/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.control.ReturnException;

public class CatchReturnAsErrorNode
extends RubyNode {
    @Node.Child
    private RubyNode body;
    private final BranchProfile retryProfile = BranchProfile.create();

    public CatchReturnAsErrorNode(RubyNode body) {
        this.body = body;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        try {
            return this.body.execute(frame);
        }
        catch (ReturnException e) {
            this.retryProfile.enter();
            throw new RaiseException(this.coreExceptions().unexpectedReturn(this));
        }
    }
}

