// Generated by psc-bundle 0.10.4
var PS = {};
(function(exports) {
    "use strict";

  exports.fromCharArray = function (a) {
    return a.join("");
  };

  exports._indexOf = function (just) {
    return function (nothing) {
      return function (x) {
        return function (s) {
          var i = s.indexOf(x);
          return i === -1 ? nothing : just(i);
        };
      };
    };
  };

  exports._lastIndexOf = function (just) {
    return function (nothing) {
      return function (x) {
        return function (s) {
          var i = s.lastIndexOf(x);
          return i === -1 ? nothing : just(i);
        };
      };
    };
  };

  exports.length = function (s) {
    return s.length;
  };

  exports.replace = function (s1) {
    return function (s2) {
      return function (s3) {
        return s3.replace(s1, s2);
      };
    };
  };

  exports.take = function (n) {
    return function (s) {
      return s.substr(0, n);
    };
  };

  exports.drop = function (n) {
    return function (s) {
      return s.substring(n);
    };
  };

  exports.count = function (p) {
    return function (s) {
      for (var i = 0; i < s.length && p(s.charAt(i)); i++); {}
      return i;
    };
  };

  exports.split = function (sep) {
    return function (s) {
      return s.split(sep);
    };
  };

  exports.toCharArray = function (s) {
    return s.split("");
  };

  exports.toLower = function (s) {
    return s.toLowerCase();
  };

  exports.toUpper = function (s) {
    return s.toUpperCase();
  };

  exports.trim = function (s) {
    return s.trim();
  };

  exports.joinWith = function (s) {
    return function (xs) {
      return xs.join(s);
    };
  };
})(PS["Data.String"] = PS["Data.String"] || {});
(function(exports) {
    "use strict";

  exports.arrayMap = function (f) {
    return function (arr) {
      var l = arr.length;
      var result = new Array(l);
      for (var i = 0; i < l; i++) {
        result[i] = f(arr[i]);
      }
      return result;
    };
  };
})(PS["Data.Functor"] = PS["Data.Functor"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";

  /**
 *  | A `Semigroupoid` is similar to a [`Category`](#category) but does not
 *  | require an identity element `id`, just composable morphisms.
 *  |
 *  | `Semigroupoid`s must satisfy the following law:
 *  |
 *  | - Associativity: `p <<< (q <<< r) = (p <<< q) <<< r`
 *  |
 *  | One example of a `Semigroupoid` is the function type constructor `(->)`,
 *  | with `(<<<)` defined as function composition.
 */  
  var Semigroupoid = function (compose) {
      this.compose = compose;
  };
  var semigroupoidFn = new Semigroupoid(function (f) {
      return function (g) {
          return function (x) {
              return f(g(x));
          };
      };
  });

  /**
 *  | A `Semigroupoid` is similar to a [`Category`](#category) but does not
 *  | require an identity element `id`, just composable morphisms.
 *  |
 *  | `Semigroupoid`s must satisfy the following law:
 *  |
 *  | - Associativity: `p <<< (q <<< r) = (p <<< q) <<< r`
 *  |
 *  | One example of a `Semigroupoid` is the function type constructor `(->)`,
 *  | with `(<<<)` defined as function composition.
 */  
  var compose = function (dict) {
      return dict.compose;
  };
  exports["Semigroupoid"] = Semigroupoid;
  exports["compose"] = compose;
  exports["semigroupoidFn"] = semigroupoidFn;
})(PS["Control.Semigroupoid"] = PS["Control.Semigroupoid"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Control_Semigroupoid = PS["Control.Semigroupoid"];        

  /**
 *  | `Category`s consist of objects and composable morphisms between them, and
 *  | as such are [`Semigroupoids`](#semigroupoid), but unlike `semigroupoids`
 *  | must have an identity element.
 *  |
 *  | Instances must satisfy the following law in addition to the
 *  | `Semigroupoid` law:
 *  |
 *  | - Identity: `id <<< p = p <<< id = p`
 */  
  var Category = function (__superclass_Control$dotSemigroupoid$dotSemigroupoid_0, id) {
      this["__superclass_Control.Semigroupoid.Semigroupoid_0"] = __superclass_Control$dotSemigroupoid$dotSemigroupoid_0;
      this.id = id;
  };

  /**
 *  | `Category`s consist of objects and composable morphisms between them, and
 *  | as such are [`Semigroupoids`](#semigroupoid), but unlike `semigroupoids`
 *  | must have an identity element.
 *  |
 *  | Instances must satisfy the following law in addition to the
 *  | `Semigroupoid` law:
 *  |
 *  | - Identity: `id <<< p = p <<< id = p`
 */  
  var id = function (dict) {
      return dict.id;
  };
  var categoryFn = new Category(function () {
      return Control_Semigroupoid.semigroupoidFn;
  }, function (x) {
      return x;
  });
  exports["Category"] = Category;
  exports["id"] = id;
  exports["categoryFn"] = categoryFn;
})(PS["Control.Category"] = PS["Control.Category"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Control_Category = PS["Control.Category"];        

  /**
 *  | The `on` function is used to change the domain of a binary operator.
 *  |
 *  | For example, we can create a function which compares two records based on the values of their `x` properties:
 *  |
 *  | ```purescript
 *  | compareX :: forall r. { x :: Number | r } -> { x :: Number | r } -> Ordering
 *  | compareX = compare `on` _.x
 *  | ```
 */  
  var on = function (f) {
      return function (g) {
          return function (x) {
              return function (y) {
                  return f(g(x))(g(y));
              };
          };
      };
  };

  /**
 *  | Flips the order of the arguments to a function of two arguments.
 *  |
 *  | ```purescript
 *  | flip const 1 2 = const 2 1 = 2
 *  | ```
 */  
  var flip = function (f) {
      return function (b) {
          return function (a) {
              return f(a)(b);
          };
      };
  };

  /**
 *  | Returns its first argument and ignores its second.
 *  |
 *  | ```purescript
 *  | const 1 "hello" = 1
 *  | ```
 */  
  var $$const = function (a) {
      return function (v) {
          return a;
      };
  };
  exports["const"] = $$const;
  exports["flip"] = flip;
  exports["on"] = on;
})(PS["Data.Function"] = PS["Data.Function"] || {});
(function(exports) {
    "use strict";

  exports.unit = {};
})(PS["Data.Unit"] = PS["Data.Unit"] || {});
(function(exports) {
    "use strict";

  exports.showIntImpl = function (n) {
    return n.toString();
  };

  exports.showStringImpl = function (s) {
    var l = s.length;
    return "\"" + s.replace(
      /[\0-\x1F\x7F"\\]/g,
      function (c, i) { // jshint ignore:line
        switch (c) {
          case "\"":
          case "\\":
            return "\\" + c;
          case "\x07": return "\\a";
          case "\b": return "\\b";
          case "\f": return "\\f";
          case "\n": return "\\n";
          case "\r": return "\\r";
          case "\t": return "\\t";
          case "\v": return "\\v";
        }
        var k = i + 1;
        var empty = k < l && s[k] >= "0" && s[k] <= "9" ? "\\&" : "";
        return "\\" + c.charCodeAt(0).toString(10) + empty;
      }
    ) + "\"";
  };

  exports.showArrayImpl = function (f) {
    return function (xs) {
      var ss = [];
      for (var i = 0, l = xs.length; i < l; i++) {
        ss[i] = f(xs[i]);
      }
      return "[" + ss.join(",") + "]";
    };
  };
})(PS["Data.Show"] = PS["Data.Show"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Data.Show"];     

  /**
 *  | The `Show` type class represents those types which can be converted into
 *  | a human-readable `String` representation.
 *  |
 *  | While not required, it is recommended that for any expression `x`, the
 *  | string `show x` be executable PureScript code which evaluates to the same
 *  | value as the expression `x`.
 */  
  var Show = function (show) {
      this.show = show;
  };
  var showString = new Show($foreign.showStringImpl);
  var showInt = new Show($foreign.showIntImpl);

  /**
 *  | The `Show` type class represents those types which can be converted into
 *  | a human-readable `String` representation.
 *  |
 *  | While not required, it is recommended that for any expression `x`, the
 *  | string `show x` be executable PureScript code which evaluates to the same
 *  | value as the expression `x`.
 */  
  var show = function (dict) {
      return dict.show;
  };
  var showArray = function (dictShow) {
      return new Show($foreign.showArrayImpl(show(dictShow)));
  };
  exports["Show"] = Show;
  exports["show"] = show;
  exports["showInt"] = showInt;
  exports["showString"] = showString;
  exports["showArray"] = showArray;
})(PS["Data.Show"] = PS["Data.Show"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Data.Unit"];
  var Data_Show = PS["Data.Show"];
  exports["unit"] = $foreign.unit;
})(PS["Data.Unit"] = PS["Data.Unit"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Data.Functor"];
  var Data_Function = PS["Data.Function"];
  var Data_Unit = PS["Data.Unit"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];        

  /**
 *  | A `Functor` is a type constructor which supports a mapping operation
 *  | `(<$>)`.
 *  |
 *  | `(<$>)` can be used to turn functions `a -> b` into functions
 *  | `f a -> f b` whose argument and return types use the type constructor `f`
 *  | to represent some computational context.
 *  |
 *  | Instances must satisfy the following laws:
 *  |
 *  | - Identity: `(<$>) id = id`
 *  | - Composition: `(<$>) (f <<< g) = (f <$>) <<< (g <$>)`
 */  
  var Functor = function (map) {
      this.map = map;
  };

  /**
 *  | A `Functor` is a type constructor which supports a mapping operation
 *  | `(<$>)`.
 *  |
 *  | `(<$>)` can be used to turn functions `a -> b` into functions
 *  | `f a -> f b` whose argument and return types use the type constructor `f`
 *  | to represent some computational context.
 *  |
 *  | Instances must satisfy the following laws:
 *  |
 *  | - Identity: `(<$>) id = id`
 *  | - Composition: `(<$>) (f <<< g) = (f <$>) <<< (g <$>)`
 */  
  var map = function (dict) {
      return dict.map;
  };

  /**
 *  | `mapFlipped` is `map` with its arguments reversed. For example:
 *  |
 *  | ```purescript
 *  | [1, 2, 3] <#> \n -> n * n
 *  | ```
 */  
  var mapFlipped = function (dictFunctor) {
      return function (fa) {
          return function (f) {
              return map(dictFunctor)(f)(fa);
          };
      };
  };

  /**
 *  | The `void` function is used to ignore the type wrapped by a
 *  | [`Functor`](#functor), replacing it with `Unit` and keeping only the type
 *  | information provided by the type constructor itself.
 *  |
 *  | `void` is often useful when using `do` notation to change the return type
 *  | of a monadic computation:
 *  |
 *  | ```purescript
 *  | main = forE 1 10 \n -> void do
 *  |   print n
 *  |   print (n * n)
 *  | ```
 */  
  var $$void = function (dictFunctor) {
      return map(dictFunctor)(Data_Function["const"](Data_Unit.unit));
  };
  var functorFn = new Functor(Control_Semigroupoid.compose(Control_Semigroupoid.semigroupoidFn));
  var functorArray = new Functor($foreign.arrayMap);
  exports["Functor"] = Functor;
  exports["map"] = map;
  exports["mapFlipped"] = mapFlipped;
  exports["void"] = $$void;
  exports["functorFn"] = functorFn;
  exports["functorArray"] = functorArray;
})(PS["Data.Functor"] = PS["Data.Functor"] || {});
(function(exports) {
    "use strict";

  exports.concatString = function (s1) {
    return function (s2) {
      return s1 + s2;
    };
  };

  exports.concatArray = function (xs) {
    return function (ys) {
      if (xs.length === 0) return ys;
      if (ys.length === 0) return xs;
      return xs.concat(ys);
    };
  };
})(PS["Data.Semigroup"] = PS["Data.Semigroup"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Data.Semigroup"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Void = PS["Data.Void"];        

  /**
 *  | The `Semigroup` type class identifies an associative operation on a type.
 *  |
 *  | Instances are required to satisfy the following law:
 *  |
 *  | - Associativity: `(x <> y) <> z = x <> (y <> z)`
 *  |
 *  | One example of a `Semigroup` is `String`, with `(<>)` defined as string
 *  | concatenation.
 */  
  var Semigroup = function (append) {
      this.append = append;
  }; 
  var semigroupString = new Semigroup($foreign.concatString);
  var semigroupArray = new Semigroup($foreign.concatArray);

  /**
 *  | The `Semigroup` type class identifies an associative operation on a type.
 *  |
 *  | Instances are required to satisfy the following law:
 *  |
 *  | - Associativity: `(x <> y) <> z = x <> (y <> z)`
 *  |
 *  | One example of a `Semigroup` is `String`, with `(<>)` defined as string
 *  | concatenation.
 */  
  var append = function (dict) {
      return dict.append;
  };
  exports["Semigroup"] = Semigroup;
  exports["append"] = append;
  exports["semigroupString"] = semigroupString;
  exports["semigroupArray"] = semigroupArray;
})(PS["Data.Semigroup"] = PS["Data.Semigroup"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Data_Functor = PS["Data.Functor"];
  var Data_Semigroup = PS["Data.Semigroup"];        

  /**
 *  | The `Alt` type class identifies an associative operation on a type
 *  | constructor.  It is similar to `Semigroup`, except that it applies to
 *  | types of kind `* -> *`, like `Array` or `List`, rather than concrete types
 *  | `String` or `Number`.
 *  |
 *  | `Alt` instances are required to satisfy the following laws:
 *  |
 *  | - Associativity: `(x <|> y) <|> z == x <|> (y <|> z)`
 *  | - Distributivity: `f <$> (x <|> y) == (f <$> x) <|> (f <$> y)`
 *  |
 *  | For example, the `Array` (`[]`) type is an instance of `Alt`, where
 *  | `(<|>)` is defined to be concatenation.
 */  
  var Alt = function (__superclass_Data$dotFunctor$dotFunctor_0, alt) {
      this["__superclass_Data.Functor.Functor_0"] = __superclass_Data$dotFunctor$dotFunctor_0;
      this.alt = alt;
  };                                                       

  /**
 *  | The `Alt` type class identifies an associative operation on a type
 *  | constructor.  It is similar to `Semigroup`, except that it applies to
 *  | types of kind `* -> *`, like `Array` or `List`, rather than concrete types
 *  | `String` or `Number`.
 *  |
 *  | `Alt` instances are required to satisfy the following laws:
 *  |
 *  | - Associativity: `(x <|> y) <|> z == x <|> (y <|> z)`
 *  | - Distributivity: `f <$> (x <|> y) == (f <$> x) <|> (f <$> y)`
 *  |
 *  | For example, the `Array` (`[]`) type is an instance of `Alt`, where
 *  | `(<|>)` is defined to be concatenation.
 */  
  var alt = function (dict) {
      return dict.alt;
  };
  exports["Alt"] = Alt;
  exports["alt"] = alt;
})(PS["Control.Alt"] = PS["Control.Alt"] || {});
(function(exports) {
    "use strict";

  exports.arrayApply = function (fs) {
    return function (xs) {
      var result = [];
      var n = 0;
      for (var i = 0, l = fs.length; i < l; i++) {
        for (var j = 0, k = xs.length; j < k; j++) {
          result[n++] = fs[i](xs[j]);
        }
      }
      return result;
    };
  };
})(PS["Control.Apply"] = PS["Control.Apply"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Control.Apply"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Function = PS["Data.Function"];
  var Control_Category = PS["Control.Category"];        

  /**
 *  | The `Apply` class provides the `(<*>)` which is used to apply a function
 *  | to an argument under a type constructor.
 *  |
 *  | `Apply` can be used to lift functions of two or more arguments to work on
 *  | values wrapped with the type constructor `f`. It might also be understood
 *  | in terms of the `lift2` function:
 *  |
 *  | ```purescript
 *  | lift2 :: forall f a b c. Apply f => (a -> b -> c) -> f a -> f b -> f c
 *  | lift2 f a b = f <$> a <*> b
 *  | ```
 *  |
 *  | `(<*>)` is recovered from `lift2` as `lift2 ($)`. That is, `(<*>)` lifts
 *  | the function application operator `($)` to arguments wrapped with the
 *  | type constructor `f`.
 *  |
 *  | Instances must satisfy the following law in addition to the `Functor`
 *  | laws:
 *  |
 *  | - Associative composition: `(<<<) <$> f <*> g <*> h = f <*> (g <*> h)`
 *  |
 *  | Formally, `Apply` represents a strong lax semi-monoidal endofunctor.
 */  
  var Apply = function (__superclass_Data$dotFunctor$dotFunctor_0, apply) {
      this["__superclass_Data.Functor.Functor_0"] = __superclass_Data$dotFunctor$dotFunctor_0;
      this.apply = apply;
  }; 
  var applyArray = new Apply(function () {
      return Data_Functor.functorArray;
  }, $foreign.arrayApply);

  /**
 *  | The `Apply` class provides the `(<*>)` which is used to apply a function
 *  | to an argument under a type constructor.
 *  |
 *  | `Apply` can be used to lift functions of two or more arguments to work on
 *  | values wrapped with the type constructor `f`. It might also be understood
 *  | in terms of the `lift2` function:
 *  |
 *  | ```purescript
 *  | lift2 :: forall f a b c. Apply f => (a -> b -> c) -> f a -> f b -> f c
 *  | lift2 f a b = f <$> a <*> b
 *  | ```
 *  |
 *  | `(<*>)` is recovered from `lift2` as `lift2 ($)`. That is, `(<*>)` lifts
 *  | the function application operator `($)` to arguments wrapped with the
 *  | type constructor `f`.
 *  |
 *  | Instances must satisfy the following law in addition to the `Functor`
 *  | laws:
 *  |
 *  | - Associative composition: `(<<<) <$> f <*> g <*> h = f <*> (g <*> h)`
 *  |
 *  | Formally, `Apply` represents a strong lax semi-monoidal endofunctor.
 */  
  var apply = function (dict) {
      return dict.apply;
  };

  /**
 *  | Combine two effectful actions, keeping only the result of the second.
 */  
  var applySecond = function (dictApply) {
      return function (a) {
          return function (b) {
              return apply(dictApply)(Data_Functor.map(dictApply["__superclass_Data.Functor.Functor_0"]())(Data_Function["const"](Control_Category.id(Control_Category.categoryFn)))(a))(b);
          };
      };
  };

  /**
 *  | Lift a function of two arguments to a function which accepts and returns
 *  | values wrapped with the type constructor `f`.
 */  
  var lift2 = function (dictApply) {
      return function (f) {
          return function (a) {
              return function (b) {
                  return apply(dictApply)(Data_Functor.map(dictApply["__superclass_Data.Functor.Functor_0"]())(f)(a))(b);
              };
          };
      };
  };
  exports["Apply"] = Apply;
  exports["apply"] = apply;
  exports["applySecond"] = applySecond;
  exports["lift2"] = lift2;
  exports["applyArray"] = applyArray;
})(PS["Control.Apply"] = PS["Control.Apply"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Control_Apply = PS["Control.Apply"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Unit = PS["Data.Unit"];        

  /**
 *  | The `Applicative` type class extends the [`Apply`](#apply) type class
 *  | with a `pure` function, which can be used to create values of type `f a`
 *  | from values of type `a`.
 *  |
 *  | Where [`Apply`](#apply) provides the ability to lift functions of two or
 *  | more arguments to functions whose arguments are wrapped using `f`, and
 *  | [`Functor`](#functor) provides the ability to lift functions of one
 *  | argument, `pure` can be seen as the function which lifts functions of
 *  | _zero_ arguments. That is, `Applicative` functors support a lifting
 *  | operation for any number of function arguments.
 *  |
 *  | Instances must satisfy the following laws in addition to the `Apply`
 *  | laws:
 *  |
 *  | - Identity: `(pure id) <*> v = v`
 *  | - Composition: `(pure <<<) <*> f <*> g <*> h = f <*> (g <*> h)`
 *  | - Homomorphism: `(pure f) <*> (pure x) = pure (f x)`
 *  | - Interchange: `u <*> (pure y) = (pure ($ y)) <*> u`
 */  
  var Applicative = function (__superclass_Control$dotApply$dotApply_0, pure) {
      this["__superclass_Control.Apply.Apply_0"] = __superclass_Control$dotApply$dotApply_0;
      this.pure = pure;
  };

  /**
 *  | The `Applicative` type class extends the [`Apply`](#apply) type class
 *  | with a `pure` function, which can be used to create values of type `f a`
 *  | from values of type `a`.
 *  |
 *  | Where [`Apply`](#apply) provides the ability to lift functions of two or
 *  | more arguments to functions whose arguments are wrapped using `f`, and
 *  | [`Functor`](#functor) provides the ability to lift functions of one
 *  | argument, `pure` can be seen as the function which lifts functions of
 *  | _zero_ arguments. That is, `Applicative` functors support a lifting
 *  | operation for any number of function arguments.
 *  |
 *  | Instances must satisfy the following laws in addition to the `Apply`
 *  | laws:
 *  |
 *  | - Identity: `(pure id) <*> v = v`
 *  | - Composition: `(pure <<<) <*> f <*> g <*> h = f <*> (g <*> h)`
 *  | - Homomorphism: `(pure f) <*> (pure x) = pure (f x)`
 *  | - Interchange: `u <*> (pure y) = (pure ($ y)) <*> u`
 */  
  var pure = function (dict) {
      return dict.pure;
  };

  /**
 *  | Perform a applicative action unless a condition is true.
 */  
  var unless = function (dictApplicative) {
      return function (v) {
          return function (v1) {
              if (!v) {
                  return v1;
              };
              if (v) {
                  return pure(dictApplicative)(Data_Unit.unit);
              };
              throw new Error("Failed pattern match at Control.Applicative line 63, column 1 - line 63, column 19: " + [ v.constructor.name, v1.constructor.name ]);
          };
      };
  };

  /**
 *  | Perform a applicative action when a condition is true.
 */  
  var when = function (dictApplicative) {
      return function (v) {
          return function (v1) {
              if (v) {
                  return v1;
              };
              if (!v) {
                  return pure(dictApplicative)(Data_Unit.unit);
              };
              throw new Error("Failed pattern match at Control.Applicative line 58, column 1 - line 58, column 16: " + [ v.constructor.name, v1.constructor.name ]);
          };
      };
  };

  /**
 *  | `liftA1` provides a default implementation of `(<$>)` for any
 *  | [`Applicative`](#applicative) functor, without using `(<$>)` as provided
 *  | by the [`Functor`](#functor)-[`Applicative`](#applicative) superclass
 *  | relationship.
 *  |
 *  | `liftA1` can therefore be used to write [`Functor`](#functor) instances
 *  | as follows:
 *  |
 *  | ```purescript
 *  | instance functorF :: Functor F where
 *  |   map = liftA1
 *  | ```
 */  
  var liftA1 = function (dictApplicative) {
      return function (f) {
          return function (a) {
              return Control_Apply.apply(dictApplicative["__superclass_Control.Apply.Apply_0"]())(pure(dictApplicative)(f))(a);
          };
      };
  };
  exports["Applicative"] = Applicative;
  exports["liftA1"] = liftA1;
  exports["pure"] = pure;
  exports["unless"] = unless;
  exports["when"] = when;
})(PS["Control.Applicative"] = PS["Control.Applicative"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Control_Alt = PS["Control.Alt"];
  var Data_Functor = PS["Data.Functor"];        

  /**
 *  | The `Plus` type class extends the `Alt` type class with a value that
 *  | should be the left and right identity for `(<|>)`.
 *  |
 *  | It is similar to `Monoid`, except that it applies to types of
 *  | kind `* -> *`, like `Array` or `List`, rather than concrete types like
 *  | `String` or `Number`.
 *  |
 *  | `Plus` instances should satisfy the following laws:
 *  |
 *  | - Left identity: `empty <|> x == x`
 *  | - Right identity: `x <|> empty == x`
 *  | - Annihilation: `f <$> empty == empty`
 */  
  var Plus = function (__superclass_Control$dotAlt$dotAlt_0, empty) {
      this["__superclass_Control.Alt.Alt_0"] = __superclass_Control$dotAlt$dotAlt_0;
      this.empty = empty;
  };       

  /**
 *  | The `Plus` type class extends the `Alt` type class with a value that
 *  | should be the left and right identity for `(<|>)`.
 *  |
 *  | It is similar to `Monoid`, except that it applies to types of
 *  | kind `* -> *`, like `Array` or `List`, rather than concrete types like
 *  | `String` or `Number`.
 *  |
 *  | `Plus` instances should satisfy the following laws:
 *  |
 *  | - Left identity: `empty <|> x == x`
 *  | - Right identity: `x <|> empty == x`
 *  | - Annihilation: `f <$> empty == empty`
 */  
  var empty = function (dict) {
      return dict.empty;
  };
  exports["Plus"] = Plus;
  exports["empty"] = empty;
})(PS["Control.Plus"] = PS["Control.Plus"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Control_Alt = PS["Control.Alt"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Plus = PS["Control.Plus"];
  var Data_Functor = PS["Data.Functor"];        

  /**
 *  | The `Alternative` type class has no members of its own; it just specifies
 *  | that the type constructor has both `Applicative` and `Plus` instances.
 *  |
 *  | Types which have `Alternative` instances should also satisfy the following
 *  | laws:
 *  |
 *  | - Distributivity: `(f <|> g) <*> x == (f <*> x) <|> (g <*> x)`
 *  | - Annihilation: `empty <*> f = empty`
 */  
  var Alternative = function (__superclass_Control$dotApplicative$dotApplicative_0, __superclass_Control$dotPlus$dotPlus_1) {
      this["__superclass_Control.Applicative.Applicative_0"] = __superclass_Control$dotApplicative$dotApplicative_0;
      this["__superclass_Control.Plus.Plus_1"] = __superclass_Control$dotPlus$dotPlus_1;
  };
  exports["Alternative"] = Alternative;
})(PS["Control.Alternative"] = PS["Control.Alternative"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Control_Category = PS["Control.Category"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Semigroup = PS["Data.Semigroup"];        

  /**
 *  | The `Extend` class defines the extension operator `(<<=)`
 *  | which extends a local context-dependent computation to
 *  | a global computation.
 *  |
 *  | `Extend` is the dual of `Bind`, and `(<<=)` is the dual of
 *  | `(>>=)`.
 *  |
 *  | Laws:
 *  |
 *  | - Associativity: `extend f <<< extend g = extend (f <<< extend g)`
 */  
  var Extend = function (__superclass_Data$dotFunctor$dotFunctor_0, extend) {
      this["__superclass_Data.Functor.Functor_0"] = __superclass_Data$dotFunctor$dotFunctor_0;
      this.extend = extend;
  };

  /**
 *  | The `Extend` class defines the extension operator `(<<=)`
 *  | which extends a local context-dependent computation to
 *  | a global computation.
 *  |
 *  | `Extend` is the dual of `Bind`, and `(<<=)` is the dual of
 *  | `(>>=)`.
 *  |
 *  | Laws:
 *  |
 *  | - Associativity: `extend f <<< extend g = extend (f <<< extend g)`
 */  
  var extend = function (dict) {
      return dict.extend;
  };
  exports["Extend"] = Extend;
  exports["extend"] = extend;
})(PS["Control.Extend"] = PS["Control.Extend"] || {});
(function(exports) {
    "use strict";

  exports.arrayBind = function (arr) {
    return function (f) {
      var result = [];
      for (var i = 0, l = arr.length; i < l; i++) {
        Array.prototype.push.apply(result, f(arr[i]));
      }
      return result;
    };
  };
})(PS["Control.Bind"] = PS["Control.Bind"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Control.Bind"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Category = PS["Control.Category"];
  var Data_Function = PS["Data.Function"];
  var Data_Functor = PS["Data.Functor"];        

  /**
 *  | The `Bind` type class extends the [`Apply`](#apply) type class with a
 *  | "bind" operation `(>>=)` which composes computations in sequence, using
 *  | the return value of one computation to determine the next computation.
 *  |
 *  | The `>>=` operator can also be expressed using `do` notation, as follows:
 *  |
 *  | ```purescript
 *  | x >>= f = do y <- x
 *  |              f y
 *  | ```
 *  |
 *  | where the function argument of `f` is given the name `y`.
 *  |
 *  | Instances must satisfy the following law in addition to the `Apply`
 *  | laws:
 *  |
 *  | - Associativity: `(x >>= f) >>= g = x >>= (\k -> f k >>= g)`
 *  |
 *  | Associativity tells us that we can regroup operations which use `do`
 *  | notation so that we can unambiguously write, for example:
 *  |
 *  | ```purescript
 *  | do x <- m1
 *  |    y <- m2 x
 *  |    m3 x y
 *  | ```
 */  
  var Bind = function (__superclass_Control$dotApply$dotApply_0, bind) {
      this["__superclass_Control.Apply.Apply_0"] = __superclass_Control$dotApply$dotApply_0;
      this.bind = bind;
  }; 
  var bindArray = new Bind(function () {
      return Control_Apply.applyArray;
  }, $foreign.arrayBind);

  /**
 *  | The `Bind` type class extends the [`Apply`](#apply) type class with a
 *  | "bind" operation `(>>=)` which composes computations in sequence, using
 *  | the return value of one computation to determine the next computation.
 *  |
 *  | The `>>=` operator can also be expressed using `do` notation, as follows:
 *  |
 *  | ```purescript
 *  | x >>= f = do y <- x
 *  |              f y
 *  | ```
 *  |
 *  | where the function argument of `f` is given the name `y`.
 *  |
 *  | Instances must satisfy the following law in addition to the `Apply`
 *  | laws:
 *  |
 *  | - Associativity: `(x >>= f) >>= g = x >>= (\k -> f k >>= g)`
 *  |
 *  | Associativity tells us that we can regroup operations which use `do`
 *  | notation so that we can unambiguously write, for example:
 *  |
 *  | ```purescript
 *  | do x <- m1
 *  |    y <- m2 x
 *  |    m3 x y
 *  | ```
 */  
  var bind = function (dict) {
      return dict.bind;
  };

  /**
 *  | `bindFlipped` is `bind` with its arguments reversed. For example:
 *  |
 *  | ```purescript
 *  | print =<< random
 *  | ```
 */  
  var bindFlipped = function (dictBind) {
      return Data_Function.flip(bind(dictBind));
  };

  /**
 *  | Forwards Kleisli composition.
 *  |
 *  | For example:
 *  |
 *  | ```purescript
 *  | import Data.Array (head, tail)
 *  |
 *  | third = tail >=> tail >=> head
 *  | ```
 */  
  var composeKleisli = function (dictBind) {
      return function (f) {
          return function (g) {
              return function (a) {
                  return bind(dictBind)(f(a))(g);
              };
          };
      };
  };
  exports["Bind"] = Bind;
  exports["bind"] = bind;
  exports["bindFlipped"] = bindFlipped;
  exports["composeKleisli"] = composeKleisli;
  exports["bindArray"] = bindArray;
})(PS["Control.Bind"] = PS["Control.Bind"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Bind = PS["Control.Bind"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Unit = PS["Data.Unit"];        

  /**
 *  | The `Monad` type class combines the operations of the `Bind` and
 *  | `Applicative` type classes. Therefore, `Monad` instances represent type
 *  | constructors which support sequential composition, and also lifting of
 *  | functions of arbitrary arity.
 *  |
 *  | Instances must satisfy the following laws in addition to the
 *  | `Applicative` and `Bind` laws:
 *  |
 *  | - Left Identity: `pure x >>= f = f x`
 *  | - Right Identity: `x >>= pure = x`
 */  
  var Monad = function (__superclass_Control$dotApplicative$dotApplicative_0, __superclass_Control$dotBind$dotBind_1) {
      this["__superclass_Control.Applicative.Applicative_0"] = __superclass_Control$dotApplicative$dotApplicative_0;
      this["__superclass_Control.Bind.Bind_1"] = __superclass_Control$dotBind$dotBind_1;
  };

  /**
 *  | `ap` provides a default implementation of `(<*>)` for any
 *  | [`Monad`](#monad), without using `(<*>)` as provided by the
 *  | [`Apply`](#apply)-[`Monad`](#monad) superclass relationship.
 *  |
 *  | `ap` can therefore be used to write [`Apply`](#apply) instances as
 *  | follows:
 *  |
 *  | ```purescript
 *  | instance applyF :: Apply F where
 *  |   apply = ap
 *  | ```
 */  
  var ap = function (dictMonad) {
      return function (f) {
          return function (a) {
              return Control_Bind.bind(dictMonad["__superclass_Control.Bind.Bind_1"]())(f)(function (v) {
                  return Control_Bind.bind(dictMonad["__superclass_Control.Bind.Bind_1"]())(a)(function (v1) {
                      return Control_Applicative.pure(dictMonad["__superclass_Control.Applicative.Applicative_0"]())(v(v1));
                  });
              });
          };
      };
  };
  exports["Monad"] = Monad;
  exports["ap"] = ap;
})(PS["Control.Monad"] = PS["Control.Monad"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Control_Alt = PS["Control.Alt"];
  var Control_Alternative = PS["Control.Alternative"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad = PS["Control.Monad"];
  var Control_Plus = PS["Control.Plus"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Unit = PS["Data.Unit"];        

  /**
 *  | The `MonadZero` type class has no members of its own; it just specifies
 *  | that the type has both `Monad` and `Alternative` instances.
 *  |
 *  | Types which have `MonadZero` instances should also satisfy the following
 *  | laws:
 *  |
 *  | - Annihilation: `empty >>= f = empty`
 */  
  var MonadZero = function (__superclass_Control$dotAlternative$dotAlternative_1, __superclass_Control$dotMonad$dotMonad_0) {
      this["__superclass_Control.Alternative.Alternative_1"] = __superclass_Control$dotAlternative$dotAlternative_1;
      this["__superclass_Control.Monad.Monad_0"] = __superclass_Control$dotMonad$dotMonad_0;
  }; 

  /**
 *  | Fail using `Plus` if a condition does not hold, or
 *  | succeed using `Monad` if it does.
 *  |
 *  | For example:
 *  |
 *  | ```purescript
 *  | import Data.Array
 *  |
 *  | factors :: Number -> Array Number
 *  | factors n = do
 *  |   a <- 1 .. n
 *  |   b <- 1 .. a
 *  |   guard $ a * b == n
 *  |   pure a
 *  | ```
 */  
  var guard = function (dictMonadZero) {
      return function (v) {
          if (v) {
              return Control_Applicative.pure((dictMonadZero["__superclass_Control.Alternative.Alternative_1"]())["__superclass_Control.Applicative.Applicative_0"]())(Data_Unit.unit);
          };
          if (!v) {
              return Control_Plus.empty((dictMonadZero["__superclass_Control.Alternative.Alternative_1"]())["__superclass_Control.Plus.Plus_1"]());
          };
          throw new Error("Failed pattern match at Control.MonadZero line 52, column 1 - line 52, column 23: " + [ v.constructor.name ]);
      };
  };
  exports["MonadZero"] = MonadZero;
  exports["guard"] = guard;
})(PS["Control.MonadZero"] = PS["Control.MonadZero"] || {});
(function(exports) {
    "use strict";

  exports.ordArrayImpl = function (f) {
    return function (xs) {
      return function (ys) {
        var i = 0;
        var xlen = xs.length;
        var ylen = ys.length;
        while (i < xlen && i < ylen) {
          var x = xs[i];
          var y = ys[i];
          var o = f(x)(y);
          if (o !== 0) {
            return o;
          }
          i++;
        }
        if (xlen === ylen) {
          return 0;
        } else if (xlen > ylen) {
          return -1;
        } else {
          return 1;
        }
      };
    };
  };
})(PS["Data.Ord"] = PS["Data.Ord"] || {});
(function(exports) {
    "use strict";

  exports.refEq = function (r1) {
    return function (r2) {
      return r1 === r2;
    };
  };

  exports.eqArrayImpl = function (f) {
    return function (xs) {
      return function (ys) {
        if (xs.length !== ys.length) return false;
        for (var i = 0; i < xs.length; i++) {
          if (!f(xs[i])(ys[i])) return false;
        }
        return true;
      };
    };
  };
})(PS["Data.Eq"] = PS["Data.Eq"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Data.Eq"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Void = PS["Data.Void"];        

  /**
 *  | The `Eq` type class represents types which support decidable equality.
 *  |
 *  | `Eq` instances should satisfy the following laws:
 *  |
 *  | - Reflexivity: `x == x = true`
 *  | - Symmetry: `x == y = y == x`
 *  | - Transitivity: if `x == y` and `y == z` then `x == z`
 *  |
 *  | **Note:** The `Number` type is not an entirely law abiding member of this
 *  | class due to the presence of `NaN`, since `NaN /= NaN`. Additionally,
 *  | computing with `Number` can result in a loss of precision, so sometimes
 *  | values that should be equivalent are not.
 */  
  var Eq = function (eq) {
      this.eq = eq;
  }; 
  var eqString = new Eq($foreign.refEq);
  var eqNumber = new Eq($foreign.refEq);
  var eqInt = new Eq($foreign.refEq);
  var eqChar = new Eq($foreign.refEq);   

  /**
 *  | The `Eq` type class represents types which support decidable equality.
 *  |
 *  | `Eq` instances should satisfy the following laws:
 *  |
 *  | - Reflexivity: `x == x = true`
 *  | - Symmetry: `x == y = y == x`
 *  | - Transitivity: if `x == y` and `y == z` then `x == z`
 *  |
 *  | **Note:** The `Number` type is not an entirely law abiding member of this
 *  | class due to the presence of `NaN`, since `NaN /= NaN`. Additionally,
 *  | computing with `Number` can result in a loss of precision, so sometimes
 *  | values that should be equivalent are not.
 */  
  var eq = function (dict) {
      return dict.eq;
  };
  var eqArray = function (dictEq) {
      return new Eq($foreign.eqArrayImpl(eq(dictEq)));
  };
  exports["Eq"] = Eq;
  exports["eq"] = eq;
  exports["eqInt"] = eqInt;
  exports["eqNumber"] = eqNumber;
  exports["eqChar"] = eqChar;
  exports["eqString"] = eqString;
  exports["eqArray"] = eqArray;
})(PS["Data.Eq"] = PS["Data.Eq"] || {});
(function(exports) {
    "use strict";

  exports.unsafeCompareImpl = function (lt) {
    return function (eq) {
      return function (gt) {
        return function (x) {
          return function (y) {
            return x < y ? lt : x === y ? eq : gt;
          };
        };
      };
    };
  };
})(PS["Data.Ord.Unsafe"] = PS["Data.Ord.Unsafe"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Data_Eq = PS["Data.Eq"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Show = PS["Data.Show"];        

  /**
 *  | The `Ordering` data type represents the three possible outcomes of
 *  | comparing two values:
 *  |
 *  | `LT` - The first value is _less than_ the second.
 *  | `GT` - The first value is _greater than_ the second.
 *  | `EQ` - The first value is _equal to_ the second.
 */  
  var LT = (function () {
      function LT() {

      };
      LT.value = new LT();
      return LT;
  })();

  /**
 *  | The `Ordering` data type represents the three possible outcomes of
 *  | comparing two values:
 *  |
 *  | `LT` - The first value is _less than_ the second.
 *  | `GT` - The first value is _greater than_ the second.
 *  | `EQ` - The first value is _equal to_ the second.
 */  
  var GT = (function () {
      function GT() {

      };
      GT.value = new GT();
      return GT;
  })();

  /**
 *  | The `Ordering` data type represents the three possible outcomes of
 *  | comparing two values:
 *  |
 *  | `LT` - The first value is _less than_ the second.
 *  | `GT` - The first value is _greater than_ the second.
 *  | `EQ` - The first value is _equal to_ the second.
 */  
  var EQ = (function () {
      function EQ() {

      };
      EQ.value = new EQ();
      return EQ;
  })();
  var semigroupOrdering = new Data_Semigroup.Semigroup(function (v) {
      return function (v1) {
          if (v instanceof LT) {
              return LT.value;
          };
          if (v instanceof GT) {
              return GT.value;
          };
          if (v instanceof EQ) {
              return v1;
          };
          throw new Error("Failed pattern match at Data.Ordering line 22, column 3 - line 22, column 19: " + [ v.constructor.name, v1.constructor.name ]);
      };
  });
  var eqOrdering = new Data_Eq.Eq(function (v) {
      return function (v1) {
          if (v instanceof LT && v1 instanceof LT) {
              return true;
          };
          if (v instanceof GT && v1 instanceof GT) {
              return true;
          };
          if (v instanceof EQ && v1 instanceof EQ) {
              return true;
          };
          return false;
      };
  });
  exports["LT"] = LT;
  exports["GT"] = GT;
  exports["EQ"] = EQ;
  exports["eqOrdering"] = eqOrdering;
  exports["semigroupOrdering"] = semigroupOrdering;
})(PS["Data.Ordering"] = PS["Data.Ordering"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Data.Ord.Unsafe"];
  var Data_Ordering = PS["Data.Ordering"];        
  var unsafeCompare = $foreign.unsafeCompareImpl(Data_Ordering.LT.value)(Data_Ordering.EQ.value)(Data_Ordering.GT.value);
  exports["unsafeCompare"] = unsafeCompare;
})(PS["Data.Ord.Unsafe"] = PS["Data.Ord.Unsafe"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Data.Semiring"];
  var Data_Unit = PS["Data.Unit"];        

  /**
 *  | The `Semiring` class is for types that support an addition and
 *  | multiplication operation.
 *  |
 *  | Instances must satisfy the following laws:
 *  |
 *  | - Commutative monoid under addition:
 *  |   - Associativity: `(a + b) + c = a + (b + c)`
 *  |   - Identity: `zero + a = a + zero = a`
 *  |   - Commutative: `a + b = b + a`
 *  | - Monoid under multiplication:
 *  |   - Associativity: `(a * b) * c = a * (b * c)`
 *  |   - Identity: `one * a = a * one = a`
 *  | - Multiplication distributes over addition:
 *  |   - Left distributivity: `a * (b + c) = (a * b) + (a * c)`
 *  |   - Right distributivity: `(a + b) * c = (a * c) + (b * c)`
 *  | - Annihilation: `zero * a = a * zero = zero`
 *  |
 *  | **Note:** The `Number` and `Int` types are not fully law abiding
 *  | members of this class hierarchy due to the potential for arithmetic
 *  | overflows, and in the case of `Number`, the presence of `NaN` and
 *  | `Infinity` values. The behaviour is unspecified in these cases.
 */  
  var Semiring = function (add, mul, one, zero) {
      this.add = add;
      this.mul = mul;
      this.one = one;
      this.zero = zero;
  };

  /**
 *  | The `Semiring` class is for types that support an addition and
 *  | multiplication operation.
 *  |
 *  | Instances must satisfy the following laws:
 *  |
 *  | - Commutative monoid under addition:
 *  |   - Associativity: `(a + b) + c = a + (b + c)`
 *  |   - Identity: `zero + a = a + zero = a`
 *  |   - Commutative: `a + b = b + a`
 *  | - Monoid under multiplication:
 *  |   - Associativity: `(a * b) * c = a * (b * c)`
 *  |   - Identity: `one * a = a * one = a`
 *  | - Multiplication distributes over addition:
 *  |   - Left distributivity: `a * (b + c) = (a * b) + (a * c)`
 *  |   - Right distributivity: `(a + b) * c = (a * c) + (b * c)`
 *  | - Annihilation: `zero * a = a * zero = zero`
 *  |
 *  | **Note:** The `Number` and `Int` types are not fully law abiding
 *  | members of this class hierarchy due to the potential for arithmetic
 *  | overflows, and in the case of `Number`, the presence of `NaN` and
 *  | `Infinity` values. The behaviour is unspecified in these cases.
 */  
  var zero = function (dict) {
      return dict.zero;
  };                                                                     

  /**
 *  | The `Semiring` class is for types that support an addition and
 *  | multiplication operation.
 *  |
 *  | Instances must satisfy the following laws:
 *  |
 *  | - Commutative monoid under addition:
 *  |   - Associativity: `(a + b) + c = a + (b + c)`
 *  |   - Identity: `zero + a = a + zero = a`
 *  |   - Commutative: `a + b = b + a`
 *  | - Monoid under multiplication:
 *  |   - Associativity: `(a * b) * c = a * (b * c)`
 *  |   - Identity: `one * a = a * one = a`
 *  | - Multiplication distributes over addition:
 *  |   - Left distributivity: `a * (b + c) = (a * b) + (a * c)`
 *  |   - Right distributivity: `(a + b) * c = (a * c) + (b * c)`
 *  | - Annihilation: `zero * a = a * zero = zero`
 *  |
 *  | **Note:** The `Number` and `Int` types are not fully law abiding
 *  | members of this class hierarchy due to the potential for arithmetic
 *  | overflows, and in the case of `Number`, the presence of `NaN` and
 *  | `Infinity` values. The behaviour is unspecified in these cases.
 */  
  var one = function (dict) {
      return dict.one;
  };

  /**
 *  | The `Semiring` class is for types that support an addition and
 *  | multiplication operation.
 *  |
 *  | Instances must satisfy the following laws:
 *  |
 *  | - Commutative monoid under addition:
 *  |   - Associativity: `(a + b) + c = a + (b + c)`
 *  |   - Identity: `zero + a = a + zero = a`
 *  |   - Commutative: `a + b = b + a`
 *  | - Monoid under multiplication:
 *  |   - Associativity: `(a * b) * c = a * (b * c)`
 *  |   - Identity: `one * a = a * one = a`
 *  | - Multiplication distributes over addition:
 *  |   - Left distributivity: `a * (b + c) = (a * b) + (a * c)`
 *  |   - Right distributivity: `(a + b) * c = (a * c) + (b * c)`
 *  | - Annihilation: `zero * a = a * zero = zero`
 *  |
 *  | **Note:** The `Number` and `Int` types are not fully law abiding
 *  | members of this class hierarchy due to the potential for arithmetic
 *  | overflows, and in the case of `Number`, the presence of `NaN` and
 *  | `Infinity` values. The behaviour is unspecified in these cases.
 */  
  var mul = function (dict) {
      return dict.mul;
  };

  /**
 *  | The `Semiring` class is for types that support an addition and
 *  | multiplication operation.
 *  |
 *  | Instances must satisfy the following laws:
 *  |
 *  | - Commutative monoid under addition:
 *  |   - Associativity: `(a + b) + c = a + (b + c)`
 *  |   - Identity: `zero + a = a + zero = a`
 *  |   - Commutative: `a + b = b + a`
 *  | - Monoid under multiplication:
 *  |   - Associativity: `(a * b) * c = a * (b * c)`
 *  |   - Identity: `one * a = a * one = a`
 *  | - Multiplication distributes over addition:
 *  |   - Left distributivity: `a * (b + c) = (a * b) + (a * c)`
 *  |   - Right distributivity: `(a + b) * c = (a * c) + (b * c)`
 *  | - Annihilation: `zero * a = a * zero = zero`
 *  |
 *  | **Note:** The `Number` and `Int` types are not fully law abiding
 *  | members of this class hierarchy due to the potential for arithmetic
 *  | overflows, and in the case of `Number`, the presence of `NaN` and
 *  | `Infinity` values. The behaviour is unspecified in these cases.
 */  
  var add = function (dict) {
      return dict.add;
  };
  exports["Semiring"] = Semiring;
  exports["add"] = add;
  exports["mul"] = mul;
  exports["one"] = one;
  exports["zero"] = zero;
})(PS["Data.Semiring"] = PS["Data.Semiring"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Data.Ord"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Function = PS["Data.Function"];
  var Data_Ord_Unsafe = PS["Data.Ord.Unsafe"];
  var Data_Ordering = PS["Data.Ordering"];
  var Data_Ring = PS["Data.Ring"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Void = PS["Data.Void"];
  var Data_Semiring = PS["Data.Semiring"];        

  /**
 *  | The `Ord` type class represents types which support comparisons with a
 *  | _total order_.
 *  |
 *  | `Ord` instances should satisfy the laws of total orderings:
 *  |
 *  | - Reflexivity: `a <= a`
 *  | - Antisymmetry: if `a <= b` and `b <= a` then `a = b`
 *  | - Transitivity: if `a <= b` and `b <= c` then `a <= c`
 */  
  var Ord = function (__superclass_Data$dotEq$dotEq_0, compare) {
      this["__superclass_Data.Eq.Eq_0"] = __superclass_Data$dotEq$dotEq_0;
      this.compare = compare;
  }; 
  var ordString = new Ord(function () {
      return Data_Eq.eqString;
  }, Data_Ord_Unsafe.unsafeCompare);
  var ordNumber = new Ord(function () {
      return Data_Eq.eqNumber;
  }, Data_Ord_Unsafe.unsafeCompare);
  var ordInt = new Ord(function () {
      return Data_Eq.eqInt;
  }, Data_Ord_Unsafe.unsafeCompare);
  var ordChar = new Ord(function () {
      return Data_Eq.eqChar;
  }, Data_Ord_Unsafe.unsafeCompare);

  /**
 *  | The `Ord` type class represents types which support comparisons with a
 *  | _total order_.
 *  |
 *  | `Ord` instances should satisfy the laws of total orderings:
 *  |
 *  | - Reflexivity: `a <= a`
 *  | - Antisymmetry: if `a <= b` and `b <= a` then `a = b`
 *  | - Transitivity: if `a <= b` and `b <= c` then `a <= c`
 */  
  var compare = function (dict) {
      return dict.compare;
  };

  /**
 *  | Test whether one value is _strictly greater than_ another.
 */  
  var greaterThan = function (dictOrd) {
      return function (a1) {
          return function (a2) {
              var $22 = compare(dictOrd)(a1)(a2);
              if ($22 instanceof Data_Ordering.GT) {
                  return true;
              };
              return false;
          };
      };
  };

  /**
 *  | Test whether one value is _strictly less than_ another.
 */  
  var lessThan = function (dictOrd) {
      return function (a1) {
          return function (a2) {
              var $25 = compare(dictOrd)(a1)(a2);
              if ($25 instanceof Data_Ordering.LT) {
                  return true;
              };
              return false;
          };
      };
  };
  var ordArray = function (dictOrd) {
      return new Ord(function () {
          return Data_Eq.eqArray(dictOrd["__superclass_Data.Eq.Eq_0"]());
      }, (function () {
          var toDelta = function (x) {
              return function (y) {
                  var $29 = compare(dictOrd)(x)(y);
                  if ($29 instanceof Data_Ordering.EQ) {
                      return 0;
                  };
                  if ($29 instanceof Data_Ordering.LT) {
                      return 1;
                  };
                  if ($29 instanceof Data_Ordering.GT) {
                      return -1;
                  };
                  throw new Error("Failed pattern match at Data.Ord line 60, column 7 - line 65, column 1: " + [ $29.constructor.name ]);
              };
          };
          return function (xs) {
              return function (ys) {
                  return compare(ordInt)(0)($foreign.ordArrayImpl(toDelta)(xs)(ys));
              };
          };
      })());
  };

  /**
 *  | Test whether a value is between a minimum and a maximum (inclusive).
 *  | For example:
 *  |
 *  | ``` purescript
 *  | let f = between 0 10
 *  | f 0    == true
 *  | f (-5) == false
 *  | f 5    == true
 *  | f 10   == true
 *  | f 15   == false
 *  | ```
 */  
  var between = function (dictOrd) {
      return function (low) {
          return function (hi) {
              return function (x) {
                  if (lessThan(dictOrd)(x)(low)) {
                      return false;
                  };
                  if (greaterThan(dictOrd)(x)(hi)) {
                      return false;
                  };
                  if (true) {
                      return true;
                  };
                  throw new Error("Failed pattern match at Data.Ord line 150, column 1 - line 153, column 16: " + [ low.constructor.name, hi.constructor.name, x.constructor.name ]);
              };
          };
      };
  };
  exports["Ord"] = Ord;
  exports["between"] = between;
  exports["compare"] = compare;
  exports["greaterThan"] = greaterThan;
  exports["lessThan"] = lessThan;
  exports["ordInt"] = ordInt;
  exports["ordNumber"] = ordNumber;
  exports["ordString"] = ordString;
  exports["ordChar"] = ordChar;
  exports["ordArray"] = ordArray;
})(PS["Data.Ord"] = PS["Data.Ord"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";

  /**
 *  | An alias for `true`, which can be useful in guard clauses:
 *  |
 *  | ```purescript
 *  | max x y | x >= y    = x
 *  |         | otherwise = y
 *  | ```
 */  
  var otherwise = true;
  exports["otherwise"] = otherwise;
})(PS["Data.Boolean"] = PS["Data.Boolean"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Function = PS["Data.Function"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Eq = PS["Data.Eq"];
  var Data_EuclideanRing = PS["Data.EuclideanRing"];
  var Data_Boolean = PS["Data.Boolean"];        

  /**
 *  | A `Monoid` is a `Semigroup` with a value `mempty`, which is both a
 *  | left and right unit for the associative operation `<>`:
 *  |
 *  | ```text
 *  | forall x. mempty <> x = x <> mempty = x
 *  | ```
 *  |
 *  | `Monoid`s are commonly used as the result of fold operations, where
 *  | `<>` is used to combine individual results, and `mempty` gives the result
 *  | of folding an empty collection of elements.
 */  
  var Monoid = function (__superclass_Data$dotSemigroup$dotSemigroup_0, mempty) {
      this["__superclass_Data.Semigroup.Semigroup_0"] = __superclass_Data$dotSemigroup$dotSemigroup_0;
      this.mempty = mempty;
  };                 
  var monoidString = new Monoid(function () {
      return Data_Semigroup.semigroupString;
  }, "");
  var monoidArray = new Monoid(function () {
      return Data_Semigroup.semigroupArray;
  }, [  ]);

  /**
 *  | A `Monoid` is a `Semigroup` with a value `mempty`, which is both a
 *  | left and right unit for the associative operation `<>`:
 *  |
 *  | ```text
 *  | forall x. mempty <> x = x <> mempty = x
 *  | ```
 *  |
 *  | `Monoid`s are commonly used as the result of fold operations, where
 *  | `<>` is used to combine individual results, and `mempty` gives the result
 *  | of folding an empty collection of elements.
 */  
  var mempty = function (dict) {
      return dict.mempty;
  };
  exports["Monoid"] = Monoid;
  exports["mempty"] = mempty;
  exports["monoidString"] = monoidString;
  exports["monoidArray"] = monoidArray;
})(PS["Data.Monoid"] = PS["Data.Monoid"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Data.Bounded"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Ordering = PS["Data.Ordering"];        

  /**
 *  | The `Bounded` type class represents totally ordered types that have an
 *  | upper and lower boundary.
 *  |
 *  | Instances should satisfy the following law in addition to the `Ord` laws:
 *  |
 *  | - Bounded: `bottom <= a <= top`
 */  
  var Bounded = function (__superclass_Data$dotOrd$dotOrd_0, bottom, top) {
      this["__superclass_Data.Ord.Ord_0"] = __superclass_Data$dotOrd$dotOrd_0;
      this.bottom = bottom;
      this.top = top;
  };

  /**
 *  | The `Bounded` type class represents totally ordered types that have an
 *  | upper and lower boundary.
 *  |
 *  | Instances should satisfy the following law in addition to the `Ord` laws:
 *  |
 *  | - Bounded: `bottom <= a <= top`
 */  
  var top = function (dict) {
      return dict.top;
  };              

  /**
 *  | The `Bounded` type class represents totally ordered types that have an
 *  | upper and lower boundary.
 *  |
 *  | Instances should satisfy the following law in addition to the `Ord` laws:
 *  |
 *  | - Bounded: `bottom <= a <= top`
 */  
  var bottom = function (dict) {
      return dict.bottom;
  };
  exports["Bounded"] = Bounded;
  exports["bottom"] = bottom;
  exports["top"] = top;
})(PS["Data.Bounded"] = PS["Data.Bounded"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Alternative = PS["Control.Alternative"];
  var Control_Extend = PS["Control.Extend"];
  var Control_MonadZero = PS["Control.MonadZero"];
  var Control_Plus = PS["Control.Plus"];
  var Data_Functor_Invariant = PS["Data.Functor.Invariant"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad = PS["Control.Monad"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Ordering = PS["Data.Ordering"];
  var Data_Bounded = PS["Data.Bounded"];
  var Data_Show = PS["Data.Show"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Function = PS["Data.Function"];
  var Control_Category = PS["Control.Category"];        

  /**
 *  | The `Maybe` type is used to represent optional values and can be seen as
 *  | something like a type-safe `null`, where `Nothing` is `null` and `Just x`
 *  | is the non-null value `x`.
 */  
  var Nothing = (function () {
      function Nothing() {

      };
      Nothing.value = new Nothing();
      return Nothing;
  })();

  /**
 *  | The `Maybe` type is used to represent optional values and can be seen as
 *  | something like a type-safe `null`, where `Nothing` is `null` and `Just x`
 *  | is the non-null value `x`.
 */  
  var Just = (function () {
      function Just(value0) {
          this.value0 = value0;
      };
      Just.create = function (value0) {
          return new Just(value0);
      };
      return Just;
  })();

  /**
 *  | The `Show` instance allows `Maybe` values to be rendered as a string with
 *  | `show` whenever there is an `Show` instance for the type the `Maybe`
 *  | contains.
 */  
  var showMaybe = function (dictShow) {
      return new Data_Show.Show(function (v) {
          if (v instanceof Just) {
              return "(Just " + (Data_Show.show(dictShow)(v.value0) + ")");
          };
          if (v instanceof Nothing) {
              return "Nothing";
          };
          throw new Error("Failed pattern match at Data.Maybe line 202, column 3 - line 203, column 3: " + [ v.constructor.name ]);
      });
  };

  /**
 *  | Takes a default value, a function, and a `Maybe` value. If the `Maybe`
 *  | value is `Nothing` the default value is returned, otherwise the function
 *  | is applied to the value inside the `Just` and the result is returned.
 *  |
 *  | ``` purescript
 *  | maybe x f Nothing == x
 *  | maybe x f (Just y) == f y
 *  | ```
 */  
  var maybe = function (v) {
      return function (v1) {
          return function (v2) {
              if (v2 instanceof Nothing) {
                  return v;
              };
              if (v2 instanceof Just) {
                  return v1(v2.value0);
              };
              throw new Error("Failed pattern match at Data.Maybe line 214, column 1 - line 214, column 22: " + [ v.constructor.name, v1.constructor.name, v2.constructor.name ]);
          };
      };
  };

  /**
 *  | Returns `true` when the `Maybe` value is `Nothing`.
 */  
  var isNothing = maybe(true)(Data_Function["const"](false));

  /**
 *  | Returns `true` when the `Maybe` value was constructed with `Just`.
 */  
  var isJust = maybe(false)(Data_Function["const"](true));

  /**
 *  | The `Functor` instance allows functions to transform the contents of a
 *  | `Just` with the `<$>` operator:
 *  |
 *  | ``` purescript
 *  | f <$> Just x == Just (f x)
 *  | ```
 *  |
 *  | `Nothing` values are left untouched:
 *  |
 *  | ``` purescript
 *  | f <$> Nothing == Nothing
 *  | ```
 */  
  var functorMaybe = new Data_Functor.Functor(function (v) {
      return function (v1) {
          if (v1 instanceof Just) {
              return new Just(v(v1.value0));
          };
          return Nothing.value;
      };
  });

  /**
 *  | Takes a default value, and a `Maybe` value. If the `Maybe` value is
 *  | `Nothing` the default value is returned, otherwise the value inside the
 *  | `Just` is returned.
 *  |
 *  | ``` purescript
 *  | fromMaybe x Nothing == x
 *  | fromMaybe x (Just y) == y
 *  | ```
 */  
  var fromMaybe = function (a) {
      return maybe(a)(Control_Category.id(Control_Category.categoryFn));
  };

  /**
 *  | A partial function that extracts the value from the `Just` data
 *  | constructor. Passing `Nothing` to `fromJust` will throw an error at
 *  | runtime.
 */  
  var fromJust = function (dictPartial) {
      return function (v) {
          var __unused = function (dictPartial1) {
              return function ($dollar33) {
                  return $dollar33;
              };
          };
          return __unused(dictPartial)((function () {
              if (v instanceof Just) {
                  return v.value0;
              };
              throw new Error("Failed pattern match at Data.Maybe line 265, column 1 - line 265, column 21: " + [ v.constructor.name ]);
          })());
      };
  };

  /**
 *  | The `Apply` instance allows functions contained within a `Just` to
 *  | transform a value contained within a `Just` using the `apply` operator:
 *  |
 *  | ``` purescript
 *  | Just f <*> Just x == Just (f x)
 *  | ```
 *  |
 *  | `Nothing` values are left untouched:
 *  |
 *  | ``` purescript
 *  | Just f <*> Nothing == Nothing
 *  | Nothing <*> Just x == Nothing
 *  | ```
 *  |
 *  | Combining `Functor`'s `<$>` with `Apply`'s `<*>` can be used transform a
 *  | pure function to take `Maybe`-typed arguments so `f :: a -> b -> c`
 *  | becomes `f :: Maybe a -> Maybe b -> Maybe c`:
 *  |
 *  | ``` purescript
 *  | f <$> Just x <*> Just y == Just (f x y)
 *  | ```
 *  |
 *  | The `Nothing`-preserving behaviour of both operators means the result of
 *  | an expression like the above but where any one of the values is `Nothing`
 *  | means the whole result becomes `Nothing` also:
 *  |
 *  | ``` purescript
 *  | f <$> Nothing <*> Just y == Nothing
 *  | f <$> Just x <*> Nothing == Nothing
 *  | f <$> Nothing <*> Nothing == Nothing
 *  | ```
 */  
  var applyMaybe = new Control_Apply.Apply(function () {
      return functorMaybe;
  }, function (v) {
      return function (v1) {
          if (v instanceof Just) {
              return Data_Functor.map(functorMaybe)(v.value0)(v1);
          };
          if (v instanceof Nothing) {
              return Nothing.value;
          };
          throw new Error("Failed pattern match at Data.Maybe line 67, column 3 - line 67, column 31: " + [ v.constructor.name, v1.constructor.name ]);
      };
  });

  /**
 *  | The `Bind` instance allows sequencing of `Maybe` values and functions that
 *  | return a `Maybe` by using the `>>=` operator:
 *  |
 *  | ``` purescript
 *  | Just x >>= f = f x
 *  | Nothing >>= f = Nothing
 *  | ```
 */  
  var bindMaybe = new Control_Bind.Bind(function () {
      return applyMaybe;
  }, function (v) {
      return function (v1) {
          if (v instanceof Just) {
              return v1(v.value0);
          };
          if (v instanceof Nothing) {
              return Nothing.value;
          };
          throw new Error("Failed pattern match at Data.Maybe line 126, column 3 - line 126, column 24: " + [ v.constructor.name, v1.constructor.name ]);
      };
  });

  /**
 *  | The `Applicative` instance enables lifting of values into `Maybe` with the
 *  | `pure` or `return` function (`return` is an alias for `pure`):
 *  |
 *  | ``` purescript
 *  | pure x :: Maybe _ == Just x
 *  | return x :: Maybe _ == Just x
 *  | ```
 *  |
 *  | Combining `Functor`'s `<$>` with `Apply`'s `<*>` and `Applicative`'s
 *  | `pure` can be used to pass a mixture of `Maybe` and non-`Maybe` typed
 *  | values to a function that does not usually expect them, by using `pure`
 *  | for any value that is not already `Maybe` typed:
 *  |
 *  | ``` purescript
 *  | f <$> Just x <*> pure y == Just (f x y)
 *  | ```
 *  |
 *  | Even though `pure = Just` it is recommended to use `pure` in situations
 *  | like this as it allows the choice of `Applicative` to be changed later
 *  | without having to go through and replace `Just` with a new constructor.
 */  
  var applicativeMaybe = new Control_Applicative.Applicative(function () {
      return applyMaybe;
  }, Just.create);

  /**
 *  | The `Alt` instance allows for a choice to be made between two `Maybe`
 *  | values with the `<|>` operator, where the first `Just` encountered
 *  | is taken.
 *  |
 *  | ``` purescript
 *  | Just x <|> Just y == Just x
 *  | Nothing <|> Just y == Just y
 *  | Nothing <|> Nothing == Nothing
 *  | ```
 */  
  var altMaybe = new Control_Alt.Alt(function () {
      return functorMaybe;
  }, function (v) {
      return function (v1) {
          if (v instanceof Nothing) {
              return v1;
          };
          return v;
      };
  });
  exports["Nothing"] = Nothing;
  exports["Just"] = Just;
  exports["fromJust"] = fromJust;
  exports["fromMaybe"] = fromMaybe;
  exports["isJust"] = isJust;
  exports["isNothing"] = isNothing;
  exports["maybe"] = maybe;
  exports["functorMaybe"] = functorMaybe;
  exports["applyMaybe"] = applyMaybe;
  exports["applicativeMaybe"] = applicativeMaybe;
  exports["altMaybe"] = altMaybe;
  exports["bindMaybe"] = bindMaybe;
  exports["showMaybe"] = showMaybe;
})(PS["Data.Maybe"] = PS["Data.Maybe"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Functor = PS["Data.Functor"];        

  /**
 *  | A type class for `newtype`s to enable convenient wrapping and unwrapping,
 *  | and the use of the other functions in this module.
 *  |
 *  | The compiler can derive instances of `Newtype` automatically:
 *  |
 *  | ``` purescript
 *  | newtype EmailAddress = EmailAddress String
 *  |
 *  | derive instance newtypeEmailAddress :: Newtype EmailAddress _
 *  | ```
 *  |
 *  | Note that deriving for `Newtype` instances requires that the type be
 *  | defined as `newtype` rather than `data` declaration (even if the `data`
 *  | structurally fits the rules of a `newtype`), and the use of a wildcard for
 *  | the wrapped type.
 *  |
 *  | Instances must obey the following laws:
 *  | ``` purescript
 *  | unwrap <<< wrap = id
 *  | wrap <<< unwrap = id
 *  | ```
 */  
  var Newtype = function (unwrap, wrap) {
      this.unwrap = unwrap;
      this.wrap = wrap;
  };

  /**
 *  | A type class for `newtype`s to enable convenient wrapping and unwrapping,
 *  | and the use of the other functions in this module.
 *  |
 *  | The compiler can derive instances of `Newtype` automatically:
 *  |
 *  | ``` purescript
 *  | newtype EmailAddress = EmailAddress String
 *  |
 *  | derive instance newtypeEmailAddress :: Newtype EmailAddress _
 *  | ```
 *  |
 *  | Note that deriving for `Newtype` instances requires that the type be
 *  | defined as `newtype` rather than `data` declaration (even if the `data`
 *  | structurally fits the rules of a `newtype`), and the use of a wildcard for
 *  | the wrapped type.
 *  |
 *  | Instances must obey the following laws:
 *  | ``` purescript
 *  | unwrap <<< wrap = id
 *  | wrap <<< unwrap = id
 *  | ```
 */  
  var wrap = function (dict) {
      return dict.wrap;
  };

  /**
 *  | A type class for `newtype`s to enable convenient wrapping and unwrapping,
 *  | and the use of the other functions in this module.
 *  |
 *  | The compiler can derive instances of `Newtype` automatically:
 *  |
 *  | ``` purescript
 *  | newtype EmailAddress = EmailAddress String
 *  |
 *  | derive instance newtypeEmailAddress :: Newtype EmailAddress _
 *  | ```
 *  |
 *  | Note that deriving for `Newtype` instances requires that the type be
 *  | defined as `newtype` rather than `data` declaration (even if the `data`
 *  | structurally fits the rules of a `newtype`), and the use of a wildcard for
 *  | the wrapped type.
 *  |
 *  | Instances must obey the following laws:
 *  | ``` purescript
 *  | unwrap <<< wrap = id
 *  | wrap <<< unwrap = id
 *  | ```
 */  
  var unwrap = function (dict) {
      return dict.unwrap;
  };

  /**
 *  | Similar to `ala` but useful for cases where you want to use an additional
 *  | projection with the higher order function:
 *  |
 *  | ``` purescript
 *  | alaF Additive foldMap String.length ["hello", "world"] -- 10
 *  | alaF Multiplicative foldMap Math.abs [1.0, -2.0, 3.0, -4.0] -- 24.0
 *  | ```
 *  |
 *  | The type admits other possibilities due to the polymorphic `Functor`
 *  | constraints, but the case described above works because ((->) a) is a
 *  | `Functor`.
 */  
  var alaF = function (dictFunctor) {
      return function (dictFunctor1) {
          return function (dictNewtype) {
              return function (dictNewtype1) {
                  return function (v) {
                      return function (f) {
                          return function ($40) {
                              return Data_Functor.map(dictFunctor1)(unwrap(dictNewtype1))(f(Data_Functor.map(dictFunctor)(wrap(dictNewtype))($40)));
                          };
                      };
                  };
              };
          };
      };
  };
  exports["Newtype"] = Newtype;
  exports["alaF"] = alaF;
  exports["unwrap"] = unwrap;
  exports["wrap"] = wrap;
})(PS["Data.Newtype"] = PS["Data.Newtype"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | Wraps the functions of Javascript's `String` object.
 *  | A String represents a sequence of characters.
 *  | For details of the underlying implementation, see [String Reference at MDN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String).
 */  
  "use strict";
  var $foreign = PS["Data.String"];
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Newtype = PS["Data.Newtype"];
  var Data_String_Unsafe = PS["Data.String.Unsafe"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Semiring = PS["Data.Semiring"];
  var Data_Ordering = PS["Data.Ordering"];
  var Data_Ring = PS["Data.Ring"];
  var Data_Function = PS["Data.Function"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];                          

  /**
 *  | Returns the longest prefix (possibly empty) of characters that satisfy
 *  | the predicate.
 */  
  var takeWhile = function (p) {
      return function (s) {
          return $foreign.take($foreign.count(p)(s))(s);
      };
  }; 

  /**
 *  | Returns `true` if the given string is empty.
 */  
  var $$null = function (s) {
      return s === "";
  };                                                                                                  

  /**
 *  | Returns the index of the last occurrence of the first string in the
 *  | second string. Returns `Nothing` if there is no match.
 */  
  var lastIndexOf = $foreign._lastIndexOf(Data_Maybe.Just.create)(Data_Maybe.Nothing.value);

  /**
 *  | If the string ends with the given suffix, return the portion of the
 *  | string left after removing it, as a Just value. Otherwise, return Nothing.
 *  | * `stripSuffix (Pattern ".exe") "psc.exe" == Just "psc"`
 *  | * `stripSuffix (Pattern ".exe") "psc" == Nothing`
 */  
  var stripSuffix = function (v) {
      return function (str) {
          var $32 = lastIndexOf(v)(str);
          if ($32 instanceof Data_Maybe.Just && $32.value0 === $foreign.length(str) - $foreign.length(v)) {
              return Data_Maybe.Just.create($foreign.take($32.value0)(str));
          };
          return Data_Maybe.Nothing.value;
      };
  };                                                                                          

  /**
 *  | Returns the index of the first occurrence of the first string in the
 *  | second string. Returns `Nothing` if there is no match.
 */  
  var indexOf = $foreign._indexOf(Data_Maybe.Just.create)(Data_Maybe.Nothing.value);

  /**
 *  | If the string starts with the given prefix, return the portion of the
 *  | string left after removing it, as a Just value. Otherwise, return Nothing.
 *  | * `stripPrefix (Pattern "http:") "http://purescript.org" == Just "//purescript.org"`
 *  | * `stripPrefix (Pattern "http:") "https://purescript.org" == Nothing`
 */  
  var stripPrefix = function (v) {
      return function (str) {
          var $36 = indexOf(v)(str);
          if ($36 instanceof Data_Maybe.Just && $36.value0 === 0) {
              return Data_Maybe.Just.create($foreign.drop($foreign.length(v))(str));
          };
          return Data_Maybe.Nothing.value;
      };
  };
  exports["indexOf"] = indexOf;
  exports["lastIndexOf"] = lastIndexOf;
  exports["null"] = $$null;
  exports["stripPrefix"] = stripPrefix;
  exports["stripSuffix"] = stripSuffix;
  exports["takeWhile"] = takeWhile;
  exports["fromCharArray"] = $foreign.fromCharArray;
  exports["joinWith"] = $foreign.joinWith;
  exports["length"] = $foreign.length;
  exports["replace"] = $foreign.replace;
  exports["split"] = $foreign.split;
  exports["toCharArray"] = $foreign.toCharArray;
  exports["toLower"] = $foreign.toLower;
  exports["toUpper"] = $foreign.toUpper;
  exports["trim"] = $foreign.trim;
})(PS["Data.String"] = PS["Data.String"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines a data type representing ANSI escape codes, as well as
 *  | functions for serialising them as Strings.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_String = PS["Data.String"];
  var Data_Show = PS["Data.Show"];
  var Data_Semiring = PS["Data.Semiring"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];        
  var Bold = (function () {
      function Bold() {

      };
      Bold.value = new Bold();
      return Bold;
  })();
  var Dim = (function () {
      function Dim() {

      };
      Dim.value = new Dim();
      return Dim;
  })();
  var Italic = (function () {
      function Italic() {

      };
      Italic.value = new Italic();
      return Italic;
  })();
  var Underline = (function () {
      function Underline() {

      };
      Underline.value = new Underline();
      return Underline;
  })();
  var Inverse = (function () {
      function Inverse() {

      };
      Inverse.value = new Inverse();
      return Inverse;
  })();
  var Strikethrough = (function () {
      function Strikethrough() {

      };
      Strikethrough.value = new Strikethrough();
      return Strikethrough;
  })();

  /**
 *  | Specifies how much text to erase.
 *  |
 *  | * ToEnd: erase from the cursor to the end of the line or screen.
 *  | * FromBeginning: erase to the cursor from the beginning of the line or
 *  |    screen.
 *  | * Entire: erase the entire line or screen.
 */  
  var ToEnd = (function () {
      function ToEnd() {

      };
      ToEnd.value = new ToEnd();
      return ToEnd;
  })();

  /**
 *  | Specifies how much text to erase.
 *  |
 *  | * ToEnd: erase from the cursor to the end of the line or screen.
 *  | * FromBeginning: erase to the cursor from the beginning of the line or
 *  |    screen.
 *  | * Entire: erase the entire line or screen.
 */  
  var FromBeginning = (function () {
      function FromBeginning() {

      };
      FromBeginning.value = new FromBeginning();
      return FromBeginning;
  })();

  /**
 *  | Specifies how much text to erase.
 *  |
 *  | * ToEnd: erase from the cursor to the end of the line or screen.
 *  | * FromBeginning: erase to the cursor from the beginning of the line or
 *  |    screen.
 *  | * Entire: erase the entire line or screen.
 */  
  var Entire = (function () {
      function Entire() {

      };
      Entire.value = new Entire();
      return Entire;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var White = (function () {
      function White() {

      };
      White.value = new White();
      return White;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var Black = (function () {
      function Black() {

      };
      Black.value = new Black();
      return Black;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var Blue = (function () {
      function Blue() {

      };
      Blue.value = new Blue();
      return Blue;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var Cyan = (function () {
      function Cyan() {

      };
      Cyan.value = new Cyan();
      return Cyan;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var Green = (function () {
      function Green() {

      };
      Green.value = new Green();
      return Green;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var Magenta = (function () {
      function Magenta() {

      };
      Magenta.value = new Magenta();
      return Magenta;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var Red = (function () {
      function Red() {

      };
      Red.value = new Red();
      return Red;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var Yellow = (function () {
      function Yellow() {

      };
      Yellow.value = new Yellow();
      return Yellow;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var Grey = (function () {
      function Grey() {

      };
      Grey.value = new Grey();
      return Grey;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var BrightBlack = (function () {
      function BrightBlack() {

      };
      BrightBlack.value = new BrightBlack();
      return BrightBlack;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var BrightRed = (function () {
      function BrightRed() {

      };
      BrightRed.value = new BrightRed();
      return BrightRed;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var BrightGreen = (function () {
      function BrightGreen() {

      };
      BrightGreen.value = new BrightGreen();
      return BrightGreen;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var BrightYellow = (function () {
      function BrightYellow() {

      };
      BrightYellow.value = new BrightYellow();
      return BrightYellow;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var BrightBlue = (function () {
      function BrightBlue() {

      };
      BrightBlue.value = new BrightBlue();
      return BrightBlue;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var BrightMagenta = (function () {
      function BrightMagenta() {

      };
      BrightMagenta.value = new BrightMagenta();
      return BrightMagenta;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var BrightCyan = (function () {
      function BrightCyan() {

      };
      BrightCyan.value = new BrightCyan();
      return BrightCyan;
  })();

  /**
 *  | The standard set of 16 ANSI colors.
 */  
  var BrightWhite = (function () {
      function BrightWhite() {

      };
      BrightWhite.value = new BrightWhite();
      return BrightWhite;
  })();

  /**
 *  | A graphics parameter, controls how text appears; for example, bold,
 *  | underlined, foreground color, background color.
 */  
  var Reset = (function () {
      function Reset() {

      };
      Reset.value = new Reset();
      return Reset;
  })();

  /**
 *  | A graphics parameter, controls how text appears; for example, bold,
 *  | underlined, foreground color, background color.
 */  
  var PMode = (function () {
      function PMode(value0) {
          this.value0 = value0;
      };
      PMode.create = function (value0) {
          return new PMode(value0);
      };
      return PMode;
  })();

  /**
 *  | A graphics parameter, controls how text appears; for example, bold,
 *  | underlined, foreground color, background color.
 */  
  var PForeground = (function () {
      function PForeground(value0) {
          this.value0 = value0;
      };
      PForeground.create = function (value0) {
          return new PForeground(value0);
      };
      return PForeground;
  })();

  /**
 *  | A graphics parameter, controls how text appears; for example, bold,
 *  | underlined, foreground color, background color.
 */  
  var PBackground = (function () {
      function PBackground(value0) {
          this.value0 = value0;
      };
      PBackground.create = function (value0) {
          return new PBackground(value0);
      };
      return PBackground;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var Up = (function () {
      function Up(value0) {
          this.value0 = value0;
      };
      Up.create = function (value0) {
          return new Up(value0);
      };
      return Up;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var Down = (function () {
      function Down(value0) {
          this.value0 = value0;
      };
      Down.create = function (value0) {
          return new Down(value0);
      };
      return Down;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var Forward = (function () {
      function Forward(value0) {
          this.value0 = value0;
      };
      Forward.create = function (value0) {
          return new Forward(value0);
      };
      return Forward;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var Back = (function () {
      function Back(value0) {
          this.value0 = value0;
      };
      Back.create = function (value0) {
          return new Back(value0);
      };
      return Back;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var NextLine = (function () {
      function NextLine(value0) {
          this.value0 = value0;
      };
      NextLine.create = function (value0) {
          return new NextLine(value0);
      };
      return NextLine;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var PreviousLine = (function () {
      function PreviousLine(value0) {
          this.value0 = value0;
      };
      PreviousLine.create = function (value0) {
          return new PreviousLine(value0);
      };
      return PreviousLine;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var HorizontalAbsolute = (function () {
      function HorizontalAbsolute(value0) {
          this.value0 = value0;
      };
      HorizontalAbsolute.create = function (value0) {
          return new HorizontalAbsolute(value0);
      };
      return HorizontalAbsolute;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var Position = (function () {
      function Position(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      Position.create = function (value0) {
          return function (value1) {
              return new Position(value0, value1);
          };
      };
      return Position;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var EraseData = (function () {
      function EraseData(value0) {
          this.value0 = value0;
      };
      EraseData.create = function (value0) {
          return new EraseData(value0);
      };
      return EraseData;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var EraseLine = (function () {
      function EraseLine(value0) {
          this.value0 = value0;
      };
      EraseLine.create = function (value0) {
          return new EraseLine(value0);
      };
      return EraseLine;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var ScrollUp = (function () {
      function ScrollUp(value0) {
          this.value0 = value0;
      };
      ScrollUp.create = function (value0) {
          return new ScrollUp(value0);
      };
      return ScrollUp;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var ScrollDown = (function () {
      function ScrollDown(value0) {
          this.value0 = value0;
      };
      ScrollDown.create = function (value0) {
          return new ScrollDown(value0);
      };
      return ScrollDown;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var Graphics = (function () {
      function Graphics(value0) {
          this.value0 = value0;
      };
      Graphics.create = function (value0) {
          return new Graphics(value0);
      };
      return Graphics;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var SavePosition = (function () {
      function SavePosition() {

      };
      SavePosition.value = new SavePosition();
      return SavePosition;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var RestorePosition = (function () {
      function RestorePosition() {

      };
      RestorePosition.value = new RestorePosition();
      return RestorePosition;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var QueryPosition = (function () {
      function QueryPosition() {

      };
      QueryPosition.value = new QueryPosition();
      return QueryPosition;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var HideCursor = (function () {
      function HideCursor() {

      };
      HideCursor.value = new HideCursor();
      return HideCursor;
  })();

  /**
 *  | An ANSI escape code. Not all sequences are implemented. 
 *  | See: <https://en.wikipedia.org/wiki/ANSI_escape_code>.
 */  
  var ShowCursor = (function () {
      function ShowCursor() {

      };
      ShowCursor.value = new ShowCursor();
      return ShowCursor;
  })();

  /**
 *  | The prefix for all escape codes.
 */  
  var prefix = "\x1b[";
  var eraseParamToString = function (ep) {
      if (ep instanceof ToEnd) {
          return "0";
      };
      if (ep instanceof FromBeginning) {
          return "1";
      };
      if (ep instanceof Entire) {
          return "2";
      };
      throw new Error("Failed pattern match at Ansi.Codes line 79, column 3 - line 84, column 1: " + [ ep.constructor.name ]);
  };

  /**
 *  | The suffix for escape codes; note that this is only required for colors.
 */  
  var colorSuffix = "m";
  var colorCode = function (c) {
      if (c instanceof White) {
          return 37;
      };
      if (c instanceof Black) {
          return 30;
      };
      if (c instanceof Blue) {
          return 34;
      };
      if (c instanceof Cyan) {
          return 36;
      };
      if (c instanceof Green) {
          return 32;
      };
      if (c instanceof Magenta) {
          return 35;
      };
      if (c instanceof Red) {
          return 31;
      };
      if (c instanceof Yellow) {
          return 33;
      };
      if (c instanceof Grey) {
          return 90;
      };
      if (c instanceof BrightBlack) {
          return 90;
      };
      if (c instanceof BrightRed) {
          return 91;
      };
      if (c instanceof BrightGreen) {
          return 92;
      };
      if (c instanceof BrightYellow) {
          return 93;
      };
      if (c instanceof BrightBlue) {
          return 94;
      };
      if (c instanceof BrightMagenta) {
          return 95;
      };
      if (c instanceof BrightCyan) {
          return 96;
      };
      if (c instanceof BrightWhite) {
          return 97;
      };
      throw new Error("Failed pattern match at Ansi.Codes line 140, column 3 - line 157, column 20: " + [ c.constructor.name ]);
  };
  var codeForRenderingMode = function (m) {
      if (m instanceof Bold) {
          return 1;
      };
      if (m instanceof Dim) {
          return 2;
      };
      if (m instanceof Italic) {
          return 3;
      };
      if (m instanceof Underline) {
          return 4;
      };
      if (m instanceof Inverse) {
          return 7;
      };
      if (m instanceof Strikethrough) {
          return 9;
      };
      throw new Error("Failed pattern match at Ansi.Codes line 110, column 3 - line 118, column 1: " + [ m.constructor.name ]);
  };
  var graphicsParamToString = function (gp) {
      if (gp instanceof Reset) {
          return "0";
      };
      if (gp instanceof PMode) {
          return Data_Show.show(Data_Show.showInt)(codeForRenderingMode(gp.value0));
      };
      if (gp instanceof PForeground) {
          return Data_Show.show(Data_Show.showInt)(colorCode(gp.value0));
      };
      if (gp instanceof PBackground) {
          return Data_Show.show(Data_Show.showInt)(colorCode(gp.value0) + 10 | 0);
      };
      throw new Error("Failed pattern match at Ansi.Codes line 94, column 3 - line 98, column 45: " + [ gp.constructor.name ]);
  };

  /**
 *  | Convert an escape code to the form recognised by terminals.
 */  
  var escapeCodeToString = (function () {
      var go = function (c) {
          if (c instanceof Up) {
              return Data_Show.show(Data_Show.showInt)(c.value0) + "A";
          };
          if (c instanceof Down) {
              return Data_Show.show(Data_Show.showInt)(c.value0) + "B";
          };
          if (c instanceof Forward) {
              return Data_Show.show(Data_Show.showInt)(c.value0) + "C";
          };
          if (c instanceof Back) {
              return Data_Show.show(Data_Show.showInt)(c.value0) + "D";
          };
          if (c instanceof NextLine) {
              return Data_Show.show(Data_Show.showInt)(c.value0) + "E";
          };
          if (c instanceof PreviousLine) {
              return Data_Show.show(Data_Show.showInt)(c.value0) + "F";
          };
          if (c instanceof HorizontalAbsolute) {
              return Data_Show.show(Data_Show.showInt)(c.value0) + "G";
          };
          if (c instanceof Position) {
              return Data_Show.show(Data_Show.showInt)(c.value0) + (";" + (Data_Show.show(Data_Show.showInt)(c.value1) + "H"));
          };
          if (c instanceof EraseData) {
              return eraseParamToString(c.value0) + "J";
          };
          if (c instanceof EraseLine) {
              return eraseParamToString(c.value0) + "K";
          };
          if (c instanceof ScrollUp) {
              return Data_Show.show(Data_Show.showInt)(c.value0) + "S";
          };
          if (c instanceof ScrollDown) {
              return Data_Show.show(Data_Show.showInt)(c.value0) + "T";
          };
          if (c instanceof Graphics) {
              return Data_String.joinWith(";")(Data_Functor.map(Data_Functor.functorArray)(graphicsParamToString)(c.value0)) + colorSuffix;
          };
          if (c instanceof SavePosition) {
              return "s";
          };
          if (c instanceof RestorePosition) {
              return "u";
          };
          if (c instanceof QueryPosition) {
              return "6n";
          };
          if (c instanceof HideCursor) {
              return "?25l";
          };
          if (c instanceof ShowCursor) {
              return "?25h";
          };
          throw new Error("Failed pattern match at Ansi.Codes line 43, column 5 - line 63, column 3: " + [ c.constructor.name ]);
      };
      return function ($23) {
          return (function (v) {
              return prefix + v;
          })(go($23));
      };
  })();
  exports["White"] = White;
  exports["Black"] = Black;
  exports["Blue"] = Blue;
  exports["Cyan"] = Cyan;
  exports["Green"] = Green;
  exports["Magenta"] = Magenta;
  exports["Red"] = Red;
  exports["Yellow"] = Yellow;
  exports["Grey"] = Grey;
  exports["BrightBlack"] = BrightBlack;
  exports["BrightRed"] = BrightRed;
  exports["BrightGreen"] = BrightGreen;
  exports["BrightYellow"] = BrightYellow;
  exports["BrightBlue"] = BrightBlue;
  exports["BrightMagenta"] = BrightMagenta;
  exports["BrightCyan"] = BrightCyan;
  exports["BrightWhite"] = BrightWhite;
  exports["ToEnd"] = ToEnd;
  exports["FromBeginning"] = FromBeginning;
  exports["Entire"] = Entire;
  exports["Up"] = Up;
  exports["Down"] = Down;
  exports["Forward"] = Forward;
  exports["Back"] = Back;
  exports["NextLine"] = NextLine;
  exports["PreviousLine"] = PreviousLine;
  exports["HorizontalAbsolute"] = HorizontalAbsolute;
  exports["Position"] = Position;
  exports["EraseData"] = EraseData;
  exports["EraseLine"] = EraseLine;
  exports["ScrollUp"] = ScrollUp;
  exports["ScrollDown"] = ScrollDown;
  exports["Graphics"] = Graphics;
  exports["SavePosition"] = SavePosition;
  exports["RestorePosition"] = RestorePosition;
  exports["QueryPosition"] = QueryPosition;
  exports["HideCursor"] = HideCursor;
  exports["ShowCursor"] = ShowCursor;
  exports["Reset"] = Reset;
  exports["PMode"] = PMode;
  exports["PForeground"] = PForeground;
  exports["PBackground"] = PBackground;
  exports["Bold"] = Bold;
  exports["Dim"] = Dim;
  exports["Italic"] = Italic;
  exports["Underline"] = Underline;
  exports["Inverse"] = Inverse;
  exports["Strikethrough"] = Strikethrough;
  exports["codeForRenderingMode"] = codeForRenderingMode;
  exports["colorCode"] = colorCode;
  exports["colorSuffix"] = colorSuffix;
  exports["eraseParamToString"] = eraseParamToString;
  exports["escapeCodeToString"] = escapeCodeToString;
  exports["graphicsParamToString"] = graphicsParamToString;
  exports["prefix"] = prefix;
})(PS["Ansi.Codes"] = PS["Ansi.Codes"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | Convenience functions to simplify outputting ANSI escape codes to
 *  | terminals.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Ansi_Codes = PS["Ansi.Codes"];
  var Control_Bind = PS["Control.Bind"];        

  /**
 *  | Using the given output function, write the given text with the given set
 *  | of graphics parameters. For example:
 *  |
 *  | ```purescript
 *  | withGraphics Console.log (bold <> underline <> foreground BrightRed) "hello world"
 *  | ```
 *  |
 *  | would print "hello world" to the terminal, bold, underlined, and in bright
 *  | red, and then reset (so that further logging to the console uses the
 *  | normal color and style).
 *  |
 *  | This function works by first printing the escape code corresponding to the
 *  | supplied graphics parameters, then printing the text, and then printing a
 *  | reset escape code.
 *  |
 *  | The first argument should take a string, and write it to some output stream
 *  | such as a terminal. In most cases, you will want to use either
 *  | `Console.log` or `Console.error`.
 */  
  var withGraphics = function (dictMonad) {
      return function (write) {
          return function (params) {
              return function (text) {
                  return Control_Bind.bind(dictMonad["__superclass_Control.Bind.Bind_1"]())(write(Ansi_Codes.escapeCodeToString(new Ansi_Codes.Graphics(params))))(function () {
                      return Control_Bind.bind(dictMonad["__superclass_Control.Bind.Bind_1"]())(write(text))(function () {
                          return write(Ansi_Codes.escapeCodeToString(new Ansi_Codes.Graphics([ Ansi_Codes.Reset.value ])));
                      });
                  });
              };
          };
      };
  };                                                               
  var foreground = function (c) {
      return [ new Ansi_Codes.PForeground(c) ];
  };                                                       
  var bold = [ new Ansi_Codes.PMode(Ansi_Codes.Bold.value) ];
  exports["bold"] = bold;
  exports["foreground"] = foreground;
  exports["withGraphics"] = withGraphics;
})(PS["Ansi.Output"] = PS["Ansi.Output"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Control_Extend = PS["Control.Extend"];
  var Data_Functor = PS["Data.Functor"];        

  /**
 *  | `Comonad` extends the `Extend` class with the `extract` function
 *  | which extracts a value, discarding the comonadic context.
 *  |
 *  | `Comonad` is the dual of `Monad`, and `extract` is the dual of `pure`.
 *  |
 *  | Laws:
 *  |
 *  | - Left Identity: `extract <<= xs = xs`
 *  | - Right Identity: `extract (f <<= xs) = f xs`
 */  
  var Comonad = function (__superclass_Control$dotExtend$dotExtend_0, extract) {
      this["__superclass_Control.Extend.Extend_0"] = __superclass_Control$dotExtend$dotExtend_0;
      this.extract = extract;
  };

  /**
 *  | `Comonad` extends the `Extend` class with the `extract` function
 *  | which extracts a value, discarding the comonadic context.
 *  |
 *  | `Comonad` is the dual of `Monad`, and `extract` is the dual of `pure`.
 *  |
 *  | Laws:
 *  |
 *  | - Left Identity: `extract <<= xs = xs`
 *  | - Right Identity: `extract (f <<= xs) = f xs`
 */  
  var extract = function (dict) {
      return dict.extract;
  };
  exports["Comonad"] = Comonad;
  exports["extract"] = extract;
})(PS["Control.Comonad"] = PS["Control.Comonad"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Data_Unit = PS["Data.Unit"];        

  /**
 *  | The `Lazy` class represents types which allow evaluation of values
 *  | to be _deferred_.
 *  |
 *  | Usually, this means that a type contains a function arrow which can
 *  | be used to delay evaluation.
 */  
  var Lazy = function (defer) {
      this.defer = defer;
  };

  /**
 *  | The `Lazy` class represents types which allow evaluation of values
 *  | to be _deferred_.
 *  |
 *  | Usually, this means that a type contains a function arrow which can
 *  | be used to delay evaluation.
 */  
  var defer = function (dict) {
      return dict.defer;
  };
  exports["Lazy"] = Lazy;
  exports["defer"] = defer;
})(PS["Control.Lazy"] = PS["Control.Lazy"] || {});
(function(exports) {
  /* globals setTimeout, clearTimeout, setImmediate, clearImmediate */
  "use strict";

  exports._unsafeInterleaveAff = function (aff) {
    return aff;
  };

  exports._forkAff = function (nonCanceler, aff) {
    var voidF = function () {};

    return function (success) {
      var canceler = aff(voidF, voidF);
      success(canceler);
      return nonCanceler;
    };
  };

  exports._makeAff = function (cb) {
    return function (success, error) {
      try {
        return cb(function (e) {
          return function () {
            error(e);
          };
        })(function (v) {
          return function () {
            success(v);
          };
        })();
      } catch (err) {
        error(err);
      }
    };
  };

  exports._pure = function (nonCanceler, v) {
    return function (success) {
      success(v);
      return nonCanceler;
    };
  };

  exports._throwError = function (nonCanceler, e) {
    return function (success, error) {
      error(e);
      return nonCanceler;
    };
  };

  exports._fmap = function (f, aff) {
    return function (success, error) {
      return aff(function (v) {
        success(f(v));
      }, error);
    };
  };

  exports._bind = function (alwaysCanceler, aff, f) {
    return function (success, error) {
      var canceler1, canceler2;

      var isCanceled    = false;
      var requestCancel = false;

      var onCanceler = function () {};

      canceler1 = aff(function (v) {
        if (requestCancel) {
          isCanceled = true;

          return alwaysCanceler;
        } else {
          canceler2 = f(v)(success, error);

          onCanceler(canceler2);

          return canceler2;
        }
      }, error);

      return function (e) {
        return function (s, f) {
          requestCancel = true;

          if (canceler2 !== undefined) {
            return canceler2(e)(s, f);
          } else {
            return canceler1(e)(function (bool) {
              if (bool || isCanceled) {
                s(true);
              } else {
                onCanceler = function (canceler) {
                  canceler(e)(s, f);
                };
              }
            }, f);
          }
        };
      };
    };
  };

  exports._attempt = function (Left, Right, aff) {
    return function (success) {
      return aff(function (v) {
        success(Right(v));
      }, function (e) {
        success(Left(e));
      });
    };
  };

  exports._runAff = function (errorT, successT, aff) {
    // If errorT or successT throw, and an Aff is comprised only of synchronous
    // effects, then it's possible for makeAff/liftEff to accidentally catch
    // it, which may end up rerunning the Aff depending on error recovery
    // behavior. To mitigate this, we observe synchronicity using mutation. If
    // an Aff is observed to be synchronous, we let the stack reset and run the
    // handlers outside of the normal callback flow.
    return function () {
      var status = 0;
      var result, success;

      var canceler = aff(function (v) {
        if (status === 2) {
          successT(v)();
        } else {
          status = 1;
          result = v;
          success = true;
        }
      }, function (e) {
        if (status === 2) {
          errorT(e)();
        } else {
          status = 1;
          result = e;
          success = false;
        }
      });

      if (status === 1) {
        if (success) {
          successT(result)();
        } else {
          errorT(result)();
        }
      } else {
        status = 2;
      }

      return canceler;
    };
  };

  exports._liftEff = function (nonCanceler, e) {
    return function (success, error) {
      var result;
      try {
        result = e();
      } catch (err) {
        error(err);
        return nonCanceler;
      }

      success(result);
      return nonCanceler;
    };
  };
})(PS["Control.Monad.Aff"] = PS["Control.Monad.Aff"] || {});
(function(exports) {
    "use strict";

  exports._makeVar = function (nonCanceler) {
    return function (success) {
      success({
        consumers: [],
        producers: [],
        error: undefined
      });
      return nonCanceler;
    };
  };

  exports._takeVar = function (nonCanceler, avar) {
    return function (success, error) {
      if (avar.error !== undefined) {
        error(avar.error);
      } else if (avar.producers.length > 0) {
        avar.producers.shift()(success, error);
      } else {
        avar.consumers.push({ peek: false, success: success, error: error });
      }

      return nonCanceler;
    };
  };

  exports._peekVar = function (nonCanceler, avar) {
    return function (success, error) {
      if (avar.error !== undefined) {
        error(avar.error);
      } else if (avar.producers.length > 0) {
        avar.producers[0](success, error);
      } else {
        avar.consumers.push({ peek: true, success: success, error: error });
      }
      return nonCanceler;
    };
  };

  exports._putVar = function (nonCanceler, avar, a) {
    return function (success, error) {
      if (avar.error !== undefined) {
        error(avar.error);
      } else {
        var shouldQueue = true;
        var consumers = [];
        var consumer;

        while (true) {
          consumer = avar.consumers.shift();
          if (consumer) {
            consumers.push(consumer);
            if (consumer.peek) {
              continue;
            } else {
              shouldQueue = false;
            }
          }
          break;
        }

        if (shouldQueue) {
          avar.producers.push(function (success) {
            success(a);
            return nonCanceler;
          });
        }

        for (var i = 0; i < consumers.length; i++) {
          consumers[i].success(a);
        }

        success({});
      }

      return nonCanceler;
    };
  };
})(PS["Control.Monad.Aff.Internal"] = PS["Control.Monad.Aff.Internal"] || {});
(function(exports) {
    "use strict";

  exports.error = function (msg) {
    return new Error(msg);
  };

  exports.message = function (e) {
    return e.message;
  };

  exports.throwException = function (e) {
    return function () {
      throw e;
    };
  };

  exports.catchException = function (c) {
    return function (t) {
      return function () {
        try {
          return t();
        } catch (e) {
          if (e instanceof Error || Object.prototype.toString.call(e) === "[object Error]") {
            return c(e)();
          } else {
            return c(new Error(e.toString()))();
          }
        }
      };
    };
  };
})(PS["Control.Monad.Eff.Exception"] = PS["Control.Monad.Eff.Exception"] || {});
(function(exports) {
    "use strict";

  exports.pureE = function (a) {
    return function () {
      return a;
    };
  };

  exports.bindE = function (a) {
    return function (f) {
      return function () {
        return f(a())();
      };
    };
  };

  exports.runPure = function (f) {
    return f();
  };
})(PS["Control.Monad.Eff"] = PS["Control.Monad.Eff"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Control.Monad.Eff"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad = PS["Control.Monad"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Unit = PS["Data.Unit"];        
  var monadEff = new Control_Monad.Monad(function () {
      return applicativeEff;
  }, function () {
      return bindEff;
  });
  var bindEff = new Control_Bind.Bind(function () {
      return applyEff;
  }, $foreign.bindE);
  var applyEff = new Control_Apply.Apply(function () {
      return functorEff;
  }, Control_Monad.ap(monadEff));
  var applicativeEff = new Control_Applicative.Applicative(function () {
      return applyEff;
  }, $foreign.pureE);
  var functorEff = new Data_Functor.Functor(Control_Applicative.liftA1(applicativeEff));
  exports["functorEff"] = functorEff;
  exports["applyEff"] = applyEff;
  exports["applicativeEff"] = applicativeEff;
  exports["bindEff"] = bindEff;
  exports["monadEff"] = monadEff;
  exports["runPure"] = $foreign.runPure;
})(PS["Control.Monad.Eff"] = PS["Control.Monad.Eff"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Control_Category = PS["Control.Category"];        

  /**
 *  | A `Bifunctor` is a `Functor` from the pair category `(Type, Type)` to `Type`.
 *  |
 *  | A type constructor with two type arguments can be made into a `Bifunctor` if
 *  | both of its type arguments are covariant.
 *  |
 *  | The `bimap` function maps a pair of functions over the two type arguments
 *  | of the bifunctor.
 *  |
 *  | Laws:
 *  |
 *  | - Identity: `bimap id id == id`
 *  | - Composition: `bimap f1 g1 <<< bimap f2 g2 == bimap (f1 <<< f2) (g1 <<< g2)`
 *  |
 */  
  var Bifunctor = function (bimap) {
      this.bimap = bimap;
  };

  /**
 *  | A `Bifunctor` is a `Functor` from the pair category `(Type, Type)` to `Type`.
 *  |
 *  | A type constructor with two type arguments can be made into a `Bifunctor` if
 *  | both of its type arguments are covariant.
 *  |
 *  | The `bimap` function maps a pair of functions over the two type arguments
 *  | of the bifunctor.
 *  |
 *  | Laws:
 *  |
 *  | - Identity: `bimap id id == id`
 *  | - Composition: `bimap f1 g1 <<< bimap f2 g2 == bimap (f1 <<< f2) (g1 <<< g2)`
 *  |
 */  
  var bimap = function (dict) {
      return dict.bimap;
  };

  /**
 *  | Map a function over the first type argument of a `Bifunctor`.
 */  
  var lmap = function (dictBifunctor) {
      return function (f) {
          return bimap(dictBifunctor)(f)(Control_Category.id(Control_Category.categoryFn));
      };
  };
  exports["Bifunctor"] = Bifunctor;
  exports["bimap"] = bimap;
  exports["lmap"] = lmap;
})(PS["Data.Bifunctor"] = PS["Data.Bifunctor"] || {});
(function(exports) {
    "use strict";

  exports.foldrArray = function (f) {
    return function (init) {
      return function (xs) {
        var acc = init;
        var len = xs.length;
        for (var i = len - 1; i >= 0; i--) {
          acc = f(xs[i])(acc);
        }
        return acc;
      };
    };
  };

  exports.foldlArray = function (f) {
    return function (init) {
      return function (xs) {
        var acc = init;
        var len = xs.length;
        for (var i = 0; i < len; i++) {
          acc = f(acc)(xs[i]);
        }
        return acc;
      };
    };
  };
})(PS["Data.Foldable"] = PS["Data.Foldable"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Extend = PS["Control.Extend"];
  var Data_Functor_Invariant = PS["Data.Functor.Invariant"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Newtype = PS["Data.Newtype"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Bounded = PS["Data.Bounded"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad = PS["Control.Monad"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];        

  /**
 *  | Monoid returning the first (left-most) non-`Nothing` value.
 *  |
 *  | ``` purescript
 *  | First (Just x) <> First (Just y) == First (Just x)
 *  | First Nothing <> First (Just y) == First (Just y)
 *  | First Nothing <> Nothing == First Nothing
 *  | mempty :: First _ == First Nothing
 *  | ```
 */  
  var First = function (x) {
      return x;
  };
  var semigroupFirst = new Data_Semigroup.Semigroup(function (v) {
      return function (v1) {
          if (v instanceof Data_Maybe.Just) {
              return v;
          };
          return v1;
      };
  });
  var newtypeFirst = new Data_Newtype.Newtype(function (n) {
      return n;
  }, First);
  var monoidFirst = new Data_Monoid.Monoid(function () {
      return semigroupFirst;
  }, Data_Maybe.Nothing.value);
  exports["First"] = First;
  exports["newtypeFirst"] = newtypeFirst;
  exports["semigroupFirst"] = semigroupFirst;
  exports["monoidFirst"] = monoidFirst;
})(PS["Data.Maybe.First"] = PS["Data.Maybe.First"] || {});
(function(exports) {
    "use strict";

  exports.boolConj = function (b1) {
    return function (b2) {
      return b1 && b2;
    };
  };

  exports.boolDisj = function (b1) {
    return function (b2) {
      return b1 || b2;
    };
  };

  exports.boolNot = function (b) {
    return !b;
  };
})(PS["Data.HeytingAlgebra"] = PS["Data.HeytingAlgebra"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Data.HeytingAlgebra"];
  var Data_Unit = PS["Data.Unit"];        

  /**
 *  | The `HeytingAlgebra` type class represents types are bounded lattices with
 *  | an implication operator such that the following laws hold:
 *  |
 *  | - Associativity:
 *  |   - `a || (b || c) = (a || b) || c`
 *  |   - `a && (b && c) = (a && b) && c`
 *  | - Commutativity:
 *  |   - `a || b = b || a`
 *  |   - `a && b = b && a`
 *  | - Absorption:
 *  |   - `a || (a && b) = a`
 *  |   - `a && (a || b) = a`
 *  | - Idempotent:
 *  |   - `a || a = a`
 *  |   - `a && a = a`
 *  | - Identity:
 *  |   - `a || ff = a`
 *  |   - `a && tt = a`
 *  | - Implication:
 *  |   - ``a `implies` a = tt``
 *  |   - ``a && (a `implies` b) = a && b``
 *  |   - ``b && (a `implies` b) = b``
 *  |   - ``a `implies` (b && c) = (a `implies` b) && (a `implies` c)``
 *  | - Complemented:
 *  |   - ``not a = a `implies` ff``
 */  
  var HeytingAlgebra = function (conj, disj, ff, implies, not, tt) {
      this.conj = conj;
      this.disj = disj;
      this.ff = ff;
      this.implies = implies;
      this.not = not;
      this.tt = tt;
  };

  /**
 *  | The `HeytingAlgebra` type class represents types are bounded lattices with
 *  | an implication operator such that the following laws hold:
 *  |
 *  | - Associativity:
 *  |   - `a || (b || c) = (a || b) || c`
 *  |   - `a && (b && c) = (a && b) && c`
 *  | - Commutativity:
 *  |   - `a || b = b || a`
 *  |   - `a && b = b && a`
 *  | - Absorption:
 *  |   - `a || (a && b) = a`
 *  |   - `a && (a || b) = a`
 *  | - Idempotent:
 *  |   - `a || a = a`
 *  |   - `a && a = a`
 *  | - Identity:
 *  |   - `a || ff = a`
 *  |   - `a && tt = a`
 *  | - Implication:
 *  |   - ``a `implies` a = tt``
 *  |   - ``a && (a `implies` b) = a && b``
 *  |   - ``b && (a `implies` b) = b``
 *  |   - ``a `implies` (b && c) = (a `implies` b) && (a `implies` c)``
 *  | - Complemented:
 *  |   - ``not a = a `implies` ff``
 */  
  var tt = function (dict) {
      return dict.tt;
  };

  /**
 *  | The `HeytingAlgebra` type class represents types are bounded lattices with
 *  | an implication operator such that the following laws hold:
 *  |
 *  | - Associativity:
 *  |   - `a || (b || c) = (a || b) || c`
 *  |   - `a && (b && c) = (a && b) && c`
 *  | - Commutativity:
 *  |   - `a || b = b || a`
 *  |   - `a && b = b && a`
 *  | - Absorption:
 *  |   - `a || (a && b) = a`
 *  |   - `a && (a || b) = a`
 *  | - Idempotent:
 *  |   - `a || a = a`
 *  |   - `a && a = a`
 *  | - Identity:
 *  |   - `a || ff = a`
 *  |   - `a && tt = a`
 *  | - Implication:
 *  |   - ``a `implies` a = tt``
 *  |   - ``a && (a `implies` b) = a && b``
 *  |   - ``b && (a `implies` b) = b``
 *  |   - ``a `implies` (b && c) = (a `implies` b) && (a `implies` c)``
 *  | - Complemented:
 *  |   - ``not a = a `implies` ff``
 */  
  var not = function (dict) {
      return dict.not;
  };

  /**
 *  | The `HeytingAlgebra` type class represents types are bounded lattices with
 *  | an implication operator such that the following laws hold:
 *  |
 *  | - Associativity:
 *  |   - `a || (b || c) = (a || b) || c`
 *  |   - `a && (b && c) = (a && b) && c`
 *  | - Commutativity:
 *  |   - `a || b = b || a`
 *  |   - `a && b = b && a`
 *  | - Absorption:
 *  |   - `a || (a && b) = a`
 *  |   - `a && (a || b) = a`
 *  | - Idempotent:
 *  |   - `a || a = a`
 *  |   - `a && a = a`
 *  | - Identity:
 *  |   - `a || ff = a`
 *  |   - `a && tt = a`
 *  | - Implication:
 *  |   - ``a `implies` a = tt``
 *  |   - ``a && (a `implies` b) = a && b``
 *  |   - ``b && (a `implies` b) = b``
 *  |   - ``a `implies` (b && c) = (a `implies` b) && (a `implies` c)``
 *  | - Complemented:
 *  |   - ``not a = a `implies` ff``
 */  
  var implies = function (dict) {
      return dict.implies;
  };                 

  /**
 *  | The `HeytingAlgebra` type class represents types are bounded lattices with
 *  | an implication operator such that the following laws hold:
 *  |
 *  | - Associativity:
 *  |   - `a || (b || c) = (a || b) || c`
 *  |   - `a && (b && c) = (a && b) && c`
 *  | - Commutativity:
 *  |   - `a || b = b || a`
 *  |   - `a && b = b && a`
 *  | - Absorption:
 *  |   - `a || (a && b) = a`
 *  |   - `a && (a || b) = a`
 *  | - Idempotent:
 *  |   - `a || a = a`
 *  |   - `a && a = a`
 *  | - Identity:
 *  |   - `a || ff = a`
 *  |   - `a && tt = a`
 *  | - Implication:
 *  |   - ``a `implies` a = tt``
 *  |   - ``a && (a `implies` b) = a && b``
 *  |   - ``b && (a `implies` b) = b``
 *  |   - ``a `implies` (b && c) = (a `implies` b) && (a `implies` c)``
 *  | - Complemented:
 *  |   - ``not a = a `implies` ff``
 */  
  var ff = function (dict) {
      return dict.ff;
  };

  /**
 *  | The `HeytingAlgebra` type class represents types are bounded lattices with
 *  | an implication operator such that the following laws hold:
 *  |
 *  | - Associativity:
 *  |   - `a || (b || c) = (a || b) || c`
 *  |   - `a && (b && c) = (a && b) && c`
 *  | - Commutativity:
 *  |   - `a || b = b || a`
 *  |   - `a && b = b && a`
 *  | - Absorption:
 *  |   - `a || (a && b) = a`
 *  |   - `a && (a || b) = a`
 *  | - Idempotent:
 *  |   - `a || a = a`
 *  |   - `a && a = a`
 *  | - Identity:
 *  |   - `a || ff = a`
 *  |   - `a && tt = a`
 *  | - Implication:
 *  |   - ``a `implies` a = tt``
 *  |   - ``a && (a `implies` b) = a && b``
 *  |   - ``b && (a `implies` b) = b``
 *  |   - ``a `implies` (b && c) = (a `implies` b) && (a `implies` c)``
 *  | - Complemented:
 *  |   - ``not a = a `implies` ff``
 */  
  var disj = function (dict) {
      return dict.disj;
  };
  var heytingAlgebraBoolean = new HeytingAlgebra($foreign.boolConj, $foreign.boolDisj, false, function (a) {
      return function (b) {
          return disj(heytingAlgebraBoolean)(not(heytingAlgebraBoolean)(a))(b);
      };
  }, $foreign.boolNot, true);

  /**
 *  | The `HeytingAlgebra` type class represents types are bounded lattices with
 *  | an implication operator such that the following laws hold:
 *  |
 *  | - Associativity:
 *  |   - `a || (b || c) = (a || b) || c`
 *  |   - `a && (b && c) = (a && b) && c`
 *  | - Commutativity:
 *  |   - `a || b = b || a`
 *  |   - `a && b = b && a`
 *  | - Absorption:
 *  |   - `a || (a && b) = a`
 *  |   - `a && (a || b) = a`
 *  | - Idempotent:
 *  |   - `a || a = a`
 *  |   - `a && a = a`
 *  | - Identity:
 *  |   - `a || ff = a`
 *  |   - `a && tt = a`
 *  | - Implication:
 *  |   - ``a `implies` a = tt``
 *  |   - ``a && (a `implies` b) = a && b``
 *  |   - ``b && (a `implies` b) = b``
 *  |   - ``a `implies` (b && c) = (a `implies` b) && (a `implies` c)``
 *  | - Complemented:
 *  |   - ``not a = a `implies` ff``
 */  
  var conj = function (dict) {
      return dict.conj;
  };
  exports["HeytingAlgebra"] = HeytingAlgebra;
  exports["conj"] = conj;
  exports["disj"] = disj;
  exports["ff"] = ff;
  exports["implies"] = implies;
  exports["not"] = not;
  exports["tt"] = tt;
  exports["heytingAlgebraBoolean"] = heytingAlgebraBoolean;
})(PS["Data.HeytingAlgebra"] = PS["Data.HeytingAlgebra"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Comonad = PS["Control.Comonad"];
  var Control_Extend = PS["Control.Extend"];
  var Data_Functor_Invariant = PS["Data.Functor.Invariant"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Newtype = PS["Data.Newtype"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Bounded = PS["Data.Bounded"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad = PS["Control.Monad"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Semiring = PS["Data.Semiring"];        

  /**
 *  | Monoid under conjuntion.
 *  |
 *  | ``` purescript
 *  | Conj x <> Conj y == Conj (x && y)
 *  | mempty :: Conj _ == Conj top
 *  | ```
 */  
  var Conj = function (x) {
      return x;
  };
  var semigroupConj = function (dictHeytingAlgebra) {
      return new Data_Semigroup.Semigroup(function (v) {
          return function (v1) {
              return Data_HeytingAlgebra.conj(dictHeytingAlgebra)(v)(v1);
          };
      });
  };
  var newtypeConj = new Data_Newtype.Newtype(function (n) {
      return n;
  }, Conj);
  var monoidConj = function (dictHeytingAlgebra) {
      return new Data_Monoid.Monoid(function () {
          return semigroupConj(dictHeytingAlgebra);
      }, Data_HeytingAlgebra.tt(dictHeytingAlgebra));
  };
  exports["Conj"] = Conj;
  exports["newtypeConj"] = newtypeConj;
  exports["semigroupConj"] = semigroupConj;
  exports["monoidConj"] = monoidConj;
})(PS["Data.Monoid.Conj"] = PS["Data.Monoid.Conj"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Comonad = PS["Control.Comonad"];
  var Control_Extend = PS["Control.Extend"];
  var Data_Functor_Invariant = PS["Data.Functor.Invariant"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Newtype = PS["Data.Newtype"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Bounded = PS["Data.Bounded"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad = PS["Control.Monad"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Semiring = PS["Data.Semiring"];        

  /**
 *  | Monoid under disjuntion.
 *  |
 *  | ``` purescript
 *  | Disj x <> Disj y == Disj (x || y)
 *  | mempty :: Disj _ == Disj bottom
 *  | ```
 */  
  var Disj = function (x) {
      return x;
  };
  var semigroupDisj = function (dictHeytingAlgebra) {
      return new Data_Semigroup.Semigroup(function (v) {
          return function (v1) {
              return Data_HeytingAlgebra.disj(dictHeytingAlgebra)(v)(v1);
          };
      });
  };
  var newtypeDisj = new Data_Newtype.Newtype(function (n) {
      return n;
  }, Disj);
  var monoidDisj = function (dictHeytingAlgebra) {
      return new Data_Monoid.Monoid(function () {
          return semigroupDisj(dictHeytingAlgebra);
      }, Data_HeytingAlgebra.ff(dictHeytingAlgebra));
  };
  exports["Disj"] = Disj;
  exports["newtypeDisj"] = newtypeDisj;
  exports["semigroupDisj"] = semigroupDisj;
  exports["monoidDisj"] = monoidDisj;
})(PS["Data.Monoid.Disj"] = PS["Data.Monoid.Disj"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Data.Foldable"];
  var Prelude = PS["Prelude"];
  var Control_Plus = PS["Control.Plus"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Maybe_First = PS["Data.Maybe.First"];
  var Data_Maybe_Last = PS["Data.Maybe.Last"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Monoid_Additive = PS["Data.Monoid.Additive"];
  var Data_Monoid_Conj = PS["Data.Monoid.Conj"];
  var Data_Monoid_Disj = PS["Data.Monoid.Disj"];
  var Data_Monoid_Dual = PS["Data.Monoid.Dual"];
  var Data_Monoid_Endo = PS["Data.Monoid.Endo"];
  var Data_Monoid_Multiplicative = PS["Data.Monoid.Multiplicative"];
  var Data_Newtype = PS["Data.Newtype"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Function = PS["Data.Function"];
  var Control_Category = PS["Control.Category"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ordering = PS["Data.Ordering"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Semiring = PS["Data.Semiring"];
  var Data_Functor = PS["Data.Functor"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];        

  /**
 *  | `Foldable` represents data structures which can be _folded_.
 *  |
 *  | - `foldr` folds a structure from the right
 *  | - `foldl` folds a structure from the left
 *  | - `foldMap` folds a structure by accumulating values in a `Monoid`
 *  |
 *  | Default implementations are provided by the following functions:
 *  |
 *  | - `foldrDefault`
 *  | - `foldlDefault`
 *  | - `foldMapDefaultR`
 *  | - `foldMapDefaultL`
 *  |
 *  | Note: some combinations of the default implementations are unsafe to
 *  | use together - causing a non-terminating mutually recursive cycle.
 *  | These combinations are documented per function.
 */  
  var Foldable = function (foldMap, foldl, foldr) {
      this.foldMap = foldMap;
      this.foldl = foldl;
      this.foldr = foldr;
  };

  /**
 *  | `Foldable` represents data structures which can be _folded_.
 *  |
 *  | - `foldr` folds a structure from the right
 *  | - `foldl` folds a structure from the left
 *  | - `foldMap` folds a structure by accumulating values in a `Monoid`
 *  |
 *  | Default implementations are provided by the following functions:
 *  |
 *  | - `foldrDefault`
 *  | - `foldlDefault`
 *  | - `foldMapDefaultR`
 *  | - `foldMapDefaultL`
 *  |
 *  | Note: some combinations of the default implementations are unsafe to
 *  | use together - causing a non-terminating mutually recursive cycle.
 *  | These combinations are documented per function.
 */  
  var foldr = function (dict) {
      return dict.foldr;
  };

  /**
 *  | Traverse a data structure, performing some effects encoded by an
 *  | `Applicative` functor at each value, ignoring the final result.
 *  |
 *  | For example:
 *  |
 *  | ```purescript
 *  | traverse_ print [1, 2, 3]
 *  | ```
 */  
  var traverse_ = function (dictApplicative) {
      return function (dictFoldable) {
          return function (f) {
              return foldr(dictFoldable)(function ($169) {
                  return Control_Apply.applySecond(dictApplicative["__superclass_Control.Apply.Apply_0"]())(f($169));
              })(Control_Applicative.pure(dictApplicative)(Data_Unit.unit));
          };
      };
  };

  /**
 *  | A version of `traverse_` with its arguments flipped.
 *  |
 *  | This can be useful when running an action written using do notation
 *  | for every element in a data structure:
 *  |
 *  | For example:
 *  |
 *  | ```purescript
 *  | for_ [1, 2, 3] \n -> do
 *  |   print n
 *  |   trace "squared is"
 *  |   print (n * n)
 *  | ```
 */  
  var for_ = function (dictApplicative) {
      return function (dictFoldable) {
          return Data_Function.flip(traverse_(dictApplicative)(dictFoldable));
      };
  };

  /**
 *  | `Foldable` represents data structures which can be _folded_.
 *  |
 *  | - `foldr` folds a structure from the right
 *  | - `foldl` folds a structure from the left
 *  | - `foldMap` folds a structure by accumulating values in a `Monoid`
 *  |
 *  | Default implementations are provided by the following functions:
 *  |
 *  | - `foldrDefault`
 *  | - `foldlDefault`
 *  | - `foldMapDefaultR`
 *  | - `foldMapDefaultL`
 *  |
 *  | Note: some combinations of the default implementations are unsafe to
 *  | use together - causing a non-terminating mutually recursive cycle.
 *  | These combinations are documented per function.
 */  
  var foldl = function (dict) {
      return dict.foldl;
  };

  /**
 *  | Fold a data structure, accumulating values in some `Monoid`,
 *  | combining adjacent elements using the specified separator.
 */  
  var intercalate = function (dictFoldable) {
      return function (dictMonoid) {
          return function (sep) {
              return function (xs) {
                  var go = function (v) {
                      return function (x) {
                          if (v.init) {
                              return {
                                  init: false, 
                                  acc: x
                              };
                          };
                          return {
                              init: false, 
                              acc: Data_Semigroup.append(dictMonoid["__superclass_Data.Semigroup.Semigroup_0"]())(v.acc)(Data_Semigroup.append(dictMonoid["__superclass_Data.Semigroup.Semigroup_0"]())(sep)(x))
                          };
                      };
                  };
                  return (foldl(dictFoldable)(go)({
                      init: true, 
                      acc: Data_Monoid.mempty(dictMonoid)
                  })(xs)).acc;
              };
          };
      };
  };

  /**
 *  | Find the largest element of a structure, according to a given comparison
 *  | function. The comparison function should represent a total ordering (see
 *  | the `Ord` type class laws); if it does not, the behaviour is undefined.
 */  
  var maximumBy = function (dictFoldable) {
      return function (cmp) {
          var max$prime = function (v) {
              return function (v1) {
                  if (v instanceof Data_Maybe.Nothing) {
                      return new Data_Maybe.Just(v1);
                  };
                  if (v instanceof Data_Maybe.Just) {
                      return new Data_Maybe.Just((function () {
                          var $92 = Data_Eq.eq(Data_Ordering.eqOrdering)(cmp(v.value0)(v1))(Data_Ordering.GT.value);
                          if ($92) {
                              return v.value0;
                          };
                          if (!$92) {
                              return v1;
                          };
                          throw new Error("Failed pattern match at Data.Foldable line 291, column 27 - line 291, column 57: " + [ $92.constructor.name ]);
                      })());
                  };
                  throw new Error("Failed pattern match at Data.Foldable line 290, column 3 - line 290, column 27: " + [ v.constructor.name, v1.constructor.name ]);
              };
          };
          return foldl(dictFoldable)(max$prime)(Data_Maybe.Nothing.value);
      };
  };

  /**
 *  | Find the largest element of a structure, according to its `Ord` instance.
 */  
  var maximum = function (dictOrd) {
      return function (dictFoldable) {
          return maximumBy(dictFoldable)(Data_Ord.compare(dictOrd));
      };
  }; 

  /**
 *  | A default implementation of `foldMap` using `foldr`.
 *  |
 *  | Note: when defining a `Foldable` instance, this function is unsafe to use
 *  | in combination with `foldrDefault`.
 */  
  var foldMapDefaultR = function (dictFoldable) {
      return function (dictMonoid) {
          return function (f) {
              return function (xs) {
                  return foldr(dictFoldable)(function (x) {
                      return function (acc) {
                          return Data_Semigroup.append(dictMonoid["__superclass_Data.Semigroup.Semigroup_0"]())(f(x))(acc);
                      };
                  })(Data_Monoid.mempty(dictMonoid))(xs);
              };
          };
      };
  };
  var foldableArray = new Foldable(function (dictMonoid) {
      return foldMapDefaultR(foldableArray)(dictMonoid);
  }, $foreign.foldlArray, $foreign.foldrArray);

  /**
 *  | `Foldable` represents data structures which can be _folded_.
 *  |
 *  | - `foldr` folds a structure from the right
 *  | - `foldl` folds a structure from the left
 *  | - `foldMap` folds a structure by accumulating values in a `Monoid`
 *  |
 *  | Default implementations are provided by the following functions:
 *  |
 *  | - `foldrDefault`
 *  | - `foldlDefault`
 *  | - `foldMapDefaultR`
 *  | - `foldMapDefaultL`
 *  |
 *  | Note: some combinations of the default implementations are unsafe to
 *  | use together - causing a non-terminating mutually recursive cycle.
 *  | These combinations are documented per function.
 */  
  var foldMap = function (dict) {
      return dict.foldMap;
  };

  /**
 *  | Fold a data structure, accumulating values in some `Monoid`.
 */  
  var fold = function (dictFoldable) {
      return function (dictMonoid) {
          return foldMap(dictFoldable)(dictMonoid)(Control_Category.id(Control_Category.categoryFn));
      };
  };

  /**
 *  | Try to find an element in a data structure which satisfies a predicate.
 */  
  var find = function (dictFoldable) {
      return function (p) {
          var go = function (v) {
              return function (v1) {
                  if (v instanceof Data_Maybe.Nothing && p(v1)) {
                      return new Data_Maybe.Just(v1);
                  };
                  return v;
              };
          };
          return foldl(dictFoldable)(go)(Data_Maybe.Nothing.value);
      };
  };

  /**
 *  | `any f` is the same as `or <<< map f`; map a function over the structure,
 *  | and then get the disjunction of the results.
 */  
  var any = function (dictFoldable) {
      return function (dictHeytingAlgebra) {
          return function (p) {
              return Data_Newtype.alaF(Data_Functor.functorFn)(Data_Functor.functorFn)(Data_Monoid_Disj.newtypeDisj)(Data_Monoid_Disj.newtypeDisj)(Data_Monoid_Disj.Disj)(foldMap(dictFoldable)(Data_Monoid_Disj.monoidDisj(dictHeytingAlgebra)))(p);
          };
      };
  };

  /**
 *  | Test whether a value is an element of a data structure.
 */  
  var elem = function (dictFoldable) {
      return function (dictEq) {
          return function ($172) {
              return any(dictFoldable)(Data_HeytingAlgebra.heytingAlgebraBoolean)(Data_Eq.eq(dictEq)($172));
          };
      };
  };

  /**
 *  | Test whether a value is not an element of a data structure.
 */  
  var notElem = function (dictFoldable) {
      return function (dictEq) {
          return function (x) {
              return function ($173) {
                  return !elem(dictFoldable)(dictEq)(x)($173);
              };
          };
      };
  };

  /**
 *  | `all f` is the same as `and <<< map f`; map a function over the structure,
 *  | and then get the conjunction of the results.
 */  
  var all = function (dictFoldable) {
      return function (dictHeytingAlgebra) {
          return function (p) {
              return Data_Newtype.alaF(Data_Functor.functorFn)(Data_Functor.functorFn)(Data_Monoid_Conj.newtypeConj)(Data_Monoid_Conj.newtypeConj)(Data_Monoid_Conj.Conj)(foldMap(dictFoldable)(Data_Monoid_Conj.monoidConj(dictHeytingAlgebra)))(p);
          };
      };
  };
  exports["Foldable"] = Foldable;
  exports["all"] = all;
  exports["any"] = any;
  exports["elem"] = elem;
  exports["find"] = find;
  exports["fold"] = fold;
  exports["foldMap"] = foldMap;
  exports["foldMapDefaultR"] = foldMapDefaultR;
  exports["foldl"] = foldl;
  exports["foldr"] = foldr;
  exports["for_"] = for_;
  exports["intercalate"] = intercalate;
  exports["maximum"] = maximum;
  exports["maximumBy"] = maximumBy;
  exports["notElem"] = notElem;
  exports["traverse_"] = traverse_;
  exports["foldableArray"] = foldableArray;
})(PS["Data.Foldable"] = PS["Data.Foldable"] || {});
(function(exports) {
    "use strict";

  // jshint maxparams: 3

  exports.traverseArrayImpl = function () {
    function Cont(fn) {
      this.fn = fn;
    }

    var emptyList = {};

    var ConsCell = function (head, tail) {
      this.head = head;
      this.tail = tail;
    };

    function consList(x) {
      return function (xs) {
        return new ConsCell(x, xs);
      };
    }

    function listToArray(list) {
      var arr = [];
      while (list !== emptyList) {
        arr.push(list.head);
        list = list.tail;
      }
      return arr;
    }

    return function (apply) {
      return function (map) {
        return function (pure) {
          return function (f) {
            var buildFrom = function (x, ys) {
              return apply(map(consList)(f(x)))(ys);
            };

            var go = function (acc, currentLen, xs) {
              if (currentLen === 0) {
                return acc;
              } else {
                var last = xs[currentLen - 1];
                return new Cont(function () {
                  return go(buildFrom(last, acc), currentLen - 1, xs);
                });
              }
            };

            return function (array) {
              var result = go(pure(emptyList), array.length, array);
              while (result instanceof Cont) {
                result = result.fn();
              }

              return map(listToArray)(result);
            };
          };
        };
      };
    };
  }();
})(PS["Data.Traversable"] = PS["Data.Traversable"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Data.Traversable"];
  var Prelude = PS["Prelude"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Maybe_First = PS["Data.Maybe.First"];
  var Data_Maybe_Last = PS["Data.Maybe.Last"];
  var Data_Monoid_Additive = PS["Data.Monoid.Additive"];
  var Data_Monoid_Conj = PS["Data.Monoid.Conj"];
  var Data_Monoid_Disj = PS["Data.Monoid.Disj"];
  var Data_Monoid_Dual = PS["Data.Monoid.Dual"];
  var Data_Monoid_Multiplicative = PS["Data.Monoid.Multiplicative"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Category = PS["Control.Category"];

  /**
 *  | `Traversable` represents data structures which can be _traversed_,
 *  | accumulating results and effects in some `Applicative` functor.
 *  |
 *  | - `traverse` runs an action for every element in a data structure,
 *  |   and accumulates the results.
 *  | - `sequence` runs the actions _contained_ in a data structure,
 *  |   and accumulates the results.
 *  |
 *  | The `traverse` and `sequence` functions should be compatible in the
 *  | following sense:
 *  |
 *  | - `traverse f xs = sequence (f <$> xs)`
 *  | - `sequence = traverse id`
 *  |
 *  | `Traversable` instances should also be compatible with the corresponding
 *  | `Foldable` instances, in the following sense:
 *  |
 *  | - `foldMap f = runConst <<< traverse (Const <<< f)`
 *  |
 *  | Default implementations are provided by the following functions:
 *  |
 *  | - `traverseDefault`
 *  | - `sequenceDefault`
 */  
  var Traversable = function (__superclass_Data$dotFoldable$dotFoldable_1, __superclass_Data$dotFunctor$dotFunctor_0, sequence, traverse) {
      this["__superclass_Data.Foldable.Foldable_1"] = __superclass_Data$dotFoldable$dotFoldable_1;
      this["__superclass_Data.Functor.Functor_0"] = __superclass_Data$dotFunctor$dotFunctor_0;
      this.sequence = sequence;
      this.traverse = traverse;
  };

  /**
 *  | `Traversable` represents data structures which can be _traversed_,
 *  | accumulating results and effects in some `Applicative` functor.
 *  |
 *  | - `traverse` runs an action for every element in a data structure,
 *  |   and accumulates the results.
 *  | - `sequence` runs the actions _contained_ in a data structure,
 *  |   and accumulates the results.
 *  |
 *  | The `traverse` and `sequence` functions should be compatible in the
 *  | following sense:
 *  |
 *  | - `traverse f xs = sequence (f <$> xs)`
 *  | - `sequence = traverse id`
 *  |
 *  | `Traversable` instances should also be compatible with the corresponding
 *  | `Foldable` instances, in the following sense:
 *  |
 *  | - `foldMap f = runConst <<< traverse (Const <<< f)`
 *  |
 *  | Default implementations are provided by the following functions:
 *  |
 *  | - `traverseDefault`
 *  | - `sequenceDefault`
 */  
  var traverse = function (dict) {
      return dict.traverse;
  };

  /**
 *  | A default implementation of `sequence` using `traverse`.
 */  
  var sequenceDefault = function (dictTraversable) {
      return function (dictApplicative) {
          return function (tma) {
              return traverse(dictTraversable)(dictApplicative)(Control_Category.id(Control_Category.categoryFn))(tma);
          };
      };
  };
  var traversableArray = new Traversable(function () {
      return Data_Foldable.foldableArray;
  }, function () {
      return Data_Functor.functorArray;
  }, function (dictApplicative) {
      return sequenceDefault(traversableArray)(dictApplicative);
  }, function (dictApplicative) {
      return $foreign.traverseArrayImpl(Control_Apply.apply(dictApplicative["__superclass_Control.Apply.Apply_0"]()))(Data_Functor.map((dictApplicative["__superclass_Control.Apply.Apply_0"]())["__superclass_Data.Functor.Functor_0"]()))(Control_Applicative.pure(dictApplicative));
  });

  /**
 *  | `Traversable` represents data structures which can be _traversed_,
 *  | accumulating results and effects in some `Applicative` functor.
 *  |
 *  | - `traverse` runs an action for every element in a data structure,
 *  |   and accumulates the results.
 *  | - `sequence` runs the actions _contained_ in a data structure,
 *  |   and accumulates the results.
 *  |
 *  | The `traverse` and `sequence` functions should be compatible in the
 *  | following sense:
 *  |
 *  | - `traverse f xs = sequence (f <$> xs)`
 *  | - `sequence = traverse id`
 *  |
 *  | `Traversable` instances should also be compatible with the corresponding
 *  | `Foldable` instances, in the following sense:
 *  |
 *  | - `foldMap f = runConst <<< traverse (Const <<< f)`
 *  |
 *  | Default implementations are provided by the following functions:
 *  |
 *  | - `traverseDefault`
 *  | - `sequenceDefault`
 */  
  var sequence = function (dict) {
      return dict.sequence;
  }; 

  /**
 *  | A version of `traverse` with its arguments flipped.
 *  |
 *  |
 *  | This can be useful when running an action written using do notation
 *  | for every element in a data structure:
 *  |
 *  | For example:
 *  |
 *  | ```purescript
 *  | for [1, 2, 3] \n -> do
 *  |   print n
 *  |   return (n * n)
 *  | ```
 */  
  var $$for = function (dictApplicative) {
      return function (dictTraversable) {
          return function (x) {
              return function (f) {
                  return traverse(dictTraversable)(dictApplicative)(f)(x);
              };
          };
      };
  };
  exports["Traversable"] = Traversable;
  exports["for"] = $$for;
  exports["sequence"] = sequence;
  exports["sequenceDefault"] = sequenceDefault;
  exports["traverse"] = traverse;
  exports["traversableArray"] = traversableArray;
})(PS["Data.Traversable"] = PS["Data.Traversable"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Extend = PS["Control.Extend"];
  var Data_Bifoldable = PS["Data.Bifoldable"];
  var Data_Bifunctor = PS["Data.Bifunctor"];
  var Data_Bitraversable = PS["Data.Bitraversable"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Functor_Invariant = PS["Data.Functor.Invariant"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad = PS["Control.Monad"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Ordering = PS["Data.Ordering"];
  var Data_Bounded = PS["Data.Bounded"];
  var Data_Semiring = PS["Data.Semiring"];
  var Data_Function = PS["Data.Function"];        

  /**
 *  | The `Either` type is used to represent a choice between two types of value.
 *  |
 *  | A common use case for `Either` is error handling, where `Left` is used to
 *  | carry an error value and `Right` is used to carry a success value.
 */  
  var Left = (function () {
      function Left(value0) {
          this.value0 = value0;
      };
      Left.create = function (value0) {
          return new Left(value0);
      };
      return Left;
  })();

  /**
 *  | The `Either` type is used to represent a choice between two types of value.
 *  |
 *  | A common use case for `Either` is error handling, where `Left` is used to
 *  | carry an error value and `Right` is used to carry a success value.
 */  
  var Right = (function () {
      function Right(value0) {
          this.value0 = value0;
      };
      Right.create = function (value0) {
          return new Right(value0);
      };
      return Right;
  })();

  /**
 *  | The `Functor` instance allows functions to transform the contents of a
 *  | `Right` with the `<$>` operator:
 *  |
 *  | ``` purescript
 *  | f <$> Right x == Right (f x)
 *  | ```
 *  |
 *  | `Left` values are untouched:
 *  |
 *  | ``` purescript
 *  | f <$> Left y == Left y
 *  | ```
 */  
  var functorEither = new Data_Functor.Functor(function (v) {
      return function (v1) {
          if (v1 instanceof Left) {
              return new Left(v1.value0);
          };
          if (v1 instanceof Right) {
              return new Right(v(v1.value0));
          };
          throw new Error("Failed pattern match at Data.Either line 35, column 3 - line 35, column 26: " + [ v.constructor.name, v1.constructor.name ]);
      };
  });

  /**
 *  | Takes two functions and an `Either` value, if the value is a `Left` the
 *  | inner value is applied to the first function, if the value is a `Right`
 *  | the inner value is applied to the second function.
 *  |
 *  | ``` purescript
 *  | either f g (Left x) == f x
 *  | either f g (Right y) == g y
 *  | ```
 */  
  var either = function (v) {
      return function (v1) {
          return function (v2) {
              if (v2 instanceof Left) {
                  return v(v2.value0);
              };
              if (v2 instanceof Right) {
                  return v1(v2.value0);
              };
              throw new Error("Failed pattern match at Data.Either line 224, column 1 - line 224, column 26: " + [ v.constructor.name, v1.constructor.name, v2.constructor.name ]);
          };
      };
  };
  var bifunctorEither = new Data_Bifunctor.Bifunctor(function (v) {
      return function (v1) {
          return function (v2) {
              if (v2 instanceof Left) {
                  return new Left(v(v2.value0));
              };
              if (v2 instanceof Right) {
                  return new Right(v1(v2.value0));
              };
              throw new Error("Failed pattern match at Data.Either line 42, column 3 - line 42, column 34: " + [ v.constructor.name, v1.constructor.name, v2.constructor.name ]);
          };
      };
  });

  /**
 *  | The `Apply` instance allows functions contained within a `Right` to
 *  | transform a value contained within a `Right` using the `(<*>)` operator:
 *  |
 *  | ``` purescript
 *  | Right f <*> Right x == Right (f x)
 *  | ```
 *  |
 *  | `Left` values are left untouched:
 *  |
 *  | ``` purescript
 *  | Left f <*> Right x == Left x
 *  | Right f <*> Left y == Left y
 *  | ```
 *  |
 *  | Combining `Functor`'s `<$>` with `Apply`'s `<*>` can be used to transform a
 *  | pure function to take `Either`-typed arguments so `f :: a -> b -> c`
 *  | becomes `f :: Either l a -> Either l b -> Either l c`:
 *  |
 *  | ``` purescript
 *  | f <$> Right x <*> Right y == Right (f x y)
 *  | ```
 *  |
 *  | The `Left`-preserving behaviour of both operators means the result of
 *  | an expression like the above but where any one of the values is `Left`
 *  | means the whole result becomes `Left` also, taking the first `Left` value
 *  | found:
 *  |
 *  | ``` purescript
 *  | f <$> Left x <*> Right y == Left x
 *  | f <$> Right x <*> Left y == Left y
 *  | f <$> Left x <*> Left y == Left x
 *  | ```
 */  
  var applyEither = new Control_Apply.Apply(function () {
      return functorEither;
  }, function (v) {
      return function (v1) {
          if (v instanceof Left) {
              return new Left(v.value0);
          };
          if (v instanceof Right) {
              return Data_Functor.map(functorEither)(v.value0)(v1);
          };
          throw new Error("Failed pattern match at Data.Either line 78, column 3 - line 78, column 28: " + [ v.constructor.name, v1.constructor.name ]);
      };
  });

  /**
 *  | The `Applicative` instance enables lifting of values into `Either` with the
 *  | `pure` function:
 *  |
 *  | ``` purescript
 *  | pure x :: Either _ _ == Right x
 *  | ```
 *  |
 *  | Combining `Functor`'s `<$>` with `Apply`'s `<*>` and `Applicative`'s
 *  | `pure` can be used to pass a mixture of `Either` and non-`Either` typed
 *  | values to a function that does not usually expect them, by using `pure`
 *  | for any value that is not already `Either` typed:
 *  |
 *  | ``` purescript
 *  | f <$> Right x <*> pure y == Right (f x y)
 *  | ```
 *  |
 *  | Even though `pure = Right` it is recommended to use `pure` in situations
 *  | like this as it allows the choice of `Applicative` to be changed later
 *  | without having to go through and replace `Right` with a new constructor.
 */  
  var applicativeEither = new Control_Applicative.Applicative(function () {
      return applyEither;
  }, Right.create);
  exports["Left"] = Left;
  exports["Right"] = Right;
  exports["either"] = either;
  exports["functorEither"] = functorEither;
  exports["bifunctorEither"] = bifunctorEither;
  exports["applyEither"] = applyEither;
  exports["applicativeEither"] = applicativeEither;
})(PS["Data.Either"] = PS["Data.Either"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines an effect, actions and handlers for working
 *  | with JavaScript exceptions.
 */  
  "use strict";
  var $foreign = PS["Control.Monad.Eff.Exception"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Either = PS["Data.Either"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Show = PS["Data.Show"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Functor = PS["Data.Functor"];
  exports["catchException"] = $foreign.catchException;
  exports["error"] = $foreign.error;
  exports["message"] = $foreign.message;
  exports["throwException"] = $foreign.throwException;
})(PS["Control.Monad.Eff.Exception"] = PS["Control.Monad.Eff.Exception"] || {});
(function(exports) {
    "use strict";

  exports.runFn2 = function (fn) {
    return function (a) {
      return function (b) {
        return fn(a, b);
      };
    };
  };

  exports.runFn4 = function (fn) {
    return function (a) {
      return function (b) {
        return function (c) {
          return function (d) {
            return fn(a, b, c, d);
          };
        };
      };
    };
  };
})(PS["Data.Function.Uncurried"] = PS["Data.Function.Uncurried"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Data.Function.Uncurried"];
  var Data_Unit = PS["Data.Unit"];
  exports["runFn2"] = $foreign.runFn2;
  exports["runFn4"] = $foreign.runFn4;
})(PS["Data.Function.Uncurried"] = PS["Data.Function.Uncurried"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Control.Monad.Aff.Internal"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  exports["_makeVar"] = $foreign._makeVar;
  exports["_peekVar"] = $foreign._peekVar;
  exports["_putVar"] = $foreign._putVar;
  exports["_takeVar"] = $foreign._takeVar;
})(PS["Control.Monad.Aff.Internal"] = PS["Control.Monad.Aff.Internal"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Control_Category = PS["Control.Category"];
  var Control_Monad = PS["Control.Monad"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];        

  /**
 *  | The `MonadEff` class captures those monads which support native effects.
 *  |
 *  | Instances are provided for `Eff` itself, and the standard monad
 *  | transformers.
 *  |
 *  | `liftEff` can be used in any appropriate monad transformer stack to lift an
 *  | action of type `Eff eff a` into the monad.
 *  |
 *  | Note that `MonadEff` is parameterized by the row of effects, so type
 *  | inference can be tricky. It is generally recommended to either work with a
 *  | polymorphic row of effects, or a concrete, closed row of effects such as
 *  | `(trace :: Trace)`.
 */  
  var MonadEff = function (__superclass_Control$dotMonad$dotMonad_0, liftEff) {
      this["__superclass_Control.Monad.Monad_0"] = __superclass_Control$dotMonad$dotMonad_0;
      this.liftEff = liftEff;
  };                                                   

  /**
 *  | The `MonadEff` class captures those monads which support native effects.
 *  |
 *  | Instances are provided for `Eff` itself, and the standard monad
 *  | transformers.
 *  |
 *  | `liftEff` can be used in any appropriate monad transformer stack to lift an
 *  | action of type `Eff eff a` into the monad.
 *  |
 *  | Note that `MonadEff` is parameterized by the row of effects, so type
 *  | inference can be tricky. It is generally recommended to either work with a
 *  | polymorphic row of effects, or a concrete, closed row of effects such as
 *  | `(trace :: Trace)`.
 */  
  var liftEff = function (dict) {
      return dict.liftEff;
  };
  exports["MonadEff"] = MonadEff;
  exports["liftEff"] = liftEff;
})(PS["Control.Monad.Eff.Class"] = PS["Control.Monad.Eff.Class"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines the `MonadError` type class and its instances.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Either = PS["Data.Either"];
  var Data_Function = PS["Data.Function"];
  var Data_Unit = PS["Data.Unit"];        

  /**
 *  | The `MonadError` type class represents those monads which support errors via
 *  | `throwError` and `catchError`.
 *  |
 *  | - `throwError e` throws the error `e`
 *  | - `catchError x f` calls the error handler `f` if an error is thrown during the
 *  |   evaluation of `x`.
 *  |
 *  | An implementation is provided for `ErrorT`, and for other monad transformers
 *  | defined in this library.
 *  |
 *  | Laws:
 *  |
 *  | - Left zero: `throwError e >>= f = throwError e`
 *  | - Catch: `catchError (throwError e) f = f e`
 *  | - Pure: `catchError (pure a) f = pure a`
 *  |
 */  
  var MonadError = function (__superclass_Control$dotMonad$dotMonad_0, catchError, throwError) {
      this["__superclass_Control.Monad.Monad_0"] = __superclass_Control$dotMonad$dotMonad_0;
      this.catchError = catchError;
      this.throwError = throwError;
  };

  /**
 *  | The `MonadError` type class represents those monads which support errors via
 *  | `throwError` and `catchError`.
 *  |
 *  | - `throwError e` throws the error `e`
 *  | - `catchError x f` calls the error handler `f` if an error is thrown during the
 *  |   evaluation of `x`.
 *  |
 *  | An implementation is provided for `ErrorT`, and for other monad transformers
 *  | defined in this library.
 *  |
 *  | Laws:
 *  |
 *  | - Left zero: `throwError e >>= f = throwError e`
 *  | - Catch: `catchError (throwError e) f = f e`
 *  | - Pure: `catchError (pure a) f = pure a`
 *  |
 */  
  var throwError = function (dict) {
      return dict.throwError;
  };                          

  /**
 *  | The `MonadError` type class represents those monads which support errors via
 *  | `throwError` and `catchError`.
 *  |
 *  | - `throwError e` throws the error `e`
 *  | - `catchError x f` calls the error handler `f` if an error is thrown during the
 *  |   evaluation of `x`.
 *  |
 *  | An implementation is provided for `ErrorT`, and for other monad transformers
 *  | defined in this library.
 *  |
 *  | Laws:
 *  |
 *  | - Left zero: `throwError e >>= f = throwError e`
 *  | - Catch: `catchError (throwError e) f = f e`
 *  | - Pure: `catchError (pure a) f = pure a`
 *  |
 */  
  var catchError = function (dict) {
      return dict.catchError;
  };

  /**
 *  | This function allows you to provide a predicate for selecting the
 *  | exceptions that you're interested in, and handle only those exceptons.
 *  | If the inner computation throws an exception, and the predicate returns
 *  | Nothing, then the whole computation will still fail with that exception.
 */  
  var catchJust = function (dictMonadError) {
      return function (p) {
          return function (act) {
              return function (handler) {
                  var handle = function (e) {
                      var $12 = p(e);
                      if ($12 instanceof Data_Maybe.Nothing) {
                          return throwError(dictMonadError)(e);
                      };
                      if ($12 instanceof Data_Maybe.Just) {
                          return handler($12.value0);
                      };
                      throw new Error("Failed pattern match at Control.Monad.Error.Class line 44, column 5 - line 46, column 26: " + [ $12.constructor.name ]);
                  };
                  return catchError(dictMonadError)(act)(handle);
              };
          };
      };
  };
  exports["MonadError"] = MonadError;
  exports["catchError"] = catchError;
  exports["catchJust"] = catchJust;
  exports["throwError"] = throwError;
})(PS["Control.Monad.Error.Class"] = PS["Control.Monad.Error.Class"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | A data type and functions for working with ordered pairs.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Biapplicative = PS["Control.Biapplicative"];
  var Control_Biapply = PS["Control.Biapply"];
  var Control_Comonad = PS["Control.Comonad"];
  var Control_Extend = PS["Control.Extend"];
  var Control_Lazy = PS["Control.Lazy"];
  var Data_Bifoldable = PS["Data.Bifoldable"];
  var Data_Bifunctor = PS["Data.Bifunctor"];
  var Data_Bitraversable = PS["Data.Bitraversable"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Functor_Invariant = PS["Data.Functor.Invariant"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Maybe_First = PS["Data.Maybe.First"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Newtype = PS["Data.Newtype"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Ordering = PS["Data.Ordering"];
  var Data_Bounded = PS["Data.Bounded"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Semiring = PS["Data.Semiring"];
  var Data_Ring = PS["Data.Ring"];
  var Data_CommutativeRing = PS["Data.CommutativeRing"];
  var Data_BooleanAlgebra = PS["Data.BooleanAlgebra"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad = PS["Control.Monad"];
  var Data_Function = PS["Data.Function"];
  var Data_Unit = PS["Data.Unit"];        

  /**
 *  | A simple product type for wrapping a pair of component values.
 */  
  var Tuple = (function () {
      function Tuple(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      Tuple.create = function (value0) {
          return function (value1) {
              return new Tuple(value0, value1);
          };
      };
      return Tuple;
  })();

  /**
 *  | Returns the second component of a tuple.
 */  
  var snd = function (v) {
      return v.value1;
  };

  /**
 *  | Allows `Tuple`s to be rendered as a string with `show` whenever there are
 *  | `Show` instances for both component types.
 */  
  var showTuple = function (dictShow) {
      return function (dictShow1) {
          return new Data_Show.Show(function (v) {
              return "(Tuple " + (Data_Show.show(dictShow)(v.value0) + (" " + (Data_Show.show(dictShow1)(v.value1) + ")")));
          });
      };
  }; 

  /**
 *  | The `Semigroup` instance enables use of the associative operator `<>` on
 *  | `Tuple`s whenever there are `Semigroup` instances for the component
 *  | types. The `<>` operator is applied pairwise, so:
 *  | ```purescript
 *  | (Tuple a1 b1) <> (Tuple a2 b2) = Tuple (a1 <> a2) (b1 <> b2)
 *  | ```
 */  
  var semigroupTuple = function (dictSemigroup) {
      return function (dictSemigroup1) {
          return new Data_Semigroup.Semigroup(function (v) {
              return function (v1) {
                  return new Tuple(Data_Semigroup.append(dictSemigroup)(v.value0)(v1.value0), Data_Semigroup.append(dictSemigroup1)(v.value1)(v1.value1));
              };
          });
      };
  };
  var monoidTuple = function (dictMonoid) {
      return function (dictMonoid1) {
          return new Data_Monoid.Monoid(function () {
              return semigroupTuple(dictMonoid["__superclass_Data.Semigroup.Semigroup_0"]())(dictMonoid1["__superclass_Data.Semigroup.Semigroup_0"]());
          }, new Tuple(Data_Monoid.mempty(dictMonoid), Data_Monoid.mempty(dictMonoid1)));
      };
  };

  /**
 *  | Lookup a value in a data structure of `Tuple`s, generalizing association lists.
 */  
  var lookup = function (dictFoldable) {
      return function (dictEq) {
          return function (a) {
              return function ($255) {
                  return Data_Newtype.unwrap(Data_Maybe_First.newtypeFirst)(Data_Foldable.foldMap(dictFoldable)(Data_Maybe_First.monoidFirst)(function (v) {
                      var $135 = Data_Eq.eq(dictEq)(a)(v.value0);
                      if ($135) {
                          return new Data_Maybe.Just(v.value1);
                      };
                      if (!$135) {
                          return Data_Maybe.Nothing.value;
                      };
                      throw new Error("Failed pattern match at Data.Tuple line 170, column 55 - line 170, column 90: " + [ $135.constructor.name ]);
                  })($255));
              };
          };
      };
  };                                                                                                    

  /**
 *  | Returns the first component of a tuple.
 */  
  var fst = function (v) {
      return v.value0;
  };
  exports["Tuple"] = Tuple;
  exports["fst"] = fst;
  exports["lookup"] = lookup;
  exports["snd"] = snd;
  exports["showTuple"] = showTuple;
  exports["semigroupTuple"] = semigroupTuple;
  exports["monoidTuple"] = monoidTuple;
})(PS["Data.Tuple"] = PS["Data.Tuple"] || {});
(function(exports) {
    "use strict";

  // module Unsafe.Coerce

  exports.unsafeCoerce = function (x) {
    return x;
  };
})(PS["Unsafe.Coerce"] = PS["Unsafe.Coerce"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Unsafe.Coerce"];
  exports["unsafeCoerce"] = $foreign.unsafeCoerce;
})(PS["Unsafe.Coerce"] = PS["Unsafe.Coerce"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Control.Monad.Aff"];
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Alternative = PS["Control.Alternative"];
  var Control_Monad_Aff_Internal = PS["Control.Monad.Aff.Internal"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Rec_Class = PS["Control.Monad.Rec.Class"];
  var Control_MonadPlus = PS["Control.MonadPlus"];
  var Control_Parallel = PS["Control.Parallel"];
  var Control_Plus = PS["Control.Plus"];
  var Data_Either = PS["Data.Either"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Newtype = PS["Data.Newtype"];
  var Data_Tuple = PS["Data.Tuple"];
  var Unsafe_Coerce = PS["Unsafe.Coerce"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad = PS["Control.Monad"];
  var Data_Function = PS["Data.Function"];
  var Control_MonadZero = PS["Control.MonadZero"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Semiring = PS["Data.Semiring"];
  var Control_Parallel_Class = PS["Control.Parallel.Class"];
  var Data_Unit = PS["Data.Unit"];

  /**
 *  | A canceler is an asynchronous function that can be used to attempt the
 *  | cancelation of a computation. Returns a boolean flag indicating whether
 *  | or not the cancellation was successful. Many computations may be composite,
 *  | in such cases the flag indicates whether any part of the computation was
 *  | successfully canceled. The flag should not be used for communication.
 */  
  var Canceler = function (x) {
      return x;
  };

  /**
 *  | Runs the asynchronous computation. You must supply an error callback and a
 *  | success callback.
 *  |
 *  | Returns a canceler that can be used to attempt cancellation of the
 *  | asynchronous computation.
 */  
  var runAff = function (ex) {
      return function (f) {
          return function (aff) {
              return $foreign._runAff(ex, f, aff);
          };
      };
  };         

  /**
 *  | Creates an asynchronous effect from a function that accepts error and
 *  | success callbacks, and returns a canceler for the computation. This
 *  | function can be used for asynchronous computations that can be canceled.
 */  
  var makeAff$prime = function (h) {
      return $foreign._makeAff(h);
  };
  var functorAff = new Data_Functor.Functor(function (f) {
      return function (fa) {
          return $foreign._fmap(f, fa);
      };
  });                                        

  /**
 *  | Unwraps the canceler function from the newtype that wraps it.
 */  
  var cancel = function (v) {
      return v;
  };

  /**
 *  | Converts the asynchronous computation into a synchronous one. All values
 *  | are ignored, and if the computation produces an error, it is thrown.
 *  |
 *  | Catching exceptions by using `catchException` with the resulting Eff
 *  | computation is not recommended, as exceptions may end up being thrown
 *  | asynchronously, in which case they cannot be caught.
 *  |
 *  | If you do need to handle exceptions, you can use `runAff` instead, or
 *  | you can handle the exception within the Aff computation, using
 *  | `catchError` (or any of the other mechanisms).
 */  
  var launchAff = (function () {
      var lowerEx = Data_Functor.map(Control_Monad_Eff.functorEff)(function ($51) {
          return Canceler(Data_Functor.map(Data_Functor.functorFn)($foreign._unsafeInterleaveAff)(cancel($51)));
      });
      return function ($52) {
          return lowerEx(runAff(Control_Monad_Eff_Exception.throwException)(Data_Function["const"](Control_Applicative.pure(Control_Monad_Eff.applicativeEff)(Data_Unit.unit)))($foreign._unsafeInterleaveAff($52)));
      };
  })();

  /**
 *  | Promotes any error to the value level of the asynchronous monad.
 */  
  var attempt = function (aff) {
      return $foreign._attempt(Data_Either.Left.create, Data_Either.Right.create, aff);
  };

  /**
 *  | Ignores any errors.
 */  
  var apathize = function (a) {
      return Data_Functor.map(functorAff)(Data_Function["const"](Data_Unit.unit))(attempt(a));
  };
  var applyAff = new Control_Apply.Apply(function () {
      return functorAff;
  }, function (ff) {
      return function (fa) {
          return $foreign._bind(alwaysCanceler, ff, function (f) {
              return Data_Functor.map(functorAff)(f)(fa);
          });
      };
  });
  var applicativeAff = new Control_Applicative.Applicative(function () {
      return applyAff;
  }, function (v) {
      return $foreign._pure(nonCanceler, v);
  });
  var nonCanceler = Data_Function["const"](Control_Applicative.pure(applicativeAff)(false));
  var alwaysCanceler = Data_Function["const"](Control_Applicative.pure(applicativeAff)(true));

  /**
 *  | Forks the specified asynchronous computation so subsequent computations
 *  | will not block on the result of the computation.
 *  |
 *  | Returns a canceler that can be used to attempt cancellation of the
 *  | forked computation.
 */  
  var forkAff = function (aff) {
      return $foreign._forkAff(nonCanceler, aff);
  };

  /**
 *  | Creates an asynchronous effect from a function that accepts error and
 *  | success callbacks. This function can be used for asynchronous computations
 *  | that cannot be canceled.
 */  
  var makeAff = function (h) {
      return makeAff$prime(function (e) {
          return function (a) {
              return Data_Functor.map(Control_Monad_Eff.functorEff)(Data_Function["const"](nonCanceler))(h(e)(a));
          };
      });
  };                                                                         
  var bindAff = new Control_Bind.Bind(function () {
      return applyAff;
  }, function (fa) {
      return function (f) {
          return $foreign._bind(alwaysCanceler, fa, f);
      };
  });
  var monadAff = new Control_Monad.Monad(function () {
      return applicativeAff;
  }, function () {
      return bindAff;
  });
  var monadEffAff = new Control_Monad_Eff_Class.MonadEff(function () {
      return monadAff;
  }, function (eff) {
      return $foreign._liftEff(nonCanceler, eff);
  });

  /**
 *  | Allows users to catch and throw errors on the error channel of the
 *  | asynchronous computation. See documentation in `purescript-transformers`.
 */  
  var monadErrorAff = new Control_Monad_Error_Class.MonadError(function () {
      return monadAff;
  }, function (aff) {
      return function (ex) {
          return Control_Bind.bind(bindAff)(attempt(aff))(Data_Either.either(ex)(Control_Applicative.pure(applicativeAff)));
      };
  }, function (e) {
      return $foreign._throwError(nonCanceler, e);
  });
  exports["Canceler"] = Canceler;
  exports["apathize"] = apathize;
  exports["attempt"] = attempt;
  exports["cancel"] = cancel;
  exports["forkAff"] = forkAff;
  exports["launchAff"] = launchAff;
  exports["makeAff"] = makeAff;
  exports["nonCanceler"] = nonCanceler;
  exports["runAff"] = runAff;
  exports["functorAff"] = functorAff;
  exports["applyAff"] = applyAff;
  exports["applicativeAff"] = applicativeAff;
  exports["bindAff"] = bindAff;
  exports["monadAff"] = monadAff;
  exports["monadEffAff"] = monadEffAff;
  exports["monadErrorAff"] = monadErrorAff;
})(PS["Control.Monad.Aff"] = PS["Control.Monad.Aff"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | A low-level primitive for building asynchronous code.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Aff_Internal = PS["Control.Monad.Aff.Internal"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Unsafe_Coerce = PS["Unsafe.Coerce"];
  var Data_Function = PS["Data.Function"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];        
  var fromAVBox = Unsafe_Coerce.unsafeCoerce;

  /**
 *  | Makes a new asynchronous avar.
 */  
  var makeVar = fromAVBox(Control_Monad_Aff_Internal._makeVar(Control_Monad_Aff.nonCanceler));

  /**
 *  | Reads a value from the asynchronous var but does not consume it.
 */  
  var peekVar = function (q) {
      return fromAVBox(Control_Monad_Aff_Internal._peekVar(Control_Monad_Aff.nonCanceler, q));
  };

  /**
 *  | Puts a new value into the asynchronous avar. If the avar has
 *  | been killed, this will result in an error.
 */  
  var putVar = function (q) {
      return function (a) {
          return fromAVBox(Control_Monad_Aff_Internal._putVar(Control_Monad_Aff.nonCanceler, q, a));
      };
  };

  /**
 *  | Takes the next value from the asynchronous avar.
 */  
  var takeVar = function (q) {
      return fromAVBox(Control_Monad_Aff_Internal._takeVar(Control_Monad_Aff.nonCanceler, q));
  };
  exports["makeVar"] = makeVar;
  exports["peekVar"] = peekVar;
  exports["putVar"] = putVar;
  exports["takeVar"] = takeVar;
})(PS["Control.Monad.Aff.AVar"] = PS["Control.Monad.Aff.AVar"] || {});
(function(exports) {
    "use strict";

  exports.log = function (s) {
    return function () {
      console.log(s);
      return {};
    };
  };

  exports.error = function (s) {
    return function () {
      console.error(s);
      return {};
    };
  };
})(PS["Control.Monad.Eff.Console"] = PS["Control.Monad.Eff.Console"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Control.Monad.Eff.Console"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Show = PS["Data.Show"];
  var Data_Unit = PS["Data.Unit"];
  exports["error"] = $foreign.error;
  exports["log"] = $foreign.log;
})(PS["Control.Monad.Eff.Console"] = PS["Control.Monad.Eff.Console"] || {});
(function(exports) {
    "use strict";

  exports.unsafeCoerceEff = function (f) {
    return f;
  };
})(PS["Control.Monad.Eff.Unsafe"] = PS["Control.Monad.Eff.Unsafe"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Control.Monad.Eff.Unsafe"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];        

  /**
 *  | Run an effectful computation.
 *  |
 *  | *Note*: use of this function can result in arbitrary side-effects.
 */  
  var unsafePerformEff = function ($0) {
      return Control_Monad_Eff.runPure($foreign.unsafeCoerceEff($0));
  };
  exports["unsafePerformEff"] = unsafePerformEff;
  exports["unsafeCoerceEff"] = $foreign.unsafeCoerceEff;
})(PS["Control.Monad.Eff.Unsafe"] = PS["Control.Monad.Eff.Unsafe"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Eff_Unsafe = PS["Control.Monad.Eff.Unsafe"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];        

  /**
 *  | Throw an exception in pure code. This function should be used very
 *  | sparingly, as it can cause unexpected crashes at runtime.
 */  
  var unsafeThrowException = function ($0) {
      return Control_Monad_Eff_Unsafe.unsafePerformEff(Control_Monad_Eff_Exception.throwException($0));
  };

  /**
 *  | Defined as `unsafeThrowException <<< error`.
 */  
  var unsafeThrow = function ($1) {
      return unsafeThrowException(Control_Monad_Eff_Exception.error($1));
  };
  exports["unsafeThrow"] = unsafeThrow;
  exports["unsafeThrowException"] = unsafeThrowException;
})(PS["Control.Monad.Eff.Exception.Unsafe"] = PS["Control.Monad.Eff.Exception.Unsafe"] || {});
(function(exports) {
    "use strict";

  exports.now = function () {
    return Date.now();
  };

  exports.nowOffset = function () {
    var dt = new Date();
    return dt.getTimezoneOffset();
  };
})(PS["Control.Monad.Eff.Now"] = PS["Control.Monad.Eff.Now"] || {});
(function(exports) {
    "use strict";

  exports.calcDiff = function (rec1, rec2) {
    var msUTC1 = Date.UTC(rec1.year, rec1.month - 1, rec1.day, rec1.hour, rec1.minute, rec1.second, rec1.millisecond);
    var msUTC2 = Date.UTC(rec2.year, rec2.month - 1, rec2.day, rec2.hour, rec2.minute, rec2.second, rec2.millisecond);
    return msUTC1 - msUTC2;
  };
})(PS["Data.DateTime"] = PS["Data.DateTime"] || {});
(function(exports) {
    "use strict";

  exports.canonicalDateImpl = function (ctor, y, m, d) {
    var date = new Date(Date.UTC(y, m - 1, d));
    return ctor(date.getUTCFullYear())(date.getUTCMonth() + 1)(date.getUTCDate());
  };
})(PS["Data.Date"] = PS["Data.Date"] || {});
(function(exports) {
    "use strict";

  exports.toLower = function (c) {
    return c.toLowerCase();
  };
})(PS["Data.Char"] = PS["Data.Char"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | A type and functions for single characters.
 */  
  "use strict";
  var $foreign = PS["Data.Char"];
  exports["toLower"] = $foreign.toLower;
})(PS["Data.Char"] = PS["Data.Char"] || {});
(function(exports) {
    "use strict";

  exports.unfoldrArrayImpl = function (isNothing) {
    return function (fromJust) {
      return function (fst) {
        return function (snd) {
          return function (f) {
            return function (b) {
              var result = [];
              while (true) {
                var maybe = f(b);
                if (isNothing(maybe)) return result;
                var tuple = fromJust(maybe);
                result.push(fst(tuple));
                b = snd(tuple);
              }
            };
          };
        };
      };
    };
  };
})(PS["Data.Unfoldable"] = PS["Data.Unfoldable"] || {});
(function(exports) {
    "use strict";

  // module Partial.Unsafe

  exports.unsafePartial = function (f) {
    return f();
  };
})(PS["Partial.Unsafe"] = PS["Partial.Unsafe"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | Utilities for working with partial functions.
 */  
  "use strict";
  var $foreign = PS["Partial.Unsafe"];
  var Partial = PS["Partial"];
  exports["unsafePartial"] = $foreign.unsafePartial;
})(PS["Partial.Unsafe"] = PS["Partial.Unsafe"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module provides a type class for _unfoldable functors_, i.e.
 *  | functors which support an `unfoldr` operation.
 *  |
 *  | This allows us to unify various operations on arrays, lists,
 *  | sequences, etc.
 */  
  "use strict";
  var $foreign = PS["Data.Unfoldable"];
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Tuple = PS["Data.Tuple"];
  var Partial_Unsafe = PS["Partial.Unsafe"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Ring = PS["Data.Ring"];
  var Data_Function = PS["Data.Function"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Functor = PS["Data.Functor"];        

  /**
 *  | This class identifies data structures which can be _unfolded_,
 *  | generalizing `unfoldr` on arrays.
 *  |
 *  | The generating function `f` in `unfoldr f` in understood as follows:
 *  |
 *  | - If `f b` is `Nothing`, then `unfoldr f b` should be empty.
 *  | - If `f b` is `Just (Tuple a b1)`, then `unfoldr f b` should consist of `a`
 *  |   appended to the result of `unfoldr f b1`.
 */  
  var Unfoldable = function (unfoldr) {
      this.unfoldr = unfoldr;
  };

  /**
 *  | This class identifies data structures which can be _unfolded_,
 *  | generalizing `unfoldr` on arrays.
 *  |
 *  | The generating function `f` in `unfoldr f` in understood as follows:
 *  |
 *  | - If `f b` is `Nothing`, then `unfoldr f b` should be empty.
 *  | - If `f b` is `Just (Tuple a b1)`, then `unfoldr f b` should consist of `a`
 *  |   appended to the result of `unfoldr f b1`.
 */  
  var unfoldr = function (dict) {
      return dict.unfoldr;
  };
  var unfoldableArray = new Unfoldable($foreign.unfoldrArrayImpl(Data_Maybe.isNothing)(Partial_Unsafe.unsafePartial(function (dictPartial) {
      return Data_Maybe.fromJust(dictPartial);
  }))(Data_Tuple.fst)(Data_Tuple.snd));
  exports["Unfoldable"] = Unfoldable;
  exports["unfoldr"] = unfoldr;
  exports["unfoldableArray"] = unfoldableArray;
})(PS["Data.Unfoldable"] = PS["Data.Unfoldable"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_MonadPlus = PS["Control.MonadPlus"];
  var Data_Char = PS["Data.Char"];
  var Data_Either = PS["Data.Either"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Newtype = PS["Data.Newtype"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Unfoldable = PS["Data.Unfoldable"];
  var Partial_Unsafe = PS["Partial.Unsafe"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Bounded = PS["Data.Bounded"];
  var Data_Semiring = PS["Data.Semiring"];
  var Data_Ring = PS["Data.Ring"];
  var Data_Function = PS["Data.Function"];
  var Data_Ordering = PS["Data.Ordering"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Control_Category = PS["Control.Category"];
  var Data_Unit = PS["Data.Unit"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Boolean = PS["Data.Boolean"];
  var Control_Apply = PS["Control.Apply"];
  var Data_EuclideanRing = PS["Data.EuclideanRing"];
  var Control_Bind = PS["Control.Bind"];
  var Control_MonadZero = PS["Control.MonadZero"];

  /**
 *  | Type class for enumerations.
 *  |
 *  | Laws:
 *  | - `succ a > pred a`
 *  | - `pred a < succ a`
 *  | - `pred >=> succ >=> pred = pred`
 *  | - `succ >=> pred >=> succ = succ`
 */  
  var Enum = function (__superclass_Data$dotOrd$dotOrd_0, pred, succ) {
      this["__superclass_Data.Ord.Ord_0"] = __superclass_Data$dotOrd$dotOrd_0;
      this.pred = pred;
      this.succ = succ;
  };

  /**
 *  | Type class for finite enumerations.
 *  |
 *  | This should not be considered a part of a numeric hierarchy, as in Haskell.
 *  | Rather, this is a type class for small, ordered sum types with
 *  | statically-determined cardinality and the ability to easily compute
 *  | successor and predecessor elements, e.g. `DayOfWeek`.
 *  |
 *  | Laws:
 *  |
 *  | - ```succ bottom >>= succ >>= succ ... succ [cardinality - 1 times] == top```
 *  | - ```pred top    >>= pred >>= pred ... pred [cardinality - 1 times] == bottom```
 *  | - ```forall a > bottom: pred a >>= succ == Just a```
 *  | - ```forall a < top:  succ a >>= pred == Just a```
 *  | - ```forall a > bottom: fromEnum <$> pred a = Just (fromEnum a - 1)```
 *  | - ```forall a < top:  fromEnum <$> succ a = Just (fromEnum a + 1)```
 *  | - ```e1 `compare` e2 == fromEnum e1 `compare` fromEnum e2```
 *  | - ```toEnum (fromEnum a) = Just a```
 */  
  var BoundedEnum = function (__superclass_Data$dotBounded$dotBounded_0, __superclass_Data$dotEnum$dotEnum_1, cardinality, fromEnum, toEnum) {
      this["__superclass_Data.Bounded.Bounded_0"] = __superclass_Data$dotBounded$dotBounded_0;
      this["__superclass_Data.Enum.Enum_1"] = __superclass_Data$dotEnum$dotEnum_1;
      this.cardinality = cardinality;
      this.fromEnum = fromEnum;
      this.toEnum = toEnum;
  };

  /**
 *  | Type class for finite enumerations.
 *  |
 *  | This should not be considered a part of a numeric hierarchy, as in Haskell.
 *  | Rather, this is a type class for small, ordered sum types with
 *  | statically-determined cardinality and the ability to easily compute
 *  | successor and predecessor elements, e.g. `DayOfWeek`.
 *  |
 *  | Laws:
 *  |
 *  | - ```succ bottom >>= succ >>= succ ... succ [cardinality - 1 times] == top```
 *  | - ```pred top    >>= pred >>= pred ... pred [cardinality - 1 times] == bottom```
 *  | - ```forall a > bottom: pred a >>= succ == Just a```
 *  | - ```forall a < top:  succ a >>= pred == Just a```
 *  | - ```forall a > bottom: fromEnum <$> pred a = Just (fromEnum a - 1)```
 *  | - ```forall a < top:  fromEnum <$> succ a = Just (fromEnum a + 1)```
 *  | - ```e1 `compare` e2 == fromEnum e1 `compare` fromEnum e2```
 *  | - ```toEnum (fromEnum a) = Just a```
 */  
  var toEnum = function (dict) {
      return dict.toEnum;
  };

  /**
 *  | Type class for enumerations.
 *  |
 *  | Laws:
 *  | - `succ a > pred a`
 *  | - `pred a < succ a`
 *  | - `pred >=> succ >=> pred = pred`
 *  | - `succ >=> pred >=> succ = succ`
 */  
  var succ = function (dict) {
      return dict.succ;
  };

  /**
 *  | Type class for enumerations.
 *  |
 *  | Laws:
 *  | - `succ a > pred a`
 *  | - `pred a < succ a`
 *  | - `pred >=> succ >=> pred = pred`
 *  | - `succ >=> pred >=> succ = succ`
 */  
  var pred = function (dict) {
      return dict.pred;
  };

  /**
 *  | Type class for finite enumerations.
 *  |
 *  | This should not be considered a part of a numeric hierarchy, as in Haskell.
 *  | Rather, this is a type class for small, ordered sum types with
 *  | statically-determined cardinality and the ability to easily compute
 *  | successor and predecessor elements, e.g. `DayOfWeek`.
 *  |
 *  | Laws:
 *  |
 *  | - ```succ bottom >>= succ >>= succ ... succ [cardinality - 1 times] == top```
 *  | - ```pred top    >>= pred >>= pred ... pred [cardinality - 1 times] == bottom```
 *  | - ```forall a > bottom: pred a >>= succ == Just a```
 *  | - ```forall a < top:  succ a >>= pred == Just a```
 *  | - ```forall a > bottom: fromEnum <$> pred a = Just (fromEnum a - 1)```
 *  | - ```forall a < top:  fromEnum <$> succ a = Just (fromEnum a + 1)```
 *  | - ```e1 `compare` e2 == fromEnum e1 `compare` fromEnum e2```
 *  | - ```toEnum (fromEnum a) = Just a```
 */  
  var fromEnum = function (dict) {
      return dict.fromEnum;
  };                                                                                               

  /**
 *  | Type class for finite enumerations.
 *  |
 *  | This should not be considered a part of a numeric hierarchy, as in Haskell.
 *  | Rather, this is a type class for small, ordered sum types with
 *  | statically-determined cardinality and the ability to easily compute
 *  | successor and predecessor elements, e.g. `DayOfWeek`.
 *  |
 *  | Laws:
 *  |
 *  | - ```succ bottom >>= succ >>= succ ... succ [cardinality - 1 times] == top```
 *  | - ```pred top    >>= pred >>= pred ... pred [cardinality - 1 times] == bottom```
 *  | - ```forall a > bottom: pred a >>= succ == Just a```
 *  | - ```forall a < top:  succ a >>= pred == Just a```
 *  | - ```forall a > bottom: fromEnum <$> pred a = Just (fromEnum a - 1)```
 *  | - ```forall a < top:  fromEnum <$> succ a = Just (fromEnum a + 1)```
 *  | - ```e1 `compare` e2 == fromEnum e1 `compare` fromEnum e2```
 *  | - ```toEnum (fromEnum a) = Just a```
 */  
  var cardinality = function (dict) {
      return dict.cardinality;
  };
  exports["BoundedEnum"] = BoundedEnum;
  exports["Enum"] = Enum;
  exports["cardinality"] = cardinality;
  exports["fromEnum"] = fromEnum;
  exports["pred"] = pred;
  exports["succ"] = succ;
  exports["toEnum"] = toEnum;
})(PS["Data.Enum"] = PS["Data.Enum"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Enum = PS["Data.Enum"];
  var Data_Generic = PS["Data.Generic"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Bounded = PS["Data.Bounded"];
  var Data_Ring = PS["Data.Ring"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Semiring = PS["Data.Semiring"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Boolean = PS["Data.Boolean"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Ordering = PS["Data.Ordering"];

  /**
 *  | A month component for a date in the Gregorian calendar.
 */  
  var January = (function () {
      function January() {

      };
      January.value = new January();
      return January;
  })();

  /**
 *  | A month component for a date in the Gregorian calendar.
 */  
  var February = (function () {
      function February() {

      };
      February.value = new February();
      return February;
  })();

  /**
 *  | A month component for a date in the Gregorian calendar.
 */  
  var March = (function () {
      function March() {

      };
      March.value = new March();
      return March;
  })();

  /**
 *  | A month component for a date in the Gregorian calendar.
 */  
  var April = (function () {
      function April() {

      };
      April.value = new April();
      return April;
  })();

  /**
 *  | A month component for a date in the Gregorian calendar.
 */  
  var May = (function () {
      function May() {

      };
      May.value = new May();
      return May;
  })();

  /**
 *  | A month component for a date in the Gregorian calendar.
 */  
  var June = (function () {
      function June() {

      };
      June.value = new June();
      return June;
  })();

  /**
 *  | A month component for a date in the Gregorian calendar.
 */  
  var July = (function () {
      function July() {

      };
      July.value = new July();
      return July;
  })();

  /**
 *  | A month component for a date in the Gregorian calendar.
 */  
  var August = (function () {
      function August() {

      };
      August.value = new August();
      return August;
  })();

  /**
 *  | A month component for a date in the Gregorian calendar.
 */  
  var September = (function () {
      function September() {

      };
      September.value = new September();
      return September;
  })();

  /**
 *  | A month component for a date in the Gregorian calendar.
 */  
  var October = (function () {
      function October() {

      };
      October.value = new October();
      return October;
  })();

  /**
 *  | A month component for a date in the Gregorian calendar.
 */  
  var November = (function () {
      function November() {

      };
      November.value = new November();
      return November;
  })();

  /**
 *  | A month component for a date in the Gregorian calendar.
 */  
  var December = (function () {
      function December() {

      };
      December.value = new December();
      return December;
  })();
  var ordYear = Data_Ord.ordInt;
  var ordDay = Data_Ord.ordInt;
  var eqYear = Data_Eq.eqInt;
  var eqMonth = new Data_Eq.Eq(function (x) {
      return function (y) {
          if (x instanceof January && y instanceof January) {
              return true;
          };
          if (x instanceof February && y instanceof February) {
              return true;
          };
          if (x instanceof March && y instanceof March) {
              return true;
          };
          if (x instanceof April && y instanceof April) {
              return true;
          };
          if (x instanceof May && y instanceof May) {
              return true;
          };
          if (x instanceof June && y instanceof June) {
              return true;
          };
          if (x instanceof July && y instanceof July) {
              return true;
          };
          if (x instanceof August && y instanceof August) {
              return true;
          };
          if (x instanceof September && y instanceof September) {
              return true;
          };
          if (x instanceof October && y instanceof October) {
              return true;
          };
          if (x instanceof November && y instanceof November) {
              return true;
          };
          if (x instanceof December && y instanceof December) {
              return true;
          };
          return false;
      };
  });
  var ordMonth = new Data_Ord.Ord(function () {
      return eqMonth;
  }, function (x) {
      return function (y) {
          if (x instanceof January && y instanceof January) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof January) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof January) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof February && y instanceof February) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof February) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof February) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof March && y instanceof March) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof March) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof March) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof April && y instanceof April) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof April) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof April) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof May && y instanceof May) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof May) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof May) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof June && y instanceof June) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof June) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof June) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof July && y instanceof July) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof July) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof July) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof August && y instanceof August) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof August) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof August) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof September && y instanceof September) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof September) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof September) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof October && y instanceof October) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof October) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof October) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof November && y instanceof November) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof November) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof November) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof December && y instanceof December) {
              return Data_Ordering.EQ.value;
          };
          throw new Error("Failed pattern match at Data.Date.Component line 63, column 1 - line 63, column 38: " + [ x.constructor.name, y.constructor.name ]);
      };
  });
  var eqDay = Data_Eq.eqInt;

  /**
 *  Note: these seemingly arbitrary bounds come from relying on JS for date
 *  manipulations, as it only supports date ±100,000,000 days of the Unix epoch.
 *  Using these year values means `Date bottom bottom bottom` is a valid date,
 *  likewise for `top`.
 */  
  var boundedYear = new Data_Bounded.Bounded(function () {
      return ordYear;
  }, -271820, 275759);           
  var boundedMonth = new Data_Bounded.Bounded(function () {
      return ordMonth;
  }, January.value, December.value);
  var boundedEnumYear = new Data_Enum.BoundedEnum(function () {
      return boundedYear;
  }, function () {
      return enumYear;
  }, 547580, function (v) {
      return v;
  }, function (n) {
      if (n >= -271821 && n <= 275759) {
          return new Data_Maybe.Just(n);
      };
      if (Data_Boolean.otherwise) {
          return Data_Maybe.Nothing.value;
      };
      throw new Error("Failed pattern match at Data.Date.Component line 39, column 3 - line 41, column 26: " + [ n.constructor.name ]);
  });
  var enumYear = new Data_Enum.Enum(function () {
      return ordYear;
  }, function ($110) {
      return Data_Enum.toEnum(boundedEnumYear)((function (v) {
          return v - 1;
      })(Data_Enum.fromEnum(boundedEnumYear)($110)));
  }, function ($111) {
      return Data_Enum.toEnum(boundedEnumYear)((function (v) {
          return v + 1 | 0;
      })(Data_Enum.fromEnum(boundedEnumYear)($111)));
  });
  var boundedEnumMonth = new Data_Enum.BoundedEnum(function () {
      return boundedMonth;
  }, function () {
      return enumMonth;
  }, 12, function (v) {
      if (v instanceof January) {
          return 1;
      };
      if (v instanceof February) {
          return 2;
      };
      if (v instanceof March) {
          return 3;
      };
      if (v instanceof April) {
          return 4;
      };
      if (v instanceof May) {
          return 5;
      };
      if (v instanceof June) {
          return 6;
      };
      if (v instanceof July) {
          return 7;
      };
      if (v instanceof August) {
          return 8;
      };
      if (v instanceof September) {
          return 9;
      };
      if (v instanceof October) {
          return 10;
      };
      if (v instanceof November) {
          return 11;
      };
      if (v instanceof December) {
          return 12;
      };
      throw new Error("Failed pattern match at Data.Date.Component line 90, column 14 - line 104, column 1: " + [ v.constructor.name ]);
  }, function (v) {
      if (v === 1) {
          return new Data_Maybe.Just(January.value);
      };
      if (v === 2) {
          return new Data_Maybe.Just(February.value);
      };
      if (v === 3) {
          return new Data_Maybe.Just(March.value);
      };
      if (v === 4) {
          return new Data_Maybe.Just(April.value);
      };
      if (v === 5) {
          return new Data_Maybe.Just(May.value);
      };
      if (v === 6) {
          return new Data_Maybe.Just(June.value);
      };
      if (v === 7) {
          return new Data_Maybe.Just(July.value);
      };
      if (v === 8) {
          return new Data_Maybe.Just(August.value);
      };
      if (v === 9) {
          return new Data_Maybe.Just(September.value);
      };
      if (v === 10) {
          return new Data_Maybe.Just(October.value);
      };
      if (v === 11) {
          return new Data_Maybe.Just(November.value);
      };
      if (v === 12) {
          return new Data_Maybe.Just(December.value);
      };
      return Data_Maybe.Nothing.value;
  });
  var enumMonth = new Data_Enum.Enum(function () {
      return ordMonth;
  }, function ($114) {
      return Data_Enum.toEnum(boundedEnumMonth)((function (v) {
          return v - 1;
      })(Data_Enum.fromEnum(boundedEnumMonth)($114)));
  }, function ($115) {
      return Data_Enum.toEnum(boundedEnumMonth)((function (v) {
          return v + 1 | 0;
      })(Data_Enum.fromEnum(boundedEnumMonth)($115)));
  });
  var boundedDay = new Data_Bounded.Bounded(function () {
      return ordDay;
  }, 1, 31);
  var boundedEnumDay = new Data_Enum.BoundedEnum(function () {
      return boundedDay;
  }, function () {
      return enumDay;
  }, 31, function (v) {
      return v;
  }, function (n) {
      if (n >= 1 && n <= 31) {
          return new Data_Maybe.Just(n);
      };
      if (Data_Boolean.otherwise) {
          return Data_Maybe.Nothing.value;
      };
      throw new Error("Failed pattern match at Data.Date.Component line 139, column 3 - line 141, column 26: " + [ n.constructor.name ]);
  });
  var enumDay = new Data_Enum.Enum(function () {
      return ordDay;
  }, function ($116) {
      return Data_Enum.toEnum(boundedEnumDay)((function (v) {
          return v - 1;
      })(Data_Enum.fromEnum(boundedEnumDay)($116)));
  }, function ($117) {
      return Data_Enum.toEnum(boundedEnumDay)((function (v) {
          return v + 1 | 0;
      })(Data_Enum.fromEnum(boundedEnumDay)($117)));
  });
  exports["January"] = January;
  exports["February"] = February;
  exports["March"] = March;
  exports["April"] = April;
  exports["May"] = May;
  exports["June"] = June;
  exports["July"] = July;
  exports["August"] = August;
  exports["September"] = September;
  exports["October"] = October;
  exports["November"] = November;
  exports["December"] = December;
  exports["eqYear"] = eqYear;
  exports["ordYear"] = ordYear;
  exports["boundedYear"] = boundedYear;
  exports["enumYear"] = enumYear;
  exports["boundedEnumYear"] = boundedEnumYear;
  exports["eqMonth"] = eqMonth;
  exports["ordMonth"] = ordMonth;
  exports["boundedMonth"] = boundedMonth;
  exports["enumMonth"] = enumMonth;
  exports["boundedEnumMonth"] = boundedEnumMonth;
  exports["eqDay"] = eqDay;
  exports["ordDay"] = ordDay;
  exports["boundedDay"] = boundedDay;
  exports["enumDay"] = enumDay;
  exports["boundedEnumDay"] = boundedEnumDay;
})(PS["Data.Date.Component"] = PS["Data.Date.Component"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Generic = PS["Data.Generic"];
  var Data_Newtype = PS["Data.Newtype"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Semiring = PS["Data.Semiring"];
  var Data_Ring = PS["Data.Ring"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Category = PS["Control.Category"];
  var Data_EuclideanRing = PS["Data.EuclideanRing"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];

  /**
 *  | A class for enabling conversions between duration types.
 */  
  var Duration = function (fromDuration, toDuration) {
      this.fromDuration = fromDuration;
      this.toDuration = toDuration;
  };

  /**
 *  | A class for enabling conversions between duration types.
 */  
  var toDuration = function (dict) {
      return dict.toDuration;
  };                                  
  var ordMilliseconds = Data_Ord.ordNumber;

  /**
 *  | A class for enabling conversions between duration types.
 */  
  var fromDuration = function (dict) {
      return dict.fromDuration;
  };  
  var durationMilliseconds = new Duration(Control_Category.id(Control_Category.categoryFn), Control_Category.id(Control_Category.categoryFn));
  exports["Duration"] = Duration;
  exports["fromDuration"] = fromDuration;
  exports["toDuration"] = toDuration;
  exports["ordMilliseconds"] = ordMilliseconds;
  exports["durationMilliseconds"] = durationMilliseconds;
})(PS["Data.Time.Duration"] = PS["Data.Time.Duration"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Data.Date"];
  var Prelude = PS["Prelude"];
  var Data_Date_Component = PS["Data.Date.Component"];
  var Data_Enum = PS["Data.Enum"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Data_Generic = PS["Data.Generic"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Time_Duration = PS["Data.Time.Duration"];
  var Partial_Unsafe = PS["Partial.Unsafe"];
  var Data_Eq = PS["Data.Eq"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Ordering = PS["Data.Ordering"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Bounded = PS["Data.Bounded"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Function = PS["Data.Function"];        

  /**
 *  | A date value in the Gregorian calendar.
 */  
  var $$Date = (function () {
      function $$Date(value0, value1, value2) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
      };
      $$Date.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return new $$Date(value0, value1, value2);
              };
          };
      };
      return $$Date;
  })();

  /**
 *  | The year component of a date value.
 */  
  var year = function (v) {
      return v.value0;
  }; 

  /**
 *  | The month component of a date value.
 */  
  var month = function (v) {
      return v.value1;
  }; 
  var eqDate = new Data_Eq.Eq(function (x) {
      return function (y) {
          return Data_Eq.eq(Data_Date_Component.eqYear)(x.value0)(y.value0) && Data_Eq.eq(Data_Date_Component.eqMonth)(x.value1)(y.value1) && Data_Eq.eq(Data_Date_Component.eqDay)(x.value2)(y.value2);
      };
  });
  var ordDate = new Data_Ord.Ord(function () {
      return eqDate;
  }, function (x) {
      return function (y) {
          var $71 = Data_Ord.compare(Data_Date_Component.ordYear)(x.value0)(y.value0);
          if ($71 instanceof Data_Ordering.LT) {
              return Data_Ordering.LT.value;
          };
          if ($71 instanceof Data_Ordering.GT) {
              return Data_Ordering.GT.value;
          };
          var $72 = Data_Ord.compare(Data_Date_Component.ordMonth)(x.value1)(y.value1);
          if ($72 instanceof Data_Ordering.LT) {
              return Data_Ordering.LT.value;
          };
          if ($72 instanceof Data_Ordering.GT) {
              return Data_Ordering.GT.value;
          };
          return Data_Ord.compare(Data_Date_Component.ordDay)(x.value2)(y.value2);
      };
  });

  /**
 *  | The day component of a date value.
 */  
  var day = function (v) {
      return v.value2;
  };

  /**
 *  | Constructs a date from year, month, and day components. The resulting date
 *  | components may not be identical to the input values, as the date will be
 *  | canonicalised according to the Gregorian calendar. For example, date
 *  | values for the invalid date 2016-02-31 will be corrected to 2016-03-02.
 */  
  var canonicalDate = function (y) {
      return function (m) {
          return function (d) {
              var mkDate = Partial_Unsafe.unsafePartial(function (dictPartial) {
                  return function (y$prime) {
                      return function (m$prime) {
                          return function (d$prime) {
                              return new $$Date(y$prime, Data_Maybe.fromJust(dictPartial)(Data_Enum.toEnum(Data_Date_Component.boundedEnumMonth)(m$prime)), d$prime);
                          };
                      };
                  };
              });
              return $foreign.canonicalDateImpl(mkDate, y, Data_Enum.fromEnum(Data_Date_Component.boundedEnumMonth)(m), d);
          };
      };
  };
  var boundedDate = new Data_Bounded.Bounded(function () {
      return ordDate;
  }, new $$Date(Data_Bounded.bottom(Data_Date_Component.boundedYear), Data_Bounded.bottom(Data_Date_Component.boundedMonth), Data_Bounded.bottom(Data_Date_Component.boundedDay)), new $$Date(Data_Bounded.top(Data_Date_Component.boundedYear), Data_Bounded.top(Data_Date_Component.boundedMonth), Data_Bounded.top(Data_Date_Component.boundedDay)));
  exports["canonicalDate"] = canonicalDate;
  exports["day"] = day;
  exports["month"] = month;
  exports["year"] = year;
  exports["eqDate"] = eqDate;
  exports["ordDate"] = ordDate;
  exports["boundedDate"] = boundedDate;
})(PS["Data.Date"] = PS["Data.Date"] || {});
(function(exports) {
    "use strict";

  // module Data.Int

  exports.fromNumberImpl = function (just) {
    return function (nothing) {
      return function (n) {
        /* jshint bitwise: false */
        return (n | 0) === n ? just(n) : nothing;
      };
    };
  };

  exports.fromStringAsImpl = function (just) {
    return function (nothing) {
      return function (radix) {
        var digits;
        if (radix < 11) {
          digits = "[0-" + (radix - 1).toString() + "]";
        } else if (radix === 11) {
          digits = "[0-9a]";
        } else {
          digits = "[0-9a-" + String.fromCharCode(86 + radix) + "]";
        }
        var pattern = new RegExp("^[\\+\\-]?" + digits + "+$", "i");

        return function (s) {
          /* jshint bitwise: false */
          if (pattern.test(s)) {
            var i = parseInt(s, radix);
            return (i | 0) === i ? just(i) : nothing;
          } else {
            return nothing;
          }
        };
      };
    };
  };
})(PS["Data.Int"] = PS["Data.Int"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Data.Int"];
  var Data_Boolean = PS["Data.Boolean"];
  var Data_BooleanAlgebra = PS["Data.BooleanAlgebra"];
  var Data_Bounded = PS["Data.Bounded"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Function = PS["Data.Function"];
  var Data_Int_Bits = PS["Data.Int.Bits"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Ord = PS["Data.Ord"];
  var $$Math = PS["Math"];
  var Partial_Unsafe = PS["Partial.Unsafe"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];

  /**
 *  | Like `fromString`, but the integer can be specified in a different base.
 *  |
 *  | Example:
 *  | ``` purs
 *  | fromStringAs binary      "100" == Just 4
 *  | fromStringAs hexadecimal "ff"  == Just 255
 *  | ```
 */  
  var fromStringAs = $foreign.fromStringAsImpl(Data_Maybe.Just.create)(Data_Maybe.Nothing.value);

  /**
 *  | Reads an `Int` from a `String` value. The number must parse as an integer
 *  | and fall within the valid range of values for the `Int` type, otherwise
 *  | `Nothing` is returned.
 */  
  var fromString = fromStringAs(10);

  /**
 *  | Creates an `Int` from a `Number` value. The number must already be an
 *  | integer and fall within the valid range of values for the `Int` type
 *  | otherwise `Nothing` is returned.
 */  
  var fromNumber = $foreign.fromNumberImpl(Data_Maybe.Just.create)(Data_Maybe.Nothing.value);
  exports["fromNumber"] = fromNumber;
  exports["fromString"] = fromString;
  exports["fromStringAs"] = fromStringAs;
})(PS["Data.Int"] = PS["Data.Int"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Enum = PS["Data.Enum"];
  var Data_Generic = PS["Data.Generic"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Bounded = PS["Data.Bounded"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Semiring = PS["Data.Semiring"];
  var Data_Ring = PS["Data.Ring"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Boolean = PS["Data.Boolean"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var ordSecond = Data_Ord.ordInt;
  var ordMinute = Data_Ord.ordInt;
  var ordMillisecond = Data_Ord.ordInt;
  var ordHour = Data_Ord.ordInt;
  var eqSecond = Data_Eq.eqInt;
  var eqMinute = Data_Eq.eqInt;
  var eqMillisecond = Data_Eq.eqInt;
  var eqHour = Data_Eq.eqInt;
  var boundedSecond = new Data_Bounded.Bounded(function () {
      return ordSecond;
  }, 0, 59);
  var boundedMinute = new Data_Bounded.Bounded(function () {
      return ordMinute;
  }, 0, 59);
  var boundedMillisecond = new Data_Bounded.Bounded(function () {
      return ordMillisecond;
  }, 0, 999);
  var boundedHour = new Data_Bounded.Bounded(function () {
      return ordHour;
  }, 0, 23);
  var boundedEnumSecond = new Data_Enum.BoundedEnum(function () {
      return boundedSecond;
  }, function () {
      return enumSecond;
  }, 60, function (v) {
      return v;
  }, function (n) {
      if (n >= 0 && n <= 59) {
          return new Data_Maybe.Just(n);
      };
      if (Data_Boolean.otherwise) {
          return Data_Maybe.Nothing.value;
      };
      throw new Error("Failed pattern match at Data.Time.Component line 96, column 3 - line 98, column 26: " + [ n.constructor.name ]);
  });
  var enumSecond = new Data_Enum.Enum(function () {
      return ordSecond;
  }, function ($64) {
      return Data_Enum.toEnum(boundedEnumSecond)((function (v) {
          return v - 1;
      })(Data_Enum.fromEnum(boundedEnumSecond)($64)));
  }, function ($65) {
      return Data_Enum.toEnum(boundedEnumSecond)((function (v) {
          return v + 1 | 0;
      })(Data_Enum.fromEnum(boundedEnumSecond)($65)));
  });
  var boundedEnumMinute = new Data_Enum.BoundedEnum(function () {
      return boundedMinute;
  }, function () {
      return enumMinute;
  }, 60, function (v) {
      return v;
  }, function (n) {
      if (n >= 0 && n <= 59) {
          return new Data_Maybe.Just(n);
      };
      if (Data_Boolean.otherwise) {
          return Data_Maybe.Nothing.value;
      };
      throw new Error("Failed pattern match at Data.Time.Component line 66, column 3 - line 68, column 26: " + [ n.constructor.name ]);
  });
  var enumMinute = new Data_Enum.Enum(function () {
      return ordMinute;
  }, function ($66) {
      return Data_Enum.toEnum(boundedEnumMinute)((function (v) {
          return v - 1;
      })(Data_Enum.fromEnum(boundedEnumMinute)($66)));
  }, function ($67) {
      return Data_Enum.toEnum(boundedEnumMinute)((function (v) {
          return v + 1 | 0;
      })(Data_Enum.fromEnum(boundedEnumMinute)($67)));
  });
  var boundedEnumMillisecond = new Data_Enum.BoundedEnum(function () {
      return boundedMillisecond;
  }, function () {
      return enumMillisecond;
  }, 1000, function (v) {
      return v;
  }, function (n) {
      if (n >= 0 && n <= 999) {
          return new Data_Maybe.Just(n);
      };
      if (Data_Boolean.otherwise) {
          return Data_Maybe.Nothing.value;
      };
      throw new Error("Failed pattern match at Data.Time.Component line 127, column 3 - line 129, column 26: " + [ n.constructor.name ]);
  });
  var enumMillisecond = new Data_Enum.Enum(function () {
      return ordMillisecond;
  }, function ($68) {
      return Data_Enum.toEnum(boundedEnumMillisecond)((function (v) {
          return v - 1;
      })(Data_Enum.fromEnum(boundedEnumMillisecond)($68)));
  }, function ($69) {
      return Data_Enum.toEnum(boundedEnumMillisecond)((function (v) {
          return v + 1 | 0;
      })(Data_Enum.fromEnum(boundedEnumMillisecond)($69)));
  });
  var boundedEnumHour = new Data_Enum.BoundedEnum(function () {
      return boundedHour;
  }, function () {
      return enumHour;
  }, 24, function (v) {
      return v;
  }, function (n) {
      if (n >= 0 && n <= 23) {
          return new Data_Maybe.Just(n);
      };
      if (Data_Boolean.otherwise) {
          return Data_Maybe.Nothing.value;
      };
      throw new Error("Failed pattern match at Data.Time.Component line 36, column 3 - line 38, column 26: " + [ n.constructor.name ]);
  });
  var enumHour = new Data_Enum.Enum(function () {
      return ordHour;
  }, function ($70) {
      return Data_Enum.toEnum(boundedEnumHour)((function (v) {
          return v - 1;
      })(Data_Enum.fromEnum(boundedEnumHour)($70)));
  }, function ($71) {
      return Data_Enum.toEnum(boundedEnumHour)((function (v) {
          return v + 1 | 0;
      })(Data_Enum.fromEnum(boundedEnumHour)($71)));
  });
  exports["eqHour"] = eqHour;
  exports["ordHour"] = ordHour;
  exports["boundedHour"] = boundedHour;
  exports["enumHour"] = enumHour;
  exports["boundedEnumHour"] = boundedEnumHour;
  exports["eqMinute"] = eqMinute;
  exports["ordMinute"] = ordMinute;
  exports["boundedMinute"] = boundedMinute;
  exports["enumMinute"] = enumMinute;
  exports["boundedEnumMinute"] = boundedEnumMinute;
  exports["eqSecond"] = eqSecond;
  exports["ordSecond"] = ordSecond;
  exports["boundedSecond"] = boundedSecond;
  exports["enumSecond"] = enumSecond;
  exports["boundedEnumSecond"] = boundedEnumSecond;
  exports["eqMillisecond"] = eqMillisecond;
  exports["ordMillisecond"] = ordMillisecond;
  exports["boundedMillisecond"] = boundedMillisecond;
  exports["enumMillisecond"] = enumMillisecond;
  exports["boundedEnumMillisecond"] = boundedEnumMillisecond;
})(PS["Data.Time.Component"] = PS["Data.Time.Component"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Enum = PS["Data.Enum"];
  var Data_Generic = PS["Data.Generic"];
  var Data_Int = PS["Data.Int"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Newtype = PS["Data.Newtype"];
  var Data_Time_Component = PS["Data.Time.Component"];
  var Data_Time_Duration = PS["Data.Time.Duration"];
  var Data_Tuple = PS["Data.Tuple"];
  var $$Math = PS["Math"];
  var Partial_Unsafe = PS["Partial.Unsafe"];
  var Data_Eq = PS["Data.Eq"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Ordering = PS["Data.Ordering"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Bounded = PS["Data.Bounded"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_EuclideanRing = PS["Data.EuclideanRing"];
  var Data_Ring = PS["Data.Ring"];
  var Data_Semiring = PS["Data.Semiring"];
  var Data_Function = PS["Data.Function"];
  var Data_Functor = PS["Data.Functor"];        
  var Time = (function () {
      function Time(value0, value1, value2, value3) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
      };
      Time.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return new Time(value0, value1, value2, value3);
                  };
              };
          };
      };
      return Time;
  })();

  /**
 *  | The second component of a time value.
 */  
  var second = function (v) {
      return v.value2;
  };

  /**
 *  | The minute component of a time value.
 */  
  var minute = function (v) {
      return v.value1;
  };

  /**
 *  | The millisecond component of a time value.
 */  
  var millisecond = function (v) {
      return v.value3;
  };

  /**
 *  | The hour component of a time value.
 */  
  var hour = function (v) {
      return v.value0;
  }; 
  var eqTime = new Data_Eq.Eq(function (x) {
      return function (y) {
          return Data_Eq.eq(Data_Time_Component.eqHour)(x.value0)(y.value0) && Data_Eq.eq(Data_Time_Component.eqMinute)(x.value1)(y.value1) && Data_Eq.eq(Data_Time_Component.eqSecond)(x.value2)(y.value2) && Data_Eq.eq(Data_Time_Component.eqMillisecond)(x.value3)(y.value3);
      };
  });
  var ordTime = new Data_Ord.Ord(function () {
      return eqTime;
  }, function (x) {
      return function (y) {
          var $117 = Data_Ord.compare(Data_Time_Component.ordHour)(x.value0)(y.value0);
          if ($117 instanceof Data_Ordering.LT) {
              return Data_Ordering.LT.value;
          };
          if ($117 instanceof Data_Ordering.GT) {
              return Data_Ordering.GT.value;
          };
          var $118 = Data_Ord.compare(Data_Time_Component.ordMinute)(x.value1)(y.value1);
          if ($118 instanceof Data_Ordering.LT) {
              return Data_Ordering.LT.value;
          };
          if ($118 instanceof Data_Ordering.GT) {
              return Data_Ordering.GT.value;
          };
          var $119 = Data_Ord.compare(Data_Time_Component.ordSecond)(x.value2)(y.value2);
          if ($119 instanceof Data_Ordering.LT) {
              return Data_Ordering.LT.value;
          };
          if ($119 instanceof Data_Ordering.GT) {
              return Data_Ordering.GT.value;
          };
          return Data_Ord.compare(Data_Time_Component.ordMillisecond)(x.value3)(y.value3);
      };
  });
  var boundedTime = new Data_Bounded.Bounded(function () {
      return ordTime;
  }, new Time(Data_Bounded.bottom(Data_Time_Component.boundedHour), Data_Bounded.bottom(Data_Time_Component.boundedMinute), Data_Bounded.bottom(Data_Time_Component.boundedSecond), Data_Bounded.bottom(Data_Time_Component.boundedMillisecond)), new Time(Data_Bounded.top(Data_Time_Component.boundedHour), Data_Bounded.top(Data_Time_Component.boundedMinute), Data_Bounded.top(Data_Time_Component.boundedSecond), Data_Bounded.top(Data_Time_Component.boundedMillisecond)));
  exports["Time"] = Time;
  exports["hour"] = hour;
  exports["millisecond"] = millisecond;
  exports["minute"] = minute;
  exports["second"] = second;
  exports["eqTime"] = eqTime;
  exports["ordTime"] = ordTime;
  exports["boundedTime"] = boundedTime;
})(PS["Data.Time"] = PS["Data.Time"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Data.DateTime"];
  var Prelude = PS["Prelude"];
  var Data_Date = PS["Data.Date"];
  var Data_Enum = PS["Data.Enum"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Data_Generic = PS["Data.Generic"];
  var Data_Time = PS["Data.Time"];
  var Data_Time_Duration = PS["Data.Time.Duration"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Eq = PS["Data.Eq"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Ordering = PS["Data.Ordering"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Bounded = PS["Data.Bounded"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Date_Component = PS["Data.Date.Component"];
  var Data_Time_Component = PS["Data.Time.Component"];
  var Data_Function = PS["Data.Function"];
  var Control_Bind = PS["Control.Bind"];
  var Data_Functor = PS["Data.Functor"];        

  /**
 *  | A date/time value in the Gregorian calendar/UTC time zone.
 */  
  var DateTime = (function () {
      function DateTime(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      DateTime.create = function (value0) {
          return function (value1) {
              return new DateTime(value0, value1);
          };
      };
      return DateTime;
  })();
  var toRecord = function (v) {
      return {
          year: Data_Enum.fromEnum(Data_Date_Component.boundedEnumYear)(Data_Date.year(v.value0)), 
          month: Data_Enum.fromEnum(Data_Date_Component.boundedEnumMonth)(Data_Date.month(v.value0)), 
          day: Data_Enum.fromEnum(Data_Date_Component.boundedEnumDay)(Data_Date.day(v.value0)), 
          hour: Data_Enum.fromEnum(Data_Time_Component.boundedEnumHour)(Data_Time.hour(v.value1)), 
          minute: Data_Enum.fromEnum(Data_Time_Component.boundedEnumMinute)(Data_Time.minute(v.value1)), 
          second: Data_Enum.fromEnum(Data_Time_Component.boundedEnumSecond)(Data_Time.second(v.value1)), 
          millisecond: Data_Enum.fromEnum(Data_Time_Component.boundedEnumMillisecond)(Data_Time.millisecond(v.value1))
      };
  }; 
  var eqDateTime = new Data_Eq.Eq(function (x) {
      return function (y) {
          return Data_Eq.eq(Data_Date.eqDate)(x.value0)(y.value0) && Data_Eq.eq(Data_Time.eqTime)(x.value1)(y.value1);
      };
  });
  var ordDateTime = new Data_Ord.Ord(function () {
      return eqDateTime;
  }, function (x) {
      return function (y) {
          var $49 = Data_Ord.compare(Data_Date.ordDate)(x.value0)(y.value0);
          if ($49 instanceof Data_Ordering.LT) {
              return Data_Ordering.LT.value;
          };
          if ($49 instanceof Data_Ordering.GT) {
              return Data_Ordering.GT.value;
          };
          return Data_Ord.compare(Data_Time.ordTime)(x.value1)(y.value1);
      };
  });

  /**
 *  | Calculates the difference between two date/time values, returning the
 *  | result as a duration.
 */  
  var diff = function (dictDuration) {
      return function (dt1) {
          return function (dt2) {
              return Data_Time_Duration.toDuration(dictDuration)($foreign.calcDiff(toRecord(dt1), toRecord(dt2)));
          };
      };
  };
  var boundedDateTime = new Data_Bounded.Bounded(function () {
      return ordDateTime;
  }, new DateTime(Data_Bounded.bottom(Data_Date.boundedDate), Data_Bounded.bottom(Data_Time.boundedTime)), new DateTime(Data_Bounded.top(Data_Date.boundedDate), Data_Bounded.top(Data_Time.boundedTime)));
  exports["DateTime"] = DateTime;
  exports["diff"] = diff;
  exports["eqDateTime"] = eqDateTime;
  exports["ordDateTime"] = ordDateTime;
  exports["boundedDateTime"] = boundedDateTime;
})(PS["Data.DateTime"] = PS["Data.DateTime"] || {});
(function(exports) {
    "use strict";

  exports.toDateTimeImpl = function (ctor) {
    return function (instant) {
      var dt = new Date(instant);
      return ctor
        (dt.getUTCFullYear())(dt.getUTCMonth() + 1)(dt.getUTCDate())
        (dt.getUTCHours())(dt.getUTCMinutes())(dt.getUTCSeconds())
        (dt.getUTCMilliseconds());
    };
  };
})(PS["Data.DateTime.Instant"] = PS["Data.DateTime.Instant"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Data.DateTime.Instant"];
  var Prelude = PS["Prelude"];
  var Data_DateTime = PS["Data.DateTime"];
  var Data_Enum = PS["Data.Enum"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Data_Generic = PS["Data.Generic"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Time_Duration = PS["Data.Time.Duration"];
  var Partial_Unsafe = PS["Partial.Unsafe"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Bounded = PS["Data.Bounded"];
  var Data_Ring = PS["Data.Ring"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Date = PS["Data.Date"];
  var Data_Date_Component = PS["Data.Date.Component"];
  var Data_Time = PS["Data.Time"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Boolean = PS["Data.Boolean"];
  var Data_Time_Component = PS["Data.Time.Component"];

  /**
 *  | Creates a `DateTime` value from an `Instant`.
 */  
  var toDateTime = (function () {
      var mkDateTime = Partial_Unsafe.unsafePartial(function (dictPartial) {
          return function (y) {
              return function (mo) {
                  return function (d) {
                      return function (h) {
                          return function (mi) {
                              return function (s) {
                                  return function (ms) {
                                      return new Data_DateTime.DateTime(Data_Date.canonicalDate(y)(Data_Maybe.fromJust(dictPartial)(Data_Enum.toEnum(Data_Date_Component.boundedEnumMonth)(mo)))(d), new Data_Time.Time(h, mi, s, ms));
                                  };
                              };
                          };
                      };
                  };
              };
          };
      });
      return $foreign.toDateTimeImpl(mkDateTime);
  })();
  exports["toDateTime"] = toDateTime;
})(PS["Data.DateTime.Instant"] = PS["Data.DateTime.Instant"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Comonad = PS["Control.Comonad"];
  var Data_DateTime = PS["Data.DateTime"];
  var Data_Generic = PS["Data.Generic"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Newtype = PS["Data.Newtype"];
  var Data_Time_Duration = PS["Data.Time.Duration"];
  var Data_Eq = PS["Data.Eq"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Ordering = PS["Data.Ordering"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Extend = PS["Control.Extend"];

  /**
 *  | A date/time locale specifying an offset in minutes and an optional name for
 *  | the locale.
 */  
  var Locale = (function () {
      function Locale(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      Locale.create = function (value0) {
          return function (value1) {
              return new Locale(value0, value1);
          };
      };
      return Locale;
  })();

  /**
 *  | A value that is subject to a `Locale`.
 *  |
 *  | There are `Functor`, `Extend`, and `Comonad` instances for `LocalValue` to
 *  | enable the inner non-localised value to be manipulated while maintaining
 *  | the locale.
 */  
  var LocalValue = (function () {
      function LocalValue(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      LocalValue.create = function (value0) {
          return function (value1) {
              return new LocalValue(value0, value1);
          };
      };
      return LocalValue;
  })();
  var functorLocalValue = new Data_Functor.Functor(function (f) {
      return function (v) {
          return new LocalValue(v.value0, f(v.value1));
      };
  });
  var extendLocalValue = new Control_Extend.Extend(function () {
      return functorLocalValue;
  }, function (f) {
      return function (v) {
          return new LocalValue(v.value0, f(v));
      };
  });
  var comonadLocalValue = new Control_Comonad.Comonad(function () {
      return extendLocalValue;
  }, function (v) {
      return v.value1;
  });
  exports["LocalValue"] = LocalValue;
  exports["Locale"] = Locale;
  exports["functorLocalValue"] = functorLocalValue;
  exports["extendLocalValue"] = extendLocalValue;
  exports["comonadLocalValue"] = comonadLocalValue;
})(PS["Data.DateTime.Locale"] = PS["Data.DateTime.Locale"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Control.Monad.Eff.Now"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_DateTime = PS["Data.DateTime"];
  var Data_DateTime_Instant = PS["Data.DateTime.Instant"];
  var Data_DateTime_Locale = PS["Data.DateTime.Locale"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Time_Duration = PS["Data.Time.Duration"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];        

  /**
 *  | Gets the locale according to the current machine’s clock.
 *  |
 *  | **Note**: The `LocaleName` will always be empty for the `Locale` value
 *  | returned here until there is a reliable way to detect a name for the
 *  | locale.
 */  
  var locale = Data_Functor.map(Control_Monad_Eff.functorEff)(Data_DateTime_Locale.Locale.create(Data_Maybe.Nothing.value))($foreign.nowOffset);

  /**
 *  | Gets a `DateTime` value for the date and time according to the current
 *  | machine’s clock.
 */  
  var nowDateTime = Control_Apply.apply(Control_Monad_Eff.applyEff)(Data_Functor.map(Control_Monad_Eff.functorEff)(Data_DateTime_Locale.LocalValue.create)(locale))(Data_Functor.map(Control_Monad_Eff.functorEff)(Data_DateTime_Instant.toDateTime)($foreign.now));
  exports["locale"] = locale;
  exports["nowDateTime"] = nowDateTime;
})(PS["Control.Monad.Eff.Now"] = PS["Control.Monad.Eff.Now"] || {});
(function(exports) {
    "use strict";

  exports.newRef = function (val) {
    return function () {
      return { value: val };
    };
  };

  exports.readRef = function (ref) {
    return function () {
      return ref.value;
    };
  };

  exports.writeRef = function (ref) {
    return function (val) {
      return function () {
        ref.value = val;
        return {};
      };
    };
  };
})(PS["Control.Monad.Eff.Ref"] = PS["Control.Monad.Eff.Ref"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines an effect and actions for working with
 *  | global mutable variables.
 *  |
 *  | _Note_: The `Control.Monad.ST` provides a _safe_ alternative
 *  | to global mutable variables when mutation is restricted to a
 *  | local scope.
 */  
  "use strict";
  var $foreign = PS["Control.Monad.Eff.Ref"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Unit = PS["Data.Unit"];
  exports["newRef"] = $foreign.newRef;
  exports["readRef"] = $foreign.readRef;
  exports["writeRef"] = $foreign.writeRef;
})(PS["Control.Monad.Eff.Ref"] = PS["Control.Monad.Eff.Ref"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines the `MonadState` type class and its instances.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Unit = PS["Data.Unit"];        

  /**
 *  | The `MonadState s` type class represents those monads which support a single piece of mutable
 *  | state of type `s`.
 *  |
 *  | - `state f` updates the state using the function `f`.
 *  |
 *  | An implementation is provided for `StateT`, and for other monad transformers
 *  | defined in this library.
 *  |
 *  | Laws:
 *  |
 *  | - `do { get ; get } = get`
 *  | - `do { put x ; put y } = put y`
 *  | - `do { put x ; get } = put x $> x`
 *  | - `do { s <- get ; put s } = pure unit`
 *  |
 */  
  var MonadState = function (__superclass_Control$dotMonad$dotMonad_0, state) {
      this["__superclass_Control.Monad.Monad_0"] = __superclass_Control$dotMonad$dotMonad_0;
      this.state = state;
  };

  /**
 *  | The `MonadState s` type class represents those monads which support a single piece of mutable
 *  | state of type `s`.
 *  |
 *  | - `state f` updates the state using the function `f`.
 *  |
 *  | An implementation is provided for `StateT`, and for other monad transformers
 *  | defined in this library.
 *  |
 *  | Laws:
 *  |
 *  | - `do { get ; get } = get`
 *  | - `do { put x ; put y } = put y`
 *  | - `do { put x ; get } = put x $> x`
 *  | - `do { s <- get ; put s } = pure unit`
 *  |
 */  
  var state = function (dict) {
      return dict.state;
  };

  /**
 *  | Modify the state by applying a function to the current state.
 */  
  var modify = function (dictMonadState) {
      return function (f) {
          return state(dictMonadState)(function (s) {
              return new Data_Tuple.Tuple(Data_Unit.unit, f(s));
          });
      };
  };

  /**
 *  | Get a value which depends on the current state.
 */  
  var gets = function (dictMonadState) {
      return function (f) {
          return state(dictMonadState)(function (s) {
              return new Data_Tuple.Tuple(f(s), s);
          });
      };
  };

  /**
 *  | Get the current state.
 */  
  var get = function (dictMonadState) {
      return state(dictMonadState)(function (s) {
          return new Data_Tuple.Tuple(s, s);
      });
  };
  exports["MonadState"] = MonadState;
  exports["get"] = get;
  exports["gets"] = gets;
  exports["modify"] = modify;
  exports["state"] = state;
})(PS["Control.Monad.State.Class"] = PS["Control.Monad.State.Class"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines the `MonadTrans` type class of _monad transformers_.
 */  
  "use strict";
  var Prelude = PS["Prelude"];        

  /**
 *  | The `MonadTrans` type class represents _monad transformers_.
 *  |
 *  | A monad transformer is a type constructor of kind `(* -> *) -> * -> *`, which
 *  | takes a `Monad` as its first argument, and returns another `Monad`.
 *  |
 *  | This allows us to add additional effects to an existing monad. By iterating this
 *  | process, we create monad transformer _stacks_, which contain all of the effects
 *  | required for a particular computation.
 *  |
 *  | The laws state that `lift` is a `Monad` morphism.
 *  |
 *  | Laws:
 *  |
 *  | - `lift (pure a) = pure a`
 *  | - `lift (do { x <- m ; y }) = do { x <- lift m ; lift y }`
 */  
  var MonadTrans = function (lift) {
      this.lift = lift;
  };

  /**
 *  | The `MonadTrans` type class represents _monad transformers_.
 *  |
 *  | A monad transformer is a type constructor of kind `(* -> *) -> * -> *`, which
 *  | takes a `Monad` as its first argument, and returns another `Monad`.
 *  |
 *  | This allows us to add additional effects to an existing monad. By iterating this
 *  | process, we create monad transformer _stacks_, which contain all of the effects
 *  | required for a particular computation.
 *  |
 *  | The laws state that `lift` is a `Monad` morphism.
 *  |
 *  | Laws:
 *  |
 *  | - `lift (pure a) = pure a`
 *  | - `lift (do { x <- m ; y }) = do { x <- lift m ; lift y }`
 */  
  var lift = function (dict) {
      return dict.lift;
  };
  exports["MonadTrans"] = MonadTrans;
  exports["lift"] = lift;
})(PS["Control.Monad.Trans.Class"] = PS["Control.Monad.Trans.Class"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines the _exception monad transformer_ `ExceptT`.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Alternative = PS["Control.Alternative"];
  var Control_Monad_Cont_Class = PS["Control.Monad.Cont.Class"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Reader_Class = PS["Control.Monad.Reader.Class"];
  var Control_Monad_Rec_Class = PS["Control.Monad.Rec.Class"];
  var Control_Monad_State_Class = PS["Control.Monad.State.Class"];
  var Control_Monad_Trans_Class = PS["Control.Monad.Trans.Class"];
  var Control_Monad_Writer_Class = PS["Control.Monad.Writer.Class"];
  var Control_MonadPlus = PS["Control.MonadPlus"];
  var Control_MonadZero = PS["Control.MonadZero"];
  var Control_Plus = PS["Control.Plus"];
  var Data_Either = PS["Data.Either"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Newtype = PS["Data.Newtype"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Monad = PS["Control.Monad"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Control_Bind = PS["Control.Bind"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Function = PS["Data.Function"];
  var Control_Category = PS["Control.Category"];        

  /**
 *  | A monad transformer which adds exceptions to other monads, in the same way
 *  | as `Except`. As before, `e` is the type of exceptions, and `a` is the type
 *  | of successful results. The new type parameter `m` is the inner monad that
 *  | computations run in.
 */  
  var ExceptT = function (x) {
      return x;
  };

  /**
 *  | The inverse of `ExceptT`. Run a computation in the `ExceptT` monad.
 */  
  var runExceptT = function (v) {
      return v;
  };          
  var monadTransExceptT = new Control_Monad_Trans_Class.MonadTrans(function (dictMonad) {
      return function (m) {
          return Control_Bind.bind(dictMonad["__superclass_Control.Bind.Bind_1"]())(m)(function (v) {
              return Control_Applicative.pure(dictMonad["__superclass_Control.Applicative.Applicative_0"]())(new Data_Either.Right(v));
          });
      };
  });

  /**
 *  | Transform the unwrapped computation using the given function.
 */  
  var mapExceptT = function (f) {
      return function (v) {
          return f(v);
      };
  };
  var functorExceptT = function (dictFunctor) {
      return new Data_Functor.Functor(function (f) {
          return mapExceptT(Data_Functor.map(dictFunctor)(Data_Functor.map(Data_Either.functorEither)(f)));
      });
  };
  var monadExceptT = function (dictMonad) {
      return new Control_Monad.Monad(function () {
          return applicativeExceptT(dictMonad);
      }, function () {
          return bindExceptT(dictMonad);
      });
  };
  var bindExceptT = function (dictMonad) {
      return new Control_Bind.Bind(function () {
          return applyExceptT(dictMonad);
      }, function (v) {
          return function (k) {
              return Control_Bind.bind(dictMonad["__superclass_Control.Bind.Bind_1"]())(v)(Data_Either.either(function ($88) {
                  return Control_Applicative.pure(dictMonad["__superclass_Control.Applicative.Applicative_0"]())(Data_Either.Left.create($88));
              })(function (a) {
                  var $56 = k(a);
                  return $56;
              }));
          };
      });
  };
  var applyExceptT = function (dictMonad) {
      return new Control_Apply.Apply(function () {
          return functorExceptT(((dictMonad["__superclass_Control.Bind.Bind_1"]())["__superclass_Control.Apply.Apply_0"]())["__superclass_Data.Functor.Functor_0"]());
      }, Control_Monad.ap(monadExceptT(dictMonad)));
  };
  var applicativeExceptT = function (dictMonad) {
      return new Control_Applicative.Applicative(function () {
          return applyExceptT(dictMonad);
      }, function ($89) {
          return ExceptT(Control_Applicative.pure(dictMonad["__superclass_Control.Applicative.Applicative_0"]())(Data_Either.Right.create($89)));
      });
  };
  var monadErrorExceptT = function (dictMonad) {
      return new Control_Monad_Error_Class.MonadError(function () {
          return monadExceptT(dictMonad);
      }, function (v) {
          return function (k) {
              return Control_Bind.bind(dictMonad["__superclass_Control.Bind.Bind_1"]())(v)(Data_Either.either(function (a) {
                  var $60 = k(a);
                  return $60;
              })(function ($91) {
                  return Control_Applicative.pure(dictMonad["__superclass_Control.Applicative.Applicative_0"]())(Data_Either.Right.create($91));
              }));
          };
      }, function ($92) {
          return ExceptT(Control_Applicative.pure(dictMonad["__superclass_Control.Applicative.Applicative_0"]())(Data_Either.Left.create($92)));
      });
  };
  var monadStateExceptT = function (dictMonadState) {
      return new Control_Monad_State_Class.MonadState(function () {
          return monadExceptT(dictMonadState["__superclass_Control.Monad.Monad_0"]());
      }, function (f) {
          return Control_Monad_Trans_Class.lift(monadTransExceptT)(dictMonadState["__superclass_Control.Monad.Monad_0"]())(Control_Monad_State_Class.state(dictMonadState)(f));
      });
  };
  exports["ExceptT"] = ExceptT;
  exports["mapExceptT"] = mapExceptT;
  exports["runExceptT"] = runExceptT;
  exports["functorExceptT"] = functorExceptT;
  exports["applyExceptT"] = applyExceptT;
  exports["applicativeExceptT"] = applicativeExceptT;
  exports["bindExceptT"] = bindExceptT;
  exports["monadExceptT"] = monadExceptT;
  exports["monadTransExceptT"] = monadTransExceptT;
  exports["monadErrorExceptT"] = monadErrorExceptT;
  exports["monadStateExceptT"] = monadStateExceptT;
})(PS["Control.Monad.Except.Trans"] = PS["Control.Monad.Except.Trans"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Comonad = PS["Control.Comonad"];
  var Control_Extend = PS["Control.Extend"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Functor_Invariant = PS["Data.Functor.Invariant"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Newtype = PS["Data.Newtype"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Bounded = PS["Data.Bounded"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_BooleanAlgebra = PS["Data.BooleanAlgebra"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Semiring = PS["Data.Semiring"];
  var Data_EuclideanRing = PS["Data.EuclideanRing"];
  var Data_Ring = PS["Data.Ring"];
  var Data_CommutativeRing = PS["Data.CommutativeRing"];
  var Data_Field = PS["Data.Field"];
  var Data_Show = PS["Data.Show"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad = PS["Control.Monad"];        
  var Identity = function (x) {
      return x;
  };
  var newtypeIdentity = new Data_Newtype.Newtype(function (n) {
      return n;
  }, Identity);
  var functorIdentity = new Data_Functor.Functor(function (f) {
      return function (v) {
          return f(v);
      };
  });
  var applyIdentity = new Control_Apply.Apply(function () {
      return functorIdentity;
  }, function (v) {
      return function (v1) {
          return v(v1);
      };
  });
  var bindIdentity = new Control_Bind.Bind(function () {
      return applyIdentity;
  }, function (v) {
      return function (f) {
          return f(v);
      };
  });
  var applicativeIdentity = new Control_Applicative.Applicative(function () {
      return applyIdentity;
  }, Identity);
  var monadIdentity = new Control_Monad.Monad(function () {
      return applicativeIdentity;
  }, function () {
      return bindIdentity;
  });
  exports["Identity"] = Identity;
  exports["newtypeIdentity"] = newtypeIdentity;
  exports["functorIdentity"] = functorIdentity;
  exports["applyIdentity"] = applyIdentity;
  exports["applicativeIdentity"] = applicativeIdentity;
  exports["bindIdentity"] = bindIdentity;
  exports["monadIdentity"] = monadIdentity;
})(PS["Data.Identity"] = PS["Data.Identity"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Except_Trans = PS["Control.Monad.Except.Trans"];
  var Data_Either = PS["Data.Either"];
  var Data_Identity = PS["Data.Identity"];
  var Data_Newtype = PS["Data.Newtype"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];                                 

  /**
 *  | Run a computation in the `Except` monad. The inverse of `except`.
 */  
  var runExcept = function ($0) {
      return Data_Newtype.unwrap(Data_Identity.newtypeIdentity)(Control_Monad_Except_Trans.runExceptT($0));
  };

  /**
 *  | Transform the unwrapped computation using the given function.
 */  
  var mapExcept = function (f) {
      return Control_Monad_Except_Trans.mapExceptT(function ($1) {
          return Data_Identity.Identity(f(Data_Newtype.unwrap(Data_Identity.newtypeIdentity)($1)));
      });
  };
  exports["mapExcept"] = mapExcept;
  exports["runExcept"] = runExcept;
})(PS["Control.Monad.Except"] = PS["Control.Monad.Except"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines the state monad transformer, `StateT`.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Alternative = PS["Control.Alternative"];
  var Control_Lazy = PS["Control.Lazy"];
  var Control_Monad_Cont_Class = PS["Control.Monad.Cont.Class"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Reader_Class = PS["Control.Monad.Reader.Class"];
  var Control_Monad_Rec_Class = PS["Control.Monad.Rec.Class"];
  var Control_Monad_State_Class = PS["Control.Monad.State.Class"];
  var Control_Monad_Trans_Class = PS["Control.Monad.Trans.Class"];
  var Control_Monad_Writer_Class = PS["Control.Monad.Writer.Class"];
  var Control_MonadPlus = PS["Control.MonadPlus"];
  var Control_MonadZero = PS["Control.MonadZero"];
  var Control_Plus = PS["Control.Plus"];
  var Data_Newtype = PS["Data.Newtype"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Monad = PS["Control.Monad"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Function = PS["Data.Function"];
  var Control_Bind = PS["Control.Bind"];
  var Data_Unit = PS["Data.Unit"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];        

  /**
 *  | The state monad transformer.
 *  |
 *  | This monad transformer extends the base monad with the operations `get`
 *  | and `put` which can be used to model a single piece of mutable state.
 *  |
 *  | The `MonadState` type class describes the operations supported by this monad.
 */  
  var StateT = function (x) {
      return x;
  };

  /**
 *  | Run a computation in the `StateT` monad.
 */  
  var runStateT = function (v) {
      return v;
  };         
  var monadTransStateT = new Control_Monad_Trans_Class.MonadTrans(function (dictMonad) {
      return function (m) {
          return function (s) {
              return Control_Bind.bind(dictMonad["__superclass_Control.Bind.Bind_1"]())(m)(function (v) {
                  return Control_Applicative.pure(dictMonad["__superclass_Control.Applicative.Applicative_0"]())(new Data_Tuple.Tuple(v, s));
              });
          };
      };
  });
  var lazyStateT = new Control_Lazy.Lazy(function (f) {
      return function (s) {
          var $52 = f(Data_Unit.unit);
          return $52(s);
      };
  });
  var functorStateT = function (dictFunctor) {
      return new Data_Functor.Functor(function (f) {
          return function (v) {
              return function (s) {
                  return Data_Functor.map(dictFunctor)(function (v1) {
                      return new Data_Tuple.Tuple(f(v1.value0), v1.value1);
                  })(v(s));
              };
          };
      });
  };

  /**
 *  | Run a computation in the `StateT` monad, discarding the final state.
 */  
  var evalStateT = function (dictFunctor) {
      return function (v) {
          return function (s) {
              return Data_Functor.map(dictFunctor)(Data_Tuple.fst)(v(s));
          };
      };
  };
  var monadStateT = function (dictMonad) {
      return new Control_Monad.Monad(function () {
          return applicativeStateT(dictMonad);
      }, function () {
          return bindStateT(dictMonad);
      });
  };
  var bindStateT = function (dictMonad) {
      return new Control_Bind.Bind(function () {
          return applyStateT(dictMonad);
      }, function (v) {
          return function (f) {
              return function (s) {
                  return Control_Bind.bind(dictMonad["__superclass_Control.Bind.Bind_1"]())(v(s))(function (v1) {
                      var $65 = f(v1.value0);
                      return $65(v1.value1);
                  });
              };
          };
      });
  };
  var applyStateT = function (dictMonad) {
      return new Control_Apply.Apply(function () {
          return functorStateT(((dictMonad["__superclass_Control.Bind.Bind_1"]())["__superclass_Control.Apply.Apply_0"]())["__superclass_Data.Functor.Functor_0"]());
      }, Control_Monad.ap(monadStateT(dictMonad)));
  };
  var applicativeStateT = function (dictMonad) {
      return new Control_Applicative.Applicative(function () {
          return applyStateT(dictMonad);
      }, function (a) {
          return function (s) {
              return Control_Applicative.pure(dictMonad["__superclass_Control.Applicative.Applicative_0"]())(new Data_Tuple.Tuple(a, s));
          };
      });
  };
  var monadStateStateT = function (dictMonad) {
      return new Control_Monad_State_Class.MonadState(function () {
          return monadStateT(dictMonad);
      }, function (f) {
          return StateT(function ($101) {
              return Control_Applicative.pure(dictMonad["__superclass_Control.Applicative.Applicative_0"]())(f($101));
          });
      });
  };
  exports["StateT"] = StateT;
  exports["evalStateT"] = evalStateT;
  exports["runStateT"] = runStateT;
  exports["functorStateT"] = functorStateT;
  exports["applyStateT"] = applyStateT;
  exports["applicativeStateT"] = applicativeStateT;
  exports["bindStateT"] = bindStateT;
  exports["monadStateT"] = monadStateT;
  exports["monadTransStateT"] = monadTransStateT;
  exports["lazyStateT"] = lazyStateT;
  exports["monadStateStateT"] = monadStateStateT;
})(PS["Control.Monad.State.Trans"] = PS["Control.Monad.State.Trans"] || {});
(function(exports) {
    "use strict";

  //------------------------------------------------------------------------------
  // Array creation --------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.range = function (start) {
    return function (end) {
      var step = start > end ? -1 : 1;
      var result = [];
      for (var i = start, n = 0; i !== end; i += step) {
        result[n++] = i;
      }
      result[n] = i;
      return result;
    };
  };   

  //------------------------------------------------------------------------------
  // Array size ------------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.length = function (xs) {
    return xs.length;
  };

  //------------------------------------------------------------------------------
  // Extending arrays ------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.cons = function (e) {
    return function (l) {
      return [e].concat(l);
    };
  };

  //------------------------------------------------------------------------------
  // Indexed operations ----------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.indexImpl = function (just) {
    return function (nothing) {
      return function (xs) {
        return function (i) {
          return i < 0 || i >= xs.length ? nothing :  just(xs[i]);
        };
      };
    };
  };

  exports.concat = function (xss) {
    var result = [];
    for (var i = 0, l = xss.length; i < l; i++) {
      var xs = xss[i];
      for (var j = 0, m = xs.length; j < m; j++) {
        result.push(xs[j]);
      }
    }
    return result;
  };

  exports.filter = function (f) {
    return function (xs) {
      return xs.filter(f);
    };
  };

  //------------------------------------------------------------------------------
  // Sorting ---------------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.sortImpl = function (f) {
    return function (l) {
      // jshint maxparams: 2
      return l.slice().sort(function (x, y) {
        return f(x)(y);
      });
    };
  };

  //------------------------------------------------------------------------------
  // Subarrays -------------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.slice = function (s) {
    return function (e) {
      return function (l) {
        return l.slice(s, e);
      };
    };
  };

  exports.drop = function (n) {
    return function (l) {
      return n < 1 ? l : l.slice(n);
    };
  };

  //------------------------------------------------------------------------------
  // Zipping ---------------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.zipWith = function (f) {
    return function (xs) {
      return function (ys) {
        var l = xs.length < ys.length ? xs.length : ys.length;
        var result = new Array(l);
        for (var i = 0; i < l; i++) {
          result[i] = f(xs[i])(ys[i]);
        }
        return result;
      };
    };
  };
})(PS["Data.Array"] = PS["Data.Array"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines a generic non-empty data structure, which adds an
 *  | additional element to any container type.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Alternative = PS["Control.Alternative"];
  var Control_Plus = PS["Control.Plus"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Eq = PS["Data.Eq"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Ordering = PS["Data.Ordering"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Category = PS["Control.Category"];        

  /**
 *  | A non-empty container of elements of type a.
 *  |
 *  | For example:
 *  |
 *  | ```purescript
 *  | nonEmptyList :: NonEmpty List Int
 *  | nonEmptyList = 0 :| empty
 *  | ```
 */  
  var NonEmpty = (function () {
      function NonEmpty(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      NonEmpty.create = function (value0) {
          return function (value1) {
              return new NonEmpty(value0, value1);
          };
      };
      return NonEmpty;
  })();

  /**
 *  | Create a non-empty structure with a single value.
 */  
  var singleton = function (dictPlus) {
      return function (a) {
          return new NonEmpty(a, Control_Plus.empty(dictPlus));
      };
  };
  var showNonEmpty = function (dictShow) {
      return function (dictShow1) {
          return new Data_Show.Show(function (v) {
              return "(NonEmpty " + (Data_Show.show(dictShow)(v.value0) + (" " + (Data_Show.show(dictShow1)(v.value1) + ")")));
          });
      };
  };
  var functorNonEmpty = function (dictFunctor) {
      return new Data_Functor.Functor(function (f) {
          return function (v) {
              return new NonEmpty(f(v.value0), Data_Functor.map(dictFunctor)(f)(v.value1));
          };
      });
  };
  exports["NonEmpty"] = NonEmpty;
  exports["singleton"] = singleton;
  exports["showNonEmpty"] = showNonEmpty;
  exports["functorNonEmpty"] = functorNonEmpty;
})(PS["Data.NonEmpty"] = PS["Data.NonEmpty"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | Helper functions for working with immutable Javascript arrays.
 *  |
 *  | _Note_: Depending on your use-case, you may prefer to use `Data.List` or
 *  | `Data.Sequence` instead, which might give better performance for certain
 *  | use cases. This module is useful when integrating with JavaScript libraries
 *  | which use arrays, but immutable arrays are not a practical data structure
 *  | for many use cases due to their poor asymptotics.
 *  |
 *  | In addition to the functions in this module, Arrays have a number of
 *  | useful instances:
 *  |
 *  | * `Functor`, which provides `map :: forall a b. (a -> b) -> Array a ->
 *  |   Array b`
 *  | * `Apply`, which provides `(<*>) :: forall a b. Array (a -> b) -> Array a
 *  |   -> Array b`. This function works a bit like a Cartesian product; the
 *  |   result array is constructed by applying each function in the first
 *  |   array to each value in the second, so that the result array ends up with
 *  |   a length equal to the product of the two arguments' lengths.
 *  | * `Bind`, which provides `(>>=) :: forall a b. (a -> Array b) -> Array a
 *  |   -> Array b` (this is the same as `concatMap`).
 *  | * `Semigroup`, which provides `(<>) :: forall a. Array a -> Array a ->
 *  |   Array a`, for concatenating arrays.
 *  | * `Foldable`, which provides a slew of functions for *folding* (also known
 *  |   as *reducing*) arrays down to one value. For example,
 *  |   `Data.Foldable.or` tests whether an array of `Boolean` values contains
 *  |   at least one `true` value.
 *  | * `Traversable`, which provides the PureScript version of a for-loop,
 *  |   allowing you to iterate over an array and accumulate effects.
 *  |
 */  
  "use strict";
  var $foreign = PS["Data.Array"];
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Alternative = PS["Control.Alternative"];
  var Control_Lazy = PS["Control.Lazy"];
  var Control_Monad_Rec_Class = PS["Control.Monad.Rec.Class"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_NonEmpty = PS["Data.NonEmpty"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Unfoldable = PS["Data.Unfoldable"];
  var Partial_Unsafe = PS["Partial.Unsafe"];
  var Data_Function = PS["Data.Function"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Semiring = PS["Data.Semiring"];
  var Data_Boolean = PS["Data.Boolean"];
  var Data_Ordering = PS["Data.Ordering"];
  var Data_Ring = PS["Data.Ring"];
  var Data_Eq = PS["Data.Eq"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Control_Bind = PS["Control.Bind"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Category = PS["Control.Category"];

  /**
 *  | Sort the elements of an array in increasing order, where elements are
 *  | compared using the specified partial ordering, creating a new array.
 */  
  var sortBy = function (comp) {
      return function (xs) {
          var comp$prime = function (x) {
              return function (y) {
                  var $51 = comp(x)(y);
                  if ($51 instanceof Data_Ordering.GT) {
                      return 1;
                  };
                  if ($51 instanceof Data_Ordering.EQ) {
                      return 0;
                  };
                  if ($51 instanceof Data_Ordering.LT) {
                      return -1;
                  };
                  throw new Error("Failed pattern match at Data.Array line 467, column 15 - line 472, column 1: " + [ $51.constructor.name ]);
              };
          };
          return $foreign.sortImpl(comp$prime)(xs);
      };
  };

  /**
 * ------------------------------------------------------------------------------
 *  Sorting ---------------------------------------------------------------------
 * ------------------------------------------------------------------------------
 *  | Sort the elements of an array in increasing order, creating a new array.
 */  
  var sort = function (dictOrd) {
      return function (xs) {
          return sortBy(Data_Ord.compare(dictOrd))(xs);
      };
  };

  /**
 *  | Create an array of one element
 */  
  var singleton = function (a) {
      return [ a ];
  };

  /**
 * ------------------------------------------------------------------------------
 *  Array size ------------------------------------------------------------------
 * ------------------------------------------------------------------------------
 *  | Test whether an array is empty.
 */  
  var $$null = function (xs) {
      return $foreign.length(xs) === 0;
  };
  var some = function (dictAlternative) {
      return function (dictLazy) {
          return function (v) {
              return Control_Apply.apply((dictAlternative["__superclass_Control.Applicative.Applicative_0"]())["__superclass_Control.Apply.Apply_0"]())(Data_Functor.map(((dictAlternative["__superclass_Control.Plus.Plus_1"]())["__superclass_Control.Alt.Alt_0"]())["__superclass_Data.Functor.Functor_0"]())($foreign.cons)(v))(Control_Lazy.defer(dictLazy)(function (v1) {
                  return many(dictAlternative)(dictLazy)(v);
              }));
          };
      };
  };
  var many = function (dictAlternative) {
      return function (dictLazy) {
          return function (v) {
              return Control_Alt.alt((dictAlternative["__superclass_Control.Plus.Plus_1"]())["__superclass_Control.Alt.Alt_0"]())(some(dictAlternative)(dictLazy)(v))(Control_Applicative.pure(dictAlternative["__superclass_Control.Applicative.Applicative_0"]())([  ]));
          };
      };
  };

  /**
 * ------------------------------------------------------------------------------
 *  Indexed operations ----------------------------------------------------------
 * ------------------------------------------------------------------------------
 *  | This function provides a safe way to read a value at a particular index
 *  | from an array.
 */  
  var index = $foreign.indexImpl(Data_Maybe.Just.create)(Data_Maybe.Nothing.value);

  /**
 * ------------------------------------------------------------------------------
 *  Non-indexed reads -----------------------------------------------------------
 * ------------------------------------------------------------------------------
 *  | Get the first element in an array, or `Nothing` if the array is empty
 *  |
 *  | Running time: `O(1)`.
 */  
  var head = function (xs) {
      return index(xs)(0);
  };

  /**
 *  | Apply a function to each element in an array, and flatten the results
 *  | into a single, new array.
 */  
  var concatMap = Data_Function.flip(Control_Bind.bind(Control_Bind.bindArray));

  /**
 *  | Apply a function to each element in an array, keeping only the results
 *  | which contain a value, creating a new array.
 */  
  var mapMaybe = function (f) {
      return concatMap(function ($78) {
          return Data_Maybe.maybe([  ])(singleton)(f($78));
      });
  };

  /**
 *  | Filter an array of optional values, keeping only the elements which contain
 *  | a value, creating a new array.
 */  
  var catMaybes = mapMaybe(Control_Category.id(Control_Category.categoryFn));
  exports["catMaybes"] = catMaybes;
  exports["concatMap"] = concatMap;
  exports["head"] = head;
  exports["index"] = index;
  exports["many"] = many;
  exports["mapMaybe"] = mapMaybe;
  exports["null"] = $$null;
  exports["singleton"] = singleton;
  exports["some"] = some;
  exports["sort"] = sort;
  exports["sortBy"] = sortBy;
  exports["concat"] = $foreign.concat;
  exports["drop"] = $foreign.drop;
  exports["filter"] = $foreign.filter;
  exports["length"] = $foreign.length;
  exports["range"] = $foreign.range;
  exports["zipWith"] = $foreign.zipWith;
})(PS["Data.Array"] = PS["Data.Array"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  // jshint maxparams: 3
  exports.parseJSONImpl = function (left, right, str) {
    try {
      return right(JSON.parse(str));
    } catch (e) {
      return left(e.toString());
    }
  };
  // jshint maxparams: 1

  exports.toForeign = function (value) {
    return value;
  };

  exports.unsafeFromForeign = function (value) {
    return value;
  };

  exports.typeOf = function (value) {
    return typeof value;
  };

  exports.tagOf = function (value) {
    return Object.prototype.toString.call(value).slice(8, -1);
  };

  exports.isNull = function (value) {
    return value === null;
  };

  exports.isUndefined = function (value) {
    return value === undefined;
  };

  exports.isArray = Array.isArray || function (value) {
    return Object.prototype.toString.call(value) === "[object Array]";
  };
})(PS["Data.Foreign"] = PS["Data.Foreign"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Alternative = PS["Control.Alternative"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Comonad = PS["Control.Comonad"];
  var Control_Extend = PS["Control.Extend"];
  var Control_MonadPlus = PS["Control.MonadPlus"];
  var Control_MonadZero = PS["Control.MonadZero"];
  var Control_Plus = PS["Control.Plus"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Generic = PS["Data.Generic"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Newtype = PS["Data.Newtype"];
  var Data_NonEmpty = PS["Data.NonEmpty"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Unfoldable = PS["Data.Unfoldable"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Function = PS["Data.Function"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Ordering = PS["Data.Ordering"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Category = PS["Control.Category"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad = PS["Control.Monad"];        
  var Nil = (function () {
      function Nil() {

      };
      Nil.value = new Nil();
      return Nil;
  })();
  var Cons = (function () {
      function Cons(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      Cons.create = function (value0) {
          return function (value1) {
              return new Cons(value0, value1);
          };
      };
      return Cons;
  })();
  var NonEmptyList = function (x) {
      return x;
  };
  var foldableList = new Data_Foldable.Foldable(function (dictMonoid) {
      return function (f) {
          return Data_Foldable.foldl(foldableList)(function (acc) {
              return function ($128) {
                  return Data_Semigroup.append(dictMonoid["__superclass_Data.Semigroup.Semigroup_0"]())(acc)(f($128));
              };
          })(Data_Monoid.mempty(dictMonoid));
      };
  }, function (f) {
      var go = function (__copy_b) {
          return function (__copy_v) {
              var b = __copy_b;
              var v = __copy_v;
              tco: while (true) {
                  if (v instanceof Nil) {
                      return b;
                  };
                  if (v instanceof Cons) {
                      var __tco_b = f(b)(v.value0);
                      var __tco_v = v.value1;
                      b = __tco_b;
                      v = __tco_v;
                      continue tco;
                  };
                  throw new Error("Failed pattern match at Data.List.Types line 66, column 3 - line 69, column 34: " + [ b.constructor.name, v.constructor.name ]);
              };
          };
      };
      return go;
  }, function (f) {
      return function (b) {
          return function (as) {
              var rev = function (__copy_acc) {
                  return function (__copy_v) {
                      var acc = __copy_acc;
                      var v = __copy_v;
                      tco: while (true) {
                          if (v instanceof Nil) {
                              return acc;
                          };
                          if (v instanceof Cons) {
                              var __tco_acc = new Cons(v.value0, acc);
                              var __tco_v = v.value1;
                              acc = __tco_acc;
                              v = __tco_v;
                              continue tco;
                          };
                          throw new Error("Failed pattern match at Data.List.Types line 62, column 3 - line 65, column 40: " + [ acc.constructor.name, v.constructor.name ]);
                      };
                  };
              };
              return Data_Foldable.foldl(foldableList)(Data_Function.flip(f))(b)(rev(Nil.value)(as));
          };
      };
  });                                                                     
  var functorList = new Data_Functor.Functor(function (f) {
      return Data_Foldable.foldr(foldableList)(function (x) {
          return function (acc) {
              return new Cons(f(x), acc);
          };
      })(Nil.value);
  });
  var functorNonEmptyList = Data_NonEmpty.functorNonEmpty(functorList);
  var semigroupList = new Data_Semigroup.Semigroup(function (xs) {
      return function (ys) {
          return Data_Foldable.foldr(foldableList)(Cons.create)(ys)(xs);
      };
  });
  var showList = function (dictShow) {
      return new Data_Show.Show(function (v) {
          if (v instanceof Nil) {
              return "Nil";
          };
          return "(" + (Data_Foldable.intercalate(foldableList)(Data_Monoid.monoidString)(" : ")(Data_Functor.map(functorList)(Data_Show.show(dictShow))(v)) + " : Nil)");
      });
  };
  var showNonEmptyList = function (dictShow) {
      return new Data_Show.Show(function (v) {
          return "(NonEmptyList " + (Data_Show.show(Data_NonEmpty.showNonEmpty(dictShow)(showList(dictShow)))(v) + ")");
      });
  };
  var traversableList = new Data_Traversable.Traversable(function () {
      return foldableList;
  }, function () {
      return functorList;
  }, function (dictApplicative) {
      return Data_Traversable.traverse(traversableList)(dictApplicative)(Control_Category.id(Control_Category.categoryFn));
  }, function (dictApplicative) {
      return function (f) {
          return function ($129) {
              return Data_Functor.map((dictApplicative["__superclass_Control.Apply.Apply_0"]())["__superclass_Data.Functor.Functor_0"]())(Data_Foldable.foldl(foldableList)(Data_Function.flip(Cons.create))(Nil.value))(Data_Foldable.foldl(foldableList)(function (acc) {
                  return function ($130) {
                      return Control_Apply.lift2(dictApplicative["__superclass_Control.Apply.Apply_0"]())(Data_Function.flip(Cons.create))(acc)(f($130));
                  };
              })(Control_Applicative.pure(dictApplicative)(Nil.value))($129));
          };
      };
  });
  var eqList = function (dictEq) {
      return new Data_Eq.Eq(function (xs) {
          return function (ys) {
              var go = function (__copy_v) {
                  return function (__copy_v1) {
                      return function (__copy_v2) {
                          var v = __copy_v;
                          var v1 = __copy_v1;
                          var v2 = __copy_v2;
                          tco: while (true) {
                              if (!v2) {
                                  return false;
                              };
                              if (v instanceof Nil && v1 instanceof Nil) {
                                  return v2;
                              };
                              if (v instanceof Cons && v1 instanceof Cons) {
                                  var __tco_v = v.value1;
                                  var __tco_v1 = v1.value1;
                                  var __tco_v2 = v2 && Data_Eq.eq(dictEq)(v1.value0)(v.value0);
                                  v = __tco_v;
                                  v1 = __tco_v1;
                                  v2 = __tco_v2;
                                  continue tco;
                              };
                              return false;
                          };
                      };
                  };
              };
              return go(xs)(ys)(true);
          };
      });
  };
  var ordList = function (dictOrd) {
      return new Data_Ord.Ord(function () {
          return eqList(dictOrd["__superclass_Data.Eq.Eq_0"]());
      }, function (xs) {
          return function (ys) {
              var go = function (__copy_v) {
                  return function (__copy_v1) {
                      var v = __copy_v;
                      var v1 = __copy_v1;
                      tco: while (true) {
                          if (v instanceof Nil && v1 instanceof Nil) {
                              return Data_Ordering.EQ.value;
                          };
                          if (v instanceof Nil) {
                              return Data_Ordering.LT.value;
                          };
                          if (v1 instanceof Nil) {
                              return Data_Ordering.GT.value;
                          };
                          if (v instanceof Cons && v1 instanceof Cons) {
                              var $99 = Data_Ord.compare(dictOrd)(v.value0)(v1.value0);
                              if ($99 instanceof Data_Ordering.EQ) {
                                  var __tco_v = v.value1;
                                  var __tco_v1 = v1.value1;
                                  v = __tco_v;
                                  v1 = __tco_v1;
                                  continue tco;
                              };
                              return $99;
                          };
                          throw new Error("Failed pattern match at Data.List.Types line 42, column 3 - line 50, column 23: " + [ v.constructor.name, v1.constructor.name ]);
                      };
                  };
              };
              return go(xs)(ys);
          };
      });
  }; 
  var applyList = new Control_Apply.Apply(function () {
      return functorList;
  }, function (v) {
      return function (v1) {
          if (v instanceof Nil) {
              return Nil.value;
          };
          if (v instanceof Cons) {
              return Data_Semigroup.append(semigroupList)(Data_Functor.map(functorList)(v.value0)(v1))(Control_Apply.apply(applyList)(v.value1)(v1));
          };
          throw new Error("Failed pattern match at Data.List.Types line 84, column 3 - line 84, column 20: " + [ v.constructor.name, v1.constructor.name ]);
      };
  });
  var applicativeList = new Control_Applicative.Applicative(function () {
      return applyList;
  }, function (a) {
      return new Cons(a, Nil.value);
  });                                              
  var altList = new Control_Alt.Alt(function () {
      return functorList;
  }, Data_Semigroup.append(semigroupList));
  var plusList = new Control_Plus.Plus(function () {
      return altList;
  }, Nil.value);
  exports["Nil"] = Nil;
  exports["Cons"] = Cons;
  exports["NonEmptyList"] = NonEmptyList;
  exports["showList"] = showList;
  exports["eqList"] = eqList;
  exports["ordList"] = ordList;
  exports["semigroupList"] = semigroupList;
  exports["functorList"] = functorList;
  exports["foldableList"] = foldableList;
  exports["traversableList"] = traversableList;
  exports["applyList"] = applyList;
  exports["applicativeList"] = applicativeList;
  exports["altList"] = altList;
  exports["plusList"] = plusList;
  exports["showNonEmptyList"] = showNonEmptyList;
  exports["functorNonEmptyList"] = functorNonEmptyList;
})(PS["Data.List.Types"] = PS["Data.List.Types"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines a type of _strict_ linked lists, and associated helper
 *  | functions and type class instances.
 *  |
 *  | _Note_: Depending on your use-case, you may prefer to use
 *  | `Data.Sequence` instead, which might give better performance for certain
 *  | use cases. This module is an improvement over `Data.Array` when working with
 *  | immutable lists of data in a purely-functional setting, but does not have
 *  | good random-access performance.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Alternative = PS["Control.Alternative"];
  var Control_Lazy = PS["Control.Lazy"];
  var Control_Monad_Rec_Class = PS["Control.Monad.Rec.Class"];
  var Data_Bifunctor = PS["Data.Bifunctor"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_List_Types = PS["Data.List.Types"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_NonEmpty = PS["Data.NonEmpty"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Unfoldable = PS["Data.Unfoldable"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Ring = PS["Data.Ring"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ordering = PS["Data.Ordering"];
  var Data_Boolean = PS["Data.Boolean"];
  var Data_Function = PS["Data.Function"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Semiring = PS["Data.Semiring"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Unit = PS["Data.Unit"];
  var Control_Apply = PS["Control.Apply"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Category = PS["Control.Category"];                                 

  /**
 *  | Break a list into its first element, and the remaining elements,
 *  | or `Nothing` if the list is empty.
 *  |
 *  | Running time: `O(1)`
 */  
  var uncons = function (v) {
      if (v instanceof Data_List_Types.Nil) {
          return Data_Maybe.Nothing.value;
      };
      if (v instanceof Data_List_Types.Cons) {
          return new Data_Maybe.Just({
              head: v.value0, 
              tail: v.value1
          });
      };
      throw new Error("Failed pattern match at Data.List line 257, column 1 - line 257, column 21: " + [ v.constructor.name ]);
  };

  /**
 *  | Convert a list into any unfoldable structure.
 *  |
 *  | Running time: `O(n)`
 */  
  var toUnfoldable = function (dictUnfoldable) {
      return Data_Unfoldable.unfoldr(dictUnfoldable)(function (xs) {
          return Data_Functor.map(Data_Maybe.functorMaybe)(function (rec) {
              return new Data_Tuple.Tuple(rec.head, rec.tail);
          })(uncons(xs));
      });
  };

  /**
 *  | Get all but the first element of a list, or `Nothing` if the list is empty.
 *  |
 *  | Running time: `O(1)`
 */  
  var tail = function (v) {
      if (v instanceof Data_List_Types.Nil) {
          return Data_Maybe.Nothing.value;
      };
      if (v instanceof Data_List_Types.Cons) {
          return new Data_Maybe.Just(v.value1);
      };
      throw new Error("Failed pattern match at Data.List line 238, column 1 - line 238, column 19: " + [ v.constructor.name ]);
  };

  /**
 * ------------------------------------------------------------------------------
 *  List size -------------------------------------------------------------------
 * ------------------------------------------------------------------------------
 *  | Test whether a list is empty.
 *  |
 *  | Running time: `O(1)`
 */  
  var $$null = function (v) {
      if (v instanceof Data_List_Types.Nil) {
          return true;
      };
      return false;
  };
  var some = function (dictAlternative) {
      return function (dictLazy) {
          return function (v) {
              return Control_Apply.apply((dictAlternative["__superclass_Control.Applicative.Applicative_0"]())["__superclass_Control.Apply.Apply_0"]())(Data_Functor.map(((dictAlternative["__superclass_Control.Plus.Plus_1"]())["__superclass_Control.Alt.Alt_0"]())["__superclass_Data.Functor.Functor_0"]())(Data_List_Types.Cons.create)(v))(Control_Lazy.defer(dictLazy)(function (v1) {
                  return many(dictAlternative)(dictLazy)(v);
              }));
          };
      };
  };
  var many = function (dictAlternative) {
      return function (dictLazy) {
          return function (v) {
              return Control_Alt.alt((dictAlternative["__superclass_Control.Plus.Plus_1"]())["__superclass_Control.Alt.Alt_0"]())(some(dictAlternative)(dictLazy)(v))(Control_Applicative.pure(dictAlternative["__superclass_Control.Applicative.Applicative_0"]())(Data_List_Types.Nil.value));
          };
      };
  };

  /**
 * ------------------------------------------------------------------------------
 *  Non-indexed reads -----------------------------------------------------------
 * ------------------------------------------------------------------------------
 *  | Get the first element in a list, or `Nothing` if the list is empty.
 *  |
 *  | Running time: `O(1)`.
 */  
  var head = function (v) {
      if (v instanceof Data_List_Types.Nil) {
          return Data_Maybe.Nothing.value;
      };
      if (v instanceof Data_List_Types.Cons) {
          return new Data_Maybe.Just(v.value0);
      };
      throw new Error("Failed pattern match at Data.List line 223, column 1 - line 223, column 19: " + [ v.constructor.name ]);
  };

  /**
 *  | Construct a list from a foldable structure.
 *  |
 *  | Running time: `O(n)`
 */  
  var fromFoldable = function (dictFoldable) {
      return Data_Foldable.foldr(dictFoldable)(Data_List_Types.Cons.create)(Data_List_Types.Nil.value);
  };
  exports["fromFoldable"] = fromFoldable;
  exports["head"] = head;
  exports["many"] = many;
  exports["null"] = $$null;
  exports["some"] = some;
  exports["tail"] = tail;
  exports["toUnfoldable"] = toUnfoldable;
  exports["uncons"] = uncons;
})(PS["Data.List"] = PS["Data.List"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_List = PS["Data.List"];
  var Data_List_Types = PS["Data.List.Types"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_NonEmpty = PS["Data.NonEmpty"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Unfoldable = PS["Data.Unfoldable"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Semiring = PS["Data.Semiring"];
  var Data_Function = PS["Data.Function"];
  var Control_Bind = PS["Control.Bind"];
  var singleton = function ($36) {
      return Data_List_Types.NonEmptyList(Data_NonEmpty.singleton(Data_List_Types.plusList)($36));
  };
  exports["singleton"] = singleton;
})(PS["Data.List.NonEmpty"] = PS["Data.List.NonEmpty"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines types and functions for working with _foreign_
 *  | data.
 */  
  "use strict";
  var $foreign = PS["Data.Foreign"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Except = PS["Control.Monad.Except"];
  var Data_Either = PS["Data.Either"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Data_Int = PS["Data.Int"];
  var Data_List_NonEmpty = PS["Data.List.NonEmpty"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_String = PS["Data.String"];
  var Data_Eq = PS["Data.Eq"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Ordering = PS["Data.Ordering"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Except_Trans = PS["Control.Monad.Except.Trans"];
  var Data_Identity = PS["Data.Identity"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Function = PS["Data.Function"];
  var Data_Boolean = PS["Data.Boolean"];

  /**
 *  | A type for foreign type errors
 */  
  var ForeignError = (function () {
      function ForeignError(value0) {
          this.value0 = value0;
      };
      ForeignError.create = function (value0) {
          return new ForeignError(value0);
      };
      return ForeignError;
  })();

  /**
 *  | A type for foreign type errors
 */  
  var TypeMismatch = (function () {
      function TypeMismatch(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      TypeMismatch.create = function (value0) {
          return function (value1) {
              return new TypeMismatch(value0, value1);
          };
      };
      return TypeMismatch;
  })();

  /**
 *  | A type for foreign type errors
 */  
  var ErrorAtIndex = (function () {
      function ErrorAtIndex(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      ErrorAtIndex.create = function (value0) {
          return function (value1) {
              return new ErrorAtIndex(value0, value1);
          };
      };
      return ErrorAtIndex;
  })();

  /**
 *  | A type for foreign type errors
 */  
  var ErrorAtProperty = (function () {
      function ErrorAtProperty(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      ErrorAtProperty.create = function (value0) {
          return function (value1) {
              return new ErrorAtProperty(value0, value1);
          };
      };
      return ErrorAtProperty;
  })();

  /**
 *  | A type for foreign type errors
 */  
  var JSONError = (function () {
      function JSONError(value0) {
          this.value0 = value0;
      };
      JSONError.create = function (value0) {
          return new JSONError(value0);
      };
      return JSONError;
  })();
  var showForeignError = new Data_Show.Show(function (v) {
      if (v instanceof ForeignError) {
          return "(ForeignError " + (v.value0 + ")");
      };
      if (v instanceof ErrorAtIndex) {
          return "(ErrorAtIndex " + (Data_Show.show(Data_Show.showInt)(v.value0) + (" " + (Data_Show.show(showForeignError)(v.value1) + ")")));
      };
      if (v instanceof ErrorAtProperty) {
          return "(ErrorAtProperty " + (Data_Show.show(Data_Show.showString)(v.value0) + (" " + (Data_Show.show(showForeignError)(v.value1) + ")")));
      };
      if (v instanceof JSONError) {
          return "(JSONError " + (Data_Show.show(Data_Show.showString)(v.value0) + ")");
      };
      if (v instanceof TypeMismatch) {
          return "(TypeMismatch " + (Data_Show.show(Data_Show.showString)(v.value0) + (" " + (Data_Show.show(Data_Show.showString)(v.value1) + ")")));
      };
      throw new Error("Failed pattern match at Data.Foreign line 65, column 3 - line 66, column 3: " + [ v.constructor.name ]);
  });

  /**
 *  | Throws a failure error in `F`.
 */  
  var fail = function ($112) {
      return Control_Monad_Error_Class.throwError(Control_Monad_Except_Trans.monadErrorExceptT(Data_Identity.monadIdentity))(Data_List_NonEmpty.singleton($112));
  };

  /**
 *  | Attempt to parse a JSON string, returning the result as foreign data.
 */  
  var parseJSON = function (json) {
      return $foreign.parseJSONImpl(function ($113) {
          return fail(JSONError.create($113));
      }, Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity)), json);
  };

  /**
 *  | Attempt to coerce a foreign value to an array.
 */  
  var readArray = function (value) {
      if ($foreign.isArray(value)) {
          return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))($foreign.unsafeFromForeign(value));
      };
      if (Data_Boolean.otherwise) {
          return fail(new TypeMismatch("array", $foreign.tagOf(value)));
      };
      throw new Error("Failed pattern match at Data.Foreign line 149, column 1 - line 151, column 58: " + [ value.constructor.name ]);
  };

  /**
 *  | Unsafely coerce a `Foreign` value when the value has a particular `tagOf`
 *  | value.
 */  
  var unsafeReadTagged = function (tag) {
      return function (value) {
          if ($foreign.tagOf(value) === tag) {
              return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))($foreign.unsafeFromForeign(value));
          };
          if (Data_Boolean.otherwise) {
              return fail(new TypeMismatch(tag, $foreign.tagOf(value)));
          };
          throw new Error("Failed pattern match at Data.Foreign line 108, column 1 - line 110, column 54: " + [ tag.constructor.name, value.constructor.name ]);
      };
  };                                            

  /**
 *  | Attempt to coerce a foreign value to a `Number`.
 */  
  var readNumber = unsafeReadTagged("Number");

  /**
 *  | Attempt to coerce a foreign value to an `Int`.
 */  
  var readInt = function (value) {
      var error = Data_Either.Left.create(Data_List_NonEmpty.singleton(new TypeMismatch("Int", $foreign.tagOf(value))));
      var fromNumber = function ($114) {
          return Data_Maybe.maybe(error)(Control_Applicative.pure(Data_Either.applicativeEither))(Data_Int.fromNumber($114));
      };
      return Control_Monad_Except.mapExcept(Data_Either.either(Data_Function["const"](error))(fromNumber))(readNumber(value));
  };

  /**
 *  | Attempt to coerce a foreign value to a `String`.
 */  
  var readString = unsafeReadTagged("String");
  exports["ForeignError"] = ForeignError;
  exports["TypeMismatch"] = TypeMismatch;
  exports["ErrorAtIndex"] = ErrorAtIndex;
  exports["ErrorAtProperty"] = ErrorAtProperty;
  exports["JSONError"] = JSONError;
  exports["fail"] = fail;
  exports["parseJSON"] = parseJSON;
  exports["readArray"] = readArray;
  exports["readInt"] = readInt;
  exports["readNumber"] = readNumber;
  exports["readString"] = readString;
  exports["unsafeReadTagged"] = unsafeReadTagged;
  exports["showForeignError"] = showForeignError;
  exports["isNull"] = $foreign.isNull;
  exports["isUndefined"] = $foreign.isUndefined;
  exports["toForeign"] = $foreign.toForeign;
  exports["typeOf"] = $foreign.typeOf;
})(PS["Data.Foreign"] = PS["Data.Foreign"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  // jshint maxparams: 4
  exports.unsafeReadPropImpl = function (f, s, key, value) {
    return value == null ? f : s(value[key]);
  };

  // jshint maxparams: 2
  exports.unsafeHasOwnProperty = function (prop, value) {
    return Object.prototype.hasOwnProperty.call(value, prop);
  };

  exports.unsafeHasProperty = function (prop, value) {
    return prop in value;
  };
})(PS["Data.Foreign.Index"] = PS["Data.Foreign.Index"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines a type class for types which act like
 *  | _property indices_.
 */  
  "use strict";
  var $foreign = PS["Data.Foreign.Index"];
  var Prelude = PS["Prelude"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Data_Function = PS["Data.Function"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Monad_Except_Trans = PS["Control.Monad.Except.Trans"];
  var Data_Identity = PS["Data.Identity"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Eq = PS["Data.Eq"];        

  /**
 *  | This type class identifies types that act like _property indices_.
 *  |
 *  | The canonical instances are for `String`s and `Int`s.
 */  
  var Index = function (errorAt, hasOwnProperty, hasProperty, ix) {
      this.errorAt = errorAt;
      this.hasOwnProperty = hasOwnProperty;
      this.hasProperty = hasProperty;
      this.ix = ix;
  };
  var unsafeReadProp = function (k) {
      return function (value) {
          return $foreign.unsafeReadPropImpl(Data_Foreign.fail(new Data_Foreign.TypeMismatch("object", Data_Foreign.typeOf(value))), Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity)), k, value);
      };
  };

  /**
 *  | Attempt to read a value from a foreign value property
 */  
  var prop = unsafeReadProp;

  /**
 *  | This type class identifies types that act like _property indices_.
 *  |
 *  | The canonical instances are for `String`s and `Int`s.
 */  
  var ix = function (dict) {
      return dict.ix;
  };                         
  var hasPropertyImpl = function (v) {
      return function (value) {
          if (Data_Foreign.isNull(value)) {
              return false;
          };
          if (Data_Foreign.isUndefined(value)) {
              return false;
          };
          if (Data_Foreign.typeOf(value) === "object" || Data_Foreign.typeOf(value) === "function") {
              return $foreign.unsafeHasProperty(v, value);
          };
          return false;
      };
  };

  /**
 *  | This type class identifies types that act like _property indices_.
 *  |
 *  | The canonical instances are for `String`s and `Int`s.
 */  
  var hasProperty = function (dict) {
      return dict.hasProperty;
  };
  var hasOwnPropertyImpl = function (v) {
      return function (value) {
          if (Data_Foreign.isNull(value)) {
              return false;
          };
          if (Data_Foreign.isUndefined(value)) {
              return false;
          };
          if (Data_Foreign.typeOf(value) === "object" || Data_Foreign.typeOf(value) === "function") {
              return $foreign.unsafeHasOwnProperty(v, value);
          };
          return false;
      };
  };                                                                                                                         
  var indexString = new Index(Data_Foreign.ErrorAtProperty.create, hasOwnPropertyImpl, hasPropertyImpl, Data_Function.flip(prop));

  /**
 *  | This type class identifies types that act like _property indices_.
 *  |
 *  | The canonical instances are for `String`s and `Int`s.
 */  
  var hasOwnProperty = function (dict) {
      return dict.hasOwnProperty;
  };

  /**
 *  | This type class identifies types that act like _property indices_.
 *  |
 *  | The canonical instances are for `String`s and `Int`s.
 */  
  var errorAt = function (dict) {
      return dict.errorAt;
  };
  exports["Index"] = Index;
  exports["errorAt"] = errorAt;
  exports["hasOwnProperty"] = hasOwnProperty;
  exports["hasProperty"] = hasProperty;
  exports["ix"] = ix;
  exports["prop"] = prop;
  exports["indexString"] = indexString;
})(PS["Data.Foreign.Index"] = PS["Data.Foreign.Index"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines a type class for reading foreign values.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Monad_Except = PS["Control.Monad.Except"];
  var Data_Array = PS["Data.Array"];
  var Data_Bifunctor = PS["Data.Bifunctor"];
  var Data_Either = PS["Data.Either"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Foreign_Index = PS["Data.Foreign.Index"];
  var Data_Foreign_Null = PS["Data.Foreign.Null"];
  var Data_Foreign_NullOrUndefined = PS["Data.Foreign.NullOrUndefined"];
  var Data_Foreign_Undefined = PS["Data.Foreign.Undefined"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Traversable = PS["Data.Traversable"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Semiring = PS["Data.Semiring"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Category = PS["Control.Category"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Control_Monad_Except_Trans = PS["Control.Monad.Except.Trans"];
  var Data_List_Types = PS["Data.List.Types"];
  var Data_Identity = PS["Data.Identity"];        

  /**
 *  | A type class instance for this class can be written for a type if it
 *  | is possible to attempt to _safely_ coerce a `Foreign` value to that
 *  | type.
 *  |
 *  | Instances are provided for standard data structures, and the `F` monad
 *  | can be used to construct instances for new data structures.
 */  
  var IsForeign = function (read) {
      this.read = read;
  };
  var stringIsForeign = new IsForeign(Data_Foreign.readString);

  /**
 *  | A type class instance for this class can be written for a type if it
 *  | is possible to attempt to _safely_ coerce a `Foreign` value to that
 *  | type.
 *  |
 *  | Instances are provided for standard data structures, and the `F` monad
 *  | can be used to construct instances for new data structures.
 */  
  var read = function (dict) {
      return dict.read;
  };

  /**
 *  | Attempt to read a foreign value, handling errors using the specified function
 */  
  var readWith = function (dictIsForeign) {
      return function (f) {
          return function ($23) {
              return Control_Monad_Except.mapExcept(Data_Bifunctor.lmap(Data_Either.bifunctorEither)(f))(read(dictIsForeign)($23));
          };
      };
  };

  /**
 *  | Attempt to read a property of a foreign value at the specified index
 */  
  var readProp = function (dictIsForeign) {
      return function (dictIndex) {
          return function (prop) {
              return function (value) {
                  return Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Data_Foreign_Index.ix(dictIndex)(value)(prop))(readWith(dictIsForeign)(Data_Functor.map(Data_List_Types.functorNonEmptyList)(Data_Foreign_Index.errorAt(dictIndex)(prop))));
              };
          };
      };
  };
  var intIsForeign = new IsForeign(Data_Foreign.readInt);  
  var foreignIsForeign = new IsForeign(Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity)));
  var arrayIsForeign = function (dictIsForeign) {
      return new IsForeign((function () {
          var readElement = function (i) {
              return function (value) {
                  return readWith(dictIsForeign)(Data_Functor.map(Data_List_Types.functorNonEmptyList)(Data_Foreign.ErrorAtIndex.create(i)))(value);
              };
          };
          var readElements = function (arr) {
              return Data_Traversable.sequence(Data_Traversable.traversableArray)(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(Data_Array.zipWith(readElement)(Data_Array.range(0)(Data_Array.length(arr)))(arr));
          };
          return Control_Bind.composeKleisli(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Data_Foreign.readArray)(readElements);
      })());
  };
  exports["IsForeign"] = IsForeign;
  exports["read"] = read;
  exports["readProp"] = readProp;
  exports["readWith"] = readWith;
  exports["foreignIsForeign"] = foreignIsForeign;
  exports["stringIsForeign"] = stringIsForeign;
  exports["intIsForeign"] = intIsForeign;
  exports["arrayIsForeign"] = arrayIsForeign;
})(PS["Data.Foreign.Class"] = PS["Data.Foreign.Class"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines a type of maps as balanced 2-3 trees, based on
 *  | <http://www.cs.princeton.edu/~dpw/courses/cos326-12/ass/2-3-trees.pdf>
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_List = PS["Data.List"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Unfoldable = PS["Data.Unfoldable"];
  var Partial_Unsafe = PS["Partial.Unsafe"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Category = PS["Control.Category"];
  var Data_List_Types = PS["Data.List.Types"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Function = PS["Data.Function"];
  var Data_Ordering = PS["Data.Ordering"];
  var Data_Semiring = PS["Data.Semiring"];        

  /**
 *  | `Map k v` represents maps from keys of type `k` to values of type `v`.
 */  
  var Leaf = (function () {
      function Leaf() {

      };
      Leaf.value = new Leaf();
      return Leaf;
  })();

  /**
 *  | `Map k v` represents maps from keys of type `k` to values of type `v`.
 */  
  var Two = (function () {
      function Two(value0, value1, value2, value3) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
      };
      Two.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return new Two(value0, value1, value2, value3);
                  };
              };
          };
      };
      return Two;
  })();

  /**
 *  | `Map k v` represents maps from keys of type `k` to values of type `v`.
 */  
  var Three = (function () {
      function Three(value0, value1, value2, value3, value4, value5, value6) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
          this.value4 = value4;
          this.value5 = value5;
          this.value6 = value6;
      };
      Three.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return function (value4) {
                          return function (value5) {
                              return function (value6) {
                                  return new Three(value0, value1, value2, value3, value4, value5, value6);
                              };
                          };
                      };
                  };
              };
          };
      };
      return Three;
  })();
  var TwoLeft = (function () {
      function TwoLeft(value0, value1, value2) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
      };
      TwoLeft.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return new TwoLeft(value0, value1, value2);
              };
          };
      };
      return TwoLeft;
  })();
  var TwoRight = (function () {
      function TwoRight(value0, value1, value2) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
      };
      TwoRight.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return new TwoRight(value0, value1, value2);
              };
          };
      };
      return TwoRight;
  })();
  var ThreeLeft = (function () {
      function ThreeLeft(value0, value1, value2, value3, value4, value5) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
          this.value4 = value4;
          this.value5 = value5;
      };
      ThreeLeft.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return function (value4) {
                          return function (value5) {
                              return new ThreeLeft(value0, value1, value2, value3, value4, value5);
                          };
                      };
                  };
              };
          };
      };
      return ThreeLeft;
  })();
  var ThreeMiddle = (function () {
      function ThreeMiddle(value0, value1, value2, value3, value4, value5) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
          this.value4 = value4;
          this.value5 = value5;
      };
      ThreeMiddle.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return function (value4) {
                          return function (value5) {
                              return new ThreeMiddle(value0, value1, value2, value3, value4, value5);
                          };
                      };
                  };
              };
          };
      };
      return ThreeMiddle;
  })();
  var ThreeRight = (function () {
      function ThreeRight(value0, value1, value2, value3, value4, value5) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
          this.value4 = value4;
          this.value5 = value5;
      };
      ThreeRight.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return function (value4) {
                          return function (value5) {
                              return new ThreeRight(value0, value1, value2, value3, value4, value5);
                          };
                      };
                  };
              };
          };
      };
      return ThreeRight;
  })();
  var KickUp = (function () {
      function KickUp(value0, value1, value2, value3) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
      };
      KickUp.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return new KickUp(value0, value1, value2, value3);
                  };
              };
          };
      };
      return KickUp;
  })();
  var toList = function (v) {
      if (v instanceof Leaf) {
          return Data_List_Types.Nil.value;
      };
      if (v instanceof Two) {
          return Data_Semigroup.append(Data_List_Types.semigroupList)(toList(v.value0))(new Data_List_Types.Cons(new Data_Tuple.Tuple(v.value1, v.value2), toList(v.value3)));
      };
      if (v instanceof Three) {
          return Data_Semigroup.append(Data_List_Types.semigroupList)(toList(v.value0))(Data_Semigroup.append(Data_List_Types.semigroupList)(new Data_List_Types.Cons(new Data_Tuple.Tuple(v.value1, v.value2), toList(v.value3)))(new Data_List_Types.Cons(new Data_Tuple.Tuple(v.value4, v.value5), toList(v.value6))));
      };
      throw new Error("Failed pattern match at Data.Map line 383, column 1 - line 383, column 18: " + [ v.constructor.name ]);
  };

  /**
 *  | Create a map with one key/value pair
 */  
  var singleton = function (k) {
      return function (v) {
          return new Two(Leaf.value, k, v, Leaf.value);
      };
  };
  var showMap = function (dictShow) {
      return function (dictShow1) {
          return new Data_Show.Show(function (m) {
              return "(fromList " + (Data_Show.show(Data_List_Types.showList(Data_Tuple.showTuple(dictShow)(dictShow1)))(toList(m)) + ")");
          });
      };
  };
  var lookup = function (dictOrd) {
      return Partial_Unsafe.unsafePartial(function (dictPartial) {
          return function (k) {
              return function (tree) {
                  if (tree instanceof Leaf) {
                      return Data_Maybe.Nothing.value;
                  };
                  var comp = Data_Ord.compare(dictOrd);
                  var __unused = function (dictPartial1) {
                      return function ($dollar42) {
                          return $dollar42;
                      };
                  };
                  return __unused(dictPartial)((function () {
                      if (tree instanceof Two) {
                          var $177 = comp(k)(tree.value1);
                          if ($177 instanceof Data_Ordering.EQ) {
                              return new Data_Maybe.Just(tree.value2);
                          };
                          if ($177 instanceof Data_Ordering.LT) {
                              return lookup(dictOrd)(k)(tree.value0);
                          };
                          return lookup(dictOrd)(k)(tree.value3);
                      };
                      if (tree instanceof Three) {
                          var $182 = comp(k)(tree.value1);
                          if ($182 instanceof Data_Ordering.EQ) {
                              return new Data_Maybe.Just(tree.value2);
                          };
                          var $184 = comp(k)(tree.value4);
                          if ($184 instanceof Data_Ordering.EQ) {
                              return new Data_Maybe.Just(tree.value5);
                          };
                          if ($182 instanceof Data_Ordering.LT) {
                              return lookup(dictOrd)(k)(tree.value0);
                          };
                          if ($184 instanceof Data_Ordering.GT) {
                              return lookup(dictOrd)(k)(tree.value6);
                          };
                          return lookup(dictOrd)(k)(tree.value3);
                      };
                      throw new Error("Failed pattern match at Data.Map line 146, column 10 - line 160, column 39: " + [ tree.constructor.name ]);
                  })());
              };
          };
      });
  };
  var keys = function (v) {
      if (v instanceof Leaf) {
          return Data_List_Types.Nil.value;
      };
      if (v instanceof Two) {
          return Data_Semigroup.append(Data_List_Types.semigroupList)(keys(v.value0))(Data_Semigroup.append(Data_List_Types.semigroupList)(Control_Applicative.pure(Data_List_Types.applicativeList)(v.value1))(keys(v.value3)));
      };
      if (v instanceof Three) {
          return Data_Semigroup.append(Data_List_Types.semigroupList)(keys(v.value0))(Data_Semigroup.append(Data_List_Types.semigroupList)(Control_Applicative.pure(Data_List_Types.applicativeList)(v.value1))(Data_Semigroup.append(Data_List_Types.semigroupList)(keys(v.value3))(Data_Semigroup.append(Data_List_Types.semigroupList)(Control_Applicative.pure(Data_List_Types.applicativeList)(v.value4))(keys(v.value6)))));
      };
      throw new Error("Failed pattern match at Data.Map line 400, column 1 - line 400, column 16: " + [ v.constructor.name ]);
  };
  var functorMap = new Data_Functor.Functor(function (v) {
      return function (v1) {
          if (v1 instanceof Leaf) {
              return Leaf.value;
          };
          if (v1 instanceof Two) {
              return new Two(Data_Functor.map(functorMap)(v)(v1.value0), v1.value1, v(v1.value2), Data_Functor.map(functorMap)(v)(v1.value3));
          };
          if (v1 instanceof Three) {
              return new Three(Data_Functor.map(functorMap)(v)(v1.value0), v1.value1, v(v1.value2), Data_Functor.map(functorMap)(v)(v1.value3), v1.value4, v(v1.value5), Data_Functor.map(functorMap)(v)(v1.value6));
          };
          throw new Error("Failed pattern match at Data.Map line 71, column 3 - line 71, column 20: " + [ v.constructor.name, v1.constructor.name ]);
      };
  });
  var fromZipper = function (__copy_dictOrd) {
      return function (__copy_v) {
          return function (__copy_tree) {
              var dictOrd = __copy_dictOrd;
              var v = __copy_v;
              var tree = __copy_tree;
              tco: while (true) {
                  if (v instanceof Data_List_Types.Nil) {
                      return tree;
                  };
                  if (v instanceof Data_List_Types.Cons) {
                      if (v.value0 instanceof TwoLeft) {
                          var __tco_dictOrd = dictOrd;
                          var __tco_v = v.value1;
                          var __tco_tree = new Two(tree, v.value0.value0, v.value0.value1, v.value0.value2);
                          dictOrd = __tco_dictOrd;
                          v = __tco_v;
                          tree = __tco_tree;
                          continue tco;
                      };
                      if (v.value0 instanceof TwoRight) {
                          var __tco_dictOrd = dictOrd;
                          var __tco_v = v.value1;
                          var __tco_tree = new Two(v.value0.value0, v.value0.value1, v.value0.value2, tree);
                          dictOrd = __tco_dictOrd;
                          v = __tco_v;
                          tree = __tco_tree;
                          continue tco;
                      };
                      if (v.value0 instanceof ThreeLeft) {
                          var __tco_dictOrd = dictOrd;
                          var __tco_v = v.value1;
                          var __tco_tree = new Three(tree, v.value0.value0, v.value0.value1, v.value0.value2, v.value0.value3, v.value0.value4, v.value0.value5);
                          dictOrd = __tco_dictOrd;
                          v = __tco_v;
                          tree = __tco_tree;
                          continue tco;
                      };
                      if (v.value0 instanceof ThreeMiddle) {
                          var __tco_dictOrd = dictOrd;
                          var __tco_v = v.value1;
                          var __tco_tree = new Three(v.value0.value0, v.value0.value1, v.value0.value2, tree, v.value0.value3, v.value0.value4, v.value0.value5);
                          dictOrd = __tco_dictOrd;
                          v = __tco_v;
                          tree = __tco_tree;
                          continue tco;
                      };
                      if (v.value0 instanceof ThreeRight) {
                          var __tco_dictOrd = dictOrd;
                          var __tco_v = v.value1;
                          var __tco_tree = new Three(v.value0.value0, v.value0.value1, v.value0.value2, v.value0.value3, v.value0.value4, v.value0.value5, tree);
                          dictOrd = __tco_dictOrd;
                          v = __tco_v;
                          tree = __tco_tree;
                          continue tco;
                      };
                      throw new Error("Failed pattern match at Data.Map line 237, column 3 - line 242, column 88: " + [ v.value0.constructor.name ]);
                  };
                  throw new Error("Failed pattern match at Data.Map line 235, column 1 - line 235, column 27: " + [ v.constructor.name, tree.constructor.name ]);
              };
          };
      };
  };

  /**
 *  | Insert a key/value pair into a map
 */  
  var insert = function (dictOrd) {
      var up = function (__copy_v) {
          return function (__copy_v1) {
              var v = __copy_v;
              var v1 = __copy_v1;
              tco: while (true) {
                  if (v instanceof Data_List_Types.Nil) {
                      return new Two(v1.value0, v1.value1, v1.value2, v1.value3);
                  };
                  if (v instanceof Data_List_Types.Cons) {
                      if (v.value0 instanceof TwoLeft) {
                          return fromZipper(dictOrd)(v.value1)(new Three(v1.value0, v1.value1, v1.value2, v1.value3, v.value0.value0, v.value0.value1, v.value0.value2));
                      };
                      if (v.value0 instanceof TwoRight) {
                          return fromZipper(dictOrd)(v.value1)(new Three(v.value0.value0, v.value0.value1, v.value0.value2, v1.value0, v1.value1, v1.value2, v1.value3));
                      };
                      if (v.value0 instanceof ThreeLeft) {
                          var __tco_v = v.value1;
                          var __tco_v1 = new KickUp(new Two(v1.value0, v1.value1, v1.value2, v1.value3), v.value0.value0, v.value0.value1, new Two(v.value0.value2, v.value0.value3, v.value0.value4, v.value0.value5));
                          v = __tco_v;
                          v1 = __tco_v1;
                          continue tco;
                      };
                      if (v.value0 instanceof ThreeMiddle) {
                          var __tco_v = v.value1;
                          var __tco_v1 = new KickUp(new Two(v.value0.value0, v.value0.value1, v.value0.value2, v1.value0), v1.value1, v1.value2, new Two(v1.value3, v.value0.value3, v.value0.value4, v.value0.value5));
                          v = __tco_v;
                          v1 = __tco_v1;
                          continue tco;
                      };
                      if (v.value0 instanceof ThreeRight) {
                          var __tco_v = v.value1;
                          var __tco_v1 = new KickUp(new Two(v.value0.value0, v.value0.value1, v.value0.value2, v.value0.value3), v.value0.value4, v.value0.value5, new Two(v1.value0, v1.value1, v1.value2, v1.value3));
                          v = __tco_v;
                          v1 = __tco_v1;
                          continue tco;
                      };
                      throw new Error("Failed pattern match at Data.Map line 273, column 5 - line 278, column 104: " + [ v.value0.constructor.name, v1.constructor.name ]);
                  };
                  throw new Error("Failed pattern match at Data.Map line 271, column 3 - line 271, column 54: " + [ v.constructor.name, v1.constructor.name ]);
              };
          };
      };
      var comp = Data_Ord.compare(dictOrd);
      var down = function (__copy_ctx) {
          return function (__copy_k) {
              return function (__copy_v) {
                  return function (__copy_v1) {
                      var ctx = __copy_ctx;
                      var k = __copy_k;
                      var v = __copy_v;
                      var v1 = __copy_v1;
                      tco: while (true) {
                          if (v1 instanceof Leaf) {
                              return up(ctx)(new KickUp(Leaf.value, k, v, Leaf.value));
                          };
                          if (v1 instanceof Two) {
                              var $305 = comp(k)(v1.value1);
                              if ($305 instanceof Data_Ordering.EQ) {
                                  return fromZipper(dictOrd)(ctx)(new Two(v1.value0, k, v, v1.value3));
                              };
                              if ($305 instanceof Data_Ordering.LT) {
                                  var __tco_ctx = new Data_List_Types.Cons(new TwoLeft(v1.value1, v1.value2, v1.value3), ctx);
                                  var __tco_k = k;
                                  var __tco_v = v;
                                  var __tco_v1 = v1.value0;
                                  ctx = __tco_ctx;
                                  k = __tco_k;
                                  v = __tco_v;
                                  v1 = __tco_v1;
                                  continue tco;
                              };
                              var __tco_ctx = new Data_List_Types.Cons(new TwoRight(v1.value0, v1.value1, v1.value2), ctx);
                              var __tco_k = k;
                              var __tco_v = v;
                              var __tco_v1 = v1.value3;
                              ctx = __tco_ctx;
                              k = __tco_k;
                              v = __tco_v;
                              v1 = __tco_v1;
                              continue tco;
                          };
                          if (v1 instanceof Three) {
                              var $310 = comp(k)(v1.value1);
                              if ($310 instanceof Data_Ordering.EQ) {
                                  return fromZipper(dictOrd)(ctx)(new Three(v1.value0, k, v, v1.value3, v1.value4, v1.value5, v1.value6));
                              };
                              var $312 = comp(k)(v1.value4);
                              if ($312 instanceof Data_Ordering.EQ) {
                                  return fromZipper(dictOrd)(ctx)(new Three(v1.value0, v1.value1, v1.value2, v1.value3, k, v, v1.value6));
                              };
                              if ($310 instanceof Data_Ordering.LT) {
                                  var __tco_ctx = new Data_List_Types.Cons(new ThreeLeft(v1.value1, v1.value2, v1.value3, v1.value4, v1.value5, v1.value6), ctx);
                                  var __tco_k = k;
                                  var __tco_v = v;
                                  var __tco_v1 = v1.value0;
                                  ctx = __tco_ctx;
                                  k = __tco_k;
                                  v = __tco_v;
                                  v1 = __tco_v1;
                                  continue tco;
                              };
                              if ($310 instanceof Data_Ordering.GT && $312 instanceof Data_Ordering.LT) {
                                  var __tco_ctx = new Data_List_Types.Cons(new ThreeMiddle(v1.value0, v1.value1, v1.value2, v1.value4, v1.value5, v1.value6), ctx);
                                  var __tco_k = k;
                                  var __tco_v = v;
                                  var __tco_v1 = v1.value3;
                                  ctx = __tco_ctx;
                                  k = __tco_k;
                                  v = __tco_v;
                                  v1 = __tco_v1;
                                  continue tco;
                              };
                              var __tco_ctx = new Data_List_Types.Cons(new ThreeRight(v1.value0, v1.value1, v1.value2, v1.value3, v1.value4, v1.value5), ctx);
                              var __tco_k = k;
                              var __tco_v = v;
                              var __tco_v1 = v1.value6;
                              ctx = __tco_ctx;
                              k = __tco_k;
                              v = __tco_v;
                              v1 = __tco_v1;
                              continue tco;
                          };
                          throw new Error("Failed pattern match at Data.Map line 254, column 3 - line 254, column 52: " + [ ctx.constructor.name, k.constructor.name, v.constructor.name, v1.constructor.name ]);
                      };
                  };
              };
          };
      };
      return down(Data_List_Types.Nil.value);
  };

  /**
 *  | Delete a key and its corresponding value from a map, returning the value
 *  | as well as the subsequent map.
 */  
  var pop = function (dictOrd) {
      var up = Partial_Unsafe.unsafePartial(function (dictPartial) {
          return function (ctxs) {
              return function (tree) {
                  if (ctxs instanceof Data_List_Types.Nil) {
                      return tree;
                  };
                  if (ctxs instanceof Data_List_Types.Cons) {
                      var __unused = function (dictPartial1) {
                          return function ($dollar50) {
                              return $dollar50;
                          };
                      };
                      return __unused(dictPartial)((function () {
                          if (ctxs.value0 instanceof TwoLeft && (ctxs.value0.value2 instanceof Leaf && tree instanceof Leaf)) {
                              return fromZipper(dictOrd)(ctxs.value1)(new Two(Leaf.value, ctxs.value0.value0, ctxs.value0.value1, Leaf.value));
                          };
                          if (ctxs.value0 instanceof TwoRight && (ctxs.value0.value0 instanceof Leaf && tree instanceof Leaf)) {
                              return fromZipper(dictOrd)(ctxs.value1)(new Two(Leaf.value, ctxs.value0.value1, ctxs.value0.value2, Leaf.value));
                          };
                          if (ctxs.value0 instanceof TwoLeft && ctxs.value0.value2 instanceof Two) {
                              return up(ctxs.value1)(new Three(tree, ctxs.value0.value0, ctxs.value0.value1, ctxs.value0.value2.value0, ctxs.value0.value2.value1, ctxs.value0.value2.value2, ctxs.value0.value2.value3));
                          };
                          if (ctxs.value0 instanceof TwoRight && ctxs.value0.value0 instanceof Two) {
                              return up(ctxs.value1)(new Three(ctxs.value0.value0.value0, ctxs.value0.value0.value1, ctxs.value0.value0.value2, ctxs.value0.value0.value3, ctxs.value0.value1, ctxs.value0.value2, tree));
                          };
                          if (ctxs.value0 instanceof TwoLeft && ctxs.value0.value2 instanceof Three) {
                              return fromZipper(dictOrd)(ctxs.value1)(new Two(new Two(tree, ctxs.value0.value0, ctxs.value0.value1, ctxs.value0.value2.value0), ctxs.value0.value2.value1, ctxs.value0.value2.value2, new Two(ctxs.value0.value2.value3, ctxs.value0.value2.value4, ctxs.value0.value2.value5, ctxs.value0.value2.value6)));
                          };
                          if (ctxs.value0 instanceof TwoRight && ctxs.value0.value0 instanceof Three) {
                              return fromZipper(dictOrd)(ctxs.value1)(new Two(new Two(ctxs.value0.value0.value0, ctxs.value0.value0.value1, ctxs.value0.value0.value2, ctxs.value0.value0.value3), ctxs.value0.value0.value4, ctxs.value0.value0.value5, new Two(ctxs.value0.value0.value6, ctxs.value0.value1, ctxs.value0.value2, tree)));
                          };
                          if (ctxs.value0 instanceof ThreeLeft && (ctxs.value0.value2 instanceof Leaf && (ctxs.value0.value5 instanceof Leaf && tree instanceof Leaf))) {
                              return fromZipper(dictOrd)(ctxs.value1)(new Three(Leaf.value, ctxs.value0.value0, ctxs.value0.value1, Leaf.value, ctxs.value0.value3, ctxs.value0.value4, Leaf.value));
                          };
                          if (ctxs.value0 instanceof ThreeMiddle && (ctxs.value0.value0 instanceof Leaf && (ctxs.value0.value5 instanceof Leaf && tree instanceof Leaf))) {
                              return fromZipper(dictOrd)(ctxs.value1)(new Three(Leaf.value, ctxs.value0.value1, ctxs.value0.value2, Leaf.value, ctxs.value0.value3, ctxs.value0.value4, Leaf.value));
                          };
                          if (ctxs.value0 instanceof ThreeRight && (ctxs.value0.value0 instanceof Leaf && (ctxs.value0.value3 instanceof Leaf && tree instanceof Leaf))) {
                              return fromZipper(dictOrd)(ctxs.value1)(new Three(Leaf.value, ctxs.value0.value1, ctxs.value0.value2, Leaf.value, ctxs.value0.value4, ctxs.value0.value5, Leaf.value));
                          };
                          if (ctxs.value0 instanceof ThreeLeft && ctxs.value0.value2 instanceof Two) {
                              return fromZipper(dictOrd)(ctxs.value1)(new Two(new Three(tree, ctxs.value0.value0, ctxs.value0.value1, ctxs.value0.value2.value0, ctxs.value0.value2.value1, ctxs.value0.value2.value2, ctxs.value0.value2.value3), ctxs.value0.value3, ctxs.value0.value4, ctxs.value0.value5));
                          };
                          if (ctxs.value0 instanceof ThreeMiddle && ctxs.value0.value0 instanceof Two) {
                              return fromZipper(dictOrd)(ctxs.value1)(new Two(new Three(ctxs.value0.value0.value0, ctxs.value0.value0.value1, ctxs.value0.value0.value2, ctxs.value0.value0.value3, ctxs.value0.value1, ctxs.value0.value2, tree), ctxs.value0.value3, ctxs.value0.value4, ctxs.value0.value5));
                          };
                          if (ctxs.value0 instanceof ThreeMiddle && ctxs.value0.value5 instanceof Two) {
                              return fromZipper(dictOrd)(ctxs.value1)(new Two(ctxs.value0.value0, ctxs.value0.value1, ctxs.value0.value2, new Three(tree, ctxs.value0.value3, ctxs.value0.value4, ctxs.value0.value5.value0, ctxs.value0.value5.value1, ctxs.value0.value5.value2, ctxs.value0.value5.value3)));
                          };
                          if (ctxs.value0 instanceof ThreeRight && ctxs.value0.value3 instanceof Two) {
                              return fromZipper(dictOrd)(ctxs.value1)(new Two(ctxs.value0.value0, ctxs.value0.value1, ctxs.value0.value2, new Three(ctxs.value0.value3.value0, ctxs.value0.value3.value1, ctxs.value0.value3.value2, ctxs.value0.value3.value3, ctxs.value0.value4, ctxs.value0.value5, tree)));
                          };
                          if (ctxs.value0 instanceof ThreeLeft && ctxs.value0.value2 instanceof Three) {
                              return fromZipper(dictOrd)(ctxs.value1)(new Three(new Two(tree, ctxs.value0.value0, ctxs.value0.value1, ctxs.value0.value2.value0), ctxs.value0.value2.value1, ctxs.value0.value2.value2, new Two(ctxs.value0.value2.value3, ctxs.value0.value2.value4, ctxs.value0.value2.value5, ctxs.value0.value2.value6), ctxs.value0.value3, ctxs.value0.value4, ctxs.value0.value5));
                          };
                          if (ctxs.value0 instanceof ThreeMiddle && ctxs.value0.value0 instanceof Three) {
                              return fromZipper(dictOrd)(ctxs.value1)(new Three(new Two(ctxs.value0.value0.value0, ctxs.value0.value0.value1, ctxs.value0.value0.value2, ctxs.value0.value0.value3), ctxs.value0.value0.value4, ctxs.value0.value0.value5, new Two(ctxs.value0.value0.value6, ctxs.value0.value1, ctxs.value0.value2, tree), ctxs.value0.value3, ctxs.value0.value4, ctxs.value0.value5));
                          };
                          if (ctxs.value0 instanceof ThreeMiddle && ctxs.value0.value5 instanceof Three) {
                              return fromZipper(dictOrd)(ctxs.value1)(new Three(ctxs.value0.value0, ctxs.value0.value1, ctxs.value0.value2, new Two(tree, ctxs.value0.value3, ctxs.value0.value4, ctxs.value0.value5.value0), ctxs.value0.value5.value1, ctxs.value0.value5.value2, new Two(ctxs.value0.value5.value3, ctxs.value0.value5.value4, ctxs.value0.value5.value5, ctxs.value0.value5.value6)));
                          };
                          if (ctxs.value0 instanceof ThreeRight && ctxs.value0.value3 instanceof Three) {
                              return fromZipper(dictOrd)(ctxs.value1)(new Three(ctxs.value0.value0, ctxs.value0.value1, ctxs.value0.value2, new Two(ctxs.value0.value3.value0, ctxs.value0.value3.value1, ctxs.value0.value3.value2, ctxs.value0.value3.value3), ctxs.value0.value3.value4, ctxs.value0.value3.value5, new Two(ctxs.value0.value3.value6, ctxs.value0.value4, ctxs.value0.value5, tree)));
                          };
                          throw new Error("Failed pattern match at Data.Map line 323, column 9 - line 340, column 136: " + [ ctxs.value0.constructor.name, tree.constructor.name ]);
                      })());
                  };
                  throw new Error("Failed pattern match at Data.Map line 320, column 5 - line 340, column 136: " + [ ctxs.constructor.name ]);
              };
          };
      });
      var removeMaxNode = Partial_Unsafe.unsafePartial(function (dictPartial) {
          return function (ctx) {
              return function (m) {
                  var __unused = function (dictPartial1) {
                      return function ($dollar52) {
                          return $dollar52;
                      };
                  };
                  return __unused(dictPartial)((function () {
                      if (m instanceof Two && (m.value0 instanceof Leaf && m.value3 instanceof Leaf)) {
                          return up(ctx)(Leaf.value);
                      };
                      if (m instanceof Two) {
                          return removeMaxNode(new Data_List_Types.Cons(new TwoRight(m.value0, m.value1, m.value2), ctx))(m.value3);
                      };
                      if (m instanceof Three && (m.value0 instanceof Leaf && (m.value3 instanceof Leaf && m.value6 instanceof Leaf))) {
                          return up(new Data_List_Types.Cons(new TwoRight(Leaf.value, m.value1, m.value2), ctx))(Leaf.value);
                      };
                      if (m instanceof Three) {
                          return removeMaxNode(new Data_List_Types.Cons(new ThreeRight(m.value0, m.value1, m.value2, m.value3, m.value4, m.value5), ctx))(m.value6);
                      };
                      throw new Error("Failed pattern match at Data.Map line 352, column 5 - line 356, column 107: " + [ m.constructor.name ]);
                  })());
              };
          };
      });
      var maxNode = Partial_Unsafe.unsafePartial(function (dictPartial) {
          return function (m) {
              var __unused = function (dictPartial1) {
                  return function ($dollar54) {
                      return $dollar54;
                  };
              };
              return __unused(dictPartial)((function () {
                  if (m instanceof Two && m.value3 instanceof Leaf) {
                      return {
                          key: m.value1, 
                          value: m.value2
                      };
                  };
                  if (m instanceof Two) {
                      return maxNode(m.value3);
                  };
                  if (m instanceof Three && m.value6 instanceof Leaf) {
                      return {
                          key: m.value4, 
                          value: m.value5
                      };
                  };
                  if (m instanceof Three) {
                      return maxNode(m.value6);
                  };
                  throw new Error("Failed pattern match at Data.Map line 343, column 33 - line 347, column 45: " + [ m.constructor.name ]);
              })());
          };
      });
      var comp = Data_Ord.compare(dictOrd);
      var down = Partial_Unsafe.unsafePartial(function (dictPartial) {
          return function (ctx) {
              return function (k) {
                  return function (m) {
                      if (m instanceof Leaf) {
                          return Data_Maybe.Nothing.value;
                      };
                      if (m instanceof Two) {
                          var $523 = comp(k)(m.value1);
                          if (m.value3 instanceof Leaf && $523 instanceof Data_Ordering.EQ) {
                              return new Data_Maybe.Just(new Data_Tuple.Tuple(m.value2, up(ctx)(Leaf.value)));
                          };
                          if ($523 instanceof Data_Ordering.EQ) {
                              var max = maxNode(m.value0);
                              return new Data_Maybe.Just(new Data_Tuple.Tuple(m.value2, removeMaxNode(new Data_List_Types.Cons(new TwoLeft(max.key, max.value, m.value3), ctx))(m.value0)));
                          };
                          if ($523 instanceof Data_Ordering.LT) {
                              return down(new Data_List_Types.Cons(new TwoLeft(m.value1, m.value2, m.value3), ctx))(k)(m.value0);
                          };
                          return down(new Data_List_Types.Cons(new TwoRight(m.value0, m.value1, m.value2), ctx))(k)(m.value3);
                      };
                      if (m instanceof Three) {
                          var leaves = (function () {
                              if (m.value0 instanceof Leaf && (m.value3 instanceof Leaf && m.value6 instanceof Leaf)) {
                                  return true;
                              };
                              return false;
                          })();
                          var $532 = comp(k)(m.value1);
                          var $533 = comp(k)(m.value4);
                          if (leaves && $532 instanceof Data_Ordering.EQ) {
                              return new Data_Maybe.Just(new Data_Tuple.Tuple(m.value2, fromZipper(dictOrd)(ctx)(new Two(Leaf.value, m.value4, m.value5, Leaf.value))));
                          };
                          if (leaves && $533 instanceof Data_Ordering.EQ) {
                              return new Data_Maybe.Just(new Data_Tuple.Tuple(m.value5, fromZipper(dictOrd)(ctx)(new Two(Leaf.value, m.value1, m.value2, Leaf.value))));
                          };
                          if ($532 instanceof Data_Ordering.EQ) {
                              var max = maxNode(m.value0);
                              return new Data_Maybe.Just(new Data_Tuple.Tuple(m.value2, removeMaxNode(new Data_List_Types.Cons(new ThreeLeft(max.key, max.value, m.value3, m.value4, m.value5, m.value6), ctx))(m.value0)));
                          };
                          if ($533 instanceof Data_Ordering.EQ) {
                              var max = maxNode(m.value3);
                              return new Data_Maybe.Just(new Data_Tuple.Tuple(m.value5, removeMaxNode(new Data_List_Types.Cons(new ThreeMiddle(m.value0, m.value1, m.value2, max.key, max.value, m.value6), ctx))(m.value3)));
                          };
                          if ($532 instanceof Data_Ordering.LT) {
                              return down(new Data_List_Types.Cons(new ThreeLeft(m.value1, m.value2, m.value3, m.value4, m.value5, m.value6), ctx))(k)(m.value0);
                          };
                          if ($532 instanceof Data_Ordering.GT && $533 instanceof Data_Ordering.LT) {
                              return down(new Data_List_Types.Cons(new ThreeMiddle(m.value0, m.value1, m.value2, m.value4, m.value5, m.value6), ctx))(k)(m.value3);
                          };
                          return down(new Data_List_Types.Cons(new ThreeRight(m.value0, m.value1, m.value2, m.value3, m.value4, m.value5), ctx))(k)(m.value6);
                      };
                      throw new Error("Failed pattern match at Data.Map line 293, column 36 - line 316, column 82: " + [ m.constructor.name ]);
                  };
              };
          };
      });
      return down(Data_List_Types.Nil.value);
  };

  /**
 *  | An empty map
 */  
  var empty = Leaf.value;

  /**
 *  | Delete a key and its corresponding value from a map.
 */  
  var $$delete = function (dictOrd) {
      return function (k) {
          return function (m) {
              return Data_Maybe.maybe(m)(Data_Tuple.snd)(pop(dictOrd)(k)(m));
          };
      };
  };

  /**
 *  | Insert the value, delete a value, or update a value for a key in a map
 */  
  var alter = function (dictOrd) {
      return function (f) {
          return function (k) {
              return function (m) {
                  var $623 = f(lookup(dictOrd)(k)(m));
                  if ($623 instanceof Data_Maybe.Nothing) {
                      return $$delete(dictOrd)(k)(m);
                  };
                  if ($623 instanceof Data_Maybe.Just) {
                      return insert(dictOrd)(k)($623.value0)(m);
                  };
                  throw new Error("Failed pattern match at Data.Map line 361, column 15 - line 363, column 25: " + [ $623.constructor.name ]);
              };
          };
      };
  };

  /**
 *  | Compute the union of two maps, using the specified function
 *  | to combine values for duplicate keys.
 */  
  var unionWith = function (dictOrd) {
      return function (f) {
          return function (m1) {
              return function (m2) {
                  var go = function (m) {
                      return function (v) {
                          return alter(dictOrd)(function ($636) {
                              return Data_Maybe.Just.create(Data_Maybe.maybe(v.value1)(f(v.value1))($636));
                          })(v.value0)(m);
                      };
                  };
                  return Data_Foldable.foldl(Data_List_Types.foldableList)(go)(m2)(toList(m1));
              };
          };
      };
  };

  /**
 *  | Compute the union of two maps, preferring values from the first map in the case
 *  | of duplicate keys
 */  
  var union = function (dictOrd) {
      return unionWith(dictOrd)(Data_Function["const"]);
  };

  /**
 *  | Compute the union of a collection of maps
 */  
  var unions = function (dictOrd) {
      return function (dictFoldable) {
          return Data_Foldable.foldl(dictFoldable)(union(dictOrd))(empty);
      };
  };
  exports["alter"] = alter;
  exports["delete"] = $$delete;
  exports["empty"] = empty;
  exports["insert"] = insert;
  exports["keys"] = keys;
  exports["lookup"] = lookup;
  exports["pop"] = pop;
  exports["singleton"] = singleton;
  exports["toList"] = toList;
  exports["union"] = union;
  exports["unionWith"] = unionWith;
  exports["unions"] = unions;
  exports["showMap"] = showMap;
  exports["functorMap"] = functorMap;
})(PS["Data.Map"] = PS["Data.Map"] || {});
(function(exports) {
    "use strict";

  exports["null"] = null;

  exports.nullable = function (a, r, f) {
    return a == null ? r : f(a);
  };

  exports.notNull = function (x) {
    return x;
  };
})(PS["Data.Nullable"] = PS["Data.Nullable"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines types and functions for working with nullable types
 *  | using the FFI.
 */  
  "use strict";
  var $foreign = PS["Data.Nullable"];
  var Prelude = PS["Prelude"];
  var Data_Function = PS["Data.Function"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Show = PS["Data.Show"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];        

  /**
 *  | Takes `Nothing` to `null`, and `Just a` to `a`.
 */  
  var toNullable = Data_Maybe.maybe($foreign["null"])($foreign.notNull);

  /**
 *  | Represent `null` using `Maybe a` as `Nothing`.
 */  
  var toMaybe = function (n) {
      return $foreign.nullable(n, Data_Maybe.Nothing.value, Data_Maybe.Just.create);
  };
  exports["toMaybe"] = toMaybe;
  exports["toNullable"] = toNullable;
})(PS["Data.Nullable"] = PS["Data.Nullable"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Functor_Contravariant = PS["Data.Functor.Contravariant"];
  var Data_Newtype = PS["Data.Newtype"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Control_Category = PS["Control.Category"];        

  /**
 *  | The opposite of the function category.
 */  
  var Op = function (x) {
      return x;
  }; 
  var newtypeOp = new Data_Newtype.Newtype(function (n) {
      return n;
  }, Op);
  exports["Op"] = Op;
  exports["newtypeOp"] = newtypeOp;
})(PS["Data.Op"] = PS["Data.Op"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  exports._copyEff = function (m) {
    return function () {
      var r = {};
      for (var k in m) {
        if (m.hasOwnProperty(k)) {
          r[k] = m[k];
        }
      }
      return r;
    };
  };

  exports.empty = {};

  exports.runST = function (f) {
    return f;
  };

  // jshint maxparams: 4
  exports._lookup = function (no, yes, k, m) {
    return k in m ? yes(m[k]) : no;
  };

  function _collect(f) {
    return function (m) {
      var r = [];
      for (var k in m) {
        if (m.hasOwnProperty(k)) {
          r.push(f(k)(m[k]));
        }
      }
      return r;
    };
  }

  exports._collect = _collect;

  exports.keys = Object.keys || _collect(function (k) {
    return function () { return k; };
  });
})(PS["Data.StrMap"] = PS["Data.StrMap"] || {});
(function(exports) {
  /* global exports */
  "use strict";

  // module Data.StrMap.ST

  exports["new"] = function () {
    return {};
  };

  exports.poke = function (m) {
    return function (k) {
      return function (v) {
        return function () {
          m[k] = v;
          return m;
        };
      };
    };
  };

  exports["delete"] = function (m) {
    return function (k) {
      return function () {
        delete m[k];
        return m;
      };
    };
  };
})(PS["Data.StrMap.ST"] = PS["Data.StrMap.ST"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | Helper functions for working with mutable maps using the `ST` effect.
 *  |
 *  | This module can be used when performance is important and mutation is a local effect.
 */  
  "use strict";
  var $foreign = PS["Data.StrMap.ST"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_ST = PS["Control.Monad.ST"];
  var Data_Maybe = PS["Data.Maybe"];
  exports["delete"] = $foreign["delete"];
  exports["new"] = $foreign["new"];
  exports["poke"] = $foreign.poke;
})(PS["Data.StrMap.ST"] = PS["Data.StrMap.ST"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines a type of native Javascript maps which
 *  | require the keys to be strings.
 *  |
 *  | To maximize performance, Javascript objects are not wrapped,
 *  | and some native code is used even when it's not necessary.
 */  
  "use strict";
  var $foreign = PS["Data.StrMap"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_ST = PS["Control.Monad.ST"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Data_List = PS["Data.List"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_StrMap_ST = PS["Data.StrMap.ST"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Unfoldable = PS["Data.Unfoldable"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Function = PS["Data.Function"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Category = PS["Control.Category"];
  var Data_Eq = PS["Data.Eq"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_List_Types = PS["Data.List.Types"];
  var Control_Bind = PS["Control.Bind"];

  /**
 *  | Convert an immutable map into a mutable map
 */  
  var thawST = $foreign._copyEff;
  var pureST = function (f) {
      return Control_Monad_Eff.runPure($foreign.runST(f));
  };
  var mutate = function (f) {
      return function (m) {
          return pureST(function __do() {
              var v = thawST(m)();
              f(v)();
              return v;
          });
      };
  };

  /**
 *  | Lookup the value for a key in a map
 */  
  var lookup = Data_Function_Uncurried.runFn4($foreign._lookup)(Data_Maybe.Nothing.value)(Data_Maybe.Just.create);

  /**
 *  | Insert a key and value into a map
 */  
  var insert = function (k) {
      return function (v) {
          return mutate(function (s) {
              return Data_StrMap_ST.poke(s)(k)(v);
          });
      };
  };

  /**
 *  | Create a map from a foldable collection of key/value pairs
 */  
  var fromFoldable = function (dictFoldable) {
      return function (l) {
          return pureST(function __do() {
              var v = Data_StrMap_ST["new"]();
              Data_Foldable.for_(Control_Monad_Eff.applicativeEff)(dictFoldable)(l)(function (v1) {
                  return Data_StrMap_ST.poke(v)(v1.value0)(v1.value1);
              })();
              return v;
          });
      };
  };

  /**
 *  | Delete a key and value from a map
 */  
  var $$delete = function (k) {
      return mutate(function (s) {
          return Data_StrMap_ST["delete"](s)(k);
      });
  };

  /**
 *  | Insert, remove or update a value for a key in a map
 */  
  var alter = function (f) {
      return function (k) {
          return function (m) {
              var $37 = f(lookup(k)(m));
              if ($37 instanceof Data_Maybe.Nothing) {
                  return $$delete(k)(m);
              };
              if ($37 instanceof Data_Maybe.Just) {
                  return insert(k)($37.value0)(m);
              };
              throw new Error("Failed pattern match at Data.StrMap line 186, column 15 - line 188, column 25: " + [ $37.constructor.name ]);
          };
      };
  };
  exports["alter"] = alter;
  exports["fromFoldable"] = fromFoldable;
  exports["insert"] = insert;
  exports["lookup"] = lookup;
  exports["pureST"] = pureST;
  exports["thawST"] = thawST;
  exports["empty"] = $foreign.empty;
  exports["keys"] = $foreign.keys;
})(PS["Data.StrMap"] = PS["Data.StrMap"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Newtype = PS["Data.Newtype"];
  var Data_Op = PS["Data.Op"];
  var Data_StrMap = PS["Data.StrMap"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Foldable = PS["Data.Foldable"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Function = PS["Data.Function"];
  var semigroupOptions = new Data_Semigroup.Semigroup(function (v) {
      return function (v1) {
          return Data_Semigroup.append(Data_Semigroup.semigroupArray)(v)(v1);
      };
  });

  /**
 *  | Convert an `Options` value into a JavaScript object, suitable for passing
 *  | to JavaScript APIs.
 */  
  var options = function (v) {
      return Data_Foreign.toForeign(Data_StrMap.fromFoldable(Data_Foldable.foldableArray)(v));
  };          
  var monoidOptions = new Data_Monoid.Monoid(function () {
      return semigroupOptions;
  }, [  ]);

  /**
 *  | The default method for turning a string property key into an
 *  | `Option`. This function simply calls `toForeign` on the value. If
 *  | you need some other behaviour, you can write your own function to replace
 *  | this one, and construct an `Option` yourself.
 */  
  var defaultToOptions = function (k) {
      return function (v) {
          return [ new Data_Tuple.Tuple(k, Data_Foreign.toForeign(v)) ];
      };
  };

  /**
 *  | The default way of creating `Option` values. Constructs an `Option` with
 *  | the given key, which passes the given value through unchanged.
 */  
  var opt = function ($12) {
      return Data_Op.Op(defaultToOptions($12));
  };

  /**
 *  | Associates a value with a specific option.
 */  
  var assoc = Data_Newtype.unwrap(Data_Op.newtypeOp);
  exports["assoc"] = assoc;
  exports["defaultToOptions"] = defaultToOptions;
  exports["opt"] = opt;
  exports["options"] = options;
  exports["semigroupOptions"] = semigroupOptions;
  exports["monoidOptions"] = monoidOptions;
})(PS["Data.Options"] = PS["Data.Options"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Show = PS["Data.Show"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Ordering = PS["Data.Ordering"];        
  var SIGABRT = (function () {
      function SIGABRT() {

      };
      SIGABRT.value = new SIGABRT();
      return SIGABRT;
  })();
  var SIGALRM = (function () {
      function SIGALRM() {

      };
      SIGALRM.value = new SIGALRM();
      return SIGALRM;
  })();
  var SIGBUS = (function () {
      function SIGBUS() {

      };
      SIGBUS.value = new SIGBUS();
      return SIGBUS;
  })();
  var SIGCHLD = (function () {
      function SIGCHLD() {

      };
      SIGCHLD.value = new SIGCHLD();
      return SIGCHLD;
  })();
  var SIGCLD = (function () {
      function SIGCLD() {

      };
      SIGCLD.value = new SIGCLD();
      return SIGCLD;
  })();
  var SIGCONT = (function () {
      function SIGCONT() {

      };
      SIGCONT.value = new SIGCONT();
      return SIGCONT;
  })();
  var SIGEMT = (function () {
      function SIGEMT() {

      };
      SIGEMT.value = new SIGEMT();
      return SIGEMT;
  })();
  var SIGFPE = (function () {
      function SIGFPE() {

      };
      SIGFPE.value = new SIGFPE();
      return SIGFPE;
  })();
  var SIGHUP = (function () {
      function SIGHUP() {

      };
      SIGHUP.value = new SIGHUP();
      return SIGHUP;
  })();
  var SIGILL = (function () {
      function SIGILL() {

      };
      SIGILL.value = new SIGILL();
      return SIGILL;
  })();
  var SIGINFO = (function () {
      function SIGINFO() {

      };
      SIGINFO.value = new SIGINFO();
      return SIGINFO;
  })();
  var SIGINT = (function () {
      function SIGINT() {

      };
      SIGINT.value = new SIGINT();
      return SIGINT;
  })();
  var SIGIO = (function () {
      function SIGIO() {

      };
      SIGIO.value = new SIGIO();
      return SIGIO;
  })();
  var SIGIOT = (function () {
      function SIGIOT() {

      };
      SIGIOT.value = new SIGIOT();
      return SIGIOT;
  })();
  var SIGKILL = (function () {
      function SIGKILL() {

      };
      SIGKILL.value = new SIGKILL();
      return SIGKILL;
  })();
  var SIGLOST = (function () {
      function SIGLOST() {

      };
      SIGLOST.value = new SIGLOST();
      return SIGLOST;
  })();
  var SIGPIPE = (function () {
      function SIGPIPE() {

      };
      SIGPIPE.value = new SIGPIPE();
      return SIGPIPE;
  })();
  var SIGPOLL = (function () {
      function SIGPOLL() {

      };
      SIGPOLL.value = new SIGPOLL();
      return SIGPOLL;
  })();
  var SIGPROF = (function () {
      function SIGPROF() {

      };
      SIGPROF.value = new SIGPROF();
      return SIGPROF;
  })();
  var SIGPWR = (function () {
      function SIGPWR() {

      };
      SIGPWR.value = new SIGPWR();
      return SIGPWR;
  })();
  var SIGQUIT = (function () {
      function SIGQUIT() {

      };
      SIGQUIT.value = new SIGQUIT();
      return SIGQUIT;
  })();
  var SIGSEGV = (function () {
      function SIGSEGV() {

      };
      SIGSEGV.value = new SIGSEGV();
      return SIGSEGV;
  })();
  var SIGSTKFLT = (function () {
      function SIGSTKFLT() {

      };
      SIGSTKFLT.value = new SIGSTKFLT();
      return SIGSTKFLT;
  })();
  var SIGSTOP = (function () {
      function SIGSTOP() {

      };
      SIGSTOP.value = new SIGSTOP();
      return SIGSTOP;
  })();
  var SIGSYS = (function () {
      function SIGSYS() {

      };
      SIGSYS.value = new SIGSYS();
      return SIGSYS;
  })();
  var SIGTERM = (function () {
      function SIGTERM() {

      };
      SIGTERM.value = new SIGTERM();
      return SIGTERM;
  })();
  var SIGTRAP = (function () {
      function SIGTRAP() {

      };
      SIGTRAP.value = new SIGTRAP();
      return SIGTRAP;
  })();
  var SIGTSTP = (function () {
      function SIGTSTP() {

      };
      SIGTSTP.value = new SIGTSTP();
      return SIGTSTP;
  })();
  var SIGTTIN = (function () {
      function SIGTTIN() {

      };
      SIGTTIN.value = new SIGTTIN();
      return SIGTTIN;
  })();
  var SIGTTOU = (function () {
      function SIGTTOU() {

      };
      SIGTTOU.value = new SIGTTOU();
      return SIGTTOU;
  })();
  var SIGUNUSED = (function () {
      function SIGUNUSED() {

      };
      SIGUNUSED.value = new SIGUNUSED();
      return SIGUNUSED;
  })();
  var SIGURG = (function () {
      function SIGURG() {

      };
      SIGURG.value = new SIGURG();
      return SIGURG;
  })();
  var SIGUSR1 = (function () {
      function SIGUSR1() {

      };
      SIGUSR1.value = new SIGUSR1();
      return SIGUSR1;
  })();
  var SIGUSR2 = (function () {
      function SIGUSR2() {

      };
      SIGUSR2.value = new SIGUSR2();
      return SIGUSR2;
  })();
  var SIGVTALRM = (function () {
      function SIGVTALRM() {

      };
      SIGVTALRM.value = new SIGVTALRM();
      return SIGVTALRM;
  })();
  var SIGWINCH = (function () {
      function SIGWINCH() {

      };
      SIGWINCH.value = new SIGWINCH();
      return SIGWINCH;
  })();
  var SIGXCPU = (function () {
      function SIGXCPU() {

      };
      SIGXCPU.value = new SIGXCPU();
      return SIGXCPU;
  })();
  var SIGXFSZ = (function () {
      function SIGXFSZ() {

      };
      SIGXFSZ.value = new SIGXFSZ();
      return SIGXFSZ;
  })();

  /**
 *  | Convert a Signal to a String. Suitable for Node.js APIs.
 */  
  var toString = function (s) {
      if (s instanceof SIGABRT) {
          return "SIGABRT";
      };
      if (s instanceof SIGALRM) {
          return "SIGALRM";
      };
      if (s instanceof SIGBUS) {
          return "SIGBUS";
      };
      if (s instanceof SIGCHLD) {
          return "SIGCHLD";
      };
      if (s instanceof SIGCLD) {
          return "SIGCLD";
      };
      if (s instanceof SIGCONT) {
          return "SIGCONT";
      };
      if (s instanceof SIGEMT) {
          return "SIGEMT";
      };
      if (s instanceof SIGFPE) {
          return "SIGFPE";
      };
      if (s instanceof SIGHUP) {
          return "SIGHUP";
      };
      if (s instanceof SIGILL) {
          return "SIGILL";
      };
      if (s instanceof SIGINFO) {
          return "SIGINFO";
      };
      if (s instanceof SIGINT) {
          return "SIGINT";
      };
      if (s instanceof SIGIO) {
          return "SIGIO";
      };
      if (s instanceof SIGIOT) {
          return "SIGIOT";
      };
      if (s instanceof SIGKILL) {
          return "SIGKILL";
      };
      if (s instanceof SIGLOST) {
          return "SIGLOST";
      };
      if (s instanceof SIGPIPE) {
          return "SIGPIPE";
      };
      if (s instanceof SIGPOLL) {
          return "SIGPOLL";
      };
      if (s instanceof SIGPROF) {
          return "SIGPROF";
      };
      if (s instanceof SIGPWR) {
          return "SIGPWR";
      };
      if (s instanceof SIGQUIT) {
          return "SIGQUIT";
      };
      if (s instanceof SIGSEGV) {
          return "SIGSEGV";
      };
      if (s instanceof SIGSTKFLT) {
          return "SIGSTKFLT";
      };
      if (s instanceof SIGSTOP) {
          return "SIGSTOP";
      };
      if (s instanceof SIGSYS) {
          return "SIGSYS";
      };
      if (s instanceof SIGTERM) {
          return "SIGTERM";
      };
      if (s instanceof SIGTRAP) {
          return "SIGTRAP";
      };
      if (s instanceof SIGTSTP) {
          return "SIGTSTP";
      };
      if (s instanceof SIGTTIN) {
          return "SIGTTIN";
      };
      if (s instanceof SIGTTOU) {
          return "SIGTTOU";
      };
      if (s instanceof SIGUNUSED) {
          return "SIGUNUSED";
      };
      if (s instanceof SIGURG) {
          return "SIGURG";
      };
      if (s instanceof SIGUSR1) {
          return "SIGUSR1";
      };
      if (s instanceof SIGUSR2) {
          return "SIGUSR2";
      };
      if (s instanceof SIGVTALRM) {
          return "SIGVTALRM";
      };
      if (s instanceof SIGWINCH) {
          return "SIGWINCH";
      };
      if (s instanceof SIGXCPU) {
          return "SIGXCPU";
      };
      if (s instanceof SIGXFSZ) {
          return "SIGXFSZ";
      };
      throw new Error("Failed pattern match at Data.Posix.Signal line 48, column 14 - line 88, column 1: " + [ s.constructor.name ]);
  };
  var showSignal = new Data_Show.Show(toString);

  /**
 *  | Try to parse a Signal from a String. Suitable for use with Node.js APIs.
 *  | This function is a partial inverse of `toString`; in code, that means, for
 *  | all `sig :: Signal`:
 *  |
 *  |   `fromString (toString sig) == Just sig`
 *  |
 */  
  var fromString = function (s) {
      if (s === "SIGABRT") {
          return new Data_Maybe.Just(SIGABRT.value);
      };
      if (s === "SIGALRM") {
          return new Data_Maybe.Just(SIGALRM.value);
      };
      if (s === "SIGBUS") {
          return new Data_Maybe.Just(SIGBUS.value);
      };
      if (s === "SIGCHLD") {
          return new Data_Maybe.Just(SIGCHLD.value);
      };
      if (s === "SIGCLD") {
          return new Data_Maybe.Just(SIGCLD.value);
      };
      if (s === "SIGCONT") {
          return new Data_Maybe.Just(SIGCONT.value);
      };
      if (s === "SIGEMT") {
          return new Data_Maybe.Just(SIGEMT.value);
      };
      if (s === "SIGFPE") {
          return new Data_Maybe.Just(SIGFPE.value);
      };
      if (s === "SIGHUP") {
          return new Data_Maybe.Just(SIGHUP.value);
      };
      if (s === "SIGILL") {
          return new Data_Maybe.Just(SIGILL.value);
      };
      if (s === "SIGINFO") {
          return new Data_Maybe.Just(SIGINFO.value);
      };
      if (s === "SIGINT") {
          return new Data_Maybe.Just(SIGINT.value);
      };
      if (s === "SIGIO") {
          return new Data_Maybe.Just(SIGIO.value);
      };
      if (s === "SIGIOT") {
          return new Data_Maybe.Just(SIGIOT.value);
      };
      if (s === "SIGKILL") {
          return new Data_Maybe.Just(SIGKILL.value);
      };
      if (s === "SIGLOST") {
          return new Data_Maybe.Just(SIGLOST.value);
      };
      if (s === "SIGPIPE") {
          return new Data_Maybe.Just(SIGPIPE.value);
      };
      if (s === "SIGPOLL") {
          return new Data_Maybe.Just(SIGPOLL.value);
      };
      if (s === "SIGPROF") {
          return new Data_Maybe.Just(SIGPROF.value);
      };
      if (s === "SIGPWR") {
          return new Data_Maybe.Just(SIGPWR.value);
      };
      if (s === "SIGQUIT") {
          return new Data_Maybe.Just(SIGQUIT.value);
      };
      if (s === "SIGSEGV") {
          return new Data_Maybe.Just(SIGSEGV.value);
      };
      if (s === "SIGSTKFLT") {
          return new Data_Maybe.Just(SIGSTKFLT.value);
      };
      if (s === "SIGSTOP") {
          return new Data_Maybe.Just(SIGSTOP.value);
      };
      if (s === "SIGSYS") {
          return new Data_Maybe.Just(SIGSYS.value);
      };
      if (s === "SIGTERM") {
          return new Data_Maybe.Just(SIGTERM.value);
      };
      if (s === "SIGTRAP") {
          return new Data_Maybe.Just(SIGTRAP.value);
      };
      if (s === "SIGTSTP") {
          return new Data_Maybe.Just(SIGTSTP.value);
      };
      if (s === "SIGTTIN") {
          return new Data_Maybe.Just(SIGTTIN.value);
      };
      if (s === "SIGTTOU") {
          return new Data_Maybe.Just(SIGTTOU.value);
      };
      if (s === "SIGUNUSED") {
          return new Data_Maybe.Just(SIGUNUSED.value);
      };
      if (s === "SIGURG") {
          return new Data_Maybe.Just(SIGURG.value);
      };
      if (s === "SIGUSR1") {
          return new Data_Maybe.Just(SIGUSR1.value);
      };
      if (s === "SIGUSR2") {
          return new Data_Maybe.Just(SIGUSR2.value);
      };
      if (s === "SIGVTALRM") {
          return new Data_Maybe.Just(SIGVTALRM.value);
      };
      if (s === "SIGWINCH") {
          return new Data_Maybe.Just(SIGWINCH.value);
      };
      if (s === "SIGXCPU") {
          return new Data_Maybe.Just(SIGXCPU.value);
      };
      if (s === "SIGXFSZ") {
          return new Data_Maybe.Just(SIGXFSZ.value);
      };
      return Data_Maybe.Nothing.value;
  };
  exports["SIGABRT"] = SIGABRT;
  exports["SIGALRM"] = SIGALRM;
  exports["SIGBUS"] = SIGBUS;
  exports["SIGCHLD"] = SIGCHLD;
  exports["SIGCLD"] = SIGCLD;
  exports["SIGCONT"] = SIGCONT;
  exports["SIGEMT"] = SIGEMT;
  exports["SIGFPE"] = SIGFPE;
  exports["SIGHUP"] = SIGHUP;
  exports["SIGILL"] = SIGILL;
  exports["SIGINFO"] = SIGINFO;
  exports["SIGINT"] = SIGINT;
  exports["SIGIO"] = SIGIO;
  exports["SIGIOT"] = SIGIOT;
  exports["SIGKILL"] = SIGKILL;
  exports["SIGLOST"] = SIGLOST;
  exports["SIGPIPE"] = SIGPIPE;
  exports["SIGPOLL"] = SIGPOLL;
  exports["SIGPROF"] = SIGPROF;
  exports["SIGPWR"] = SIGPWR;
  exports["SIGQUIT"] = SIGQUIT;
  exports["SIGSEGV"] = SIGSEGV;
  exports["SIGSTKFLT"] = SIGSTKFLT;
  exports["SIGSTOP"] = SIGSTOP;
  exports["SIGSYS"] = SIGSYS;
  exports["SIGTERM"] = SIGTERM;
  exports["SIGTRAP"] = SIGTRAP;
  exports["SIGTSTP"] = SIGTSTP;
  exports["SIGTTIN"] = SIGTTIN;
  exports["SIGTTOU"] = SIGTTOU;
  exports["SIGUNUSED"] = SIGUNUSED;
  exports["SIGURG"] = SIGURG;
  exports["SIGUSR1"] = SIGUSR1;
  exports["SIGUSR2"] = SIGUSR2;
  exports["SIGVTALRM"] = SIGVTALRM;
  exports["SIGWINCH"] = SIGWINCH;
  exports["SIGXCPU"] = SIGXCPU;
  exports["SIGXFSZ"] = SIGXFSZ;
  exports["fromString"] = fromString;
  exports["toString"] = toString;
  exports["showSignal"] = showSignal;
})(PS["Data.Posix.Signal"] = PS["Data.Posix.Signal"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines a type of sets as balanced 2-3 trees, based on
 *  | <http://www.cs.princeton.edu/~dpw/courses/cos326-12/ass/2-3-trees.pdf>
 *  |
 *  | Qualified import is encouraged, so as to avoid name clashes with other modules.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_Rec_Class = PS["Control.Monad.Rec.Class"];
  var Control_Monad_ST = PS["Control.Monad.ST"];
  var Data_Array = PS["Data.Array"];
  var Data_Array_ST = PS["Data.Array.ST"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_List = PS["Data.List"];
  var Data_Map = PS["Data.Map"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Unfoldable = PS["Data.Unfoldable"];
  var Partial_Unsafe = PS["Partial.Unsafe"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Ord = PS["Data.Ord"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Unit = PS["Data.Unit"];
  var Data_List_Types = PS["Data.List.Types"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Ordering = PS["Data.Ordering"];
  var Control_Bind = PS["Control.Bind"];
  var Data_Function = PS["Data.Function"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Semiring = PS["Data.Semiring"];        

  /**
 *  | `Set a` represents a set of values of type `a`
 */  
  var $$Set = (function () {
      function $$Set(value0) {
          this.value0 = value0;
      };
      $$Set.create = function (value0) {
          return new $$Set(value0);
      };
      return $$Set;
  })();

  /**
 *  | Form the union of two sets
 *  |
 *  | Running time: `O(n * log(m))`
 */  
  var union = function (dictOrd) {
      return function (v) {
          return function (v1) {
              return new $$Set(Data_Map.union(dictOrd)(v.value0)(v1.value0));
          };
      };
  };
  var toList = function (v) {
      return Data_Map.keys(v.value0);
  };

  /**
 *  | Convert a set to an unfoldable structure.
 */  
  var toUnfoldable = function (dictUnfoldable) {
      return function ($59) {
          return Data_List.toUnfoldable(dictUnfoldable)(toList($59));
      };
  };

  /**
 *  | Create a set with one element
 */  
  var singleton = function (a) {
      return new $$Set(Data_Map.singleton(a)(Data_Unit.unit));
  };

  /**
 *  | Insert a value into a set
 */  
  var insert = function (dictOrd) {
      return function (a) {
          return function (v) {
              return new $$Set(Data_Map.insert(dictOrd)(a)(Data_Unit.unit)(v.value0));
          };
      };
  };

  /**
 *  | An empty set
 */  
  var empty = new $$Set(Data_Map.empty);

  /**
 *  | Create a set from a foldable structure.
 */  
  var fromFoldable = function (dictFoldable) {
      return function (dictOrd) {
          return Data_Foldable.foldl(dictFoldable)(function (m) {
              return function (a) {
                  return insert(dictOrd)(a)(m);
              };
          })(empty);
      };
  };

  /**
 *  | Form the union of a collection of sets
 */  
  var unions = function (dictFoldable) {
      return function (dictOrd) {
          return Data_Foldable.foldl(dictFoldable)(union(dictOrd))(empty);
      };
  };
  exports["empty"] = empty;
  exports["fromFoldable"] = fromFoldable;
  exports["insert"] = insert;
  exports["singleton"] = singleton;
  exports["toUnfoldable"] = toUnfoldable;
  exports["union"] = union;
  exports["unions"] = unions;
})(PS["Data.Set"] = PS["Data.Set"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Newtype = PS["Data.Newtype"];
  var Data_String = PS["Data.String"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Eq = PS["Data.Eq"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Ordering = PS["Data.Ordering"];
  var Data_Semiring = PS["Data.Semiring"];
  var Data_Ring = PS["Data.Ring"];
  var Data_EuclideanRing = PS["Data.EuclideanRing"];
  var showPosition = new Data_Show.Show(function (v) {
      return "Position { line: " + (Data_Show.show(Data_Show.showInt)(v.line) + (", column: " + (Data_Show.show(Data_Show.showInt)(v.column) + " }")));
  });

  /**
 *  | The `Position` before any input has been parsed.
 */  
  var initialPos = {
      line: 1, 
      column: 1
  };
  exports["initialPos"] = initialPos;
  exports["showPosition"] = showPosition;
})(PS["Text.Parsing.Parser.Pos"] = PS["Text.Parsing.Parser.Pos"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Lazy = PS["Control.Lazy"];
  var Control_Monad_Except = PS["Control.Monad.Except"];
  var Control_Monad_Rec_Class = PS["Control.Monad.Rec.Class"];
  var Control_Monad_State = PS["Control.Monad.State"];
  var Control_Monad_Trans_Class = PS["Control.Monad.Trans.Class"];
  var Control_MonadPlus = PS["Control.MonadPlus"];
  var Data_Either = PS["Data.Either"];
  var Data_Identity = PS["Data.Identity"];
  var Data_Newtype = PS["Data.Newtype"];
  var Data_Tuple = PS["Data.Tuple"];
  var Text_Parsing_Parser_Pos = PS["Text.Parsing.Parser.Pos"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Eq = PS["Data.Eq"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Ordering = PS["Data.Ordering"];
  var Control_Monad_Except_Trans = PS["Control.Monad.Except.Trans"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad = PS["Control.Monad"];
  var Control_Monad_State_Class = PS["Control.Monad.State.Class"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_State_Trans = PS["Control.Monad.State.Trans"];
  var Control_Plus = PS["Control.Plus"];
  var Control_Alternative = PS["Control.Alternative"];
  var Control_MonadZero = PS["Control.MonadZero"];        

  /**
 *  | Contains the remaining input and current position.
 */  
  var ParseState = (function () {
      function ParseState(value0, value1, value2) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
      };
      ParseState.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return new ParseState(value0, value1, value2);
              };
          };
      };
      return ParseState;
  })();

  /**
 *  | A parsing error, consisting of a message and position information.
 */  
  var ParseError = (function () {
      function ParseError(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      ParseError.create = function (value0) {
          return function (value1) {
              return new ParseError(value0, value1);
          };
      };
      return ParseError;
  })();

  /**
 *  | The Parser monad transformer.
 *  |
 *  | The first type argument is the stream type. Typically, this is either `String`,
 *  | or some sort of token stream.
 */  
  var ParserT = function (x) {
      return x;
  };
  var showParseError = new Data_Show.Show(function (v) {
      return "(ParseError " + (Data_Show.show(Data_Show.showString)(v.value0) + (Data_Show.show(Text_Parsing_Parser_Pos.showPosition)(v.value1) + ")"));
  });
  var parseErrorMessage = function (v) {
      return v.value0;
  };
  var newtypeParserT = new Data_Newtype.Newtype(function (n) {
      return n;
  }, ParserT);

  /**
 *  | Apply a parser, keeping only the parsed result.
 */  
  var runParserT = function (dictMonad) {
      return function (s) {
          return function (p) {
              var initialState = new ParseState(s, Text_Parsing_Parser_Pos.initialPos, false);
              return Control_Monad_State_Trans.evalStateT(((dictMonad["__superclass_Control.Bind.Bind_1"]())["__superclass_Control.Apply.Apply_0"]())["__superclass_Data.Functor.Functor_0"]())(Control_Monad_Except_Trans.runExceptT(Data_Newtype.unwrap(newtypeParserT)(p)))(initialState);
          };
      };
  };

  /**
 *  | Apply a parser, keeping only the parsed result.
 */  
  var runParser = function (s) {
      return function ($86) {
          return Data_Newtype.unwrap(Data_Identity.newtypeIdentity)(runParserT(Data_Identity.monadIdentity)(s)($86));
      };
  };
  var monadTransParserT = new Control_Monad_Trans_Class.MonadTrans(function (dictMonad) {
      return function ($87) {
          return ParserT(Control_Monad_Trans_Class.lift(Control_Monad_Except_Trans.monadTransExceptT)(Control_Monad_State_Trans.monadStateT(dictMonad))(Control_Monad_Trans_Class.lift(Control_Monad_State_Trans.monadTransStateT)(dictMonad)($87)));
      };
  });
  var monadStateParserT = function (dictMonad) {
      return Control_Monad_Except_Trans.monadStateExceptT(Control_Monad_State_Trans.monadStateStateT(dictMonad));
  };
  var monadParserT = function (dictMonad) {
      return Control_Monad_Except_Trans.monadExceptT(Control_Monad_State_Trans.monadStateT(dictMonad));
  };
  var monadErrorParserT = function (dictMonad) {
      return Control_Monad_Except_Trans.monadErrorExceptT(Control_Monad_State_Trans.monadStateT(dictMonad));
  };
  var lazyParserT = new Control_Lazy.Lazy(function (f) {
      return Control_Lazy.defer(Control_Monad_State_Trans.lazyStateT)(function ($88) {
          return Control_Monad_Except_Trans.runExceptT(Data_Newtype.unwrap(newtypeParserT)(f($88)));
      });
  });
  var functorParserT = function (dictFunctor) {
      return Control_Monad_Except_Trans.functorExceptT(Control_Monad_State_Trans.functorStateT(dictFunctor));
  };
  var bindParserT = function (dictMonad) {
      return Control_Monad_Except_Trans.bindExceptT(Control_Monad_State_Trans.monadStateT(dictMonad));
  };

  /**
 *  | Fail with a message.
 */  
  var fail = function (dictMonad) {
      return function (message) {
          return Control_Bind.bind(bindParserT(dictMonad))(Control_Monad_State_Class.gets(monadStateParserT(dictMonad))(function (v) {
              return v.value1;
          }))(function (v) {
              return Control_Monad_Error_Class.throwError(monadErrorParserT(dictMonad))(new ParseError(message, v));
          });
      };
  };
  var applyParserT = function (dictMonad) {
      return Control_Monad_Except_Trans.applyExceptT(Control_Monad_State_Trans.monadStateT(dictMonad));
  };
  var applicativeParserT = function (dictMonad) {
      return Control_Monad_Except_Trans.applicativeExceptT(Control_Monad_State_Trans.monadStateT(dictMonad));
  };
  var altParserT = function (dictMonad) {
      return new Control_Alt.Alt(function () {
          return functorParserT(((dictMonad["__superclass_Control.Bind.Bind_1"]())["__superclass_Control.Apply.Apply_0"]())["__superclass_Data.Functor.Functor_0"]());
      }, function (p1) {
          return function (p2) {
              return ParserT(Control_Monad_Except_Trans.ExceptT(Control_Monad_State_Trans.StateT(function (v) {
                  return Control_Bind.bind(dictMonad["__superclass_Control.Bind.Bind_1"]())(Control_Monad_State_Trans.runStateT(Control_Monad_Except_Trans.runExceptT(Data_Newtype.unwrap(newtypeParserT)(p1)))(new ParseState(v.value0, v.value1, false)))(function (v1) {
                      if (v1.value0 instanceof Data_Either.Left && !v1.value1.value2) {
                          return Control_Monad_State_Trans.runStateT(Control_Monad_Except_Trans.runExceptT(Data_Newtype.unwrap(newtypeParserT)(p2)))(v);
                      };
                      return Control_Applicative.pure(dictMonad["__superclass_Control.Applicative.Applicative_0"]())(new Data_Tuple.Tuple(v1.value0, v1.value1));
                  });
              })));
          };
      });
  };
  var plusParserT = function (dictMonad) {
      return new Control_Plus.Plus(function () {
          return altParserT(dictMonad);
      }, fail(dictMonad)("No alternative"));
  };
  var alternativeParserT = function (dictMonad) {
      return new Control_Alternative.Alternative(function () {
          return applicativeParserT(dictMonad);
      }, function () {
          return plusParserT(dictMonad);
      });
  };
  var monadZeroParserT = function (dictMonad) {
      return new Control_MonadZero.MonadZero(function () {
          return alternativeParserT(dictMonad);
      }, function () {
          return monadParserT(dictMonad);
      });
  };
  exports["ParseState"] = ParseState;
  exports["ParserT"] = ParserT;
  exports["fail"] = fail;
  exports["parseErrorMessage"] = parseErrorMessage;
  exports["runParser"] = runParser;
  exports["runParserT"] = runParserT;
  exports["showParseError"] = showParseError;
  exports["newtypeParserT"] = newtypeParserT;
  exports["lazyParserT"] = lazyParserT;
  exports["functorParserT"] = functorParserT;
  exports["applyParserT"] = applyParserT;
  exports["applicativeParserT"] = applicativeParserT;
  exports["bindParserT"] = bindParserT;
  exports["monadParserT"] = monadParserT;
  exports["monadStateParserT"] = monadStateParserT;
  exports["monadErrorParserT"] = monadErrorParserT;
  exports["altParserT"] = altParserT;
  exports["plusParserT"] = plusParserT;
  exports["alternativeParserT"] = alternativeParserT;
  exports["monadZeroParserT"] = monadZeroParserT;
  exports["monadTransParserT"] = monadTransParserT;
})(PS["Text.Parsing.Parser"] = PS["Text.Parsing.Parser"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | Combinators for creating parsers.
 *  |
 *  | ### Notes
 *  |
 *  | A few of the known combinators from Parsec are missing in this module. That
 *  | is because they have already been defined in other libraries.
 *  |
 *  | ```purescript
 *  | Text.Parsec.many  = Data.(Array|List).many
 *  | Text.Parsec.many1 = Data.(Array|List).some
 *  | Text.Parsec.(<|>) = Control.Alt.alt (<|>)
 *  | ```
 *  |
 *  | Because Strings are not Char Arrays in PureScript `many` and `some` on Char Parsers need to
 *  | be used in conjunction with `Data.String.fromCharArray` to achieve "Parsec-like" results.
 *  |
 *  | ```purescript
 *  | Text.Parsec.many  (char 'x') <=> fromCharArray <$> Data.Array.many (char 'x')
 *  | ```
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Except = PS["Control.Monad.Except"];
  var Control_Monad_State = PS["Control.Monad.State"];
  var Control_Plus = PS["Control.Plus"];
  var Data_Either = PS["Data.Either"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_List = PS["Data.List"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Newtype = PS["Data.Newtype"];
  var Data_Tuple = PS["Data.Tuple"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Control_Alt = PS["Control.Alt"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Control_Monad_Except_Trans = PS["Control.Monad.Except.Trans"];
  var Control_Monad_State_Trans = PS["Control.Monad.State.Trans"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Unit = PS["Data.Unit"];
  var Data_List_Types = PS["Data.List.Types"];
  var Data_Function = PS["Data.Function"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Apply = PS["Control.Apply"];        

  /**
 *  | Provide an error message in the case of failure.
 */  
  var withErrorMessage = function (dictMonad) {
      return function (p) {
          return function (msg) {
              return Control_Alt.alt(Text_Parsing_Parser.altParserT(dictMonad))(p)(Text_Parsing_Parser.fail(dictMonad)("Expected " + msg));
          };
      };
  };

  /**
 *  | In case of failure, reset the stream to the unconsumed state.
 */  
  var $$try = function (dictMonad) {
      return function (p) {
          return Text_Parsing_Parser.ParserT(Control_Monad_Except_Trans.ExceptT(Control_Monad_State_Trans.StateT(function (v) {
              return Control_Bind.bind(dictMonad["__superclass_Control.Bind.Bind_1"]())(Control_Monad_State_Trans.runStateT(Control_Monad_Except_Trans.runExceptT(Data_Newtype.unwrap(Text_Parsing_Parser.newtypeParserT)(p)))(v))(function (v1) {
                  if (v1.value0 instanceof Data_Either.Left) {
                      return Control_Applicative.pure(dictMonad["__superclass_Control.Applicative.Applicative_0"]())(new Data_Tuple.Tuple(v1.value0, new Text_Parsing_Parser.ParseState(v1.value1.value0, v1.value1.value1, v.value2)));
                  };
                  return Control_Applicative.pure(dictMonad["__superclass_Control.Applicative.Applicative_0"]())(new Data_Tuple.Tuple(v1.value0, v1.value1));
              });
          })));
      };
  };

  /**
 *  | Parse phrases delimited by a separator, requiring at least one match.
 */  
  var sepBy1 = function (dictMonad) {
      return function (p) {
          return function (sep) {
              return Control_Bind.bind(Text_Parsing_Parser.bindParserT(dictMonad))(p)(function (v) {
                  return Control_Bind.bind(Text_Parsing_Parser.bindParserT(dictMonad))(Data_List.many(Text_Parsing_Parser.alternativeParserT(dictMonad))(Text_Parsing_Parser.lazyParserT)(Control_Bind.bind(Text_Parsing_Parser.bindParserT(dictMonad))(sep)(function () {
                      return p;
                  })))(function (v1) {
                      return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(dictMonad))(new Data_List_Types.Cons(v, v1));
                  });
              });
          };
      };
  };

  /**
 *  | Parse phrases delimited by a separator.
 *  |
 *  | For example:
 *  |
 *  | ```purescript
 *  | digit `sepBy` string ","
 *  | ```
 */  
  var sepBy = function (dictMonad) {
      return function (p) {
          return function (sep) {
              return Control_Alt.alt(Text_Parsing_Parser.altParserT(dictMonad))(sepBy1(dictMonad)(p)(sep))(Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(dictMonad))(Data_List_Types.Nil.value));
          };
      };
  };

  /**
 *  | Provide a default result in the case where a parser fails without consuming input.
 */  
  var option = function (dictMonad) {
      return function (a) {
          return function (p) {
              return Control_Alt.alt(Text_Parsing_Parser.altParserT(dictMonad))(p)(Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(dictMonad))(a));
          };
      };
  };

  /**
 *  | pure `Nothing` in the case where a parser fails without consuming input.
 */  
  var optionMaybe = function (dictMonad) {
      return function (p) {
          return option(dictMonad)(Data_Maybe.Nothing.value)(Data_Functor.map(Text_Parsing_Parser.functorParserT(((dictMonad["__superclass_Control.Bind.Bind_1"]())["__superclass_Control.Apply.Apply_0"]())["__superclass_Data.Functor.Functor_0"]()))(Data_Maybe.Just.create)(p));
      };
  };
  exports["option"] = option;
  exports["optionMaybe"] = optionMaybe;
  exports["sepBy"] = sepBy;
  exports["sepBy1"] = sepBy1;
  exports["try"] = $$try;
  exports["withErrorMessage"] = withErrorMessage;
})(PS["Text.Parsing.Parser.Combinators"] = PS["Text.Parsing.Parser.Combinators"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | Functions for working with streams of tokens.
 */  
  "use strict";
  var Data_Array = PS["Data.Array"];
  var Data_Char_Unicode = PS["Data.Char.Unicode"];
  var Data_List = PS["Data.List"];
  var Control_Lazy = PS["Control.Lazy"];
  var Control_Monad_State = PS["Control.Monad.State"];
  var Control_MonadPlus = PS["Control.MonadPlus"];
  var Data_Char = PS["Data.Char"];
  var Data_Either = PS["Data.Either"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Identity = PS["Data.Identity"];
  var Data_Int = PS["Data.Int"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_String = PS["Data.String"];
  var Data_Tuple = PS["Data.Tuple"];
  var $$Math = PS["Math"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Text_Parsing_Parser_Combinators = PS["Text.Parsing.Parser.Combinators"];
  var Text_Parsing_Parser_Pos = PS["Text.Parsing.Parser.Pos"];
  var Text_Parsing_Parser_String = PS["Text.Parsing.Parser.String"];
  var Prelude = PS["Prelude"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad_State_Class = PS["Control.Monad.State.Class"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Function = PS["Data.Function"];
  var Control_MonadZero = PS["Control.MonadZero"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Boolean = PS["Data.Boolean"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ordering = PS["Data.Ordering"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Alt = PS["Control.Alt"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Ring = PS["Data.Ring"];
  var Control_Category = PS["Control.Category"];
  var Data_Semiring = PS["Data.Semiring"];
  var Data_Show = PS["Data.Show"];
  var Data_EuclideanRing = PS["Data.EuclideanRing"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Unit = PS["Data.Unit"];
  var Data_List_Types = PS["Data.List.Types"];
  var Data_Unfoldable = PS["Data.Unfoldable"];

  /**
 *  | Create a parser which Returns the first token in the stream.
 */  
  var token = function (dictMonad) {
      return function (tokpos) {
          return Control_Bind.bind(Text_Parsing_Parser.bindParserT(dictMonad))(Control_Monad_State_Class.gets(Text_Parsing_Parser.monadStateParserT(dictMonad))(function (v) {
              return v.value0;
          }))(function (v) {
              var $72 = Data_List.uncons(v);
              if ($72 instanceof Data_Maybe.Nothing) {
                  return Text_Parsing_Parser.fail(dictMonad)("Unexpected EOF");
              };
              if ($72 instanceof Data_Maybe.Just) {
                  return Control_Bind.bind(Text_Parsing_Parser.bindParserT(dictMonad))(Control_Monad_State_Class.modify(Text_Parsing_Parser.monadStateParserT(dictMonad))(function (v1) {
                      return new Text_Parsing_Parser.ParseState($72.value0.tail, tokpos($72.value0.head), true);
                  }))(function () {
                      return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(dictMonad))($72.value0.head);
                  });
              };
              throw new Error("Failed pattern match at Text.Parsing.Parser.Token line 51, column 3 - line 56, column 16: " + [ $72.constructor.name ]);
          });
      };
  };

  /**
 *  | Create a parser which matches any token satisfying the predicate.
 */  
  var when = function (dictMonad) {
      return function (tokpos) {
          return function (f) {
              return Text_Parsing_Parser_Combinators["try"](dictMonad)(Control_Bind.bind(Text_Parsing_Parser.bindParserT(dictMonad))(token(dictMonad)(tokpos))(function (v) {
                  return Control_Bind.bind(Text_Parsing_Parser.bindParserT(dictMonad))(Control_MonadZero.guard(Text_Parsing_Parser.monadZeroParserT(dictMonad))(f(v)))(function () {
                      return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(dictMonad))(v);
                  });
              }));
          };
      };
  };

  /**
 *  | Match the specified token at the head of the stream.
 */  
  var match = function (dictMonad) {
      return function (dictEq) {
          return function (tokpos) {
              return function (tok) {
                  return when(dictMonad)(tokpos)(function (v) {
                      return Data_Eq.eq(dictEq)(v)(tok);
                  });
              };
          };
      };
  };
  exports["match"] = match;
  exports["token"] = token;
  exports["when"] = when;
})(PS["Text.Parsing.Parser.Token"] = PS["Text.Parsing.Parser.Token"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Int = PS["Data.Int"];
  var Data_Char = PS["Data.Char"];
  var Data_String = PS["Data.String"];
  var Data_List = PS["Data.List"];
  var Data_Maybe = PS["Data.Maybe"];
  var Control_Monad = PS["Control.Monad"];
  var Control_Monad_State_Class = PS["Control.Monad.State.Class"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Text_Parsing_Parser_Token = PS["Text.Parsing.Parser.Token"];
  var Text_Parsing_Parser_Pos = PS["Text.Parsing.Parser.Pos"];
  var Partial_Unsafe = PS["Partial.Unsafe"];
  var Data_Function = PS["Data.Function"];
  var Data_Identity = PS["Data.Identity"];
  var Data_Eq = PS["Data.Eq"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Unfoldable = PS["Data.Unfoldable"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Applicative = PS["Control.Applicative"];        
  var lieAboutPos = Data_Function["const"](Text_Parsing_Parser_Pos.initialPos);
  var match$prime = Text_Parsing_Parser_Token.match(Data_Identity.monadIdentity)(Data_Eq.eqChar)(lieAboutPos);
  var when$prime = Text_Parsing_Parser_Token.when(Data_Identity.monadIdentity)(lieAboutPos);
  var isDigit = function (c) {
      return "0" <= c && c <= "9";
  };
  var nonNegativeInt = (function () {
      var fromDigits = function (digits) {
          return Partial_Unsafe.unsafePartial(function (dictPartial) {
              return Data_Maybe.fromJust(dictPartial)(Data_Int.fromString(Data_String.fromCharArray(Data_List.toUnfoldable(Data_Unfoldable.unfoldableArray)(digits))));
          });
      };
      return Data_Functor.map(Text_Parsing_Parser.functorParserT(Data_Identity.functorIdentity))(fromDigits)(Data_List.some(Text_Parsing_Parser.alternativeParserT(Data_Identity.monadIdentity))(Text_Parsing_Parser.lazyParserT)(Text_Parsing_Parser_Token.when(Data_Identity.monadIdentity)(lieAboutPos)(isDigit)));
  })();
  var isAsciiAlpha = function (ch) {
      return Data_Ord.between(Data_Ord.ordChar)("a")("z")(Data_Char.toLower(ch));
  };
  var eof = Control_Bind.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Control_Monad_State_Class.gets(Text_Parsing_Parser.monadStateParserT(Data_Identity.monadIdentity))(function (v) {
      return v.value0;
  }))(function (v) {
      return Control_Applicative.unless(Text_Parsing_Parser.applicativeParserT(Data_Identity.monadIdentity))(Data_List["null"](v))(Text_Parsing_Parser.fail(Data_Identity.monadIdentity)("expected eof"));
  });
  exports["eof"] = eof;
  exports["isAsciiAlpha"] = isAsciiAlpha;
  exports["isDigit"] = isDigit;
  exports["lieAboutPos"] = lieAboutPos;
  exports["match'"] = match$prime;
  exports["nonNegativeInt"] = nonNegativeInt;
  exports["when'"] = when$prime;
})(PS["Data.Version.Internal"] = PS["Data.Version.Internal"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines a `Version` data type, for representing software
 *  | versions, according to the [Semantic Versioning](http://semver.org)
 *  | specification. To summarize, a `Version` consists of:
 *  |
 *  | * a MAJOR, MINOR, and a PATCH component, all of which are nonnegative
 *  |   integers.
 *  | * optionally, a list of pre-release identifiers, consisting of ASCII
 *  |   letters, numbers, and hyphens, and which is separated from the three
 *  |   main components with a hyphen.
 *  | * optionally, build metadata, consisting of ASCII letters, numbers, and
 *  |   hyphens, and which is separated from the rest of the version with a plus
 *  |   symbol.
 *  |
 *  | Note that, according to the semver spec, version precedence must ignore
 *  | any build metadata. Therefore, the `Ord` instance ignores the build
 *  | metadata. In order to have the `Eq` instance agree with the `Ord`
 *  | instance, the `Eq` instance ignores build metadata too.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Either = PS["Data.Either"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Int = PS["Data.Int"];
  var Data_String = PS["Data.String"];
  var Data_List = PS["Data.List"];
  var Data_Function = PS["Data.Function"];
  var Data_Foldable = PS["Data.Foldable"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Apply = PS["Control.Apply"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Text_Parsing_Parser_Combinators = PS["Text.Parsing.Parser.Combinators"];
  var Data_Version_Internal = PS["Data.Version.Internal"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Ordering = PS["Data.Ordering"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Show = PS["Data.Show"];
  var Data_List_Types = PS["Data.List.Types"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Unfoldable = PS["Data.Unfoldable"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Semiring = PS["Data.Semiring"];
  var Control_Bind = PS["Control.Bind"];
  var Data_Identity = PS["Data.Identity"];
  var Control_Applicative = PS["Control.Applicative"];        
  var IInt = (function () {
      function IInt(value0) {
          this.value0 = value0;
      };
      IInt.create = function (value0) {
          return new IInt(value0);
      };
      return IInt;
  })();
  var IStr = (function () {
      function IStr(value0) {
          this.value0 = value0;
      };
      IStr.create = function (value0) {
          return new IStr(value0);
      };
      return IStr;
  })();

  /**
 *  | A semver version.
 */  
  var Version = (function () {
      function Version(value0, value1, value2, value3, value4) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
          this.value4 = value4;
      };
      Version.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return function (value4) {
                          return new Version(value0, value1, value2, value3, value4);
                      };
                  };
              };
          };
      };
      return Version;
  })();
  var showIdentifier = function (i) {
      if (i instanceof IInt) {
          return Data_Show.show(Data_Show.showInt)(i.value0);
      };
      if (i instanceof IStr) {
          return i.value0;
      };
      throw new Error("Failed pattern match at Data.Version line 126, column 20 - line 128, column 14: " + [ i.constructor.name ]);
  };

  /**
 *  | Unpack a version. Useful for pattern matching.
 *  |
 *  | The reason we have this function instead of exporting the `Version`
 *  | constructor is that in this way we can guarantee that `Version` values are
 *  | always valid.
 */  
  var runVersion = function (f) {
      return function (v) {
          return f(v.value0)(v.value1)(v.value2)(v.value3)(v.value4);
      };
  };
  var showVersion = (function () {
      var sep = function (v) {
          return function (v1) {
              if (v1 instanceof Data_List_Types.Nil) {
                  return "";
              };
              return (function (v2) {
                  return v + v2;
              })(Data_String.joinWith(".")(Data_Functor.map(Data_Functor.functorArray)(showIdentifier)(Data_List.toUnfoldable(Data_Unfoldable.unfoldableArray)(v1))));
          };
      };
      var go = function (maj) {
          return function (min) {
              return function (pat) {
                  return function (pre) {
                      return function (build) {
                          return Data_String.joinWith(".")(Data_Functor.map(Data_Functor.functorArray)(Data_Show.show(Data_Show.showInt))([ maj, min, pat ])) + (sep("-")(pre) + sep("+")(build));
                      };
                  };
              };
          };
      };
      return runVersion(go);
  })();
  var preRelease = function (v) {
      return v.value3;
  };
  var patch = function (v) {
      return v.value2;
  };
  var nonneg = function (x) {
      var $49 = x < 0;
      if ($49) {
          return 0;
      };
      if (!$49) {
          return x;
      };
      throw new Error("Failed pattern match at Data.Version line 169, column 12 - line 169, column 34: " + [ $49.constructor.name ]);
  };

  /**
 *  | Construct a numeric identifier.
 */  
  var numeric = function ($104) {
      return IInt.create(nonneg($104));
  };

  /**
 *  | Smart constructor for versions. Negative integer components will be
 *  | replaced with zeroes.
 */  
  var version = function (ma) {
      return function (mi) {
          return function (pa) {
              return function (pre) {
                  return function (meta) {
                      return new Version(nonneg(ma), nonneg(mi), nonneg(pa), pre, meta);
                  };
              };
          };
      };
  };
  var minor = function (v) {
      return v.value1;
  };
  var major = function (v) {
      return v.value0;
  };
  var ordIdentifier = new Data_Ord.Ord(function () {
      return eqIdentifier;
  }, function (v) {
      return function (v1) {
          if (v instanceof IInt && v1 instanceof IStr) {
              return Data_Ordering.LT.value;
          };
          if (v instanceof IStr && v1 instanceof IInt) {
              return Data_Ordering.GT.value;
          };
          if (v instanceof IInt && v1 instanceof IInt) {
              return Data_Ord.compare(Data_Ord.ordInt)(v.value0)(v1.value0);
          };
          if (v instanceof IStr && v1 instanceof IStr) {
              return Data_Ord.compare(Data_Ord.ordString)(v.value0)(v1.value0);
          };
          throw new Error("Failed pattern match at Data.Version line 204, column 3 - line 204, column 33: " + [ v.constructor.name, v1.constructor.name ]);
      };
  });
  var eqIdentifier = new Data_Eq.Eq(function (i1) {
      return function (i2) {
          return Data_Eq.eq(Data_Ordering.eqOrdering)(Data_Ord.compare(ordIdentifier)(i1)(i2))(Data_Ordering.EQ.value);
      };
  });
  var comparePre = function (v) {
      return function (v1) {
          if (v instanceof Data_List_Types.Nil && v1 instanceof Data_List_Types.Nil) {
              return Data_Ordering.EQ.value;
          };
          if (v instanceof Data_List_Types.Nil) {
              return Data_Ordering.GT.value;
          };
          if (v1 instanceof Data_List_Types.Nil) {
              return Data_Ordering.LT.value;
          };
          if (v instanceof Data_List_Types.Cons && v1 instanceof Data_List_Types.Cons) {
              var helper = function (v2) {
                  return function (v3) {
                      if (v2 instanceof Data_List_Types.Nil && v3 instanceof Data_List_Types.Nil) {
                          return Data_Ordering.EQ.value;
                      };
                      if (v2 instanceof Data_List_Types.Nil) {
                          return Data_Ordering.LT.value;
                      };
                      if (v3 instanceof Data_List_Types.Nil) {
                          return Data_Ordering.GT.value;
                      };
                      if (v2 instanceof Data_List_Types.Cons && v3 instanceof Data_List_Types.Cons) {
                          return Data_Semigroup.append(Data_Ordering.semigroupOrdering)(Data_Ord.compare(ordIdentifier)(v2.value0)(v3.value0))(helper(v2.value1)(v3.value1));
                      };
                      throw new Error("Failed pattern match at Data.Version line 177, column 1 - line 177, column 24: " + [ v2.constructor.name, v3.constructor.name ]);
                  };
              };
              return Data_Semigroup.append(Data_Ordering.semigroupOrdering)(Data_Ord.compare(ordIdentifier)(v.value0)(v1.value0))(helper(v.value1)(v1.value1));
          };
          throw new Error("Failed pattern match at Data.Version line 177, column 1 - line 177, column 24: " + [ v.constructor.name, v1.constructor.name ]);
      };
  };
  var ordVersion = new Data_Ord.Ord(function () {
      return eqVersion;
  }, function (v1) {
      return function (v2) {
          var comparePre$prime = Data_Function.on(comparePre)(preRelease);
          var compareNormal = Data_Function.on(Data_Ord.compare(Data_Ord.ordArray(Data_Ord.ordInt)))(runVersion(function (ma) {
              return function (mi) {
                  return function (pa) {
                      return function (v) {
                          return function (v3) {
                              return [ ma, mi, pa ];
                          };
                      };
                  };
              };
          }));
          return Data_Semigroup.append(Data_Ordering.semigroupOrdering)(compareNormal(v1)(v2))(comparePre$prime(v1)(v2));
      };
  });
  var eqVersion = new Data_Eq.Eq(function (v1) {
      return function (v2) {
          return Data_Eq.eq(Data_Ordering.eqOrdering)(Data_Ord.compare(ordVersion)(v1)(v2))(Data_Ordering.EQ.value);
      };
  });

  /**
 *  | Bump the patch version, and discard any prerelease identifiers and build
 *  | metadata.
 */  
  var bumpPatch = function (v) {
      return version(major(v))(minor(v))(patch(v) + 1 | 0)(Data_List_Types.Nil.value)(Data_List_Types.Nil.value);
  };

  /**
 *  | Bump the minor version, and discard any prerelease identifiers and build
 *  | metadata.
 */  
  var bumpMinor = function (v) {
      return version(major(v))(minor(v) + 1 | 0)(0)(Data_List_Types.Nil.value)(Data_List_Types.Nil.value);
  };

  /**
 *  | Bump the major version, and discard any prerelease identifiers and build
 *  | metadata.
 */  
  var bumpMajor = function (v) {
      return version(major(v) + 1 | 0)(0)(0)(Data_List_Types.Nil.value)(Data_List_Types.Nil.value);
  };
  var acceptableIdentifier = function (ch) {
      return Data_Version_Internal.isDigit(ch) || (Data_Version_Internal.isAsciiAlpha(ch) || ch === "-");
  };

  /**
 *  | Construct a textual identifier.
 */  
  var textual = function (str) {
      var startsWith = function (str1) {
          return function ($106) {
              return Data_Maybe.isJust(Data_String.stripPrefix(str1)($106));
          };
      };
      var ok = function (x) {
          return Data_Foldable.all(Data_Foldable.foldableArray)(Data_HeytingAlgebra.heytingAlgebraBoolean)(function (v) {
              return v(x);
          })([ function ($107) {
              return !Data_Maybe.isJust(Data_Int.fromString($107));
          }, function ($108) {
              return !startsWith("0")($108);
          }, function ($109) {
              return Data_Foldable.all(Data_Foldable.foldableArray)(Data_HeytingAlgebra.heytingAlgebraBoolean)(acceptableIdentifier)(Data_String.toCharArray($109));
          } ]);
      };
      var $92 = ok(str);
      if ($92) {
          return new Data_Maybe.Just(new IStr(str));
      };
      if (!$92) {
          return Data_Maybe.Nothing.value;
      };
      throw new Error("Failed pattern match at Data.Version line 113, column 3 - line 113, column 46: " + [ $92.constructor.name ]);
  };
  var versionParser = (function () {
      var textIdent = Control_Bind.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Data_List.some(Text_Parsing_Parser.alternativeParserT(Data_Identity.monadIdentity))(Text_Parsing_Parser.lazyParserT)(Data_Version_Internal["when'"](acceptableIdentifier)))(function (v) {
          var str = Data_String.fromCharArray(Data_List.toUnfoldable(Data_Unfoldable.unfoldableArray)(v));
          var $94 = textual(str);
          if ($94 instanceof Data_Maybe.Just) {
              return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(Data_Identity.monadIdentity))($94.value0);
          };
          if ($94 instanceof Data_Maybe.Nothing) {
              return Text_Parsing_Parser.fail(Data_Identity.monadIdentity)("invalid identifier: " + str);
          };
          throw new Error("Failed pattern match at Data.Version line 152, column 5 - line 154, column 54: " + [ $94.constructor.name ]);
      });
      var intIdent = Data_Functor.map(Text_Parsing_Parser.functorParserT(Data_Identity.functorIdentity))(numeric)(Data_Version_Internal.nonNegativeInt);
      var identifier = Control_Alt.alt(Text_Parsing_Parser.altParserT(Data_Identity.monadIdentity))(intIdent)(textIdent);
      var identifiers = Text_Parsing_Parser_Combinators.sepBy(Data_Identity.monadIdentity)(identifier)(Data_Version_Internal["match'"]("."));
      return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Data_Version_Internal.nonNegativeInt)(function (v) {
          return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Data_Version_Internal["match'"]("."))(function () {
              return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Data_Version_Internal.nonNegativeInt)(function (v1) {
                  return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Data_Version_Internal["match'"]("."))(function () {
                      return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Data_Version_Internal.nonNegativeInt)(function (v2) {
                          return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Text_Parsing_Parser_Combinators.option(Data_Identity.monadIdentity)(Data_List_Types.Nil.value)(Control_Apply.applySecond(Text_Parsing_Parser.applyParserT(Data_Identity.monadIdentity))(Data_Version_Internal["match'"]("-"))(identifiers)))(function (v3) {
                              return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Text_Parsing_Parser_Combinators.option(Data_Identity.monadIdentity)(Data_List_Types.Nil.value)(Control_Apply.applySecond(Text_Parsing_Parser.applyParserT(Data_Identity.monadIdentity))(Data_Version_Internal["match'"]("+"))(identifiers)))(function (v4) {
                                  return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Data_Version_Internal.eof)(function () {
                                      return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(Data_Identity.monadIdentity))(new Version(v, v1, v2, v3, v4));
                                  });
                              });
                          });
                      });
                  });
              });
          });
      });
  })();
  var parseVersion = function ($110) {
      return Data_Function.flip(Text_Parsing_Parser.runParser)(versionParser)(Data_List.fromFoldable(Data_Foldable.foldableArray)(Data_String.toCharArray($110)));
  };
  exports["bumpMajor"] = bumpMajor;
  exports["bumpMinor"] = bumpMinor;
  exports["bumpPatch"] = bumpPatch;
  exports["major"] = major;
  exports["minor"] = minor;
  exports["numeric"] = numeric;
  exports["parseVersion"] = parseVersion;
  exports["preRelease"] = preRelease;
  exports["runVersion"] = runVersion;
  exports["showVersion"] = showVersion;
  exports["textual"] = textual;
  exports["version"] = version;
  exports["versionParser"] = versionParser;
  exports["eqVersion"] = eqVersion;
  exports["ordVersion"] = ordVersion;
  exports["eqIdentifier"] = eqIdentifier;
  exports["ordIdentifier"] = ordIdentifier;
})(PS["Data.Version"] = PS["Data.Version"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | A Version data type corresponding to the type in Haskell's `Data.Version`
 *  | module, from the `base` library (that is, the Haskell standard library).
 *  |
 *  | See also [the Haskell documentation](http://hackage.haskell.org/package/base-4.8.1.0/docs/Data-Version.html).
 *  |
 *  | You might need this module in order to deal with PureScript compiler
 *  | versions, as they do not always have 3 components, and therefore will not
 *  | work with the `Data.Version` module in this package. In most other cases,
 *  | though, you should probably be using `Data.Version`.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Either = PS["Data.Either"];
  var Data_List = PS["Data.List"];
  var Data_String = PS["Data.String"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Text_Parsing_Parser_Combinators = PS["Text.Parsing.Parser.Combinators"];
  var Data_Version_Internal = PS["Data.Version.Internal"];
  var Data_Eq = PS["Data.Eq"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Show = PS["Data.Show"];
  var Data_Identity = PS["Data.Identity"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Unfoldable = PS["Data.Unfoldable"];
  var Control_Bind = PS["Control.Bind"];
  var Data_List_Types = PS["Data.List.Types"];
  var Data_Function = PS["Data.Function"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Ordering = PS["Data.Ordering"];        

  /**
 *  | A version consists of any number of integer components, and any number of
 *  | string components.
 */  
  var Version = (function () {
      function Version(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      Version.create = function (value0) {
          return function (value1) {
              return new Version(value0, value1);
          };
      };
      return Version;
  })();
  var versionParser = (function () {
      var someAlphaNums = Data_List.some(Text_Parsing_Parser.alternativeParserT(Data_Identity.monadIdentity))(Text_Parsing_Parser.lazyParserT)(Data_Version_Internal["when'"](function (c) {
          return Data_Version_Internal.isAsciiAlpha(c) || Data_Version_Internal.isDigit(c);
      }));
      var identifier = Data_Functor.map(Text_Parsing_Parser.functorParserT(Data_Identity.functorIdentity))(function ($32) {
          return Data_String.fromCharArray(Data_List.toUnfoldable(Data_Unfoldable.unfoldableArray)($32));
      })(someAlphaNums);
      var hyphen = Data_Version_Internal["match'"]("-");
      return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Text_Parsing_Parser_Combinators.sepBy(Data_Identity.monadIdentity)(Data_Version_Internal.nonNegativeInt)(Data_Version_Internal["match'"](".")))(function (v) {
          return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Text_Parsing_Parser_Combinators.option(Data_Identity.monadIdentity)(Data_List_Types.Nil.value)(Control_Apply.applySecond(Text_Parsing_Parser.applyParserT(Data_Identity.monadIdentity))(hyphen)(Text_Parsing_Parser_Combinators.sepBy(Data_Identity.monadIdentity)(identifier)(hyphen))))(function (v1) {
              return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Data_Identity.monadIdentity))(Data_Version_Internal.eof)(function () {
                  return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(Data_Identity.monadIdentity))(new Version(v, v1));
              });
          });
      });
  })();
  var showVersion = function (v) {
      var prefix = function (v1) {
          return function (v2) {
              if (v2 === "") {
                  return "";
              };
              return v1 + v2;
          };
      };
      var f = function ($33) {
          return Data_String.joinWith(".")(Data_List.toUnfoldable(Data_Unfoldable.unfoldableArray)(Data_Functor.map(Data_List_Types.functorList)(Data_Show.show(Data_Show.showInt))($33)));
      };
      return f(v.value0) + prefix("-")(Data_String.joinWith("-")(Data_List.toUnfoldable(Data_Unfoldable.unfoldableArray)(v.value1)));
  };
  var parseVersion = function ($34) {
      return Data_Function.flip(Text_Parsing_Parser.runParser)(versionParser)(Data_List.fromFoldable(Data_Foldable.foldableArray)(Data_String.toCharArray($34)));
  };
  var eqVersion = new Data_Eq.Eq(function (v) {
      return function (v1) {
          return Data_Eq.eq(Data_List_Types.eqList(Data_Eq.eqInt))(v.value0)(v1.value0) && Data_Eq.eq(Data_List_Types.eqList(Data_Eq.eqString))(v.value1)(v1.value1);
      };
  });
  var ordVersion = new Data_Ord.Ord(function () {
      return eqVersion;
  }, function (v) {
      return function (v1) {
          return Data_Semigroup.append(Data_Ordering.semigroupOrdering)(Data_Ord.compare(Data_List_Types.ordList(Data_Ord.ordInt))(v.value0)(v1.value0))(Data_Ord.compare(Data_List_Types.ordList(Data_Ord.ordString))(v.value1)(v1.value1));
      };
  });
  exports["Version"] = Version;
  exports["parseVersion"] = parseVersion;
  exports["showVersion"] = showVersion;
  exports["versionParser"] = versionParser;
  exports["eqVersion"] = eqVersion;
  exports["ordVersion"] = ordVersion;
})(PS["Data.Version.Haskell"] = PS["Data.Version.Haskell"] || {});
(function(exports) {
  // module Main

  "use strict";

  exports.logStack = function logStack(err) {
    return function() {
      console.log(err.stack);
    };
  };
})(PS["Main"] = PS["Main"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Node.Encoding"];
  var Prelude = PS["Prelude"];
  var Data_Show = PS["Data.Show"];        
  var ASCII = (function () {
      function ASCII() {

      };
      ASCII.value = new ASCII();
      return ASCII;
  })();
  var UTF8 = (function () {
      function UTF8() {

      };
      UTF8.value = new UTF8();
      return UTF8;
  })();
  var UTF16LE = (function () {
      function UTF16LE() {

      };
      UTF16LE.value = new UTF16LE();
      return UTF16LE;
  })();
  var UCS2 = (function () {
      function UCS2() {

      };
      UCS2.value = new UCS2();
      return UCS2;
  })();
  var Base64 = (function () {
      function Base64() {

      };
      Base64.value = new Base64();
      return Base64;
  })();
  var Latin1 = (function () {
      function Latin1() {

      };
      Latin1.value = new Latin1();
      return Latin1;
  })();
  var Binary = (function () {
      function Binary() {

      };
      Binary.value = new Binary();
      return Binary;
  })();
  var Hex = (function () {
      function Hex() {

      };
      Hex.value = new Hex();
      return Hex;
  })();
  var showEncoding = new Data_Show.Show(function (v) {
      if (v instanceof ASCII) {
          return "ASCII";
      };
      if (v instanceof UTF8) {
          return "UTF8";
      };
      if (v instanceof UTF16LE) {
          return "UTF16LE";
      };
      if (v instanceof UCS2) {
          return "UCS2";
      };
      if (v instanceof Base64) {
          return "Base64";
      };
      if (v instanceof Latin1) {
          return "Latin1";
      };
      if (v instanceof Binary) {
          return "Binary";
      };
      if (v instanceof Hex) {
          return "Hex";
      };
      throw new Error("Failed pattern match at Node.Encoding line 20, column 3 - line 21, column 3: " + [ v.constructor.name ]);
  });

  /**
 *  | Convert an `Encoding` to a `String` in the format expected by Node.js
 *  | APIs.
 */  
  var encodingToNode = function (v) {
      if (v instanceof ASCII) {
          return "ascii";
      };
      if (v instanceof UTF8) {
          return "utf8";
      };
      if (v instanceof UTF16LE) {
          return "utf16le";
      };
      if (v instanceof UCS2) {
          return "ucs2";
      };
      if (v instanceof Base64) {
          return "base64";
      };
      if (v instanceof Latin1) {
          return "latin1";
      };
      if (v instanceof Binary) {
          return "binary";
      };
      if (v instanceof Hex) {
          return "hex";
      };
      throw new Error("Failed pattern match at Node.Encoding line 32, column 1 - line 33, column 1: " + [ v.constructor.name ]);
  };
  exports["ASCII"] = ASCII;
  exports["UTF8"] = UTF8;
  exports["UTF16LE"] = UTF16LE;
  exports["UCS2"] = UCS2;
  exports["Base64"] = Base64;
  exports["Latin1"] = Latin1;
  exports["Binary"] = Binary;
  exports["Hex"] = Hex;
  exports["encodingToNode"] = encodingToNode;
  exports["showEncoding"] = showEncoding;
})(PS["Node.Encoding"] = PS["Node.Encoding"] || {});
(function(exports) {
  /* global exports */
  /* global Buffer */
  /* global require */
  "use strict";

  exports.fromStringImpl = function (str) {
    return function (encoding) {
      return function() {
        return new Buffer(str, encoding);
      };
    };
  };

  exports.toStringImpl = function (enc) {
    return function (buff) {
      return function() {
        return buff.toString(enc);
      };
    };
  };

  exports.size = function (buff) {
    return function() {
      return buff.length;
    };
  };
})(PS["Node.Buffer"] = PS["Node.Buffer"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Node.Buffer"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Maybe = PS["Data.Maybe"];
  var Node_Encoding = PS["Node.Encoding"];
  var Data_Show = PS["Data.Show"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];

  /**
 *  | Reads the buffer as a string with the specified encoding.
 */  
  var toString = function ($3) {
      return $foreign.toStringImpl(Node_Encoding.encodingToNode($3));
  };                                                                                           

  /**
 *  | Creates a new buffer from a string with the specified encoding, sized to
 *  | match the string.
 */  
  var fromString = function (str) {
      return function ($7) {
          return $foreign.fromStringImpl(str)(Node_Encoding.encodingToNode($7));
      };
  };
  exports["fromString"] = fromString;
  exports["toString"] = toString;
  exports["size"] = $foreign.size;
})(PS["Node.Buffer"] = PS["Node.Buffer"] || {});
(function(exports) {
    "use strict";                                

  exports.statsMethod = function (m, s) {
    return s[m]();
  };
})(PS["Node.FS.Stats"] = PS["Node.FS.Stats"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Node.FS.Stats"];
  var Prelude = PS["Prelude"];
  var Data_DateTime = PS["Data.DateTime"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Data_JSDate = PS["Data.JSDate"];
  var Data_Maybe = PS["Data.Maybe"];
  var Partial_Unsafe = PS["Partial.Unsafe"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Function = PS["Data.Function"];        

  /**
 *  | Stats wrapper to provide a usable interface to the underlying properties and methods.
 */  
  var Stats = (function () {
      function Stats(value0) {
          this.value0 = value0;
      };
      Stats.create = function (value0) {
          return new Stats(value0);
      };
      return Stats;
  })();
  var isFile = function (v) {
      return $foreign.statsMethod("isFile", v.value0);
  };
  var isDirectory = function (v) {
      return $foreign.statsMethod("isDirectory", v.value0);
  };
  exports["Stats"] = Stats;
  exports["isDirectory"] = isDirectory;
  exports["isFile"] = isFile;
})(PS["Node.FS.Stats"] = PS["Node.FS.Stats"] || {});
(function(exports) {
    "use strict";
  var path =require("path"); 

  exports.normalize = path.normalize;

  exports.concat = function (segments) {
    return path.join.apply(this, segments);
  };

  exports.resolve = function (from) {
    return function (to) {
      return path.resolve.apply(this, from.concat([to]));
    };
  };

  exports.dirname = function (p) {
    return path.normalize(path.dirname(p));
  };

  exports.basename = path.basename;

  exports.delimiter = path.delimiter;

  exports.parse = path.parse;
})(PS["Node.Path"] = PS["Node.Path"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Node.Path"];
  exports["basename"] = $foreign.basename;
  exports["concat"] = $foreign.concat;
  exports["delimiter"] = $foreign.delimiter;
  exports["dirname"] = $foreign.dirname;
  exports["parse"] = $foreign.parse;
  exports["resolve"] = $foreign.resolve;
})(PS["Node.Path"] = PS["Node.Path"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Char = PS["Data.Char"];
  var Data_Int = PS["Data.Int"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_String = PS["Data.String"];
  var Global = PS["Global"];
  var Partial_Unsafe = PS["Partial.Unsafe"];
  var Data_Eq = PS["Data.Eq"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Semiring = PS["Data.Semiring"];
  var Data_Function = PS["Data.Function"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Boolean = PS["Data.Boolean"];
  var Control_Apply = PS["Control.Apply"];

  /**
 *  | The "writable" permission.
 */  
  var write = {
      r: false, 
      w: true, 
      x: false
  };
  var semiringPerm = new Data_Semiring.Semiring(function (v) {
      return function (v1) {
          return {
              r: v.r || v1.r, 
              w: v.w || v1.w, 
              x: v.x || v1.x
          };
      };
  }, function (v) {
      return function (v1) {
          return {
              r: v.r && v1.r, 
              w: v.w && v1.w, 
              x: v.x && v1.x
          };
      };
  }, {
      r: true, 
      w: true, 
      x: true
  }, {
      r: false, 
      w: false, 
      x: false
  });

  /**
 *  | The "readable" permission.
 */  
  var read = {
      r: true, 
      w: false, 
      x: false
  };

  /**
 *  | Convert a `Perm` to an octal digit. For example:
 *  |
 *  | * `permToInt r == 4`
 *  | * `permToInt w == 2`
 *  | * `permToInt (r + w) == 6`
 */  
  var permToInt = function (v) {
      return ((function () {
          if (v.r) {
              return 4;
          };
          if (!v.r) {
              return 0;
          };
          throw new Error("Failed pattern match at Node.FS.Perms line 158, column 8 - line 158, column 26: " + [ v.r.constructor.name ]);
      })() + (function () {
          if (v.w) {
              return 2;
          };
          if (!v.w) {
              return 0;
          };
          throw new Error("Failed pattern match at Node.FS.Perms line 159, column 8 - line 159, column 26: " + [ v.w.constructor.name ]);
      })() | 0) + (function () {
          if (v.x) {
              return 1;
          };
          if (!v.x) {
              return 0;
          };
          throw new Error("Failed pattern match at Node.FS.Perms line 160, column 8 - line 160, column 26: " + [ v.x.constructor.name ]);
      })() | 0;
  };

  /**
 *  | Convert a `Perm` to an octal string, via `permToInt`.
 */  
  var permToString = function ($96) {
      return Data_Show.show(Data_Show.showInt)(permToInt($96));
  };

  /**
 *  | Convert a `Perms` value to an octal string, in a format similar to that
 *  | accepted by `chmod`. For example:
 *  | `permsToString (mkPerms (read + write) read read) == "0644"`
 */  
  var permsToString = function (v) {
      return "0" + (permToString(v.u) + (permToString(v.g) + permToString(v.o)));
  }; 

  /**
 *  | No permissions. This is the identity of the `Semiring` operation `(+)`
 *  | for `Perm`; that is, it is the same as `zero`.
 */  
  var none = Data_Semiring.zero(semiringPerm);

  /**
 *  | Create a `Perms` value. The arguments represent the owner's, group's, and
 *  | other users' permission sets, respectively.
 */  
  var mkPerms = function (u) {
      return function (g) {
          return function (o) {
              return {
                  u: u, 
                  g: g, 
                  o: o
              };
          };
      };
  }; 

  /**
 *  | All permissions: readable, writable, and executable. This is the identity
 *  | of the `Semiring` operation `(*)` for `Perm`; that is, it is the same as
 *  | `one`.
 */  
  var all = Data_Semiring.one(semiringPerm);
  exports["all"] = all;
  exports["mkPerms"] = mkPerms;
  exports["none"] = none;
  exports["permsToString"] = permsToString;
  exports["read"] = read;
  exports["write"] = write;
  exports["semiringPerm"] = semiringPerm;
})(PS["Node.FS.Perms"] = PS["Node.FS.Perms"] || {});
(function(exports) {
    "use strict";

  exports.unsafeRequireFS = require("fs");
})(PS["Node.FS.Internal"] = PS["Node.FS.Internal"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Node.FS.Internal"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Unsafe_Coerce = PS["Unsafe.Coerce"];        
  var mkEff = Unsafe_Coerce.unsafeCoerce;
  exports["mkEff"] = mkEff;
  exports["unsafeRequireFS"] = $foreign.unsafeRequireFS;
})(PS["Node.FS.Internal"] = PS["Node.FS.Internal"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Data_DateTime = PS["Data.DateTime"];
  var Data_Time_Duration = PS["Data.Time.Duration"];
  var Data_DateTime_Instant = PS["Data.DateTime.Instant"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Data_Nullable = PS["Data.Nullable"];
  var Data_Int = PS["Data.Int"];
  var Data_Maybe = PS["Data.Maybe"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_FS = PS["Node.FS"];
  var Node_FS_Stats = PS["Node.FS.Stats"];
  var Node_Path = PS["Node.Path"];
  var Node_FS_Perms = PS["Node.FS.Perms"];
  var Node_FS_Internal = PS["Node.FS.Internal"];
  var Data_Function = PS["Data.Function"];
  var Data_Show = PS["Data.Show"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_EuclideanRing = PS["Data.EuclideanRing"];
  var Control_Bind = PS["Control.Bind"];        
  var fs = Node_FS_Internal.unsafeRequireFS;

  /**
 *  | Reads the entire contents of a text file with the specified encoding.
 */  
  var readTextFile = function (encoding) {
      return function (file) {
          return Node_FS_Internal.mkEff(function (v) {
              return fs.readFileSync(file, {
                  encoding: Data_Show.show(Node_Encoding.showEncoding)(encoding)
              });
          });
      };
  };
  exports["readTextFile"] = readTextFile;
})(PS["Node.FS.Sync"] = PS["Node.FS.Sync"] || {});
(function(exports) {
    "use strict";

  exports.process = process;

  exports.onSignalImpl = function (signal) {
    return function (callback) {
      return function () {
        process.on(signal, callback);
      };
    };
  };

  exports.chdir = function (dir) {
    return function () {
      process.chdir(dir);
    };
  };

  exports.setEnv = function (var_) {
    return function (val) {
      return function () {
        process.env[var_] = val;
      };
    };
  };

  exports.exit = function (code) {
    return function () {
      process.exit(code);
    };
  };
})(PS["Node.Process"] = PS["Node.Process"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines data type for the different platforms supported by
 *  | Node.js
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Show = PS["Data.Show"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Ordering = PS["Data.Ordering"];        
  var Darwin = (function () {
      function Darwin() {

      };
      Darwin.value = new Darwin();
      return Darwin;
  })();
  var FreeBSD = (function () {
      function FreeBSD() {

      };
      FreeBSD.value = new FreeBSD();
      return FreeBSD;
  })();
  var Linux = (function () {
      function Linux() {

      };
      Linux.value = new Linux();
      return Linux;
  })();
  var SunOS = (function () {
      function SunOS() {

      };
      SunOS.value = new SunOS();
      return SunOS;
  })();
  var Win32 = (function () {
      function Win32() {

      };
      Win32.value = new Win32();
      return Win32;
  })();
  var fromString = function (v) {
      if (v === "darwin") {
          return new Data_Maybe.Just(Darwin.value);
      };
      if (v === "freebsd") {
          return new Data_Maybe.Just(FreeBSD.value);
      };
      if (v === "linux") {
          return new Data_Maybe.Just(Linux.value);
      };
      if (v === "sunos") {
          return new Data_Maybe.Just(SunOS.value);
      };
      if (v === "win32") {
          return new Data_Maybe.Just(Win32.value);
      };
      return Data_Maybe.Nothing.value;
  };
  var eqPlatform = new Data_Eq.Eq(function (x) {
      return function (y) {
          if (x instanceof Darwin && y instanceof Darwin) {
              return true;
          };
          if (x instanceof FreeBSD && y instanceof FreeBSD) {
              return true;
          };
          if (x instanceof Linux && y instanceof Linux) {
              return true;
          };
          if (x instanceof SunOS && y instanceof SunOS) {
              return true;
          };
          if (x instanceof Win32 && y instanceof Win32) {
              return true;
          };
          return false;
      };
  });
  exports["Darwin"] = Darwin;
  exports["FreeBSD"] = FreeBSD;
  exports["Linux"] = Linux;
  exports["SunOS"] = SunOS;
  exports["Win32"] = Win32;
  exports["fromString"] = fromString;
  exports["eqPlatform"] = eqPlatform;
})(PS["Node.Platform"] = PS["Node.Platform"] || {});
(function(exports) {
    "use strict";

  exports.onError = function (s) {
    return function (f) {
      return function () {
        s.on("error", function (e) {
          f(e)();
        });
      };
    };
  };

  exports.write = function (w) {
    return function (chunk) {
      return function (done) {
        return function () {
          return w.write(chunk, null, done);
        };
      };
    };
  };

  exports.writeStringImpl = function (w) {
    return function (enc) {
      return function (s) {
        return function (done) {
          return function () {
            return w.write(s, enc, done);
          };
        };
      };
    };
  };

  exports.end = function (w) {
    return function (done) {
      return function () {
        w.end(null, null, function () {
          done();
        });
      };
    };
  };
})(PS["Node.Stream"] = PS["Node.Stream"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module provides a low-level wrapper for the Node Stream API.
 */  
  "use strict";
  var $foreign = PS["Node.Stream"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Eff_Unsafe = PS["Control.Monad.Eff.Unsafe"];
  var Data_Either = PS["Data.Either"];
  var Data_Maybe = PS["Data.Maybe"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_Encoding = PS["Node.Encoding"];
  var Data_Show = PS["Data.Show"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Function = PS["Data.Function"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];        

  /**
 *  | Write a string in the specified encoding to a writable stream.
 */  
  var writeString = function (w) {
      return function (enc) {
          return $foreign.writeStringImpl(w)(Data_Show.show(Node_Encoding.showEncoding)(enc));
      };
  };
  exports["writeString"] = writeString;
  exports["end"] = $foreign.end;
  exports["onError"] = $foreign.onError;
  exports["write"] = $foreign.write;
})(PS["Node.Stream"] = PS["Node.Stream"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | Bindings to the global `process` object in Node.js. See also [the Node API documentation](https://nodejs.org/api/process.html)
 */  
  "use strict";
  var $foreign = PS["Node.Process"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_Eff_Console = PS["Control.Monad.Eff.Console"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Posix = PS["Data.Posix"];
  var Data_Posix_Signal = PS["Data.Posix.Signal"];
  var Data_StrMap = PS["Data.StrMap"];
  var Node_Platform = PS["Node.Platform"];
  var Node_Stream = PS["Node.Stream"];
  var Partial_Unsafe = PS["Partial.Unsafe"];
  var Unsafe_Coerce = PS["Unsafe.Coerce"];
  var Data_Function = PS["Data.Function"];
  var Data_Functor = PS["Data.Functor"];        

  /**
 *  | Get the Node.js version.
 */  
  var version = $foreign.process.version;         

  /**
 *  | The standard output stream. Note that this stream cannot be closed; calling
 *  | `end` will result in an exception being thrown.
 */  
  var stdout = $foreign.process.stdout;

  /**
 *  | The standard input stream. Note that this stream will never emit an `end`
 *  | event, so any handlers attached via `onEnd` will never be called.
 */  
  var stdin = $foreign.process.stdin;             

  /**
 *  | The standard error stream. Note that this stream cannot be closed; calling
 *  | `end` will result in an exception being thrown.
 */  
  var stderr = $foreign.process.stderr;
  var platform = Partial_Unsafe.unsafePartial(function (dictPartial) {
      return Data_Maybe.fromJust(dictPartial)(Node_Platform.fromString($foreign.process.platform));
  });                            

  /**
 *  | Install a handler for a particular signal.
 */  
  var onSignal = function (sig) {
      return $foreign.onSignalImpl(Data_Posix_Signal.toString(sig));
  };
  var mkEff = Unsafe_Coerce.unsafeCoerce;

  /**
 *  | Get a copy of the current environment.
 */  
  var getEnv = mkEff(function (v) {
      return $foreign.process.env;
  });

  /**
 *  | Lookup a particular environment variable.
 */  
  var lookupEnv = function (k) {
      return Data_Functor.map(Control_Monad_Eff.functorEff)(Data_StrMap.lookup(k))(getEnv);
  }; 

  /**
 *  | Get the current working directory of the process.
 */  
  var cwd = $foreign.process.cwd;

  /**
 *  | Get an array containing the command line arguments. Be aware
 *  | that this can change over the course of the program.
 */  
  var argv = mkEff(function (v) {
      return $foreign.process.argv;
  });
  exports["argv"] = argv;
  exports["cwd"] = cwd;
  exports["getEnv"] = getEnv;
  exports["lookupEnv"] = lookupEnv;
  exports["onSignal"] = onSignal;
  exports["platform"] = platform;
  exports["stderr"] = stderr;
  exports["stdin"] = stdin;
  exports["stdout"] = stdout;
  exports["version"] = version;
  exports["chdir"] = $foreign.chdir;
  exports["exit"] = $foreign.exit;
  exports["setEnv"] = $foreign.setEnv;
})(PS["Node.Process"] = PS["Node.Process"] || {});
(function(exports) {
  // module Pulp.System.FFI

  "use strict";

  exports["runNode'"] = function runNode$prime(error, success, fn) {
    return function() {
      fn(function(err, val) {
        if (err) { error(err)(); } else { success(val)(); }
      });
    };
  };

  exports.unsafeInspect = function unsafeInspect(obj) {
    return require('util').inspect(obj);
  };
})(PS["Pulp.System.FFI"] = PS["Pulp.System.FFI"] || {});
(function(exports) {
    "use strict";

  /* eslint-env node*/

  exports.unsafeFromNullable = function unsafeFromNullable (msg) {
    return function (x) {
      if (x === null) throw new Error(msg);
      return x;
    };
  };

  exports.spawnImpl = function spawnImpl (command) {
    return function (args) {
      return function (opts) {
        return function () {
          return require("child_process").spawn(command, args, opts);
        };
      };
    };
  };

  exports.fork = function fork (cmd) {
    return function (args) {
      return function () {
        return require("child_process").fork(cmd, args);
      };
    };
  };

  exports.mkOnExit = function mkOnExit (mkChildExit) {
    return function onExit (cp) {
      return function (cb) {
        return function () {
          cp.on("exit", function (code, signal) {
            cb(mkChildExit(code)(signal))();
          });
        };
      };
    };
  };

  exports.onError = function onError (cp) {
    return function (cb) {
      return function () {
        cp.on("error", function (err) {
          cb(err)();
        });
      };
    };
  };

  exports.undefined = undefined;
  exports.process = process;
})(PS["Node.ChildProcess"] = PS["Node.ChildProcess"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module contains various types and functions to allow you to spawn and
 *  | interact with child processes.
 *  |
 *  | It is intended to be imported qualified, as follows:
 *  |
 *  | ```purescript
 *  | import Node.ChildProcess (ChildProcess, CHILD_PROCESS)
 *  | import Node.ChildProcess as ChildProcess
 *  | ```
 *  |
 *  | The [Node.js documentation](https://nodejs.org/api/child_process.html)
 *  | will probably also be useful to read if you want to use this module.
 */  
  "use strict";
  var $foreign = PS["Node.ChildProcess"];
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Eff_Exception_Unsafe = PS["Control.Monad.Eff.Exception.Unsafe"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Nullable = PS["Data.Nullable"];
  var Data_Posix = PS["Data.Posix"];
  var Data_Posix_Signal = PS["Data.Posix.Signal"];
  var Data_StrMap = PS["Data.StrMap"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_FS = PS["Node.FS"];
  var Node_Stream = PS["Node.Stream"];
  var Unsafe_Coerce = PS["Unsafe.Coerce"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Control_Bind = PS["Control.Bind"];        

  /**
 *  | Behaviour for standard IO streams (eg, standard input, standard output) of
 *  | a child process.
 *  |
 *  | * `Pipe`: creates a pipe between the child and parent process, which can
 *  |   then be accessed as a `Stream` via the `stdin`, `stdout`, or `stderr`
 *  |   functions.
 *  | * `Ignore`: ignore this stream. This will cause Node to open /dev/null and
 *  |   connect it to the stream.
 *  | * `ShareStream`: Connect the supplied stream to the corresponding file
 *  |    descriptor in the child.
 *  | * `ShareFD`: Connect the supplied file descriptor (which should be open
 *  |   in the parent) to the corresponding file descriptor in the child.
 */  
  var Pipe = (function () {
      function Pipe() {

      };
      Pipe.value = new Pipe();
      return Pipe;
  })();

  /**
 *  | Behaviour for standard IO streams (eg, standard input, standard output) of
 *  | a child process.
 *  |
 *  | * `Pipe`: creates a pipe between the child and parent process, which can
 *  |   then be accessed as a `Stream` via the `stdin`, `stdout`, or `stderr`
 *  |   functions.
 *  | * `Ignore`: ignore this stream. This will cause Node to open /dev/null and
 *  |   connect it to the stream.
 *  | * `ShareStream`: Connect the supplied stream to the corresponding file
 *  |    descriptor in the child.
 *  | * `ShareFD`: Connect the supplied file descriptor (which should be open
 *  |   in the parent) to the corresponding file descriptor in the child.
 */  
  var Ignore = (function () {
      function Ignore() {

      };
      Ignore.value = new Ignore();
      return Ignore;
  })();

  /**
 *  | Behaviour for standard IO streams (eg, standard input, standard output) of
 *  | a child process.
 *  |
 *  | * `Pipe`: creates a pipe between the child and parent process, which can
 *  |   then be accessed as a `Stream` via the `stdin`, `stdout`, or `stderr`
 *  |   functions.
 *  | * `Ignore`: ignore this stream. This will cause Node to open /dev/null and
 *  |   connect it to the stream.
 *  | * `ShareStream`: Connect the supplied stream to the corresponding file
 *  |    descriptor in the child.
 *  | * `ShareFD`: Connect the supplied file descriptor (which should be open
 *  |   in the parent) to the corresponding file descriptor in the child.
 */  
  var ShareStream = (function () {
      function ShareStream(value0) {
          this.value0 = value0;
      };
      ShareStream.create = function (value0) {
          return new ShareStream(value0);
      };
      return ShareStream;
  })();

  /**
 *  | Behaviour for standard IO streams (eg, standard input, standard output) of
 *  | a child process.
 *  |
 *  | * `Pipe`: creates a pipe between the child and parent process, which can
 *  |   then be accessed as a `Stream` via the `stdin`, `stdout`, or `stderr`
 *  |   functions.
 *  | * `Ignore`: ignore this stream. This will cause Node to open /dev/null and
 *  |   connect it to the stream.
 *  | * `ShareStream`: Connect the supplied stream to the corresponding file
 *  |    descriptor in the child.
 *  | * `ShareFD`: Connect the supplied file descriptor (which should be open
 *  |   in the parent) to the corresponding file descriptor in the child.
 */  
  var ShareFD = (function () {
      function ShareFD(value0) {
          this.value0 = value0;
      };
      ShareFD.create = function (value0) {
          return new ShareFD(value0);
      };
      return ShareFD;
  })();

  /**
 *  | Specifies how a child process exited; normally (with an exit code), or
 *  | due to a signal.
 */  
  var Normally = (function () {
      function Normally(value0) {
          this.value0 = value0;
      };
      Normally.create = function (value0) {
          return new Normally(value0);
      };
      return Normally;
  })();

  /**
 *  | Specifies how a child process exited; normally (with an exit code), or
 *  | due to a signal.
 */  
  var BySignal = (function () {
      function BySignal(value0) {
          this.value0 = value0;
      };
      BySignal.create = function (value0) {
          return new BySignal(value0);
      };
      return BySignal;
  })();

  /**
 *  | Convert a ChildProcess.Error to a standard Error, which can then be thrown
 *  | inside an Eff or Aff computation (for example).
 */  
  var toStandardError = Unsafe_Coerce.unsafeCoerce;
  var toActualStdIOBehaviour = function (b) {
      if (b instanceof Pipe) {
          return Unsafe_Coerce.unsafeCoerce("pipe");
      };
      if (b instanceof Ignore) {
          return Unsafe_Coerce.unsafeCoerce("ignore");
      };
      if (b instanceof ShareFD) {
          return Unsafe_Coerce.unsafeCoerce(b.value0);
      };
      if (b instanceof ShareStream) {
          return Unsafe_Coerce.unsafeCoerce(b.value0);
      };
      throw new Error("Failed pattern match at Node.ChildProcess line 382, column 28 - line 386, column 33: " + [ b.constructor.name ]);
  };
  var toActualStdIOOptions = Data_Functor.map(Data_Functor.functorArray)(function ($31) {
      return Data_Nullable.toNullable(Data_Functor.map(Data_Maybe.functorMaybe)(toActualStdIOBehaviour)($31));
  });

  /**
 *  | Spawn a child process. Note that, in the event that a child process could
 *  | not be spawned (for example, if the executable was not found) this will
 *  | not throw an error. Instead, the `ChildProcess` will be created anyway,
 *  | but it will immediately emit an 'error' event.
 */  
  var spawn = function (cmd) {
      return function (args) {
          var convertOpts = function (opts) {
              return {
                  cwd: Data_Maybe.fromMaybe($foreign["undefined"])(opts.cwd), 
                  stdio: toActualStdIOOptions(opts.stdio), 
                  env: Data_Nullable.toNullable(opts.env), 
                  detached: opts.detached, 
                  uid: Data_Maybe.fromMaybe($foreign["undefined"])(opts.uid), 
                  gid: Data_Maybe.fromMaybe($foreign["undefined"])(opts.gid)
              };
          };
          return function ($32) {
              return $foreign.spawnImpl(cmd)(args)(convertOpts($32));
          };
      };
  }; 
  var runChildProcess = function (v) {
      return v;
  };

  /**
 *  | Create pipes for each of the three standard IO streams.
 */  
  var pipe = Data_Functor.map(Data_Functor.functorArray)(Data_Maybe.Just.create)([ Pipe.value, Pipe.value, Pipe.value ]);

  /**
 *  | The process ID of a child process. Note that if the process has already
 *  | exited, another process may have taken the same ID, so be careful!
 */  
  var pid = function ($33) {
      return (function (v) {
          return v.pid;
      })(runChildProcess($33));
  };                                                                                     
  var mkExit = function (code) {
      return function (signal) {
          var fromSignal = Control_Bind.composeKleisli(Data_Maybe.bindMaybe)(Data_Nullable.toMaybe)(function ($34) {
              return Data_Functor.map(Data_Maybe.functorMaybe)(BySignal.create)(Data_Posix_Signal.fromString($34));
          });
          var fromCode = function ($35) {
              return Data_Functor.map(Data_Maybe.functorMaybe)(Normally.create)(Data_Nullable.toMaybe($35));
          };
          var $20 = Control_Alt.alt(Data_Maybe.altMaybe)(fromCode(code))(fromSignal(signal));
          if ($20 instanceof Data_Maybe.Just) {
              return $20.value0;
          };
          if ($20 instanceof Data_Maybe.Nothing) {
              return Control_Monad_Eff_Exception_Unsafe.unsafeThrow("Node.ChildProcess.mkExit: Invalid arguments");
          };
          throw new Error("Failed pattern match at Node.ChildProcess line 152, column 3 - line 155, column 3: " + [ $20.constructor.name ]);
      };
  };                                       
  var onExit = $foreign.mkOnExit(mkExit);
  var mkEff = Unsafe_Coerce.unsafeCoerce;
  var missingStream = function (str) {
      return "Node.ChildProcess: stream not available: " + (str + ("\nThis is probably " + ("because you passed something other than Pipe to the stdio option when " + "you spawned it.")));
  };

  /**
 *  | The standard error stream of a child process. Note that this is only
 *  | available if the process was spawned with the stderr option set to "pipe".
 */  
  var stderr = function ($36) {
      return $foreign.unsafeFromNullable(missingStream("stderr"))((function (v) {
          return v.stderr;
      })(runChildProcess($36)));
  };

  /**
 *  | The standard input stream of a child process. Note that this is only
 *  | available if the process was spawned with the stdin option set to "pipe".
 */  
  var stdin = function ($37) {
      return $foreign.unsafeFromNullable(missingStream("stdin"))((function (v) {
          return v.stdin;
      })(runChildProcess($37)));
  };

  /**
 *  | The standard output stream of a child process. Note that this is only
 *  | available if the process was spawned with the stdout option set to "pipe".
 */  
  var stdout = function ($38) {
      return $foreign.unsafeFromNullable(missingStream("stdout"))((function (v) {
          return v.stdout;
      })(runChildProcess($38)));
  };

  /**
 *  | Send a signal to a child process. It's an unfortunate historical decision
 *  | that this function is called "kill", as sending a signal to a child
 *  | process won't necessarily kill it.
 */  
  var kill = function (sig) {
      return function (v) {
          return mkEff(function (v1) {
              return v.kill(Data_Posix_Signal.toString(sig));
          });
      };
  };

  /**
 *  | Share stdin with stdin, stdout with stdout, and stderr with stderr.
 */  
  var inherit = Data_Functor.map(Data_Functor.functorArray)(Data_Maybe.Just.create)([ new ShareStream($foreign.process.stdin), new ShareStream($foreign.process.stdout), new ShareStream($foreign.process.stderr) ]);
  var defaultSpawnOptions = {
      cwd: Data_Maybe.Nothing.value, 
      stdio: pipe, 
      env: Data_Maybe.Nothing.value, 
      detached: false, 
      uid: Data_Maybe.Nothing.value, 
      gid: Data_Maybe.Nothing.value
  };
  exports["Normally"] = Normally;
  exports["BySignal"] = BySignal;
  exports["Pipe"] = Pipe;
  exports["Ignore"] = Ignore;
  exports["ShareStream"] = ShareStream;
  exports["ShareFD"] = ShareFD;
  exports["defaultSpawnOptions"] = defaultSpawnOptions;
  exports["inherit"] = inherit;
  exports["kill"] = kill;
  exports["onExit"] = onExit;
  exports["pid"] = pid;
  exports["pipe"] = pipe;
  exports["spawn"] = spawn;
  exports["stderr"] = stderr;
  exports["stdin"] = stdin;
  exports["stdout"] = stdout;
  exports["toStandardError"] = toStandardError;
  exports["fork"] = $foreign.fork;
  exports["onError"] = $foreign.onError;
})(PS["Node.ChildProcess"] = PS["Node.ChildProcess"] || {});
(function(exports) {
    "use strict";
  var http =require("http"); 

  exports.createServer = function (handleRequest) {
    return function () {
      return http.createServer(function (req, res) {
        handleRequest(req)(res)();
      });
    };
  };

  exports.listenImpl = function (server) {
    return function (port) {
      return function (hostname) {
        return function (backlog) {
          return function (done) {
            return function () {
              if (backlog !== null) {
                server.listen(port, hostname, backlog, done);
              } else {
                server.listen(port, hostname, done);
              }
            };
          };
        };
      };
    };
  };

  exports.setStatusCode = function (res) {
    return function (code) {
      return function () {
        res.statusCode = code;
      };
    };
  };

  exports.setStatusMessage = function (res) {
    return function (message) {
      return function () {
        res.statusMessage = message;
      };
    };
  };
})(PS["Node.HTTP"] = PS["Node.HTTP"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines low-level bindings to the Node HTTP module.
 */  
  "use strict";
  var $foreign = PS["Node.HTTP"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Nullable = PS["Data.Nullable"];
  var Data_StrMap = PS["Data.StrMap"];
  var Node_Stream = PS["Node.Stream"];
  var Unsafe_Coerce = PS["Unsafe.Coerce"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];        

  /**
 *  | Coerce the response object into a writable stream.
 */  
  var responseAsStream = Unsafe_Coerce.unsafeCoerce;

  /**
 *  | Get the request URL
 */  
  var requestURL = function ($4) {
      return (function (v) {
          return v.url;
      })(Unsafe_Coerce.unsafeCoerce($4));
  };                                               

  /**
 *  | Listen on a port in order to start accepting HTTP requests. The specified callback will be run when setup is complete.
 */  
  var listen = function (server) {
      return function (opts) {
          return function (done) {
              return $foreign.listenImpl(server)(opts.port)(opts.hostname)(Data_Nullable.toNullable(opts.backlog))(done);
          };
      };
  };
  exports["listen"] = listen;
  exports["requestURL"] = requestURL;
  exports["responseAsStream"] = responseAsStream;
  exports["createServer"] = $foreign.createServer;
  exports["setStatusCode"] = $foreign.setStatusCode;
  exports["setStatusMessage"] = $foreign.setStatusMessage;
})(PS["Node.HTTP"] = PS["Node.HTTP"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Pulp.System.FFI"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Aff_AVar = PS["Control.Monad.Aff.AVar"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Eff_Console = PS["Control.Monad.Eff.Console"];
  var Control_Monad_Eff_Now = PS["Control.Monad.Eff.Now"];
  var Control_Monad_Eff_Ref = PS["Control.Monad.Eff.Ref"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Unsafe_Coerce = PS["Unsafe.Coerce"];
  var Node_FS = PS["Node.FS"];
  var Node_ChildProcess = PS["Node.ChildProcess"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_Process = PS["Node.Process"];
  var Node_ReadLine = PS["Node.ReadLine"];
  var Node_HTTP = PS["Node.HTTP"];        
  var unsafeToEffN = Unsafe_Coerce.unsafeCoerce;
  var runNode = function (fn) {
      return Control_Monad_Aff.makeAff(function (err) {
          return function (win) {
              return $foreign["runNode'"](err, win, fn);
          };
      });
  };
  exports["runNode"] = runNode;
  exports["unsafeToEffN"] = unsafeToEffN;
  exports["unsafeInspect"] = $foreign.unsafeInspect;
})(PS["Pulp.System.FFI"] = PS["Pulp.System.FFI"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Map = PS["Data.Map"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_List = PS["Data.List"];
  var Data_Foreign = PS["Data.Foreign"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var runAction = function (v) {
      return v;
  };
  var option = function (name) {
      return function (match) {
          return function (parser) {
              return function (desc) {
                  return {
                      name: name, 
                      match: match, 
                      parser: parser, 
                      desc: desc, 
                      defaultValue: Data_Maybe.Nothing.value
                  };
              };
          };
      };
  };
  var optionDefault = function (n) {
      return function (m) {
          return function (p) {
              return function (d) {
                  return function (defaultValue) {
                      var $4 = option(n)(m)(p)(d);
                      var $2 = {};
                      for (var $3 in $4) {
                          if ({}.hasOwnProperty.call($4, $3)) {
                              $2[$3] = $4[$3];
                          };
                      };
                      $2.defaultValue = new Data_Maybe.Just(Data_Foreign.toForeign(defaultValue));
                      return $2;
                  };
              };
          };
      };
  };
  var command = function (name) {
      return function (desc) {
          return function (passthroughDesc) {
              return function (action) {
                  return function (options) {
                      return {
                          name: name, 
                          desc: desc, 
                          passthroughDesc: passthroughDesc, 
                          options: options, 
                          action: action, 
                          "arguments": [  ]
                      };
                  };
              };
          };
      };
  };
  var commandWithArgs = function (name) {
      return function (desc) {
          return function (passthroughDesc) {
              return function (action) {
                  return function (options) {
                      return function (args) {
                          var $7 = command(name)(desc)(passthroughDesc)(action)(options);
                          var $5 = {};
                          for (var $6 in $7) {
                              if ({}.hasOwnProperty.call($7, $6)) {
                                  $5[$6] = $7[$6];
                              };
                          };
                          $5["arguments"] = args;
                          return $5;
                      };
                  };
              };
          };
      };
  };
  var argument = function (name) {
      return function (parser) {
          return function (desc) {
              return function (required) {
                  return {
                      name: name, 
                      parser: parser, 
                      desc: desc, 
                      required: required
                  };
              };
          };
      };
  };
  exports["argument"] = argument;
  exports["command"] = command;
  exports["commandWithArgs"] = commandWithArgs;
  exports["option"] = option;
  exports["optionDefault"] = optionDefault;
  exports["runAction"] = runAction;
})(PS["Pulp.Args"] = PS["Pulp.Args"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | Functions for getting data back out of an `Options` value.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Either = PS["Data.Either"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_String = PS["Data.String"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Data_Map = PS["Data.Map"];
  var Control_Monad_Except = PS["Control.Monad.Except"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_Args = PS["Pulp.Args"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Function = PS["Data.Function"];
  var Data_Show = PS["Data.Show"];
  var Data_List_Types = PS["Data.List.Types"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Bind = PS["Control.Bind"];        
  var internalError = function (msg) {
      return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Internal error in Pulp.Args.Get: " + (msg + ("\n" + "This is a bug. Please report it.\n"))));
  };
  var readForeign = function (dictIsForeign) {
      return function (name) {
          return function (thing) {
              var $4 = Control_Monad_Except.runExcept(Data_Foreign_Class.read(dictIsForeign)(thing));
              if ($4 instanceof Data_Either.Left) {
                  return internalError(Data_String.joinWith("\n")([ "Failed to read option: " + name, "The value was: " + Pulp_System_FFI.unsafeInspect(thing), "Data.Foreign.read failed: " + Data_Show.show(Data_List_Types.showNonEmptyList(Data_Foreign.showForeignError))($4.value0) ]));
              };
              if ($4 instanceof Data_Either.Right) {
                  return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)($4.value0);
              };
              throw new Error("Failed pattern match at Pulp.Args.Get line 72, column 3 - line 80, column 13: " + [ $4.constructor.name ]);
          };
      };
  };

  /**
 *  | Get an option out of the `Options` value. If the option has no default and
 *  | was not specified at the command line, the result will be `Nothing`. For
 *  | options which do have defaults, you probably want the primed version
 *  | instead, `getOption'`.
 */  
  var getOption = function (dictIsForeign) {
      return function (name) {
          return function (opts) {
              var $7 = Data_Map.lookup(Data_Ord.ordString)(name)(opts);
              if ($7 instanceof Data_Maybe.Just && $7.value0 instanceof Data_Maybe.Just) {
                  return Data_Functor.map(Control_Monad_Aff.functorAff)(Data_Maybe.Just.create)(readForeign(dictIsForeign)(name)($7.value0.value0));
              };
              if ($7 instanceof Data_Maybe.Just && $7.value0 instanceof Data_Maybe.Nothing) {
                  var msg = "Tried to read a flag as an option: " + name;
                  return internalError(msg);
              };
              if ($7 instanceof Data_Maybe.Nothing) {
                  return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Data_Maybe.Nothing.value);
              };
              throw new Error("Failed pattern match at Pulp.Args.Get line 29, column 3 - line 36, column 19: " + [ $7.constructor.name ]);
          };
      };
  };

  /**
 *  | Get an option which was declared with a default value, and therefore
 *  | should always have a value.
 */  
  var getOption$prime = function (dictIsForeign) {
      return function (name) {
          return function (opts) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(getOption(dictIsForeign)(name)(opts))(function (v) {
                  if (v instanceof Data_Maybe.Just) {
                      return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(v.value0);
                  };
                  if (v instanceof Data_Maybe.Nothing) {
                      var msg = "Missing default value for option: " + name;
                      return internalError(msg);
                  };
                  throw new Error("Failed pattern match at Pulp.Args.Get line 43, column 3 - line 48, column 27: " + [ v.constructor.name ]);
              });
          };
      };
  };

  /**
 *  | True if a given option exists in the `Options` map, false otherwise.
 */  
  var hasOption = function (name) {
      return function (opts) {
          var opt = getOption(Data_Foreign_Class.foreignIsForeign)(name)(opts);
          return Data_Functor.map(Control_Monad_Aff.functorAff)(Data_Maybe.isJust)(opt);
      };
  };

  /**
 *  | Get a flag out of the `Options` value. If it was specified at the command
 *  | line, the result is `true`, otherwise, `false`.
 */  
  var getFlag = function (name) {
      return function (opts) {
          var $14 = Data_Map.lookup(Data_Ord.ordString)(name)(opts);
          if ($14 instanceof Data_Maybe.Just && $14.value0 instanceof Data_Maybe.Just) {
              var msg = "Tried to read an option as a flag: " + name;
              return internalError(msg);
          };
          if ($14 instanceof Data_Maybe.Just && $14.value0 instanceof Data_Maybe.Nothing) {
              return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(true);
          };
          if ($14 instanceof Data_Maybe.Nothing) {
              return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(false);
          };
          throw new Error("Failed pattern match at Pulp.Args.Get line 54, column 3 - line 61, column 17: " + [ $14.constructor.name ]);
      };
  };
  exports["getFlag"] = getFlag;
  exports["getOption"] = getOption;
  exports["getOption'"] = getOption$prime;
  exports["hasOption"] = hasOption;
})(PS["Pulp.Args.Get"] = PS["Pulp.Args.Get"] || {});
(function(exports) {
  // module Pulp.Args.Help
  "use strict";

  exports.pad = function pad(n) {
    return new Array(n + 1).join(" ");
  };

  exports.wrap = function wrap(s) {
    return function(indent) {
      return function() {
        var cols = process.stdout.columns;
        return cols ? require("wordwrap")(indent, cols)(s).slice(indent) : s;
      };
    };
  };
})(PS["Pulp.Args.Help"] = PS["Pulp.Args.Help"] || {});
(function(exports) {
    "use strict";

  exports.handleCallbackImpl = function (left, right, f) {
    return function (err, value) {
      if (err) {
        f(left(err))();
      } else {
        f(right(value))();
      }
    };
  };
})(PS["Node.FS.Async"] = PS["Node.FS.Async"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Node.FS.Async"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_Eff_Unsafe = PS["Control.Monad.Eff.Unsafe"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Data_DateTime = PS["Data.DateTime"];
  var Data_Time_Duration = PS["Data.Time.Duration"];
  var Data_DateTime_Instant = PS["Data.DateTime.Instant"];
  var Data_Either = PS["Data.Either"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Nullable = PS["Data.Nullable"];
  var Node_Buffer = PS["Node.Buffer"];
  var Data_Int = PS["Data.Int"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_FS = PS["Node.FS"];
  var Node_FS_Stats = PS["Node.FS.Stats"];
  var Node_Path = PS["Node.Path"];
  var Node_FS_Perms = PS["Node.FS.Perms"];
  var Node_FS_Internal = PS["Node.FS.Internal"];
  var Data_Function = PS["Data.Function"];
  var Data_Show = PS["Data.Show"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Functor = PS["Data.Functor"];
  var Data_EuclideanRing = PS["Data.EuclideanRing"];
  var Control_Bind = PS["Control.Bind"];        
  var handleCallback = function (cb) {
      return $foreign.handleCallbackImpl(Data_Either.Left.create, Data_Either.Right.create, cb);
  };
  var fs = Node_FS_Internal.unsafeRequireFS;

  /**
 *  | Makes a new directory with the specified permissions.
 */  
  var mkdir$prime = function (file) {
      return function (perms) {
          return function (cb) {
              return Node_FS_Internal.mkEff(function (v) {
                  return fs.mkdir(file, Node_FS_Perms.permsToString(perms), handleCallback(cb));
              });
          };
      };
  };

  /**
 *  | Makes a new directory.
 */  
  var mkdir = Data_Function.flip(mkdir$prime)(Node_FS_Perms.mkPerms(Node_FS_Perms.all)(Node_FS_Perms.all)(Node_FS_Perms.all));

  /**
 *  | Reads the entire contents of a file returning the result as a raw buffer.
 */  
  var readFile = function (file) {
      return function (cb) {
          return Node_FS_Internal.mkEff(function (v) {
              return fs.readFile(file, {}, handleCallback(cb));
          });
      };
  };

  /**
 *  | Reads the entire contents of a text file with the specified encoding.
 */  
  var readTextFile = function (encoding) {
      return function (file) {
          return function (cb) {
              return Node_FS_Internal.mkEff(function (v) {
                  return fs.readFile(file, {
                      encoding: Data_Show.show(Node_Encoding.showEncoding)(encoding)
                  }, handleCallback(cb));
              });
          };
      };
  };

  /**
 *  | Renames a file.
 */  
  var rename = function (oldFile) {
      return function (newFile) {
          return function (cb) {
              return Node_FS_Internal.mkEff(function (v) {
                  return fs.rename(oldFile, newFile, handleCallback(cb));
              });
          };
      };
  };

  /**
 *  | Gets file statistics.
 */  
  var stat = function (file) {
      return function (cb) {
          return Node_FS_Internal.mkEff(function (v) {
              return fs.stat(file, handleCallback(function ($58) {
                  return cb(Data_Functor.map(Data_Either.functorEither)(Node_FS_Stats.Stats.create)($58));
              }));
          });
      };
  };

  /**
 *  | Deletes a file.
 */  
  var unlink = function (file) {
      return function (cb) {
          return Node_FS_Internal.mkEff(function (v) {
              return fs.unlink(file, handleCallback(cb));
          });
      };
  };

  /**
 *  | Writes a buffer to a file.
 */  
  var writeFile = function (file) {
      return function (buff) {
          return function (cb) {
              return Node_FS_Internal.mkEff(function (v) {
                  return fs.writeFile(file, buff, {}, handleCallback(cb));
              });
          };
      };
  };

  /**
 *  | Writes text to a file using the specified encoding.
 */  
  var writeTextFile = function (encoding) {
      return function (file) {
          return function (buff) {
              return function (cb) {
                  return Node_FS_Internal.mkEff(function (v) {
                      return fs.writeFile(file, buff, {
                          encoding: Data_Show.show(Node_Encoding.showEncoding)(encoding)
                      }, handleCallback(cb));
                  });
              };
          };
      };
  };

  /**
 *  | Write to a file asynchronously. See the [Node Documentation](https://nodejs.org/api/fs.html#fs_fs_write_fd_buffer_offset_length_position_callback)
 *  | for details.
 */  
  var fdWrite = function (fd) {
      return function (buff) {
          return function (off) {
              return function (len) {
                  return function (pos) {
                      return function (cb) {
                          return Node_FS_Internal.mkEff(function (v) {
                              return fs.write(fd, buff, off, len, Data_Nullable.toNullable(pos), handleCallback(cb));
                          });
                      };
                  };
              };
          };
      };
  };

  /**
 *  | Close a file asynchronously. See the [Node Documentation](https://nodejs.org/api/fs.html#fs_fs_close_fd_callback)
 *  | for details.
 */  
  var fdClose = function (fd) {
      return function (cb) {
          return Node_FS_Internal.mkEff(function (v) {
              return fs.close(fd, handleCallback(cb));
          });
      };
  };

  /**
 *  | Convenience function to append the whole buffer to the current
 *  | file position.
 */  
  var fdAppend = function (fd) {
      return function (buff) {
          return function (cb) {
              return function __do() {
                  var v = Node_Buffer.size(buff)();
                  return fdWrite(fd)(buff)(0)(v)(Data_Maybe.Nothing.value)(cb)();
              };
          };
      };
  };

  /**
 *  | Check if the path exists.
 */  
  var exists = function (file) {
      return function (cb) {
          return Node_FS_Internal.mkEff(function (v) {
              return fs.exists(file, function (b) {
                  return Control_Monad_Eff.runPure(Control_Monad_Eff_Unsafe.unsafeCoerceEff(cb(b)));
              });
          });
      };
  };

  /**
 *  | Changes the permissions of a file.
 */  
  var chmod = function (file) {
      return function (perms) {
          return function (cb) {
              return Node_FS_Internal.mkEff(function (v) {
                  return fs.chmod(file, Node_FS_Perms.permsToString(perms), handleCallback(cb));
              });
          };
      };
  };
  exports["chmod"] = chmod;
  exports["exists"] = exists;
  exports["fdAppend"] = fdAppend;
  exports["fdClose"] = fdClose;
  exports["fdWrite"] = fdWrite;
  exports["mkdir"] = mkdir;
  exports["readFile"] = readFile;
  exports["readTextFile"] = readTextFile;
  exports["rename"] = rename;
  exports["stat"] = stat;
  exports["unlink"] = unlink;
  exports["writeFile"] = writeFile;
  exports["writeTextFile"] = writeTextFile;
})(PS["Node.FS.Async"] = PS["Node.FS.Async"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_DateTime = PS["Data.DateTime"];
  var Data_Either = PS["Data.Either"];
  var Data_Maybe = PS["Data.Maybe"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_FS = PS["Node.FS"];
  var Node_FS_Async = PS["Node.FS.Async"];
  var Node_FS_Perms = PS["Node.FS.Perms"];
  var Node_FS_Stats = PS["Node.FS.Stats"];
  var Node_Path = PS["Node.Path"];
  var Data_Function = PS["Data.Function"];        
  var toAff = function (p) {
      return Control_Monad_Aff.makeAff(function (e) {
          return function (a) {
              return p(Data_Either.either(e)(a));
          };
      });
  };
  var toAff1 = function (f) {
      return function (a) {
          return toAff(f(a));
      };
  };

  /**
 *  |
 *  | Deletes a file.
 *  |
 */  
  var unlink = toAff1(Node_FS_Async.unlink);
  var toAff2 = function (f) {
      return function (a) {
          return function (b) {
              return toAff(f(a)(b));
          };
      };
  };                                              
  var toAff3 = function (f) {
      return function (a) {
          return function (b) {
              return function (c) {
                  return toAff(f(a)(b)(c));
              };
          };
      };
  };                                        

  /**
 *  |
 *  | Writes text to a file using the specified encoding.
 *  |
 */  
  var writeTextFile = toAff3(Node_FS_Async.writeTextFile);

  /**
 *  |
 *  | Gets file statistics.
 *  |
 */  
  var stat = toAff1(Node_FS_Async.stat);  

  /**
 *  |
 *  | Rename a file.
 *  |
 */  
  var rename = toAff2(Node_FS_Async.rename);  

  /**
 *  |
 *  | Reads the entire contents of a text file with the specified encoding.
 *  |
 */  
  var readTextFile = toAff2(Node_FS_Async.readTextFile);

  /**
 *  |
 *  | Makes a new directory.
 *  |
 */  
  var mkdir = toAff1(Node_FS_Async.mkdir);  

  /**
 *  | Close a file asynchronously. See the [Node Documentation](https://nodejs.org/api/fs.html#fs_fs_close_fd_callback)
 *  | for details.
 */  
  var fdClose = toAff1(Node_FS_Async.fdClose);

  /**
 *  | Convenience function to append the whole buffer to the current
 *  | file position.
 */  
  var fdAppend = toAff2(Node_FS_Async.fdAppend);

  /**
 *  |
 *  | Check to see if a file exists.
 *  |
 */  
  var exists = function (file) {
      return Control_Monad_Aff.makeAff(function (v) {
          return function (a) {
              return Node_FS_Async.exists(file)(a);
          };
      });
  };                                      

  /**
 *  |
 *  | Changes the permissions of a file.
 *  |
 */  
  var chmod = toAff2(Node_FS_Async.chmod);
  exports["chmod"] = chmod;
  exports["exists"] = exists;
  exports["fdAppend"] = fdAppend;
  exports["fdClose"] = fdClose;
  exports["mkdir"] = mkdir;
  exports["readTextFile"] = readTextFile;
  exports["rename"] = rename;
  exports["stat"] = stat;
  exports["unlink"] = unlink;
  exports["writeTextFile"] = writeTextFile;
})(PS["Node.FS.Aff"] = PS["Node.FS.Aff"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Trans_Class = PS["Control.Monad.Trans.Class"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_State_Class = PS["Control.Monad.State.Class"];
  var Control_Alt = PS["Control.Alt"];
  var Data_Array = PS["Data.Array"];
  var Data_Either = PS["Data.Either"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_List = PS["Data.List"];
  var Data_String = PS["Data.String"];
  var Data_Map = PS["Data.Map"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Foreign = PS["Data.Foreign"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Text_Parsing_Parser_Combinators = PS["Text.Parsing.Parser.Combinators"];
  var Text_Parsing_Parser_Token = PS["Text.Parsing.Parser.Token"];
  var Text_Parsing_Parser_Pos = PS["Text.Parsing.Parser.Pos"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Data_Function = PS["Data.Function"];
  var Data_Eq = PS["Data.Eq"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Show = PS["Data.Show"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Unfoldable = PS["Data.Unfoldable"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Ord = PS["Data.Ord"];        

  /**
 *  | A version of Text.Parsing.Parser.Token.when which lies about the position,
 *  | since we don't care about it here.
 */  
  var when = function (dictMonad) {
      return Text_Parsing_Parser_Token.when(dictMonad)(Data_Function["const"](Text_Parsing_Parser_Pos.initialPos));
  };

  /**
 *  | A version of Text.Parsing.Parser.Token.token which lies about the position,
 *  | since we don't care about it here.
 */  
  var token = function (dictMonad) {
      return Text_Parsing_Parser_Token.token(dictMonad)(Data_Function["const"](Text_Parsing_Parser_Pos.initialPos));
  };
  var matchOpt = function (o) {
      return function (key) {
          return Data_Foldable.elem(Data_Foldable.foldableArray)(Data_Eq.eqString)(key)(o.match);
      };
  };

  /**
 *  halt err = ParserT $ \s ->
 *    pure { consumed: true, input: s, result: Left (strMsg err) }
 */  
  var matchNamed = function (dictEq) {
      return function (o) {
          return function (key) {
              return Data_Eq.eq(dictEq)(o.name)(key);
          };
      };
  };

  /**
 *  | A version of Text.Parsing.Parser.Token.match which lies about the position,
 *  | since we don't care about it here.
 */  
  var match = function (dictMonad) {
      return function (dictEq) {
          return Text_Parsing_Parser_Token.match(dictMonad)(dictEq)(Data_Function["const"](Text_Parsing_Parser_Pos.initialPos));
      };
  };
  var lookup = function (dictMonad) {
      return function (dictEq) {
          return function (dictShow) {
              return function (matches) {
                  return function (table) {
                      return Control_Bind.bind(Text_Parsing_Parser.bindParserT(dictMonad))(token(dictMonad))(function (v) {
                          var $26 = Data_Foldable.find(Data_Foldable.foldableArray)(function (i) {
                              return matches(i)(v);
                          })(table);
                          if ($26 instanceof Data_Maybe.Just) {
                              return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(dictMonad))(new Data_Tuple.Tuple(v, $26.value0));
                          };
                          if ($26 instanceof Data_Maybe.Nothing) {
                              return Text_Parsing_Parser.fail(dictMonad)("Unknown command: " + Data_Show.show(dictShow)(v));
                          };
                          throw new Error("Failed pattern match at Pulp.Args.Parser line 59, column 3 - line 61, column 55: " + [ $26.constructor.name ]);
                      });
                  };
              };
          };
      };
  };
  var lookupCmd = lookup(Control_Monad_Aff.monadAff)(Data_Eq.eqString)(Data_Show.showString)(matchNamed(Data_Eq.eqString));
  var lookupOpt = lookup(Control_Monad_Aff.monadAff)(Data_Eq.eqString)(Data_Show.showString)(matchOpt);
  var opt = function (opts) {
      return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(lookupOpt(opts))(function (v) {
          return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(v.value1.parser.parser(v.value0))(function (v1) {
              return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(Data_Map.singleton(v.value1.name)(v1));
          });
      });
  };
  var halt = function (err) {
      return Control_Monad_Trans_Class.lift(Text_Parsing_Parser.monadTransParserT)(Control_Monad_Aff.monadAff)(Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error(err)));
  };
  var extractDefault = function (o) {
      if (o.defaultValue instanceof Data_Maybe.Just) {
          return Data_Map.singleton(o.name)(new Data_Maybe.Just(Data_Foreign.toForeign(o.defaultValue.value0)));
      };
      if (o.defaultValue instanceof Data_Maybe.Nothing) {
          return Data_Map.empty;
      };
      throw new Error("Failed pattern match at Pulp.Args.Parser line 94, column 3 - line 98, column 16: " + [ o.defaultValue.constructor.name ]);
  };

  /**
 *  See also https://github.com/purescript-contrib/purescript-parsing/issues/25
 */  
  var eof = function (dictMonad) {
      return function (msg) {
          return Control_Bind.bind(Text_Parsing_Parser.bindParserT(dictMonad))(Control_Monad_State_Class.get(Text_Parsing_Parser.monadStateParserT(dictMonad)))(function (v) {
              return Control_Applicative.unless(Text_Parsing_Parser.applicativeParserT(dictMonad))(Data_List["null"](v.value0))(Text_Parsing_Parser.fail(dictMonad)(msg(v.value0)));
          });
      };
  };
  var cmd = function (cmds) {
      return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Text_Parsing_Parser_Combinators.withErrorMessage(Control_Monad_Aff.monadAff)(lookupCmd(cmds))("command"))(function (v) {
          return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(v.value1);
      });
  };
  var arg = function (a) {
      if (a.required) {
          return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Control_Alt.alt(Text_Parsing_Parser.altParserT(Control_Monad_Aff.monadAff))(token(Control_Monad_Aff.monadAff))(Text_Parsing_Parser.fail(Control_Monad_Aff.monadAff)("Required argument \"" + (a.name + "\" missing."))))(function (v) {
              return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(a.parser(v))(function (v1) {
                  return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(Data_Map.singleton(a.name)(new Data_Maybe.Just(v1)));
              });
          });
      };
      return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Control_Alt.alt(Text_Parsing_Parser.altParserT(Control_Monad_Aff.monadAff))(Text_Parsing_Parser_Combinators["try"](Control_Monad_Aff.monadAff)(Data_Functor.map(Text_Parsing_Parser.functorParserT(Control_Monad_Aff.functorAff))(Data_Maybe.Just.create)(Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(token(Control_Monad_Aff.monadAff))(a.parser))))(Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(Data_Maybe.Nothing.value)))(function (v) {
          return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(Data_Maybe.maybe(Data_Map.empty)(function ($53) {
              return Data_Map.singleton(a.name)(Data_Maybe.Just.create($53));
          })(v));
      });
  };
  var parseArgv = function (globals) {
      return function (commands) {
        
          /**
         *  match a single "-h" or "--help"
         */  
          var unrecognised = function ($54) {
              return (function (v) {
                  return "Unrecognised arguments: " + v;
              })(Data_String.joinWith(", ")(Data_List.toUnfoldable(Data_Unfoldable.unfoldableArray)($54)));
          };
          var matchHelp = Data_Functor["void"](Text_Parsing_Parser.functorParserT(Control_Monad_Aff.functorAff))(when(Control_Monad_Aff.monadAff)(function (v) {
              return Data_Foldable.elem(Data_Foldable.foldableArray)(Data_Eq.eqString)(v)([ "-h", "--help" ]);
          }));
          var helpForCommand = function (command) {
              return Control_Apply.applySecond(Text_Parsing_Parser.applyParserT(Control_Monad_Aff.monadAff))(matchHelp)(Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(new Data_Either.Left(command)));
          };
          var defs = Data_Functor.map(Data_Functor.functorArray)(extractDefault);
          var globalDefaults = function (opts) {
              return Data_Map.unions(Data_Ord.ordString)(Data_Foldable.foldableArray)(Data_Semigroup.append(Data_Semigroup.semigroupArray)(opts)(defs(globals)));
          };
          var normalCommand = function (globalOpts) {
              return function (command) {
                  return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Data_Traversable.traverse(Data_Traversable.traversableArray)(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(arg)(command["arguments"]))(function (v) {
                      return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Data_Array.many(Text_Parsing_Parser.alternativeParserT(Control_Monad_Aff.monadAff))(Text_Parsing_Parser.lazyParserT)(Text_Parsing_Parser_Combinators["try"](Control_Monad_Aff.monadAff)(opt(command.options))))(function (v1) {
                          return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Text_Parsing_Parser_Combinators.optionMaybe(Control_Monad_Aff.monadAff)(match(Control_Monad_Aff.monadAff)(Data_Eq.eqString)("--")))(function (v2) {
                              return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Data_Maybe.maybe(Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))([  ]))(Data_Function["const"](Data_Array.many(Text_Parsing_Parser.alternativeParserT(Control_Monad_Aff.monadAff))(Text_Parsing_Parser.lazyParserT)(token(Control_Monad_Aff.monadAff))))(v2))(function (v3) {
                                  return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(eof(Control_Monad_Aff.monadAff)(unrecognised))(function () {
                                      return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(new Data_Either.Right({
                                          globalOpts: globalOpts, 
                                          command: command, 
                                          commandOpts: Data_Map.unions(Data_Ord.ordString)(Data_Foldable.foldableArray)(Data_Semigroup.append(Data_Semigroup.semigroupArray)(v1)(defs(command.options))), 
                                          commandArgs: Data_Map.unions(Data_Ord.ordString)(Data_Foldable.foldableArray)(v), 
                                          remainder: v3
                                      }));
                                  });
                              });
                          });
                      });
                  });
              };
          };
          return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Data_Functor.map(Text_Parsing_Parser.functorParserT(Control_Monad_Aff.functorAff))(globalDefaults)(Data_Array.many(Text_Parsing_Parser.alternativeParserT(Control_Monad_Aff.monadAff))(Text_Parsing_Parser.lazyParserT)(Text_Parsing_Parser_Combinators["try"](Control_Monad_Aff.monadAff)(opt(globals)))))(function (v) {
              return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(cmd(commands))(function (v1) {
                  return Control_Alt.alt(Text_Parsing_Parser.altParserT(Control_Monad_Aff.monadAff))(helpForCommand(v1))(normalCommand(v)(v1));
              });
          });
      };
  };
  var parse = function (globals) {
      return function (commands) {
          return function (s) {
              return Text_Parsing_Parser.runParserT(Control_Monad_Aff.monadAff)(Data_List.fromFoldable(Data_Foldable.foldableArray)(s))(parseArgv(globals)(commands));
          };
      };
  };
  exports["arg"] = arg;
  exports["cmd"] = cmd;
  exports["eof"] = eof;
  exports["extractDefault"] = extractDefault;
  exports["halt"] = halt;
  exports["lookup"] = lookup;
  exports["lookupCmd"] = lookupCmd;
  exports["lookupOpt"] = lookupOpt;
  exports["match"] = match;
  exports["matchNamed"] = matchNamed;
  exports["matchOpt"] = matchOpt;
  exports["opt"] = opt;
  exports["parse"] = parse;
  exports["parseArgv"] = parseArgv;
  exports["token"] = token;
  exports["when"] = when;
})(PS["Pulp.Args.Parser"] = PS["Pulp.Args.Parser"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | Defines a VersionBump type and associated functions.
 */  
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Either = PS["Data.Either"];
  var Data_String = PS["Data.String"];
  var Data_Version = PS["Data.Version"];
  var Data_Show = PS["Data.Show"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Function = PS["Data.Function"];        
  var Major = (function () {
      function Major() {

      };
      Major.value = new Major();
      return Major;
  })();
  var Minor = (function () {
      function Minor() {

      };
      Minor.value = new Minor();
      return Minor;
  })();
  var Patch = (function () {
      function Patch() {

      };
      Patch.value = new Patch();
      return Patch;
  })();
  var ToExact = (function () {
      function ToExact(value0) {
          this.value0 = value0;
      };
      ToExact.create = function (value0) {
          return new ToExact(value0);
      };
      return ToExact;
  })();
  var parseBump = function (str) {
      var $3 = Data_String.toLower(str);
      if ($3 === "major") {
          return new Data_Maybe.Just(Major.value);
      };
      if ($3 === "minor") {
          return new Data_Maybe.Just(Minor.value);
      };
      if ($3 === "patch") {
          return new Data_Maybe.Just(Patch.value);
      };
      return Data_Functor.map(Data_Maybe.functorMaybe)(ToExact.create)(Data_Either.either(Data_Function["const"](Data_Maybe.Nothing.value))(Data_Maybe.Just.create)(Data_Version.parseVersion(str)));
  };
  var applyBump = function (b) {
      if (b instanceof Major) {
          return Data_Version.bumpMajor;
      };
      if (b instanceof Minor) {
          return Data_Version.bumpMinor;
      };
      if (b instanceof Patch) {
          return Data_Version.bumpPatch;
      };
      if (b instanceof ToExact) {
          return Data_Function["const"](b.value0);
      };
      throw new Error("Failed pattern match at Pulp.VersionBump line 28, column 15 - line 32, column 22: " + [ b.constructor.name ]);
  };
  exports["Major"] = Major;
  exports["Minor"] = Minor;
  exports["Patch"] = Patch;
  exports["ToExact"] = ToExact;
  exports["applyBump"] = applyBump;
  exports["parseBump"] = parseBump;
})(PS["Pulp.VersionBump"] = PS["Pulp.VersionBump"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Alt = PS["Control.Alt"];
  var Control_Monad_Trans_Class = PS["Control.Monad.Trans.Class"];
  var Data_String = PS["Data.String"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Int = PS["Data.Int"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Foreign = PS["Data.Foreign"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Node_FS_Stats = PS["Node.FS.Stats"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_Path = PS["Node.Path"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Parser = PS["Pulp.Args.Parser"];
  var Pulp_VersionBump = PS["Pulp.VersionBump"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Bind = PS["Control.Bind"];
  var Data_Function = PS["Data.Function"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];        

  /**
 *  TODO: this is gross; we end up parsing the version twice. Probably should
 *  fix this by parameterising OptionParsers and ArgumentParsers based on the
 *  type of the thing they parse.
 */  
  var versionBump = function (arg) {
      var $6 = Pulp_VersionBump.parseBump(arg);
      if ($6 instanceof Data_Maybe.Just) {
          return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(Data_Foreign.toForeign(arg));
      };
      if ($6 instanceof Data_Maybe.Nothing) {
          return Text_Parsing_Parser.fail(Control_Monad_Aff.monadAff)("Not a valid version bump. Must be: 'major', 'minor', 'patch', " + "or a version.");
      };
      throw new Error("Failed pattern match at Pulp.Args.Types line 103, column 3 - line 108, column 31: " + [ $6.constructor.name ]);
  };
  var require = function (pred) {
      return function (typ) {
          return function (path) {
              return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Control_Alt.alt(Text_Parsing_Parser.altParserT(Control_Monad_Aff.monadAff))(Control_Monad_Trans_Class.lift(Text_Parsing_Parser.monadTransParserT)(Control_Monad_Aff.monadAff)(Node_FS_Aff.stat(path)))(Pulp_Args_Parser.halt(typ + (" '" + (path + "' not found.")))))(function (v) {
                  return Control_Applicative.unless(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(pred(v))(Pulp_Args_Parser.halt("Path '" + (path + ("' is not a " + (typ + ".")))));
              });
          };
      };
  };
  var requireDirectory = require(Node_FS_Stats.isDirectory)("Directory");
  var requireFile = require(Node_FS_Stats.isFile)("File");
  var flag = {
      name: Data_Maybe.Nothing.value, 
      parser: function (v) {
          return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(Data_Maybe.Nothing.value);
      }
  };
  var argErr = function (arg) {
      return function (msg) {
          return Pulp_Args_Parser.halt("Argument " + (arg + (": " + msg)));
      };
  };
  var directories = {
      name: new Data_Maybe.Just("<dir:dir:...>"), 
      parser: function (arg) {
          return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Control_Alt.alt(Text_Parsing_Parser.altParserT(Control_Monad_Aff.monadAff))(Pulp_Args_Parser.token(Control_Monad_Aff.monadAff))(argErr(arg)("Needs a directory argument.")))(function (v) {
              var paths$prime = Data_String.split(Node_Path.delimiter)(v);
              return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Data_Foldable.for_(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(Data_Foldable.foldableArray)(paths$prime)(requireDirectory))(function () {
                  return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(new Data_Maybe.Just(Data_Foreign.toForeign(paths$prime)));
              });
          });
      }
  };
  var directory = {
      name: new Data_Maybe.Just("<dir>"), 
      parser: function (arg) {
          return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Control_Alt.alt(Text_Parsing_Parser.altParserT(Control_Monad_Aff.monadAff))(Pulp_Args_Parser.token(Control_Monad_Aff.monadAff))(argErr(arg)("Needs a directory argument.")))(function (v) {
              return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(requireDirectory(v))(function () {
                  return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(new Data_Maybe.Just(Data_Foreign.toForeign(v)));
              });
          });
      }
  };
  var file = {
      name: new Data_Maybe.Just("<file>"), 
      parser: function (arg) {
          return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Control_Alt.alt(Text_Parsing_Parser.altParserT(Control_Monad_Aff.monadAff))(Pulp_Args_Parser.token(Control_Monad_Aff.monadAff))(argErr(arg)("Needs a file argument.")))(function (v) {
              return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(requireFile(v))(function () {
                  return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(new Data_Maybe.Just(Data_Foreign.toForeign(v)));
              });
          });
      }
  };
  var $$int = {
      name: new Data_Maybe.Just("<int>"), 
      parser: function (arg) {
          var err = argErr(arg)("Needs an int argument.");
          return Control_Bind.bind(Text_Parsing_Parser.bindParserT(Control_Monad_Aff.monadAff))(Data_Functor.map(Text_Parsing_Parser.functorParserT(Control_Monad_Aff.functorAff))(Data_Int.fromString)(Control_Alt.alt(Text_Parsing_Parser.altParserT(Control_Monad_Aff.monadAff))(Pulp_Args_Parser.token(Control_Monad_Aff.monadAff))(err)))(function (v) {
              if (v instanceof Data_Maybe.Just) {
                  return Control_Applicative.pure(Text_Parsing_Parser.applicativeParserT(Control_Monad_Aff.monadAff))(new Data_Maybe.Just(Data_Foreign.toForeign(v.value0)));
              };
              if (v instanceof Data_Maybe.Nothing) {
                  return err;
              };
              throw new Error("Failed pattern match at Pulp.Args.Types line 53, column 5 - line 55, column 21: " + [ v.constructor.name ]);
          });
      }
  };
  var string = {
      name: new Data_Maybe.Just("<string>"), 
      parser: function (arg) {
          return Data_Functor.map(Text_Parsing_Parser.functorParserT(Control_Monad_Aff.functorAff))(function ($16) {
              return Data_Maybe.Just.create(Data_Foreign.toForeign($16));
          })(Control_Alt.alt(Text_Parsing_Parser.altParserT(Control_Monad_Aff.monadAff))(Pulp_Args_Parser.token(Control_Monad_Aff.monadAff))(argErr(arg)("Needs a string argument.")));
      }
  };
  exports["directories"] = directories;
  exports["directory"] = directory;
  exports["file"] = file;
  exports["flag"] = flag;
  exports["int"] = $$int;
  exports["string"] = string;
  exports["versionBump"] = versionBump;
})(PS["Pulp.Args.Types"] = PS["Pulp.Args.Types"] || {});
(function(exports) {
  // module Pulp.System.Stream
  "use strict";

  exports["concatStreamToBuffer'"] = function concatStream$prime(stream, callback) {
    var concat = require("concat-stream");

    var onSuccess = function(buf) {
      callback(null, buf);
    };

    var onError = function(err) {
      callback(err, null);
    };

    stream.on('error', onError);
    stream.pipe(concat(onSuccess));
  };

  exports.createGzip = require("zlib").createGzip;
})(PS["Pulp.System.Stream"] = PS["Pulp.System.Stream"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Pulp.System.Stream"];
  var Prelude = PS["Prelude"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Node_Stream = PS["Node.Stream"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_Encoding = PS["Node.Encoding"];
  var Unsafe_Coerce = PS["Unsafe.Coerce"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Function = PS["Data.Function"];
  var Control_Bind = PS["Control.Bind"];        
  var write = function (stream) {
      return function (str) {
          return Control_Monad_Aff.makeAff(function (v) {
              return function (done) {
                  return Data_Functor["void"](Control_Monad_Eff.functorEff)(Node_Stream.writeString(stream)(Node_Encoding.UTF8.value)(str)(done(Data_Unit.unit)));
              };
          });
      };
  };                                      
  var end = function (stream) {
      return Control_Monad_Aff.makeAff(function (v) {
          return function (done) {
              return Data_Functor["void"](Control_Monad_Eff.functorEff)(Node_Stream.end(stream)(done(Data_Unit.unit)));
          };
      });
  };
  var concatStreamToBuffer = function (stream) {
      return Pulp_System_FFI.runNode(Data_Function_Uncurried.runFn2($foreign["concatStreamToBuffer'"])(stream));
  };
  var concatStream = function (stream) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(concatStreamToBuffer(stream))(function (v) {
          return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Buffer.toString(Node_Encoding.UTF8.value)(v));
      });
  };
  exports["concatStream"] = concatStream;
  exports["concatStreamToBuffer"] = concatStreamToBuffer;
  exports["end"] = end;
  exports["write"] = write;
  exports["createGzip"] = $foreign.createGzip;
})(PS["Pulp.System.Stream"] = PS["Pulp.System.Stream"] || {});
(function(exports) {
  // module Pulp.System.SupportsColor
  "use strict";

  // The MIT License (MIT)
  // 
  // Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)
  // 
  // Permission is hereby granted, free of charge, to any person obtaining a copy
  // of this software and associated documentation files (the "Software"), to deal
  // in the Software without restriction, including without limitation the rights
  // to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  // copies of the Software, and to permit persons to whom the Software is
  // furnished to do so, subject to the following conditions:
  // 
  // The above copyright notice and this permission notice shall be included in
  // all copies or substantial portions of the Software.
  // 
  // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  // IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  // FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  // AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  // LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  // OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  // THE SOFTWARE.

  exports.supportLevel = (function() {
    if (process.stderr && !process.stderr.isTTY) {
      return 0;
    }

    if (process.platform === 'win32') {
      return 1;
    }

    if ('COLORTERM' in process.env) {
      return 1;
    }

    if (process.env.TERM === 'dumb') {
      return 0;
    }

    if (/^xterm-256(?:color)?/.test(process.env.TERM)) {
      return 2;
    }

    if (/^screen|^xterm|^vt100|color|ansi|cygwin|linux/i.test(process.env.TERM)) {
      return 1;
    }

    return 0;
  })();
})(PS["Pulp.System.SupportsColor"] = PS["Pulp.System.SupportsColor"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Pulp.System.SupportsColor"];
  var Prelude = PS["Prelude"];
  var Data_Ord = PS["Data.Ord"];        
  var hasBasic = $foreign.supportLevel >= 1;
  exports["hasBasic"] = hasBasic;
})(PS["Pulp.System.SupportsColor"] = PS["Pulp.System.SupportsColor"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Ansi_Codes = PS["Ansi.Codes"];
  var Ansi_Output = PS["Ansi.Output"];
  var Node_Process = PS["Node.Process"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Stream = PS["Pulp.System.Stream"];
  var Pulp_System_SupportsColor = PS["Pulp.System.SupportsColor"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Data_Function = PS["Data.Function"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Bind = PS["Control.Bind"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Functor = PS["Data.Functor"];        

  /**
 *  | An outputter which doesn't ever output anything.
 */  
  var nullOutputter = (function () {
      var dud = Data_Function["const"](Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Data_Unit.unit));
      return {
          log: dud, 
          err: dud, 
          write: dud, 
          bolded: dud, 
          monochrome: false
      };
  })();
  var monochromeOutputter = (function () {
      var monobullet = function (text) {
          return Pulp_System_Stream.write(Node_Process.stderr)("* " + (text + "\n"));
      };
      return {
          log: monobullet, 
          err: monobullet, 
          write: Pulp_System_Stream.write(Node_Process.stderr), 
          bolded: Pulp_System_Stream.write(Node_Process.stderr), 
          monochrome: true
      };
  })();
  var bullet = function (stream) {
      return function (color) {
          return function (text) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Ansi_Output.withGraphics(Control_Monad_Aff.monadAff)(Pulp_System_Stream.write(stream))(Ansi_Output.foreground(color))("* "))(function () {
                  return Pulp_System_Stream.write(stream)(text + "\n");
              });
          };
      };
  };
  var ansiOutputter = {
      log: bullet(Node_Process.stderr)(Ansi_Codes.Green.value), 
      err: bullet(Node_Process.stderr)(Ansi_Codes.Red.value), 
      write: Pulp_System_Stream.write(Node_Process.stderr), 
      bolded: Ansi_Output.withGraphics(Control_Monad_Aff.monadAff)(Pulp_System_Stream.write(Node_Process.stderr))(Ansi_Output.bold), 
      monochrome: false
  };

  /**
 *  | Get an outputter. The argument represents "monochrome"; if true is
 *  | supplied, the returned logger will never use color. Otherwise, whether or
 *  | not colour is used depends on the "supports-color" module. Note that the
 *  | `monochrome` attribute of the returned outputter might not necessarily
 *  | be the same as the argument supplied.
 */  
  var makeOutputter = function (monochrome) {
      var $1 = !monochrome && Pulp_System_SupportsColor.hasBasic;
      if ($1) {
          return ansiOutputter;
      };
      if (!$1) {
          return monochromeOutputter;
      };
      throw new Error("Failed pattern match at Pulp.Outputter line 42, column 3 - line 44, column 29: " + [ $1.constructor.name ]);
  };

  /**
 *  | Get an outputter, with monochrome based on the command line arguments.
 */  
  var getOutputter = function (args) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("_silenced")(args.commandOpts))(function (v) {
          if (v) {
              return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(nullOutputter);
          };
          if (!v) {
              return Data_Functor.map(Control_Monad_Aff.functorAff)(makeOutputter)(Pulp_Args_Get.getFlag("monochrome")(args.globalOpts));
          };
          throw new Error("Failed pattern match at Pulp.Outputter line 31, column 3 - line 33, column 64: " + [ v.constructor.name ]);
      });
  };
  exports["getOutputter"] = getOutputter;
  exports["makeOutputter"] = makeOutputter;
})(PS["Pulp.Outputter"] = PS["Pulp.Outputter"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Pulp.Args.Help"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Except = PS["Control.Monad.Except"];
  var Data_Either = PS["Data.Either"];
  var Data_Array = PS["Data.Array"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_StrMap = PS["Data.StrMap"];
  var Data_String = PS["Data.String"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Node_Process = PS["Node.Process"];
  var Node_Path = PS["Node.Path"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Types = PS["Pulp.Args.Types"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Partial_Unsafe = PS["Partial.Unsafe"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Function = PS["Data.Function"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Ring = PS["Data.Ring"];
  var Control_Bind = PS["Control.Bind"];
  var Data_Semiring = PS["Data.Semiring"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Show = PS["Data.Show"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];        
  var prepareCmds = (function () {
      var foldCmds = function (n) {
          return Data_StrMap.insert(n.name)(n.desc);
      };
      return Data_Foldable.foldr(Data_Foldable.foldableArray)(foldCmds)(Data_StrMap.empty);
  })();
  var prepareArguments = (function () {
      var formatKey = function (arg) {
          return Data_String.toUpper(arg.name);
      };
      var foldOpts = function (arg) {
          return Data_StrMap.insert(formatKey(arg))(arg.desc);
      };
      return Data_Foldable.foldr(Data_Foldable.foldableArray)(foldOpts)(Data_StrMap.empty);
  })();
  var helpOpt = Pulp_Args.option("help")([ "--help", "-h" ])(Pulp_Args_Types.flag)("Show this help message.");
  var getCommandName = Data_Functor.map(Control_Monad_Eff.functorEff)(function ($26) {
      return Data_Maybe.maybe("pulp")(function ($27) {
          return (function (v) {
              return v.name;
          })(Node_Path.parse($27));
      })((function (v) {
          return Data_Array.index(v)(1);
      })($26));
  })(Node_Process.argv);
  var formatTable = function (table) {
      var headers = Data_Array.sort(Data_Ord.ordString)(Data_StrMap.keys(table));
      var longest = Data_Maybe.fromMaybe(0)(Data_Foldable.maximum(Data_Ord.ordInt)(Data_Foldable.foldableArray)(Data_Functor.mapFlipped(Data_Functor.functorArray)(headers)(Data_String.length)));
      var formatEntry = function (key) {
          return Partial_Unsafe.unsafePartial(function (dictPartial) {
              return (function (entry) {
                  var padding = longest - Data_String.length(key);
                  return function __do() {
                      var v = $foreign.wrap(entry)(longest + 4 | 0)();
                      return "  " + (key + ($foreign.pad(padding + 2 | 0) + (v + "\n")));
                  };
              })(Data_Maybe.fromJust(dictPartial)(Data_StrMap.lookup(key)(table)));
          });
      };
      return function __do() {
          var v = Data_Traversable.sequence(Data_Traversable.traversableArray)(Control_Monad_Eff.applicativeEff)(Data_Functor.mapFlipped(Data_Functor.functorArray)(headers)(formatEntry))();
          return Data_String.joinWith("")(v);
      };
  };
  var formatPassThrough = function (mdesc) {
      var desc = Data_Maybe.fromMaybe("Passthrough options are ignored.")(mdesc);
      return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)($foreign.wrap("  " + desc)(2));
  };
  var formatCmds = function ($28) {
      return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(formatTable(prepareCmds($28)));
  };
  var formatArguments = function ($29) {
      return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(formatTable(prepareArguments($29)));
  };
  var describeOpt = function (opt) {
      var tryDefault = function (def) {
          var $10 = Control_Monad_Except.runExcept(Data_Foreign_Class.read(Data_Foreign_Class.stringIsForeign)(def));
          if ($10 instanceof Data_Either.Right) {
              return new Data_Maybe.Just(Data_Show.show(Data_Show.showString)($10.value0));
          };
          if ($10 instanceof Data_Either.Left) {
              var $12 = Control_Monad_Except.runExcept(Data_Foreign_Class.read(Data_Foreign_Class.intIsForeign)(def));
              if ($12 instanceof Data_Either.Right) {
                  return new Data_Maybe.Just(Data_Show.show(Data_Show.showInt)($12.value0));
              };
              if ($12 instanceof Data_Either.Left) {
                  return Data_Maybe.Nothing.value;
              };
              throw new Error("Failed pattern match at Pulp.Args.Help line 56, column 9 - line 60, column 20: " + [ $12.constructor.name ]);
          };
          throw new Error("Failed pattern match at Pulp.Args.Help line 52, column 5 - line 60, column 20: " + [ $10.constructor.name ]);
      };
      return opt.desc + (function () {
          if (opt.defaultValue instanceof Data_Maybe.Nothing) {
              return "";
          };
          if (opt.defaultValue instanceof Data_Maybe.Just) {
              return Data_Maybe.maybe("")(function (d) {
                  return " [Default: " + (d + "]");
              })(tryDefault(opt.defaultValue.value0));
          };
          throw new Error("Failed pattern match at Pulp.Args.Help line 47, column 31 - line 49, column 74: " + [ opt.defaultValue.constructor.name ]);
      })();
  };
  var prepareOpts = (function () {
      var formatKey = function (n) {
          return Data_String.joinWith(" ")(n.match) + (function () {
              if (n.parser.name instanceof Data_Maybe.Nothing) {
                  return "";
              };
              if (n.parser.name instanceof Data_Maybe.Just) {
                  return " " + n.parser.name.value0;
              };
              throw new Error("Failed pattern match at Pulp.Args.Help line 64, column 53 - line 66, column 33: " + [ n.parser.name.constructor.name ]);
          })();
      };
      var foldOpts = function (n) {
          return Data_StrMap.insert(formatKey(n))(describeOpt(n));
      };
      return Data_Foldable.foldr(Data_Foldable.foldableArray)(foldOpts)(Data_StrMap.empty);
  })();
  var formatOpts = function ($30) {
      return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(formatTable(prepareOpts($30)));
  };
  var printHelp = function (out) {
      return function (globals) {
          return function (commands) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(getCommandName))(function (v) {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.write("Usage: " + (v + " [global-options] <command> [command-options]\n")))(function () {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.bolded("\nGlobal options:\n"))(function () {
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Bind.bind(Control_Monad_Aff.bindAff)(formatOpts(Data_Semigroup.append(Data_Semigroup.semigroupArray)(globals)([ helpOpt ])))(out.write))(function () {
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.bolded("\nCommands:\n"))(function () {
                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Bind.bind(Control_Monad_Aff.bindAff)(formatCmds(commands))(out.write))(function () {
                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)($foreign.wrap("Use `" + (v + (" <command> --help` to " + "learn about command specific options.")))(2)))(function (v1) {
                                          return out.write("\n" + (v1 + "\n\n"));
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          };
      };
  };
  var argumentSynopsis = (function () {
      var format = function (arg) {
          return Data_String.toUpper((function () {
              if (arg.required) {
                  return arg.name;
              };
              if (!arg.required) {
                  return "[" + (arg.name + "]");
              };
              throw new Error("Failed pattern match at Pulp.Args.Help line 97, column 7 - line 101, column 1: " + [ arg.required.constructor.name ]);
          })());
      };
      return function ($31) {
          return Data_String.joinWith(" ")(Data_Functor.map(Data_Functor.functorArray)(format)($31));
      };
  })();
  var printCommandHelp = function (out) {
      return function (globals) {
          return function (command) {
              var hasCommandOpts = !Data_Array["null"](command.options);
              var hasArguments = !Data_Array["null"](command["arguments"]);
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(getCommandName))(function (v) {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.write("Usage: " + (v + (" [global-options] " + (command.name + (" " + ((function () {
                      if (hasArguments) {
                          return argumentSynopsis(command["arguments"]) + " ";
                      };
                      if (!hasArguments) {
                          return "";
                      };
                      throw new Error("Failed pattern match at Pulp.Args.Help line 123, column 20 - line 123, column 90: " + [ hasArguments.constructor.name ]);
                  })() + ((function () {
                      if (hasCommandOpts) {
                          return "[command-options]";
                      };
                      if (!hasCommandOpts) {
                          return "";
                      };
                      throw new Error("Failed pattern match at Pulp.Args.Help line 124, column 20 - line 124, column 70: " + [ hasCommandOpts.constructor.name ]);
                  })() + "\n"))))))))(function () {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.bolded("\nCommand: " + (command.name + "\n")))(function () {
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.write("  " + (command.desc + "\n")))(function () {
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Applicative.when(Control_Monad_Aff.applicativeAff)(hasArguments)(Control_Bind.bind(Control_Monad_Aff.bindAff)(out.bolded("\nArguments:\n"))(function () {
                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(formatArguments(command["arguments"]))(out.write);
                              })))(function () {
                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Applicative.when(Control_Monad_Aff.applicativeAff)(hasCommandOpts)(Control_Bind.bind(Control_Monad_Aff.bindAff)(out.bolded("\nCommand options:\n"))(function () {
                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(formatOpts(command.options))(out.write);
                                  })))(function () {
                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.bolded("\nGlobal options:\n"))(function () {
                                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Bind.bind(Control_Monad_Aff.bindAff)(formatOpts(Data_Semigroup.append(Data_Semigroup.semigroupArray)(globals)([ helpOpt ])))(out.write))(function () {
                                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.bolded("\nPassthrough options:\n"))(function () {
                                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Bind.bind(Control_Monad_Aff.bindAff)(formatPassThrough(command.passthroughDesc))(out.write))(function () {
                                                      return out.write("\n");
                                                  });
                                              });
                                          });
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          };
      };
  };
  exports["printCommandHelp"] = printCommandHelp;
  exports["printHelp"] = printHelp;
})(PS["Pulp.Args.Help"] = PS["Pulp.Args.Help"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Either = PS["Data.Either"];
  var Data_String = PS["Data.String"];
  var Data_StrMap = PS["Data.StrMap"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Foldable = PS["Data.Foldable"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Aff_AVar = PS["Control.Monad.Aff.AVar"];
  var Data_Posix_Signal = PS["Data.Posix.Signal"];
  var Node_Process = PS["Node.Process"];
  var Node_Platform = PS["Node.Platform"];
  var Node_ChildProcess = PS["Node.ChildProcess"];
  var Unsafe_Coerce = PS["Unsafe.Coerce"];
  var Pulp_System_Stream = PS["Pulp.System.Stream"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Show = PS["Data.Show"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Function = PS["Data.Function"];
  var Data_Boolean = PS["Data.Boolean"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Functor = PS["Data.Functor"];        

  /**
 *  | A slightly weird combination of `onError` and `onExit` into one.
 */  
  var wait = function (child) {
      return Control_Monad_Aff.makeAff(function (v) {
          return function (win) {
              return function __do() {
                  Node_ChildProcess.onExit(child)(function ($33) {
                      return win(Data_Either.Right.create($33));
                  })();
                  return Node_ChildProcess.onError(child)(function ($34) {
                      return win(Data_Either.Left.create($34));
                  })();
              };
          };
      });
  };
  var showExit = function (v) {
      if (v instanceof Node_ChildProcess.Normally) {
          return "with exit code " + Data_Show.show(Data_Show.showInt)(v.value0);
      };
      if (v instanceof Node_ChildProcess.BySignal) {
          return "as a result of receiving " + Data_Show.show(Data_Posix_Signal.showSignal)(v.value0);
      };
      throw new Error("Failed pattern match at Pulp.Exec line 143, column 1 - line 143, column 55: " + [ v.constructor.name ]);
  };
  var handleErrors = function (cmd) {
      return function (retry) {
          return function (err) {
              if (err.code === "ENOENT") {
                  var $13 = Data_Eq.eq(Node_Platform.eqPlatform)(Node_Process.platform)(Node_Platform.Win32.value);
                  if ($13) {
                      var $14 = Data_String.stripSuffix(".cmd")(cmd);
                      if ($14 instanceof Data_Maybe.Nothing) {
                          return retry(cmd + ".cmd");
                      };
                      if ($14 instanceof Data_Maybe.Just) {
                          return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("`" + ($14.value0 + ("` executable not found. (nor `" + (cmd + "`)")))));
                      };
                      throw new Error("Failed pattern match at Pulp.Exec line 151, column 13 - line 155, column 8: " + [ $14.constructor.name ]);
                  };
                  if (!$13) {
                      return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("`" + (cmd + "` executable not found.")));
                  };
                  throw new Error("Failed pattern match at Pulp.Exec line 150, column 6 - line 158, column 3: " + [ $13.constructor.name ]);
              };
              if (Data_Boolean.otherwise) {
                  return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Node_ChildProcess.toStandardError(err));
              };
              throw new Error("Failed pattern match at Pulp.Exec line 147, column 1 - line 159, column 40: " + [ cmd.constructor.name, retry.constructor.name, err.constructor.name ]);
          };
      };
  };
  var execWithStdio = function (stdio) {
      return function (cmd) {
          return function (args) {
              return function (env) {
                  var retry = function (newCmd) {
                      return execWithStdio(stdio)(newCmd)(args)(env);
                  };
                  var onExit = function (exit) {
                      if (exit instanceof Node_ChildProcess.Normally && exit.value0 === 0) {
                          return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Data_Unit.unit);
                      };
                      return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Subcommand terminated " + showExit(exit)));
                  };
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_ChildProcess.spawn(cmd)(args)((function () {
                      var $18 = {};
                      for (var $19 in Node_ChildProcess.defaultSpawnOptions) {
                          if ({}.hasOwnProperty.call(Node_ChildProcess.defaultSpawnOptions, $19)) {
                              $18[$19] = Node_ChildProcess.defaultSpawnOptions[$19];
                          };
                      };
                      $18.env = env;
                      $18.stdio = stdio;
                      return $18;
                  })())))(function (v) {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(wait(v))(Data_Either.either(handleErrors(cmd)(retry))(onExit));
                  });
              };
          };
      };
  };
  var execQuietWithStderr = function (stderrBehaviour) {
      return function (cmd) {
          return function (args) {
              return function (env) {
                  var retry = function (newCmd) {
                      return execQuietWithStderr(stderrBehaviour)(newCmd)(args)(env);
                  };
                  var onExit = function (outVar) {
                      return function (exit) {
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff_AVar.takeVar(outVar))(function (childOut) {
                              if (exit instanceof Node_ChildProcess.Normally && exit.value0 === 0) {
                                  return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(childOut);
                              };
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_Stream.write(Node_Process.stderr)(childOut))(function () {
                                  return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Subcommand terminated " + showExit(exit)));
                              });
                          });
                      };
                  };
                  var stdio = [ new Data_Maybe.Just(new Node_ChildProcess.ShareStream(Unsafe_Coerce.unsafeCoerce(Node_Process.stdin))), new Data_Maybe.Just(Node_ChildProcess.Pipe.value), new Data_Maybe.Just(stderrBehaviour) ];
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_ChildProcess.spawn(cmd)(args)((function () {
                      var $24 = {};
                      for (var $25 in Node_ChildProcess.defaultSpawnOptions) {
                          if ({}.hasOwnProperty.call(Node_ChildProcess.defaultSpawnOptions, $25)) {
                              $24[$25] = Node_ChildProcess.defaultSpawnOptions[$25];
                          };
                      };
                      $24.env = env;
                      $24.stdio = stdio;
                      return $24;
                  })())))(function (v) {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff_AVar.makeVar)(function (v1) {
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff.forkAff(Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_Stream.concatStream(Node_ChildProcess.stdout(v)))(Control_Monad_Aff_AVar.putVar(v1))))(function () {
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(wait(v))(Data_Either.either(handleErrors(cmd)(retry))(onExit(v1)));
                          });
                      });
                  });
              };
          };
      };
  };

  /**
 *  | Same as exec, except instead of relaying stdout immediately, it is
 *  | captured and returned as a String.
 */  
  var execQuiet = execQuietWithStderr(new Node_ChildProcess.ShareStream(Unsafe_Coerce.unsafeCoerce(Node_Process.stderr)));
  var pscBundle = function (files) {
      return function (args) {
          return function (env) {
              return execQuiet("psc-bundle")(Data_Semigroup.append(Data_Semigroup.semigroupArray)(files)(args))(env);
          };
      };
  };

  /**
 *  | Start a child process asynchronously, with the given command line
 *  | arguments and environment, and wait for it to exit.
 *  | On a non-zero exit code, throw an error.
 *  |
 *  | If the executable was not found and we are on Windows, retry with ".cmd"
 *  | appended.
 *  |
 *  | Stdout, stdin, and stderr of the child process are shared with the pulp
 *  | process (that is, data on stdin from pulp is relayed to the child process,
 *  | and any stdout and stderr from the child process are relayed back out by
 *  | pulp, which usually means they will immediately appear in the terminal).
 */  
  var exec = execWithStdio(Node_ChildProcess.inherit);

  /**
 *  | A version of `exec` which installs signal handlers to make sure that the
 *  | signals SIGINT and SIGTERM are relayed to the child process, if received.
 */  
  var execInteractive = function (cmd) {
      return function (args) {
          return function (env) {
              var retry = function (newCmd) {
                  return exec(newCmd)(args)(env);
              };
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_ChildProcess.spawn(cmd)(args)((function () {
                  var $29 = {};
                  for (var $30 in Node_ChildProcess.defaultSpawnOptions) {
                      if ({}.hasOwnProperty.call(Node_ChildProcess.defaultSpawnOptions, $30)) {
                          $29[$30] = Node_ChildProcess.defaultSpawnOptions[$30];
                      };
                  };
                  $29.env = env;
                  $29.stdio = Node_ChildProcess.inherit;
                  return $29;
              })())))(function (v) {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Data_Foldable.for_(Control_Monad_Eff.applicativeEff)(Data_Foldable.foldableArray)([ Data_Posix_Signal.SIGTERM.value, Data_Posix_Signal.SIGINT.value ])(function (sig) {
                      return Node_Process.onSignal(sig)(Data_Functor["void"](Control_Monad_Eff.functorEff)(Node_ChildProcess.kill(sig)(v)));
                  })))(function () {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(wait(v))(Data_Either.either(handleErrors(cmd)(retry))(Data_Function["const"](Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Data_Unit.unit))));
                  });
              });
          };
      };
  };
  var compiler = function (name) {
      return function (deps) {
          return function (args) {
              return function (env) {
                
                  /**
                 *  | Like Node.ChildProcess.inherit except the child process' standard output
                 *  | is sent to Pulp's standard error.
                 */  
                  var inheritButOutToErr = Data_Functor.map(Data_Functor.functorArray)(Data_Maybe.Just.create)([ new Node_ChildProcess.ShareStream(Unsafe_Coerce.unsafeCoerce(Node_Process.stdin)), new Node_ChildProcess.ShareStream(Unsafe_Coerce.unsafeCoerce(Node_Process.stderr)), new Node_ChildProcess.ShareStream(Unsafe_Coerce.unsafeCoerce(Node_Process.stderr)) ]);
                  return execWithStdio(inheritButOutToErr)(name)(Data_Semigroup.append(Data_Semigroup.semigroupArray)(args)(deps))(env);
              };
          };
      };
  };
  var psa = compiler("psa");
  var psc = compiler("psc");
  exports["exec"] = exec;
  exports["execInteractive"] = execInteractive;
  exports["execQuiet"] = execQuiet;
  exports["execQuietWithStderr"] = execQuietWithStderr;
  exports["execWithStdio"] = execWithStdio;
  exports["psa"] = psa;
  exports["psc"] = psc;
  exports["pscBundle"] = pscBundle;
})(PS["Pulp.Exec"] = PS["Pulp.Exec"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Either = PS["Data.Either"];
  var Data_List = PS["Data.List"];
  var Data_String = PS["Data.String"];
  var Data_Version_Haskell = PS["Data.Version.Haskell"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_List_Types = PS["Data.List.Types"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Function = PS["Data.Function"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Ord = PS["Data.Ord"];        
  var minimumPscVersion = new Data_Version_Haskell.Version(Data_List.fromFoldable(Data_Foldable.foldableArray)([ 0, 9, 0 ]), Data_List_Types.Nil.value);
  var getPscVersion = function (out) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Data_Functor.map(Control_Monad_Aff.functorAff)(Data_String.trim)(Pulp_Exec.execQuiet("psc")([ "--version" ])(Data_Maybe.Nothing.value)))(function (v) {
          var $3 = Data_Version_Haskell.parseVersion(v);
          if ($3 instanceof Data_Either.Right) {
              return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)($3.value0);
          };
          if ($3 instanceof Data_Either.Left) {
              var msg = Text_Parsing_Parser.parseErrorMessage($3.value0);
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.err("Unable to parse the version from psc. (It was: " + (v + ")")))(function () {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.err("Please check that the right psc is on your PATH."))(function () {
                      return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Couldn't parse version from psc"));
                  });
              });
          };
          throw new Error("Failed pattern match at Pulp.Validate line 34, column 3 - line 43, column 1: " + [ $3.constructor.name ]);
      });
  };
  var validate = function (out) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(getPscVersion(out))(function (v) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Applicative.when(Control_Monad_Aff.applicativeAff)(Data_Ord.lessThan(Data_Version_Haskell.ordVersion)(v)(minimumPscVersion))(Control_Bind.bind(Control_Monad_Aff.bindAff)(out.err("This version of Pulp requires version " + (Data_Version_Haskell.showVersion(minimumPscVersion) + (" of the PureScript compiler " + "or higher."))))(function () {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.err("Your installed version is " + (Data_Version_Haskell.showVersion(v) + ".")))(function () {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.err("Please either upgrade PureScript or downgrade Pulp to version 8.x."))(function () {
                      return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Minimum psc version not satisfied"));
                  });
              });
          })))(function () {
              return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(v);
          });
      });
  };
  exports["validate"] = validate;
})(PS["Pulp.Validate"] = PS["Pulp.Validate"] || {});
(function(exports) {
    "use strict";

  exports.__dirname = __dirname;
  exports.__filename = __filename;
})(PS["Node.Globals"] = PS["Node.Globals"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | Global objects exposed by Node.js. See also the [Node.js API
 *  | documentation](https://nodejs.org/api/globals.html).
 */  
  "use strict";
  var $foreign = PS["Node.Globals"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Node_FS = PS["Node.FS"];
  exports["__dirname"] = $foreign.__dirname;
  exports["__filename"] = $foreign.__filename;
})(PS["Node.Globals"] = PS["Node.Globals"] || {});
(function(exports) {
  // module Pulp.System.Which

  "use strict";

  exports["which'"] = require("which");
})(PS["Pulp.System.Which"] = PS["Pulp.System.Which"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Pulp.System.Which"];
  var Prelude = PS["Prelude"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Data_Function = PS["Data.Function"];        
  var which = function (cmd) {
      return Pulp_System_FFI.runNode(Data_Function_Uncurried.runFn2($foreign["which'"])(cmd));
  };
  exports["which"] = which;
})(PS["Pulp.System.Which"] = PS["Pulp.System.Which"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Either = PS["Data.Either"];
  var Data_String = PS["Data.String"];
  var Data_Version = PS["Data.Version"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Eff_Console = PS["Control.Monad.Eff.Console"];
  var Control_Monad_Eff_Unsafe = PS["Control.Monad.Eff.Unsafe"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Eff_Exception_Unsafe = PS["Control.Monad.Eff.Exception.Unsafe"];
  var Control_Monad_Except = PS["Control.Monad.Except"];
  var Node_FS_Sync = PS["Node.FS.Sync"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_Path = PS["Node.Path"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Node_Globals = PS["Node.Globals"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Which = PS["Pulp.System.Which"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Data_Function = PS["Data.Function"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Monad_Except_Trans = PS["Control.Monad.Except.Trans"];
  var Data_Identity = PS["Data.Identity"];
  var Data_Foreign_Index = PS["Data.Foreign.Index"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Show = PS["Data.Show"];
  var Data_List_Types = PS["Data.List.Types"];
  var Control_Applicative = PS["Control.Applicative"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];        
  var versionString = Control_Monad_Eff_Unsafe.unsafePerformEff(function __do() {
      var v = Node_FS_Sync.readTextFile(Node_Encoding.UTF8.value)(Node_Path.concat([ Node_Globals.__dirname, "package.json" ]))();
      var $4 = Control_Monad_Except.runExcept(Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Data_Foreign.parseJSON(v))(Data_Foreign_Class.readProp(Data_Foreign_Class.stringIsForeign)(Data_Foreign_Index.indexString)("version")));
      if ($4 instanceof Data_Either.Left) {
          return Control_Monad_Eff_Exception.throwException(Control_Monad_Eff_Exception.error("pulp: Unable to parse package.json: " + Data_Show.show(Data_List_Types.showNonEmptyList(Data_Foreign.showForeignError))($4.value0)))();
      };
      if ($4 instanceof Data_Either.Right) {
          return $4.value0;
      };
      throw new Error("Failed pattern match at Pulp.Version line 38, column 5 - line 42, column 15: " + [ $4.constructor.name ]);
  });
  var version = (function () {
      var $7 = Data_Version.parseVersion(versionString);
      if ($7 instanceof Data_Either.Right) {
          return $7.value0;
      };
      if ($7 instanceof Data_Either.Left) {
          return Control_Monad_Eff_Exception_Unsafe.unsafeThrow("pulp: Unable to parse version from package.json: " + Data_Show.show(Text_Parsing_Parser.showParseError)($7.value0));
      };
      throw new Error("Failed pattern match at Pulp.Version line 29, column 3 - line 32, column 42: " + [ $7.constructor.name ]);
  })();
  var printVersion = Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Exec.execQuiet("psc")([ "--version" ])(Data_Maybe.Nothing.value))(function (v) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff.attempt(Pulp_System_Which.which("psc")))(function (v1) {
          return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Control_Monad_Eff_Console.log("Pulp version " + (Data_Version.showVersion(version) + ("\npsc version " + (Data_String.trim(v) + Data_Either.either(Data_Function["const"](""))(function (p) {
              return " using " + Data_String.trim(p);
          })(v1))))));
      });
  });
  exports["printVersion"] = printVersion;
  exports["version"] = version;
  exports["versionString"] = versionString;
})(PS["Pulp.Version"] = PS["Pulp.Version"] || {});
(function(exports) {
  // module Pulp.System.Files

  "use strict";

  exports.isEEXIST = function isEEXIST(err) {
    return err && err.code === 'EEXIST';
  };

  var temp = require('temp').track();
  exports["openTemp'"] = function openTemp$prime(opts, callback) {
    temp.open(opts, callback);
  };

  exports.createWriteStream = function createWriteStream(path) {
    return function() {
      return require('fs').createWriteStream(path);
    };
  };

  exports.isENOENT = function isENOENT(error) {
    return error.code === "ENOENT";
  };
})(PS["Pulp.System.Files"] = PS["Pulp.System.Files"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Pulp.System.Files"];
  var Prelude = PS["Prelude"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Either = PS["Data.Either"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Node_FS = PS["Node.FS"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Stream = PS["Pulp.System.Stream"];
  var Data_Function = PS["Data.Function"];
  var Data_Unit = PS["Data.Unit"];
  var Control_Applicative = PS["Control.Applicative"];
  var openTemp = function (opts) {
      return Pulp_System_FFI.runNode(Data_Function_Uncurried.runFn2($foreign["openTemp'"])(opts));
  };
  var mkdirIfNotExist = function (dir) {
      return Control_Monad_Error_Class.catchJust(Control_Monad_Aff.monadErrorAff)(function (e) {
          var $0 = $foreign.isEEXIST(e);
          if ($0) {
              return new Data_Maybe.Just(Data_Unit.unit);
          };
          if (!$0) {
              return Data_Maybe.Nothing.value;
          };
          throw new Error("Failed pattern match at Pulp.System.Files line 28, column 20 - line 28, column 61: " + [ $0.constructor.name ]);
      })(Node_FS_Aff.mkdir(dir))(Control_Applicative.pure(Control_Monad_Aff.applicativeAff));
  };
  exports["mkdirIfNotExist"] = mkdirIfNotExist;
  exports["openTemp"] = openTemp;
  exports["createWriteStream"] = $foreign.createWriteStream;
  exports["isENOENT"] = $foreign.isENOENT;
})(PS["Pulp.System.Files"] = PS["Pulp.System.Files"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Either = PS["Data.Either"];
  var Control_Monad_Except = PS["Control.Monad.Except"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_Path = PS["Node.Path"];
  var Node_Process = PS["Node.Process"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Files = PS["Pulp.System.Files"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Data_Function = PS["Data.Function"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Show = PS["Data.Show"];
  var Data_List_Types = PS["Data.List.Types"];
  var Control_Monad_Except_Trans = PS["Control.Monad.Except.Trans"];
  var Data_Identity = PS["Data.Identity"];
  var Data_Foreign_Index = PS["Data.Foreign.Index"];
  var Data_Eq = PS["Data.Eq"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];        
  var Project = function (x) {
      return x;
  };

  /**
 *  | Read a project's bower file at the given path and construct a Project
 *  | value.
 */  
  var readConfig = function (configFilePath) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.readTextFile(Node_Encoding.UTF8.value)(configFilePath))(function (v) {
          var $8 = Control_Monad_Except.runExcept(Data_Foreign.parseJSON(v));
          if ($8 instanceof Data_Either.Left) {
              return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Unable to parse bower.json: " + Data_Show.show(Data_List_Types.showNonEmptyList(Data_Foreign.showForeignError))($8.value0)));
          };
          if ($8 instanceof Data_Either.Right) {
              var path = Node_Path.dirname(configFilePath);
              var cachePath = Node_Path.resolve([ path ])(".pulp-cache");
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.chdir(path)))(function () {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_Files.mkdirIfNotExist(cachePath))(function () {
                      return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)({
                          bowerFile: $8.value0, 
                          cache: cachePath, 
                          path: path
                      });
                  });
              });
          };
          throw new Error("Failed pattern match at Pulp.Project line 52, column 3 - line 60, column 70: " + [ $8.constructor.name ]);
      });
  };
  var isForeignProject = new Data_Foreign_Class.IsForeign(function (o) {
      return Data_Functor.map(Control_Monad_Except_Trans.functorExceptT(Data_Identity.functorIdentity))(Project)(Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Data_Foreign_Class.readProp(Data_Foreign_Class.foreignIsForeign)(Data_Foreign_Index.indexString)("bowerFile")(o))(function (v) {
          return Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Data_Foreign_Class.readProp(Data_Foreign_Class.stringIsForeign)(Data_Foreign_Index.indexString)("path")(o))(function (v1) {
              return Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Data_Foreign_Class.readProp(Data_Foreign_Class.stringIsForeign)(Data_Foreign_Index.indexString)("cache")(o))(function (v2) {
                  return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))({
                      bowerFile: v, 
                      path: v1, 
                      cache: v2
                  });
              });
          });
      }));
  });
  var findIn = function (path) {
      return function (file) {
          var fullPath = Node_Path.concat([ path, file ]);
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.exists(fullPath))(function (v) {
              if (v) {
                  return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(new Data_Maybe.Just(fullPath));
              };
              if (!v) {
                  var parent = Node_Path.dirname(path);
                  var $16 = path === parent;
                  if ($16) {
                      return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Data_Maybe.Nothing.value);
                  };
                  if (!$16) {
                      return findIn(parent)(file);
                  };
                  throw new Error("Failed pattern match at Pulp.Project line 43, column 10 - line 45, column 35: " + [ $16.constructor.name ]);
              };
              throw new Error("Failed pattern match at Pulp.Project line 39, column 3 - line 45, column 35: " + [ v.constructor.name ]);
          });
      };
  };

  /**
 *  | Use the provided bower file, or if it is Nothing, try to find a bower file
 *  | path in this or any parent directory.
 */  
  var getBowerFile = (function () {
      var search = Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.cwd))(function (v) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(findIn(v)("bower.json"))(function (v1) {
              if (v1 instanceof Data_Maybe.Just) {
                  return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(v1.value0);
              };
              if (v1 instanceof Data_Maybe.Nothing) {
                  return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("No bower.json found in current or parent directories. Are you in a PureScript project?"));
              };
              throw new Error("Failed pattern match at Pulp.Project line 70, column 5 - line 75, column 1: " + [ v1.constructor.name ]);
          });
      });
      return Data_Maybe.maybe(search)(Control_Applicative.pure(Control_Monad_Aff.applicativeAff));
  })();
  var getProject = function (args) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)("bowerFile")(args))(getBowerFile))(readConfig);
  };
  exports["Project"] = Project;
  exports["getProject"] = getProject;
  exports["isForeignProject"] = isForeignProject;
})(PS["Pulp.Project"] = PS["Pulp.Project"] || {});
(function(exports) {
  // module Pulp.Init
  "use strict";

  exports.bowerFile = function bowerFile(name) {
    return JSON.stringify({
      name: name,
      ignore: [
        "**/.*",
        "node_modules",
        "bower_components",
        "output"
      ],
      dependencies: {
      },
      devDependencies: {
      },
    }, null, 2) + "\n";
  };
})(PS["Pulp.Init"] = PS["Pulp.Init"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Data_Either = PS["Data.Either"];
  var Data_Maybe = PS["Data.Maybe"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Which = PS["Pulp.System.Which"];
  var Control_Bind = PS["Control.Bind"];
  var Data_Function = PS["Data.Function"];        
  var launchBower = function (args) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff.attempt(Pulp_System_Which.which("bower")))(function (v) {
          return Data_Either.either(Data_Function["const"](Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("No `bower` executable found.\nPulp no longer bundles Bower. You'll need to install it manually:\n\n   $ npm install -g bower\n"))))(function (e) {
              return Pulp_Exec.exec(e)(args)(Data_Maybe.Nothing.value);
          })(v);
      });
  };
  exports["launchBower"] = launchBower;
})(PS["Pulp.Bower"] = PS["Pulp.Bower"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Pulp.Init"];
  var Prelude = PS["Prelude"];
  var Data_String = PS["Data.String"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Node_Path = PS["Node.Path"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_Process = PS["Node.Process"];
  var Data_Traversable = PS["Data.Traversable"];
  var Data_Foldable = PS["Data.Foldable"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_System_Files = PS["Pulp.System.Files"];
  var Pulp_Bower = PS["Pulp.Bower"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Function = PS["Data.Function"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Eq = PS["Data.Eq"];        
  var unlines = function (arr) {
      return Data_String.joinWith("\n")(arr) + "\n";
  };
  var testFile = unlines([ "module Test.Main where", "", "import Prelude", "import Control.Monad.Eff (Eff)", "import Control.Monad.Eff.Console (CONSOLE, log)", "", "main :: forall e. Eff (console :: CONSOLE | e) Unit", "main = do", "  log \"You should add some tests.\"" ]);
  var mainFile = unlines([ "module Main where", "", "import Prelude", "import Control.Monad.Eff (Eff)", "import Control.Monad.Eff.Console (CONSOLE, log)", "", "main :: forall e. Eff (console :: CONSOLE | e) Unit", "main = do", "  log \"Hello sailor!\"" ]);
  var gitignore = unlines([ "/bower_components/", "/node_modules/", "/.pulp-cache/", "/output/", "/generated-docs/", "/.psc*", "/.psa*" ]);
  var projectFiles = function (pathRoot) {
      return function (projectName) {
          var fullPath = function (pathParts) {
              return Node_Path.concat(Data_Semigroup.append(Data_Semigroup.semigroupArray)([ pathRoot ])(pathParts));
          };
          return [ {
              path: fullPath([ "bower.json" ]), 
              content: $foreign.bowerFile(projectName)
          }, {
              path: fullPath([ ".gitignore" ]), 
              content: gitignore
          }, {
              path: fullPath([ "src", "Main.purs" ]), 
              content: mainFile
          }, {
              path: fullPath([ "test", "Main.purs" ]), 
              content: testFile
          } ];
      };
  };
  var init = function (force) {
      return function (out) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.cwd))(function (v) {
              var projectName = Node_Path.basename(v);
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.log("Generating project skeleton in " + v))(function () {
                  var files = projectFiles(v)(projectName);
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Applicative.when(Control_Monad_Aff.applicativeAff)(!force)(Data_Foldable.for_(Control_Monad_Aff.applicativeAff)(Data_Foldable.foldableArray)(files)(function (f) {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.exists(f.path))(function (v1) {
                          return Control_Applicative.when(Control_Monad_Aff.applicativeAff)(v1)(Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Found " + (f.path + (": " + ("There's already a project here. Run `pulp init --force` " + "if you're sure you want to overwrite it."))))));
                      });
                  })))(function () {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Data_Traversable["for"](Control_Monad_Aff.applicativeAff)(Data_Traversable.traversableArray)(files)(function (f) {
                          var dir = Node_Path.dirname(f.path);
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Applicative.when(Control_Monad_Aff.applicativeAff)(dir !== v)(Pulp_System_Files.mkdirIfNotExist(dir)))(function () {
                              return Node_FS_Aff.writeTextFile(Node_Encoding.UTF8.value)(f.path)(f.content);
                          });
                      }))(function () {
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Bower.launchBower([ "install", "--save", "purescript-prelude", "purescript-console" ]))(function () {
                              return Pulp_Bower.launchBower([ "install", "--save-dev", "purescript-psci-support" ]);
                          });
                      });
                  });
              });
          });
      };
  };
  var action = function (args) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("force")(args.commandOpts))(function (v) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v1) {
              return init(v)(v1);
          });
      });
  };
  exports["action"] = action;
})(PS["Pulp.Init"] = PS["Pulp.Init"] || {});
(function(exports) {
  // module Pulp.Files

  "use strict";

  exports["glob'"] = function glob$prime(pat, callback) {
    require("glob")(pat, {}, callback);
  };
})(PS["Pulp.Files"] = PS["Pulp.Files"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Pulp.Files"];
  var Prelude = PS["Prelude"];
  var Data_Array = PS["Data.Array"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Data_List = PS["Data.List"];
  var Data_Set = PS["Data.Set"];
  var Data_Traversable = PS["Data.Traversable"];
  var Node_Path = PS["Node.Path"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Unfoldable = PS["Data.Unfoldable"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Ord = PS["Data.Ord"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Bind = PS["Control.Bind"];
  var Data_Function = PS["Data.Function"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Category = PS["Control.Category"];
  var Data_List_Types = PS["Data.List.Types"];        
  var recursiveGlobWithExtension = function (ext) {
      return function ($7) {
          return Data_Functor.map(Data_Functor.functorArray)(function (v) {
              return v + ("/**/*." + ext);
          })(Data_Set.toUnfoldable(Data_Unfoldable.unfoldableArray)($7));
      };
  };
  var sources = recursiveGlobWithExtension("purs");
  var outputModules = function (buildPath) {
      return [ buildPath + "/*/*.js" ];
  };
  var includeGlobs = function (opts) {
      var mkSet = function ($8) {
          return Data_Set.fromFoldable(Data_Foldable.foldableArray)(Data_Ord.ordString)(Data_Maybe.fromMaybe([  ])($8));
      };
      return Data_Functor.map(Control_Monad_Aff.functorAff)(mkSet)(Pulp_Args_Get.getOption(Data_Foreign_Class.arrayIsForeign(Data_Foreign_Class.stringIsForeign))("includePaths")(opts));
  };
  var globsFromOption$prime = function (dictIsForeign) {
      return function (f) {
          return function (name) {
              return function (opts) {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(dictIsForeign)(name)(opts))(function (v) {
                      return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)((function () {
                          if (v instanceof Data_Maybe.Just) {
                              return Data_Set.singleton(f(v.value0));
                          };
                          if (v instanceof Data_Maybe.Nothing) {
                              return Data_Set.empty;
                          };
                          throw new Error("Failed pattern match at Pulp.Files line 43, column 10 - line 45, column 31: " + [ v.constructor.name ]);
                      })());
                  });
              };
          };
      };
  };
  var globsFromOption = function (dictIsForeign) {
      return globsFromOption$prime(dictIsForeign)(Control_Category.id(Control_Category.categoryFn));
  };
  var localGlobs = globsFromOption(Data_Foreign_Class.stringIsForeign)("srcPath");
  var testGlobs = globsFromOption(Data_Foreign_Class.stringIsForeign)("testPath");
  var glob = function (pattern) {
      return Pulp_System_FFI.runNode(Data_Function_Uncurried.runFn2($foreign["glob'"])(pattern));
  };
  var resolveGlobs = function (patterns) {
      return Data_Functor.map(Control_Monad_Aff.functorAff)(Data_Array.concat)(Data_Traversable.traverse(Data_Traversable.traversableArray)(Control_Monad_Aff.applicativeAff)(glob)(patterns));
  };
  var ffis = recursiveGlobWithExtension("js");
  var dependencyGlobs = globsFromOption$prime(Data_Foreign_Class.stringIsForeign)(function (path) {
      return Node_Path.concat([ path, "purescript-*", "src" ]);
  })("dependencyPath");
  var defaultGlobs = function (opts) {
      return Data_Functor.map(Control_Monad_Aff.functorAff)(Data_Set.unions(Data_List_Types.foldableList)(Data_Ord.ordString))(Data_Traversable.sequence(Data_List_Types.traversableList)(Control_Monad_Aff.applicativeAff)(Data_List.fromFoldable(Data_Foldable.foldableArray)([ localGlobs(opts), dependencyGlobs(opts), includeGlobs(opts) ])));
  };
  exports["defaultGlobs"] = defaultGlobs;
  exports["dependencyGlobs"] = dependencyGlobs;
  exports["ffis"] = ffis;
  exports["glob"] = glob;
  exports["includeGlobs"] = includeGlobs;
  exports["localGlobs"] = localGlobs;
  exports["outputModules"] = outputModules;
  exports["resolveGlobs"] = resolveGlobs;
  exports["sources"] = sources;
  exports["testGlobs"] = testGlobs;
})(PS["Pulp.Files"] = PS["Pulp.Files"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Either = PS["Data.Either"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Map = PS["Data.Map"];
  var Data_String = PS["Data.String"];
  var Data_Set = PS["Data.Set"];
  var Data_Foldable = PS["Data.Foldable"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Node_Process = PS["Node.Process"];
  var Node_Path = PS["Node.Path"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Stream = PS["Pulp.System.Stream"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_System_Files = PS["Pulp.System.Files"];
  var Pulp_System_Which = PS["Pulp.System.Which"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_Files = PS["Pulp.Files"];
  var Data_Eq = PS["Data.Eq"];
  var Control_Bind = PS["Control.Bind"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Data_Function = PS["Data.Function"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Monoid = PS["Data.Monoid"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Apply = PS["Control.Apply"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Show = PS["Data.Show"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];        
  var NormalBuild = (function () {
      function NormalBuild() {

      };
      NormalBuild.value = new NormalBuild();
      return NormalBuild;
  })();
  var TestBuild = (function () {
      function TestBuild() {

      };
      TestBuild.value = new TestBuild();
      return TestBuild;
  })();

  /**
 *  | Get a writable stream which output should be written to, based on the
 *  | value of the 'to' option.
 */  
  var withOutputStream = function (opts) {
      return function (aff) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)("to")(opts))(function (v) {
              if (v instanceof Data_Maybe.Just) {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_Files.openTemp({
                      prefix: "pulp-output", 
                      suffix: ""
                  }))(function (v1) {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Pulp_System_Files.createWriteStream(v1.path)))(function (v2) {
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(aff(v2))(function () {
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_Stream.end(v2))(function () {
                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.fdClose(v1.fd))(function () {
                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_Files.mkdirIfNotExist(Node_Path.dirname(v.value0)))(function () {
                                          return Node_FS_Aff.rename(v1.path)(v.value0);
                                      });
                                  });
                              });
                          });
                      });
                  });
              };
              if (v instanceof Data_Maybe.Nothing) {
                  return aff(Node_Process.stdout);
              };
              throw new Error("Failed pattern match at Pulp.Build line 123, column 3 - line 133, column 19: " + [ v.constructor.name ]);
          });
      };
  };
  var eqBuildType = new Data_Eq.Eq(function (v) {
      return function (v1) {
          if (v instanceof NormalBuild && v1 instanceof NormalBuild) {
              return true;
          };
          if (v instanceof TestBuild && v1 instanceof TestBuild) {
              return true;
          };
          return false;
      };
  });
  var bundle = function (args) {
      var parseModulesOption = Data_Maybe.maybe([  ])(Data_String.split(","));
      var opts = Data_Map.union(Data_Ord.ordString)(args.globalOpts)(args.commandOpts);
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(v.log("Bundling JavaScript..."))(function () {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("main")(opts))(function (v1) {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Data_Functor.map(Control_Monad_Aff.functorAff)(parseModulesOption)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)("modules")(opts)))(function (v2) {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("buildPath")(opts))(function (v3) {
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("skipEntryPoint")(opts))(function (v4) {
                              var bundleArgs = Data_Foldable.fold(Data_Foldable.foldableArray)(Data_Monoid.monoidArray)([ [ "--module=" + v1 ], (function () {
                                  if (v4) {
                                      return [  ];
                                  };
                                  if (!v4) {
                                      return [ "--main=" + v1 ];
                                  };
                                  throw new Error("Failed pattern match at Pulp.Build line 103, column 11 - line 103, column 56: " + [ v4.constructor.name ]);
                              })(), Data_Functor.map(Data_Functor.functorArray)(function (m) {
                                  return "--module=" + m;
                              })(v2), args.remainder ]);
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Exec.pscBundle(Pulp_Files.outputModules(v3))(bundleArgs)(Data_Maybe.Nothing.value))(function (v5) {
                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(withOutputStream(opts)(function (out$prime) {
                                      return Pulp_System_Stream.write(out$prime)(v5);
                                  }))(function () {
                                      return v.log("Bundled.");
                                  });
                              });
                          });
                      });
                  });
              });
          });
      });
  };
  var go = function (buildType) {
      return function (args) {
          var opts = Data_Map.union(Data_Ord.ordString)(args.globalOpts)(args.commandOpts);
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.cwd))(function (v1) {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(v.log("Building project in " + v1))(function () {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Apply.apply(Control_Monad_Aff.applyAff)(Data_Functor.map(Control_Monad_Aff.functorAff)(Data_Set.union(Data_Ord.ordString))(Pulp_Files.defaultGlobs(opts)))((function () {
                          var $37 = Data_Eq.eq(eqBuildType)(buildType)(TestBuild.value);
                          if ($37) {
                              return Pulp_Files.testGlobs(opts);
                          };
                          if (!$37) {
                              return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Data_Set.empty);
                          };
                          throw new Error("Failed pattern match at Pulp.Build line 56, column 27 - line 58, column 48: " + [ $37.constructor.name ]);
                      })()))(function (v2) {
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("buildPath")(args.commandOpts))(function (v3) {
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("noPsa")(args.commandOpts))(function (v4) {
                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.intIsForeign)("jobs")(args.commandOpts))(function (v5) {
                                      var jobsArgs = Data_Maybe.maybe([  ])(function (j) {
                                          return [ "+RTS", "-N" + Data_Show.show(Data_Show.showInt)(j), "-RTS" ];
                                      })(v5);
                                      var sourceGlobs = Pulp_Files.sources(v2);
                                      var binArgs = Data_Semigroup.append(Data_Semigroup.semigroupArray)([ "-o", v3 ])(Data_Semigroup.append(Data_Semigroup.semigroupArray)(jobsArgs)(args.remainder));
                                      var runPsc = Pulp_Exec.psc(sourceGlobs)(binArgs)(Data_Maybe.Nothing.value);
                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)((function () {
                                          if (v4) {
                                              return runPsc;
                                          };
                                          if (!v4) {
                                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff.attempt(Pulp_System_Which.which("psa")))(function (v6) {
                                                  if (v6 instanceof Data_Either.Left) {
                                                      return runPsc;
                                                  };
                                                  if (v6 instanceof Data_Either.Right) {
                                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("monochrome")(args.globalOpts))(function (v7) {
                                                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("dependencyPath")(args.commandOpts))(function (v8) {
                                                              var binArgs$prime = Data_Semigroup.append(Data_Semigroup.semigroupArray)(binArgs)(Data_Semigroup.append(Data_Semigroup.semigroupArray)([ "--is-lib=" + v8 ])((function () {
                                                                  if (v7) {
                                                                      return [ "--monochrome" ];
                                                                  };
                                                                  if (!v7) {
                                                                      return [  ];
                                                                  };
                                                                  throw new Error("Failed pattern match at Pulp.Build line 79, column 38 - line 81, column 47: " + [ v7.constructor.name ]);
                                                              })()));
                                                              return Pulp_Exec.psa(sourceGlobs)(binArgs$prime)(Data_Maybe.Nothing.value);
                                                          });
                                                      });
                                                  };
                                                  throw new Error("Failed pattern match at Pulp.Build line 73, column 7 - line 82, column 43: " + [ v6.constructor.name ]);
                                              });
                                          };
                                          throw new Error("Failed pattern match at Pulp.Build line 69, column 3 - line 82, column 43: " + [ v4.constructor.name ]);
                                      })())(function () {
                                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(v.log("Build successful."))(function () {
                                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Apply.apply(Control_Monad_Aff.applyAff)(Data_Functor.map(Control_Monad_Aff.functorAff)(Data_HeytingAlgebra.disj(Data_HeytingAlgebra.heytingAlgebraBoolean))(Pulp_Args_Get.getFlag("optimise")(opts)))(Pulp_Args_Get.hasOption("to")(opts)))(function (v6) {
                                                  return Control_Applicative.when(Control_Monad_Aff.applicativeAff)(v6)(bundle(args));
                                              });
                                          });
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          });
      };
  };
  var testBuild = Pulp_Args.runAction(go(TestBuild.value));
  var action = go(NormalBuild.value);
  var build = Pulp_Args.runAction(action);
  exports["action"] = action;
  exports["build"] = build;
  exports["testBuild"] = testBuild;
  exports["withOutputStream"] = withOutputStream;
})(PS["Pulp.Build"] = PS["Pulp.Build"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Map = PS["Data.Map"];
  var Data_StrMap = PS["Data.StrMap"];
  var Data_String = PS["Data.String"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Node_Path = PS["Node.Path"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_Process = PS["Node.Process"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_Files = PS["Pulp.Files"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_System_Files = PS["Pulp.System.Files"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Data_Function = PS["Data.Function"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];        
  var prependPath = function (newPath) {
      return function (paths) {
          return Data_Maybe.Just.create((function () {
              if (paths instanceof Data_Maybe.Nothing) {
                  return newPath;
              };
              if (paths instanceof Data_Maybe.Just) {
                  return newPath + (Node_Path.delimiter + paths.value0);
              };
              throw new Error("Failed pattern match at Pulp.Run line 61, column 10 - line 63, column 46: " + [ paths.constructor.name ]);
          })());
      };
  };

  /**
 *  | Given a build path, create an environment that is just like this process'
 *  | environment, except with NODE_PATH set up for commands like `pulp run`.
 */  
  var setupEnv = function (buildPath) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.getEnv))(function (v) {
          return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Data_StrMap.alter(prependPath(Node_Path.resolve([  ])(buildPath)))("NODE_PATH")(v));
      });
  };

  /**
 *  | Escape a string for insertion into a JS string literal.
 */  
  var jsEscape = function ($22) {
      return Data_String.replace("'")("\\'")(Data_String.replace("\\")("\\\\")($22));
  };

  /**
 *  | Construct a JS string to be used as an entry point from a module name.
 */  
  var makeEntry = function (main) {
      return "require('" + (jsEscape(main) + "').main();\n");
  };
  var action = function (args) {
      var opts = Data_Map.union(Data_Ord.ordString)(args.globalOpts)(args.commandOpts);
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.cwd))(function (v1) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(v.log("Building project in" + v1))(function () {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Files.defaultGlobs(opts))(function (v2) {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("buildPath")(opts))(function (v3) {
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Exec.psc(Pulp_Files.sources(v2))([ "-o", v3 ])(Data_Maybe.Nothing.value))(function () {
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(v.log("Build successful."))(function () {
                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("main")(opts))(function (v4) {
                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Buffer.fromString(makeEntry(v4))(Node_Encoding.UTF8.value)))(function (v5) {
                                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_Files.openTemp({
                                              prefix: "pulp-run", 
                                              suffix: ".js"
                                          }))(function (v6) {
                                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.fdAppend(v6.fd)(v5))(function () {
                                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.fdClose(v6.fd))(function () {
                                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("runtime")(opts))(function (v7) {
                                                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(setupEnv(v3))(function (v8) {
                                                              return Pulp_Exec.exec(v7)(Data_Semigroup.append(Data_Semigroup.semigroupArray)([ v6.path ])(args.remainder))(new Data_Maybe.Just(v8));
                                                          });
                                                      });
                                                  });
                                              });
                                          });
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          });
      });
  };
  exports["action"] = action;
  exports["jsEscape"] = jsEscape;
  exports["makeEntry"] = makeEntry;
  exports["prependPath"] = prependPath;
  exports["setupEnv"] = setupEnv;
})(PS["Pulp.Run"] = PS["Pulp.Run"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Map = PS["Data.Map"];
  var Data_Foreign = PS["Data.Foreign"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_Build = PS["Pulp.Build"];
  var Pulp_Run = PS["Pulp.Run"];
  var Pulp_System_Files = PS["Pulp.System.Files"];
  var Data_Ord = PS["Data.Ord"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Data_Eq = PS["Data.Eq"];
  var Control_Category = PS["Control.Category"];
  var Data_Function = PS["Data.Function"];
  var Data_Semigroup = PS["Data.Semigroup"];        
  var action = function (args) {
      var opts = Data_Map.union(Data_Ord.ordString)(args.globalOpts)(args.commandOpts);
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("runtime")(opts))(function (v1) {
              var isNode = v1 === "node";
              var changeOpts = (function () {
                  if (isNode) {
                      return Control_Category.id(Control_Category.categoryFn);
                  };
                  if (!isNode) {
                      return Data_Map.insert(Data_Ord.ordString)("to")(new Data_Maybe.Just(Data_Foreign.toForeign("./output/test.js")));
                  };
                  throw new Error("Failed pattern match at Pulp.Test line 30, column 20 - line 32, column 80: " + [ isNode.constructor.name ]);
              })();
              var buildArgs = (function () {
                  var $11 = {};
                  for (var $12 in args) {
                      if ({}.hasOwnProperty.call(args, $12)) {
                          $11[$12] = args[$12];
                      };
                  };
                  $11.remainder = [  ];
                  $11.commandOpts = changeOpts(args.commandOpts);
                  return $11;
              })();
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Build.testBuild(buildArgs))(function () {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(v.log("Running tests..."))(function () {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)((function () {
                          if (isNode) {
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("main")(opts))(function (v2) {
                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("buildPath")(opts))(function (v3) {
                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Run.setupEnv(v3))(function (v4) {
                                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_Files.openTemp({
                                              prefix: "pulp-test", 
                                              suffix: ".js"
                                          }))(function (v5) {
                                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Buffer.fromString(Pulp_Run.makeEntry(v2))(Node_Encoding.UTF8.value)))(function (v6) {
                                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.fdAppend(v5.fd)(v6))(function () {
                                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.fdClose(v5.fd))(function () {
                                                          return Pulp_Exec.exec(v1)(Data_Semigroup.append(Data_Semigroup.semigroupArray)([ v5.path ])(args.remainder))(new Data_Maybe.Just(v4));
                                                      });
                                                  });
                                              });
                                          });
                                      });
                                  });
                              });
                          };
                          if (!isNode) {
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("to")(buildArgs.commandOpts))(function (v2) {
                                  return Pulp_Exec.exec(v1)(Data_Semigroup.append(Data_Semigroup.semigroupArray)([ v2 ])(args.remainder))(Data_Maybe.Nothing.value);
                              });
                          };
                          throw new Error("Failed pattern match at Pulp.Test line 40, column 3 - line 54, column 52: " + [ isNode.constructor.name ]);
                      })())(function () {
                          return v.log("Tests OK.");
                      });
                  });
              });
          });
      });
  };
  exports["action"] = action;
})(PS["Pulp.Test"] = PS["Pulp.Test"] || {});
(function(exports) {
  // module Pulp.Browserify

  "use strict";

  function write(input, output, callback) {
    var pipe = require("through")();
    input.pipe(pipe);
    pipe.pipe(output, {end: false});
    pipe.on("end", callback);
  }

  exports["browserifyBundle'"] = function browserifyBundle$prime(opts, callback) {
    var StringStream = require("string-stream");
    var browserify = require("browserify");

    var b = browserify({
      basedir: opts.basedir,
      entries: new StringStream(opts.src),
      standalone: opts.standalone
    });
    if (opts.transform) b.transform(opts.transform);
    write(b.bundle(), opts.out, callback);
  };

  exports["browserifyIncBundle'"] = function browserifyIncBundle$prime(opts, callback) {
    var browserifyInc = require("browserify-incremental");

    var b = browserifyInc({
      basedir: opts.buildPath,
      cacheFile: opts.cachePath,
      standalone: opts.standalone
    });
    b.add(opts.path);
    if (opts.transform) b.transform(opts.transform);
    write(b.bundle(), opts.out, callback);
  };
})(PS["Pulp.Browserify"] = PS["Pulp.Browserify"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Pulp.Browserify"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Map = PS["Data.Map"];
  var Data_Nullable = PS["Data.Nullable"];
  var Node_Path = PS["Node.Path"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_Process = PS["Node.Process"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Stream = PS["Pulp.System.Stream"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_Files = PS["Pulp.Files"];
  var Pulp_Build = PS["Pulp.Build"];
  var Pulp_Run = PS["Pulp.Run"];
  var Pulp_Project = PS["Pulp.Project"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Function = PS["Data.Function"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Ord = PS["Data.Ord"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Data_Monoid = PS["Data.Monoid"];        

  /**
 *  | Given the build path, modify this process' NODE_PATH environment variable
 *  | for browserify.
 */  
  var setupNodePath = function (buildPath) {
      return function __do() {
          var v = Node_Process.lookupEnv("NODE_PATH")();
          var buildPath$prime = Node_Path.resolve([  ])(buildPath);
          return Node_Process.setEnv("NODE_PATH")((function () {
              if (v instanceof Data_Maybe.Just) {
                  return buildPath$prime + (Node_Path.delimiter + v.value0);
              };
              if (v instanceof Data_Maybe.Nothing) {
                  return buildPath$prime;
              };
              throw new Error("Failed pattern match at Pulp.Browserify line 142, column 5 - line 144, column 28: " + [ v.constructor.name ]);
          })())();
      };
  };
  var makeOptExport = function (main) {
      return "module.exports = PS[\"" + (Pulp_Run.jsEscape(main) + "\"];\n");
  };
  var makeExport = function (main) {
      return function ($$export) {
          if ($$export) {
              return "module.exports = require(\"" + (Pulp_Run.jsEscape(main) + "\");\n");
          };
          if (!$$export) {
              return Pulp_Run.makeEntry(main);
          };
          throw new Error("Failed pattern match at Pulp.Browserify line 45, column 3 - line 47, column 22: " + [ $$export.constructor.name ]);
      };
  };
  var buildForBrowserify = function (args) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("skipCompile")(args.commandOpts))(function (v) {
          return Control_Applicative.when(Control_Monad_Aff.applicativeAff)(!v)((function () {
              var munge = function ($54) {
                  return Data_Map["delete"](Data_Ord.ordString)("optimise")(Data_Map["delete"](Data_Ord.ordString)("to")($54));
              };
              return Pulp_Build.build((function () {
                  var $27 = {};
                  for (var $28 in args) {
                      if ({}.hasOwnProperty.call(args, $28)) {
                          $27[$28] = args[$28];
                      };
                  };
                  $27.commandOpts = munge(args.commandOpts);
                  $27.remainder = [  ];
                  return $27;
              })());
          })());
      });
  };
  var browserifyIncBundle = function (opts) {
      return Pulp_System_FFI.runNode(Data_Function_Uncurried.runFn2($foreign["browserifyIncBundle'"])(opts));
  };
  var incremental = function (args) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          var opts = Data_Map.union(Data_Ord.ordString)(args.globalOpts)(args.commandOpts);
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(v.log("Browserifying..."))(function () {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("buildPath")(opts))(function (v1) {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(setupNodePath(v1)))(function () {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("force")(opts))(function (v2) {
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Pulp_Project.isForeignProject)("_project")(opts))(function (v3) {
                              var cachePath = Node_Path.resolve([ v3.cache ])("browserify.json");
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Applicative.when(Control_Monad_Aff.applicativeAff)(v2)(Control_Monad_Aff.apathize(Node_FS_Aff.unlink(cachePath))))(function () {
                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)("transform")(opts))(function (v4) {
                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)("standalone")(opts))(function (v5) {
                                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("skipEntryPoint")(opts))(function (v6) {
                                              var skipEntryPoint = v6 && Data_Maybe.isNothing(v5);
                                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("main")(opts))(function (v7) {
                                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)((function () {
                                                      if (skipEntryPoint) {
                                                          return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Node_Path.concat([ v1, v7 ]));
                                                      };
                                                      if (!skipEntryPoint) {
                                                          var entryJs = makeExport(v7)(Data_Maybe.isJust(v5));
                                                          var entryPath = Node_Path.concat([ v1, "browserify.js" ]);
                                                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.writeTextFile(Node_Encoding.UTF8.value)(entryPath)(entryJs))(function () {
                                                              return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(entryPath);
                                                          });
                                                      };
                                                      throw new Error("Failed pattern match at Pulp.Browserify line 116, column 11 - line 123, column 29: " + [ skipEntryPoint.constructor.name ]);
                                                  })())(function (v8) {
                                                      return Pulp_Build.withOutputStream(opts)(function (out$prime) {
                                                          return browserifyIncBundle({
                                                              basedir: v1, 
                                                              cacheFile: cachePath, 
                                                              path: v8, 
                                                              transform: Data_Nullable.toNullable(v4), 
                                                              standalone: Data_Nullable.toNullable(v5), 
                                                              out: out$prime
                                                          });
                                                      });
                                                  });
                                              });
                                          });
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          });
      });
  };
  var browserifyBundle = function (opts) {
      return Pulp_System_FFI.runNode(Data_Function_Uncurried.runFn2($foreign["browserifyBundle'"])(opts));
  };
  var optimising = function (args) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          var opts = Data_Map.union(Data_Ord.ordString)(args.globalOpts)(args.commandOpts);
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Files.defaultGlobs(opts))(function (v1) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("buildPath")(opts))(function (v2) {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("main")(opts))(function (v3) {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)("transform")(opts))(function (v4) {
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)("standalone")(opts))(function (v5) {
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("skipEntryPoint")(opts))(function (v6) {
                                  var skipEntryPoint = v6 || Data_Maybe.isJust(v5);
                                  var bundleArgs = Data_Foldable.fold(Data_Foldable.foldableArray)(Data_Monoid.monoidArray)([ [ "--module=" + v3 ], (function () {
                                      if (skipEntryPoint) {
                                          return [  ];
                                      };
                                      if (!skipEntryPoint) {
                                          return [ "--main=" + v3 ];
                                      };
                                      throw new Error("Failed pattern match at Pulp.Browserify line 75, column 11 - line 75, column 61: " + [ skipEntryPoint.constructor.name ]);
                                  })(), args.remainder ]);
                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Exec.pscBundle(Pulp_Files.outputModules(v2))(bundleArgs)(Data_Maybe.Nothing.value))(function (v7) {
                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(v.log("Browserifying..."))(function () {
                                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(setupNodePath(v2)))(function () {
                                              return Pulp_Build.withOutputStream(opts)(function (out$prime) {
                                                  return browserifyBundle({
                                                      basedir: Node_Path.resolve([  ])(v2), 
                                                      src: v7 + (function () {
                                                          var $49 = Data_Maybe.isJust(v5);
                                                          if ($49) {
                                                              return makeOptExport(v3);
                                                          };
                                                          if (!$49) {
                                                              return "";
                                                          };
                                                          throw new Error("Failed pattern match at Pulp.Browserify line 88, column 27 - line 89, column 7: " + [ $49.constructor.name ]);
                                                      })(), 
                                                      transform: Data_Nullable.toNullable(v4), 
                                                      standalone: Data_Nullable.toNullable(v5), 
                                                      out: out$prime
                                                  });
                                              });
                                          });
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          });
      });
  };
  var action = function (args) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.cwd))(function (v1) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(v.log("Browserifying project in " + v1))(function () {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("optimise")(args.commandOpts))(function (v2) {
                      var act = (function () {
                          if (v2) {
                              return optimising;
                          };
                          if (!v2) {
                              return incremental;
                          };
                          throw new Error("Failed pattern match at Pulp.Browserify line 36, column 13 - line 36, column 57: " + [ v2.constructor.name ]);
                      })();
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(buildForBrowserify(args))(function () {
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args.runAction(act)(args))(function () {
                              return v.log("Browserified.");
                          });
                      });
                  });
              });
          });
      });
  };
  exports["action"] = action;
  exports["browserifyBundle"] = browserifyBundle;
  exports["browserifyIncBundle"] = browserifyIncBundle;
  exports["buildForBrowserify"] = buildForBrowserify;
  exports["incremental"] = incremental;
  exports["makeExport"] = makeExport;
  exports["makeOptExport"] = makeOptExport;
  exports["optimising"] = optimising;
  exports["setupNodePath"] = setupNodePath;
})(PS["Pulp.Browserify"] = PS["Pulp.Browserify"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Array = PS["Data.Array"];
  var Data_Set = PS["Data.Set"];
  var Data_Map = PS["Data.Map"];
  var Data_String = PS["Data.String"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Traversable = PS["Data.Traversable"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_Process = PS["Node.Process"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_Files = PS["Pulp.Files"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Functor = PS["Data.Functor"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Eq = PS["Data.Eq"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Bind = PS["Control.Bind"];
  var Data_Function = PS["Data.Function"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Ord = PS["Data.Ord"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Monoid = PS["Data.Monoid"];        
  var showModuleName = Data_String.joinWith(".");

  /**
 *  | Given a line in a PureScript source file, attempt to extract its name.
 */  
  var moduleNameFromLine = function ($29) {
      return Data_Functor.map(Data_Maybe.functorMaybe)(function ($30) {
          return Data_String.split(".")(Data_String.takeWhile(function ($31) {
              return !(function (v) {
                  return Data_Foldable.elem(Data_Foldable.foldableArray)(Data_Eq.eqChar)(v)([ " ", "(" ]);
              })($31);
          })($30));
      })(Data_String.stripPrefix("module ")($29));
  };

  /**
 *  | Given a PureScript source file path, extract its module name (or throw
 *  | an error).
 */  
  var extractModuleName = function (path) {
      var go = function ($32) {
          return (function ($33) {
              return Data_Array.head(Data_Array.catMaybes($33));
          })(Data_Functor.map(Data_Functor.functorArray)(moduleNameFromLine)(Data_String.split("\n")($32)));
      };
      return Data_Functor.map(Control_Monad_Aff.functorAff)(go)(Node_FS_Aff.readTextFile(Node_Encoding.UTF8.value)(path));
  };

  /**
 *  | Given a module name, return the file path where its documentation should
 *  | be written to.
 */  
  var docPath = function (mn) {
      return "generated-docs/" + (Data_String.joinWith("/")(mn) + ".md");
  };

  /**
 *  | Given a file path to be included in the documentation, return a --docgen
 *  | argument for it, to be passsed to psc-docs.
 */  
  var makeDocgen = function (path) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(extractModuleName(path))(function (v) {
          return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)((function () {
              if (v instanceof Data_Maybe.Just) {
                  return new Data_Tuple.Tuple([ "--docgen", showModuleName(v.value0) + (":" + docPath(v.value0)) ], [  ]);
              };
              if (v instanceof Data_Maybe.Nothing) {
                  return new Data_Tuple.Tuple([  ], [ path ]);
              };
              throw new Error("Failed pattern match at Pulp.Docs line 62, column 10 - line 66, column 22: " + [ v.constructor.name ]);
          })());
      });
  };
  var action = function (args) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.cwd))(function (v1) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(v.log("Generating documentation in " + v1))(function () {
                  var opts = Data_Map.union(Data_Ord.ordString)(args.globalOpts)(args.commandOpts);
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("withTests")(opts))(function (v2) {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("withDependencies")(opts))(function (v3) {
                          var includeWhen = function (b) {
                              return function (act) {
                                  if (b) {
                                      return act;
                                  };
                                  if (!b) {
                                      return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Data_Set.empty);
                                  };
                                  throw new Error("Failed pattern match at Pulp.Docs line 37, column 27 - line 37, column 60: " + [ b.constructor.name ]);
                              };
                          };
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Apply.apply(Control_Monad_Aff.applyAff)(Data_Functor.map(Control_Monad_Aff.functorAff)(Data_Set.union(Data_Ord.ordString))(includeWhen(v2)(Pulp_Files.testGlobs(opts))))(includeWhen(v3)(Pulp_Files.dependencyGlobs(opts))))(function (v4) {
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Data_Functor.map(Control_Monad_Aff.functorAff)(Data_Set.union(Data_Ord.ordString)(v4))(Pulp_Files.defaultGlobs(opts)))(function (v5) {
                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Data_Functor.map(Control_Monad_Aff.functorAff)(Data_Set.union(Data_Ord.ordString)(v4))(Pulp_Files.localGlobs(opts)))(function (v6) {
                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Files.resolveGlobs(Pulp_Files.sources(v6)))(function (v7) {
                                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Data_Functor.map(Control_Monad_Aff.functorAff)(Data_Foldable.fold(Data_Foldable.foldableArray)(Data_Tuple.monoidTuple(Data_Monoid.monoidArray)(Data_Monoid.monoidArray)))(Data_Traversable.traverse(Data_Traversable.traversableArray)(Control_Monad_Aff.applicativeAff)(makeDocgen)(v7)))(function (v8) {
                                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Applicative.unless(Control_Monad_Aff.applicativeAff)(Data_Array["null"](v8.value1))(Control_Bind.bind(Control_Monad_Aff.bindAff)(v.err("Unable to extract module name from the following modules:"))(function () {
                                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Data_Foldable.for_(Control_Monad_Aff.applicativeAff)(Data_Foldable.foldableArray)(v8.value1)(function ($34) {
                                                      return v.log((function (v9) {
                                                          return "  " + v9;
                                                      })($34));
                                                  }))(function () {
                                                      return v.err("This may be a bug.");
                                                  });
                                              })))(function () {
                                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Exec.execQuiet("psc-docs")(Data_Semigroup.append(Data_Semigroup.semigroupArray)(args.remainder)(Data_Semigroup.append(Data_Semigroup.semigroupArray)(Pulp_Files.sources(v5))(v8.value0)))(Data_Maybe.Nothing.value))(function (v9) {
                                                      return v.log("Documentation generated.");
                                                  });
                                              });
                                          });
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          });
      });
  };
  exports["action"] = action;
  exports["docPath"] = docPath;
  exports["extractModuleName"] = extractModuleName;
  exports["makeDocgen"] = makeDocgen;
  exports["moduleNameFromLine"] = moduleNameFromLine;
  exports["showModuleName"] = showModuleName;
})(PS["Pulp.Docs"] = PS["Pulp.Docs"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Map = PS["Data.Map"];
  var Data_Set = PS["Data.Set"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_Files = PS["Pulp.Files"];
  var Data_Ord = PS["Data.Ord"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Semigroup = PS["Data.Semigroup"];        
  var action = function (args) {
      var opts = Data_Map.union(Data_Ord.ordString)(args.globalOpts)(args.commandOpts);
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Apply.apply(Control_Monad_Aff.applyAff)(Data_Functor.map(Control_Monad_Aff.functorAff)(Data_Set.union(Data_Ord.ordString))(Pulp_Files.defaultGlobs(opts)))(Pulp_Files.testGlobs(opts)))(function (v) {
          return Pulp_Exec.execInteractive("psci")(Data_Semigroup.append(Data_Semigroup.semigroupArray)(Pulp_Files.sources(v))(args.remainder))(Data_Maybe.Nothing.value);
      });
  };
  exports["action"] = action;
})(PS["Pulp.Psci"] = PS["Pulp.Psci"] || {});
(function(exports) {
    "use strict";

  exports["new"] = function(path) {
    return function() {
      var s = require('node-static');
      return new s.Server(path);
    };
  };

  exports.serve = function(server) {
    return function(req) {
      return function(res) {
        return function() {
          server.serve(req, res);
        };
      };
    };
  };

  exports.serveFile = function(server) {
    return function(file) {
      return function(statusCode) {
        return function(req) {
          return function(res) {
            return function() {
              server.serveFile(file, statusCode, {}, req, res);
            };
          };
        };
      };
    };
  };
})(PS["Pulp.System.StaticServer"] = PS["Pulp.System.StaticServer"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Pulp.System.StaticServer"];
  var Prelude = PS["Prelude"];
  var Node_HTTP = PS["Node.HTTP"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  exports["new"] = $foreign["new"];
  exports["serve"] = $foreign.serve;
  exports["serveFile"] = $foreign.serveFile;
})(PS["Pulp.System.StaticServer"] = PS["Pulp.System.StaticServer"] || {});
(function(exports) {
  // module Pulp.Watch

  "use strict";

  exports.watch = function watch(directories) {
    return function(act) {
      return function() {
        var Watchpack = require("watchpack");
        var watchpack = new Watchpack();
        watchpack.watch([], directories, Date.now() - 10000);
        watchpack.on("change", function(path) {
          act(path)();
        });
      };
    };
  };

  exports.minimatch = function(str) {
    return function(glob) {
      return require("minimatch")(str, glob);
    };
  };
})(PS["Pulp.Watch"] = PS["Pulp.Watch"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Unsafe_Coerce = PS["Unsafe.Coerce"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Control_Applicative = PS["Control.Applicative"];        
  var $$throw = function (dictMonadError) {
      return function ($2) {
          return Control_Monad_Error_Class.throwError(dictMonadError)(Control_Monad_Eff_Exception.error($2));
      };
  };
  var removeErrLabel = Unsafe_Coerce.unsafeCoerce;
  var orErr = function (dictMonadError) {
      return function (msg) {
          return Data_Maybe.maybe($$throw(dictMonadError)(msg))(Control_Applicative.pure((dictMonadError["__superclass_Control.Monad.Monad_0"]())["__superclass_Control.Applicative.Applicative_0"]()));
      };
  };
  exports["orErr"] = orErr;
  exports["removeErrLabel"] = removeErrLabel;
})(PS["Pulp.Utils"] = PS["Pulp.Utils"] || {});
(function(exports) {
  // module Pulp.System.TreeKill
  "use strict";

  exports.treeKill = function treeKill(pid) {
    return function(signal) {
      return function() {
        require("tree-kill")(pid, signal);
      };
    };
  };
})(PS["Pulp.System.TreeKill"] = PS["Pulp.System.TreeKill"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Pulp.System.TreeKill"];
  var Prelude = PS["Prelude"];
  var Data_Posix = PS["Data.Posix"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  exports["treeKill"] = $foreign.treeKill;
})(PS["Pulp.System.TreeKill"] = PS["Pulp.System.TreeKill"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Pulp.Watch"];
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Control_Monad_Aff_AVar = PS["Control.Monad.Aff.AVar"];
  var Control_Monad_Eff_Now = PS["Control.Monad.Eff.Now"];
  var Control_Comonad = PS["Control.Comonad"];
  var Data_Array = PS["Data.Array"];
  var Data_Map = PS["Data.Map"];
  var Data_Set = PS["Data.Set"];
  var Node_Process = PS["Node.Process"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Eff_Ref = PS["Control.Monad.Eff.Ref"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Time_Duration = PS["Data.Time.Duration"];
  var Data_DateTime = PS["Data.DateTime"];
  var Data_Traversable = PS["Data.Traversable"];
  var Node_ChildProcess = PS["Node.ChildProcess"];
  var Node_Globals = PS["Node.Globals"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Files = PS["Pulp.Files"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_Utils = PS["Pulp.Utils"];
  var Pulp_System_TreeKill = PS["Pulp.System.TreeKill"];
  var Control_Bind = PS["Control.Bind"];
  var Data_Function = PS["Data.Function"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Bounded = PS["Data.Bounded"];
  var Data_DateTime_Locale = PS["Data.DateTime.Locale"];
  var Data_Ord = PS["Data.Ord"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Eq = PS["Data.Eq"];
  var Control_Apply = PS["Control.Apply"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];        

  /**
 *  Returns Nothing if the given Options did not include the relevant options
 *  i.e. watching does not make sense with this command.
 */  
  var watchDirectories = function (opts) {
      var basicPathOpts = [ "srcPath", "testPath", "dependencyPath" ];
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Data_Traversable.traverse(Data_Traversable.traversableArray)(Control_Monad_Aff.applicativeAff)(Data_Function.flip(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign))(opts))(basicPathOpts))(function (v) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Data_Functor.map(Control_Monad_Aff.functorAff)(Data_Maybe.fromMaybe([  ]))(Pulp_Args_Get.getOption(Data_Foreign_Class.arrayIsForeign(Data_Foreign_Class.stringIsForeign))("includePaths")(opts)))(function (v1) {
              return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Data_Functor.map(Data_Maybe.functorMaybe)(function (v2) {
                  return Data_Semigroup.append(Data_Semigroup.semigroupArray)(v2)(v1);
              })(Data_Traversable.sequence(Data_Traversable.traversableArray)(Data_Maybe.applicativeMaybe)(v)));
          });
      });
  };

  /**
 *  | Ensure that a callback is only called at some given maximum frequency,
 *  | by returning a new callback that does nothing if an attempt is made to
 *  | perform it again sooner than the given duration since the last attempt.
 */  
  var debounce = function (cooldown) {
      return function (callback) {
          return function __do() {
              var v = Control_Monad_Eff_Ref.newRef(Data_Bounded.bottom(Data_DateTime.boundedDateTime))();
              return function (info) {
                  return function __do() {
                      var v1 = Control_Monad_Eff_Ref.readRef(v)();
                      var v2 = Data_Functor.map(Control_Monad_Eff.functorEff)(Control_Comonad.extract(Data_DateTime_Locale.comonadLocalValue))(Control_Monad_Eff_Now.nowDateTime)();
                      return Control_Applicative.when(Control_Monad_Eff.applicativeEff)(Data_Ord.greaterThan(Data_Time_Duration.ordMilliseconds)(Data_DateTime.diff(Data_Time_Duration.durationMilliseconds)(v2)(v1))(cooldown))(function __do() {
                          Control_Monad_Eff_Ref.writeRef(v)(v2)();
                          return callback(info)();
                      })();
                  };
              };
          };
      };
  };
  var watchAff = function (dirs) {
      return function (callback) {
          return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(function __do() {
              var v = debounce(100.0)(function ($26) {
                  return (function ($27) {
                      return Data_Functor["void"](Control_Monad_Eff.functorEff)(Control_Monad_Aff.launchAff($27));
                  })(Pulp_Utils.removeErrLabel(callback($26)));
              })();
              return $foreign.watch(dirs)(v)();
          });
      };
  };
  var action = function (args) {
      var opts = Data_Map.union(Data_Ord.ordString)(args.globalOpts)(args.commandOpts);
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Bind.bind(Control_Monad_Aff.bindAff)(watchDirectories(opts))(Pulp_Utils.orErr(Control_Monad_Aff.monadErrorAff)("This command does not work with --watch")))(function (v1) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Data_Functor.map(Control_Monad_Eff.functorEff)(function ($28) {
                  return Data_Array.filter(function (v2) {
                      return Data_Foldable.notElem(Data_Foldable.foldableArray)(Data_Eq.eqString)(v2)([ "-w", "--watch" ]);
                  })(Data_Array.drop(2)($28));
              })(Node_Process.argv)))(function (v2) {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff_AVar.makeVar)(function (v3) {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_ChildProcess.fork(Node_Globals.__filename)(v2)))(Control_Monad_Aff_AVar.putVar(v3)))(function () {
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Apply.apply(Control_Monad_Aff.applyAff)(Data_Functor.map(Control_Monad_Aff.functorAff)(Data_Set.union(Data_Ord.ordString))(Pulp_Files.defaultGlobs(opts)))(Pulp_Files.testGlobs(opts)))(function (v4) {
                              var fileGlobs = Data_Semigroup.append(Data_Semigroup.semigroupArray)(Pulp_Files.sources(v4))(Pulp_Files.ffis(v4));
                              return watchAff(v1)(function (path) {
                                  return Control_Applicative.when(Control_Monad_Aff.applicativeAff)(Data_Foldable.any(Data_Foldable.foldableArray)(Data_HeytingAlgebra.heytingAlgebraBoolean)($foreign.minimatch(path))(fileGlobs))(Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff_AVar.takeVar(v3))(function (v5) {
                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Pulp_System_TreeKill.treeKill(Node_ChildProcess.pid(v5))("SIGTERM")))(function () {
                                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(v.write("---\n"))(function () {
                                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(v.log("Source tree changed; restarting:"))(function () {
                                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_ChildProcess.fork(Node_Globals.__filename)(v2)))(Control_Monad_Aff_AVar.putVar(v3));
                                              });
                                          });
                                      });
                                  }));
                              });
                          });
                      });
                  });
              });
          });
      });
  };
  exports["action"] = action;
  exports["watchAff"] = watchAff;
  exports["watchDirectories"] = watchDirectories;
})(PS["Pulp.Watch"] = PS["Pulp.Watch"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Either = PS["Data.Either"];
  var Data_Map = PS["Data.Map"];
  var Data_Foreign = PS["Data.Foreign"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Aff_AVar = PS["Control.Monad.Aff.AVar"];
  var Node_HTTP = PS["Node.HTTP"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_Stream = PS["Node.Stream"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_StaticServer = PS["Pulp.System.StaticServer"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Watch = PS["Pulp.Watch"];
  var Pulp_Build = PS["Pulp.Build"];
  var Pulp_Utils = PS["Pulp.Utils"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Ord = PS["Data.Ord"];
  var Control_Category = PS["Control.Category"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Function = PS["Data.Function"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Show = PS["Data.Show"];        
  var Succeeded = (function () {
      function Succeeded() {

      };
      Succeeded.value = new Succeeded();
      return Succeeded;
  })();
  var Failed = (function () {
      function Failed() {

      };
      Failed.value = new Failed();
      return Failed;
  })();
  var rebuildWith = function (v) {
      return function (args) {
          var addExtras = function ($41) {
              return (function () {
                  if (v.quiet) {
                      return Data_Map.insert(Data_Ord.ordString)("_silenced")(Data_Maybe.Nothing.value);
                  };
                  if (!v.quiet) {
                      return Control_Category.id(Control_Category.categoryFn);
                  };
                  throw new Error("Failed pattern match at Pulp.Server line 106, column 9 - line 106, column 59: " + [ v.quiet.constructor.name ]);
              })()(Data_Map.insert(Data_Ord.ordString)("to")(new Data_Maybe.Just(Data_Foreign.toForeign(v.bundleFileName)))($41));
          };
          return Pulp_Build.build((function () {
              var $18 = {};
              for (var $19 in args) {
                  if ({}.hasOwnProperty.call(args, $19)) {
                      $18[$19] = args[$19];
                  };
              };
              $18.commandOpts = addExtras(args.commandOpts);
              return $18;
          })());
      };
  };
  var listen = function (server) {
      return function (opts) {
          return Control_Monad_Aff.makeAff(function (v) {
              return function (done) {
                  return Node_HTTP.listen(server)(opts)(done(Data_Unit.unit));
              };
          });
      };
  };
  var getBundleFileName = function (opts) {
      return Data_Functor.map(Control_Monad_Aff.functorAff)(function (v) {
          return v + "/app.js";
      })(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("buildPath")(opts));
  };
  var createServer = function (rebuildV) {
      return function (bundleFileName) {
          return function __do() {
              var v = Pulp_System_StaticServer["new"](".")();
              return Node_HTTP.createServer(function (req) {
                  return function (res) {
                      var $25 = Node_HTTP.requestURL(req);
                      if ($25 === "/app.js") {
                          return Data_Functor["void"](Control_Monad_Eff.functorEff)(Pulp_System_FFI.unsafeToEffN(Control_Monad_Aff.launchAff(Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff_AVar.peekVar(rebuildV))(function (v1) {
                              return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)((function () {
                                  if (v1 instanceof Succeeded) {
                                      return Pulp_System_StaticServer.serveFile(v)(bundleFileName)(200)(req)(res);
                                  };
                                  if (v1 instanceof Failed) {
                                      return function __do() {
                                          Node_HTTP.setStatusCode(res)(400)();
                                          Node_HTTP.setStatusMessage(res)("Rebuild failed")();
                                          var resS = Node_HTTP.responseAsStream(res);
                                          return Data_Functor["void"](Control_Monad_Eff.functorEff)(Node_Stream.writeString(resS)(Node_Encoding.UTF8.value)("Compile error in pulp server")(Node_Stream.end(resS)(Control_Applicative.pure(Control_Monad_Eff.applicativeEff)(Data_Unit.unit))))();
                                      };
                                  };
                                  throw new Error("Failed pattern match at Pulp.Server line 81, column 21 - line 90, column 46: " + [ v1.constructor.name ]);
                              })());
                          }))));
                      };
                      return Pulp_System_StaticServer.serve(v)(req)(res);
                  };
              })();
          };
      };
  };
  var action = function (args) {
      var opts = Data_Map.union(Data_Ord.ordString)(args.globalOpts)(args.commandOpts);
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(getBundleFileName(opts))(function (v1) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("host")(opts))(function (v2) {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.intIsForeign)("port")(opts))(function (v3) {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff_AVar.makeVar)(function (v4) {
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(createServer(v4)(v1)))(function (v5) {
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(listen(v5)({
                                  hostname: v2, 
                                  port: v3, 
                                  backlog: Data_Maybe.Nothing.value
                              }))(function () {
                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(v.log("Server listening on http://" + (v2 + (":" + (Data_Show.show(Data_Show.showInt)(v3) + "/")))))(function () {
                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("quiet")(opts))(function (v6) {
                                          var rebuild = Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff.attempt(rebuildWith({
                                              bundleFileName: v1, 
                                              quiet: v6
                                          })(args)))(function (v7) {
                                              if (v7 instanceof Data_Either.Right) {
                                                  return Control_Monad_Aff_AVar.putVar(v4)(Succeeded.value);
                                              };
                                              if (v7 instanceof Data_Either.Left) {
                                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff_AVar.putVar(v4)(Failed.value))(function () {
                                                      return v.err("Failed to rebuild; try to fix the compile errors");
                                                  });
                                              };
                                              throw new Error("Failed pattern match at Pulp.Server line 58, column 9 - line 64, column 3: " + [ v7.constructor.name ]);
                                          });
                                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(rebuild)(function () {
                                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Watch.watchDirectories(opts))(Pulp_Utils.orErr(Control_Monad_Aff.monadErrorAff)("Internal error: unexpected Nothing")))(function (v7) {
                                                  return Pulp_Watch.watchAff(v7)(function (v8) {
                                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Data_Functor["void"](Control_Monad_Aff.functorAff)(Control_Monad_Aff_AVar.takeVar(v4)))(function () {
                                                          return rebuild;
                                                      });
                                                  });
                                              });
                                          });
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          });
      });
  };
  exports["action"] = action;
})(PS["Pulp.Server"] = PS["Pulp.Server"] || {});
(function(exports) {
    "use strict";
  var http =require("http");
  var https =require("https"); 

  exports.requestImpl = function (opts) {
    return function (k) {
      return function () {
        var lib = opts.protocol === "https:" ? https : http;
        return lib.request(opts, function (res) {
          k(res)();
        });
      };
    };
  };
})(PS["Node.HTTP.Client"] = PS["Node.HTTP.Client"] || {});
(function(exports) {
  // Generated by psc version 0.10.4

  /**
 *  | This module defines low-level bindings to the Node HTTP client.
 */  
  "use strict";
  var $foreign = PS["Node.HTTP.Client"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Functor_Contravariant = PS["Data.Functor.Contravariant"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Options = PS["Data.Options"];
  var Data_StrMap = PS["Data.StrMap"];
  var Node_HTTP = PS["Node.HTTP"];
  var Node_Stream = PS["Node.Stream"];
  var Node_URL = PS["Node.URL"];
  var Unsafe_Coerce = PS["Unsafe.Coerce"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Function = PS["Data.Function"];
  var Data_Op = PS["Data.Op"];

  /**
 *  | Get the response status message
 */  
  var statusMessage = function ($6) {
      return (function (v) {
          return v.statusMessage;
      })(Unsafe_Coerce.unsafeCoerce($6));
  };

  /**
 *  | Get the response status code
 */  
  var statusCode = function ($7) {
      return (function (v) {
          return v.statusCode;
      })(Unsafe_Coerce.unsafeCoerce($7));
  };

  /**
 *  | Create a readable stream from a response object.
 */  
  var responseAsStream = Unsafe_Coerce.unsafeCoerce;

  /**
 *  | Create a writable stream from a request object.
 */  
  var requestAsStream = Unsafe_Coerce.unsafeCoerce;

  /**
 *  | Make a HTTP request using the specified options and response callback.
 */  
  var request = function ($9) {
      return $foreign.requestImpl(Data_Options.options($9));
  };                                                              

  /**
 *  | The protocol to use
 */  
  var protocol = Data_Options.opt("protocol");

  /**
 *  | The request path, including query string if appropriate.
 */  
  var path = Data_Options.opt("path");

  /**
 *  | The HTTP request method: GET, POST, etc.
 */  
  var method = Data_Options.opt("method");

  /**
 *  | Domain name or IP
 */  
  var hostname = Data_Options.opt("hostname");
  var headers = Data_Options.opt("headers");
  exports["headers"] = headers;
  exports["hostname"] = hostname;
  exports["method"] = method;
  exports["path"] = path;
  exports["protocol"] = protocol;
  exports["request"] = request;
  exports["requestAsStream"] = requestAsStream;
  exports["responseAsStream"] = responseAsStream;
  exports["statusCode"] = statusCode;
  exports["statusMessage"] = statusMessage;
})(PS["Node.HTTP.Client"] = PS["Node.HTTP.Client"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Options = PS["Data.Options"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_HTTP_Client = PS["Node.HTTP.Client"];
  var Node_Stream = PS["Node.Stream"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Unit = PS["Data.Unit"];        
  var httpRequest = function (reqOptions) {
      return function (reqBody) {
          var maybeWrite = function (v) {
              return function (v1) {
                  return function (next) {
                      if (v1 instanceof Data_Maybe.Just) {
                          return Data_Functor["void"](Control_Monad_Eff.functorEff)(Node_Stream.write(v)(v1.value0)(next));
                      };
                      if (v1 instanceof Data_Maybe.Nothing) {
                          return next;
                      };
                      throw new Error("Failed pattern match at Pulp.System.HTTP line 23, column 3 - line 23, column 76: " + [ v.constructor.name, v1.constructor.name, next.constructor.name ]);
                  };
              };
          };
          return Control_Monad_Aff.makeAff(function (err) {
              return function (done) {
                  return function __do() {
                      var v = Node_HTTP_Client.request(reqOptions)(done)();
                      var reqStream = Node_HTTP_Client.requestAsStream(v);
                      Node_Stream.onError(reqStream)(err)();
                      return maybeWrite(reqStream)(reqBody)(Node_Stream.end(reqStream)(Control_Applicative.pure(Control_Monad_Eff.applicativeEff)(Data_Unit.unit)))();
                  };
              };
          });
      };
  };
  exports["httpRequest"] = httpRequest;
})(PS["Pulp.System.HTTP"] = PS["Pulp.System.HTTP"] || {});
(function(exports) {
  // module Pulp.System.Read

  "use strict";

  exports["read'"] = require("read");
})(PS["Pulp.System.Read"] = PS["Pulp.System.Read"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Pulp.System.Read"];
  var Prelude = PS["Prelude"];
  var Data_Function_Uncurried = PS["Data.Function.Uncurried"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Data_Function = PS["Data.Function"];        
  var read = function (opts) {
      return Pulp_System_FFI.runNode(Data_Function_Uncurried.runFn2($foreign["read'"])(opts));
  };
  exports["read"] = read;
})(PS["Pulp.System.Read"] = PS["Pulp.System.Read"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Except = PS["Control.Monad.Except"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Tuple_Nested = PS["Data.Tuple.Nested"];
  var Data_Either = PS["Data.Either"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Data_String = PS["Data.String"];
  var Data_StrMap = PS["Data.StrMap"];
  var Data_Options = PS["Data.Options"];
  var Node_Process = PS["Node.Process"];
  var Node_Platform = PS["Node.Platform"];
  var Node_Path = PS["Node.Path"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_FS_Perms = PS["Node.FS.Perms"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_HTTP_Client = PS["Node.HTTP.Client"];
  var Pulp_System_HTTP = PS["Pulp.System.HTTP"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Stream = PS["Pulp.System.Stream"];
  var Pulp_System_Files = PS["Pulp.System.Files"];
  var Pulp_System_Read = PS["Pulp.System.Read"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Version = PS["Pulp.Version"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Eq = PS["Data.Eq"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Apply = PS["Control.Apply"];
  var Data_Semiring = PS["Data.Semiring"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Function = PS["Data.Function"];
  var Data_Show = PS["Data.Show"];
  var Control_Monad_Except_Trans = PS["Control.Monad.Except.Trans"];
  var Data_Identity = PS["Data.Identity"];
  var Data_Foreign_Index = PS["Data.Foreign.Index"];
  var Data_List_Types = PS["Data.List.Types"];        
  var obtainTokenFromStdin = function (out) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.write("Please obtain a GitHub personal access token at:\n"))(function () {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.write("  https://github.com/settings/tokens/new\n"))(function () {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.write("No scopes are required, so don't check any of the boxes.\n"))(function () {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.write("\n"))(function () {
                      return Data_Functor.map(Control_Monad_Aff.functorAff)(Data_String.trim)(Pulp_System_Read.read({
                          prompt: "After you've done that, paste it in here: ", 
                          silent: true
                      }));
                  });
              });
          });
      });
  };
  var getHome = (function () {
      var homeVar = (function () {
          var $6 = Data_Eq.eq(Node_Platform.eqPlatform)(Node_Process.platform)(Node_Platform.Win32.value);
          if ($6) {
              return "USERPROFILE";
          };
          if (!$6) {
              return "HOME";
          };
          throw new Error("Failed pattern match at Pulp.Login line 113, column 17 - line 114, column 3: " + [ $6.constructor.name ]);
      })();
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.lookupEnv(homeVar)))(function (v) {
          if (v instanceof Data_Maybe.Just) {
              return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(v.value0);
          };
          if (v instanceof Data_Maybe.Nothing) {
              return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("The " + (homeVar + " environment variable is not set.")));
          };
          throw new Error("Failed pattern match at Pulp.Login line 115, column 3 - line 120, column 66: " + [ v.constructor.name ]);
      });
  })();
  var tokenFilePath = Control_Apply.apply(Control_Monad_Aff.applyAff)(Data_Functor.map(Control_Monad_Aff.functorAff)(Data_Semigroup.append(Data_Semigroup.semigroupString))(getHome))(Control_Applicative.pure(Control_Monad_Aff.applicativeAff)("/.pulp/github-oauth-token"));
  var writeTokenFile = function (token) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(tokenFilePath)(function (v) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_Files.mkdirIfNotExist(Node_Path.dirname(v)))(function () {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.writeTextFile(Node_Encoding.UTF8.value)(v)(token))(function () {
                  return Node_FS_Aff.chmod(v)(Node_FS_Perms.mkPerms(Data_Semiring.add(Node_FS_Perms.semiringPerm)(Node_FS_Perms.read)(Node_FS_Perms.write))(Node_FS_Perms.none)(Node_FS_Perms.none));
              });
          });
      });
  };
  var checkToken = function (out) {
      return function (token) {
          var reqOptions = Data_Foldable.fold(Data_Foldable.foldableArray)(Data_Options.monoidOptions)([ Data_Options.assoc(Node_HTTP_Client.protocol)("https:"), Data_Options.assoc(Node_HTTP_Client.hostname)("api.github.com"), Data_Options.assoc(Node_HTTP_Client.path)("/user"), Data_Options.assoc(Node_HTTP_Client.headers)(Data_StrMap.fromFoldable(Data_Foldable.foldableArray)([ new Data_Tuple.Tuple("Accept", "application/vnd.github.v3+json"), new Data_Tuple.Tuple("Authorization", "token " + token), new Data_Tuple.Tuple("User-Agent", "Pulp-" + Pulp_Version.versionString) ])) ]);
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_HTTP.httpRequest(reqOptions)(Data_Maybe.Nothing.value))(function (v) {
              var statusCode = Node_HTTP_Client.statusCode(v);
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_Stream.concatStream(Node_HTTP_Client.responseAsStream(v)))(function (v1) {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Applicative.unless(Control_Monad_Aff.applicativeAff)(statusCode === 200)(Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error((function () {
                      if (statusCode === 401) {
                          return "Your token was not accepted (401 Unauthorized).";
                      };
                      var header = "Something went wrong (HTTP " + (Data_Show.show(Data_Show.showInt)(statusCode) + (" " + (Node_HTTP_Client.statusMessage(v) + ").")));
                      return header + ("\n" + v1);
                  })()))))(function () {
                      var $14 = Control_Monad_Except.runExcept(Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Data_Foreign.parseJSON(v1))(Data_Foreign_Class.readProp(Data_Foreign_Class.stringIsForeign)(Data_Foreign_Index.indexString)("login")));
                      if ($14 instanceof Data_Either.Right) {
                          return out.write("Successfully authenticated as " + ($14.value0 + ".\n"));
                      };
                      if ($14 instanceof Data_Either.Left) {
                          return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Unexpected response from GitHub API: " + Data_Show.show(Data_List_Types.showNonEmptyList(Data_Foreign.showForeignError))($14.value0)));
                      };
                      throw new Error("Failed pattern match at Pulp.Login line 82, column 3 - line 86, column 79: " + [ $14.constructor.name ]);
                  });
              });
          });
      };
  };

  /**
 *  TODO: Obtain tokens automatically after prompting for a username and
 *  password.
 * 
 *  Unfortunately it is not easy to do this without exposing the client secret,
 *  so I think we need to add a route to Pursuit itself to support this, so that
 *  Pursuit sort of proxies to GitHub and adds its client secret itself.
 */  
  var action = function (args) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(obtainTokenFromStdin(v))(function (v1) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(checkToken(v)(v1))(function () {
                  return writeTokenFile(v1);
              });
          });
      });
  };
  exports["action"] = action;
  exports["tokenFilePath"] = tokenFilePath;
})(PS["Pulp.Login"] = PS["Pulp.Login"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Function = PS["Data.Function"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Either = PS["Data.Either"];
  var Data_Array = PS["Data.Array"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Version = PS["Data.Version"];
  var Data_String = PS["Data.String"];
  var Node_ChildProcess = PS["Node.ChildProcess"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Control_Bind = PS["Control.Bind"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Unit = PS["Data.Unit"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Functor = PS["Data.Functor"];
  var Data_Ord = PS["Data.Ord"];        

  /**
 *  | Throw an error if the git working tree is dirty.
 */  
  var requireCleanGitWorkingTree = Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Exec.execQuiet("git")([ "status", "--porcelain" ])(Data_Maybe.Nothing.value))(function (v) {
      var $2 = Data_Foldable.all(Data_Foldable.foldableArray)(Data_HeytingAlgebra.heytingAlgebraBoolean)(Data_String["null"])(Data_String.split("\n")(v));
      if ($2) {
          return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Data_Unit.unit);
      };
      if (!$2) {
          return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Your git working tree is dirty. Please commit or stash your changes " + "first."));
      };
      throw new Error("Failed pattern match at Pulp.Git line 25, column 3 - line 31, column 1: " + [ $2.constructor.name ]);
  });
  var dropPrefix = function (prefix) {
      return function (str) {
          return Data_Maybe.fromMaybe(str)(Data_String.stripPrefix(prefix)(str));
      };
  };

  /**
 *  | Given a number of lines of text, attempt to parse each line as a version,
 *  | and return the maximum.
 */  
  var maxVersion = (function () {
      var parseMay = function (str) {
          return Data_Functor.map(Data_Maybe.functorMaybe)(Data_Tuple.Tuple.create(str))(Data_Either.either(Data_Function["const"](Data_Maybe.Nothing.value))(Data_Maybe.Just.create)(Data_Version.parseVersion(dropPrefix("v")(str))));
      };
      return function ($3) {
          return Data_Foldable.maximumBy(Data_Foldable.foldableArray)(Data_Function.on(Data_Ord.compare(Data_Version.ordVersion))(Data_Tuple.snd))(Data_Array.mapMaybe(function ($4) {
              return parseMay(Data_String.trim($4));
          })(Data_String.split("\n")($3)));
      };
  })();

  /**
 *  | Get the most recently tagged version from the git tag.
 */  
  var getVersionFromGitTag = (function () {
    
      /**
     *  Run a command, piping stderr to /dev/null
     */  
      var run = Pulp_Exec.execQuietWithStderr(Node_ChildProcess.Ignore.value);
      return Data_Functor.map(Control_Monad_Aff.functorAff)(Data_Either.either(Data_Function["const"](Data_Maybe.Nothing.value))(maxVersion))(Control_Monad_Aff.attempt(run("git")([ "describe", "--tags", "--abbrev=0", "HEAD" ])(Data_Maybe.Nothing.value)));
  })();
  exports["dropPrefix"] = dropPrefix;
  exports["getVersionFromGitTag"] = getVersionFromGitTag;
  exports["maxVersion"] = maxVersion;
  exports["requireCleanGitWorkingTree"] = requireCleanGitWorkingTree;
})(PS["Pulp.Git"] = PS["Pulp.Git"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Either = PS["Data.Either"];
  var Data_List = PS["Data.List"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Version = PS["Data.Version"];
  var Data_String = PS["Data.String"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_VersionBump = PS["Pulp.VersionBump"];
  var Pulp_System_Read = PS["Pulp.System.Read"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Git = PS["Pulp.Git"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_List_Types = PS["Data.List.Types"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Function = PS["Data.Function"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Data_Functor = PS["Data.Functor"];        
  var untilJust = function (dictMonad) {
      return function (act) {
          return Control_Bind.bind(dictMonad["__superclass_Control.Bind.Bind_1"]())(act)(function (v) {
              if (v instanceof Data_Maybe.Just) {
                  return Control_Applicative.pure(dictMonad["__superclass_Control.Applicative.Applicative_0"]())(v.value0);
              };
              if (v instanceof Data_Maybe.Nothing) {
                  return untilJust(dictMonad)(act);
              };
              throw new Error("Failed pattern match at Pulp.BumpVersion line 139, column 3 - line 143, column 20: " + [ v.constructor.name ]);
          });
      };
  };
  var tagNewVersion = function (version) {
      var versionStr = "v" + Data_Version.showVersion(version);
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Exec.exec("git")([ "commit", "--allow-empty", "--message=" + versionStr ])(Data_Maybe.Nothing.value))(function () {
          return Pulp_Exec.exec("git")([ "tag", "--annotate", "--message=" + versionStr, versionStr ])(Data_Maybe.Nothing.value);
      });
  };

  /**
 *  | Prompt and ask the user what to use as the initial version.
 */  
  var promptInitial = function (out) {
      var vers = function (major) {
          return function (minor) {
              return function (patch) {
                  return Data_Version.version(major)(minor)(patch)(Data_List_Types.Nil.value)(Data_List_Types.Nil.value);
              };
          };
      };
      var initialOptions = [ new Data_Tuple.Tuple("a", vers(1)(0)(0)), new Data_Tuple.Tuple("b", vers(0)(1)(0)), new Data_Tuple.Tuple("c", vers(0)(0)(1)) ];
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.log("Initial version"))(function () {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.write("You can release this code as:\n"))(function () {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Data_Foldable.for_(Control_Monad_Aff.applicativeAff)(Data_Foldable.foldableArray)(initialOptions)(function (v) {
                  return out.write(v.value0 + (") v" + (Data_Version.showVersion(v.value1) + "\n")));
              }))(function () {
                  return untilJust(Control_Monad_Aff.monadAff)(Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_Read.read({
                      prompt: "Choose one, or enter a specific version:", 
                      silent: false
                  }))(function (v) {
                      var $19 = Data_Tuple.lookup(Data_Foldable.foldableArray)(Data_Eq.eqString)(Data_String.toLower(v))(initialOptions);
                      if ($19 instanceof Data_Maybe.Just) {
                          return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(new Data_Maybe.Just($19.value0));
                      };
                      if ($19 instanceof Data_Maybe.Nothing) {
                          var $21 = Data_Version.parseVersion(Pulp_Git.dropPrefix("v")(v));
                          if ($21 instanceof Data_Either.Right) {
                              return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(new Data_Maybe.Just($21.value0));
                          };
                          if ($21 instanceof Data_Either.Left) {
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.log("Sorry, that choice wasn't understood."))(function () {
                                  return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Data_Maybe.Nothing.value);
                              });
                          };
                          throw new Error("Failed pattern match at Pulp.BumpVersion line 89, column 9 - line 94, column 25: " + [ $21.constructor.name ]);
                      };
                      throw new Error("Failed pattern match at Pulp.BumpVersion line 85, column 5 - line 94, column 25: " + [ $19.constructor.name ]);
                  }));
              });
          });
      });
  };
  var promptCurrent = function (out) {
      return function (current) {
          var bumpOptions = [ new Data_Tuple.Tuple("a", Pulp_VersionBump.Major.value), new Data_Tuple.Tuple("b", Pulp_VersionBump.Minor.value), new Data_Tuple.Tuple("c", Pulp_VersionBump.Patch.value) ];
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.log("The current version is v" + Data_Version.showVersion(current)))(function () {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.write("You can bump the version to:\n"))(function () {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Data_Foldable.for_(Control_Monad_Aff.applicativeAff)(Data_Foldable.foldableArray)(bumpOptions)(function (v) {
                      return out.write(v.value0 + (") v" + (Data_Version.showVersion(Pulp_VersionBump.applyBump(v.value1)(current)) + "\n")));
                  }))(function () {
                      return untilJust(Control_Monad_Aff.monadAff)(Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_Read.read({
                          prompt: "Choose one, or enter a specific version:", 
                          silent: false
                      }))(function (v) {
                          var $28 = Data_Tuple.lookup(Data_Foldable.foldableArray)(Data_Eq.eqString)(Data_String.toLower(v))(bumpOptions);
                          if ($28 instanceof Data_Maybe.Just) {
                              return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(new Data_Maybe.Just(Pulp_VersionBump.applyBump($28.value0)(current)));
                          };
                          if ($28 instanceof Data_Maybe.Nothing) {
                              var $30 = Data_Version.parseVersion(Pulp_Git.dropPrefix("v")(v));
                              if ($30 instanceof Data_Either.Right) {
                                  return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(new Data_Maybe.Just($30.value0));
                              };
                              if ($30 instanceof Data_Either.Left) {
                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.log("Sorry, that choice wasn't understood."))(function () {
                                      return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Data_Maybe.Nothing.value);
                                  });
                              };
                              throw new Error("Failed pattern match at Pulp.BumpVersion line 122, column 9 - line 127, column 25: " + [ $30.constructor.name ]);
                          };
                          throw new Error("Failed pattern match at Pulp.BumpVersion line 118, column 5 - line 127, column 25: " + [ $28.constructor.name ]);
                      }));
                  });
              });
          });
      };
  };
  var internalError = function (msg) {
      return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Internal error in Pulp.BumpVersion: " + (msg + ("\n" + "This is a bug. Please report it.\n"))));
  };

  /**
 *  | Try running `psc-publish --dry-run` to make sure the code is suitable for
 *  | release.
 */  
  var checkPscPublish = function (out) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.log("Checking your package using psc-publish..."))(function () {
          return Pulp_Exec.exec("psc-publish")([ "--dry-run" ])(Data_Maybe.Nothing.value);
      });
  };

  /**
 *  | Returns the new version that we should bump to.
 */  
  var bumpVersion = function (args) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)("bump")(args.commandArgs))(function (v) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Data_Functor.map(Control_Monad_Aff.functorAff)(Data_Functor.map(Data_Maybe.functorMaybe)(Data_Tuple.snd))(Pulp_Git.getVersionFromGitTag))(function (v1) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v2) {
                  if (v instanceof Data_Maybe.Just) {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Data_Maybe.maybe(internalError("invalid bump"))(Control_Applicative.pure(Control_Monad_Aff.applicativeAff))(Pulp_VersionBump.parseBump(v.value0)))(function (v3) {
                          return Data_Maybe.maybe(promptInitial(v2))(function ($41) {
                              return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Pulp_VersionBump.applyBump(v3)($41));
                          })(v1);
                      });
                  };
                  if (v instanceof Data_Maybe.Nothing) {
                      return Data_Maybe.maybe(promptInitial(v2))(promptCurrent(v2))(v1);
                  };
                  throw new Error("Failed pattern match at Pulp.BumpVersion line 48, column 3 - line 54, column 61: " + [ v.constructor.name ]);
              });
          });
      });
  };
  var action = function (args) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Git.requireCleanGitWorkingTree)(function () {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(checkPscPublish(v))(function () {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(bumpVersion(args))(function (v1) {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(tagNewVersion(v1))(function () {
                          return v.log("Bumped to: v" + Data_Version.showVersion(v1));
                      });
                  });
              });
          });
      });
  };
  exports["action"] = action;
})(PS["Pulp.BumpVersion"] = PS["Pulp.BumpVersion"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Except = PS["Control.Monad.Except"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Tuple = PS["Data.Tuple"];
  var Data_Tuple_Nested = PS["Data.Tuple.Nested"];
  var Data_Either = PS["Data.Either"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Data_Version = PS["Data.Version"];
  var Data_String = PS["Data.String"];
  var Data_StrMap = PS["Data.StrMap"];
  var Data_Options = PS["Data.Options"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_ChildProcess = PS["Node.ChildProcess"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_HTTP_Client = PS["Node.HTTP.Client"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_HTTP = PS["Pulp.System.HTTP"];
  var Pulp_System_Stream = PS["Pulp.System.Stream"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_System_Files = PS["Pulp.System.Files"];
  var Pulp_System_Read = PS["Pulp.System.Read"];
  var Pulp_Git = PS["Pulp.Git"];
  var Pulp_Login = PS["Pulp.Login"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Applicative = PS["Control.Applicative"];
  var Data_Unit = PS["Data.Unit"];
  var Data_Show = PS["Data.Show"];
  var Data_List_Types = PS["Data.List.Types"];
  var Control_Monad_Except_Trans = PS["Control.Monad.Except.Trans"];
  var Data_Identity = PS["Data.Identity"];
  var Data_Foreign_Index = PS["Data.Foreign.Index"];
  var uploadPursuitDocs = function (out) {
      return function (authToken) {
          return function (gzippedJson) {
              var headers = Data_StrMap.fromFoldable(Data_Foldable.foldableArray)([ new Data_Tuple.Tuple("Accept", "application/json"), new Data_Tuple.Tuple("Authorization", "token " + authToken), new Data_Tuple.Tuple("Content-Encoding", "gzip") ]);
              var reqOptions = Data_Foldable.fold(Data_Foldable.foldableArray)(Data_Options.monoidOptions)([ Data_Options.assoc(Node_HTTP_Client.method)("POST"), Data_Options.assoc(Node_HTTP_Client.protocol)("https:"), Data_Options.assoc(Node_HTTP_Client.hostname)("pursuit.purescript.org"), Data_Options.assoc(Node_HTTP_Client.path)("/packages"), Data_Options.assoc(Node_HTTP_Client.headers)(headers) ]);
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_HTTP.httpRequest(reqOptions)(new Data_Maybe.Just(gzippedJson)))(function (v) {
                  var $19 = Node_HTTP_Client.statusCode(v);
                  if ($19 === 201) {
                      return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Data_Unit.unit);
                  };
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Bind.bindFlipped(Control_Monad_Aff.bindAff)(out.err)(Pulp_System_Stream.concatStream(Node_HTTP_Client.responseAsStream(v))))(function () {
                      return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Expected an HTTP 201 response from Pursuit, got: " + Data_Show.show(Data_Show.showInt)($19)));
                  });
              });
          };
      };
  };
  var readTokenFile = Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Login.tokenFilePath)(function (v) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff.attempt(Node_FS_Aff.readTextFile(Node_Encoding.UTF8.value)(v)))(function (v1) {
          if (v1 instanceof Data_Either.Right) {
              return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(v1.value0);
          };
          if (v1 instanceof Data_Either.Left && Pulp_System_Files.isENOENT(v1.value0)) {
              return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Pursuit authentication token not found. Try running `pulp login` " + "first."));
          };
          if (v1 instanceof Data_Either.Left) {
              return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(v1.value0);
          };
          throw new Error("Failed pattern match at Pulp.Publish line 145, column 3 - line 153, column 21: " + [ v1.constructor.name ]);
      });
  });
  var readBowerJson = Control_Bind.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.readTextFile(Node_Encoding.UTF8.value)("bower.json"))(function (v) {
      var $27 = Control_Monad_Except.runExcept(Data_Foreign.parseJSON(v));
      if ($27 instanceof Data_Either.Right) {
          return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)($27.value0);
      };
      if ($27 instanceof Data_Either.Left) {
          return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Unable to parse bower.json:" + Data_Show.show(Data_List_Types.showNonEmptyList(Data_Foreign.showForeignError))($27.value0)));
      };
      throw new Error("Failed pattern match at Pulp.Publish line 116, column 3 - line 121, column 52: " + [ $27.constructor.name ]);
  });
  var pursuitUrl = function (name) {
      return function (vers) {
          return "https://pursuit.purescript.org/packages/" + (name + ("/" + Data_Version.showVersion(vers)));
      };
  };
  var pscPublish = Pulp_Exec.execQuiet("psc-publish")([  ])(Data_Maybe.Nothing.value);
  var gzip = function (str) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Pulp_System_Stream.createGzip))(function (v) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_Stream.write(v)(str))(function () {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_Stream.end(v))(function () {
                  return Pulp_System_Stream.concatStreamToBuffer(v);
              });
          });
      });
  };
  var getBowerRepositoryUrl = function (v) {
      var $32 = Control_Monad_Except.runExcept(Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Data_Foreign_Class.readProp(Data_Foreign_Class.foreignIsForeign)(Data_Foreign_Index.indexString)("repository")(v))(Data_Foreign_Class.readProp(Data_Foreign_Class.stringIsForeign)(Data_Foreign_Index.indexString)("url")));
      if ($32 instanceof Data_Either.Right) {
          return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)($32.value0);
      };
      if ($32 instanceof Data_Either.Left) {
          return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Unable to read property 'repository.url' from bower.json:" + Data_Show.show(Data_List_Types.showNonEmptyList(Data_Foreign.showForeignError))($32.value0)));
      };
      throw new Error("Failed pattern match at Pulp.Publish line 134, column 3 - line 139, column 82: " + [ $32.constructor.name ]);
  };
  var getBowerName = function (v) {
      var $36 = Control_Monad_Except.runExcept(Data_Foreign_Class.readProp(Data_Foreign_Class.stringIsForeign)(Data_Foreign_Index.indexString)("name")(v));
      if ($36 instanceof Data_Either.Right) {
          return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)($36.value0);
      };
      if ($36 instanceof Data_Either.Left) {
          return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Unable to read property 'name' from bower.json:" + Data_Show.show(Data_List_Types.showNonEmptyList(Data_Foreign.showForeignError))($36.value0)));
      };
      throw new Error("Failed pattern match at Pulp.Publish line 125, column 3 - line 130, column 72: " + [ $36.constructor.name ]);
  };
  var confirm = function (q) {
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_Read.read({
          prompt: q + " [y/n] ", 
          silent: false
      }))(function (v) {
          var $40 = Data_String.trim(Data_String.toLower(v));
          if ($40 === "y") {
              return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Data_Unit.unit);
          };
          return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Aborted"));
      });
  };
  var confirmRun = function (out) {
      return function (cmd) {
          return function (args) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.log("About to execute:"))(function () {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.write("> " + (cmd + (" " + (Data_String.joinWith(" ")(args) + "\n")))))(function () {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(confirm("Ok?"))(function () {
                          return Pulp_Exec.exec(cmd)(args)(Data_Maybe.Nothing.value);
                      });
                  });
              });
          };
      };
  };
  var registerOnBowerIfNecessary = function (out) {
      return function (name) {
          return function (repoUrl) {
            
              /**
             *  Run a command, sending stderr to /dev/null
             */  
              var run = Pulp_Exec.execQuietWithStderr(Node_ChildProcess.Ignore.value);
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff.attempt(run("bower")([ "info", name, "--json" ])(Data_Maybe.Nothing.value)))(function (v) {
                  if (v instanceof Data_Either.Left) {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.log("Registering your package on Bower..."))(function () {
                          return confirmRun(out)("bower")([ "register", name, repoUrl ]);
                      });
                  };
                  if (v instanceof Data_Either.Right) {
                      return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Data_Unit.unit);
                  };
                  throw new Error("Failed pattern match at Pulp.Publish line 162, column 3 - line 168, column 16: " + [ v.constructor.name ]);
              });
          };
      };
  };

  /**
 *  TODO:
 *  * Check that the 'origin' remote matches with bower.json
 *  * Better handling for the situation where the person running 'pulp publish'
 *    doesn't actually own the repo.
 */  
  var action = (function () {
      var getVersion = Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Git.getVersionFromGitTag)(Data_Maybe.maybe(Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Internal error: No version could be extracted from the git tags" + (" in this repository. This should not have happened. Please" + " report this: https://github.com/bodil/pulp/issues/new"))))(Control_Applicative.pure(Control_Monad_Aff.applicativeAff)));
      return function (args) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Git.requireCleanGitWorkingTree)(function () {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(readTokenFile)(function (v1) {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Bind.bind(Control_Monad_Aff.bindAff)(pscPublish)(gzip))(function (v2) {
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(getVersion)(function (v3) {
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(readBowerJson)(function (v4) {
                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(getBowerName(v4))(function (v5) {
                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(confirm("Publishing " + (v5 + (" at v" + (Data_Version.showVersion(v3.value1) + ". Is this ok?")))))(function () {
                                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("noPush")(args.commandOpts))(function (v6) {
                                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Applicative.unless(Control_Monad_Aff.applicativeAff)(v6)(Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get["getOption'"](Data_Foreign_Class.stringIsForeign)("pushTo")(args.commandOpts))(function (v7) {
                                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(confirmRun(v)("git")([ "push", v7, "HEAD", "refs/tags/" + v3.value0 ]))(function () {
                                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(getBowerRepositoryUrl(v4))(function (v8) {
                                                          return registerOnBowerIfNecessary(v)(v5)(v8);
                                                      });
                                                  });
                                              })))(function () {
                                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(v.log("Uploading documentation to Pursuit..."))(function () {
                                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(uploadPursuitDocs(v)(v1)(v2))(function () {
                                                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(v.log("Done."))(function () {
                                                              return v.log("You can view your package's documentation at: " + pursuitUrl(v5)(v3.value1));
                                                          });
                                                      });
                                                  });
                                              });
                                          });
                                      });
                                  });
                              });
                          });
                      });
                  });
              });
          });
      };
  })();
  exports["action"] = action;
})(PS["Pulp.Publish"] = PS["Pulp.Publish"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var Prelude = PS["Prelude"];
  var Data_Maybe = PS["Data.Maybe"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_Buffer = PS["Node.Buffer"];
  var Node_FS_Aff = PS["Node.FS.Aff"];
  var Node_Process = PS["Node.Process"];
  var Node_Platform = PS["Node.Platform"];
  var Pulp_Exec = PS["Pulp.Exec"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_System_Files = PS["Pulp.System.Files"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Control_Bind = PS["Control.Bind"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Data_Function = PS["Data.Function"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Data_Eq = PS["Data.Eq"];        
  var shell$prime = function (out) {
      return function (cmd) {
          return function (opts) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.log("Executing " + cmd))(function () {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Buffer.fromString(cmd)(Node_Encoding.UTF8.value)))(function (v) {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_System_Files.openTemp({
                          prefix: "pulp-cmd-", 
                          suffix: opts.extension
                      }))(function (v1) {
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.fdAppend(v1.fd)(v))(function () {
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Node_FS_Aff.fdClose(v1.fd))(function () {
                                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Exec.exec(opts.executable)(Data_Semigroup.append(Data_Semigroup.semigroupArray)(opts.extraArgs)([ v1.path ]))(Data_Maybe.Nothing.value))(function () {
                                      return out.log("Done.");
                                  });
                              });
                          });
                      });
                  });
              });
          };
      };
  };
  var shell = function (out) {
      return function (cmd) {
          var $4 = Data_Eq.eq(Node_Platform.eqPlatform)(Node_Process.platform)(Node_Platform.Win32.value);
          if ($4) {
              return shell$prime(out)(cmd)({
                  extension: ".cmd", 
                  executable: "cmd", 
                  extraArgs: [ "/s", "/c" ]
              });
          };
          if (!$4) {
              return shell$prime(out)(cmd)({
                  extension: ".sh", 
                  executable: "sh", 
                  extraArgs: [  ]
              });
          };
          throw new Error("Failed pattern match at Pulp.Shell line 20, column 3 - line 30, column 14: " + [ $4.constructor.name ]);
      };
  };
  exports["shell"] = shell;
})(PS["Pulp.Shell"] = PS["Pulp.Shell"] || {});
(function(exports) {
  // Generated by psc version 0.10.4
  "use strict";
  var $foreign = PS["Main"];
  var Prelude = PS["Prelude"];
  var Control_Monad_Aff = PS["Control.Monad.Aff"];
  var Control_Monad_Eff_Class = PS["Control.Monad.Eff.Class"];
  var Control_Monad_Eff_Console = PS["Control.Monad.Eff.Console"];
  var Control_Monad_Eff_Unsafe = PS["Control.Monad.Eff.Unsafe"];
  var Control_Monad_Eff_Exception = PS["Control.Monad.Eff.Exception"];
  var Control_Monad_Error_Class = PS["Control.Monad.Error.Class"];
  var Control_Monad_Except = PS["Control.Monad.Except"];
  var Data_Maybe = PS["Data.Maybe"];
  var Data_Either = PS["Data.Either"];
  var Data_Map = PS["Data.Map"];
  var Data_Foreign = PS["Data.Foreign"];
  var Data_Foreign_Class = PS["Data.Foreign.Class"];
  var Data_Array = PS["Data.Array"];
  var Data_Foldable = PS["Data.Foldable"];
  var Data_List = PS["Data.List"];
  var Data_Version = PS["Data.Version"];
  var Data_String = PS["Data.String"];
  var Text_Parsing_Parser = PS["Text.Parsing.Parser"];
  var Node_Encoding = PS["Node.Encoding"];
  var Node_FS_Sync = PS["Node.FS.Sync"];
  var Node_Path = PS["Node.Path"];
  var Node_Process = PS["Node.Process"];
  var Pulp_Args = PS["Pulp.Args"];
  var Pulp_Args_Get = PS["Pulp.Args.Get"];
  var Pulp_Args_Help = PS["Pulp.Args.Help"];
  var Pulp_Args_Types = PS["Pulp.Args.Types"];
  var Pulp_Args_Parser = PS["Pulp.Args.Parser"];
  var Pulp_System_FFI = PS["Pulp.System.FFI"];
  var Pulp_Outputter = PS["Pulp.Outputter"];
  var Pulp_Validate = PS["Pulp.Validate"];
  var Pulp_Version = PS["Pulp.Version"];
  var Pulp_Project = PS["Pulp.Project"];
  var Pulp_Init = PS["Pulp.Init"];
  var Pulp_Build = PS["Pulp.Build"];
  var Pulp_Run = PS["Pulp.Run"];
  var Pulp_Test = PS["Pulp.Test"];
  var Pulp_Browserify = PS["Pulp.Browserify"];
  var Pulp_Docs = PS["Pulp.Docs"];
  var Pulp_Psci = PS["Pulp.Psci"];
  var Pulp_Server = PS["Pulp.Server"];
  var Pulp_Login = PS["Pulp.Login"];
  var Pulp_BumpVersion = PS["Pulp.BumpVersion"];
  var Pulp_Publish = PS["Pulp.Publish"];
  var Pulp_Watch = PS["Pulp.Watch"];
  var Pulp_Shell = PS["Pulp.Shell"];
  var Data_Function = PS["Data.Function"];
  var Control_Applicative = PS["Control.Applicative"];
  var Control_Monad_Eff = PS["Control.Monad.Eff"];
  var Data_Unit = PS["Data.Unit"];
  var Control_Bind = PS["Control.Bind"];
  var Data_Eq = PS["Data.Eq"];
  var Data_Ord = PS["Data.Ord"];
  var Data_HeytingAlgebra = PS["Data.HeytingAlgebra"];
  var Data_Semigroup = PS["Data.Semigroup"];
  var Control_Monad_Except_Trans = PS["Control.Monad.Except.Trans"];
  var Data_Identity = PS["Data.Identity"];
  var Data_Foreign_Index = PS["Data.Foreign.Index"];
  var Data_Show = PS["Data.Show"];
  var Data_List_Types = PS["Data.List.Types"];
  var Data_Functor = PS["Data.Functor"];
  var Control_Semigroupoid = PS["Control.Semigroupoid"];        
  var succeeded = Data_Function["const"](Control_Applicative.pure(Control_Monad_Eff.applicativeEff)(Data_Unit.unit));
  var runWithArgs = function (args) {
    
      /**
     *  This is really quite gross, especially with _project. Not sure exactly
     *  how to go about improving this.
     */  
      var runShellForOption = function (option) {
          return function (opts) {
              return function (out) {
                  return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getOption(Data_Foreign_Class.stringIsForeign)(option)(opts))(function (v) {
                      if (v instanceof Data_Maybe.Just) {
                          return Pulp_Shell.shell(out)(v.value0);
                      };
                      if (v instanceof Data_Maybe.Nothing) {
                          return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(Data_Unit.unit);
                      };
                      throw new Error("Failed pattern match at Main line 285, column 5 - line 287, column 28: " + [ v.constructor.name ]);
                  });
              };
          };
      };
      var noProject = [ "init", "login" ];
      var addProject = function (as) {
          var $14 = Data_Foldable.elem(Data_Foldable.foldableArray)(Data_Eq.eqString)(as.command.name)(noProject);
          if ($14) {
              return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)(as);
          };
          if (!$14) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Project.getProject(as.globalOpts))(function (v) {
                  var globalOpts$prime = Data_Map.insert(Data_Ord.ordString)("_project")(new Data_Maybe.Just(Data_Foreign.toForeign(v)))(as.globalOpts);
                  return Control_Applicative.pure(Control_Monad_Aff.applicativeAff)((function () {
                      var $16 = {};
                      for (var $17 in as) {
                          if ({}.hasOwnProperty.call(as, $17)) {
                              $16[$17] = as[$17];
                          };
                      };
                      $16.globalOpts = globalOpts$prime;
                      return $16;
                  })());
              });
          };
          throw new Error("Failed pattern match at Main line 276, column 5 - line 281, column 47: " + [ $14.constructor.name ]);
      };
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Outputter.getOutputter(args))(function (v) {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Validate.validate(v))(function (v1) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Get.getFlag("watch")(args.globalOpts))(function (v2) {
                  var $22 = v2 && args.command.name !== "server";
                  if ($22) {
                      return Pulp_Args.runAction(Pulp_Watch.action)(args);
                  };
                  if (!$22) {
                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(addProject(args))(function (v3) {
                          return Control_Bind.bind(Control_Monad_Aff.bindAff)(runShellForOption("before")(v3.globalOpts)(v))(function () {
                              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Control_Monad_Aff.attempt(Pulp_Args.runAction(args.command.action)(v3)))(function (v4) {
                                  if (v4 instanceof Data_Either.Left) {
                                      return Control_Bind.bind(Control_Monad_Aff.bindAff)(runShellForOption("else")(v3.globalOpts)(v))(function () {
                                          return Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Control_Monad_Eff_Exception.throwException(v4.value0));
                                      });
                                  };
                                  if (v4 instanceof Data_Either.Right) {
                                      return runShellForOption("then")(v3.globalOpts)(v);
                                  };
                                  throw new Error("Failed pattern match at Main line 264, column 7 - line 269, column 56: " + [ v4.constructor.name ]);
                              });
                          });
                      });
                  };
                  throw new Error("Failed pattern match at Main line 257, column 3 - line 269, column 56: " + [ $22.constructor.name ]);
              });
          });
      });
  };
  var requireNodeAtLeast = function (minimum) {
      var stripV = function (str) {
          return Data_Maybe.fromMaybe(str)(Data_String.stripPrefix("v")(str));
      };
      var $28 = Data_Version.parseVersion(stripV(Node_Process.version));
      if ($28 instanceof Data_Either.Left) {
          var message = Text_Parsing_Parser.parseErrorMessage($28.value0);
          return Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Failed to parse node.js version: " + message));
      };
      if ($28 instanceof Data_Either.Right) {
          return Control_Applicative.when(Control_Monad_Aff.applicativeAff)(Data_Ord.lessThan(Data_Version.ordVersion)($28.value0)(minimum))(Control_Monad_Error_Class.throwError(Control_Monad_Aff.monadErrorAff)(Control_Monad_Eff_Exception.error("Your node.js version is too old " + ("(required: " + (Data_Version.showVersion(minimum) + (", actual: " + (Data_Version.showVersion($28.value0) + ")")))))));
      };
      throw new Error("Failed pattern match at Main line 291, column 3 - line 300, column 56: " + [ $28.constructor.name ]);
  };
  var remainderToTest = new Data_Maybe.Just("Passthrough options are sent to the test program. " + "This can be useful for only running one particular test, for instance.");
  var remainderToPsci = new Data_Maybe.Just("Passthrough options are sent to `psci`.");
  var remainderToPscDocs = new Data_Maybe.Just("Passthrough options are sent to `psc-docs`.");
  var remainderToPsc = new Data_Maybe.Just("Passthrough options are sent to `psc`.");
  var remainderToProgram = new Data_Maybe.Just("Passthrough options are sent to your program.");
  var remainderToBundle = new Data_Maybe.Just("Passthrough options are sent to `psc-bundle`.");

  /**
 *  TODO: This is possibly just a temporary separation from buildArgs; at the
 *        moment, the browserify action doesn't support this option, but it's
 *        definitely in the realm of possibility.
 */  
  var moduleArgs = [ Pulp_Args.option("modules")([ "--modules" ])(Pulp_Args_Types.string)("Additional modules to be included in the output bundle (comma-separated list).") ];
  var globals = [ Pulp_Args.option("bowerFile")([ "--bower-file", "-b" ])(Pulp_Args_Types.file)("Read this bower.json file instead of autodetecting it."), Pulp_Args.option("watch")([ "--watch", "-w" ])(Pulp_Args_Types.flag)("Watch source directories and re-run command if something changes."), Pulp_Args.option("monochrome")([ "--monochrome" ])(Pulp_Args_Types.flag)("Don't colourise log output."), Pulp_Args.option("before")([ "--before" ])(Pulp_Args_Types.string)("Run a shell command before the operation begins. Useful with `--watch`, eg. `--watch --before clear`."), Pulp_Args.option("then")([ "--then" ])(Pulp_Args_Types.string)("Run a shell command after the operation finishes successfully. Useful with `--watch`, eg. `--watch --then 'say Done'`"), Pulp_Args.option("else")([ "--else" ])(Pulp_Args_Types.string)("Run a shell command if an operation finishes. Useful with `--watch`, eg. `--watch --then 'say Done' --else 'say Failed'`"), Pulp_Args.option("version")([ "--version", "-v" ])(Pulp_Args_Types.flag)("Show current pulp version.") ];
  var failed = function (err) {
      return function __do() {
          Control_Monad_Eff_Console.error("* ERROR: " + Control_Monad_Eff_Exception.message(err))();
          return Node_Process.exit(1)();
      };
  };
  var defaultDependencyPath = (function () {
      var readFromBowerRc = function __do() {
          var v = Node_FS_Sync.readTextFile(Node_Encoding.UTF8.value)(".bowerrc")();
          var $32 = Control_Monad_Except.runExcept(Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Data_Foreign.parseJSON(v))(Data_Foreign_Class.readProp(Data_Foreign_Class.stringIsForeign)(Data_Foreign_Index.indexString)("directory")));
          if ($32 instanceof Data_Either.Right) {
              return $32.value0;
          };
          if ($32 instanceof Data_Either.Left) {
              return Control_Monad_Eff_Exception.throwException(Control_Monad_Eff_Exception.error(Data_Show.show(Data_List_Types.showNonEmptyList(Data_Foreign.showForeignError))($32.value0)))();
          };
          throw new Error("Failed pattern match at Main line 77, column 5 - line 79, column 53: " + [ $32.constructor.name ]);
      };
      return Control_Monad_Eff_Unsafe.unsafePerformEff(Control_Monad_Eff_Exception.catchException(Data_Function["const"](Control_Applicative.pure(Control_Monad_Eff.applicativeEff)("bower_components")))(readFromBowerRc));
  })();

  /**
 *  | Options for any command requiring paths
 */  
  var pathArgs = [ Pulp_Args.optionDefault("includePaths")([ "--include", "-I" ])(Pulp_Args_Types.directories)("Additional directories for PureScript source files, separated by `" + (Node_Path.delimiter + "`."))([  ]), Pulp_Args.optionDefault("srcPath")([ "--src-path" ])(Pulp_Args_Types.directory)("Directory for PureScript source files.")("src"), Pulp_Args.optionDefault("testPath")([ "--test-path" ])(Pulp_Args_Types.directory)("Directory for PureScript test files.")("test"), Pulp_Args.optionDefault("dependencyPath")([ "--dependency-path" ])(Pulp_Args_Types.directory)("Directory for PureScript dependency files.")(defaultDependencyPath) ];

  /**
 *  | Options common to 'build', 'test', and 'browserify'
 */  
  var buildishArgs = Data_Semigroup.append(Data_Semigroup.semigroupArray)([ Pulp_Args.optionDefault("buildPath")([ "--build-path", "-o" ])(Pulp_Args_Types.string)("Path for compiler output.")("./output"), Pulp_Args.option("noPsa")([ "--no-psa" ])(Pulp_Args_Types.flag)("Do not attempt to use the psa frontend instead of psc") ])(pathArgs);
  var runArgs = Data_Semigroup.append(Data_Semigroup.semigroupArray)([ Pulp_Args.optionDefault("main")([ "--main", "-m" ])(Pulp_Args_Types.string)("Application's entry point.")("Main"), Pulp_Args.option("jobs")([ "--jobs", "-j" ])(Pulp_Args_Types["int"])("Tell psc to use the specified number of cores.") ])(buildishArgs);
  var buildArgs = Data_Semigroup.append(Data_Semigroup.semigroupArray)([ Pulp_Args.option("to")([ "--to", "-t" ])(Pulp_Args_Types.string)("Output file name (stdout if not specified)."), Pulp_Args.option("optimise")([ "--optimise", "-O" ])(Pulp_Args_Types.flag)("Perform dead code elimination."), Pulp_Args.option("skipEntryPoint")([ "--skip-entry-point" ])(Pulp_Args_Types.flag)("Don't add code to automatically invoke Main.") ])(runArgs);
  var commands = [ Pulp_Args.command("init")("Generate an example PureScript project.")(Data_Maybe.Nothing.value)(Pulp_Init.action)([ Pulp_Args.option("force")([ "--force" ])(Pulp_Args_Types.flag)("Overwrite any project found in the current directory.") ]), Pulp_Args.command("build")("Build the project.")(remainderToPsc)(Pulp_Build.action)(Data_Semigroup.append(Data_Semigroup.semigroupArray)(buildArgs)(moduleArgs)), Pulp_Args.command("test")("Run project tests.")(remainderToTest)(Pulp_Test.action)(Data_Semigroup.append(Data_Semigroup.semigroupArray)([ Pulp_Args.optionDefault("main")([ "--main", "-m" ])(Pulp_Args_Types.string)("Test entry point.")("Test.Main"), Pulp_Args.optionDefault("runtime")([ "--runtime", "-r" ])(Pulp_Args_Types.string)("Run test script using this command instead of Node.")("node") ])(buildishArgs)), Pulp_Args.command("browserify")("Produce a deployable bundle using Browserify.")(remainderToBundle)(Pulp_Browserify.action)(Data_Semigroup.append(Data_Semigroup.semigroupArray)([ Pulp_Args.option("transform")([ "--transform" ])(Pulp_Args_Types.string)("Apply a Browserify transform."), Pulp_Args.option("sourceMap")([ "--source-map" ])(Pulp_Args_Types.string)("Generate source maps."), Pulp_Args.option("force")([ "--force" ])(Pulp_Args_Types.flag)("Force a non-incremental build by deleting the build cache."), Pulp_Args.option("standalone")([ "--standalone" ])(Pulp_Args_Types.string)("Output a UMD bundle with the given external module name."), Pulp_Args.option("skipCompile")([ "--skip-compile" ])(Pulp_Args_Types.flag)("Assume PureScript code has already been compiled. Useful for when you want to pass options to psc.") ])(buildArgs)), Pulp_Args.command("run")("Compile and run the project.")(remainderToProgram)(Pulp_Run.action)(Data_Semigroup.append(Data_Semigroup.semigroupArray)([ Pulp_Args.optionDefault("runtime")([ "--runtime", "-r" ])(Pulp_Args_Types.string)("Run the program using this command instead of Node.")("node") ])(runArgs)), Pulp_Args.command("docs")("Generate project documentation.")(remainderToPscDocs)(Pulp_Docs.action)(Data_Semigroup.append(Data_Semigroup.semigroupArray)([ Pulp_Args.option("withTests")([ "--with-tests", "-t" ])(Pulp_Args_Types.flag)("Include tests."), Pulp_Args.option("withDependencies")([ "--with-dependencies", "-d" ])(Pulp_Args_Types.flag)("Include external dependencies.") ])(pathArgs)), Pulp_Args.command("psci")("Launch a PureScript REPL configured for the project.")(remainderToPsci)(Pulp_Psci.action)(pathArgs), Pulp_Args.command("server")("Launch a development server.")(Data_Maybe.Nothing.value)(Pulp_Server.action)(Data_Semigroup.append(Data_Semigroup.semigroupArray)([ Pulp_Args.optionDefault("main")([ "--main", "-m" ])(Pulp_Args_Types.string)("Application's entry point.")("Main"), Pulp_Args.optionDefault("port")([ "--port", "-p" ])(Pulp_Args_Types["int"])("Port number to listen on.")(1337), Pulp_Args.optionDefault("host")([ "--host" ])(Pulp_Args_Types.string)("IP address to bind the server to.")("localhost"), Pulp_Args.option("quiet")([ "--quiet", "-q" ])(Pulp_Args_Types.flag)("Display nothing to the console when rebuilding.") ])(buildishArgs)), Pulp_Args.command("login")("Obtain and store a token for uploading packages to Pursuit.")(Data_Maybe.Nothing.value)(Pulp_Login.action)([  ]), Pulp_Args.commandWithArgs("version")("Bump and tag a new version in preparation for release.")(Data_Maybe.Nothing.value)(Pulp_BumpVersion.action)([  ])([ Pulp_Args.argument("bump")(Pulp_Args_Types.versionBump)("How to bump the version. Acceptable values: 'major', 'minor', 'patch', or any specific version. If omitted, Pulp will prompt you for a version.")(false) ]), Pulp_Args.command("publish")("Publish a previously tagged version to Bower and Pursuit.")(Data_Maybe.Nothing.value)(Pulp_Publish.action)([ Pulp_Args.optionDefault("pushTo")([ "--push-to" ])(Pulp_Args_Types.string)("The Git remote to push commits and tags to.")("origin"), Pulp_Args.option("noPush")([ "--no-push" ])(Pulp_Args_Types.flag)("Skip pushing commits or tags to any remote.") ]) ];
  var main = (function () {
      var out = Pulp_Outputter.makeOutputter(false);
      var handleParseError = function (v) {
          return function (err) {
              if (v instanceof Data_Maybe.Just) {
                  if (Data_Foldable.elem(Data_Foldable.foldableArray)(Data_Eq.eqString)(v.value0)([ "--version", "-v" ])) {
                      return Pulp_Version.printVersion;
                  };
                  if (Data_Foldable.elem(Data_Foldable.foldableArray)(Data_Eq.eqString)(v.value0)([ "--help", "-h" ])) {
                      return Pulp_Args_Help.printHelp(out)(globals)(commands);
                  };
              };
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.err("Error: " + err))(function () {
                  return Pulp_Args_Help.printHelp(out)(globals)(commands);
              });
          };
      };
      return Data_Functor["void"](Control_Monad_Eff.functorEff)(Control_Monad_Aff.runAff(failed)(succeeded)(Control_Bind.bind(Control_Monad_Aff.bindAff)(requireNodeAtLeast(Data_Version.version(4)(0)(0)(Data_List_Types.Nil.value)(Data_List_Types.Nil.value)))(function () {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(Data_Functor.map(Control_Monad_Aff.functorAff)(Data_Array.drop(2))(Control_Monad_Eff_Class.liftEff(Control_Monad_Aff.monadEffAff)(Node_Process.argv)))(function (v) {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(Pulp_Args_Parser.parse(globals)(commands)(v))(function (v1) {
                  if (v1 instanceof Data_Either.Left) {
                      return handleParseError(Data_Array.head(v))(Text_Parsing_Parser.parseErrorMessage(v1.value0));
                  };
                  if (v1 instanceof Data_Either.Right && v1.value0 instanceof Data_Either.Left) {
                      return Pulp_Args_Help.printCommandHelp(out)(globals)(v1.value0.value0);
                  };
                  if (v1 instanceof Data_Either.Right && v1.value0 instanceof Data_Either.Right) {
                      return runWithArgs(v1.value0.value0);
                  };
                  throw new Error("Failed pattern match at Main line 232, column 17 - line 238, column 38: " + [ v1.constructor.name ]);
              });
          });
      })));
  })();
  var argsParserDiagnostics = function (opts) {
      var out = Pulp_Outputter.makeOutputter(false);
      return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.log("Globals: " + Data_Show.show(Data_Map.showMap(Data_Show.showString)(Data_Maybe.showMaybe(Data_Show.showString)))(Data_Functor.map(Data_Map.functorMap)(Data_Functor.map(Data_Maybe.functorMaybe)(Pulp_System_FFI.unsafeInspect))(opts.globalOpts))))(function () {
          return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.log("Command: " + opts.command.name))(function () {
              return Control_Bind.bind(Control_Monad_Aff.bindAff)(out.log("Locals: " + Data_Show.show(Data_Map.showMap(Data_Show.showString)(Data_Maybe.showMaybe(Data_Show.showString)))(Data_Functor.map(Data_Map.functorMap)(Data_Functor.map(Data_Maybe.functorMaybe)(Pulp_System_FFI.unsafeInspect))(opts.commandOpts))))(function () {
                  return out.log("Remainder: " + Data_Show.show(Data_Show.showArray(Data_Show.showString))(opts.remainder));
              });
          });
      });
  };
  exports["argsParserDiagnostics"] = argsParserDiagnostics;
  exports["buildArgs"] = buildArgs;
  exports["buildishArgs"] = buildishArgs;
  exports["commands"] = commands;
  exports["defaultDependencyPath"] = defaultDependencyPath;
  exports["failed"] = failed;
  exports["globals"] = globals;
  exports["main"] = main;
  exports["moduleArgs"] = moduleArgs;
  exports["pathArgs"] = pathArgs;
  exports["remainderToBundle"] = remainderToBundle;
  exports["remainderToProgram"] = remainderToProgram;
  exports["remainderToPsc"] = remainderToPsc;
  exports["remainderToPscDocs"] = remainderToPscDocs;
  exports["remainderToPsci"] = remainderToPsci;
  exports["remainderToTest"] = remainderToTest;
  exports["requireNodeAtLeast"] = requireNodeAtLeast;
  exports["runArgs"] = runArgs;
  exports["runWithArgs"] = runWithArgs;
  exports["succeeded"] = succeeded;
  exports["logStack"] = $foreign.logStack;
})(PS["Main"] = PS["Main"] || {});
PS["Main"].main();