/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.function.LongConsumer;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.LegacyNumericUtils;

abstract class DocValuesTermsCollector<DV>
extends SimpleCollector {
    protected DV docValues;
    private final Function<DV> docValuesCall;

    public DocValuesTermsCollector(Function<DV> docValuesCall) {
        this.docValuesCall = docValuesCall;
    }

    protected final void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = this.docValuesCall.apply(context.reader());
    }

    static Function<BinaryDocValues> binaryDocValues(String field) {
        return ctx -> DocValues.getBinary((LeafReader)ctx, (String)field);
    }

    static Function<SortedSetDocValues> sortedSetDocValues(String field) {
        return ctx -> DocValues.getSortedSet((LeafReader)ctx, (String)field);
    }

    static Function<BinaryDocValues> numericAsBinaryDocValues(String field, FieldType.LegacyNumericType numTyp) {
        return ctx -> {
            final NumericDocValues numeric = DocValues.getNumeric((LeafReader)ctx, (String)field);
            final BytesRefBuilder bytes = new BytesRefBuilder();
            final LongConsumer coder = DocValuesTermsCollector.coder(bytes, numTyp, field);
            return new BinaryDocValues(){

                public BytesRef get(int docID) {
                    long lVal = numeric.get(docID);
                    coder.accept(lVal);
                    return bytes.get();
                }
            };
        };
    }

    static LongConsumer coder(BytesRefBuilder bytes, FieldType.LegacyNumericType type, String fieldName) {
        switch (type) {
            case INT: {
                return l -> LegacyNumericUtils.intToPrefixCoded((int)((int)l), (int)0, (BytesRefBuilder)bytes);
            }
            case LONG: {
                return l -> LegacyNumericUtils.longToPrefixCoded((long)l, (int)0, (BytesRefBuilder)bytes);
            }
        }
        throw new IllegalArgumentException("Unsupported " + type + ". Only " + FieldType.LegacyNumericType.INT + " and " + FieldType.LegacyNumericType.LONG + " are supported.Field " + fieldName);
    }

    static Function<SortedSetDocValues> sortedNumericAsSortedSetDocValues(String field, FieldType.LegacyNumericType numTyp) {
        return ctx -> {
            final SortedNumericDocValues numerics = DocValues.getSortedNumeric((LeafReader)ctx, (String)field);
            final BytesRefBuilder bytes = new BytesRefBuilder();
            final LongConsumer coder = DocValuesTermsCollector.coder(bytes, numTyp, field);
            return new SortedSetDocValues(){
                private int index = Integer.MIN_VALUE;

                public long nextOrd() {
                    return this.index < numerics.count() - 1 ? (long)(++this.index) : -1L;
                }

                public void setDocument(int docID) {
                    numerics.setDocument(docID);
                    this.index = -1;
                }

                public BytesRef lookupOrd(long ord) {
                    assert (ord >= 0L && ord < (long)numerics.count());
                    long value = numerics.valueAt((int)ord);
                    coder.accept(value);
                    return bytes.get();
                }

                public long getValueCount() {
                    throw new UnsupportedOperationException("it's just number encoding wrapper");
                }

                public long lookupTerm(BytesRef key) {
                    throw new UnsupportedOperationException("it's just number encoding wrapper");
                }
            };
        };
    }

    @FunctionalInterface
    static interface Function<R> {
        public R apply(LeafReader var1) throws IOException;
    }
}

