/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

abstract class ProgressInputStream
extends FilterInputStream {
    private final int expectedTotalSize;
    private int currentPercent;
    private int count = 0;

    public ProgressInputStream(InputStream is, int expectedTotalSize) {
        super(is);
        this.expectedTotalSize = expectedTotalSize;
        this.currentPercent = 0;
    }

    @Override
    public int read() throws IOException {
        int read = this.in.read();
        this.checkProgress(read == -1 ? -1 : 1);
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int byteCount = super.read(b, off, len);
        this.checkProgress(byteCount);
        return byteCount;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    void checkProgress(int byteCount) {
        if (byteCount == -1) {
            this.currentPercent = 100;
            this.onProgress(this.currentPercent);
        } else {
            this.count += byteCount;
            int percent = Math.min(99, (int)Math.floor(100.0 * (double)this.count / (double)this.expectedTotalSize));
            if (percent > this.currentPercent) {
                this.currentPercent = percent;
                this.onProgress(percent);
            }
        }
    }

    public void onProgress(int percent) {
    }
}

