/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class AbstractInfoAction
extends JosmAction {
    public AbstractInfoAction(boolean bl) {
        super(bl);
    }

    public AbstractInfoAction(String string, String string2, String string3, Shortcut shortcut, boolean bl, String string4, boolean bl2) {
        super(string, string2, string3, shortcut, bl, string4, bl2);
    }

    public static boolean confirmLaunchMultiple(int n) {
        String string = I18n.trn("You are about to launch {0} browser window.<br>This may both clutter your screen with browser windows<br>and take some time to finish.", "You are about to launch {0} browser windows.<br>This may both clutter your screen with browser windows<br>and take some time to finish.", n, n);
        string = "<html>" + string + "</html>";
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Continue", new Object[0]), ImageProvider.get("ok"), I18n.trn("Click to continue and to open {0} browser", "Click to continue and to open {0} browsers", n, n), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to abort launching external browsers", new Object[0]), null)};
        return 0 == HelpAwareOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Warning", new Object[0]), 2, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/WarningMessages#ToManyBrowsersToOpen"));
    }

    protected void launchInfoBrowsersForSelectedPrimitivesAndNote() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        if (dataSet != null) {
            arrayList.addAll(dataSet.getAllSelected());
        }
        Note note = Main.isDisplayingMapView() ? Main.map.noteDialog.getSelectedNote() : null;
        arrayList.removeIf(AbstractPrimitive::isNew);
        if (arrayList.isEmpty() && note == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one already uploaded node, way, or relation.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        int n = Math.min(10, arrayList.size());
        if (arrayList.size() > n && !AbstractInfoAction.confirmLaunchMultiple(arrayList.size())) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.launchInfoBrowser(arrayList.get(i));
        }
        if (note != null) {
            this.launchInfoBrowser(note);
        }
    }

    protected final void launchInfoBrowser(Object object) {
        String string;
        String string2 = this.createInfoUrl(object);
        if (string2 != null && (string = OpenBrowser.displayUrl(string2)) != null) {
            Main.warn(string);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.launchInfoBrowsersForSelectedPrimitivesAndNote();
    }

    protected abstract String createInfoUrl(Object var1);

    @Override
    protected void updateEnabledState() {
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        this.setEnabled(dataSet != null && !dataSet.selectionEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }
}

