/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.plugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.openstreetmap.josm.gui.preferences.plugin.PluginCheckBox;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreferencesModel;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class PluginListPanel
extends VerticallyScrollablePanel {
    private transient PluginPreferencesModel model;

    public PluginListPanel() {
        this(new PluginPreferencesModel());
    }

    public PluginListPanel(PluginPreferencesModel pluginPreferencesModel) {
        this.model = pluginPreferencesModel;
        this.setLayout(new GridBagLayout());
    }

    protected static String formatPluginRemoteVersion(PluginInformation pluginInformation) {
        StringBuilder stringBuilder = new StringBuilder();
        if (pluginInformation.version == null || pluginInformation.version.trim().isEmpty()) {
            stringBuilder.append(I18n.tr("unknown", new Object[0]));
        } else {
            stringBuilder.append(pluginInformation.version);
            if (pluginInformation.oldmode) {
                stringBuilder.append('*');
            }
        }
        return stringBuilder.toString();
    }

    protected static String formatPluginLocalVersion(PluginInformation pluginInformation) {
        if (pluginInformation == null) {
            return I18n.tr("unknown", new Object[0]);
        }
        if (pluginInformation.localversion == null || pluginInformation.localversion.trim().isEmpty()) {
            return I18n.tr("unknown", new Object[0]);
        }
        return pluginInformation.localversion;
    }

    protected static String formatCheckboxTooltipText(PluginInformation pluginInformation) {
        if (pluginInformation == null) {
            return "";
        }
        if (pluginInformation.downloadlink == null) {
            return I18n.tr("Plugin bundled with JOSM", new Object[0]);
        }
        return pluginInformation.downloadlink;
    }

    public void displayEmptyPluginListInformation() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(40, 0, 40, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        HtmlPanel htmlPanel = new HtmlPanel();
        htmlPanel.setText("<html>" + I18n.tr("Please click on <strong>Download list</strong> to download and display a list of available plugins.", new Object[0]) + "</html>");
        this.add((Component)htmlPanel, gridBagConstraints);
    }

    public void refreshView() {
        Rectangle rectangle = this.getVisibleRect();
        List<PluginInformation> list = this.model.getDisplayedPlugins();
        this.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        if (list.isEmpty()) {
            this.displayEmptyPluginListInformation();
            return;
        }
        int n = -1;
        for (PluginInformation pluginInformation : list) {
            boolean bl = this.model.isSelectedPlugin(pluginInformation.getName());
            String string = PluginListPanel.formatPluginRemoteVersion(pluginInformation);
            String string2 = PluginListPanel.formatPluginLocalVersion(this.model.getPluginInformation(pluginInformation.getName()));
            PluginCheckBox pluginCheckBox = new PluginCheckBox(pluginInformation, bl, this, this.model);
            String string3 = I18n.tr("{0}: Version {1} (local: {2})", pluginInformation.getName(), string, string2);
            if (pluginInformation.requires != null && !pluginInformation.requires.isEmpty()) {
                string3 = string3 + I18n.tr(" (requires: {0})", pluginInformation.requires);
            }
            JLabel jLabel = new JLabel(string3, pluginInformation.getScaledIcon(), 2);
            jLabel.addMouseListener(new PluginCheckBoxMouseAdapter(pluginCheckBox));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = ++n;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)pluginCheckBox, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)jLabel, gridBagConstraints);
            HtmlPanel htmlPanel = new HtmlPanel();
            htmlPanel.setText(pluginInformation.getDescriptionAsHtml());
            htmlPanel.getEditorPane().addHyperlinkListener(hyperlinkEvent -> {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    OpenBrowser.displayUrl(hyperlinkEvent.getURL().toString());
                }
            });
            jLabel.setLabelFor(htmlPanel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = ++n;
            gridBagConstraints.insets = new Insets(3, 25, 5, 5);
            gridBagConstraints.weighty = 1.0;
            this.add((Component)htmlPanel, gridBagConstraints);
        }
        this.revalidate();
        this.repaint();
        SwingUtilities.invokeLater(() -> this.scrollRectToVisible(rectangle));
    }

    static final class PluginCheckBoxMouseAdapter
    extends MouseAdapter {
        private final PluginCheckBox cbPlugin;

        PluginCheckBoxMouseAdapter(PluginCheckBox pluginCheckBox) {
            this.cbPlugin = pluginCheckBox;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.cbPlugin.doClick();
        }
    }
}

