/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.openapi.extensions.AreaPicoContainer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.picocontainer.defaults.ImmutablePicoContainerProxyFactory;
import org.picocontainer.defaults.InstanceComponentAdapter;

public class DefaultPicoContainer
implements AreaPicoContainer,
Serializable {
    private final PicoContainer parent;
    private final Set<PicoContainer> children = new HashSet<PicoContainer>();
    private final Map<Object, ComponentAdapter> componentKeyToAdapterCache = ContainerUtil.newConcurrentMap();
    private final LinkedHashSetWrapper<ComponentAdapter> componentAdapters = new LinkedHashSetWrapper();
    private final Map<String, ComponentAdapter> classNameToAdapter = ContainerUtil.newConcurrentMap();
    private final AtomicReference<FList<ComponentAdapter>> nonAssignableComponentAdapters = new AtomicReference(FList.emptyList());

    public DefaultPicoContainer(PicoContainer parent2) {
        this.parent = parent2 == null ? null : ImmutablePicoContainerProxyFactory.newProxyInstance(parent2);
    }

    public DefaultPicoContainer() {
        this(null);
    }

    @Override
    public Collection<ComponentAdapter> getComponentAdapters() {
        return this.componentAdapters.getImmutableSet();
    }

    private void appendNonAssignableAdaptersOfType(@NotNull Class componentType, @NotNull List<ComponentAdapter> result2) {
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentType", "com/intellij/util/pico/DefaultPicoContainer", "appendNonAssignableAdaptersOfType"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/pico/DefaultPicoContainer", "appendNonAssignableAdaptersOfType"));
        }
        ArrayList<ComponentAdapter> comp2 = new ArrayList<ComponentAdapter>();
        for (ComponentAdapter componentAdapter : this.nonAssignableComponentAdapters.get()) {
            if (!ReflectionUtil.isAssignable(componentType, componentAdapter.getComponentImplementation())) continue;
            comp2.add(componentAdapter);
        }
        for (int i = comp2.size() - 1; i >= 0; --i) {
            ComponentAdapter adapter = (ComponentAdapter)comp2.get(i);
            result2.add(adapter);
        }
    }

    @Override
    @Nullable
    public final ComponentAdapter getComponentAdapter(Object componentKey) {
        ComponentAdapter adapter = this.getFromCache(componentKey);
        if (adapter == null && this.parent != null) {
            adapter = this.parent.getComponentAdapter(componentKey);
        }
        return adapter;
    }

    @Nullable
    private ComponentAdapter getFromCache(Object componentKey) {
        ComponentAdapter adapter = this.componentKeyToAdapterCache.get(componentKey);
        if (adapter != null) {
            return adapter;
        }
        if (componentKey instanceof Class) {
            Class klass = (Class)componentKey;
            return this.componentKeyToAdapterCache.get(klass.getName());
        }
        return null;
    }

    @Override
    @Nullable
    public ComponentAdapter getComponentAdapterOfType(Class componentType) {
        ComponentAdapter adapterByKey = this.getComponentAdapter(componentType);
        if (adapterByKey != null) {
            return adapterByKey;
        }
        List<ComponentAdapter> found = this.getComponentAdaptersOfType(componentType);
        if (found.size() == 1) {
            return found.get(0);
        }
        if (found.isEmpty()) {
            if (this.parent != null) {
                return this.parent.getComponentAdapterOfType(componentType);
            }
            return null;
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found.get(i).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    @Override
    public List<ComponentAdapter> getComponentAdaptersOfType(Class componentType) {
        if (componentType == null) {
            return Collections.emptyList();
        }
        if (componentType == String.class) {
            return Collections.emptyList();
        }
        SmartList<ComponentAdapter> result2 = new SmartList<ComponentAdapter>();
        ComponentAdapter cacheHit = this.classNameToAdapter.get(componentType.getName());
        if (cacheHit != null) {
            result2.add(cacheHit);
        }
        this.appendNonAssignableAdaptersOfType(componentType, result2);
        return result2;
    }

    @Override
    public ComponentAdapter registerComponent(@NotNull ComponentAdapter componentAdapter) {
        if (componentAdapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentAdapter", "com/intellij/util/pico/DefaultPicoContainer", "registerComponent"));
        }
        Object componentKey = componentAdapter.getComponentKey();
        if (this.componentKeyToAdapterCache.containsKey(componentKey)) {
            throw new DuplicateComponentKeyRegistrationException(componentKey);
        }
        if (componentAdapter instanceof AssignableToComponentAdapter) {
            String classKey = ((AssignableToComponentAdapter)componentAdapter).getAssignableToClassName();
            this.classNameToAdapter.put(classKey, componentAdapter);
        } else {
            FList<ComponentAdapter> newList;
            FList<ComponentAdapter> oldList;
            while (!this.nonAssignableComponentAdapters.compareAndSet(oldList = this.nonAssignableComponentAdapters.get(), newList = oldList.prepend(componentAdapter))) {
            }
        }
        this.componentAdapters.add(componentAdapter);
        this.componentKeyToAdapterCache.put(componentKey, componentAdapter);
        return componentAdapter;
    }

    @Override
    public ComponentAdapter unregisterComponent(@NotNull Object componentKey) {
        if (componentKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/util/pico/DefaultPicoContainer", "unregisterComponent"));
        }
        ComponentAdapter adapter = this.componentKeyToAdapterCache.remove(componentKey);
        this.componentAdapters.remove(adapter);
        if (adapter instanceof AssignableToComponentAdapter) {
            this.classNameToAdapter.remove(((AssignableToComponentAdapter)adapter).getAssignableToClassName());
        } else {
            FList<ComponentAdapter> newList;
            FList<ComponentAdapter> oldList;
            while (!this.nonAssignableComponentAdapters.compareAndSet(oldList = this.nonAssignableComponentAdapters.get(), newList = oldList.without(adapter))) {
            }
        }
        return adapter;
    }

    @Override
    @Nullable
    public Object getComponentInstance(Object componentKey) {
        ComponentAdapter adapter = this.getFromCache(componentKey);
        if (adapter != null) {
            return this.getLocalInstance(adapter);
        }
        if (this.parent != null && (adapter = this.parent.getComponentAdapter(componentKey)) != null) {
            return this.parent.getComponentInstance(adapter.getComponentKey());
        }
        return null;
    }

    private Object getLocalInstance(ComponentAdapter componentAdapter) {
        PicoException firstLevelException = null;
        Object instance = null;
        try {
            instance = componentAdapter.getComponentInstance(this);
        }
        catch (PicoInitializationException e) {
            firstLevelException = e;
        }
        catch (PicoIntrospectionException e) {
            firstLevelException = e;
        }
        if (firstLevelException != null) {
            if (this.parent != null && (instance = this.parent.getComponentInstance(componentAdapter.getComponentKey())) != null) {
                return instance;
            }
            throw firstLevelException;
        }
        return instance;
    }

    @Override
    public void start() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ComponentAdapter registerComponentInstance(@NotNull Object component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/util/pico/DefaultPicoContainer", "registerComponentInstance"));
        }
        return this.registerComponentInstance(component.getClass(), component);
    }

    @Override
    public ComponentAdapter registerComponentInstance(@NotNull Object componentKey, @NotNull Object componentInstance) {
        if (componentKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/util/pico/DefaultPicoContainer", "registerComponentInstance"));
        }
        if (componentInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentInstance", "com/intellij/util/pico/DefaultPicoContainer", "registerComponentInstance"));
        }
        return this.registerComponent(new InstanceComponentAdapter(componentKey, componentInstance));
    }

    @Override
    public ComponentAdapter registerComponentImplementation(@NotNull Object componentKey, @NotNull Class componentImplementation) {
        if (componentKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/util/pico/DefaultPicoContainer", "registerComponentImplementation"));
        }
        if (componentImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentImplementation", "com/intellij/util/pico/DefaultPicoContainer", "registerComponentImplementation"));
        }
        return this.registerComponentImplementation(componentKey, componentImplementation, null);
    }

    public ComponentAdapter registerComponentImplementation(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters2) {
        if (componentKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/util/pico/DefaultPicoContainer", "registerComponentImplementation"));
        }
        if (componentImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentImplementation", "com/intellij/util/pico/DefaultPicoContainer", "registerComponentImplementation"));
        }
        CachingConstructorInjectionComponentAdapter componentAdapter = new CachingConstructorInjectionComponentAdapter(componentKey, componentImplementation, parameters2, true);
        return this.registerComponent(componentAdapter);
    }

    @Override
    public PicoContainer getParent() {
        return this.parent;
    }

    public String toString() {
        return "DefaultPicoContainer" + (this.getParent() == null ? " (root)" : " (parent=" + this.getParent() + ")");
    }

    private static class LinkedHashSetWrapper<T> {
        private final Object lock = new Object();
        private volatile Set<T> immutableSet;
        private LinkedHashSet<T> synchronizedSet = new LinkedHashSet();

        private LinkedHashSetWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(@NotNull T element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/pico/DefaultPicoContainer$LinkedHashSetWrapper", "add"));
            }
            Object object = this.lock;
            synchronized (object) {
                if (!this.synchronizedSet.contains(element)) {
                    this.copySyncSetIfExposedAsImmutable().add(element);
                }
            }
        }

        private LinkedHashSet<T> copySyncSetIfExposedAsImmutable() {
            if (this.immutableSet != null) {
                this.immutableSet = null;
                this.synchronizedSet = new LinkedHashSet<T>(this.synchronizedSet);
            }
            return this.synchronizedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(@Nullable T element) {
            Object object = this.lock;
            synchronized (object) {
                this.copySyncSetIfExposedAsImmutable().remove(element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Set<T> getImmutableSet() {
            Set<T> res = this.immutableSet;
            if (res == null) {
                Object object = this.lock;
                synchronized (object) {
                    res = this.immutableSet;
                    if (res == null) {
                        this.immutableSet = res = Collections.unmodifiableSet(this.synchronizedSet);
                    }
                }
            }
            Set<T> set = res;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/pico/DefaultPicoContainer$LinkedHashSetWrapper", "getImmutableSet"));
            }
            return set;
        }
    }
}

