/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.common;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.IntInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

public class OptimizationBasicInterpreter
extends Interpreter<BasicValue>
implements Opcodes {
    private final boolean tolerantToUninitializedValues;

    public OptimizationBasicInterpreter(boolean tolerantToUninitializedValues) {
        super(327680);
        this.tolerantToUninitializedValues = tolerantToUninitializedValues;
    }

    public OptimizationBasicInterpreter() {
        this(false);
    }

    @Override
    @Nullable
    public StrictBasicValue newValue(@Nullable Type type2) {
        if (type2 == null) {
            return StrictBasicValue.UNINITIALIZED_VALUE;
        }
        switch (type2.getSort()) {
            case 0: {
                return null;
            }
            case 5: {
                return StrictBasicValue.INT_VALUE;
            }
            case 6: {
                return StrictBasicValue.FLOAT_VALUE;
            }
            case 7: {
                return StrictBasicValue.LONG_VALUE;
            }
            case 8: {
                return StrictBasicValue.DOUBLE_VALUE;
            }
            case 1: {
                return StrictBasicValue.BOOLEAN_VALUE;
            }
            case 2: {
                return StrictBasicValue.CHAR_VALUE;
            }
            case 3: {
                return StrictBasicValue.BYTE_VALUE;
            }
            case 4: {
                return StrictBasicValue.SHORT_VALUE;
            }
            case 10: {
                return new StrictBasicValue(type2);
            }
            case 9: {
                return StrictBasicValue.REFERENCE_VALUE;
            }
        }
        throw new IllegalArgumentException("Unknown type sort " + type2.getSort());
    }

    @Override
    public BasicValue newOperation(@NotNull AbstractInsnNode insn) throws AnalyzerException {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "newOperation"));
        }
        switch (insn.getOpcode()) {
            case 1: {
                return this.newValue(Type.getObjectType("null"));
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return StrictBasicValue.INT_VALUE;
            }
            case 9: 
            case 10: {
                return StrictBasicValue.LONG_VALUE;
            }
            case 11: 
            case 12: 
            case 13: {
                return StrictBasicValue.FLOAT_VALUE;
            }
            case 14: 
            case 15: {
                return StrictBasicValue.DOUBLE_VALUE;
            }
            case 16: 
            case 17: {
                return StrictBasicValue.INT_VALUE;
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                if (cst instanceof Integer) {
                    return StrictBasicValue.INT_VALUE;
                }
                if (cst instanceof Float) {
                    return StrictBasicValue.FLOAT_VALUE;
                }
                if (cst instanceof Long) {
                    return StrictBasicValue.LONG_VALUE;
                }
                if (cst instanceof Double) {
                    return StrictBasicValue.DOUBLE_VALUE;
                }
                if (cst instanceof String) {
                    return this.newValue(Type.getObjectType("java/lang/String"));
                }
                if (cst instanceof Type) {
                    int sort = ((Type)cst).getSort();
                    if (sort == 10 || sort == 9) {
                        return this.newValue(Type.getObjectType("java/lang/Class"));
                    }
                    if (sort == 11) {
                        return this.newValue(Type.getObjectType("java/lang/invoke/MethodType"));
                    }
                    throw new IllegalArgumentException("Illegal LDC constant " + cst);
                }
                if (cst instanceof Handle) {
                    return this.newValue(Type.getObjectType("java/lang/invoke/MethodHandle"));
                }
                throw new IllegalArgumentException("Illegal LDC constant " + cst);
            }
            case 178: {
                return this.newValue(Type.getType(((FieldInsnNode)insn).desc));
            }
            case 187: {
                return this.newValue(Type.getObjectType(((TypeInsnNode)insn).desc));
            }
        }
        throw new Error("Internal error.");
    }

    @Override
    public BasicValue copyOperation(@NotNull AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "copyOperation"));
        }
        return value;
    }

    @Override
    public BasicValue binaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value1, @NotNull BasicValue value2) throws AnalyzerException {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "binaryOperation"));
        }
        if (value1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value1", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "binaryOperation"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value2", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "binaryOperation"));
        }
        switch (insn.getOpcode()) {
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                return StrictBasicValue.INT_VALUE;
            }
            case 48: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                return StrictBasicValue.FLOAT_VALUE;
            }
            case 47: 
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return StrictBasicValue.LONG_VALUE;
            }
            case 49: 
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                return StrictBasicValue.DOUBLE_VALUE;
            }
            case 50: {
                return StrictBasicValue.REFERENCE_VALUE;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return StrictBasicValue.INT_VALUE;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 181: {
                return null;
            }
        }
        throw new Error("Internal error.");
    }

    @Override
    public BasicValue ternaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2, BasicValue value3) throws AnalyzerException {
        return null;
    }

    @Override
    public BasicValue naryOperation(AbstractInsnNode insn, List<? extends BasicValue> values) throws AnalyzerException {
        int opcode = insn.getOpcode();
        if (opcode == 197) {
            return this.newValue(Type.getType(((MultiANewArrayInsnNode)insn).desc));
        }
        if (opcode == 186) {
            return this.newValue(Type.getReturnType(((InvokeDynamicInsnNode)insn).desc));
        }
        return this.newValue(Type.getReturnType(((MethodInsnNode)insn).desc));
    }

    @Override
    public void returnOperation(AbstractInsnNode insn, BasicValue value, BasicValue expected) throws AnalyzerException {
    }

    @Override
    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 116: 
            case 132: 
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 146: 
            case 147: {
                return StrictBasicValue.INT_VALUE;
            }
            case 118: 
            case 134: 
            case 137: 
            case 144: {
                return StrictBasicValue.FLOAT_VALUE;
            }
            case 117: 
            case 133: 
            case 140: 
            case 143: {
                return StrictBasicValue.LONG_VALUE;
            }
            case 119: 
            case 135: 
            case 138: 
            case 141: {
                return StrictBasicValue.DOUBLE_VALUE;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 179: {
                return null;
            }
            case 180: {
                return this.newValue(Type.getType(((FieldInsnNode)insn).desc));
            }
            case 188: {
                switch (((IntInsnNode)insn).operand) {
                    case 4: {
                        return this.newValue(Type.getType("[Z"));
                    }
                    case 5: {
                        return this.newValue(Type.getType("[C"));
                    }
                    case 8: {
                        return this.newValue(Type.getType("[B"));
                    }
                    case 9: {
                        return this.newValue(Type.getType("[S"));
                    }
                    case 10: {
                        return this.newValue(Type.getType("[I"));
                    }
                    case 6: {
                        return this.newValue(Type.getType("[F"));
                    }
                    case 7: {
                        return this.newValue(Type.getType("[D"));
                    }
                    case 11: {
                        return this.newValue(Type.getType("[J"));
                    }
                }
                throw new AnalyzerException(insn, "Invalid array type");
            }
            case 189: {
                String desc = ((TypeInsnNode)insn).desc;
                return this.newValue(Type.getType("[" + Type.getObjectType(desc)));
            }
            case 190: {
                return StrictBasicValue.INT_VALUE;
            }
            case 191: {
                return null;
            }
            case 192: {
                String desc = ((TypeInsnNode)insn).desc;
                return this.newValue(Type.getObjectType(desc));
            }
            case 193: {
                return StrictBasicValue.INT_VALUE;
            }
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                return null;
            }
        }
        throw new Error("Internal error.");
    }

    @Override
    @NotNull
    public BasicValue merge(@NotNull BasicValue v, @NotNull BasicValue w) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "merge"));
        }
        if (w == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "w", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "merge"));
        }
        if (v.equals(w)) {
            BasicValue basicValue = v;
            if (basicValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "merge"));
            }
            return basicValue;
        }
        if (this.tolerantToUninitializedValues) {
            if (v == StrictBasicValue.UNINITIALIZED_VALUE) {
                BasicValue basicValue = w;
                if (basicValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "merge"));
                }
                return basicValue;
            }
            if (w == StrictBasicValue.UNINITIALIZED_VALUE) {
                BasicValue basicValue = v;
                if (basicValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "merge"));
                }
                return basicValue;
            }
        } else if (v == StrictBasicValue.UNINITIALIZED_VALUE || w == StrictBasicValue.UNINITIALIZED_VALUE) {
            StrictBasicValue strictBasicValue = StrictBasicValue.UNINITIALIZED_VALUE;
            if (strictBasicValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "merge"));
            }
            return strictBasicValue;
        }
        if (v.getType().getSort() == 10 && w.getType().getSort() == 10) {
            StrictBasicValue strictBasicValue = StrictBasicValue.REFERENCE_VALUE;
            if (strictBasicValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "merge"));
            }
            return strictBasicValue;
        }
        assert (v.getType().getSort() != 9 && w.getType().getSort() != 9) : "There should not be arrays";
        if (v.getType().getOpcode(54) == 54 && w.getType().getOpcode(54) == 54) {
            StrictBasicValue strictBasicValue = StrictBasicValue.INT_VALUE;
            if (strictBasicValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "merge"));
            }
            return strictBasicValue;
        }
        StrictBasicValue strictBasicValue = StrictBasicValue.UNINITIALIZED_VALUE;
        if (strictBasicValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter", "merge"));
        }
        return strictBasicValue;
    }
}

