/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class ByteArrayDataSource
implements DataSource {
    private byte[] data;
    private String type;
    private String name = "";

    public ByteArrayDataSource(byte[] data, String type) {
        this.data = data;
        this.type = type;
    }

    public ByteArrayDataSource(InputStream is, String type) throws IOException {
        ByteArrayOutputStream sink = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int len = is.read(buf);
        while (len != -1) {
            sink.write(buf, 0, len);
            len = is.read(buf);
        }
        this.data = sink.toByteArray();
        this.type = type;
    }

    public ByteArrayDataSource(String data, String type) throws IOException {
        try {
            String jcharset;
            ContentType ct = new ContentType(type);
            String charset = ct.getParameter("charset");
            String string = jcharset = charset == null ? MimeUtility.getDefaultJavaCharset() : MimeUtility.javaCharset(charset);
            if (jcharset == null) {
                throw new UnsupportedEncodingException(charset);
            }
            this.data = data.getBytes(jcharset);
            this.type = type;
        }
        catch (ParseException e) {
            IOException e2 = new IOException("can't parse MIME type");
            e2.initCause(e);
            throw e2;
        }
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        return new ErrorOutputStream();
    }

    public String getContentType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    static class ErrorOutputStream
    extends OutputStream {
        ErrorOutputStream() {
        }

        @Override
        public void write(int c) throws IOException {
            throw new IOException("writing to this stream is not allowed");
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            throw new IOException("writing to this stream is not allowed");
        }
    }
}

