/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.ImageLine;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.PngChunkPLTE;
import jogamp.opengl.util.pngj.chunks.PngChunkTRNS;

public class ImageLineHelper {
    private static final double BIG_VALUE = 8.988465674311579E307;
    private static final double BIG_VALUE_NEG = -8.988465674311579E307;

    public static int[] palette2rgb(ImageLine imageLine, PngChunkPLTE pngChunkPLTE, PngChunkTRNS pngChunkTRNS, int[] nArray) {
        boolean bl = pngChunkTRNS != null;
        int n = bl ? 4 : 3;
        int n2 = imageLine.imgInfo.cols * n;
        if (nArray == null || nArray.length < n2) {
            nArray = new int[n2];
        }
        if (!imageLine.samplesUnpacked) {
            imageLine = imageLine.unpackToNewImageLine();
        }
        boolean bl2 = imageLine.sampleType == ImageLine.SampleType.BYTE;
        int n3 = pngChunkTRNS != null ? pngChunkTRNS.getPalletteAlpha().length : 0;
        for (int i = 0; i < imageLine.imgInfo.cols; ++i) {
            int n4;
            int n5 = bl2 ? imageLine.scanlineb[i] & 0xFF : imageLine.scanline[i];
            pngChunkPLTE.getEntryRgb(n5, nArray, i * n);
            if (!bl) continue;
            nArray[i * n + 3] = n4 = n5 < n3 ? pngChunkTRNS.getPalletteAlpha()[n5] : 255;
        }
        return nArray;
    }

    public static int[] palette2rgb(ImageLine imageLine, PngChunkPLTE pngChunkPLTE, int[] nArray) {
        return ImageLineHelper.palette2rgb(imageLine, pngChunkPLTE, null, nArray);
    }

    public static String infoFirstLastPixels(ImageLine imageLine) {
        return imageLine.imgInfo.channels == 1 ? String.format("first=(%d) last=(%d)", imageLine.scanline[0], imageLine.scanline[imageLine.scanline.length - 1]) : String.format("first=(%d %d %d) last=(%d %d %d)", imageLine.scanline[0], imageLine.scanline[1], imageLine.scanline[2], imageLine.scanline[imageLine.scanline.length - imageLine.imgInfo.channels], imageLine.scanline[imageLine.scanline.length - imageLine.imgInfo.channels + 1], imageLine.scanline[imageLine.scanline.length - imageLine.imgInfo.channels + 2]);
    }

    public static String infoFull(ImageLine imageLine) {
        ImageLineStats imageLineStats = new ImageLineStats(imageLine);
        return "row=" + imageLine.getRown() + " " + imageLineStats.toString() + "\n  " + ImageLineHelper.infoFirstLastPixels(imageLine);
    }

    public static int getPixelRGB8(ImageLine imageLine, int n) {
        int n2 = n * imageLine.channels;
        return (imageLine.scanline[n2] << 16) + (imageLine.scanline[n2 + 1] << 8) + imageLine.scanline[n2 + 2];
    }

    public static int getPixelARGB8(ImageLine imageLine, int n) {
        int n2 = n * imageLine.channels;
        return (imageLine.scanline[n2 + 3] << 24) + (imageLine.scanline[n2] << 16) + (imageLine.scanline[n2 + 1] << 8) + imageLine.scanline[n2 + 2];
    }

    public static void setPixelsRGB8(ImageLine imageLine, int[] nArray) {
        int n = 0;
        for (int i = 0; i < imageLine.imgInfo.cols; ++i) {
            imageLine.scanline[n++] = nArray[i] >> 16 & 0xFF;
            imageLine.scanline[n++] = nArray[i] >> 8 & 0xFF;
            imageLine.scanline[n++] = nArray[i] & 0xFF;
        }
    }

    public static void setPixelRGB8(ImageLine imageLine, int n, int n2, int n3, int n4) {
        n *= imageLine.channels;
        imageLine.scanline[n++] = n2;
        imageLine.scanline[n++] = n3;
        imageLine.scanline[n] = n4;
    }

    public static void setPixelRGB8(ImageLine imageLine, int n, int n2) {
        ImageLineHelper.setPixelRGB8(imageLine, n, n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF);
    }

    public static void setPixelsRGBA8(ImageLine imageLine, int[] nArray) {
        int n = 0;
        for (int i = 0; i < imageLine.imgInfo.cols; ++i) {
            imageLine.scanline[n++] = nArray[i] >> 16 & 0xFF;
            imageLine.scanline[n++] = nArray[i] >> 8 & 0xFF;
            imageLine.scanline[n++] = nArray[i] & 0xFF;
            imageLine.scanline[n++] = nArray[i] >> 24 & 0xFF;
        }
    }

    public static void setPixelRGBA8(ImageLine imageLine, int n, int n2, int n3, int n4, int n5) {
        n *= imageLine.channels;
        imageLine.scanline[n++] = n2;
        imageLine.scanline[n++] = n3;
        imageLine.scanline[n++] = n4;
        imageLine.scanline[n] = n5;
    }

    public static void setPixelRGBA8(ImageLine imageLine, int n, int n2) {
        ImageLineHelper.setPixelRGBA8(imageLine, n, n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF, n2 >> 24 & 0xFF);
    }

    public static void setValD(ImageLine imageLine, int n, double d) {
        imageLine.scanline[n] = ImageLineHelper.double2int(imageLine, d);
    }

    public static int interpol(int n, int n2, int n3, int n4, double d, double d2) {
        double d3 = (double)n * (1.0 - d) + (double)n2 * d;
        double d4 = (double)n3 * (1.0 - d) + (double)n4 * d;
        return (int)(d3 * (1.0 - d2) + d4 * d2 + 0.5);
    }

    public static double int2double(ImageLine imageLine, int n) {
        return imageLine.bitDepth == 16 ? (double)n / 65535.0 : (double)n / 255.0;
    }

    public static double int2doubleClamped(ImageLine imageLine, int n) {
        double d;
        double d2 = d = imageLine.bitDepth == 16 ? (double)n / 65535.0 : (double)n / 255.0;
        return d <= 0.0 ? 0.0 : (d >= 1.0 ? 1.0 : d);
    }

    public static int double2int(ImageLine imageLine, double d) {
        d = d <= 0.0 ? 0.0 : (d >= 1.0 ? 1.0 : d);
        return imageLine.bitDepth == 16 ? (int)(d * 65535.0 + 0.5) : (int)(d * 255.0 + 0.5);
    }

    public static int double2intClamped(ImageLine imageLine, double d) {
        d = d <= 0.0 ? 0.0 : (d >= 1.0 ? 1.0 : d);
        return imageLine.bitDepth == 16 ? (int)(d * 65535.0 + 0.5) : (int)(d * 255.0 + 0.5);
    }

    public static int clampTo_0_255(int n) {
        return n > 255 ? 255 : (n < 0 ? 0 : n);
    }

    public static int clampTo_0_65535(int n) {
        return n > 65535 ? 65535 : (n < 0 ? 0 : n);
    }

    public static int clampTo_128_127(int n) {
        return n > 127 ? 127 : (n < -128 ? -128 : n);
    }

    public static int[] unpack(ImageInfo imageInfo, int[] nArray, int[] nArray2, boolean bl) {
        int n = imageInfo.samplesPerRow;
        int n2 = imageInfo.samplesPerRowPacked;
        if (nArray2 == null || nArray2.length < n) {
            nArray2 = new int[n];
        }
        if (imageInfo.packed) {
            ImageLine.unpackInplaceInt(imageInfo, nArray, nArray2, bl);
        } else {
            System.arraycopy(nArray, 0, nArray2, 0, n2);
        }
        return nArray2;
    }

    public static byte[] unpack(ImageInfo imageInfo, byte[] byArray, byte[] byArray2, boolean bl) {
        int n = imageInfo.samplesPerRow;
        int n2 = imageInfo.samplesPerRowPacked;
        if (byArray2 == null || byArray2.length < n) {
            byArray2 = new byte[n];
        }
        if (imageInfo.packed) {
            ImageLine.unpackInplaceByte(imageInfo, byArray, byArray2, bl);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, n2);
        }
        return byArray2;
    }

    public static int[] pack(ImageInfo imageInfo, int[] nArray, int[] nArray2, boolean bl) {
        int n = imageInfo.samplesPerRowPacked;
        if (nArray2 == null || nArray2.length < n) {
            nArray2 = new int[n];
        }
        if (imageInfo.packed) {
            ImageLine.packInplaceInt(imageInfo, nArray, nArray2, bl);
        } else {
            System.arraycopy(nArray, 0, nArray2, 0, n);
        }
        return nArray2;
    }

    public static byte[] pack(ImageInfo imageInfo, byte[] byArray, byte[] byArray2, boolean bl) {
        int n = imageInfo.samplesPerRowPacked;
        if (byArray2 == null || byArray2.length < n) {
            byArray2 = new byte[n];
        }
        if (imageInfo.packed) {
            ImageLine.packInplaceByte(imageInfo, byArray, byArray2, bl);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, n);
        }
        return byArray2;
    }

    static int getMaskForPackedFormats(int n) {
        if (n == 4) {
            return 240;
        }
        if (n == 2) {
            return 192;
        }
        return 128;
    }

    static int getMaskForPackedFormatsLs(int n) {
        if (n == 4) {
            return 15;
        }
        if (n == 2) {
            return 3;
        }
        return 1;
    }

    static class ImageLineStats {
        public double[] prom = new double[]{0.0, 0.0, 0.0, 0.0};
        public double[] maxv = new double[]{-8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307};
        public double[] minv = new double[]{8.988465674311579E307, 8.988465674311579E307, 8.988465674311579E307, 8.988465674311579E307};
        public double promlum = 0.0;
        public double maxlum = -8.988465674311579E307;
        public double minlum = 8.988465674311579E307;
        public double[] maxdif = new double[]{-8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307, 8.988465674311579E307};
        public final int channels;

        public String toString() {
            return this.channels == 3 ? String.format("prom=%.1f (%.1f %.1f %.1f) max=%.1f (%.1f %.1f %.1f) min=%.1f (%.1f %.1f %.1f)", this.promlum, this.prom[0], this.prom[1], this.prom[2], this.maxlum, this.maxv[0], this.maxv[1], this.maxv[2], this.minlum, this.minv[0], this.minv[1], this.minv[2]) + String.format(" maxdif=(%.1f %.1f %.1f)", this.maxdif[0], this.maxdif[1], this.maxdif[2]) : String.format("prom=%.1f (%.1f %.1f %.1f %.1f) max=%.1f (%.1f %.1f %.1f %.1f) min=%.1f (%.1f %.1f %.1f %.1f)", this.promlum, this.prom[0], this.prom[1], this.prom[2], this.prom[3], this.maxlum, this.maxv[0], this.maxv[1], this.maxv[2], this.maxv[3], this.minlum, this.minv[0], this.minv[1], this.minv[2], this.minv[3]) + String.format(" maxdif=(%.1f %.1f %.1f %.1f)", this.maxdif[0], this.maxdif[1], this.maxdif[2], this.maxdif[3]);
        }

        public ImageLineStats(ImageLine imageLine) {
            this.channels = imageLine.channels;
            if (imageLine.channels < 3) {
                throw new PngjException("ImageLineStats only works for RGB - RGBA");
            }
            int n = 0;
            for (int i = 0; i < imageLine.imgInfo.cols; ++i) {
                double d = 0.0;
                for (n = this.channels - 1; n >= 0; --n) {
                    double d2;
                    double d3 = ImageLineHelper.int2double(imageLine, imageLine.scanline[i * this.channels]);
                    if (n < 3) {
                        d += d3;
                    }
                    int n2 = n;
                    this.prom[n2] = this.prom[n2] + d3;
                    if (d3 > this.maxv[n]) {
                        this.maxv[n] = d3;
                    }
                    if (d3 < this.minv[n]) {
                        this.minv[n] = d3;
                    }
                    if (i < this.channels || !((d2 = Math.abs(d3 - ImageLineHelper.int2double(imageLine, imageLine.scanline[i - this.channels]))) > this.maxdif[n])) continue;
                    this.maxdif[n] = d2;
                }
                this.promlum += d;
                if (d > this.maxlum) {
                    this.maxlum = d;
                }
                if (!(d < this.minlum)) continue;
                this.minlum = d;
            }
            n = 0;
            while (n < this.channels) {
                int n3 = n++;
                this.prom[n3] = this.prom[n3] / (double)imageLine.imgInfo.cols;
            }
            this.promlum /= (double)imageLine.imgInfo.cols * 3.0;
            this.maxlum /= 3.0;
            this.minlum /= 3.0;
        }
    }
}

