/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import org.elasticsearch.action.support.WriteResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.StatusToXContent;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;

public abstract class DocWriteResponse
extends ReplicationResponse
implements WriteResponse,
StatusToXContent {
    private ShardId shardId;
    private String id;
    private String type;
    private long version;
    private boolean forcedRefresh;
    protected Result result;

    public DocWriteResponse(ShardId shardId, String type, String id, long version, Result result) {
        this.shardId = shardId;
        this.type = type;
        this.id = id;
        this.version = version;
        this.result = result;
    }

    protected DocWriteResponse() {
    }

    public Result getResult() {
        return this.result;
    }

    public String getIndex() {
        return this.shardId.getIndexName();
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean forcedRefresh() {
        return this.forcedRefresh;
    }

    @Override
    public void setForcedRefresh(boolean forcedRefresh) {
        this.forcedRefresh = forcedRefresh;
    }

    @Override
    public RestStatus status() {
        return this.getShardInfo().status();
    }

    public String getLocation(@Nullable String routing) {
        String encodedRouting;
        String encodedId;
        String encodedType;
        String encodedIndex;
        try {
            encodedIndex = URLEncoder.encode(this.getIndex(), "UTF-8");
            encodedType = URLEncoder.encode(this.getType(), "UTF-8");
            encodedId = URLEncoder.encode(this.getId(), "UTF-8");
            encodedRouting = routing == null ? null : URLEncoder.encode(routing, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        String routingStart = "?routing=";
        int bufferSizeExcludingRouting = 3 + encodedIndex.length() + encodedType.length() + encodedId.length();
        int bufferSize = encodedRouting == null ? bufferSizeExcludingRouting : bufferSizeExcludingRouting + "?routing=".length() + encodedRouting.length();
        StringBuilder location = new StringBuilder(bufferSize);
        location.append('/').append(encodedIndex);
        location.append('/').append(encodedType);
        location.append('/').append(encodedId);
        if (encodedRouting != null) {
            location.append("?routing=").append(encodedRouting);
        }
        return location.toString();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardId = ShardId.readShardId(in);
        this.type = in.readString();
        this.id = in.readString();
        this.version = in.readZLong();
        this.forcedRefresh = in.readBoolean();
        this.result = Result.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeZLong(this.version);
        out.writeBoolean(this.forcedRefresh);
        this.result.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ReplicationResponse.ShardInfo shardInfo = this.getShardInfo();
        builder.field("_index", this.shardId.getIndexName()).field("_type", this.type).field("_id", this.id).field("_version", this.version).field("result", this.getResult().getLowercase());
        if (this.forcedRefresh) {
            builder.field("forced_refresh", this.forcedRefresh);
        }
        shardInfo.toXContent(builder, params);
        return builder;
    }

    public static enum Result implements Writeable
    {
        CREATED(0),
        UPDATED(1),
        DELETED(2),
        NOT_FOUND(3),
        NOOP(4);

        private final byte op;
        private final String lowercase;

        private Result(int op) {
            this.op = (byte)op;
            this.lowercase = this.toString().toLowerCase(Locale.ENGLISH);
        }

        public byte getOp() {
            return this.op;
        }

        public String getLowercase() {
            return this.lowercase;
        }

        public static Result readFrom(StreamInput in) throws IOException {
            Byte opcode = in.readByte();
            switch (opcode) {
                case 0: {
                    return CREATED;
                }
                case 1: {
                    return UPDATED;
                }
                case 2: {
                    return DELETED;
                }
                case 3: {
                    return NOT_FOUND;
                }
                case 4: {
                    return NOOP;
                }
            }
            throw new IllegalArgumentException("Unknown result code: " + opcode);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.op);
        }
    }
}

