/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.action.fieldstats.FieldStatsRequest;
import org.elasticsearch.action.fieldstats.FieldStatsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestFieldStatsAction
extends BaseRestHandler {
    @Inject
    public RestFieldStatsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_field_stats", this);
        controller.registerHandler(RestRequest.Method.POST, "/_field_stats", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_field_stats", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_field_stats", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        if (request.hasContentOrSourceParam() && request.hasParam("fields")) {
            throw new IllegalArgumentException("can't specify a request body and [fields] request parameter, either specify a request body or the [fields] request parameter");
        }
        FieldStatsRequest fieldStatsRequest = new FieldStatsRequest();
        fieldStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
        fieldStatsRequest.indicesOptions(IndicesOptions.fromRequest(request, fieldStatsRequest.indicesOptions()));
        fieldStatsRequest.level(request.param("level", "cluster"));
        if (request.hasContentOrSourceParam()) {
            try (XContentParser parser = request.contentOrSourceParamParser();){
                fieldStatsRequest.source(parser);
            }
        } else {
            fieldStatsRequest.setFields(Strings.splitStringByCommaToArray(request.param("fields")));
        }
        return channel -> client.fieldStats(fieldStatsRequest, (ActionListener<FieldStatsResponse>)new RestBuilderListener<FieldStatsResponse>(channel){

            @Override
            public RestResponse buildResponse(FieldStatsResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildBroadcastShardsHeader(builder, request, response);
                builder.startObject("indices");
                for (Map.Entry<String, Map<String, FieldStats>> entry : response.getIndicesMergedFieldStats().entrySet()) {
                    builder.startObject(entry.getKey());
                    builder.startObject("fields");
                    for (Map.Entry<String, FieldStats> entry2 : entry.getValue().entrySet()) {
                        builder.field(entry2.getKey());
                        entry2.getValue().toXContent(builder, request);
                    }
                    builder.endObject();
                    builder.endObject();
                }
                builder.endObject();
                if (response.getConflicts().size() > 0) {
                    builder.startObject("conflicts");
                    for (Map.Entry<String, Object> entry : response.getConflicts().entrySet()) {
                        builder.field(entry.getKey(), (String)entry.getValue());
                    }
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

