/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.read.bytes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.read.SourceNode;
import org.jruby.truffle.core.numeric.FixnumOrBignumNode;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadBERNode
extends FormatNode {
    @Node.Child
    private FixnumOrBignumNode fixnumOrBignumNode = FixnumOrBignumNode.create(null);
    private static final long UL_MASK = -33554432L;
    private static final BigInteger BIG_128 = BigInteger.valueOf(128L);
    private final ConditionProfile simpleProfile = ConditionProfile.createBinaryProfile();

    @Specialization
    protected Object encode(VirtualFrame frame, byte[] source) {
        int position = this.getSourcePosition(frame);
        int length = this.getSourceLength(frame);
        ByteBuffer encode = ByteBuffer.wrap(source, position, length - position);
        int pos = encode.position();
        long ul = encode.get(pos) & 0x7F;
        if (this.simpleProfile.profile((encode.get(pos++) & 0x80) == 0)) {
            this.setSourcePosition(frame, position + pos);
            return ul;
        }
        assert ((ul & 0xFFFFFFFFFE000000L) == 0L);
        BigIntegerAndPos bigIntegerAndPos = this.runLoop(encode, ul, pos);
        this.setSourcePosition(frame, position + bigIntegerAndPos.getPos());
        return this.fixnumOrBignumNode.fixnumOrBignum(bigIntegerAndPos.getBigInteger());
    }

    @CompilerDirectives.TruffleBoundary
    private BigIntegerAndPos runLoop(ByteBuffer encode, long ul, int pos) {
        BigInteger big = BigInteger.valueOf(ul);
        do {
            assert (pos < encode.limit());
            big = big.multiply(BIG_128);
            big = big.add(BigInteger.valueOf(encode.get(pos) & 0x7F));
        } while ((encode.get(pos++) & 0x80) != 0);
        return new BigIntegerAndPos(big, pos);
    }

    private static class BigIntegerAndPos {
        private final BigInteger bigInteger;
        private final int pos;

        public BigIntegerAndPos(BigInteger bigInteger, int pos) {
            this.bigInteger = bigInteger;
            this.pos = pos;
        }

        public BigInteger getBigInteger() {
            return this.bigInteger;
        }

        public int getPos() {
            return this.pos;
        }
    }
}

