/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

public enum CodeRange {
    CR_UNKNOWN(0),
    CR_7BIT(1),
    CR_VALID(2),
    CR_BROKEN(3);

    private final int value;

    private CodeRange(int value) {
        this.value = value;
    }

    public int toInt() {
        return this.value;
    }

    public static CodeRange fromInt(int codeRange) {
        switch (codeRange) {
            case 0: {
                return CR_UNKNOWN;
            }
            case 1: {
                return CR_7BIT;
            }
            case 2: {
                return CR_VALID;
            }
            case 3: {
                return CR_BROKEN;
            }
        }
        throw new UnsupportedOperationException("Don't know how to convert code range: " + codeRange);
    }
}

