/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.extra.ffi;

import com.kenai.jffi.MemoryIO;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeConstants;
import org.jruby.truffle.core.string.ByteList;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.platform.RubiniusTypes;
import org.jruby.truffle.platform.UnsafeGroup;

public abstract class PointerPrimitiveNodes {
    public static final Pointer NULL_POINTER = Runtime.getSystemRuntime().getMemoryManager().newOpaquePointer(0L);

    @Primitive(name="pointer_write_int", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerWriteIntPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject address(DynamicObject pointer, int value) {
            Layouts.POINTER.getPointer(pointer).putInt(0L, value);
            return pointer;
        }
    }

    @Primitive(name="pointer_read_string_to_null", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerReadStringToNullPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isNullPointer(pointer)"})
        public DynamicObject readNullPointer(DynamicObject pointer) {
            return this.createString(RopeConstants.EMPTY_ASCII_8BIT_ROPE);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isNullPointer(pointer)"})
        public DynamicObject readStringToNull(DynamicObject pointer) {
            if (TruffleOptions.AOT) {
                Pointer ptr = Layouts.POINTER.getPointer(pointer);
                int nullOffset = ptr.indexOf(0L, (byte)0);
                byte[] bytes = new byte[nullOffset];
                ptr.get(0L, bytes, 0, bytes.length);
                return StringOperations.createString(this.getContext(), new ByteList(bytes));
            }
            return this.createString(MemoryIO.getInstance().getZeroTerminatedByteArray(Layouts.POINTER.getPointer(pointer).address()), ASCIIEncoding.INSTANCE);
        }
    }

    @Primitive(name="pointer_write_string", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerWriteStringPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject address(DynamicObject pointer, DynamicObject string, int maxLength) {
            Rope rope = StringOperations.rope(string);
            int length = Math.min(rope.byteLength(), maxLength);
            Layouts.POINTER.getPointer(pointer).put(0L, rope.getBytes(), 0, length);
            return pointer;
        }
    }

    @Primitive(name="pointer_get_at_offset", unsafe={UnsafeGroup.MEMORY})
    @ImportStatic(value={RubiniusTypes.class})
    public static abstract class PointerGetAtOffsetPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        @Specialization(guards={"type == TYPE_CHAR"})
        public int getAtOffsetChar(DynamicObject pointer, int offset, int type) {
            return Layouts.POINTER.getPointer(pointer).getByte(offset);
        }

        @Specialization(guards={"type == TYPE_UCHAR"})
        public int getAtOffsetUChar(DynamicObject pointer, int offset, int type) {
            return Layouts.POINTER.getPointer(pointer).getByte(offset);
        }

        @Specialization(guards={"type == TYPE_INT"})
        public int getAtOffsetInt(DynamicObject pointer, int offset, int type) {
            return Layouts.POINTER.getPointer(pointer).getInt(offset);
        }

        @Specialization(guards={"type == TYPE_SHORT"})
        public int getAtOffsetShort(DynamicObject pointer, int offset, int type) {
            return Layouts.POINTER.getPointer(pointer).getShort(offset);
        }

        @Specialization(guards={"type == TYPE_USHORT"})
        public int getAtOffsetUShort(DynamicObject pointer, int offset, int type) {
            return Layouts.POINTER.getPointer(pointer).getShort(offset);
        }

        @Specialization(guards={"type == TYPE_LONG"})
        public long getAtOffsetLong(DynamicObject pointer, int offset, int type) {
            return Layouts.POINTER.getPointer(pointer).getLong(offset);
        }

        @Specialization(guards={"type == TYPE_ULONG"})
        public long getAtOffsetULong(DynamicObject pointer, int offset, int type) {
            return Layouts.POINTER.getPointer(pointer).getLong(offset);
        }

        @Specialization(guards={"type == TYPE_ULL"})
        public long getAtOffsetULL(DynamicObject pointer, int offset, int type) {
            return Layouts.POINTER.getPointer(pointer).getLongLong(offset);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"type == TYPE_STRING"})
        public DynamicObject getAtOffsetString(DynamicObject pointer, int offset, int type) {
            return this.createString(StringOperations.encodeRope(Layouts.POINTER.getPointer(pointer).getString(offset), UTF8Encoding.INSTANCE));
        }

        @Specialization(guards={"type == TYPE_PTR"})
        public DynamicObject getAtOffsetPointer(DynamicObject pointer, int offset, int type) {
            Pointer readPointer;
            if (this.allocateObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.allocateObjectNode = this.insert(AllocateObjectNode.create());
            }
            if ((readPointer = Layouts.POINTER.getPointer(pointer).getPointer(offset)) == null) {
                return this.nil();
            }
            return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(pointer), readPointer);
        }
    }

    @Primitive(name="pointer_address", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerAddressPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public long address(DynamicObject pointer) {
            return Layouts.POINTER.getPointer(pointer).address();
        }
    }

    @Primitive(name="pointer_read_pointer", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerReadPointerPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        @Specialization
        public DynamicObject readPointer(DynamicObject pointer) {
            Pointer ptr = Layouts.POINTER.getPointer(pointer);
            assert (ptr.address() != 0L) : "Attempt to dereference a null pointer";
            Pointer readPointer = ptr.getPointer(0L);
            if (readPointer == null) {
                readPointer = NULL_POINTER;
            }
            return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(pointer), readPointer);
        }
    }

    @Primitive(name="pointer_set_at_offset", lowerFixnum={1, 2}, unsafe={UnsafeGroup.MEMORY})
    @ImportStatic(value={RubiniusTypes.class})
    public static abstract class PointerSetAtOffsetPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"type == TYPE_INT"})
        public int setAtOffsetInt(DynamicObject pointer, int offset, int type, int value) {
            Layouts.POINTER.getPointer(pointer).putInt(offset, value);
            return value;
        }

        @Specialization(guards={"type == TYPE_LONG"})
        public long setAtOffsetLong(DynamicObject pointer, int offset, int type, long value) {
            Layouts.POINTER.getPointer(pointer).putLong(offset, value);
            return value;
        }

        @Specialization(guards={"type == TYPE_ULONG"})
        public long setAtOffsetULong(DynamicObject pointer, int offset, int type, long value) {
            Layouts.POINTER.getPointer(pointer).putLong(offset, value);
            return value;
        }

        @Specialization(guards={"type == TYPE_ULL"})
        public long setAtOffsetULL(DynamicObject pointer, int offset, int type, long value) {
            Layouts.POINTER.getPointer(pointer).putLongLong(offset, value);
            return value;
        }
    }

    @Primitive(name="pointer_set_autorelease", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerSetAutoreleasePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public boolean setAutorelease(DynamicObject pointer, boolean autorelease) {
            return autorelease;
        }
    }

    @Primitive(name="pointer_read_string", lowerFixnum={1}, unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerReadStringPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject readString(DynamicObject pointer, int length) {
            byte[] bytes = new byte[length];
            Layouts.POINTER.getPointer(pointer).get(0L, bytes, 0, length);
            return this.createString(new ByteList(bytes));
        }
    }

    @Primitive(name="pointer_read_int", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerReadIntPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isSigned(signed)"})
        public int readInt(DynamicObject pointer, boolean signed) {
            return Layouts.POINTER.getPointer(pointer).getInt(0L);
        }

        protected boolean isSigned(boolean signed) {
            return signed;
        }
    }

    @Primitive(name="pointer_add", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerAddPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        @Specialization
        public DynamicObject add(DynamicObject a, int b) {
            return this.add(a, (long)b);
        }

        @Specialization
        public DynamicObject add(DynamicObject a, long b) {
            return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(a), this.memoryManager().newPointer(Layouts.POINTER.getPointer(a).address() + b));
        }
    }

    @Primitive(name="pointer_set_address", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerSetAddressPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public long setAddress(DynamicObject pointer, int address) {
            return this.setAddress(pointer, (long)address);
        }

        @Specialization
        public long setAddress(DynamicObject pointer, long address) {
            Layouts.POINTER.setPointer(pointer, this.memoryManager().newPointer(address));
            return address;
        }
    }

    @Primitive(name="pointer_free", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerFreePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject free(DynamicObject pointer) {
            this.getContext().getNativePlatform().getMallocFree().free(Layouts.POINTER.getPointer(pointer).address());
            return pointer;
        }
    }

    @Primitive(name="pointer_malloc", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerMallocPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        @Specialization
        public DynamicObject malloc(DynamicObject pointerClass, int size) {
            return this.malloc(pointerClass, (long)size);
        }

        @Specialization
        public DynamicObject malloc(DynamicObject pointerClass, long size) {
            return this.allocateObjectNode.allocate(pointerClass, this.memoryManager().newPointer(this.getContext().getNativePlatform().getMallocFree().malloc(size)));
        }
    }

    @Primitive(name="pointer_allocate", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerAllocatePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        @Specialization
        public DynamicObject allocate(DynamicObject pointerClass) {
            return this.allocateObjectNode.allocate(pointerClass, NULL_POINTER);
        }
    }
}

