/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect.profiles;

import com.optimaize.langdetect.profiles.LanguageProfile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LanguageProfileWriter {
    public void write(@NotNull LanguageProfile languageProfile, @NotNull OutputStream outputStream) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, Charset.forName("utf-8")));){
            long nWord;
            writer.write("{\"freq\":{");
            boolean first = true;
            for (Map.Entry<String, Integer> entry : languageProfile.iterateGrams()) {
                if (!first) {
                    writer.write(44);
                }
                writer.write(34);
                writer.write(entry.getKey());
                writer.write("\":");
                writer.write(entry.getValue().toString());
                first = false;
            }
            writer.write("},\"n_words\":[");
            first = true;
            for (int i = 1; i <= 10 && (nWord = languageProfile.getNumGramOccurrences(i)) != 0L; ++i) {
                if (!first) {
                    writer.write(44);
                }
                writer.write(Long.toString(nWord));
                first = false;
            }
            writer.write("],\"name\":\"");
            writer.write(languageProfile.getLocale().toString());
            writer.write("\"}");
            writer.flush();
        }
    }

    public void writeToDirectory(@NotNull LanguageProfile languageProfile, @NotNull File fullPath) throws IOException {
        if (!fullPath.exists()) {
            throw new IOException("Path does not exist: " + fullPath);
        }
        if (!fullPath.canWrite()) {
            throw new IOException("Path not writable: " + fullPath);
        }
        File file = new File(fullPath.getAbsolutePath() + "/" + languageProfile.getLocale());
        if (file.exists()) {
            throw new IOException("File exists already, refusing to overwrite: " + file);
        }
        try (FileOutputStream output = new FileOutputStream(file);){
            this.write(languageProfile, output);
        }
    }
}

