/*
 * Decompiled with CFR 0.152.
 */
package a_vcard.android.syncml.pim.vcard;

import a_vcard.android.syncml.pim.vcard.ContactStruct;
import a_vcard.android.syncml.pim.vcard.VCardException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardComposer {
    public static final int VERSION_VCARD21_INT = 1;
    public static final int VERSION_VCARD30_INT = 2;
    private String mNewline;
    private StringBuilder mResult;
    private static final HashSet<String> emailTypes = new HashSet<String>(Arrays.asList("CELL", "AOL", "APPLELINK", "ATTMAIL", "CIS", "EWORLD", "INTERNET", "IBMMAIL", "MCIMAIL", "POWERSHARE", "PRODIGY", "TLX", "X400"));
    private static final HashSet<String> phoneTypes = new HashSet<String>(Arrays.asList("PREF", "WORK", "HOME", "VOICE", "FAX", "MSG", "CELL", "PAGER", "BBS", "MODEM", "CAR", "ISDN", "VIDEO"));
    private static final String TAG = "VCardComposer";
    private static final HashMap<Integer, String> phoneTypeMap = new HashMap();
    private static final HashMap<Integer, String> emailTypeMap = new HashMap();

    public String createVCard(ContactStruct struct, int vcardversion) throws VCardException {
        this.mResult = new StringBuilder();
        if (struct.name == null || struct.name.trim().equals("")) {
            throw new VCardException(" struct.name MUST have value.");
        }
        if (vcardversion == 1) {
            this.mNewline = "\r\n";
        } else if (vcardversion == 2) {
            this.mNewline = "\n";
        } else {
            throw new VCardException(" version not match VERSION_VCARD21 or VERSION_VCARD30.");
        }
        this.mResult.append("BEGIN:VCARD").append(this.mNewline);
        if (vcardversion == 1) {
            this.mResult.append("VERSION:2.1").append(this.mNewline);
        } else {
            this.mResult.append("VERSION:3.0").append(this.mNewline);
        }
        if (!this.isNull(struct.name)) {
            this.appendNameStr(struct.name);
        }
        if (!this.isNull(struct.company)) {
            this.mResult.append("ORG:").append(struct.company).append(this.mNewline);
        }
        if (struct.notes.size() > 0 && !this.isNull(struct.notes.get(0))) {
            this.mResult.append("NOTE:").append(this.foldingString(struct.notes.get(0), vcardversion)).append(this.mNewline);
        }
        if (!this.isNull(struct.title)) {
            this.mResult.append("TITLE:").append(this.foldingString(struct.title, vcardversion)).append(this.mNewline);
        }
        if (struct.photoBytes != null) {
            this.appendPhotoStr(struct.photoBytes, struct.photoType, vcardversion);
        }
        if (struct.phoneList != null) {
            this.appendPhoneStr(struct.phoneList, vcardversion);
        }
        if (struct.contactmethodList != null) {
            this.appendContactMethodStr(struct.contactmethodList, vcardversion);
        }
        this.mResult.append("END:VCARD").append(this.mNewline);
        return this.mResult.toString();
    }

    private String foldingString(String str, int version) {
        if (str.endsWith("\r\n")) {
            str = str.substring(0, str.length() - 2);
        } else if (str.endsWith("\n")) {
            str = str.substring(0, str.length() - 1);
        } else {
            return null;
        }
        str = str.replaceAll("\r\n", "\n");
        if (version == 1) {
            return str.replaceAll("\n", "\r\n ");
        }
        if (version == 2) {
            return str.replaceAll("\n", "\n ");
        }
        return null;
    }

    private void appendPhotoStr(byte[] bytes, String type, int version) throws VCardException {
        String encodingStr;
        int indexOfSlash;
        String value;
        try {
            value = this.foldingString(new String(Base64.encodeBase64((byte[])bytes, (boolean)true)), version);
        }
        catch (Exception e) {
            throw new VCardException(e.getMessage());
        }
        type = this.isNull(type) || type.toUpperCase().indexOf("JPEG") >= 0 ? "JPEG" : (type.toUpperCase().indexOf("GIF") >= 0 ? "GIF" : (type.toUpperCase().indexOf("BMP") >= 0 ? "BMP" : ((indexOfSlash = type.indexOf("/")) >= 0 ? type.substring(indexOfSlash + 1).toUpperCase() : type.toUpperCase())));
        this.mResult.append("LOGO;TYPE=").append(type);
        if (version == 1) {
            encodingStr = ";ENCODING=BASE64:";
            value = value + this.mNewline;
        } else if (version == 2) {
            encodingStr = ";ENCODING=b:";
        } else {
            return;
        }
        this.mResult.append(encodingStr).append(value).append(this.mNewline);
    }

    private boolean isNull(String str) {
        return str == null || str.trim().equals("");
    }

    private void appendNameStr(String name) {
        this.mResult.append("FN:").append(name).append(this.mNewline);
        this.mResult.append("N:").append(name).append(this.mNewline);
    }

    private void appendPhoneStr(List<ContactStruct.PhoneData> phoneList, int version) {
        HashMap<String, String> numMap = new HashMap<String, String>();
        String joinMark = version == 1 ? ";" : ",";
        for (ContactStruct.PhoneData phoneData : phoneList) {
            if (this.isNull(phoneData.data)) continue;
            String type = this.getPhoneTypeStr(phoneData);
            if (version == 2 && type.indexOf(";") != -1) {
                type = type.replace(";", ",");
            }
            if (numMap.containsKey(phoneData.data)) {
                type = (String)numMap.get(phoneData.data) + joinMark + type;
            }
            numMap.put(phoneData.data, type);
        }
        for (Map.Entry entry : numMap.entrySet()) {
            if (version == 1) {
                this.mResult.append("TEL;");
            } else {
                this.mResult.append("TEL;TYPE=");
            }
            this.mResult.append((String)entry.getValue()).append(":").append((String)entry.getKey()).append(this.mNewline);
        }
    }

    private String getPhoneTypeStr(ContactStruct.PhoneData phone) {
        String label;
        int phoneType = phone.type;
        String typeStr = phoneTypeMap.containsKey(phoneType) ? phoneTypeMap.get(phoneType) : (phoneType == 0 ? (phoneTypes.contains(label = phone.label.toUpperCase()) || label.startsWith("X-") ? label : "X-CUSTOM-" + label) : "VOICE");
        return typeStr;
    }

    private void appendContactMethodStr(List<ContactStruct.ContactMethod> contactMList, int version) {
        HashMap<String, String> emailMap = new HashMap<String, String>();
        String joinMark = version == 1 ? ";" : ",";
        for (ContactStruct.ContactMethod contactMethod : contactMList) {
            switch (contactMethod.kind) {
                case 1: {
                    String mailType = "INTERNET";
                    if (this.isNull(contactMethod.data)) break;
                    int methodType = new Integer(contactMethod.type);
                    if (emailTypeMap.containsKey(methodType)) {
                        mailType = emailTypeMap.get(methodType);
                    } else if (emailTypes.contains(contactMethod.label.toUpperCase())) {
                        mailType = contactMethod.label.toUpperCase();
                    }
                    if (emailMap.containsKey(contactMethod.data)) {
                        mailType = (String)emailMap.get(contactMethod.data) + joinMark + mailType;
                    }
                    emailMap.put(contactMethod.data, mailType);
                    break;
                }
                case 2: {
                    if (this.isNull(contactMethod.data)) break;
                    this.mResult.append("ADR;TYPE=POSTAL:").append(this.foldingString(contactMethod.data, version)).append(this.mNewline);
                    break;
                }
            }
        }
        for (Map.Entry entry : emailMap.entrySet()) {
            if (version == 1) {
                this.mResult.append("EMAIL;");
            } else {
                this.mResult.append("EMAIL;TYPE=");
            }
            this.mResult.append((String)entry.getValue()).append(":").append((String)entry.getKey()).append(this.mNewline);
        }
    }

    static {
        phoneTypeMap.put(1, "HOME");
        phoneTypeMap.put(2, "CELL");
        phoneTypeMap.put(3, "WORK");
        phoneTypeMap.put(4, "WORK;FAX");
        phoneTypeMap.put(5, "HOME;FAX");
        phoneTypeMap.put(6, "PAGER");
        phoneTypeMap.put(7, "X-OTHER");
        emailTypeMap.put(1, "HOME");
        emailTypeMap.put(2, "WORK");
    }
}

