/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import java.util.Collection;
import org.gradle.internal.Cast;
import org.gradle.model.internal.core.DefaultModelViewState;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScalarCollectionModelView<E, C extends Collection<E>>
implements ModelView<C> {
    protected final ModelPath path;
    protected final ModelType<E> elementType;
    protected final ModelType<C> type;
    protected final MutableModelNode modelNode;
    protected final boolean overwritable;
    protected final DefaultModelViewState state;

    public ScalarCollectionModelView(ModelPath path, ModelType<C> type, ModelType<E> elementType, MutableModelNode modelNode, ModelRuleDescriptor descriptor, boolean overwritable, boolean mutable) {
        this.path = path;
        this.type = type;
        this.elementType = elementType;
        this.modelNode = modelNode;
        this.overwritable = overwritable;
        this.state = new DefaultModelViewState(path, type, descriptor, mutable, false);
    }

    @Override
    public ModelPath getPath() {
        return this.path;
    }

    @Override
    public ModelType<C> getType() {
        return this.type;
    }

    private Collection<E> getBackingValue() {
        return (Collection)Cast.uncheckedCast((Object)this.modelNode.getPrivateData(Collection.class));
    }

    private void setBackingValue(Collection<E> values) {
        if (this.state.isCanMutate()) {
            this.modelNode.setPrivateData(Collection.class, values);
        }
    }

    protected abstract C toMutationSafe(Collection<?> var1);

    @Override
    public C getInstance() {
        Collection<E> delegate = this.getBackingValue();
        if (delegate == null && (this.overwritable || this.state.isCanMutate())) {
            delegate = this.initializeEmptyCollection();
        }
        return delegate == null ? null : (C)this.toMutationSafe(delegate);
    }

    private Collection<E> initializeEmptyCollection() {
        C delegate = this.initialValue();
        this.setBackingValue((Collection<E>)delegate);
        return delegate;
    }

    @Override
    public void close() {
        Object instance = this.getInstance();
        this.state.closer().execute(instance);
    }

    protected abstract C initialValue();

    public Object setValue(Object values) {
        this.state.assertCanMutate();
        if (values == null) {
            this.setBackingValue(null);
            return null;
        }
        Collection<E> objects = this.initializeEmptyCollection();
        objects.addAll((Collection)values);
        return objects;
    }
}

