/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health.memory;

import org.gradle.internal.os.OperatingSystem;
import org.gradle.launcher.daemon.server.health.memory.MBeanAttributeProvider;
import org.gradle.launcher.daemon.server.health.memory.MBeanAvailableMemory;
import org.gradle.launcher.daemon.server.health.memory.MeminfoAvailableMemory;
import org.gradle.launcher.daemon.server.health.memory.VmstatAvailableMemory;

public class MemoryInfo {
    private final long totalMemory = Runtime.getRuntime().maxMemory();

    public long getMaxMemory() {
        return this.totalMemory;
    }

    public long getCommittedMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public long getTotalPhysicalMemory() {
        return MBeanAttributeProvider.getMbeanAttribute("java.lang:type=OperatingSystem", "TotalPhysicalMemorySize", Long.class);
    }

    public long getFreePhysicalMemory() {
        OperatingSystem operatingSystem = OperatingSystem.current();
        if (operatingSystem.isMacOsX()) {
            return new VmstatAvailableMemory().get();
        }
        if (operatingSystem.isLinux()) {
            return new MeminfoAvailableMemory().get();
        }
        return new MBeanAvailableMemory().get();
    }
}

