/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.DefaultAttributeContainer;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImmutableAttributes
implements AttributeContainerInternal {
    private static final Comparator<Attribute<?>> ATTRIBUTE_NAME_COMPARATOR = new Comparator<Attribute<?>>(){

        @Override
        public int compare(Attribute<?> o1, Attribute<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final Map<Attribute<?>, Object> attributes;

    ImmutableAttributes(Map<Attribute<?>, Object> attributes) {
        assert (!attributes.isEmpty());
        this.attributes = ImmutableMap.copyOf(attributes);
    }

    @Override
    public Set<Attribute<?>> keySet() {
        return this.attributes.keySet();
    }

    @Override
    public <T> AttributeContainer attribute(Attribute<T> key, T value) {
        throw new UnsupportedOperationException("Mutation of attributes returned by Configuration#getAttributes() is not allowed");
    }

    @Override
    public <T> T getAttribute(Attribute<T> key) {
        return (T)Cast.uncheckedCast((Object)this.attributes.get(key));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Attribute<?> key) {
        return this.attributes.containsKey(key);
    }

    @Override
    public AttributeContainerInternal asImmutable() {
        return this;
    }

    @Override
    public AttributeContainerInternal copy() {
        DefaultAttributeContainer copy = new DefaultAttributeContainer();
        for (Attribute<?> attribute : this.attributes.keySet()) {
            Attribute castAttribute = (Attribute)Cast.uncheckedCast(attribute);
            copy.attribute(castAttribute, this.attributes.get(castAttribute));
        }
        return copy;
    }

    @Override
    public AttributeContainer getAttributes() {
        return this;
    }

    public String toString() {
        TreeMap sorted = new TreeMap(ATTRIBUTE_NAME_COMPARATOR);
        sorted.putAll(this.attributes);
        return ((Object)sorted).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableAttributes)) {
            return false;
        }
        ImmutableAttributes that = (ImmutableAttributes)o;
        return Objects.equal(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.attributes});
    }
}

