/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.indexing;

import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.LanguageSubstitutors;

public class SubstitutedFileType
extends LanguageFileType {
    @NotNull
    private final FileType myOriginalFileType;
    @NotNull
    private final FileType myFileType;

    private SubstitutedFileType(@NotNull FileType originalFileType, @NotNull LanguageFileType substitutionFileType, @NotNull Language substitutedLanguage) {
        if (originalFileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFileType", "org/jetbrains/kotlin/com/intellij/util/indexing/SubstitutedFileType", "<init>"));
        }
        if (substitutionFileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutionFileType", "org/jetbrains/kotlin/com/intellij/util/indexing/SubstitutedFileType", "<init>"));
        }
        if (substitutedLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutedLanguage", "org/jetbrains/kotlin/com/intellij/util/indexing/SubstitutedFileType", "<init>"));
        }
        super(substitutedLanguage);
        this.myOriginalFileType = originalFileType;
        this.myFileType = substitutionFileType;
    }

    @NotNull
    public static FileType substituteFileType(@NotNull VirtualFile file2, @NotNull FileType fileType, Project project) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/util/indexing/SubstitutedFileType", "substituteFileType"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "org/jetbrains/kotlin/com/intellij/util/indexing/SubstitutedFileType", "substituteFileType"));
        }
        if (project == null) {
            FileType fileType2 = fileType;
            if (fileType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/indexing/SubstitutedFileType", "substituteFileType"));
            }
            return fileType2;
        }
        if (fileType instanceof LanguageFileType) {
            Language language = ((LanguageFileType)fileType).getLanguage();
            Language substitutedLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language, file2, project);
            LanguageFileType substFileType = substitutedLanguage.getAssociatedFileType();
            if (!substitutedLanguage.equals(language) && substFileType != null) {
                SubstitutedFileType substitutedFileType = new SubstitutedFileType(fileType, substFileType, substitutedLanguage);
                if (substitutedFileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/indexing/SubstitutedFileType", "substituteFileType"));
                }
                return substitutedFileType;
            }
        }
        FileType fileType3 = fileType;
        if (fileType3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/indexing/SubstitutedFileType", "substituteFileType"));
        }
        return fileType3;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myFileType.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/indexing/SubstitutedFileType", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myFileType.getDescription();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/indexing/SubstitutedFileType", "getDescription"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDefaultExtension() {
        String string = this.myFileType.getDefaultExtension();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/indexing/SubstitutedFileType", "getDefaultExtension"));
        }
        return string;
    }

    @Override
    public Icon getIcon() {
        return this.myFileType.getIcon();
    }

    @Override
    public String getCharset(@NotNull VirtualFile file2, @NotNull byte[] content) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/util/indexing/SubstitutedFileType", "getCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/kotlin/com/intellij/util/indexing/SubstitutedFileType", "getCharset"));
        }
        return this.myFileType.getCharset(file2, content);
    }

    public String toString() {
        return "SubstitutedFileType: original=" + this.myOriginalFileType + "; substituted=" + this.myFileType;
    }
}

