/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.io.UnsyncByteArrayInputStream;
import org.jetbrains.kotlin.com.intellij.util.lang.Resource;

class MemoryResource
extends Resource {
    private final URL myUrl;
    private final byte[] myContent;
    private final Map<Resource.Attribute, String> myAttributes;

    private MemoryResource(URL url, byte[] content, Map<Resource.Attribute, String> attributes) {
        this.myUrl = url;
        this.myContent = content;
        this.myAttributes = attributes;
    }

    @Override
    public URL getURL() {
        return this.myUrl;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new UnsyncByteArrayInputStream(this.myContent);
    }

    @Override
    public byte[] getBytes() throws IOException {
        return this.myContent;
    }

    @Override
    public String getValue(Resource.Attribute key) {
        return this.myAttributes != null ? this.myAttributes.get((Object)key) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static MemoryResource load(URL baseUrl, @NotNull ZipFile zipFile, @NotNull ZipEntry entry, @Nullable Map<Resource.Attribute, String> attributes) throws IOException {
        if (zipFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zipFile", "org/jetbrains/kotlin/com/intellij/util/lang/MemoryResource", "load"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/com/intellij/util/lang/MemoryResource", "load"));
        }
        String name2 = entry.getName();
        URL url = new URL(baseUrl, name2);
        byte[] content = ArrayUtil.EMPTY_BYTE_ARRAY;
        InputStream stream2 = zipFile.getInputStream(entry);
        if (stream2 != null) {
            try {
                content = FileUtil.loadBytes(stream2, (int)entry.getSize());
            }
            finally {
                stream2.close();
            }
        }
        MemoryResource memoryResource = new MemoryResource(url, content, attributes);
        if (memoryResource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/lang/MemoryResource", "load"));
        }
        return memoryResource;
    }
}

