/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.sourceMap;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.JsToStringGenerationVisitor;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsProgramFragment;
import org.jetbrains.kotlin.com.google.dart.compiler.util.TextOutput;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.js.sourceMap.SourceMapBuilder;

public class JsSourceGenerationVisitor
extends JsToStringGenerationVisitor
implements TextOutput.OutListener {
    @Nullable
    private final SourceMapBuilder sourceMapBuilder;
    private final List<Object> pendingSources = new SmartList<Object>();

    public JsSourceGenerationVisitor(TextOutput out, @Nullable SourceMapBuilder sourceMapBuilder) {
        super(out);
        this.sourceMapBuilder = sourceMapBuilder;
        out.setOutListener(this);
    }

    @Override
    public void visitProgramFragment(@NotNull JsProgramFragment x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/sourceMap/JsSourceGenerationVisitor", "visitProgramFragment"));
        }
        x.acceptChildren(this);
    }

    @Override
    public void newLined() {
        if (this.sourceMapBuilder != null) {
            this.sourceMapBuilder.newLine();
        }
    }

    @Override
    public void indentedAfterNewLine() {
        if (this.pendingSources.isEmpty()) {
            return;
        }
        assert (this.sourceMapBuilder != null);
        for (Object source : this.pendingSources) {
            this.sourceMapBuilder.processSourceInfo(source);
        }
        this.pendingSources.clear();
    }

    public void accept(JsNode node) {
        if (!(node instanceof JsNameRef) && !(node instanceof JsLiteral.JsThisRef)) {
            this.mapSource(node);
        }
        super.accept(node);
    }

    private void mapSource(JsNode node) {
        Object sourceInfo;
        if (this.sourceMapBuilder != null && (sourceInfo = node.getSource()) != null) {
            if (this.p.isJustNewlined()) {
                this.pendingSources.add(sourceInfo);
            } else {
                this.sourceMapBuilder.processSourceInfo(sourceInfo);
            }
        }
    }

    @Override
    protected void beforeNodePrinted(JsNode node) {
        this.mapSource(node);
    }

    @Override
    public void visitProgram(@NotNull JsProgram program) {
        if (program == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "program", "org/jetbrains/kotlin/js/sourceMap/JsSourceGenerationVisitor", "visitProgram"));
        }
        program.acceptChildren(this);
        if (this.sourceMapBuilder != null) {
            this.sourceMapBuilder.addLink();
        }
    }
}

