/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal.resolve;

import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionRules;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultResolutionStrategy;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.jvm.internal.resolve.UsageKind;
import org.gradle.jvm.internal.resolve.VariantsMetaData;
import org.gradle.language.base.internal.model.DefaultLibraryLocalComponentMetadata;
import org.gradle.platform.base.DependencySpec;

public class JvmLibraryResolveContext
implements ResolveContext {
    private final LibraryBinaryIdentifier libraryBinaryIdentifier;
    private final String displayName;
    private final UsageKind usage;
    private final ResolutionStrategyInternal resolutionStrategy = new DefaultResolutionStrategy(DependencySubstitutionRules.NO_OP, null);
    private final VariantsMetaData variants;
    private final Iterable<DependencySpec> dependencies;

    public JvmLibraryResolveContext(LibraryBinaryIdentifier libraryBinaryIdentifier, VariantsMetaData variants, Iterable<DependencySpec> dependencies, UsageKind usage, String displayName) {
        this.libraryBinaryIdentifier = libraryBinaryIdentifier;
        this.usage = usage;
        this.displayName = displayName;
        this.variants = variants;
        this.dependencies = dependencies;
    }

    public String getName() {
        return this.usage.getConfigurationName();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public VariantsMetaData getVariants() {
        return this.variants;
    }

    public ResolutionStrategyInternal getResolutionStrategy() {
        return this.resolutionStrategy;
    }

    public ComponentResolveMetadata toRootComponentMetaData() {
        return DefaultLibraryLocalComponentMetadata.newResolvingLocalComponentMetadata((LibraryBinaryIdentifier)this.libraryBinaryIdentifier, (String)this.usage.getConfigurationName(), this.dependencies);
    }
}

