/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache;

import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;

class CachedModuleVersionResult {
    private final BuildableModuleComponentMetaDataResolveResult.State state;
    private final boolean authoritative;
    private final ModuleComponentResolveMetadata metaData;

    public CachedModuleVersionResult(BuildableModuleComponentMetaDataResolveResult result) {
        this.state = result.getState();
        if (this.state == BuildableModuleComponentMetaDataResolveResult.State.Resolved) {
            this.metaData = result.getMetaData();
            this.authoritative = result.isAuthoritative();
        } else if (this.state == BuildableModuleComponentMetaDataResolveResult.State.Missing) {
            this.metaData = null;
            this.authoritative = result.isAuthoritative();
        } else {
            this.metaData = null;
            this.authoritative = false;
        }
    }

    public boolean isCacheable() {
        return this.state == BuildableModuleComponentMetaDataResolveResult.State.Missing || this.state == BuildableModuleComponentMetaDataResolveResult.State.Resolved;
    }

    public void supply(BuildableModuleComponentMetaDataResolveResult result) {
        assert (this.isCacheable()) : "Results are not cacheable, cannot supply the results.";
        if (this.state == BuildableModuleComponentMetaDataResolveResult.State.Resolved) {
            ModuleComponentResolveMetadata metaData = this.metaData;
            result.resolved(metaData);
            result.setAuthoritative(this.authoritative);
        } else if (this.state == BuildableModuleComponentMetaDataResolveResult.State.Missing) {
            result.missing();
            result.setAuthoritative(this.authoritative);
        }
    }
}

