/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributeValue;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.CompatibilityRuleChainInternal;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;

public class AmbiguousConfigurationSelectionException
extends IllegalArgumentException {
    private static final Function<ConfigurationMetadata, String> CONFIG_NAME = new Function<ConfigurationMetadata, String>(){

        public String apply(ConfigurationMetadata input) {
            return input.getName();
        }
    };
    private static final Joiner JOINER = Joiner.on((String)", ");
    static final Function<Attribute<?>, String> ATTRIBUTE_NAME = new Function<Attribute<?>, String>(){

        public String apply(Attribute<?> input) {
            return input.getName();
        }
    };

    public AmbiguousConfigurationSelectionException(AttributeContainer fromConfigurationAttributes, AttributesSchema consumerSchema, List<ConfigurationMetadata> matches, ComponentResolveMetadata targetComponent) {
        super(AmbiguousConfigurationSelectionException.generateMessage(fromConfigurationAttributes, consumerSchema, matches, targetComponent));
    }

    private static String generateMessage(AttributeContainer fromConfigurationAttributes, AttributesSchema consumerSchema, List<ConfigurationMetadata> matches, ComponentResolveMetadata targetComponent) {
        TreeSet ambiguousConfigurations = Sets.newTreeSet((Iterable)Lists.transform(matches, CONFIG_NAME));
        TreeSet requestedAttributes = Sets.newTreeSet((Iterable)Iterables.transform((Iterable)fromConfigurationAttributes.keySet(), ATTRIBUTE_NAME));
        StringBuilder sb = new StringBuilder("Cannot choose between the following configurations on '" + targetComponent + "' : ");
        JOINER.appendTo(sb, (Iterable)ambiguousConfigurations);
        sb.append(". All of them match the consumer attributes:");
        sb.append("\n");
        int maxConfLength = AmbiguousConfigurationSelectionException.maxLength(ambiguousConfigurations);
        for (String ambiguousConf : ambiguousConfigurations) {
            AmbiguousConfigurationSelectionException.formatConfiguration(sb, fromConfigurationAttributes, consumerSchema, matches, requestedAttributes, maxConfLength, ambiguousConf);
        }
        return sb.toString();
    }

    static void formatConfiguration(StringBuilder sb, AttributeContainer fromConfigurationAttributes, AttributesSchema consumerSchema, List<ConfigurationMetadata> matches, Set<String> requestedAttributes, int maxConfLength, final String conf) {
        Optional match = Iterables.tryFind(matches, (Predicate)new Predicate<ConfigurationMetadata>(){

            public boolean apply(ConfigurationMetadata input) {
                return conf.equals(input.getName());
            }
        });
        if (match.isPresent()) {
            AttributeContainerInternal producerAttributes = ((ConfigurationMetadata)match.get()).getAttributes();
            Set targetAttributes = producerAttributes.keySet();
            TreeSet targetAttributeNames = Sets.newTreeSet((Iterable)Iterables.transform((Iterable)targetAttributes, ATTRIBUTE_NAME));
            Sets.SetView allAttributes = Sets.union((Set)fromConfigurationAttributes.keySet(), (Set)producerAttributes.keySet());
            Sets.SetView commonAttributes = Sets.intersection(requestedAttributes, (Set)targetAttributeNames);
            Sets.SetView consumerOnlyAttributes = Sets.difference(requestedAttributes, (Set)targetAttributeNames);
            sb.append("   ").append("- Configuration '").append(StringUtils.rightPad((String)(conf + "'"), (int)(maxConfLength + 1))).append(" :");
            List sortedAttributes = Ordering.usingToString().sortedCopy((Iterable)allAttributes);
            ArrayList<String> values = new ArrayList<String>(sortedAttributes.size());
            AmbiguousConfigurationSelectionException.formatAttributes(sb, fromConfigurationAttributes, consumerSchema, (AttributeContainer)producerAttributes, (Set<String>)commonAttributes, (Set<String>)consumerOnlyAttributes, sortedAttributes, values);
        }
    }

    private static void formatAttributes(StringBuilder sb, AttributeContainer fromConfigurationAttributes, AttributesSchema consumerSchema, AttributeContainer producerAttributes, Set<String> commonAttributes, Set<String> consumerOnlyAttributes, List<Attribute<?>> sortedAttributes, final List<String> values) {
        for (Attribute<?> attribute : sortedAttributes) {
            final String attributeName = attribute.getName();
            if (commonAttributes.contains(attributeName)) {
                AttributeMatchingStrategy strategy = consumerSchema.getMatchingStrategy(attribute);
                CompatibilityRuleChainInternal compatibilityRules = (CompatibilityRuleChainInternal)Cast.uncheckedCast((Object)strategy.getCompatibilityRules());
                final Object consumerValue = fromConfigurationAttributes.getAttribute(attribute);
                final Object producerValue = producerAttributes.getAttribute(attribute);
                compatibilityRules.execute((Object)new CompatibilityCheckDetails<Object>(){

                    public AttributeValue<Object> getConsumerValue() {
                        return AttributeValue.of((Object)consumerValue);
                    }

                    public AttributeValue<Object> getProducerValue() {
                        return AttributeValue.of((Object)producerValue);
                    }

                    public void compatible() {
                        values.add("      - Required " + attributeName + " '" + consumerValue + "' and found compatible value '" + producerValue + "'.");
                    }

                    public void incompatible() {
                        values.add("      - Required " + attributeName + " '" + consumerValue + "' and found incompatible value '" + producerValue + "'.");
                    }
                });
                continue;
            }
            if (consumerOnlyAttributes.contains(attributeName)) {
                values.add("      - Required " + attributeName + " '" + fromConfigurationAttributes.getAttribute(attribute) + "' but no value provided.");
                continue;
            }
            values.add("      - Found " + attributeName + " '" + producerAttributes.getAttribute(attribute) + "' but wasn't required.");
        }
        sb.append("\n");
        sb.append(Joiner.on((String)"\n").join(values));
        sb.append("\n");
    }

    static int maxLength(Collection<String> strings) {
        return (Integer)Ordering.natural().max(Iterables.transform(strings, (Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                return input.length();
            }
        }));
    }
}

