/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import org.jmol.api.JmolRendererInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.viewer.JC;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public abstract class ShapeRenderer {
    public Viewer vwr;
    protected TransformManager tm;
    public JmolRendererInterface g3d;
    protected ModelSet ms;
    protected Shape shape;
    protected int myVisibilityFlag;
    protected int shapeID;
    public short colix;
    public short mad;
    public int exportType;
    protected boolean isExport;

    protected void initRenderer() {
    }

    protected abstract boolean render();

    public final void setViewerG3dShapeID(Viewer vwr, int shapeID) {
        this.vwr = vwr;
        this.tm = vwr.tm;
        this.shapeID = shapeID;
        this.myVisibilityFlag = JC.getShapeVisibilityFlag(shapeID);
        this.initRenderer();
    }

    public boolean renderShape(JmolRendererInterface g3d, ModelSet modelSet, Shape shape) {
        this.setup(g3d, modelSet, shape);
        boolean needsTranslucent = this.render();
        this.exportType = 0;
        this.isExport = false;
        return needsTranslucent;
    }

    public void setup(JmolRendererInterface g3d, ModelSet modelSet, Shape shape) {
        this.g3d = g3d;
        this.ms = modelSet;
        this.shape = shape;
        this.exportType = g3d.getExportType();
        this.isExport = this.exportType != 0;
    }

    protected boolean isVisibleForMe(Atom a) {
        return a.isVisible(this.myVisibilityFlag | 9);
    }
}

