/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import org.gennbo.NBOFileHandler;
import org.gennbo.NBOPlugin;
import org.gennbo.NBOService;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.jmolpanel.JmolPanel;

abstract class NBODialogConfig
extends JDialog {
    protected static final String NBO_WEB_SITE = "http://nbo6.chem.wisc.edu";
    protected static final String ARCHIVE_DIR = "http://nbo6.chem.wisc.edu/jmol_nborxiv/";
    protected static final int DIALOG_HOME = 0;
    protected static final int DIALOG_MODEL = 1;
    protected static final int DIALOG_RUN = 2;
    protected static final int DIALOG_VIEW = 3;
    protected static final int DIALOG_SEARCH = 4;
    protected static final int DIALOG_CONFIG = 5;
    protected static final int DIALOG_HELP = 6;
    private static final String[] dialogNames = new String[]{"Home", "Model", "Run", "View", "Search", "Settings", "Help"};
    protected static final int ORIGIN_UNKNOWN = 0;
    protected static final int ORIGIN_NIH = 1;
    protected static final int ORIGIN_LINE_FORMULA = 2;
    protected static final int ORIGIN_FILE_INPUT = 3;
    protected static final int ORIGIN_NBO_ARCHIVE = 4;
    protected int modelOrigin = 0;
    private static final String DEFAULT_SCRIPT = "zap;set antialiasdisplay;set fontscaling;set bondpicking true;set multipleBondSpacing -0.5;set zoomlarge false;select none;";
    protected static final String INPUT_FILE_EXTENSIONS = "adf;cfi;com;g09;gau;gms;jag;log;mm2;mnd;mol;mp;nw;orc;pqs;qc;vfi;xyz;47";
    protected static final String OUTPUT_FILE_EXTENSIONS = "adf;cfi;gau;gms;jag;mm2;mnd;mp;nw;orc;pqs;qc;mol;xyz;vfi;g09;com";
    protected static final String JMOL_EXTENSIONS = "xyz;mol";
    protected static final String sep = System.getProperty("line.separator");
    protected static final String JMOL_FONT_SCRIPT = ";set fontscaling true; select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;";
    protected NBOPlugin nboPlugin;
    protected static final Font listFont = new Font("Monospaced", 1, 14);
    protected static final Font monoFont = new Font("Monospaced", 1, 16);
    protected static final Font userInputFont = new Font("Arial", 0, 12);
    protected static final Font settingHelpFont = new Font("Arial", 0, 14);
    protected static final Font searchOpListFont;
    protected static final Font statusFont;
    protected static final Font searchTextAreaFont;
    protected static final Font iconFont;
    protected static final Font nboFont;
    protected static final Font homeTextFont;
    protected static final Font titleFont;
    protected static final Font runButtonFont;
    protected static final Font topFont;
    protected static final Font homeButtonFont;
    protected static final Font nboFontLarge;
    protected static final Font nboProTitleFont;
    private static final int MODE_PATH_SERVICE = 0;
    private static final int MODE_PATH_WORKING = 1;
    protected static final Color titleColor;
    private static final String NBOPROPERTY_DISPLAY_OPTIONS = "displayOptions";
    protected Viewer vwr;
    protected NBOService nboService;
    protected JLabel icon;
    protected JSplitPane centerPanel;
    protected JPanel modulePanel;
    protected boolean jmolOptionNOZAP = false;
    protected boolean jmolOptionNOSET = false;
    protected boolean jmolOptionVIEW = false;
    protected boolean jmolOptionNONBO = false;
    protected JLabel statusLab;
    protected JTextPane jpNBODialog;
    protected JSlider opacity = new JSlider(0, 10);
    protected JPanel settingsPanel;
    protected JComboBox<Color> colorBox1;
    protected JComboBox<Color> colorBox2;
    protected JCheckBox jCheckAtomNum;
    protected JCheckBox jCheckSelHalo;
    protected JCheckBox jCheckDebugVerbose;
    protected JCheckBox jCheckNboView;
    protected JCheckBox jCheckWireMesh;
    protected Color orbColor1;
    protected Color orbColor2;
    protected Color backgroundColor;
    protected String orbColorJmol1;
    protected String orbColorJmol2;
    protected float opacityOp;
    protected boolean nboView;
    protected boolean useWireMesh;
    private boolean showAtNum;
    protected boolean debugVerbose;
    private String rsTypeLast = "alpha";
    protected NBOFileHandler inputFileHandler;
    protected int dialogMode;
    protected boolean haveService;
    protected String nboOutputBodyText = "";
    protected boolean iAmLoading;

    protected abstract void setStatus(String var1);

    protected abstract void updatePanelSettings();

    protected abstract NBOFileHandler newNBOFileHandler(String var1, String var2, int var3, String var4);

    protected static String getDialogName(int type) {
        return dialogNames[type];
    }

    protected void resetVariables_c() {
        this.rsTypeLast = "alpha";
    }

    protected NBODialogConfig(JFrame f) {
        super(f);
    }

    protected void alertRequiresNBOServe() {
        this.vwr.alert("This functionality requires NBOServe.");
    }

    protected String getJmolWorkingPath() {
        String path = JmolPanel.getJmolProperty("workingPath", System.getProperty("user.home"));
        this.saveWorkingPath(path);
        return path;
    }

    protected String getWorkingPath() {
        String path = this.nboPlugin.getNBOProperty("workingPath", null);
        return path == null ? this.getJmolWorkingPath() : path;
    }

    protected void saveWorkingPath(String path) {
        this.nboPlugin.setNBOProperty("workingPath", path);
    }

    protected JPanel buildSettingsPanel(JPanel settingsPanel) {
        settingsPanel.removeAll();
        this.checkNBOStatus();
        String viewOpts = this.getOrbitalDisplayOptions();
        settingsPanel.setLayout(new BoxLayout(settingsPanel, 1));
        this.addPathSetting(settingsPanel, 0);
        this.addPathSetting(settingsPanel, 1);
        JButton jbDefaults = new JButton("Set Defaults");
        jbDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogConfig.this.doSetDefaults(false);
            }
        });
        settingsPanel.add(NBODialogConfig.createTitleBox(" Settings ", jbDefaults));
        this.jCheckAtomNum = new JCheckBox("Show Atom Numbers");
        this.jCheckAtomNum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogConfig.this.doSettingAtomNums();
            }
        });
        this.showAtNum = true;
        this.jCheckAtomNum.setSelected(true);
        Box settingsBox = this.createBorderBox(true);
        settingsBox.add(this.jCheckAtomNum);
        this.jCheckSelHalo = new JCheckBox("Show selection halos on atoms");
        this.jCheckSelHalo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogConfig.this.doSettingShowHalos();
            }
        });
        this.jCheckSelHalo.doClick();
        settingsBox.add(this.jCheckSelHalo);
        this.jCheckWireMesh = new JCheckBox("Use wire mesh for orbital display");
        settingsBox.add(this.jCheckWireMesh);
        Color[] colors = new Color[]{Color.red, Color.orange, Color.yellow, Color.green, Color.cyan, Color.blue, Color.magenta};
        JPanel displayOps = new JPanel(new GridLayout(1, 4));
        JLabel label = new JLabel("     (+) color: ");
        displayOps.add(label);
        this.colorBox1 = new JComboBox<Color>(colors);
        this.colorBox1.setRenderer(new ColorRenderer());
        this.colorBox1.setSelectedItem(this.orbColor1);
        displayOps.add(this.colorBox1);
        this.colorBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogConfig.this.orbColor1 = (Color)NBODialogConfig.this.colorBox1.getSelectedItem();
                NBODialogConfig.this.setOrbitalDisplayOptions();
            }
        });
        displayOps.add(new JLabel("     (-) color: "));
        this.colorBox2 = new JComboBox<Color>(colors);
        this.colorBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogConfig.this.orbColor2 = (Color)NBODialogConfig.this.colorBox2.getSelectedItem();
                NBODialogConfig.this.setOrbitalDisplayOptions();
            }
        });
        this.colorBox2.setSelectedItem(this.orbColor2);
        this.colorBox2.setRenderer(new ColorRenderer());
        displayOps.add(this.colorBox2);
        displayOps.setAlignmentX(0.0f);
        settingsBox.add(displayOps);
        settingsBox.add(Box.createRigidArea(new Dimension(10, 10)));
        this.opacity.setMajorTickSpacing(1);
        this.opacity.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 10; ++i) {
            labelTable.put(new Integer(i), new JLabel(i == 10 ? "1" : "0." + i));
        }
        this.opacity.setPaintLabels(true);
        this.opacity.setLabelTable(labelTable);
        this.opacity.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NBODialogConfig.this.opacityOp = (float)NBODialogConfig.this.opacity.getValue() / 10.0f;
                NBODialogConfig.this.setOrbitalDisplayOptions();
            }
        });
        Box opacBox = Box.createHorizontalBox();
        opacBox.add(new JLabel("Orbital opacity:  "));
        opacBox.setAlignmentX(0.0f);
        opacBox.add(this.opacity);
        settingsBox.add(opacBox);
        this.jCheckWireMesh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogConfig.this.doSettingWireMesh();
            }
        });
        if (this.useWireMesh) {
            this.jCheckWireMesh.setSelected(true);
        }
        this.jCheckNboView = new JCheckBox("Emulate NBO View");
        this.jCheckNboView.setSelected(true);
        this.jCheckNboView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogConfig.this.doSetDefaults(!((JCheckBox)e.getSource()).isSelected());
            }
        });
        this.jCheckDebugVerbose = new JCheckBox("Verbose Debugging");
        settingsBox.add(this.jCheckDebugVerbose);
        this.jCheckDebugVerbose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogConfig.this.debugVerbose = ((JCheckBox)e.getSource()).isSelected();
            }
        });
        if (!"nboView".equals(viewOpts) && !"default".equals(viewOpts)) {
            this.jCheckNboView.doClick();
        } else {
            this.opacity.setValue((int)(this.opacityOp * 10.0f));
        }
        settingsBox.setBorder(BorderFactory.createLineBorder(Color.black));
        settingsPanel.add(settingsBox);
        return settingsPanel;
    }

    protected void doSettingShowHalos() {
        this.runScriptNow("select " + this.jCheckSelHalo.isSelected());
    }

    protected void doSettingWireMesh() {
        this.useWireMesh = !this.useWireMesh;
        this.opacity.setValue(0);
    }

    protected void doSettingAtomNums() {
        this.showAtNum = !this.showAtNum;
        this.doSetStructure(null);
    }

    protected void setJmolOptions(Map<String, Object> jmolOptions) {
        String options = ("" + (jmolOptions == null ? "" : jmolOptions.get("options"))).toUpperCase();
        if (options.equals("VIEW")) {
            options = "VIEW;NOZAP;NOSET;NONBO";
        }
        this.jmolOptionVIEW = options.indexOf("VIEW") >= 0;
        this.jmolOptionNOZAP = options.indexOf("NOZAP") >= 0;
        this.jmolOptionNOSET = options.indexOf("NOSET") >= 0;
        this.jmolOptionNONBO = options.indexOf("NONBO") >= 0;
    }

    protected void doSetDefaults(boolean isJmol) {
        this.nboPlugin.setNBOProperty(NBOPROPERTY_DISPLAY_OPTIONS, "default");
        this.getOrbitalDisplayOptions();
        this.opacity.setValue((int)(this.opacityOp * 10.0f));
        this.colorBox1.setSelectedItem(this.orbColor1);
        this.colorBox2.setSelectedItem(this.orbColor2);
        this.jCheckWireMesh.setSelected(this.useWireMesh);
        this.jCheckAtomNum.setSelected(true);
        this.jCheckSelHalo.setSelected(true);
        this.jCheckDebugVerbose.setSelected(false);
        this.jCheckNboView.setSelected(false);
        if (isJmol) {
            if (!this.jmolOptionNONBO) {
                this.runScriptNow("background gray;set defaultcolors Jmol;refresh;");
            }
        } else {
            if (this.jCheckWireMesh.isSelected()) {
                this.jCheckWireMesh.doClick();
            }
            this.colorBox1.setSelectedItem(Color.cyan);
            this.colorBox2.setSelectedItem(Color.yellow);
            this.opacity.setValue(7);
            try {
                String atomColors = "";
                atomColors = GuiMap.getResourceString(this, "org/gennbo/assets/atomColors.txt");
                this.runScriptNow(atomColors + ";refresh");
            }
            catch (IOException e) {
                this.logError("atomColors.txt not found");
            }
            this.nboView = true;
        }
        this.updatePanelSettings();
    }

    protected void setOrbitalDisplayOptions() {
        this.orbColorJmol1 = "[" + this.orbColor1.getRed() + " " + this.orbColor1.getGreen() + " " + this.orbColor1.getBlue() + "]";
        this.orbColorJmol2 = "[" + this.orbColor2.getRed() + " " + this.orbColor2.getGreen() + " " + this.orbColor2.getBlue() + "]";
        this.updatePanelSettings();
        if (!this.nboView) {
            this.nboPlugin.setNBOProperty(NBOPROPERTY_DISPLAY_OPTIONS, this.orbColor1.getRGB() + "," + this.orbColor2.getRGB() + "," + this.opacityOp + "," + this.useWireMesh);
        }
    }

    private String getOrbitalDisplayOptions() {
        String options;
        String string = options = this.jmolOptionNONBO ? "jmol" : this.nboPlugin.getNBOProperty(NBOPROPERTY_DISPLAY_OPTIONS, "default");
        if (options.equals("default") || options.equals("nboView")) {
            this.orbColor1 = Color.cyan;
            this.orbColor2 = Color.yellow;
            this.opacityOp = 0.7f;
            this.useWireMesh = false;
        } else if (options.equals("jmol")) {
            this.orbColor1 = Color.blue;
            this.orbColor2 = Color.red;
            this.opacityOp = 1.0f;
            this.useWireMesh = true;
        } else {
            String[] toks = options.split(",");
            this.orbColor1 = new Color(Integer.parseInt(toks[0]));
            this.orbColor2 = new Color(Integer.parseInt(toks[1]));
            this.opacityOp = Float.parseFloat(toks[2]);
            this.useWireMesh = toks[3].contains("true");
        }
        return options;
    }

    private void addPathSetting(JPanel panel, final int mode) {
        String title = "";
        String path = "";
        switch (mode) {
            case 0: {
                title = " NBO Directory ";
                path = this.nboService.getServerPath(null);
                break;
            }
            case 1: {
                title = " Working Directory ";
                path = this.getWorkingPath();
            }
        }
        final JTextField tfPath = new JTextField(path);
        tfPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogConfig.this.doSetNBOPath(tfPath, mode);
            }
        });
        panel.add(NBODialogConfig.createTitleBox(title, null));
        Box serverBox = this.createBorderBox(true);
        serverBox.add(this.createPathBox(tfPath, mode));
        serverBox.setMaximumSize(new Dimension(350, 50));
        panel.add(serverBox);
    }

    protected void doSetNBOPath(JTextField tf, int mode) {
        String path = PT.rep(tf.getText(), "\\", "/");
        if (path.length() == 0) {
            return;
        }
        switch (mode) {
            case 0: {
                this.nboService.setServerPath(path);
                this.log("NBOServe location changed changed:<br> " + path, 'b');
                this.connect();
                break;
            }
            case 1: {
                if ((path + "/").equals(this.nboService.getServerPath(null))) {
                    this.vwr.alert("The working directory may not be the same as the directory containing NBOServe");
                    return;
                }
                this.nboPlugin.setNBOProperty("workingPath", path);
                this.log("Working path directory changed:<br> " + path, 'b');
            }
        }
    }

    private void checkNBOStatus() {
        if (this.jmolOptionNONBO) {
            return;
        }
        if (!this.nboService.restartIfNecessary()) {
            String s = "Could not connect to NBOServe. Check to make sure its path is correct. \nIf it is already running from another instance of Jmol, you must first close that instance.";
            this.alertError(s);
        }
    }

    private Box createPathBox(final JTextField tf, final int mode) {
        Box box = Box.createHorizontalBox();
        box.add(tf);
        JButton b = new JButton("Browse");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogConfig.this.doPathBrowseClicked(tf, tf.getText(), mode);
            }
        });
        box.add(b);
        return box;
    }

    protected void doPathBrowseClicked(JTextField tf, String fname, int mode) {
        JFileChooser myChooser = new JFileChooser();
        myChooser.setFileSelectionMode(1);
        myChooser.setSelectedFile(new File(fname + "/ "));
        int button = myChooser.showDialog(this, GT._("Select"));
        if (button == 0) {
            File newFile = myChooser.getSelectedFile();
            tf.setText(PT.rep(newFile.toString(), "\\", "/"));
            tf.postActionEvent();
        }
    }

    protected static Box createTitleBox(String title, Component rightSideComponent) {
        Box box = Box.createVerticalBox();
        JLabel label = new JLabel(title);
        label.setAlignmentX(0.0f);
        label.setBackground(titleColor);
        label.setForeground(Color.white);
        label.setFont(titleFont);
        label.setOpaque(true);
        if (rightSideComponent != null) {
            JPanel box2 = new JPanel(new BorderLayout());
            box2.setAlignmentX(0.0f);
            box2.add((Component)label, "West");
            box2.add(rightSideComponent, "East");
            box2.setMaximumSize(new Dimension(360, 25));
            box.add(box2);
        } else {
            box.add(label);
        }
        box.setAlignmentX(0.0f);
        return box;
    }

    protected Box createBorderBox(boolean isVertical) {
        Box box = isVertical ? Box.createVerticalBox() : Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        box.setBorder(BorderFactory.createLineBorder(Color.black));
        return box;
    }

    protected void centerDialog(JDialog d) {
        int x = this.getWidth() / 2 - d.getWidth() / 2 + this.getX();
        int y = this.getHeight() / 2 - d.getHeight() / 2;
        d.setLocation(x, y);
    }

    protected void logCmd(String msg) {
        this.log(msg, 'I');
    }

    protected void logValue(String msg) {
        this.log(msg, 'b');
    }

    protected void logStatus(String msg) {
        this.log(msg, 'p');
    }

    protected void logError(String msg) {
        this.log(msg, 'r');
    }

    private synchronized void log(String line, char chFormat) {
        if (this.dontLog(line, chFormat)) {
            return;
        }
        if (line.trim().length() >= 1) {
            String format0;
            line = PT.rep(line.trim(), "<", "&lt;");
            line = PT.rep(line, ">", "&gt;");
            line = PT.rep(line, "&lt;br&gt;", "<br>");
            String format1 = format0 = "" + chFormat;
            if (chFormat == 'r') {
                format0 = "b style=color:red";
                format1 = "b";
                this.setStatus("");
            }
            if (!format0.equals("p")) {
                line = "<" + format0 + ">" + line + "</" + format1 + ">";
            }
            this.nboOutputBodyText = this.nboOutputBodyText + line + "\n<br>";
            this.jpNBODialog.setText("<html><font face=\"Arial\">" + this.nboOutputBodyText + "</font></html>");
        }
        this.jpNBODialog.setCaretPosition(this.jpNBODialog.getDocument().getLength());
    }

    private boolean dontLog(String line, char chFormat) {
        return this.jpNBODialog == null || line.trim().equals("") || line.indexOf("read/unit=5/attempt to read past end") >= 0 || line.indexOf("*end*") >= 0 || !this.debugVerbose && "b|r|I".indexOf("" + chFormat) < 0;
    }

    protected void alertError(String line) {
        line = PT.rep(line.replace('\r', ' '), "\n\n", "\n");
        this.logError(line);
        this.vwr.alert(line);
    }

    protected void logInfo(String msg, int mode) {
        Logger.info(msg);
        this.log(msg, (char)(mode == 4 ? 112 : (mode == 2 ? 114 : (mode == 3 ? 98 : 105))));
    }

    protected void sendDefaultScript() {
        if (!this.jmolOptionNOSET) {
            this.runScriptQueued(DEFAULT_SCRIPT);
        }
    }

    protected void runScriptQueued(String script) {
        this.logInfo("_$ " + PT.rep(script, "\n", "<br>"), 5);
        this.vwr.script(script);
    }

    protected synchronized String runScriptNow(String script) {
        this.logInfo("!$ " + script, 5);
        return PT.trim("" + this.vwr.runScript(script.replace('\"', '\'')), "\n");
    }

    protected void loadModelFileQueued(File f, boolean saveOrientation) {
        this.iAmLoading = true;
        String s = "load \"" + f.getAbsolutePath().replace('\\', '/') + "\"" + JMOL_FONT_SCRIPT;
        if (saveOrientation) {
            s = "save orientation o1;" + s + ";restore orientation o1";
        }
        this.runScriptQueued(s);
    }

    protected void loadModelDataQueued(String s) {
        this.iAmLoading = true;
        this.runScriptQueued(s);
    }

    protected String loadModelFileNow(String s) {
        this.iAmLoading = true;
        return this.runScriptNow("load " + s.replace('\\', '/'));
    }

    private boolean connect() {
        if (!this.nboService.haveGenNBO()) {
            return false;
        }
        boolean isOK = this.checkEnabled();
        if (isOK) {
            this.icon.setText("Connected");
        }
        return isOK;
    }

    protected boolean checkEnabled() {
        return this.jmolOptionNONBO || this.nboService.isEnabled() && this.nboService.restartIfNecessary();
    }

    protected String evaluateJmolString(String expr) {
        return this.vwr.evaluateExpressionAsVariable(expr).asString();
    }

    protected String getJmolFilename() {
        return this.evaluateJmolString("getProperty('filename')");
    }

    protected void colorMeshes() {
    }

    protected void getNewInputFileHandler(int mode) {
        this.inputFileHandler = this.newNBOFileHandler(this.inputFileHandler == null ? "" : this.inputFileHandler.jobStem, "47", mode, "47");
    }

    protected SB postAddCmd(SB sb, String cmd) {
        return sb.append("CMD ").append(cmd).append(sep);
    }

    protected void postAddGlobal(SB sb, String key, String val) {
        sb.append("GLOBAL ").append(key).append(" ").append(val).append(sep);
    }

    protected void postAddGlobalT(SB sb, String key, JTextField t) {
        sb.append("GLOBAL ").append(key).append(" ").append(t.getText()).append(sep);
    }

    protected void postAddGlobalI(SB sb, String label, int offset, JComboBox<String> cb) {
        sb.append("GLOBAL I_").append(label).append(" ").appendI(cb == null ? offset : cb.getSelectedIndex() + offset).append(sep);
    }

    protected void postAddGlobalC(SB sb, String label, String val) {
        sb.append("GLOBAL C_").append(label).append(" ").append(val).append(sep);
    }

    protected void doSetStructure(String type) {
        this.doSearchSetResStruct(type, -1);
    }

    protected void doSearchSetResStruct(String type, int rsNum) {
        if (!this.showAtNum) {
            this.runScriptNow("measurements off;isosurface off;select visible;label off; select none;refresh");
            return;
        }
        if (type == null) {
            type = this.rsTypeLast;
        } else {
            this.rsTypeLast = type;
        }
        SB sb = new SB();
        sb.append("measurements off;isosurface off;select visible;label %a;");
        String color = this.nboView ? "black" : "gray";
        sb.append("select visible;color labels white;select visible & _H;color labels " + color + ";" + "set labeloffset 0 0 {visible}; select none;refresh;");
        String s = this.inputFileHandler.setStructure(sb, type, rsNum);
        if (s == null) {
            this.runScriptNow(sb.toString());
            return;
        }
        if (this.nboView) {
            sb.append("select add {*}.bonds;color bonds lightgrey;wireframe 0.1;");
        }
        sb.append(JMOL_FONT_SCRIPT);
        this.runScriptQueued(sb.toString());
    }

    protected boolean isOpenShell() {
        return this.inputFileHandler.isOpenShell;
    }

    static {
        statusFont = searchOpListFont = new Font("Arial", 1, 14);
        iconFont = searchTextAreaFont = new Font("Arial", 0, 16);
        nboFont = new Font("Arial", 1, 16);
        homeTextFont = new Font("Arial", 3, 16);
        titleFont = new Font("Arial", 3, 18);
        runButtonFont = new Font("Arial", 0, 20);
        topFont = new Font("Arial", 1, 20);
        homeButtonFont = new Font("Arial", 3, 22);
        nboProTitleFont = nboFontLarge = new Font("Arial", 1, 26);
        titleColor = Color.blue;
    }

    class StyledComboBoxUI
    extends MetalComboBoxUI {
        protected int height;
        protected int width;

        protected StyledComboBoxUI(int h, int w) {
            this.height = h;
            this.width = w;
        }

        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup popup = new BasicComboPopup(this.comboBox){

                @Override
                protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
                    return super.computePopupBounds(px, py, Math.max(StyledComboBoxUI.this.width, pw), StyledComboBoxUI.this.height);
                }
            };
            popup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return popup;
        }
    }

    class HelpBtn
    extends JButton {
        String page;

        protected HelpBtn(String page) {
            this("Help", page, null);
        }

        protected HelpBtn(String label, String page, String tooltip) {
            super(label);
            this.setBackground(Color.black);
            this.setForeground(Color.white);
            this.page = page;
            tooltip = "Help for " + (tooltip != null ? tooltip : (page == null || page.length() == 1 ? "this module" : page));
            this.setToolTipText(tooltip);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    HelpBtn.this.doHelp();
                }
            });
        }

        protected void doHelp() {
            NBODialogConfig.this.vwr.showUrl("http://nbo6.chem.wisc.edu/jmol_help/" + this.getHelpPage());
        }

        public String getHelpPage() {
            String u = this.page;
            if (u == null) {
                switch (NBODialogConfig.this.dialogMode) {
                    case 1: {
                        u = "model_help.htm";
                        break;
                    }
                    case 2: {
                        u = "run_help.htm";
                        break;
                    }
                    case 3: {
                        u = "view_help.htm";
                        break;
                    }
                    case 4: {
                        u = "search_help.htm";
                        break;
                    }
                    default: {
                        u = "Jmol_NBOPro6_help.htm";
                    }
                }
            }
            return u;
        }
    }

    class ColorRenderer
    extends JButton
    implements ListCellRenderer {
        boolean b = false;

        public ColorRenderer() {
            this.setOpaque(true);
        }

        @Override
        public void setBackground(Color bg) {
            if (!this.b) {
                return;
            }
            super.setBackground(bg);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.b = true;
            this.setText(" ");
            this.setBackground((Color)value);
            this.b = false;
            return this;
        }
    }
}

