/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import org.gennbo.NBODialogConfig;
import org.gennbo.NBODialogView;
import org.gennbo.NBOFileHandler;
import org.gennbo.NBORequest;

abstract class NBODialogSearch
extends NBODialogView {
    private static final int KEYWD_WEBHELP = 0;
    private static final int KEYWD_NPA = 1;
    private static final int KEYWD_NBO = 2;
    private static final int KEYWD_BEND = 3;
    private static final int KEYWD_E2PERT = 4;
    private static final int KEYWD_NLMO = 5;
    private static final int KEYWD_NRT = 6;
    private static final int KEYWD_STERIC = 7;
    private static final int KEYWD_CMO = 8;
    private static final int KEYWD_DIPOLE = 9;
    private static final int KEYWD_OPBAS = 10;
    private static final int KEYWD_BAS1BAS2 = 11;
    private static final String[] keywordNames = new String[]{"NPA", "NBO", "BEND", "E2", "NLMO", "NRT", "STERIC", "CMO", "DIPOLE", "OPBAS", "B1B2"};
    private static final int[] btnIndexToNBOKeyword = new int[]{1, 2, 3, 4, 5, 8, 6, 7, 9, 10, 11};
    protected static final String[] keyW = new String[]{"NPA    : Atomic and NAO properties", "NBO    : Natural Lewis Structure and\n NBO properties", "BEND   : NHO directionality and\n bond-bending", "E2PERT : 2nd-order energtics of NBO\n donor-acceptor interactions", "NLMO   : NLMO properties", "CMO    : NBO-based character of canonical\n molecular orbitals", "NRT    : Natural Resonance Theory\n weightings and bond orders", "STERIC : Total/pairwise contributions\n to steric exchange energy", "DIPOLE : L/NL contributions to electric\n dipole moment", "OPBAS  : Matrix elements of chosen operator   \n in chosen basis set", "B1B2   : Transformation matrix between\n chosen basis sets"};
    protected static final String[] npa = new String[]{"NPA Atomic Properties:", "  (1) NPA atomic charge", "  (2) NPA atomic spin density", "  (3) NEC atomic electron configuration", "NPA Molecular Unit Properties:", "  (4) NPA molecular unit charge", "  (5) NPA molecular unit spin density", "NAO Orbital Properties:", "  (6) NAO label", "  (7) NAO orbital population", "  (8) NAO orbital energy", "  (9) NAO orbital spin density", "  (10) NMB minimal basis %-accuracy", "Display Options:", "  (11) Display atomic charges"};
    protected static final String[] nbo = new String[]{"NBO Orbital Properties:", "  (1) NBO orbital label", "  (2) NBO orbital population", "  (3) NBO orbital energy", "  (4) NBO ionicity", "Natural Lewis Structure Properties:", "  (5) NLS rho(NL)", "  (6) NLS %-rho(L)"};
    protected static final String[] bend = new String[]{"NHO Orbital Prperties:", "  (1) NHO orbital label", "  (2) NHO orbital population", "  (3) NHO orbital energy", "  (4) NHO hybrid composition", "  (5) NHO direction angles", "  (6) NHO bending deviation from line of centers", "  (7) Strongest bending deviation for any NHO"};
    protected static final String[] e2 = new String[]{"E2 Values for Selected Donor-Acceptor NBOs:", "  (1) E(2) interaction for current d/a NBOs", "  (2) Strongest E(2) interaction for current d-NBO", "  (3) Strongest E(2) interaction for current a-NBO", "  (4) Strongest E(2) interaction for any d/a NBOs", "Intermolecular E2 Options:", "  (5) Strongest intermolecular E(2) for current unit", "  (6) Strongest intermolecular E(2) for any units"};
    protected static final String[] nlmo = new String[]{"NLMO Orbital Properties:", "  (1) NLMO orbital label", "  (2) NLMO population", "  (3) NLMO orbital energy", "  (4) NLMO %-NBO parentage", "NLMO Delocalization Tail Properties:", "  (5) NLMO delocalization tail population", "  (6) NLMO delocalization tail NBO components"};
    protected static final String[] nrt = new String[]{"Atom (A) Properties:", "  (1) atomic valency (total)", "  (2) atomic covalency", "  (3) atomic electrovalency", "Bond [A-A'] Properties:", "  (4) bond order (total)", "  (5) covalent bond order", "  (6) electrovalent bond order", "Resonance Structure Properties:", "  (7) RS weighting", "  (8) RS rho(NL) (reference structures only)", "Display Options:", "  (9) Display NRT atomic valencies", "  (10) Display NRT bond orders"};
    protected static final String[] steric = new String[]{"Total Steric Exchange Energy (SXE) Estimates:", "  (1) Total SXE", "  (2) Sum of pairwise (PW-SXE) contributions", "Selected PW-SXE contributions:", "  (3) PW-SXE for current d-d' NLMOs", "  (4) Strongest PW-SXE for current d NLMO", "Intra- and intermolecular options:", "  (5) Strongest PW-SXE within current unit", "  (6) Strongest PW-SXE within any unit", "  (7) Strongest PW-SXE between any units"};
    protected static final String[] mo = new String[]{"Character of current MO (c):", "  (1) Current MO energy and type", "  (2) Bonding character of current MO", "  (3) Nonbonding character of current MO", "  (4) Antibonding character of current MO", "NBO (n) %-contribution to selected MO (c):", "  (5) %-contribution of current NBO to current MO", "  (6) Largest %-contribution to current MO from any NBO", "  (7) Largest %-contribution of current NBO to any MO"};
    protected static final String[] dip = new String[]{"Total Dipole Properties:", "  (1) Total dipole moment", "  (2) Total L-type (Lewis) dipole", "  (3) Total NL-type (resonance) dipole", "Bond [NBO/NLMO] Dipole Properties:", "  (4) Dipole moment of current NLMO", "  (5) L-type (NBO bond dipole) contribution", "  (6) NL-type (resonance dipole) contribution", "Molecular Unit Dipole Properties:", "  (7) Dipole moment of current molecular unit", "  (8) L-type contribution to unit dipole", "  (9) NL-type contribution to unit dipole"};
    protected static final String[] op = new String[]{"<select an operation>", " S    : overlap (unit) operator", " F    : 1e Hamiltonian (Fock/Kohn-Sham) operator", " K    : kinetic energy operator", " V    : 1e potential (nuclear-electron attraction) operator", " DM   : 1e density matrix operator", " DIx  : dipole moment operator (x component)", " DIy  : dipole moment operator (y component)", " DIz  : dipole moment operator (z component)"};
    private Box optionBox;
    private JButton back;
    private JButton keyWdBtn;
    protected JLabel unitLabel;
    protected JPanel opList;
    protected JRadioButton[] rBtns = new JRadioButton[12];
    protected JRadioButton radioOrbMO;
    protected JRadioButton radioOrbNBO;
    protected JComboBox<String> comboSearchOrb1;
    protected JComboBox<String> comboSearchOrb2;
    protected JComboBox<String> comboUnit1;
    protected JComboBox<String> comboAtom1;
    protected JComboBox<String> comboAtom2;
    protected JComboBox<String> comboBasis2;
    protected JComboBox<String> comboBasisOperation;
    private int keywordID = 0;
    private int optionSelected;
    private int operator = 1;
    private boolean needRelabel;
    private boolean secondPick = true;

    private String getKeyword() {
        return this.getKeywordName(this.keywordID);
    }

    private String getKeywordButtonLabel(int ibtn) {
        return ibtn == 3 ? "E2PERT" : this.getKeywordName(btnIndexToNBOKeyword[ibtn]);
    }

    private String getKeywordName(int ikeywd) {
        return keywordNames[ikeywd - 1];
    }

    protected static final int getNboKeywordNumber(int index) {
        return btnIndexToNBOKeyword[index];
    }

    private void resetVariables_s() {
        this.optionSelected = -1;
        this.keywordID = 0;
        this.operator = 1;
    }

    protected NBODialogSearch(JFrame f) {
        super(f);
    }

    protected JPanel buildSearchPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.createViewSearchJobBox(4), "North");
        this.back = new JButton("<html>&#8592Back</html>");
        this.betaSpin = new JRadioButton("<html>&#x3B2</html>");
        this.alphaSpin = new JRadioButton("<html>&#x3B1</html>");
        ActionListener spinListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NBODialogSearch.this.doSetSpin();
            }
        };
        this.alphaSpin.addActionListener(spinListener);
        this.betaSpin.addActionListener(spinListener);
        this.alphaSpin.setSelected(true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.alphaSpin);
        bg.add(this.betaSpin);
        bg = new ButtonGroup();
        this.radioOrbMO = new JRadioButton("MO");
        this.radioOrbMO.setSelected(true);
        this.radioOrbMO.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NBODialogSearch.this.doSearchCMOSelectMO();
            }
        });
        this.radioOrbMO.setBackground(null);
        bg.add(this.radioOrbMO);
        this.radioOrbNBO = new JRadioButton("NBO");
        this.radioOrbNBO.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NBODialogSearch.this.doSearchCMOSelectNBO();
            }
        });
        this.radioOrbNBO.setBackground(null);
        bg.add(this.radioOrbNBO);
        Box optionBox2 = Box.createVerticalBox();
        this.opList = new JPanel();
        this.comboBasisOperation = new JComboBox<String>(op);
        this.comboBasisOperation.setUI(new NBODialogConfig.StyledComboBoxUI(150, 350));
        this.comboBasisOperation.setMaximumSize(new Dimension(350, 30));
        this.comboBasisOperation.setAlignmentX(0.0f);
        this.comboBasisOperation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogSearch.this.doComboBasisOperationAction();
            }
        });
        this.comboBasisOperation.setVisible(false);
        optionBox2.add(this.comboBasisOperation);
        optionBox2.add(this.opList);
        optionBox2.setBorder(BorderFactory.createLineBorder(Color.black));
        this.optionBox = Box.createVerticalBox();
        this.optionBox.setVisible(false);
        Box topBox = Box.createHorizontalBox();
        this.keyWdBtn = new JButton("<html></html>");
        this.keyWdBtn.setVisible(false);
        this.keyWdBtn.setRolloverEnabled(false);
        topBox.add(this.keyWdBtn);
        topBox.add(this.back);
        topBox.add(new NBODialogConfig.HelpBtn("a"){

            @Override
            public String getHelpPage() {
                return NBODialogSearch.this.getSearchHelpURL();
            }
        });
        Box box2 = NBODialogSearch.createTitleBox(" Select Keyword ", topBox);
        this.back.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NBODialogSearch.this.doSelectKeyword();
            }
        });
        this.back.setForeground(Color.blue);
        this.back.setEnabled(false);
        this.buildHome();
        box2.setAlignmentX(0.0f);
        this.optionBox.add(box2);
        optionBox2.setAlignmentX(0.0f);
        this.optionBox.add(optionBox2);
        panel.add(this.optionBox);
        this.comboBasis1 = new JComboBox<String>(NBODialogView.basSet);
        this.comboBasis1.setUI(new NBODialogConfig.StyledComboBoxUI(180, -1));
        this.inputFileHandler.setBrowseEnabled(true);
        this.viewSettingsBox.removeAll();
        String file = this.vwr.getProperty("String", "filename", null).toString();
        String ext = NBOFileHandler.getExt((File)new File(file));
        if (PT.isOneOf(ext, "31;32;33;34;35;36;37;38;39;40;41;42;46;nbo")) {
            this.notifyLoad_s();
        }
        return panel;
    }

    protected void doSearchCMOSelectNBO() {
        this.showOrbJmol("PNBO", this.comboSearchOrb1.getSelectedIndex(), "cmo");
    }

    protected void doSearchCMOSelectMO() {
        this.showOrbJmol("MO", this.comboSearchOrb2.getSelectedIndex(), "cmo");
    }

    protected void doComboBasisOperationAction() {
        this.operator = this.comboBasisOperation.getSelectedIndex();
        if (this.operator > 0) {
            this.changeKey(NBODialogSearch.getBasisOperations(this.comboBasisOperation.getSelectedItem().toString().trim().split(" ")[0]));
        }
    }

    protected void buildHome() {
        this.resetVariables_s();
        this.resetCurrentOrbitalClicked();
        this.opList.removeAll();
        this.comboBasisOperation.setVisible(false);
        this.keyWdBtn.setVisible(false);
        this.opList.setLayout(new GridBagLayout());
        this.opList.setBackground(Color.white);
        this.keywordID = 0;
        this.viewSettingsBox.setVisible(false);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        for (int i = 0; i < keywordNames.length * 2; i += 2) {
            c.gridy = i;
            c.gridx = 0;
            c.gridwidth = 1;
            final int index = i / 2;
            JButton btn = new JButton(this.getKeywordButtonLabel(index));
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    NBODialogSearch.this.doSearchKeywordClicked(index);
                }
            });
            this.opList.add((Component)btn, c);
            c.gridx = 1;
            String st = keyW[index].substring(keyW[index].indexOf(":") + 1);
            JTextArea jt = new JTextArea(st);
            jt.setBackground(null);
            jt.setFont(searchTextAreaFont);
            jt.setEditable(false);
            this.opList.add((Component)jt, c);
            c.gridy = i + 1;
            c.gridx = 0;
            c.gridwidth = 2;
            JSeparator sp = new JSeparator(0);
            sp.setForeground(Color.BLACK);
            sp.setSize(350, 10);
            this.opList.add((Component)sp, c);
        }
        this.opList.repaint();
        this.opList.revalidate();
        this.back.setEnabled(false);
    }

    protected void doSearchKeywordClicked(int index) {
        if (this.nboService.isWorking()) {
            this.vwr.alert("Please wait for NBOServe to finish working");
            return;
        }
        this.keywordClicked(NBODialogSearch.getNboKeywordNumber(index));
    }

    protected String getSearchHelpURL() {
        return this.keywordID == 0 ? "search_help.htm" : (this.getKeyword().equals("E2") ? "search_e2pert_help.htm" : "search_" + this.getKeyword() + "_help.htm");
    }

    protected void doSetSpin() {
        this.doSetStructure(this.alphaSpin.isSelected() ? "alpha" : "beta");
        switch (this.keywordID) {
            case 2: 
            case 3: 
            case 9: {
                this.postListRequest("o", this.comboSearchOrb1);
                break;
            }
            case 4: {
                this.postListRequest("d nbo", this.comboSearchOrb1);
                this.postListRequest("a nbo", this.comboSearchOrb2);
                break;
            }
            case 5: {
                this.postListRequest("o", this.comboSearchOrb2);
                break;
            }
            case 7: {
                this.postListRequest("d", this.comboSearchOrb1);
                this.postListRequest("d'", this.comboSearchOrb2);
                break;
            }
            case 8: {
                this.postListRequest("n", this.comboSearchOrb1);
                if (!this.radioOrbMO.isSelected()) break;
                this.radioOrbMO.doClick();
                break;
            }
            case 10: 
            case 11: {
                this.doSetBasis();
            }
        }
    }

    protected void doSelectKeyword() {
        if (this.keywordID == 6 && this.comboUnit1.getModel().getSize() > 0) {
            this.comboUnit1.setSelectedIndex(0);
        }
        SB script = new SB();
        if (this.needRelabel) {
            this.doSetStructure(this.alphaSpin.isSelected() ? "alpha" : "beta");
            script.append("measurements off;select add {*}.bonds; color bonds lightgrey; select none;");
        }
        script.append("isosurface delete; select off;refresh");
        this.runScriptNow(script.toString());
        this.buildHome();
    }

    private void changeKey(String[] s) {
        this.secondPick = true;
        this.back.setEnabled(true);
        this.viewSettingsBox.setVisible(!this.jmolOptionNONBO);
        this.keyWdBtn.setText("<html><font color=black>" + this.getKeyword() + "</font></html>");
        this.keyWdBtn.setVisible(true);
        this.runScriptNow("isosurface delete;refresh");
        this.opList.removeAll();
        ButtonGroup btnGroup = new ButtonGroup();
        this.opList.setLayout(new BoxLayout(this.opList, 1));
        if (this.keywordID == 10) {
            this.comboBasisOperation.setVisible(true);
            this.opList.add(this.comboBasisOperation);
        }
        for (int i = 0; i < s.length; ++i) {
            if (!s[i].trim().startsWith("(")) {
                JLabel lab = new JLabel(s[i]);
                lab.setFont(searchOpListFont);
                lab.setForeground(Color.blue);
                this.opList.add(lab);
            } else {
                final int num = Integer.parseInt(s[i].substring(s[i].indexOf("(") + 1, s[i].indexOf(")"))) - 1;
                this.rBtns[num] = new JRadioButton(s[i].substring(s[i].indexOf(41) + 1));
                this.rBtns[num].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        NBODialogSearch.this.doGetSearchValue(num + 1);
                    }
                });
                this.rBtns[num].setBackground(null);
                this.opList.add(this.rBtns[num]);
                btnGroup.add(this.rBtns[num]);
            }
            this.opList.add(new JSeparator());
        }
        this.opList.add(Box.createRigidArea(new Dimension(0, (16 - s.length) * 20)));
        this.opList.repaint();
        this.opList.revalidate();
    }

    protected void showMessage() {
        JOptionPane.showMessageDialog(this, "Error getting lists, an error may have occured during run");
    }

    protected void getBasisOperations2(boolean andUpdateList2) {
        String b1 = this.comboBasis1.getSelectedItem().toString();
        String b2 = this.comboBasis2.getSelectedItem().toString();
        this.changeKey(new String[]{"Current r(ow),c(olumn) matrix element:", "  (1) current <" + b1 + "(r)|" + b2 + "(c)> value", "Extremal off-diagonal values for current r orbital:", "  (2) max <" + b1 + "(r)|" + b2 + "(*c)> value for current r", "  (3) min <" + b1 + "(r)|" + b2 + "(*c)> value for current r", "Extremal off-diagonal values for current c orbital:", "  (4) max <" + b1 + "(*r)|" + b2 + "(c)> value for current c", "  (5) min <" + b1 + "(*r)|" + b2 + "(c)> value for current c", "Extremal off-diagonal values for any (*r,*c) orbitals:", "  (6) max <" + b1 + "(*r)|" + b2 + "(*c)> value for any *r,*c", "  (7) min <" + b1 + "(*r)|" + b2 + "(*c)> value for any *r,*c"});
        if (andUpdateList2) {
            this.postListRequest("c", this.comboSearchOrb2);
        }
    }

    private static String[] getBasisOperations(String operator) {
        return new String[]{"Current [r(ow),c(ol)] matrix element", "  (1) current <r|" + operator + "|c> value", "Extremal off-diagonal values for current r orbital:", "  (2) max <r|" + operator + "|*c> value for current r", "  (3) min <r|" + operator + "|*c> value for current r", "Extremal off-diagonal values for current c orbital:", "  (4) max <*r|" + operator + "|c> value for current c", "  (5) min <*r|" + operator + "|c> value for current c", "Extremal off-diagonal values for any [*r,*c] orbitals:", "  (6) max <*r|" + operator + "|*c> value for any *r,*c", "  (7) min <*r|" + operator + "|*c> value for any *r,*c"};
    }

    protected void keywordClicked(int index) throws IllegalArgumentException {
        this.isNewModel = false;
        this.keywordID = index;
        this.resetCurrentOrbitalClicked();
        switch (index) {
            case 1: {
                this.load(31, false);
                this.comboAtom2 = null;
                this.comboBasis1.setSelectedIndex(1);
                this.setKeyword(new String[]{"b", "a", "o PNAO", "u"}, new String[]{"Basis: ", "Atom: ", "Orbital: ", "Unit: "});
                this.changeKey(npa);
                break;
            }
            case 2: {
                this.load(36, true);
                this.comboBasis1.setSelectedIndex(5);
                this.setKeyword(new String[]{"b", "o PNBO"}, new String[]{"Basis: ", "Orbital: "});
                this.changeKey(nbo);
                break;
            }
            case 5: {
                this.load(38, true);
                this.comboBasis1.setSelectedIndex(7);
                this.setKeyword(new String[]{"b", "o PNLMO"}, new String[]{"Basis: ", "Orbital: "});
                this.changeKey(nlmo);
                break;
            }
            case 3: {
                this.load(34, true);
                this.comboBasis1.setSelectedIndex(3);
                this.setKeyword(new String[]{"b", "o PNHO"}, new String[]{"Basis: ", "Orbital: "});
                this.changeKey(bend);
                break;
            }
            case 6: {
                this.runScriptNow("set bondpicking true");
                if (this.isOpenShell()) {
                    this.setKeyword("s a a' rs".split(" "), new String[]{"Spin: ", "Atom A: ", "Atom A': ", "Res Struct: "});
                } else {
                    this.setKeyword("a a' rs".split(" "), new String[]{"Atom A: ", "Atom A': ", "Res Struct: "});
                }
                this.changeKey(nrt);
                break;
            }
            case 4: {
                this.load(36, true);
                this.comboBasis1.setSelectedIndex(5);
                this.setKeyword(new String[]{"b", "d nbo", "a nbo", "u"}, new String[]{"Basis: ", "d-NBO: ", "a-NBO:", "Unit: "});
                this.changeKey(e2);
                break;
            }
            case 7: {
                this.load(38, true);
                this.comboBasis1.setSelectedIndex(7);
                this.setKeyword(new String[]{"b", "d nlmo", "d' nlmo", "u"}, new String[]{"Basis: ", "d-NLMO: ", "d'-NLMO:", "Unit: "});
                this.changeKey(steric);
                break;
            }
            case 8: {
                this.load(40, true);
                this.comboBasis1.setSelectedIndex(9);
                if (!this.cleanNBOKeylist(this.inputFileHandler.read47File(false)[1], true).contains("CMO")) {
                    this.doRunGenNBOJob("CMO");
                    return;
                }
                this.setKeyword(new String[]{"b", "c cmo", "n"}, new String[]{"Basis: ", "MO: ", "NBO:"});
                this.changeKey(mo);
                break;
            }
            case 9: {
                this.load(38, true);
                this.comboBasis1.setSelectedIndex(7);
                this.setKeyword(new String[]{"b", "o", "u"}, new String[]{"Basis: ", "Orbital: ", "Unit:"});
                this.changeKey(dip);
                break;
            }
            case 10: {
                this.load(31, true);
                this.viewSettingsBox.removeAll();
                this.comboBasis1 = new JComboBox<String>(NBODialogView.basSet);
                this.comboBasis1.setUI(new NBODialogConfig.StyledComboBoxUI(180, -1));
                this.comboBasis1.setEditable(false);
                this.comboBasisOperation.requestFocus();
                this.setKeyword("b1 r c".split(" "), new String[]{"Basis:", "Row:", "Column:"});
                this.changeKey(new String[0]);
                break;
            }
            case 11: {
                this.runScriptNow("set bondpicking true");
                this.setKeyword("b1 b2 r c".split(" "), new String[]{"Basis 1:", "Basis 2:", "Row:", "Column:"});
                this.getBasisOperations2(false);
            }
        }
        this.repaint();
        this.revalidate();
        if (index == 10) {
            this.comboBasisOperation.showPopup();
        }
    }

    private void load(int nn, boolean withBondPicking) {
        this.loadModelFileNow(this.inputFileHandler.newNBOFileForExt("" + nn) + (withBondPicking ? ";set bondpicking true" : ""));
    }

    protected void setKeyword(String[] items, String[] labels) {
        this.resetCurrentOrbitalClicked();
        this.viewSettingsBox.removeAll();
        this.viewSettingsBox.setLayout(new BorderLayout());
        JPanel outerListPanel = new JPanel(new GridLayout(labels.length, 1));
        JPanel innerListPanel = new JPanel(new GridLayout(labels.length, 1));
        for (int i = 0; i < labels.length; ++i) {
            Box b;
            String key = items[i].split(" ")[0];
            outerListPanel.add(new JLabel(labels[i]));
            if (key.equals("b") || key.equals("s")) {
                b = Box.createHorizontalBox();
                if (this.keywordID == 8) {
                    b.add(this.radioOrbMO);
                    b.add(this.radioOrbNBO);
                } else if (key.equals("b")) {
                    String str = this.peeify(this.comboBasis1.getSelectedItem().toString());
                    b.add(new JLabel(str));
                    b.add(Box.createRigidArea(new Dimension(20, 0)));
                }
                b.add(this.alphaSpin);
                b.add(this.betaSpin);
                innerListPanel.add(b);
                continue;
            }
            if (PT.isOneOf(items[i], "o PNBO;o PNLMO;r;d nlmo;n;d nbo;o PNHO;o")) {
                this.comboSearchOrb1 = new JComboBox(new DefaultComboBoxModel());
                this.setComboSearchOrbDefaultAction(key);
                innerListPanel.add(this.comboSearchOrb1);
                this.postListRequest(key, this.comboSearchOrb1);
                continue;
            }
            if (PT.isOneOf(items[i], "c;d' nlmo;a nbo;c cmo;o PNAO")) {
                this.comboSearchOrb2 = new JComboBox(new DefaultComboBoxModel());
                this.postListRequest(key, this.comboSearchOrb2);
                this.setComboSearchOrb2DefaultAction(key, items[i]);
                innerListPanel.add(this.comboSearchOrb2);
                continue;
            }
            if (key.equals("u")) {
                this.comboUnit1 = new JComboBox(new DefaultComboBoxModel());
                this.postListRequest(key, this.comboUnit1);
                this.unitLabel = new JLabel();
                Box box = Box.createHorizontalBox();
                box.add(this.comboUnit1);
                box.add(this.unitLabel);
                innerListPanel.add(box);
                this.unitLabel.setVisible(false);
                continue;
            }
            if (key.equals("rs")) {
                this.comboUnit1 = new JComboBox(new DefaultComboBoxModel());
                this.postListRequest("r", this.comboUnit1);
                innerListPanel.add(this.comboUnit1);
                continue;
            }
            if (key.equals("a")) {
                this.comboAtom1 = new JComboBox(new DefaultComboBoxModel());
                this.postListRequest("a", this.comboAtom1);
                this.comboAtom1.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NBODialogSearch.this.doSearchAtom1Action(NBODialogSearch.this.comboAtom1.getSelectedIndex(), NBODialogSearch.this.comboAtom2 == null ? -1 : NBODialogSearch.this.comboAtom2.getSelectedIndex());
                    }
                });
                innerListPanel.add(this.comboAtom1);
                continue;
            }
            if (key.equals("a'")) {
                this.comboAtom2 = new JComboBox(new DefaultComboBoxModel());
                this.postListRequest("a", this.comboAtom2);
                this.comboAtom2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (NBODialogSearch.this.comboAtom1.getSelectedIndex() > 0 && NBODialogSearch.this.comboAtom2.getSelectedIndex() > 0) {
                            NBODialogSearch.this.runScriptQueued("select on @" + NBODialogSearch.this.comboAtom1.getSelectedIndex() + ",@" + NBODialogSearch.this.comboAtom2.getSelectedIndex());
                        }
                    }
                });
                innerListPanel.add(this.comboAtom2);
                continue;
            }
            if (key.equals("b1")) {
                b = Box.createHorizontalBox();
                b.add(this.comboBasis1);
                this.comboBasis1.setSelectedIndex(0);
                this.comboBasis1.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NBODialogSearch.this.doSetBasis();
                    }
                });
                if (this.isOpenShell()) {
                    b.add(this.alphaSpin);
                    b.add(this.betaSpin);
                }
                innerListPanel.add(b);
                continue;
            }
            if (key.equals("b2")) {
                this.comboBasis2 = new JComboBox<String>(NBODialogView.basSet);
                this.comboBasis2.setUI(new NBODialogConfig.StyledComboBoxUI(180, -1));
                this.comboBasis2.setSelectedIndex(1);
                this.comboBasis2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NBODialogSearch.this.getBasisOperations2(true);
                    }
                });
                innerListPanel.add(this.comboBasis2);
                continue;
            }
            if (!key.equals("b12")) continue;
            this.comboBasis1 = new JComboBox<String>(NBODialogView.basSet);
            this.comboBasis1.setUI(new NBODialogConfig.StyledComboBoxUI(180, -1));
            innerListPanel.add(this.comboBasis1);
        }
        this.logCmd(this.getKeyword() + " Search Results:");
        JLabel lab = new JLabel("Settings");
        lab.setFont(nboFont);
        lab.setOpaque(true);
        lab.setBackground(Color.black);
        lab.setForeground(Color.white);
        this.viewSettingsBox.add((Component)lab, "North");
        this.viewSettingsBox.add((Component)outerListPanel, "West");
        this.viewSettingsBox.add((Component)innerListPanel, "Center");
    }

    protected void doSearchAtom1Action(int atomno1, int atomno2) {
        if (atomno1 <= 0 || atomno2 <= 0) {
            return;
        }
        if (this.comboAtom2 == null) {
            this.runScriptQueued("select on @" + atomno1);
        } else {
            this.runScriptQueued("select on @" + atomno1 + ", @" + atomno2);
        }
    }

    private void setComboSearchOrbDefaultAction(final String key) {
        this.comboSearchOrb1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NBODialogSearch.this.comboSearchOrb1.getSelectedIndex() > 0) {
                    NBODialogSearch.this.doSearchOrb1Action(key);
                }
            }
        });
    }

    protected void doSearchOrb1Action(String key) {
        this.checkOptionClickForOrbitalSelection();
        if (key.equals("n")) {
            this.showOrbJmol("NBO", this.comboSearchOrb1.getSelectedIndex(), key);
            this.radioOrbNBO.doClick();
        } else {
            this.showOrbJmol(this.comboBasis1.getSelectedItem().toString(), this.comboSearchOrb1.getSelectedIndex(), key);
        }
    }

    private void setComboSearchOrb2DefaultAction(final String key, final String item) {
        this.comboSearchOrb2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogSearch.this.doComboSearchOrb2Click(key, item);
            }
        });
    }

    protected void doComboSearchOrb2Click(String key, String item) {
        int index2;
        int n = index2 = this.comboSearchOrb2.isEnabled() ? this.comboSearchOrb2.getSelectedIndex() : 0;
        if (index2 <= 0) {
            return;
        }
        this.checkOptionClickForOrbitalSelection();
        if (this.keywordID == 11) {
            this.showOrbJmol(this.comboBasis2.getSelectedItem().toString(), index2, "b2");
        } else if (key.equals("a")) {
            this.showOrbJmol("NBO", this.comboSearchOrb1.getModel().getSize() + (index2 - 1), key);
        } else {
            this.showOrbJmol(this.comboBasis1.getSelectedItem().toString(), index2, key);
        }
        if (item.equals("c cmo")) {
            this.radioOrbMO.doClick();
        }
    }

    protected void doSetBasis() {
        this.resetCurrentOrbitalClicked();
        switch (this.keywordID) {
            case 11: {
                if (this.comboBasis2 == null) {
                    return;
                }
                this.getBasisOperations2(false);
                this.postListRequest("r", this.comboSearchOrb1);
                break;
            }
            case 10: {
                this.loadModelFileNow("" + this.inputFileHandler.newNBOFileForExt("" + (31 + this.comboBasis1.getSelectedIndex())));
                this.postListRequest("r", this.comboSearchOrb1);
                this.postListRequest("c", this.comboSearchOrb2);
                break;
            }
            default: {
                NBODialogSearch.getBasisOperations(this.comboBasisOperation.getSelectedItem().toString().trim().split(" ")[0]);
            }
        }
    }

    private String peeify(String str) {
        return !(str = str.trim()).equals("MO") && !str.equals("AO") && str.charAt(0) != 'P' ? "P" + str : str;
    }

    protected void doGetSearchValue(int op) {
        boolean isOK;
        this.optionSelected = op - 1;
        JComboBox<String> orb1 = this.comboSearchOrb1;
        JComboBox<String> orb2 = null;
        JComboBox<String> atom1 = null;
        JComboBox atom2 = null;
        JComboBox<String> unit1 = null;
        String labelOrb1 = "ORB_1";
        String labelOrb2 = "ORB_2";
        String labelAtom1 = "ATOM_1";
        String labelAtom2 = "ATOM_2";
        String labelUnit1 = "UNIT_1";
        int offset1 = 0;
        int offset2 = 0;
        SB sb = this.getMetaHeader(false);
        this.postAddGlobalI(sb, "KEYWORD", this.keywordID, null);
        boolean isLabel = false;
        boolean isLabelBonds = false;
        switch (this.keywordID) {
            case 1: {
                orb1 = this.comboSearchOrb2;
                unit1 = this.comboUnit1;
                if (op >= 6 && op <= 10) break;
                orb1 = null;
                if (op > 10) {
                    isLabel = true;
                    op = 12;
                    break;
                }
                if (op > 3) break;
                atom1 = this.comboAtom1;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                labelOrb1 = "d_NBO_1";
                labelOrb2 = "a_NBO";
                orb2 = this.comboSearchOrb2;
                offset2 = orb1.getModel().getSize() + 1;
                break;
            }
            case 6: {
                orb1 = null;
                atom1 = op <= 6 ? this.comboAtom1 : null;
                atom2 = op >= 4 && op <= 6 ? this.comboAtom2 : null;
                unit1 = this.comboUnit1;
                labelUnit1 = "RES_STR";
                isLabel = op == 9;
                isLabelBonds = op == 10;
                break;
            }
            case 7: {
                labelOrb1 = "d_NBO_1";
                orb2 = this.comboSearchOrb2;
                labelOrb2 = "d_NBO_2";
                unit1 = this.comboUnit1;
                break;
            }
            case 8: {
                labelOrb1 = "NBO";
                orb2 = this.comboSearchOrb2;
                labelOrb2 = "CMO";
                break;
            }
            case 9: {
                unit1 = this.comboUnit1;
                break;
            }
            case 10: {
                labelOrb1 = "ROW";
                orb2 = this.comboSearchOrb2;
                labelOrb2 = "COLUMN";
                this.postAddGlobalI(sb, "OPERATOR", this.operator, null);
                this.postAddGlobalI(sb, "BAS_1", 1, this.comboBasis1);
                break;
            }
            case 11: {
                labelOrb1 = "ROW";
                orb2 = this.comboSearchOrb2;
                labelOrb2 = "COLUMN";
                this.postAddGlobalI(sb, "BAS_1", 1, this.comboBasis1);
                this.postAddGlobalI(sb, "BAS_2", 1, this.comboBasis2);
            }
        }
        boolean bl = isOK = !(orb1 != null && orb1.getSelectedIndex() <= 0 || orb2 != null && orb2.getSelectedIndex() <= 0 || atom1 != null && atom1.getSelectedIndex() <= 0 || atom2 != null && atom2.getSelectedIndex() <= 0);
        if (!isOK) {
            return;
        }
        if (orb1 != null) {
            this.postAddGlobalI(sb, labelOrb1, offset1, orb1);
        }
        if (orb2 != null) {
            this.postAddGlobalI(sb, labelOrb2, offset2, orb1);
        }
        if (atom1 != null) {
            this.postAddGlobalI(sb, labelAtom1, 0, atom1);
        }
        if (atom2 != null) {
            this.postAddGlobalI(sb, labelAtom2, 0, atom2);
        }
        if (unit1 != null) {
            this.postAddGlobalI(sb, labelUnit1, 1, unit1);
        }
        this.postAddGlobalI(sb, "OPT_" + this.getKeyword(), op, null);
        if (this.needRelabel) {
            this.runScriptQueued("select add {*}.bonds; color bonds lightgrey; select none; measurements off");
            this.doSetStructure(this.alphaSpin.isSelected() ? "alpha" : "beta");
            this.needRelabel = false;
        }
        if (isLabel) {
            this.needRelabel = true;
            this.postNBO_s(sb, 44, null, "Getting labels");
        } else if (isLabelBonds) {
            this.needRelabel = true;
            this.runScriptQueued("select add {*}.bonds; color bonds [170,170,170]; select none");
            this.postNBO_s(sb, 54, null, "Getting bonds list");
        } else {
            this.postNBO_s(sb, 14, null, "Getting value...");
        }
    }

    protected void processReturnedSearchList(JComboBox<String> cb) {
        DefaultComboBoxModel list = (DefaultComboBoxModel)cb.getModel();
        switch (this.keywordID) {
            case 4: {
                if (cb != this.comboSearchOrb2) break;
                int offset = this.comboSearchOrb1.getModel().getSize() - 1;
                int sz = cb.getModel().getSize();
                this.comboSearchOrb2.setEnabled(false);
                for (int i = 1; i < sz; ++i) {
                    String s = (String)list.getElementAt(i);
                    list.removeElementAt(i);
                    s = "   " + (offset + i) + s.substring(s.indexOf("."));
                    list.insertElementAt(s, i);
                }
                this.comboSearchOrb2.setEnabled(true);
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                if (cb != this.comboUnit1) break;
                if (list.getSize() == 1) {
                    this.comboUnit1.setVisible(false);
                    this.unitLabel.setVisible(true);
                    this.unitLabel.setText(((String)list.getElementAt(0)).substring(6));
                    break;
                }
                this.unitLabel.setVisible(false);
                this.comboUnit1.setVisible(true);
                break;
            }
            case 6: {
                if (cb != this.comboUnit1) break;
                this.changeKey(nrt);
                this.comboUnit1.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NBODialogSearch.this.doSearchSetResStruct(NBODialogSearch.this.alphaSpin.isSelected() ? "nrtstra" : "nrtstrb", NBODialogSearch.this.comboUnit1.getSelectedIndex());
                    }
                });
                this.doSearchSetResStruct(this.alphaSpin.isSelected() ? "nrtstra" : "nrtstrb", 0);
                break;
            }
            case 10: 
            case 11: {
                if (cb != this.comboBasis2) break;
                this.comboSearchOrb1.setSelectedIndex(0);
                this.comboSearchOrb2.setSelectedIndex(0);
            }
        }
    }

    protected void showOrbJmol(String type, int i, String id) {
        if (i <= 0) {
            this.runScriptQueued("select visible;isosurface delete");
            this.logError("Select an orbital.");
            return;
        }
        id = this.fixID(id);
        this.runScriptQueued("select visible;isosurface delete;" + this.getJmolIsosurfaceScript(id, this.peeify(type), i, this.betaSpin.isSelected(), false));
    }

    private String fixID(String id) {
        return PT.replaceAllCharacters(id, "'\"", "_");
    }

    protected void checkOptionClickForOrbitalSelection() {
        if (this.optionSelected < 0) {
            return;
        }
        boolean doClick = false;
        switch (this.keywordID) {
            default: {
                break;
            }
            case 1: {
                doClick = this.optionSelected > 4 && this.optionSelected < 10;
                break;
            }
            case 2: {
                doClick = this.optionSelected < 4;
                break;
            }
            case 3: {
                doClick = this.optionSelected < 6;
                break;
            }
            case 4: {
                doClick = this.optionSelected < 3;
                break;
            }
            case 5: {
                doClick = true;
                break;
            }
            case 7: {
                doClick = this.optionSelected > 1 && this.optionSelected < 4;
                break;
            }
            case 8: {
                doClick = true;
                break;
            }
            case 9: {
                boolean bl = doClick = this.optionSelected > 2 && this.optionSelected < 6;
            }
        }
        if (doClick) {
            this.rBtns[this.optionSelected].doClick();
        }
    }

    protected void notifyPick_s(String atomnoOrBondInfo) {
        this.runScriptNow("isosurface delete");
        String[] tok = atomnoOrBondInfo.split(",");
        if (tok.length < 2) {
            int n = PT.parseInt(atomnoOrBondInfo);
            switch (n == Integer.MIN_VALUE ? 2 : this.keywordID) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.showOrbital(this.nextOrbitalForAtomPick(atomnoOrBondInfo, (DefaultComboBoxModel)this.comboSearchOrb1.getModel()));
                    return;
                }
                case 8: {
                    this.showOrbital(this.nextOrbitalForAtomPick(atomnoOrBondInfo, (DefaultComboBoxModel)this.comboSearchOrb2.getModel()));
                    return;
                }
            }
            if (this.comboAtom1 != null && this.comboAtom2 == null) {
                this.comboAtom1.setSelectedIndex(n);
                if (this.optionSelected >= 0 && this.optionSelected < 3) {
                    this.rBtns[this.optionSelected].doClick();
                }
            } else if (this.comboAtom1 != null && this.comboAtom2 != null) {
                boolean bl = this.secondPick = !this.secondPick;
                if (this.secondPick) {
                    this.comboAtom2.setSelectedIndex(n);
                } else {
                    this.comboAtom1.setSelectedIndex(n);
                }
            }
            return;
        }
        String[] tok2 = tok[1].split(" ");
        String at1 = tok2[2];
        String at2 = tok2[5];
        block4 : switch (this.keywordID) {
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                this.comboSearchOrb1.setSelectedIndex(this.pickNBO_s(at1, at2, this.comboSearchOrb1));
                break;
            }
            case 3: {
                this.comboSearchOrb1.setSelectedIndex(this.pickNHO_s(at1, at2, this.comboSearchOrb1));
                break;
            }
            case 6: {
                tok = atomnoOrBondInfo.split(",");
                int a1 = Integer.parseInt(at1.replaceAll("[\\D]", ""));
                int a2 = Integer.parseInt(at2.replaceAll("[\\D]", ""));
                this.comboAtom1.setSelectedIndex(a1);
                this.comboAtom2.setSelectedIndex(a2);
                if (this.optionSelected > 2 && this.optionSelected < 6) {
                    this.rBtns[this.optionSelected].doClick();
                }
                return;
            }
            case 4: 
            case 7: {
                tok = atomnoOrBondInfo.split(",");
                tok2 = tok[1].split(" ");
                String bond = tok2[2] + "-" + tok2[5];
                String str = this.comboSearchOrb1.getSelectedItem().toString().replace(" ", "");
                if (str.contains(bond)) {
                    this.comboSearchOrb1.setSelectedIndex(this.pickNBO_s(at1, at2, this.comboSearchOrb1));
                    return;
                }
                str = this.comboSearchOrb2.getSelectedItem().toString().replace(" ", "");
                if (str.contains(bond)) {
                    this.comboSearchOrb2.setSelectedIndex(this.pickNBO_s(at1, at2, this.comboSearchOrb2));
                    return;
                }
                boolean bl = this.secondPick = !this.secondPick;
                if (this.secondPick) {
                    this.comboSearchOrb2.setSelectedIndex(this.pickNBO_s(at1, at2, this.comboSearchOrb2));
                    break;
                }
                this.comboSearchOrb1.setSelectedIndex(this.pickNBO_s(at1, at2, this.comboSearchOrb1));
                break;
            }
            case 10: 
            case 11: {
                JComboBox<String> tmpBas = this.comboBasis1;
                if (this.keywordID == 11 && !this.secondPick) {
                    tmpBas = this.comboBasis2;
                }
                switch (tmpBas.getSelectedIndex()) {
                    default: {
                        this.secondPick = !this.secondPick;
                        break block4;
                    }
                    case 3: 
                    case 4: {
                        boolean bl = this.secondPick = !this.secondPick;
                        if (this.secondPick) {
                            this.comboSearchOrb2.setSelectedIndex(this.pickNHO_s(at1, at2, this.comboSearchOrb2));
                            break block4;
                        }
                        this.comboSearchOrb1.setSelectedIndex(this.pickNHO_s(at1, at2, this.comboSearchOrb1));
                        break block4;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                }
                String bond = at1 + "-" + at2;
                String str = this.comboSearchOrb1.getSelectedItem().toString().replace(" ", "");
                if (str.contains(bond)) {
                    this.comboSearchOrb1.setSelectedIndex(this.pickNBO_s(at1, at2, this.comboSearchOrb1));
                    return;
                }
                str = this.comboSearchOrb2.getSelectedItem().toString().replace(" ", "");
                if (str.contains(bond)) {
                    this.comboSearchOrb2.setSelectedIndex(this.pickNBO_s(at1, at2, this.comboSearchOrb2));
                    return;
                }
                boolean bl = this.secondPick = !this.secondPick;
                if (this.secondPick) {
                    this.comboSearchOrb2.setSelectedIndex(this.pickNBO_s(at1, at2, this.comboSearchOrb2));
                    break;
                }
                this.comboSearchOrb1.setSelectedIndex(this.pickNBO_s(at1, at2, this.comboSearchOrb1));
            }
        }
    }

    private int pickNBO_s(String at1, String at2, JComboBox<String> cb) {
        return this.selectOnOrb_s(at1 + "-" + at2, null, cb);
    }

    private int pickNHO_s(String at1, String at2, JComboBox<String> cb) {
        return this.selectOnOrb_s(at1 + "(" + at2 + ")", at2 + "(" + at1 + ")", cb);
    }

    protected int selectOnOrb_s(String b1, String b2, JComboBox<String> cb) {
        DefaultComboBoxModel list = (DefaultComboBoxModel)cb.getModel();
        int size = list.getSize();
        int curr = this.currOrb.contains(b1) ? this.currOrbIndex : 0;
        for (int i = curr + 1; i < size + curr; ++i) {
            int ipt = i % size;
            String str = ((String)list.getElementAt(ipt)).replace(" ", "");
            if (!str.contains(b1) && (b2 == null || !str.contains(b2))) continue;
            list.setSelectedItem(list.getElementAt(ipt));
            this.currOrb = str;
            this.currOrbIndex = ipt;
            return ipt;
        }
        return curr;
    }

    protected void notifyLoad_s() {
        if (this.vwr.ms.ac == 0) {
            return;
        }
        this.runScriptNow("isosurface delete");
        this.optionSelected = -1;
        this.doSetStructure("alpha");
        if (this.isOpenShell()) {
            this.alphaSpin.setVisible(true);
            this.betaSpin.setVisible(true);
        } else {
            this.alphaSpin.setVisible(false);
            this.betaSpin.setVisible(false);
        }
        this.optionBox.setVisible(true);
        if (this.keywordID > 0 && this.isNewModel) {
            this.keywordClicked(this.keywordID);
        }
    }

    @Override
    protected void showConfirmationDialog(String st, File newFile, String ext) {
        int i = JOptionPane.showConfirmDialog(this, st, "Message", 0);
        if (i == 0) {
            JDialog d = new JDialog(this);
            d.setLayout(new BorderLayout());
            JTextPane tp = new JTextPane();
            d.add((Component)tp, "Center");
            d.setSize(new Dimension(500, 600));
            tp.setText(this.inputFileHandler.getFileData(NBOFileHandler.newNBOFile((File)newFile, (String)"nbo").toString()));
            d.setVisible(true);
        }
    }

    private void postListRequest(String cmd_basis, JComboBox<String> cb) {
        String cmd;
        int mode = 64;
        SB sb = this.getMetaHeader(false);
        int metaKey = this.keywordID;
        if (this.keywordID == 10 || this.keywordID == 11) {
            cmd = "o";
            JComboBox<String> tmpBas = cmd_basis.startsWith("c") && metaKey == 11 ? this.comboBasis2 : this.comboBasis1;
            switch (tmpBas.getSelectedIndex()) {
                case 0: 
                case 1: 
                case 2: {
                    metaKey = 1;
                    break;
                }
                case 5: 
                case 6: {
                    metaKey = 2;
                    break;
                }
                case 3: 
                case 4: {
                    metaKey = 3;
                    break;
                }
                case 7: 
                case 8: {
                    metaKey = 5;
                    break;
                }
                case 9: {
                    cmd = "c";
                    metaKey = 8;
                }
            }
            this.postAddGlobalI(sb, "BAS_1", 1, tmpBas);
        } else {
            this.postAddGlobalI(sb, "BAS_1", 1, this.comboBasis1);
            cmd = cmd_basis.split(" ")[0];
        }
        this.postAddGlobalI(sb, "KEYWORD", metaKey, null);
        this.postAddCmd(sb, cmd);
        if (this.keywordID == 8 && cmd_basis.equals("c_cmo")) {
            mode = 24;
        }
        this.postNBO_s(sb, mode, cb, "Getting list " + cmd);
    }

    private void postNBO_s(SB sb, final int mode, final JComboBox<String> cb, String statusMessage) {
        final NBORequest req = new NBORequest();
        req.set(new Runnable(){

            @Override
            public void run() {
                NBODialogSearch.this.processNBO_s(req, mode, cb);
            }
        }, statusMessage, new String[]{"s_cmd.txt", sb.toString()});
        this.nboService.postToNBO(req);
    }

    protected void showMax(String line) {
    }

    protected void processNBO_s(NBORequest req, int mode, JComboBox<String> cb) {
        String[] lines = req.getReplyLines();
        switch (mode) {
            case 14: {
                String line = lines[0];
                if (this.isOpenShell()) {
                    String spin = this.alphaSpin.isSelected() ? "&uarr;" : "&darr;";
                    int ind = line.indexOf(41) + 1;
                    line = line.substring(0, ind) + spin + line.substring(ind);
                }
                this.logValue(" " + line);
                if (!line.contains("*")) break;
                this.showMax(line);
                break;
            }
            case 64: {
                DefaultComboBoxModel list = (DefaultComboBoxModel)cb.getModel();
                list.removeAllElements();
                if (cb == this.comboAtom1 || cb == this.comboAtom2) {
                    list.addElement("<select an atom>");
                } else if (cb == this.comboSearchOrb1 || cb == this.comboSearchOrb2) {
                    list.addElement("<select an orbital>");
                }
                for (int i = 0; i < lines.length; ++i) {
                    list.addElement(lines[i]);
                }
                this.processReturnedSearchList(cb);
                break;
            }
            case 24: {
                DefaultComboBoxModel list = (DefaultComboBoxModel)cb.getModel();
                for (int i = 0; i < lines.length; ++i) {
                    list.addElement("  " + PT.rep(PT.rep(lines[i], "MO ", ""), " ", ".  "));
                }
                break;
            }
            case 44: 
            case 54: {
                int i0 = -1;
                int i = lines.length;
                while (--i >= 0 && lines[i].indexOf("END") < 0) {
                    i0 = i;
                }
                boolean isLabel = mode == 44;
                SB sb = new SB();
                int i2 = i0;
                int pt = 1;
                while (i2 < lines.length && !(isLabel ? !this.processLabel(sb, lines[i2], pt) : !this.processLabelBonds(sb, lines[i2]))) {
                    ++i2;
                    ++pt;
                }
                this.runScriptQueued(sb.toString() + ";set fontscaling true; select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;" + ";select none;");
            }
        }
    }

    protected boolean processLabel(SB sb, String line, int count) {
        try {
            double val = Double.parseDouble(line);
            val = NBODialogSearch.round(val, 4);
            sb.append(";select @" + count + ";label " + val);
        }
        catch (Exception e) {
            System.out.println("SEARCH: label processing ended!");
            return false;
        }
        return true;
    }

    protected boolean processLabelBonds(SB sb, String line) {
        try {
            String[] toks = PT.getTokens(line);
            if (toks.length < 3) {
                return false;
            }
            float order = Float.parseFloat(toks[2]);
            if ((double)order > 0.01) {
                sb.append("font measures 20; measure id 'm" + toks[0] + "_" + toks[1] + "' @" + toks[0] + " @" + toks[1] + " radius 0.0 \"" + toks[2] + "\";");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

