/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;

public class XmlCmlReader
extends XmlReader {
    private String scalarDictRef;
    private String scalarDictValue;
    private String scalarTitle;
    private String cellParameterType;
    private boolean checkedSerial;
    private boolean isSerial;
    private int moleculeNesting = 0;
    private int latticeVectorPtr = 0;
    private boolean embeddedCrystal = false;
    private Properties atomIdNames;
    protected String[] tokens = new String[16];
    private int aaLen;
    private Atom[] atomArray = new Atom[100];
    private int bondCount;
    private Bond[] bondArray = new Bond[100];
    private int tokenCount;
    private int moduleNestingLevel = 0;
    private boolean haveMolecule = false;
    private String localSpaceGroupName;
    protected boolean processing = true;
    protected int state = 0;
    private int atomIndex0;
    private Lst<String[]> joinList;
    private Map<Atom, String> mapRtoA;
    private BS deleteAtoms;
    protected String moleculeID;
    protected Map<String, Object> htModelAtomMap;
    private boolean is2d;
    protected static final int START = 0;
    protected static final int CML = 1;
    protected static final int CRYSTAL = 2;
    protected static final int CRYSTAL_SCALAR = 3;
    protected static final int CRYSTAL_SYMMETRY = 4;
    protected static final int CRYSTAL_SYMMETRY_TRANSFORM3 = 5;
    protected static final int MOLECULE = 6;
    protected static final int MOLECULE_ATOM_ARRAY = 7;
    protected static final int MOLECULE_ATOM = 8;
    protected static final int MOLECULE_ATOM_SCALAR = 9;
    protected static final int MOLECULE_BOND_ARRAY = 10;
    protected static final int MOLECULE_BOND = 11;
    protected static final int MOLECULE_FORMULA = 12;
    protected static final int MOLECULE_ATOM_BUILTIN = 13;
    protected static final int MOLECULE_BOND_BUILTIN = 14;
    protected static final int MODULE = 15;
    protected static final int SYMMETRY = 17;
    protected static final int LATTICE_VECTOR = 18;
    protected static final int ASSOCIATION = 19;
    private static final String[] unitCellParamTags = new String[]{"a", "b", "c", "alpha", "beta", "gamma"};

    @Override
    protected void processXml(XmlReader parent, Object saxReader) throws Exception {
        this.is2d = parent.checkFilterKey("2D");
        this.processXml2(parent, saxReader);
    }

    @Override
    public void processStartElement(String name, String nodeName) {
        if (!this.processing) {
            return;
        }
        this.processStart2(name);
    }

    protected void processStart2(String name) {
        name = name.toLowerCase();
        switch (this.state) {
            case 0: {
                if (name.equals("molecule")) {
                    this.moleculeID = (String)this.atts.get("id");
                    this.state = 6;
                    this.haveMolecule = true;
                    if (this.moleculeNesting == 0) {
                        this.createNewAtomSet();
                    }
                    ++this.moleculeNesting;
                    break;
                }
                if (name.equals("crystal")) {
                    this.state = 2;
                    break;
                }
                if (name.equals("symmetry")) {
                    this.state = 17;
                    String val = (String)this.atts.get("spacegroup");
                    if (val != null) {
                        this.localSpaceGroupName = val;
                        break;
                    }
                    this.localSpaceGroupName = "P1";
                    this.parent.clearUnitCell();
                    break;
                }
                if (name.equals("module")) {
                    ++this.moduleNestingLevel;
                    break;
                }
                if (!name.equals("latticevector")) break;
                this.state = 18;
                this.setKeepChars(true);
                break;
            }
            case 2: {
                String val;
                this.checkedSerial = true;
                this.isSerial = false;
                if (name.equals("scalar")) {
                    this.state = 3;
                    this.setKeepChars(true);
                    this.scalarTitle = (String)this.atts.get("title");
                    this.getDictRefValue();
                    break;
                }
                if (name.equals("symmetry")) {
                    this.state = 4;
                    String val2 = (String)this.atts.get("spacegroup");
                    if (val2 == null) break;
                    this.localSpaceGroupName = val2;
                    for (int i = 0; i < this.localSpaceGroupName.length(); ++i) {
                        if (this.localSpaceGroupName.charAt(i) != '_') continue;
                        this.localSpaceGroupName = this.localSpaceGroupName.substring(0, i) + this.localSpaceGroupName.substring(i-- + 1);
                    }
                    break;
                }
                if (!name.equals("cellparameter") || (val = (String)this.atts.get("parametertype")) == null) break;
                this.cellParameterType = val;
                this.setKeepChars(true);
                break;
            }
            case 18: {
                this.setKeepChars(true);
                break;
            }
            case 3: 
            case 4: 
            case 17: {
                if (!name.equals("transform3")) break;
                this.state = 5;
                this.setKeepChars(true);
                break;
            }
            case 5: 
            case 6: {
                if (name.equals("fragmentlist")) {
                    this.joinList = new Lst();
                    this.mapRtoA = new Hashtable<Atom, String>();
                    if (this.deleteAtoms != null) break;
                    this.deleteAtoms = new BS();
                    break;
                }
                if (name.equals("crystal")) {
                    this.state = 2;
                    this.embeddedCrystal = true;
                    break;
                }
                if (name.equals("molecule")) {
                    this.state = 6;
                    ++this.moleculeNesting;
                    break;
                }
                if (name.equals("join")) {
                    int order = -1;
                    this.tokenCount = 0;
                    String val = (String)this.atts.get("atomrefs2");
                    if (val == null) break;
                    this.breakOutTokens(val);
                    val = (String)this.atts.get("order");
                    if (val != null) {
                        order = this.parseBondToken(val);
                    }
                    if (this.tokenCount != 2 || order <= 0) break;
                    this.joinList.addLast((Object)new String[]{this.tokens[0], this.tokens[1], "" + order});
                    break;
                }
                if (name.equals("bondarray")) {
                    int i;
                    this.state = 10;
                    this.bondCount = 0;
                    String val = (String)this.atts.get("order");
                    if (val != null) {
                        this.breakOutBondTokens(val);
                        i = this.tokenCount;
                        while (--i >= 0) {
                            this.bondArray[i].order = this.parseBondToken(this.tokens[i]);
                        }
                    }
                    if ((val = (String)this.atts.get("atomref1")) != null) {
                        this.breakOutBondTokens(val);
                        i = this.tokenCount;
                        while (--i >= 0) {
                            this.bondArray[i].atomIndex1 = this.getAtomIndex(this.tokens[i]);
                        }
                    }
                    if ((val = (String)this.atts.get("atomref2")) == null) break;
                    this.breakOutBondTokens(val);
                    i = this.tokenCount;
                    while (--i >= 0) {
                        this.bondArray[i].atomIndex2 = this.getAtomIndex(this.tokens[i]);
                    }
                    break;
                }
                if (name.equals("atomarray")) {
                    int i;
                    boolean is3d;
                    this.state = 7;
                    this.aaLen = 0;
                    boolean coords3D = false;
                    String val = (String)this.atts.get("atomid");
                    if (val != null) {
                        this.breakOutAtomTokens(val);
                        int i2 = this.tokenCount;
                        while (--i2 >= 0) {
                            this.atomArray[i2].atomName = this.tokens[i2];
                        }
                    }
                    boolean bl = is3d = !this.is2d && (val = (String)this.atts.get("x3")) != null;
                    if (is3d) {
                        is3d = true;
                        coords3D = true;
                        this.breakOutAtomTokens(val);
                        i = this.tokenCount;
                        while (--i >= 0) {
                            this.atomArray[i].x = this.parseFloatStr(this.tokens[i]);
                        }
                        val = (String)this.atts.get("y3");
                        if (val != null) {
                            this.breakOutAtomTokens(val);
                            i = this.tokenCount;
                            while (--i >= 0) {
                                this.atomArray[i].y = this.parseFloatStr(this.tokens[i]);
                            }
                        }
                        if ((val = (String)this.atts.get("z3")) != null) {
                            this.breakOutAtomTokens(val);
                            i = this.tokenCount;
                            while (--i >= 0) {
                                this.atomArray[i].z = this.parseFloatStr(this.tokens[i]);
                            }
                        }
                    } else {
                        val = (String)this.atts.get("x2");
                        if (val != null) {
                            this.breakOutAtomTokens(val);
                            i = this.tokenCount;
                            while (--i >= 0) {
                                this.atomArray[i].x = this.parseFloatStr(this.tokens[i]);
                            }
                        }
                        if ((val = (String)this.atts.get("y2")) != null) {
                            this.breakOutAtomTokens(val);
                            i = this.tokenCount;
                            while (--i >= 0) {
                                this.atomArray[i].y = this.parseFloatStr(this.tokens[i]);
                            }
                        }
                    }
                    if ((val = (String)this.atts.get("elementtype")) != null) {
                        this.breakOutAtomTokens(val);
                        i = this.tokenCount;
                        while (--i >= 0) {
                            this.atomArray[i].elementSymbol = this.tokens[i];
                        }
                    }
                    i = this.aaLen;
                    while (--i >= 0) {
                        Atom atom = this.atomArray[i];
                        if (!coords3D) {
                            atom.z = 0.0f;
                        }
                        this.addAtom(atom);
                    }
                    break;
                }
                if (name.equals("formula")) {
                    this.state = 12;
                    break;
                }
                if (!name.equals("association")) break;
                this.state = 19;
                break;
            }
            case 10: {
                if (!name.equals("bond")) break;
                this.state = 11;
                int order = -1;
                this.tokenCount = 0;
                String val = (String)this.atts.get("atomrefs2");
                if (val != null) {
                    this.breakOutTokens(val);
                }
                if ((val = (String)this.atts.get("order")) != null) {
                    order = this.parseBondToken(val);
                }
                if (this.tokenCount != 2 || order <= 0) break;
                this.addNewBond(this.tokens[0], this.tokens[1], order);
                break;
            }
            case 7: {
                if (!name.equals("atom")) break;
                this.state = 8;
                this.atom = new Atom();
                this.parent.setFractionalCoordinates(false);
                String id = (String)this.atts.get("id");
                String val = (String)this.atts.get("name");
                this.atom.atomName = val != null ? val : ((val = (String)this.atts.get("title")) != null ? val : ((val = (String)this.atts.get("label")) != null ? val : id));
                if (!this.checkedSerial) {
                    this.isSerial = id != null && id.length() > 1 && id.startsWith("a") && PT.parseInt((String)id.substring(1)) != Integer.MIN_VALUE;
                    this.checkedSerial = true;
                }
                if (this.isSerial) {
                    this.atom.atomSerial = PT.parseInt((String)id.substring(1));
                }
                if ((val = (String)this.atts.get("xfract")) != null && (this.parent.iHaveUnitCell || !this.atts.containsKey("x3"))) {
                    this.parent.setFractionalCoordinates(true);
                    this.atom.set(this.parseFloatStr(val), this.parseFloatStr((String)this.atts.get("yfract")), this.parseFloatStr((String)this.atts.get("zfract")));
                } else {
                    val = (String)this.atts.get("x3");
                    if (val != null) {
                        this.atom.set(this.parseFloatStr(val), this.parseFloatStr((String)this.atts.get("y3")), this.parseFloatStr((String)this.atts.get("z3")));
                    } else {
                        val = (String)this.atts.get("x2");
                        if (val != null) {
                            this.atom.set(this.parseFloatStr(val), this.parseFloatStr((String)this.atts.get("y2")), 0.0f);
                        }
                    }
                }
                val = (String)this.atts.get("elementtype");
                if (val != null) {
                    String sym = val;
                    val = (String)this.atts.get("isotope");
                    if (val != null) {
                        this.atom.elementNumber = (short)((this.parseIntStr(val) << 7) + JmolAdapter.getElementNumber((String)sym));
                    }
                    this.atom.elementSymbol = sym;
                }
                if ((val = (String)this.atts.get("formalcharge")) == null) break;
                this.atom.formalCharge = this.parseIntStr(val);
                break;
            }
            case 11: {
                String val = (String)this.atts.get("builtin");
                if (val == null) break;
                this.setKeepChars(true);
                this.state = 14;
                this.scalarDictValue = val;
                break;
            }
            case 8: {
                if (name.equals("scalar")) {
                    this.state = 9;
                    this.setKeepChars(true);
                    this.scalarTitle = (String)this.atts.get("title");
                    this.getDictRefValue();
                    break;
                }
                String val = (String)this.atts.get("builtin");
                if (val == null) break;
                this.setKeepChars(true);
                this.state = 13;
                this.scalarDictValue = val;
                break;
            }
            case 9: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
        }
    }

    private int getAtomIndex(String label) {
        return this.asc.getAtomIndex(this.isSerial ? label.substring(1) : label);
    }

    @Override
    void processEndElement(String name) {
        if (!this.processing) {
            return;
        }
        this.processEnd2(name);
    }

    public void processEnd2(String name) {
        name = name.toLowerCase();
        switch (this.state) {
            case 0: {
                if (!name.equals("module") || --this.moduleNestingLevel != 0) break;
                if (this.parent.iHaveUnitCell) {
                    this.applySymmetryAndSetTrajectory();
                }
                this.setAtomNames();
                break;
            }
            case 19: {
                if (!name.equals("association")) break;
                this.state = 6;
                break;
            }
            case 2: {
                if (name.equals("crystal")) {
                    if (this.embeddedCrystal) {
                        this.state = 6;
                        this.embeddedCrystal = false;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                if (!name.equals("cellparameter") || !this.keepChars) break;
                String[] tokens = PT.getTokens((String)this.chars.toString());
                this.setKeepChars(false);
                if (tokens.length == 3 && this.cellParameterType != null) {
                    if (this.cellParameterType.equals("length")) {
                        for (int i = 0; i < 3; ++i) {
                            this.parent.setUnitCellItem(i, this.parseFloatStr(tokens[i]));
                        }
                        break;
                    }
                    if (this.cellParameterType.equals("angle")) {
                        for (int i = 0; i < 3; ++i) {
                            this.parent.setUnitCellItem(i + 3, this.parseFloatStr(tokens[i]));
                        }
                        break;
                    }
                }
                Logger.error((String)("bad cellParameter information: parameterType=" + this.cellParameterType + " data=" + this.chars));
                this.parent.setFractionalCoordinates(false);
                break;
            }
            case 3: {
                if (name.equals("scalar")) {
                    this.state = 2;
                    if (this.scalarTitle != null) {
                        this.checkUnitCellItem(unitCellParamTags, this.scalarTitle);
                    } else if (this.scalarDictRef != null) {
                        this.checkUnitCellItem(JmolAdapter.cellParamNames, this.scalarDictValue.startsWith("_") ? this.scalarDictValue : "_" + this.scalarDictValue);
                    }
                }
                this.setKeepChars(false);
                this.scalarTitle = null;
                this.scalarDictRef = null;
                break;
            }
            case 5: {
                if (!name.equals("transform3")) break;
                this.setKeepChars(false);
                this.state = 4;
                break;
            }
            case 18: {
                float[] values = XmlCmlReader.getTokensFloat((String)this.chars.toString(), null, (int)3);
                this.parent.addPrimitiveLatticeVector(this.latticeVectorPtr, values, 0);
                this.latticeVectorPtr = (this.latticeVectorPtr + 1) % 3;
                this.setKeepChars(false);
                this.state = 0;
                break;
            }
            case 4: 
            case 17: {
                if (name.equals("symmetry")) {
                    int n = this.state = this.state == 4 ? 2 : 0;
                }
                if (this.moduleNestingLevel != 0 || !this.parent.iHaveUnitCell || this.embeddedCrystal) break;
                this.applySymmetryAndSetTrajectory();
                break;
            }
            case 6: {
                if (name.equals("fragmentlist")) {
                    int i = this.joinList.size();
                    while (--i >= 0) {
                        String[] join = (String[])this.joinList.get(i);
                        Atom r1 = this.asc.getAtomFromName(this.fixSerialName(join[0]));
                        Atom r2 = this.asc.getAtomFromName(this.fixSerialName(join[1]));
                        if (r1 == null || r2 == null) continue;
                        this.deleteAtoms.set(r1.index);
                        this.deleteAtoms.set(r2.index);
                        this.addNewBond(this.mapRtoA.get(r1), this.mapRtoA.get(r2), this.parseIntStr(join[2]));
                    }
                    this.joinList = null;
                    this.mapRtoA = null;
                }
                if (!name.equals("molecule")) break;
                if (--this.moleculeNesting == 0) {
                    this.applySymmetryAndSetTrajectory();
                    this.setAtomNames();
                    this.state = 0;
                    break;
                }
                this.state = 6;
                break;
            }
            case 10: {
                if (!name.equals("bondarray")) break;
                this.state = 6;
                for (int i = 0; i < this.bondCount; ++i) {
                    this.addBond(this.bondArray[i]);
                }
                this.parent.applySymmetryToBonds = true;
                break;
            }
            case 7: {
                if (!name.equals("atomarray")) break;
                this.state = 6;
                break;
            }
            case 11: {
                if (!name.equals("bond")) break;
                this.state = 10;
                break;
            }
            case 8: {
                if (!name.equals("atom")) break;
                this.state = 7;
                this.addAtom(this.atom);
                this.atom = null;
                break;
            }
            case 9: {
                if (name.equals("scalar")) {
                    this.state = 8;
                    if ("jmol:charge".equals(this.scalarDictRef)) {
                        this.atom.partialCharge = this.parseFloatStr(this.chars.toString());
                    } else if (this.scalarDictRef != null && "_atom_site_label".equals(this.scalarDictValue)) {
                        if (this.atomIdNames == null) {
                            this.atomIdNames = new Properties();
                        }
                        this.atomIdNames.put(this.atom.atomName, this.chars.toString());
                    }
                }
                this.setKeepChars(false);
                this.scalarTitle = null;
                this.scalarDictRef = null;
                break;
            }
            case 13: {
                this.state = 8;
                if (this.scalarDictValue.equals("x3")) {
                    this.atom.x = this.parseFloatStr(this.chars.toString());
                } else if (this.scalarDictValue.equals("y3")) {
                    this.atom.y = this.parseFloatStr(this.chars.toString());
                } else if (this.scalarDictValue.equals("z3")) {
                    this.atom.z = this.parseFloatStr(this.chars.toString());
                } else if (this.scalarDictValue.equals("elementType")) {
                    this.atom.elementSymbol = this.chars.toString();
                }
                this.setKeepChars(false);
                break;
            }
            case 14: {
                int order;
                this.state = 11;
                if (this.scalarDictValue.equals("atomRef")) {
                    if (this.tokenCount == 0) {
                        this.tokens = new String[2];
                    }
                    if (this.tokenCount < 2) {
                        this.tokens[this.tokenCount++] = this.chars.toString();
                    }
                } else if (this.scalarDictValue.equals("order") && (order = this.parseBondToken(this.chars.toString())) > 0 && this.tokenCount == 2) {
                    this.addNewBond(this.tokens[0], this.tokens[1], order);
                }
                this.setKeepChars(false);
                break;
            }
            case 12: {
                this.state = 6;
            }
        }
    }

    private void addBond(Bond bond) {
        Atom a1 = this.asc.atoms[bond.atomIndex1];
        Atom a2 = this.asc.atoms[bond.atomIndex2];
        if (this.joinList != null && !this.checkBondToR(a1.atomName, a2.atomName)) {
            this.asc.addBond(bond);
        }
    }

    private boolean checkBondToR(String a1name, String a2name) {
        Atom a1 = this.asc.getAtomFromName(a1name);
        Atom a2 = this.asc.getAtomFromName(a2name);
        if (a1 == null || a2 == null) {
            return true;
        }
        if ("R".equals(a1.elementSymbol)) {
            this.mapRtoA.put(a1, a2.atomName);
            return true;
        }
        if ("R".equals(a2.elementSymbol)) {
            this.mapRtoA.put(a2, a1.atomName);
            return true;
        }
        return false;
    }

    private void setAtomNames() {
        if (this.atomIdNames == null) {
            return;
        }
        Atom[] atoms = this.asc.atoms;
        for (int i = this.atomIndex0; i < this.asc.ac; ++i) {
            String s = this.atomIdNames.getProperty(atoms[i].atomName);
            if (s == null) continue;
            atoms[i].atomName = s;
        }
        this.atomIdNames = null;
        this.atomIndex0 = this.asc.ac;
    }

    private void addNewBond(String a1, String a2, int order) {
        if (a1 == null || a2 == null) {
            return;
        }
        this.parent.applySymmetryToBonds = true;
        a1 = this.fixSerialName(a1);
        a2 = this.fixSerialName(a2);
        if (this.joinList == null || !this.checkBondToR(a1, a2)) {
            this.asc.addNewBondFromNames(a1, a2, order);
        }
    }

    private String fixSerialName(String a) {
        return this.isSerial ? a.substring(1) : a;
    }

    private void getDictRefValue() {
        this.scalarDictRef = (String)this.atts.get("dictref");
        if (this.scalarDictRef != null) {
            int iColon = this.scalarDictRef.indexOf(":");
            this.scalarDictValue = this.scalarDictRef.substring(iColon + 1);
        }
    }

    private void checkUnitCellItem(String[] tags, String value) {
        int i = tags.length;
        while (--i >= 0) {
            if (!value.equals(tags[i])) continue;
            this.parent.setUnitCellItem(i, this.parseFloatStr(this.chars.toString()));
            return;
        }
    }

    private void addAtom(Atom atom) {
        if (atom.elementSymbol == null && atom.elementNumber < 0 || Float.isNaN(atom.z)) {
            return;
        }
        this.parent.setAtomCoord(atom);
        if (this.htModelAtomMap != null) {
            this.htModelAtomMap.put(this.moleculeID + atom.atomName, atom);
        }
        if (this.isSerial) {
            this.asc.addAtomWithMappedSerialNumber(atom);
        } else {
            this.asc.addAtomWithMappedName(atom);
        }
    }

    private int parseBondToken(String str) {
        float floatOrder = this.parseFloatStr(str);
        if (Float.isNaN(floatOrder) && str.length() >= 1) {
            str = str.toUpperCase();
            switch (str.charAt(0)) {
                case 'S': {
                    return 1;
                }
                case 'D': {
                    return 2;
                }
                case 'T': {
                    return 3;
                }
                case 'A': {
                    return 515;
                }
                case 'P': {
                    return 66;
                }
            }
            return this.parseIntStr(str);
        }
        if ((double)floatOrder == 1.5) {
            return 515;
        }
        if (floatOrder == 2.0f) {
            return 2;
        }
        if (floatOrder == 3.0f) {
            return 3;
        }
        return 1;
    }

    private void breakOutTokens(String str) {
        StringTokenizer st = new StringTokenizer(str);
        this.tokenCount = st.countTokens();
        if (this.tokenCount > this.tokens.length) {
            this.tokens = new String[this.tokenCount];
        }
        for (int i = 0; i < this.tokenCount; ++i) {
            try {
                this.tokens[i] = st.nextToken();
                continue;
            }
            catch (NoSuchElementException nsee) {
                this.tokens[i] = null;
            }
        }
    }

    void breakOutAtomTokens(String str) {
        this.breakOutTokens(str);
        this.checkAtomArrayLength(this.tokenCount);
    }

    void checkAtomArrayLength(int newAtomCount) {
        if (this.aaLen == 0) {
            if (newAtomCount > this.atomArray.length) {
                this.atomArray = new Atom[newAtomCount];
            }
            int i = newAtomCount;
            while (--i >= 0) {
                this.atomArray[i] = new Atom();
            }
            this.aaLen = newAtomCount;
        } else if (newAtomCount != this.aaLen) {
            throw new IndexOutOfBoundsException("bad atom attribute length");
        }
    }

    void breakOutBondTokens(String str) {
        this.breakOutTokens(str);
        this.checkBondArrayLength(this.tokenCount);
    }

    void checkBondArrayLength(int newBondCount) {
        if (this.bondCount == 0) {
            if (newBondCount > this.bondArray.length) {
                this.bondArray = new Bond[newBondCount];
            }
            int i = newBondCount;
            while (--i >= 0) {
                this.bondArray[i] = new Bond(-1, -1, 1);
            }
            this.bondCount = newBondCount;
        } else if (newBondCount != this.bondCount) {
            throw new IndexOutOfBoundsException("bad bond attribute length");
        }
    }

    private void createNewAtomSet() {
        String val;
        String collectionName;
        this.asc.newAtomSet();
        if (this.htModelAtomMap != null) {
            this.htModelAtomMap.put("" + this.asc.iSet, "" + this.moleculeID);
        }
        String string = collectionName = (val = (String)this.atts.get("title")) != null || (val = (String)this.atts.get("id")) != null ? val : null;
        if (collectionName != null) {
            this.asc.setAtomSetName(collectionName);
        }
    }

    @Override
    public void applySymmetryAndSetTrajectory() {
        if (this.moduleNestingLevel > 0 || !this.haveMolecule || this.localSpaceGroupName == null) {
            return;
        }
        this.parent.setSpaceGroupName(this.localSpaceGroupName);
        this.parent.iHaveSymmetryOperators = this.iHaveSymmetryOperators;
        this.parent.applySymmetryAndSetTrajectory();
    }

    @Override
    public void endDocument() {
        if (this.deleteAtoms != null) {
            BS bs = this.asc.bsAtoms == null ? (this.asc.bsAtoms = BSUtil.newBitSet2((int)0, (int)this.asc.ac)) : this.asc.bsAtoms;
            bs.andNot(this.deleteAtoms);
        }
    }
}

