/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.Lst;
import org.jmol.modelset.Atom;
import org.jmol.modelsetbio.BasePair;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.renderbio.BioShapeRenderer;
import org.jmol.shapebio.BioShape;
import org.jmol.util.C;

public class BackboneRenderer
extends BioShapeRenderer {
    private boolean isDataFrame;

    @Override
    protected void renderBioShape(BioShape bioShape) {
        boolean checkPass2 = !this.isExport && !this.vwr.gdata.isPass2;
        boolean showSteps = this.vwr.getBoolean(603979811) && bioShape.bioPolymer.isNucleic();
        this.isDataFrame = this.vwr.ms.isJmolDataFrameForModel(bioShape.modelIndex);
        int n = this.monomerCount;
        Atom[] atoms = this.ms.at;
        int i = this.bsVisible.nextSetBit(0);
        while (i >= 0) {
            NucleicMonomer g;
            Lst<BasePair> bps;
            Atom atomA = atoms[this.leadAtomIndices[i]];
            short cA = this.colixes[i];
            this.mad = this.mads[i];
            int i1 = (i + 1) % n;
            this.drawSegment(atomA, atoms[this.leadAtomIndices[i1]], cA, this.colixes[i1], 100.0f, checkPass2);
            if (showSteps && (bps = (g = (NucleicMonomer)this.monomers[i]).getBasePairs()) != null) {
                int j = bps.size();
                while (--j >= 0) {
                    int iAtom = ((BasePair)bps.get(j)).getPartnerAtom(g);
                    if (iAtom <= i) continue;
                    this.drawSegment(atomA, atoms[iAtom], cA, cA, 1000.0f, checkPass2);
                }
            }
            i = this.bsVisible.nextSetBit(i + 1);
        }
    }

    private void drawSegment(Atom atomA, Atom atomB, short colixA, short colixB, float max, boolean checkPass2) {
        if (atomA.nBackbonesDisplayed == 0 || atomB.nBackbonesDisplayed == 0 || this.ms.isAtomHidden(atomB.i) || !this.isDataFrame && atomA.distanceSquared(atomB) > max) {
            return;
        }
        colixA = C.getColixInherited(colixA, atomA.colixAtom);
        colixB = C.getColixInherited(colixB, atomB.colixAtom);
        if (checkPass2 && !this.setBioColix(colixA) && !this.setBioColix(colixB)) {
            return;
        }
        int xA = atomA.sX;
        int yA = atomA.sY;
        int zA = atomA.sZ;
        int xB = atomB.sX;
        int yB = atomB.sY;
        int zB = atomB.sZ;
        int mad = this.mad;
        if (max == 1000.0f) {
            mad >>= 1;
        }
        if (mad < 0) {
            this.g3d.drawLine(colixA, colixB, xA, yA, zA, xB, yB, zB);
        } else {
            int width = (int)(this.isExport ? (float)mad : this.vwr.tm.scaleToScreen((zA + zB) / 2, mad));
            this.g3d.fillCylinderXYZ(colixA, colixB, (byte)3, width, xA, yA, zA, xB, yB, zB);
        }
    }
}

