/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.Instrumentable;
import com.oracle.truffle.api.instrumentation.InstrumentableFactory;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.LoadSourceEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceListener;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionListener;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;

final class InstrumentationHandler {
    private static final boolean TRACE = Boolean.getBoolean("truffle.instrumentation.trace");
    private final Object sourceVM;
    private final Map<Source, Void> sources = Collections.synchronizedMap(new WeakHashMap());
    private volatile Collection<Source> sourcesList;
    private final Collection<RootNode> loadedRoots = new WeakAsyncList<RootNode>(256);
    private final Collection<RootNode> executedRoots = new WeakAsyncList<RootNode>(64);
    private final Collection<EventBinding<?>> executionBindings = new EventBindingList(8);
    private final Collection<EventBinding<?>> sourceSectionBindings = new EventBindingList(8);
    private final Collection<EventBinding<?>> sourceBindings = new EventBindingList(8);
    private final ConcurrentHashMap<Object, AbstractInstrumenter> instrumenterMap = new ConcurrentHashMap();
    private final OutputStream out;
    private final OutputStream err;
    private final InputStream in;
    private final Map<Class<?>, Set<Class<?>>> cachedProvidedTags = new ConcurrentHashMap();
    static final AccessorInstrumentHandler ACCESSOR = new AccessorInstrumentHandler();

    private InstrumentationHandler(Object sourceVM, OutputStream out, OutputStream err, InputStream in) {
        this.sourceVM = sourceVM;
        this.out = out;
        this.err = err;
        this.in = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onLoad(RootNode root) {
        if (!AccessorInstrumentHandler.nodesAccess().isInstrumentable(root)) {
            return;
        }
        Source source = null;
        Map<Source, Void> map = this.sources;
        synchronized (map) {
            if (!this.sourceBindings.isEmpty()) {
                this.lazyInitializeSourcesList();
                SourceSection sourceSection = root.getSourceSection();
                if (sourceSection != null && !this.sources.containsKey(source = sourceSection.getSource())) {
                    this.sources.put(source, null);
                    this.sourcesList.add(source);
                }
            }
            this.loadedRoots.add(root);
        }
        if (source != null) {
            InstrumentationHandler.notifySourceBindingsLoaded(this.sourceBindings, source);
        }
        if (!this.sourceSectionBindings.isEmpty()) {
            this.visitRoot(root, new NotifyLoadedListenerVisitor(this.sourceSectionBindings));
        }
    }

    void onFirstExecution(RootNode root) {
        if (!AccessorInstrumentHandler.nodesAccess().isInstrumentable(root)) {
            return;
        }
        this.executedRoots.add(root);
        if (this.executionBindings.isEmpty()) {
            return;
        }
        this.visitRoot(root, new InsertWrappersVisitor(this.executionBindings));
    }

    void addInstrument(Object key, Class<?> clazz) {
        this.addInstrumenter(key, new InstrumentClientInstrumenter(this.sourceVM, clazz, this.out, this.err, this.in));
    }

    void disposeInstrumenter(Object key, boolean cleanupRequired) {
        AbstractInstrumenter disposedInstrumenter = this.instrumenterMap.remove(key);
        if (disposedInstrumenter == null) {
            throw new AssertionError((Object)"Instrumenter already disposed.");
        }
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Dispose instrumenter %n", key);
        }
        disposedInstrumenter.dispose();
        if (cleanupRequired) {
            Collection<EventBinding<?>> disposedExecutionBindings = InstrumentationHandler.filterBindingsForInstrumenter(this.executionBindings, disposedInstrumenter);
            if (!disposedExecutionBindings.isEmpty()) {
                this.visitRoots(this.executedRoots, new DisposeWrappersWithBindingVisitor(disposedExecutionBindings));
            }
            InstrumentationHandler.disposeBindingsBulk(disposedExecutionBindings);
            InstrumentationHandler.disposeBindingsBulk(InstrumentationHandler.filterBindingsForInstrumenter(this.sourceSectionBindings, disposedInstrumenter));
            InstrumentationHandler.disposeBindingsBulk(InstrumentationHandler.filterBindingsForInstrumenter(this.sourceBindings, disposedInstrumenter));
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Disposed instrumenter %n", key);
        }
    }

    private static void disposeBindingsBulk(Collection<EventBinding<?>> list) {
        for (EventBinding<?> binding : list) {
            binding.disposeBulk();
        }
    }

    Instrumenter forLanguage(TruffleLanguage.Env context, TruffleLanguage<?> language) {
        return new LanguageClientInstrumenter(language, context);
    }

    <T> EventBinding<T> addExecutionBinding(EventBinding<T> binding) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding execution binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        this.executionBindings.add(binding);
        if (!this.executedRoots.isEmpty()) {
            this.visitRoots(this.executedRoots, new InsertWrappersWithBindingVisitor(binding));
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added execution binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        return binding;
    }

    <T> EventBinding<T> addSourceSectionBinding(EventBinding<T> binding, boolean notifyLoaded) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        this.sourceSectionBindings.add(binding);
        if (notifyLoaded && !this.loadedRoots.isEmpty()) {
            this.visitRoots(this.loadedRoots, new NotifyLoadedWithBindingVisitor(binding));
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> EventBinding<T> addSourceBinding(EventBinding<T> binding, boolean notifyLoaded) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding source binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        this.sourceBindings.add(binding);
        if (notifyLoaded) {
            Map<Source, Void> map = this.sources;
            synchronized (map) {
                this.lazyInitializeSourcesList();
            }
            for (Source source : this.sourcesList) {
                InstrumentationHandler.notifySourceBindingLoaded(binding, source);
            }
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added source binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        return binding;
    }

    private void lazyInitializeSourcesList() {
        assert (Thread.holdsLock(this.sources));
        if (this.sourcesList == null) {
            this.sourcesList = new WeakAsyncList<Source>(16);
            for (RootNode root : this.loadedRoots) {
                Source source;
                SourceSection sourceSection = root.getSourceSection();
                if (sourceSection == null || this.sources.containsKey(source = sourceSection.getSource())) continue;
                this.sources.put(source, null);
                this.sourcesList.add(source);
            }
        }
    }

    private void visitRoots(Collection<RootNode> roots, AbstractNodeVisitor addBindingsVisitor) {
        for (RootNode root : roots) {
            this.visitRoot(root, addBindingsVisitor);
        }
    }

    void disposeBinding(EventBinding<?> binding) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Dispose binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        if (binding.isExecutionEvent()) {
            this.visitRoots(this.executedRoots, new DisposeWrappersVisitor(binding));
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Disposed binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
    }

    ProbeNode.EventChainNode createBindings(ProbeNode probeNodeImpl) {
        EventContext context = probeNodeImpl.getContext();
        SourceSection sourceSection = context.getInstrumentedSourceSection();
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Lazy update for %s%n", sourceSection);
        }
        RootNode rootNode = probeNodeImpl.getRootNode();
        Node instrumentedNode = probeNodeImpl.findWrapper().getDelegateNode();
        Set<Class<?>> providedTags = this.getProvidedTags(rootNode);
        ProbeNode.EventChainNode root = null;
        ProbeNode.EventChainNode parent = null;
        for (EventBinding<?> binding : this.executionBindings) {
            ProbeNode.EventChainNode next;
            if (!binding.isInstrumentedFull(providedTags, rootNode, instrumentedNode, sourceSection)) continue;
            if (TRACE) {
                InstrumentationHandler.trace("  Found binding %s, %s%n", binding.getFilter(), binding.getElement());
            }
            if ((next = probeNodeImpl.createEventChainCallback(binding)) == null) continue;
            if (root == null) {
                root = next;
            } else {
                assert (parent != null);
                parent.setNext(next);
            }
            parent = next;
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Lazy updated for %s%n", sourceSection);
        }
        return root;
    }

    private static void notifySourceBindingsLoaded(Collection<EventBinding<?>> bindings, Source source) {
        for (EventBinding<?> binding : bindings) {
            InstrumentationHandler.notifySourceBindingLoaded(binding, source);
        }
    }

    private static void notifySourceBindingLoaded(EventBinding<?> binding, Source source) {
        if (!binding.isDisposed() && binding.isInstrumentedSource(source)) {
            try {
                ((LoadSourceListener)binding.getElement()).onLoad(new LoadSourceEvent(source));
            }
            catch (Throwable t) {
                if (binding.isLanguageBinding()) {
                    throw t;
                }
                ProbeNode.exceptionEventForClientInstrument(binding, "onLoad", t);
            }
        }
    }

    static void notifySourceSectionLoaded(EventBinding<?> binding, Node node, SourceSection section) {
        LoadSourceSectionListener listener = (LoadSourceSectionListener)binding.getElement();
        try {
            listener.onLoad(new LoadSourceSectionEvent(section, node));
        }
        catch (Throwable t) {
            if (binding.isLanguageBinding()) {
                throw t;
            }
            ProbeNode.exceptionEventForClientInstrument(binding, "onLoad", t);
        }
    }

    private void addInstrumenter(Object key, AbstractInstrumenter instrumenter) throws AssertionError {
        AbstractInstrumenter previousKey = this.instrumenterMap.putIfAbsent(key, instrumenter);
        if (previousKey != null) {
            throw new AssertionError((Object)"Instrumenter already present.");
        }
        instrumenter.initialize();
    }

    private static Collection<EventBinding<?>> filterBindingsForInstrumenter(Collection<EventBinding<?>> bindings, AbstractInstrumenter instrumenter) {
        if (bindings.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList newBindings = new ArrayList();
        for (EventBinding<?> binding : bindings) {
            if (binding.getInstrumenter() != instrumenter) continue;
            newBindings.add(binding);
        }
        return newBindings;
    }

    private void insertWrapper(Node instrumentableNode, SourceSection sourceSection) {
        InstrumentableFactory.WrapperNode wrapper;
        Node node = instrumentableNode;
        Node parent = node.getParent();
        if (parent instanceof InstrumentableFactory.WrapperNode) {
            InstrumentationHandler.invalidateWrapperImpl((InstrumentableFactory.WrapperNode)((Object)parent), node);
            return;
        }
        ProbeNode probe = new ProbeNode(this, sourceSection);
        try {
            Class<? extends InstrumentableFactory<? extends Node>> factory = null;
            for (Class<?> currentClass = instrumentableNode.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                Instrumentable instrumentable = currentClass.getAnnotation(Instrumentable.class);
                if (instrumentable == null) continue;
                factory = instrumentable.factory();
                break;
            }
            if (factory == null) {
                if (TRACE) {
                    InstrumentationHandler.trace("No wrapper inserted for %s, section %s. Not annotated with @Instrumentable.%n", node, sourceSection);
                }
                return;
            }
            if (TRACE) {
                InstrumentationHandler.trace("Insert wrapper for %s, section %s%n", node, sourceSection);
            }
            wrapper = ((InstrumentableFactory)factory.newInstance()).createWrapper(instrumentableNode, probe);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create wrapper node. ", e);
        }
        if (!(wrapper instanceof Node)) {
            throw new IllegalStateException(String.format("Implementation of %s must be a subclass of %s.", InstrumentableFactory.WrapperNode.class.getSimpleName(), Node.class.getSimpleName()));
        }
        Node wrapperNode = (Node)((Object)wrapper);
        if (wrapperNode.getParent() != null) {
            throw new IllegalStateException(String.format("Instance of provided %s is already adopted by another parent.", InstrumentableFactory.WrapperNode.class.getSimpleName()));
        }
        if (parent == null) {
            throw new IllegalStateException(String.format("Instance of instrumentable %s is not adopted by a parent.", Node.class.getSimpleName()));
        }
        if (!NodeUtil.isReplacementSafe(parent, node, wrapperNode)) {
            throw new IllegalStateException(String.format("WrapperNode implementation %s cannot be safely replaced in parent node class %s.", wrapperNode.getClass().getName(), parent.getClass().getName()));
        }
        node.replace(wrapperNode, "Insert instrumentation wrapper node.");
    }

    private <T extends ExecutionEventNodeFactory> EventBinding<T> attachFactory(AbstractInstrumenter instrumenter, SourceSectionFilter filter, T factory) {
        return this.addExecutionBinding(new EventBinding<T>(instrumenter, filter, factory, true));
    }

    private <T extends ExecutionEventListener> EventBinding<T> attachListener(AbstractInstrumenter instrumenter, SourceSectionFilter filter, T listener) {
        return this.addExecutionBinding(new EventBinding<T>(instrumenter, filter, listener, true));
    }

    private <T> EventBinding<T> attachSourceListener(AbstractInstrumenter abstractInstrumenter, SourceSectionFilter filter, T listener, boolean notifyLoaded) {
        return this.addSourceBinding(new EventBinding<T>(abstractInstrumenter, filter, listener, false), notifyLoaded);
    }

    private <T> EventBinding<T> attachSourceSectionListener(AbstractInstrumenter abstractInstrumenter, SourceSectionFilter filter, T listener, boolean notifyLoaded) {
        return this.addSourceSectionBinding(new EventBinding<T>(abstractInstrumenter, filter, listener, false), notifyLoaded);
    }

    Set<Class<?>> getProvidedTags(Class<?> language) {
        Set<Class<Object>> tags = this.cachedProvidedTags.get(language);
        if (tags == null) {
            ProvidedTags languageTags = language.getAnnotation(ProvidedTags.class);
            List languageTagsList = languageTags != null ? Arrays.asList(languageTags.value()) : Collections.emptyList();
            tags = Collections.unmodifiableSet(new HashSet(languageTagsList));
            this.cachedProvidedTags.put(language, tags);
        }
        return tags;
    }

    Set<Class<?>> getProvidedTags(RootNode root) {
        Class<? extends TruffleLanguage> language = AccessorInstrumentHandler.nodesAccess().findLanguage(root);
        if (language != null) {
            return this.getProvidedTags(language);
        }
        return Collections.emptySet();
    }

    private static boolean isInstrumentableNode(Node node, SourceSection sourceSection) {
        return !(node instanceof InstrumentableFactory.WrapperNode) && !(node instanceof RootNode) && sourceSection != null;
    }

    private static void trace(String message, Object ... args) {
        PrintStream out = System.out;
        out.printf(message, args);
    }

    private void visitRoot(RootNode root, AbstractNodeVisitor visitor) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Visit root %s for %s%n", root.toString(), visitor);
        }
        visitor.root = root;
        visitor.providedTags = this.getProvidedTags(root);
        if (visitor.shouldVisit()) {
            if (TRACE) {
                InstrumentationHandler.trace("BEGIN: Traverse root %s for %s%n", root.toString(), visitor);
            }
            root.accept(visitor);
            if (TRACE) {
                InstrumentationHandler.trace("END: Traverse root %s for %s%n", root.toString(), visitor);
            }
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Visited root %s for %s%n", root.toString(), visitor);
        }
    }

    static void removeWrapper(ProbeNode node) {
        if (TRACE) {
            InstrumentationHandler.trace("Remove wrapper for %s%n", node.getContext().getInstrumentedSourceSection());
        }
        InstrumentableFactory.WrapperNode wrapperNode = node.findWrapper();
        ((Node)((Object)wrapperNode)).replace(wrapperNode.getDelegateNode());
    }

    private static void invalidateWrapper(Node node) {
        Node parent = node.getParent();
        if (!(parent instanceof InstrumentableFactory.WrapperNode)) {
            return;
        }
        InstrumentationHandler.invalidateWrapperImpl((InstrumentableFactory.WrapperNode)((Object)parent), node);
    }

    private static void invalidateWrapperImpl(InstrumentableFactory.WrapperNode parent, Node node) {
        ProbeNode probeNode = parent.getProbeNode();
        if (TRACE) {
            SourceSection section = probeNode.getContext().getInstrumentedSourceSection();
            InstrumentationHandler.trace("Invalidate wrapper for %s, section %s %n", node, section);
        }
        if (probeNode != null) {
            probeNode.invalidate();
        }
    }

    static boolean hasTagImpl(Set<Class<?>> providedTags, Node node, Class<?> tag) {
        if (providedTags.contains(tag)) {
            return AccessorInstrumentHandler.nodesAccess().isTaggedWith(node, tag);
        }
        return false;
    }

    static Instrumentable getInstrumentable(Node node) {
        Instrumentable instrumentable = node.getClass().getAnnotation(Instrumentable.class);
        if (instrumentable != null && !(node instanceof InstrumentableFactory.WrapperNode)) {
            return instrumentable;
        }
        return null;
    }

    private <T> T lookup(Object key, Class<T> type) {
        AbstractInstrumenter value = this.instrumenterMap.get(key);
        return value == null ? null : (T)value.lookup(this, type);
    }

    private static void traceFilterCheck(String result, Set<Class<?>> providedTags, EventBinding<?> binding, Node node, SourceSection sourceSection) {
        Set<Class<?>> tags = binding.getFilter().getReferencedTags();
        HashSet containedTags = new HashSet();
        for (Class<?> tag : tags) {
            if (!InstrumentationHandler.hasTagImpl(providedTags, node, tag)) continue;
            containedTags.add(tag);
        }
        InstrumentationHandler.trace("  Filter %4s %s section:%s tags:%s%n", result, binding.getFilter(), sourceSection, containedTags);
    }

    static final class AccessorInstrumentHandler
    extends Accessor {
        AccessorInstrumentHandler() {
        }

        static Accessor.Nodes nodesAccess() {
            return ACCESSOR.nodes();
        }

        static Accessor.LanguageSupport langAccess() {
            return ACCESSOR.languageSupport();
        }

        static Accessor.EngineSupport engineAccess() {
            return ACCESSOR.engineSupport();
        }

        protected CallTarget parse(Class<? extends TruffleLanguage> languageClass, Source code, Node context, String ... argumentNames) {
            TruffleLanguage<?> truffleLanguage = this.engineSupport().findLanguageImpl(null, languageClass, code.getMimeType());
            return AccessorInstrumentHandler.langAccess().parse(truffleLanguage, code, context, argumentNames);
        }

        @Override
        protected Accessor.InstrumentSupport instrumentSupport() {
            return new InstrumentImpl();
        }

        static final class InstrumentImpl
        extends Accessor.InstrumentSupport {
            InstrumentImpl() {
            }

            @Override
            public Object createInstrumentationHandler(Object vm, OutputStream out, OutputStream err, InputStream in) {
                return new InstrumentationHandler(vm, out, err, in);
            }

            @Override
            public void addInstrument(Object instrumentationHandler, Object key, Class<?> instrumentClass) {
                ((InstrumentationHandler)instrumentationHandler).addInstrument(key, instrumentClass);
            }

            @Override
            public void disposeInstrument(Object instrumentationHandler, Object key, boolean cleanupRequired) {
                ((InstrumentationHandler)instrumentationHandler).disposeInstrumenter(key, cleanupRequired);
            }

            @Override
            public void collectEnvServices(Set<Object> collectTo, Object vm, TruffleLanguage<?> impl, TruffleLanguage.Env env) {
                InstrumentationHandler instrumentationHandler = (InstrumentationHandler)AccessorInstrumentHandler.engineAccess().getInstrumentationHandler(vm);
                Instrumenter instrumenter = instrumentationHandler.forLanguage(env, impl);
                collectTo.add(instrumenter);
            }

            @Override
            public <T> T getInstrumentationHandlerService(Object vm, Object key, Class<T> type) {
                InstrumentationHandler instrumentationHandler = (InstrumentationHandler)vm;
                return (T)instrumentationHandler.lookup(key, type);
            }

            @Override
            public void detachLanguageFromInstrumentation(Object vm, TruffleLanguage.Env env) {
                InstrumentationHandler instrumentationHandler = (InstrumentationHandler)AccessorInstrumentHandler.engineAccess().getInstrumentationHandler(vm);
                instrumentationHandler.disposeInstrumenter(AccessorInstrumentHandler.langAccess().findContext(env), false);
            }

            @Override
            public void onFirstExecution(RootNode rootNode) {
                Object instrumentationHandler = AccessorInstrumentHandler.engineAccess().getInstrumentationHandler(null);
                if (instrumentationHandler != null) {
                    ((InstrumentationHandler)instrumentationHandler).onFirstExecution(rootNode);
                }
            }

            @Override
            public void onLoad(RootNode rootNode) {
                Object instrumentationHandler = AccessorInstrumentHandler.engineAccess().getInstrumentationHandler(null);
                if (instrumentationHandler != null) {
                    ((InstrumentationHandler)instrumentationHandler).onLoad(rootNode);
                }
            }
        }
    }

    private static final class WeakAsyncList<T>
    extends AbstractAsyncCollection<WeakReference<T>, T> {
        WeakAsyncList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected WeakReference<T> wrap(T element) {
            return new WeakReference<T>(element);
        }

        @Override
        protected T unwrap(WeakReference<T> element) {
            return element.get();
        }
    }

    private static final class EventBindingList
    extends AbstractAsyncCollection<EventBinding<?>, EventBinding<?>> {
        EventBindingList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected EventBinding<?> wrap(EventBinding<?> element) {
            return element;
        }

        @Override
        protected EventBinding<?> unwrap(EventBinding<?> element) {
            if (element.isDisposed()) {
                return null;
            }
            return element;
        }
    }

    private static abstract class AbstractAsyncCollection<T, R>
    extends AbstractCollection<R> {
        private volatile AtomicReferenceArray<T> values;
        private int nextInsertionIndex;

        AbstractAsyncCollection(int initialCapacity) {
            if (initialCapacity <= 0) {
                throw new IllegalArgumentException("Invalid initial capacity " + initialCapacity);
            }
            this.values = new AtomicReferenceArray(initialCapacity);
        }

        @Override
        public final synchronized boolean add(R reference) {
            T wrappedElement = this.wrap(reference);
            if (wrappedElement == null) {
                throw new NullPointerException();
            }
            if (this.nextInsertionIndex >= this.values.length()) {
                this.compact();
            }
            this.values.set(this.nextInsertionIndex++, wrappedElement);
            return true;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean isEmpty() {
            return this.values.get(0) == null;
        }

        protected abstract T wrap(R var1);

        protected abstract R unwrap(T var1);

        private void compact() {
            T ref;
            T ref2;
            AtomicReferenceArray<T> localValues = this.values;
            int liveElements = 0;
            for (int i = 0; i < localValues.length() && (ref2 = localValues.get(i)) != null; ++i) {
                if (this.unwrap(ref2) == null) continue;
                ++liveElements;
            }
            AtomicReferenceArray<T> newValues = new AtomicReferenceArray<T>(Math.max(liveElements * 2, 8));
            int index = 0;
            for (int i = 0; i < localValues.length() && (ref = localValues.get(i)) != null; ++i) {
                if (this.unwrap(ref) == null) continue;
                newValues.set(index++, ref);
            }
            this.nextInsertionIndex = index;
            this.values = newValues;
        }

        @Override
        public Iterator<R> iterator() {
            return new Iterator<R>(){
                private final AtomicReferenceArray<T> values;
                private int index;
                private R queuedNext;
                {
                    this.values = values;
                }

                @Override
                public boolean hasNext() {
                    Object next = this.queuedNext;
                    if (next == null) {
                        this.queuedNext = next = this.queueNext();
                    }
                    return next != null;
                }

                private R queueNext() {
                    Object localValue;
                    Object alive;
                    int localIndex = this.index;
                    AtomicReferenceArray array = this.values;
                    do {
                        if (localIndex >= array.length()) {
                            return null;
                        }
                        localValue = array.get(localIndex);
                        if (localValue == null) {
                            return null;
                        }
                        ++localIndex;
                    } while ((alive = this.unwrap(localValue)) == null);
                    this.index = localIndex;
                    return alive;
                }

                @Override
                public R next() {
                    Object next = this.queuedNext;
                    if (next == null && (next = this.queueNext()) == null) {
                        throw new NoSuchElementException();
                    }
                    this.queuedNext = null;
                    return next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    abstract class AbstractInstrumenter
    extends Instrumenter {
        AbstractInstrumenter() {
        }

        abstract void initialize();

        abstract void dispose();

        abstract <T> T lookup(InstrumentationHandler var1, Class<T> var2);

        void disposeBinding(EventBinding<?> binding) {
            InstrumentationHandler.this.disposeBinding(binding);
        }

        abstract boolean isInstrumentableRoot(RootNode var1);

        abstract boolean isInstrumentableSource(Source var1);

        final Set<Class<?>> queryTagsImpl(Node node, Class<?> onlyLanguage) {
            SourceSection sourceSection = node.getSourceSection();
            if (!InstrumentationHandler.isInstrumentableNode(node, sourceSection)) {
                return Collections.emptySet();
            }
            RootNode root = node.getRootNode();
            if (root == null) {
                return Collections.emptySet();
            }
            Class<? extends TruffleLanguage> language = AccessorInstrumentHandler.nodesAccess().findLanguage(root);
            if (onlyLanguage != null && language != onlyLanguage) {
                throw new IllegalArgumentException("The language instrumenter cannot query tags of nodes of other languages.");
            }
            Set<Class<?>> providedTags = InstrumentationHandler.this.getProvidedTags(root);
            if (providedTags.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet tags = new HashSet();
            for (Class<?> providedTag : providedTags) {
                if (!InstrumentationHandler.hasTagImpl(providedTags, node, providedTag)) continue;
                tags.add(providedTag);
            }
            return Collections.unmodifiableSet(tags);
        }

        @Override
        public final <T extends ExecutionEventNodeFactory> EventBinding<T> attachFactory(SourceSectionFilter filter, T factory) {
            this.verifyFilter(filter);
            return InstrumentationHandler.this.attachFactory(this, filter, factory);
        }

        @Override
        public final <T extends ExecutionEventListener> EventBinding<T> attachListener(SourceSectionFilter filter, T listener) {
            this.verifyFilter(filter);
            return InstrumentationHandler.this.attachListener(this, filter, listener);
        }

        @Override
        public <T extends LoadSourceListener> EventBinding<T> attachLoadSourceListener(SourceSectionFilter filter, T listener, boolean notifyLoaded) {
            this.verifySourceOnly(filter);
            this.verifyFilter(filter);
            return InstrumentationHandler.this.attachSourceListener(this, filter, listener, notifyLoaded);
        }

        @Override
        public <T extends LoadSourceSectionListener> EventBinding<T> attachLoadSourceSectionListener(SourceSectionFilter filter, T listener, boolean notifyLoaded) {
            this.verifyFilter(filter);
            return InstrumentationHandler.this.attachSourceSectionListener(this, filter, listener, notifyLoaded);
        }

        private void verifySourceOnly(SourceSectionFilter filter) {
            if (!filter.isSourceOnly()) {
                throw new IllegalArgumentException(String.format("The attached filter %s uses filters that require source sections to verifiy. Source listeners can only use filter critera based on Source objects like mimeTypeIs or sourceIs.", filter));
            }
        }

        abstract void verifyFilter(SourceSectionFilter var1);
    }

    final class LanguageClientInstrumenter<T>
    extends AbstractInstrumenter {
        private final TruffleLanguage.Env env;
        private final TruffleLanguage<T> language;

        LanguageClientInstrumenter(TruffleLanguage<T> language, TruffleLanguage.Env env) {
            this.language = language;
            this.env = env;
        }

        @Override
        boolean isInstrumentableSource(Source source) {
            String mimeType = source.getMimeType();
            if (mimeType == null) {
                return false;
            }
            return this.env.isMimeTypeSupported(mimeType);
        }

        @Override
        boolean isInstrumentableRoot(RootNode node) {
            return AccessorInstrumentHandler.nodesAccess().findLanguage(node.getRootNode()) == this.language.getClass();
        }

        @Override
        public Set<Class<?>> queryTags(Node node) {
            return this.queryTagsImpl(node, this.language.getClass());
        }

        @Override
        void verifyFilter(SourceSectionFilter filter) {
            Set<Class<?>> referencedTags;
            Set<Class<Class<?>>> providedTags = InstrumentationHandler.this.getProvidedTags(this.language.getClass());
            if (!providedTags.containsAll(referencedTags = filter.getReferencedTags())) {
                HashSet missingTags = new HashSet(referencedTags);
                missingTags.removeAll(providedTags);
                LinkedHashSet allTags = new LinkedHashSet(providedTags);
                allTags.addAll(missingTags);
                StringBuilder builder = new StringBuilder("{");
                String sep = "";
                for (Class clazz : allTags) {
                    builder.append(sep);
                    builder.append(clazz.getSimpleName());
                    sep = ", ";
                }
                builder.append("}");
                throw new IllegalArgumentException(String.format("The attached filter %s references the following tags %s which are not declared as provided by the language. To fix this annotate the language class %s with @%s(%s).", filter, missingTags, this.language.getClass().getName(), ProvidedTags.class.getSimpleName(), builder));
            }
        }

        @Override
        void initialize() {
        }

        @Override
        void dispose() {
        }

        <S> S lookup(InstrumentationHandler handler, Class<S> type) {
            return null;
        }
    }

    final class InstrumentClientInstrumenter
    extends AbstractInstrumenter {
        private final Class<?> instrumentClass;
        private Object[] services;
        private TruffleInstrument instrument;
        private final TruffleInstrument.Env env;

        InstrumentClientInstrumenter(Object vm, Class<?> instrumentClass, OutputStream out, OutputStream err, InputStream in) {
            this.instrumentClass = instrumentClass;
            this.env = new TruffleInstrument.Env(vm, this, out, err, in);
        }

        @Override
        boolean isInstrumentableSource(Source source) {
            return true;
        }

        @Override
        boolean isInstrumentableRoot(RootNode rootNode) {
            return true;
        }

        @Override
        public Set<Class<?>> queryTags(Node node) {
            return this.queryTagsImpl(node, null);
        }

        @Override
        void verifyFilter(SourceSectionFilter filter) {
        }

        Class<?> getInstrumentClass() {
            return this.instrumentClass;
        }

        TruffleInstrument.Env getEnv() {
            return this.env;
        }

        @Override
        void initialize() {
            if (TRACE) {
                InstrumentationHandler.trace("Initialize instrument %s class %s %n", new Object[]{this.instrument, this.instrumentClass});
            }
            assert (this.instrument == null);
            try {
                this.instrument = (TruffleInstrument)this.instrumentClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.failInstrumentInitialization(String.format("Failed to create new instrumenter class %s", this.instrumentClass.getName()), e);
                return;
            }
            try {
                this.services = this.env.onCreate(this.instrument);
            }
            catch (Throwable e) {
                this.failInstrumentInitialization(String.format("Failed calling onCreate of instrument class %s", this.instrumentClass.getName()), e);
                return;
            }
            if (TRACE) {
                InstrumentationHandler.trace("Initialized instrument %s class %s %n", new Object[]{this.instrument, this.instrumentClass});
            }
        }

        private void failInstrumentInitialization(String message, Throwable t) {
            Exception exception = new Exception(message, t);
            PrintStream stream = new PrintStream(this.env.err());
            exception.printStackTrace(stream);
        }

        boolean isInitialized() {
            return this.instrument != null;
        }

        TruffleInstrument getInstrument() {
            return this.instrument;
        }

        @Override
        void dispose() {
            this.instrument.onDispose(this.env);
        }

        @Override
        <T> T lookup(InstrumentationHandler handler, Class<T> type) {
            if (this.services != null) {
                for (Object service : this.services) {
                    if (!type.isInstance(service)) continue;
                    return type.cast(service);
                }
            }
            return null;
        }
    }

    private final class NotifyLoadedListenerVisitor
    extends AbstractBindingsVisitor {
        NotifyLoadedListenerVisitor(Collection<EventBinding<?>> bindings) {
            super(bindings, true);
        }

        @Override
        protected void visitInstrumented(EventBinding<?> binding, Node node, SourceSection section) {
            InstrumentationHandler.notifySourceSectionLoaded(binding, node, section);
        }
    }

    private final class NotifyLoadedWithBindingVisitor
    extends AbstractBindingVisitor {
        NotifyLoadedWithBindingVisitor(EventBinding<?> binding) {
            super(binding);
        }

        @Override
        protected void visitInstrumented(Node node, SourceSection section) {
            InstrumentationHandler.notifySourceSectionLoaded(this.binding, node, section);
        }
    }

    private final class DisposeWrappersWithBindingVisitor
    extends AbstractBindingsVisitor {
        DisposeWrappersWithBindingVisitor(Collection<EventBinding<?>> bindings) {
            super(bindings, false);
        }

        @Override
        protected void visitInstrumented(EventBinding<?> binding, Node node, SourceSection section) {
            InstrumentationHandler.invalidateWrapper(node);
        }
    }

    private final class InsertWrappersVisitor
    extends AbstractBindingsVisitor {
        InsertWrappersVisitor(Collection<EventBinding<?>> bindings) {
            super(bindings, false);
        }

        @Override
        protected void visitInstrumented(EventBinding<?> binding, Node node, SourceSection section) {
            InstrumentationHandler.this.insertWrapper(node, section);
        }
    }

    private final class DisposeWrappersVisitor
    extends AbstractBindingVisitor {
        DisposeWrappersVisitor(EventBinding<?> binding) {
            super(binding);
        }

        @Override
        protected void visitInstrumented(Node node, SourceSection section) {
            InstrumentationHandler.invalidateWrapper(node);
        }
    }

    private final class InsertWrappersWithBindingVisitor
    extends AbstractBindingVisitor {
        InsertWrappersWithBindingVisitor(EventBinding<?> filter) {
            super(filter);
        }

        @Override
        protected void visitInstrumented(Node node, SourceSection section) {
            InstrumentationHandler.this.insertWrapper(node, section);
        }
    }

    private abstract class AbstractBindingsVisitor
    extends AbstractNodeVisitor {
        private final Collection<EventBinding<?>> bindings;
        private final boolean visitForEachBinding;

        AbstractBindingsVisitor(Collection<EventBinding<?>> bindings, boolean visitForEachBinding) {
            this.bindings = bindings;
            this.visitForEachBinding = visitForEachBinding;
        }

        @Override
        boolean shouldVisit() {
            if (this.bindings.isEmpty()) {
                return false;
            }
            RootNode localRoot = this.root;
            if (localRoot == null) {
                return false;
            }
            SourceSection sourceSection = localRoot.getSourceSection();
            for (EventBinding<?> binding : this.bindings) {
                if (!binding.isInstrumentedRoot(this.providedTags, localRoot, sourceSection)) continue;
                return true;
            }
            return false;
        }

        @Override
        public final boolean visit(Node node) {
            SourceSection sourceSection = node.getSourceSection();
            if (InstrumentationHandler.isInstrumentableNode(node, sourceSection)) {
                for (EventBinding<?> binding : this.bindings) {
                    if (binding.isInstrumentedFull(this.providedTags, this.root, node, sourceSection)) {
                        if (TRACE) {
                            InstrumentationHandler.traceFilterCheck("hit", this.providedTags, binding, node, sourceSection);
                        }
                        this.visitInstrumented(binding, node, sourceSection);
                        if (this.visitForEachBinding) continue;
                        break;
                    }
                    if (!TRACE) continue;
                    InstrumentationHandler.traceFilterCheck("miss", this.providedTags, binding, node, sourceSection);
                }
            }
            return true;
        }

        protected abstract void visitInstrumented(EventBinding<?> var1, Node var2, SourceSection var3);
    }

    private abstract class AbstractBindingVisitor
    extends AbstractNodeVisitor {
        protected final EventBinding<?> binding;

        AbstractBindingVisitor(EventBinding<?> binding) {
            this.binding = binding;
        }

        @Override
        boolean shouldVisit() {
            return this.binding.isInstrumentedRoot(this.providedTags, this.root, this.root.getSourceSection());
        }

        @Override
        public final boolean visit(Node node) {
            SourceSection sourceSection = node.getSourceSection();
            if (InstrumentationHandler.isInstrumentableNode(node, sourceSection)) {
                if (this.binding.isInstrumentedLeaf(this.providedTags, node, sourceSection)) {
                    if (TRACE) {
                        InstrumentationHandler.traceFilterCheck("hit", this.providedTags, this.binding, node, sourceSection);
                    }
                    this.visitInstrumented(node, sourceSection);
                } else if (TRACE) {
                    InstrumentationHandler.traceFilterCheck("miss", this.providedTags, this.binding, node, sourceSection);
                }
            }
            return true;
        }

        protected abstract void visitInstrumented(Node var1, SourceSection var2);
    }

    private static abstract class AbstractNodeVisitor
    implements NodeVisitor {
        RootNode root;
        Set<Class<?>> providedTags;

        private AbstractNodeVisitor() {
        }

        abstract boolean shouldVisit();
    }
}

