/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ast.NilImplicitParseNode;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.NonLocalControlFlowParseNode;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;

public class BreakParseNode
extends ParseNode
implements NonLocalControlFlowParseNode {
    private final ParseNode valueNode;

    public BreakParseNode(SourceIndexLength position, ParseNode valueNode) {
        super(position, valueNode != null && valueNode.containsVariableAssignment());
        assert (valueNode != null) : "valueNode is not null";
        this.valueNode = valueNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.BREAKNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitBreakNode(this);
    }

    @Override
    public ParseNode getValueNode() {
        return this.valueNode;
    }

    @Override
    public boolean hasValue() {
        return this.valueNode != NilImplicitParseNode.NIL;
    }

    @Override
    public List<ParseNode> childNodes() {
        return BreakParseNode.createList(this.valueNode);
    }
}

