/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;

final class EConstant
extends AExpression {
    EConstant(Location location, Object constant) {
        super(location);
        this.constant = constant;
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw new IllegalStateException("Illegal tree structure.");
    }

    @Override
    void analyze(Locals locals) {
        if (this.constant instanceof String) {
            this.actual = Definition.STRING_TYPE;
        } else if (this.constant instanceof Double) {
            this.actual = Definition.DOUBLE_TYPE;
        } else if (this.constant instanceof Float) {
            this.actual = Definition.FLOAT_TYPE;
        } else if (this.constant instanceof Long) {
            this.actual = Definition.LONG_TYPE;
        } else if (this.constant instanceof Integer) {
            this.actual = Definition.INT_TYPE;
        } else if (this.constant instanceof Character) {
            this.actual = Definition.CHAR_TYPE;
        } else if (this.constant instanceof Short) {
            this.actual = Definition.SHORT_TYPE;
        } else if (this.constant instanceof Byte) {
            this.actual = Definition.BYTE_TYPE;
        } else if (this.constant instanceof Boolean) {
            this.actual = Definition.BOOLEAN_TYPE;
        } else {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        Definition.Sort sort = this.actual.sort;
        switch (sort) {
            case STRING: {
                writer.push((String)this.constant);
                break;
            }
            case DOUBLE: {
                writer.push((Double)this.constant);
                break;
            }
            case FLOAT: {
                writer.push(((Float)this.constant).floatValue());
                break;
            }
            case LONG: {
                writer.push((Long)this.constant);
                break;
            }
            case INT: {
                writer.push((Integer)this.constant);
                break;
            }
            case CHAR: {
                writer.push(((Character)this.constant).charValue());
                break;
            }
            case SHORT: {
                writer.push(((Short)this.constant).shortValue());
                break;
            }
            case BYTE: {
                writer.push(((Byte)this.constant).byteValue());
                break;
            }
            case BOOL: {
                writer.push((Boolean)this.constant);
                break;
            }
            default: {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    @Override
    public String toString() {
        String c = this.constant.toString();
        if (this.constant instanceof String) {
            c = "'" + c + "'";
        }
        return this.singleLineToString(this.constant.getClass().getSimpleName(), c);
    }
}

