/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.jgoodies.looks.common;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.pushingpixels.substance.internal.contrib.jgoodies.looks.common.ShadowPopupBorder;

public final class ShadowPopup
extends Popup {
    private static final int MAX_CACHE_SIZE = 5;
    private static List cache;
    private static final Border SHADOW_BORDER;
    private static final int SHADOW_SIZE = 5;
    private static boolean canSnapshot;
    private Component owner;
    private Component contents;
    private int x;
    private int y;
    private Popup popup;
    private Border oldBorder;
    private boolean oldOpaque;
    private Container heavyWeightContainer;
    private static final Point point;
    private static final Rectangle rect;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Popup getInstance(Component owner, Component contents, int x, int y, Popup delegate) {
        Class<ShadowPopup> clazz = ShadowPopup.class;
        synchronized (ShadowPopup.class) {
            if (cache == null) {
                cache = new ArrayList(5);
            }
            ShadowPopup result = cache.size() > 0 ? (ShadowPopup)cache.remove(0) : new ShadowPopup();
            // ** MonitorExit[var6_5] (shouldn't be in output)
            result.reset(owner, contents, x, y, delegate);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recycle(ShadowPopup popup) {
        Class<ShadowPopup> clazz = ShadowPopup.class;
        synchronized (ShadowPopup.class) {
            if (cache.size() < 5) {
                cache.add(popup);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean canSnapshot() {
        return canSnapshot;
    }

    @Override
    public void hide() {
        if (this.contents == null) {
            return;
        }
        JComponent parent = (JComponent)this.contents.getParent();
        this.popup.hide();
        if (parent.getBorder() == SHADOW_BORDER) {
            parent.setBorder(this.oldBorder);
            parent.setOpaque(this.oldOpaque);
            this.oldBorder = null;
            if (this.heavyWeightContainer != null) {
                parent.putClientProperty("jgoodies.hShadowBg", null);
                parent.putClientProperty("jgoodies.vShadowBg", null);
                this.heavyWeightContainer = null;
            }
        }
        this.owner = null;
        this.contents = null;
        this.popup = null;
        ShadowPopup.recycle(this);
    }

    @Override
    public void show() {
        if (this.heavyWeightContainer != null) {
            this.snapshot();
        }
        this.popup.show();
    }

    private void reset(Component owner, Component contents, int x, int y, Popup popup) {
        this.owner = owner;
        this.contents = contents;
        this.popup = popup;
        this.x = x;
        this.y = y;
        if (owner instanceof JComboBox) {
            return;
        }
        for (Container p = contents.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof JWindow) && !(p instanceof Panel)) continue;
            p.setBackground(contents.getBackground());
            this.heavyWeightContainer = p;
            break;
        }
        JComponent parent = (JComponent)contents.getParent();
        this.oldOpaque = parent.isOpaque();
        this.oldBorder = parent.getBorder();
        parent.setOpaque(false);
        parent.setBorder(SHADOW_BORDER);
        if (this.heavyWeightContainer != null) {
            this.heavyWeightContainer.setSize(this.heavyWeightContainer.getPreferredSize());
        } else {
            parent.setSize(parent.getPreferredSize());
        }
    }

    private void snapshot() {
        try {
            boolean doubleBuffered;
            JComponent c;
            Graphics2D g;
            Robot robot = new Robot();
            Dimension size = this.heavyWeightContainer.getPreferredSize();
            int width = size.width;
            int height = size.height;
            rect.setBounds(this.x, this.y + height - 5, width, 5);
            BufferedImage hShadowBg = robot.createScreenCapture(rect);
            rect.setBounds(this.x + width - 5, this.y, 5, height - 5);
            BufferedImage vShadowBg = robot.createScreenCapture(rect);
            JComponent parent = (JComponent)this.contents.getParent();
            parent.putClientProperty("jgoodies.hShadowBg", hShadowBg);
            parent.putClientProperty("jgoodies.vShadowBg", vShadowBg);
            Container layeredPane = this.getLayeredPane();
            if (layeredPane == null) {
                return;
            }
            int layeredPaneWidth = layeredPane.getWidth();
            int layeredPaneHeight = layeredPane.getHeight();
            ShadowPopup.point.x = this.x;
            ShadowPopup.point.y = this.y;
            SwingUtilities.convertPointFromScreen(point, layeredPane);
            ShadowPopup.rect.x = ShadowPopup.point.x;
            ShadowPopup.rect.y = ShadowPopup.point.y + height - 5;
            ShadowPopup.rect.width = width;
            ShadowPopup.rect.height = 5;
            if (ShadowPopup.rect.x + ShadowPopup.rect.width > layeredPaneWidth) {
                ShadowPopup.rect.width = layeredPaneWidth - ShadowPopup.rect.x;
            }
            if (ShadowPopup.rect.y + ShadowPopup.rect.height > layeredPaneHeight) {
                ShadowPopup.rect.height = layeredPaneHeight - ShadowPopup.rect.y;
            }
            if (!rect.isEmpty()) {
                g = hShadowBg.createGraphics();
                ((Graphics)g).translate(-ShadowPopup.rect.x, -ShadowPopup.rect.y);
                g.setClip(rect);
                if (layeredPane instanceof JComponent) {
                    c = (JComponent)layeredPane;
                    doubleBuffered = c.isDoubleBuffered();
                    c.setDoubleBuffered(false);
                    c.paintAll(g);
                    c.setDoubleBuffered(doubleBuffered);
                } else {
                    layeredPane.paintAll(g);
                }
                g.dispose();
            }
            ShadowPopup.rect.x = ShadowPopup.point.x + width - 5;
            ShadowPopup.rect.y = ShadowPopup.point.y;
            ShadowPopup.rect.width = 5;
            ShadowPopup.rect.height = height - 5;
            if (ShadowPopup.rect.x + ShadowPopup.rect.width > layeredPaneWidth) {
                ShadowPopup.rect.width = layeredPaneWidth - ShadowPopup.rect.x;
            }
            if (ShadowPopup.rect.y + ShadowPopup.rect.height > layeredPaneHeight) {
                ShadowPopup.rect.height = layeredPaneHeight - ShadowPopup.rect.y;
            }
            if (!rect.isEmpty()) {
                g = vShadowBg.createGraphics();
                ((Graphics)g).translate(-ShadowPopup.rect.x, -ShadowPopup.rect.y);
                g.setClip(rect);
                if (layeredPane instanceof JComponent) {
                    c = (JComponent)layeredPane;
                    doubleBuffered = c.isDoubleBuffered();
                    c.setDoubleBuffered(false);
                    c.paintAll(g);
                    c.setDoubleBuffered(doubleBuffered);
                } else {
                    layeredPane.paintAll(g);
                }
                g.dispose();
            }
        }
        catch (AWTException e) {
            canSnapshot = false;
        }
        catch (SecurityException e) {
            canSnapshot = false;
        }
    }

    private Container getLayeredPane() {
        Container parent = null;
        if (this.owner != null) {
            parent = this.owner instanceof Container ? (Container)this.owner : this.owner.getParent();
        }
        for (Container p = parent; p != null; p = p.getParent()) {
            if (p instanceof JRootPane) {
                if (p.getParent() instanceof JInternalFrame) continue;
                parent = ((JRootPane)p).getLayeredPane();
                continue;
            }
            if (p instanceof Window) {
                if (parent != null) break;
                parent = p;
                break;
            }
            if (p instanceof JApplet) break;
        }
        return parent;
    }

    static {
        SHADOW_BORDER = ShadowPopupBorder.getInstance();
        canSnapshot = true;
        point = new Point();
        rect = new Rectangle();
    }
}

