/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectLocalComponentProvider;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.scala.ScalaBasePlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugins.ear.EarPlugin;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.EclipseWtpPlugin;
import org.gradle.plugins.ide.eclipse.GenerateEclipseClasspath;
import org.gradle.plugins.ide.eclipse.GenerateEclipseJdt;
import org.gradle.plugins.ide.eclipse.GenerateEclipseProject;
import org.gradle.plugins.ide.eclipse.internal.AfterEvaluateHelper;
import org.gradle.plugins.ide.eclipse.internal.EclipseNameDeduper;
import org.gradle.plugins.ide.eclipse.internal.LinkedResourcesCreator;
import org.gradle.plugins.ide.eclipse.model.BuildCommand;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseJdt;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseProject;
import org.gradle.plugins.ide.eclipse.model.Link;
import org.gradle.plugins.ide.internal.IdePlugin;

public class EclipsePlugin
extends IdePlugin {
    public static final String ECLIPSE_TASK_NAME = "eclipse";
    public static final String ECLIPSE_PROJECT_TASK_NAME = "eclipseProject";
    public static final String ECLIPSE_CP_TASK_NAME = "eclipseClasspath";
    public static final String ECLIPSE_JDT_TASK_NAME = "eclipseJdt";
    private final Instantiator instantiator;
    private static final Predicate<Project> HAS_ECLIPSE_PLUGIN = new Predicate<Project>(){

        public boolean apply(Project project) {
            return project.getPlugins().hasPlugin(EclipsePlugin.class);
        }
    };

    @Inject
    public EclipsePlugin(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    @Override
    protected String getLifecycleTaskName() {
        return ECLIPSE_TASK_NAME;
    }

    @Override
    protected void onApply(Project project) {
        this.getLifecycleTask().setDescription("Generates all Eclipse files.");
        this.getCleanTask().setDescription("Cleans all Eclipse files.");
        EclipseModel model = (EclipseModel)project.getExtensions().create(ECLIPSE_TASK_NAME, EclipseModel.class, new Object[0]);
        this.configureEclipseProject(project, model);
        this.configureEclipseJdt(project, model);
        this.configureEclipseClasspath(project, model);
        this.postProcess(ECLIPSE_TASK_NAME, (Action<? super Gradle>)new Action<Gradle>(){

            public void execute(Gradle gradle) {
                EclipsePlugin.this.performPostEvaluationActions();
            }
        });
        this.applyEclipseWtpPluginOnWebProjects(project);
    }

    public void performPostEvaluationActions() {
        this.makeSureProjectNamesAreUnique();
        this.registerEclipseArtifacts();
    }

    private void makeSureProjectNamesAreUnique() {
        new EclipseNameDeduper().configureRoot(this.project.getRootProject());
    }

    private void registerEclipseArtifacts() {
        Set projectsWithEclipse = Sets.filter((Set)this.project.getRootProject().getAllprojects(), HAS_ECLIPSE_PLUGIN);
        for (Project project : projectsWithEclipse) {
            EclipsePlugin.registerEclipseArtifacts(project);
        }
    }

    private static void registerEclipseArtifacts(Project project) {
        ProjectLocalComponentProvider projectComponentProvider = (ProjectLocalComponentProvider)((ProjectInternal)project).getServices().get(ProjectLocalComponentProvider.class);
        ProjectComponentIdentifier projectId = DefaultProjectComponentIdentifier.newProjectId((Project)project);
        String projectName = ((EclipseModel)project.getExtensions().getByType(EclipseModel.class)).getProject().getName();
        projectComponentProvider.registerAdditionalArtifact(projectId, EclipsePlugin.createArtifact("project", projectId, projectName, project));
        projectComponentProvider.registerAdditionalArtifact(projectId, EclipsePlugin.createArtifact("classpath", projectId, projectName, project));
    }

    private static LocalComponentArtifactMetadata createArtifact(String extension, ProjectComponentIdentifier projectId, String projectName, Project project) {
        File projectFile = new File(project.getProjectDir(), "." + extension);
        Task byName = project.getTasks().getByName(ECLIPSE_PROJECT_TASK_NAME);
        String type = "eclipse." + extension;
        DefaultPublishArtifact publishArtifact = new DefaultPublishArtifact(projectName, extension, type, null, null, projectFile, new Object[]{byName});
        return new PublishArtifactLocalArtifactMetadata((ComponentIdentifier)projectId, (PublishArtifact)publishArtifact);
    }

    private void configureEclipseProject(final Project project, final EclipseModel model) {
        EclipsePlugin.maybeAddTask(project, this, ECLIPSE_PROJECT_TASK_NAME, GenerateEclipseProject.class, new Action<GenerateEclipseProject>(){

            public void execute(GenerateEclipseProject task) {
                final EclipseProject projectModel = task.getProjectModel();
                task.setDescription("Generates the Eclipse project file.");
                task.setInputFile(project.file((Object)".project"));
                task.setOutputFile(project.file((Object)".project"));
                model.setProject(projectModel);
                projectModel.setName(project.getName());
                final ConventionMapping convention = ((IConventionAware)projectModel).getConventionMapping();
                convention.map("comment", (Callable)new Callable<String>(){

                    @Override
                    public String call() {
                        return project.getDescription();
                    }
                });
                project.getPlugins().withType(JavaBasePlugin.class, (Action)new Action<JavaBasePlugin>(){

                    public void execute(JavaBasePlugin javaBasePlugin) {
                        if (!project.getPlugins().hasPlugin(EarPlugin.class)) {
                            projectModel.buildCommand("org.eclipse.jdt.core.javabuilder");
                        }
                        projectModel.natures("org.eclipse.jdt.core.javanature");
                        convention.map("linkedResources", (Callable)new Callable<Set<Link>>(){

                            @Override
                            public Set<Link> call() {
                                return new LinkedResourcesCreator().links(project);
                            }
                        });
                    }
                });
                project.getPlugins().withType(GroovyBasePlugin.class, (Action)new Action<GroovyBasePlugin>(){

                    public void execute(GroovyBasePlugin groovyBasePlugin) {
                        projectModel.getNatures().add(projectModel.getNatures().indexOf("org.eclipse.jdt.core.javanature"), "org.eclipse.jdt.groovy.core.groovyNature");
                    }
                });
                project.getPlugins().withType(ScalaBasePlugin.class, (Action)new Action<ScalaBasePlugin>(){

                    public void execute(ScalaBasePlugin scalaBasePlugin) {
                        projectModel.getBuildCommands().set(Iterables.indexOf(projectModel.getBuildCommands(), (Predicate)new Predicate<BuildCommand>(){

                            public boolean apply(BuildCommand buildCommand) {
                                return buildCommand.getName().equals("org.eclipse.jdt.core.javabuilder");
                            }
                        }), new BuildCommand("org.scala-ide.sdt.core.scalabuilder"));
                        projectModel.getNatures().add(projectModel.getNatures().indexOf("org.eclipse.jdt.core.javanature"), "org.scala-ide.sdt.core.scalanature");
                    }
                });
            }
        });
    }

    private void configureEclipseClasspath(final Project project, final EclipseModel model) {
        model.setClasspath((EclipseClasspath)this.instantiator.newInstance(EclipseClasspath.class, new Object[]{project}));
        ((IConventionAware)model.getClasspath()).getConventionMapping().map("defaultOutputDir", (Callable)new Callable<File>(){

            @Override
            public File call() {
                return new File(project.getProjectDir(), "bin");
            }
        });
        final EclipsePlugin eclipsePlugin = this;
        project.getPlugins().withType(JavaBasePlugin.class, (Action)new Action<JavaBasePlugin>(){

            public void execute(JavaBasePlugin javaBasePlugin) {
                EclipsePlugin.maybeAddTask(project, eclipsePlugin, EclipsePlugin.ECLIPSE_CP_TASK_NAME, GenerateEclipseClasspath.class, (Action)new Action<GenerateEclipseClasspath>(){

                    public void execute(final GenerateEclipseClasspath task) {
                        task.setDescription("Generates the Eclipse classpath file.");
                        task.setInputFile(project.file((Object)".classpath"));
                        task.setOutputFile(project.file((Object)".classpath"));
                        task.setClasspath(model.getClasspath());
                        task.getClasspath().setFile(new XmlFileContentMerger(task.getXmlTransformer()));
                        task.getClasspath().setSourceSets((Iterable<SourceSet>)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets());
                        AfterEvaluateHelper.afterEvaluateOrExecute(project, new Action<Project>(){

                            public void execute(Project p) {
                                LinkedHashSet containers = Sets.newLinkedHashSet();
                                containers.add("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/" + model.getJdt().getJavaRuntimeName() + "/");
                                containers.addAll(task.getClasspath().getContainers());
                                task.getClasspath().setContainers(containers);
                            }
                        });
                        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

                            public void execute(JavaPlugin javaPlugin) {
                                EclipsePlugin.configureJavaClasspath(project, task);
                            }
                        });
                        EclipsePlugin.configureScalaDependencies(project, task);
                    }
                });
            }
        });
    }

    private static void configureJavaClasspath(final Project project, GenerateEclipseClasspath task) {
        task.getClasspath().setPlusConfigurations(Lists.newArrayList((Object[])new Configuration[]{project.getConfigurations().getByName("testRuntime"), project.getConfigurations().getByName("compileClasspath"), project.getConfigurations().getByName("testCompileClasspath")}));
        ((IConventionAware)task.getClasspath()).getConventionMapping().map("classFolders", (Callable)new Callable<List<File>>(){

            @Override
            public List<File> call() {
                SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
                return Lists.newArrayList((Iterable)Iterables.concat((Iterable)((SourceSet)sourceSets.getByName("main")).getOutput().getDirs(), (Iterable)((SourceSet)sourceSets.getByName("test")).getOutput().getDirs()));
            }
        });
        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        task.dependsOn(new Object[]{((SourceSet)sourceSets.getByName("main")).getOutput().getDirs()});
        task.dependsOn(new Object[]{((SourceSet)sourceSets.getByName("test")).getOutput().getDirs()});
    }

    private static void configureScalaDependencies(final Project project, final GenerateEclipseClasspath task) {
        project.getPlugins().withType(ScalaBasePlugin.class, (Action)new Action<ScalaBasePlugin>(){

            public void execute(ScalaBasePlugin scalaBasePlugin) {
                task.getClasspath().containers("org.scala-ide.sdt.launching.SCALA_CONTAINER");
                project.getGradle().addBuildListener((BuildListener)new BuildAdapter(){

                    public void projectsEvaluated(Gradle gradle) {
                        final ArrayList provided = Lists.newArrayList((Object[])new String[]{"scala-library", "scala-swing", "scala-dbc"});
                        Predicate<Dependency> dependencyInProvided = new Predicate<Dependency>(){

                            public boolean apply(Dependency dependency) {
                                return provided.contains(dependency.getName());
                            }
                        };
                        ArrayList dependencies = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)Iterables.transform(task.getClasspath().getPlusConfigurations(), (Function)new Function<Configuration, Iterable<Dependency>>(){

                            public Iterable<Dependency> apply(Configuration config) {
                                return config.getAllDependencies();
                            }
                        })), (Predicate)dependencyInProvided));
                        if (!dependencies.isEmpty()) {
                            task.getClasspath().getMinusConfigurations().add(project.getConfigurations().detachedConfiguration(dependencies.toArray(new Dependency[0])));
                        }
                    }
                });
            }
        });
    }

    private void configureEclipseJdt(final Project project, final EclipseModel model) {
        final EclipsePlugin eclipsePlugin = this;
        project.getPlugins().withType(JavaBasePlugin.class, (Action)new Action<JavaBasePlugin>(){

            public void execute(JavaBasePlugin javaBasePlugin) {
                EclipsePlugin.maybeAddTask(project, eclipsePlugin, EclipsePlugin.ECLIPSE_JDT_TASK_NAME, GenerateEclipseJdt.class, (Action)new Action<GenerateEclipseJdt>(){

                    public void execute(GenerateEclipseJdt task) {
                        task.setDescription("Generates the Eclipse JDT settings file.");
                        task.setOutputFile(project.file((Object)".settings/org.eclipse.jdt.core.prefs"));
                        task.setInputFile(project.file((Object)".settings/org.eclipse.jdt.core.prefs"));
                        EclipseJdt jdt = task.getJdt();
                        model.setJdt(jdt);
                        ConventionMapping conventionMapping = ((IConventionAware)jdt).getConventionMapping();
                        conventionMapping.map("sourceCompatibility", (Callable)new Callable<JavaVersion>(){

                            @Override
                            public JavaVersion call() {
                                return ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceCompatibility();
                            }
                        });
                        conventionMapping.map("targetCompatibility", (Callable)new Callable<JavaVersion>(){

                            @Override
                            public JavaVersion call() {
                                return ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getTargetCompatibility();
                            }
                        });
                        conventionMapping.map("javaRuntimeName", (Callable)new Callable<String>(){

                            @Override
                            public String call() {
                                return "JavaSE-" + ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getTargetCompatibility();
                            }
                        });
                    }
                });
            }
        });
    }

    private void applyEclipseWtpPluginOnWebProjects(Project project) {
        Action<Plugin<Project>> action = this.createActionApplyingEclipseWtpPlugin();
        project.getPlugins().withType(WarPlugin.class, action);
        project.getPlugins().withType(EarPlugin.class, action);
    }

    private Action<Plugin<Project>> createActionApplyingEclipseWtpPlugin() {
        return new Action<Plugin<Project>>(){

            public void execute(Plugin<Project> plugin) {
                EclipsePlugin.this.project.getPluginManager().apply(EclipseWtpPlugin.class);
            }
        };
    }

    private static <T extends Task> void maybeAddTask(Project project, IdePlugin plugin, String taskName, Class<T> taskType, Action<T> action) {
        TaskContainer tasks = project.getTasks();
        if (tasks.findByName(taskName) != null) {
            return;
        }
        Task task = tasks.create(taskName, taskType);
        action.execute((Object)task);
        plugin.addWorker(task);
    }
}

