/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jetty;

import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.plugins.jetty.internal.ConsoleScanner;
import org.gradle.api.plugins.jetty.internal.JettyPluginServer;
import org.gradle.api.plugins.jetty.internal.JettyPluginWebAppContext;
import org.gradle.api.plugins.jetty.internal.Monitor;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractJettyRunTask
extends ConventionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJettyRunTask.class);
    private Iterable<File> additionalRuntimeJars = new ArrayList<File>();
    private JettyPluginServer server;
    private JettyPluginWebAppContext webAppConfig;
    private String contextPath;
    private File webDefaultXml;
    private File overrideWebXml;
    private int scanIntervalSeconds;
    protected String reload;
    private File jettyConfig;
    private Integer stopPort;
    private String stopKey;
    private boolean daemon;
    private Integer httpPort;
    private Connector[] connectors;
    private UserRealm[] userRealms;
    private RequestLog requestLog;
    private Scanner scanner = new Scanner();
    protected List<Scanner.Listener> scannerListeners;
    protected Thread consoleScanner;
    public static final String PORT_SYSPROPERTY = "jetty.port";

    public abstract void validateConfiguration();

    public abstract void configureScanner();

    public abstract void applyJettyXml() throws Exception;

    public abstract JettyPluginServer createServer() throws Exception;

    public abstract void finishConfigurationBeforeStart() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    protected void start() {
        ClassLoader originalClassloader = Server.class.getClassLoader();
        ArrayList<File> additionalClasspath = new ArrayList<File>();
        for (File additionalRuntimeJar : this.getAdditionalRuntimeJars()) {
            additionalClasspath.add(additionalRuntimeJar);
        }
        URLClassLoader jettyClassloader = new URLClassLoader(new DefaultClassPath(additionalClasspath).getAsURLArray(), originalClassloader);
        try {
            Thread.currentThread().setContextClassLoader(jettyClassloader);
            this.startJetty();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassloader);
        }
    }

    @Internal
    public JettyPluginServer getServer() {
        return this.server;
    }

    public void setServer(JettyPluginServer server) {
        this.server = server;
    }

    public void setScannerListeners(List<Scanner.Listener> listeners) {
        this.scannerListeners = new ArrayList<Scanner.Listener>(listeners);
    }

    @Internal
    public List<Scanner.Listener> getScannerListeners() {
        return this.scannerListeners;
    }

    @Internal
    public Scanner getScanner() {
        return this.scanner;
    }

    public void startJetty() {
        LOGGER.info("Configuring Jetty for " + this.getProject());
        this.validateConfiguration();
        this.startJettyInternal();
    }

    public void startJettyInternal() {
        ProgressLoggerFactory progressLoggerFactory = (ProgressLoggerFactory)this.getServices().get(ProgressLoggerFactory.class);
        ProgressLogger progressLogger = progressLoggerFactory.newOperation(AbstractJettyRunTask.class).start("Start Jetty server", "Starting Jetty");
        try {
            this.setServer(this.createServer());
            this.applyJettyXml();
            JettyPluginServer plugin = this.getServer();
            Object[] configuredConnectors = this.getConnectors();
            plugin.setConnectors(configuredConnectors);
            Object[] connectors = plugin.getConnectors();
            if (connectors == null || connectors.length == 0) {
                configuredConnectors = new Object[]{plugin.createDefaultConnector(this.getHttpPort())};
                plugin.setConnectors(configuredConnectors);
            }
            if (this.getRequestLog() != null) {
                this.getServer().setRequestLog(this.getRequestLog());
            }
            this.getServer().configureHandlers();
            this.configureWebApplication();
            this.getServer().addWebApplication(this.webAppConfig);
            Object[] configuredRealms = this.getUserRealms();
            for (int i = 0; configuredRealms != null && i < configuredRealms.length; ++i) {
                LOGGER.debug(configuredRealms[i].getClass().getName() + ": " + configuredRealms[i].toString());
            }
            plugin.setUserRealms(configuredRealms);
            this.finishConfigurationBeforeStart();
            this.server.start();
            if (this.getStopPort() != null && this.getStopPort() > 0 && this.getStopKey() != null) {
                Monitor monitor = new Monitor(this.getStopPort(), this.getStopKey(), (Server)this.server.getProxiedObject());
                monitor.start();
            }
            if (this.daemon) {
                return;
            }
            this.configureScanner();
            this.startScanner();
            this.startConsoleScanner();
        }
        catch (Exception e) {
            throw new GradleException("Could not start the Jetty server.", (Throwable)e);
        }
        finally {
            progressLogger.completed();
        }
        progressLogger = progressLoggerFactory.newOperation(AbstractJettyRunTask.class).start("Run Jetty at http://localhost:" + this.getHttpPort() + "/" + this.getContextPath(), "Running at http://localhost:" + this.getHttpPort() + "/" + this.getContextPath());
        try {
            this.server.join();
        }
        catch (Exception e) {
            throw new GradleException("Failed to wait for the Jetty server to stop.", (Throwable)e);
        }
        finally {
            progressLogger.completed();
        }
    }

    public abstract void restartWebApp(boolean var1) throws Exception;

    public void configureWebApplication() throws Exception {
        if (this.webAppConfig == null) {
            this.webAppConfig = new JettyPluginWebAppContext();
        }
        this.webAppConfig.setContextPath(this.getContextPath().startsWith("/") ? this.getContextPath() : "/" + this.getContextPath());
        if (this.getTemporaryDir() != null) {
            this.webAppConfig.setTempDirectory(this.getTemporaryDir());
        }
        if (this.getWebDefaultXml() != null) {
            this.webAppConfig.setDefaultsDescriptor(this.getWebDefaultXml().getCanonicalPath());
        }
        if (this.getOverrideWebXml() != null) {
            this.webAppConfig.setOverrideDescriptor(this.getOverrideWebXml().getCanonicalPath());
        }
        LinkedHashSet<String> systemClasses = new LinkedHashSet<String>(Arrays.asList(this.webAppConfig.getSystemClasses()));
        systemClasses.remove("org.apache.commons.logging.");
        systemClasses.remove("org.apache.log4j.");
        this.webAppConfig.setSystemClasses(systemClasses.toArray(new String[0]));
        this.webAppConfig.setParentLoaderPriority(false);
        LOGGER.info("Context path = " + this.webAppConfig.getContextPath());
        LOGGER.info("Tmp directory =  determined at runtime");
        LOGGER.info("Web defaults = " + (this.webAppConfig.getDefaultsDescriptor() == null ? " jetty default" : this.webAppConfig.getDefaultsDescriptor()));
        LOGGER.info("Web overrides = " + (this.webAppConfig.getOverrideDescriptor() == null ? " none" : this.webAppConfig.getOverrideDescriptor()));
    }

    private void startScanner() {
        Iterator<Scanner.Listener> itor;
        if (this.getScanIntervalSeconds() <= 0) {
            return;
        }
        if ("manual".equalsIgnoreCase(this.reload)) {
            LOGGER.warn("scanIntervalSeconds is set to " + this.scanIntervalSeconds + " but will be IGNORED due to manual reloading");
            return;
        }
        this.scanner.setReportExistingFilesOnStartup(false);
        this.scanner.setScanInterval(this.getScanIntervalSeconds());
        this.scanner.setRecursive(true);
        List<Scanner.Listener> listeners = this.getScannerListeners();
        Iterator<Scanner.Listener> iterator = itor = listeners == null ? null : listeners.iterator();
        while (itor != null && itor.hasNext()) {
            this.scanner.addListener(itor.next());
        }
        LOGGER.info("Starting scanner at interval of " + this.getScanIntervalSeconds() + " seconds.");
        this.scanner.start();
    }

    protected void startConsoleScanner() {
        if ("manual".equalsIgnoreCase(this.reload)) {
            LOGGER.info("Console reloading is ENABLED. Hit ENTER on the console to restart the context.");
            this.consoleScanner = new ConsoleScanner(this);
            this.consoleScanner.start();
        }
    }

    public File findJettyWebXmlFile(File webInfDir) {
        if (webInfDir == null) {
            return null;
        }
        if (!webInfDir.exists()) {
            return null;
        }
        File f = new File(webInfDir, "jetty-web.xml");
        if (f.exists()) {
            return f;
        }
        f = new File(webInfDir, "web-jetty.xml");
        if (f.exists()) {
            return f;
        }
        f = new File(webInfDir, "jetty6-web.xml");
        if (f.exists()) {
            return f;
        }
        return null;
    }

    @InputFile
    @Optional
    public File getWebDefaultXml() {
        return this.webDefaultXml;
    }

    public void setWebDefaultXml(File webDefaultXml) {
        this.webDefaultXml = webDefaultXml;
    }

    @InputFile
    @Optional
    public File getOverrideWebXml() {
        return this.overrideWebXml;
    }

    public void setOverrideWebXml(File overrideWebXml) {
        this.overrideWebXml = overrideWebXml;
    }

    @Internal
    public int getScanIntervalSeconds() {
        return this.scanIntervalSeconds;
    }

    public void setScanIntervalSeconds(int scanIntervalSeconds) {
        this.scanIntervalSeconds = scanIntervalSeconds;
    }

    @Internal
    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @Internal
    public JettyPluginWebAppContext getWebAppConfig() {
        return this.webAppConfig;
    }

    public void setWebAppConfig(JettyPluginWebAppContext webAppConfig) {
        this.webAppConfig = webAppConfig;
    }

    @Internal
    public String getReload() {
        return this.reload;
    }

    public void setReload(String reload) {
        this.reload = reload;
    }

    @InputFile
    @Optional
    public File getJettyConfig() {
        return this.jettyConfig;
    }

    public void setJettyConfig(File jettyConfig) {
        this.jettyConfig = jettyConfig;
    }

    @Internal
    public Integer getStopPort() {
        return this.stopPort;
    }

    public void setStopPort(Integer stopPort) {
        this.stopPort = stopPort;
    }

    @Internal
    public String getStopKey() {
        return this.stopKey;
    }

    public void setStopKey(String stopKey) {
        this.stopKey = stopKey;
    }

    @Internal
    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    @Internal
    public Integer getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
    }

    @Internal
    public Connector[] getConnectors() {
        return this.connectors;
    }

    public void setConnectors(Connector[] connectors) {
        this.connectors = connectors;
    }

    @Internal
    public UserRealm[] getUserRealms() {
        return this.userRealms;
    }

    public void setUserRealms(UserRealm[] userRealms) {
        this.userRealms = userRealms;
    }

    @Internal
    public RequestLog getRequestLog() {
        return this.requestLog;
    }

    public void setRequestLog(RequestLog requestLog) {
        this.requestLog = requestLog;
    }

    @Classpath
    public Iterable<File> getAdditionalRuntimeJars() {
        return this.additionalRuntimeJars;
    }

    public void setAdditionalRuntimeJars(Iterable<File> additionalRuntimeJars) {
        this.additionalRuntimeJars = additionalRuntimeJars;
    }
}

