/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultFileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.DefaultFileDetails;
import org.gradle.api.internal.changedetection.state.DirSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileDetails;
import org.gradle.api.internal.changedetection.state.FileHashSnapshot;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.MissingFileSnapshot;
import org.gradle.api.internal.changedetection.state.MissingFileVisitDetails;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.SnapshotNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.SingletonFileTree;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.api.internal.tasks.execution.TaskOutputsGenerationListener;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileCollectionSnapshotter
implements FileCollectionSnapshotter,
TaskOutputsGenerationListener {
    private final FileHasher hasher;
    private final StringInterner stringInterner;
    private final FileSystem fileSystem;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final Map<String, DefaultFileDetails> rootFiles = new ConcurrentHashMap<String, DefaultFileDetails>();

    public AbstractFileCollectionSnapshotter(FileHasher hasher, StringInterner stringInterner, FileSystem fileSystem, DirectoryFileTreeFactory directoryFileTreeFactory) {
        this.hasher = hasher;
        this.stringInterner = stringInterner;
        this.fileSystem = fileSystem;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
    }

    @Override
    public void beforeTaskOutputsGenerated() {
        this.rootFiles.clear();
    }

    @Override
    public void registerSerializers(SerializerRegistry registry) {
        registry.register(DefaultFileCollectionSnapshot.class, (Serializer)new DefaultFileCollectionSnapshot.SerializerImpl(this.stringInterner));
    }

    @Override
    public FileCollectionSnapshot snapshot(FileCollection input, TaskFilePropertyCompareStrategy compareStrategy, SnapshotNormalizationStrategy snapshotNormalizationStrategy) {
        LinkedList fileTreeElements = Lists.newLinkedList();
        FileCollectionInternal fileCollection = (FileCollectionInternal)input;
        FileCollectionVisitorImpl visitor = new FileCollectionVisitorImpl(fileTreeElements);
        fileCollection.visitRootElements(visitor);
        if (fileTreeElements.isEmpty()) {
            return FileCollectionSnapshot.EMPTY;
        }
        LinkedHashMap snapshots = Maps.newLinkedHashMap();
        for (DefaultFileDetails fileDetails : fileTreeElements) {
            NormalizedFileSnapshot normalizedSnapshot;
            IncrementalFileSnapshot snapshot;
            String absolutePath = fileDetails.path;
            if (snapshots.containsKey(absolutePath)) continue;
            switch (fileDetails.getType()) {
                case Missing: {
                    snapshot = MissingFileSnapshot.getInstance();
                    break;
                }
                case Directory: {
                    snapshot = DirSnapshot.getInstance();
                    break;
                }
                case RegularFile: {
                    snapshot = new FileHashSnapshot(this.hasher.hash(fileDetails.details), fileDetails.details.getLastModified());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if ((normalizedSnapshot = snapshotNormalizationStrategy.getNormalizedSnapshot(fileDetails, snapshot, this.stringInterner)) == null) continue;
            snapshots.put(absolutePath, normalizedSnapshot);
        }
        return new DefaultFileCollectionSnapshot(snapshots, compareStrategy, snapshotNormalizationStrategy.isPathAbsolute());
    }

    private String getPath(File file) {
        return this.stringInterner.intern(file.getAbsolutePath());
    }

    protected void visitTreeOrBackingFile(FileTreeInternal fileTree, List<DefaultFileDetails> fileTreeElements) {
        fileTree.visitTreeOrBackingFile(new FileVisitorImpl(fileTreeElements));
    }

    protected void visitDirectoryTree(DirectoryFileTree directoryTree, List<DefaultFileDetails> fileTreeElements) {
        directoryTree.visit(new FileVisitorImpl(fileTreeElements));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileVisitorImpl
    implements FileVisitor {
        private final List<DefaultFileDetails> fileTreeElements;

        public FileVisitorImpl(List<DefaultFileDetails> fileTreeElements) {
            this.fileTreeElements = fileTreeElements;
        }

        @Override
        public void visitDir(FileVisitDetails dirDetails) {
            this.fileTreeElements.add(new DefaultFileDetails(AbstractFileCollectionSnapshotter.this.getPath(dirDetails.getFile()), FileDetails.FileType.Directory, dirDetails));
        }

        @Override
        public void visitFile(FileVisitDetails fileDetails) {
            this.fileTreeElements.add(new DefaultFileDetails(AbstractFileCollectionSnapshotter.this.getPath(fileDetails.getFile()), FileDetails.FileType.RegularFile, fileDetails));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileCollectionVisitorImpl
    implements FileCollectionVisitor {
        private final List<DefaultFileDetails> fileTreeElements;

        FileCollectionVisitorImpl(List<DefaultFileDetails> fileTreeElements) {
            this.fileTreeElements = fileTreeElements;
        }

        @Override
        public void visitCollection(FileCollectionInternal fileCollection) {
            block4: for (File file : fileCollection) {
                DefaultFileDetails details = (DefaultFileDetails)AbstractFileCollectionSnapshotter.this.rootFiles.get(file.getPath());
                if (details == null) {
                    details = this.calculateDetails(file);
                    AbstractFileCollectionSnapshotter.this.rootFiles.put(details.path, details);
                }
                switch (details.type) {
                    case Missing: 
                    case RegularFile: {
                        this.fileTreeElements.add(details);
                        continue block4;
                    }
                    case Directory: {
                        this.fileTreeElements.add(details);
                        this.visitDirectoryTree(AbstractFileCollectionSnapshotter.this.directoryFileTreeFactory.create(file));
                        continue block4;
                    }
                }
                throw new AssertionError();
            }
        }

        private DefaultFileDetails calculateDetails(File file) {
            String path = AbstractFileCollectionSnapshotter.this.getPath(file);
            if (!file.exists()) {
                return new DefaultFileDetails(path, FileDetails.FileType.Missing, new MissingFileVisitDetails(file));
            }
            if (file.isDirectory()) {
                return new DefaultFileDetails(path, FileDetails.FileType.Directory, new SingletonFileTree.SingletonFileVisitDetails(file, AbstractFileCollectionSnapshotter.this.fileSystem, true));
            }
            return new DefaultFileDetails(path, FileDetails.FileType.RegularFile, new SingletonFileTree.SingletonFileVisitDetails(file, AbstractFileCollectionSnapshotter.this.fileSystem, false));
        }

        @Override
        public void visitTree(FileTreeInternal fileTree) {
            AbstractFileCollectionSnapshotter.this.visitTreeOrBackingFile(fileTree, this.fileTreeElements);
        }

        @Override
        public void visitDirectoryTree(DirectoryFileTree directoryTree) {
            AbstractFileCollectionSnapshotter.this.visitDirectoryTree(directoryTree, this.fileTreeElements);
        }
    }
}

