/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.HashCode;
import java.io.File;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentStore;
import org.gradle.internal.resource.TextResource;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;

public class CachingFileHasher
implements FileHasher {
    private final PersistentIndexedCache<String, FileInfo> cache;
    private final FileHasher delegate;
    private final StringInterner stringInterner;

    public CachingFileHasher(FileHasher delegate, PersistentStore store, StringInterner stringInterner) {
        this.delegate = delegate;
        this.cache = store.createCache("fileHashes", String.class, new FileInfoSerializer());
        this.stringInterner = stringInterner;
    }

    public HashCode hash(TextResource resource) {
        File file = resource.getFile();
        if (file != null) {
            return this.hash(file);
        }
        return this.delegate.hash(resource);
    }

    public HashCode hash(File file) {
        return this.snapshot(file).getHash();
    }

    public HashCode hash(FileTreeElement fileDetails) {
        return this.snapshot(fileDetails).getHash();
    }

    private FileInfo snapshot(File file) {
        return this.snapshot(file, file.length(), file.lastModified());
    }

    private FileInfo snapshot(FileTreeElement file) {
        return this.snapshot(file.getFile(), file.getSize(), file.getLastModified());
    }

    private FileInfo snapshot(File file, long length, long timestamp) {
        String absolutePath = file.getAbsolutePath();
        FileInfo info = this.cache.get(absolutePath);
        if (info != null && length == info.length && timestamp == info.timestamp) {
            return info;
        }
        HashCode hash = this.delegate.hash(file);
        info = new FileInfo(hash, length, timestamp);
        this.cache.put(this.stringInterner.intern(absolutePath), info);
        return info;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileInfoSerializer
    implements Serializer<FileInfo> {
        private final HashCodeSerializer hashCodeSerializer = new HashCodeSerializer();

        private FileInfoSerializer() {
        }

        public FileInfo read(Decoder decoder) throws Exception {
            HashCode hash = this.hashCodeSerializer.read(decoder);
            long timestamp = decoder.readLong();
            long length = decoder.readLong();
            return new FileInfo(hash, length, timestamp);
        }

        public void write(Encoder encoder, FileInfo value) throws Exception {
            this.hashCodeSerializer.write(encoder, value.hash);
            encoder.writeLong(value.timestamp);
            encoder.writeLong(value.length);
        }
    }

    @VisibleForTesting
    static class FileInfo {
        private final HashCode hash;
        private final long timestamp;
        private final long length;

        public FileInfo(HashCode hash, long length, long timestamp) {
            this.hash = hash;
            this.length = length;
            this.timestamp = timestamp;
        }

        public HashCode getHash() {
            return this.hash;
        }
    }
}

