/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;

class MissingFileVisitDetails
implements FileVisitDetails {
    private final File file;
    private final RelativePath relativePath;

    public MissingFileVisitDetails(File file) {
        this.file = file;
        this.relativePath = new RelativePath(true, file.getName());
    }

    public File getFile() {
        return this.file;
    }

    public boolean isDirectory() {
        return false;
    }

    public String getName() {
        return this.file.getName();
    }

    public String getPath() {
        return this.file.getName();
    }

    public RelativePath getRelativePath() {
        return this.relativePath;
    }

    public int getMode() {
        return 0;
    }

    public long getLastModified() {
        return 0L;
    }

    public long getSize() {
        return 0L;
    }

    public InputStream open() {
        throw new UncheckedIOException((Throwable)new FileNotFoundException(this.file.getAbsolutePath()));
    }

    public void copyTo(OutputStream output) {
        throw new UncheckedIOException((Throwable)new FileNotFoundException(this.file.getAbsolutePath()));
    }

    public boolean copyTo(File target) {
        throw new UncheckedIOException((Throwable)new FileNotFoundException(this.file.getAbsolutePath()));
    }

    public void stopVisiting() {
    }
}

