/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Action;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.DefaultPersistentDirectoryStore;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPersistentDirectoryCache
extends DefaultPersistentDirectoryStore
implements ReferencablePersistentCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPersistentDirectoryCache.class);
    private final Properties properties = new Properties();
    private final Action<? super PersistentCache> initAction;
    private final CacheValidator validator;
    private boolean didRebuild;

    public DefaultPersistentDirectoryCache(File dir, String displayName, CacheValidator validator, Map<String, ?> properties, CacheBuilder.LockTarget lockTarget, LockOptions lockOptions, Action<? super PersistentCache> initAction, FileLockManager lockManager, ExecutorFactory executorFactory) {
        super(dir, displayName, lockTarget, lockOptions, lockManager, executorFactory);
        this.validator = validator;
        this.initAction = initAction;
        this.properties.putAll(properties);
    }

    @Override
    protected CacheInitializationAction getInitAction() {
        return new Initializer();
    }

    public Properties getProperties() {
        return this.properties;
    }

    private class Initializer
    implements CacheInitializationAction {
        private Initializer() {
        }

        public boolean requiresInitialization(FileLock lock) {
            if (!DefaultPersistentDirectoryCache.this.didRebuild && DefaultPersistentDirectoryCache.this.validator != null && !DefaultPersistentDirectoryCache.this.validator.isValid()) {
                LOGGER.debug("Invalidating {} as cache validator return false.", (Object)DefaultPersistentDirectoryCache.this);
                return true;
            }
            if (!lock.getUnlockedCleanly()) {
                if (!lock.getState().isInInitialState()) {
                    LOGGER.warn("Invalidating {} as it was not closed cleanly.", (Object)DefaultPersistentDirectoryCache.this);
                }
                return true;
            }
            Properties cachedProperties = GUtil.loadProperties((File)DefaultPersistentDirectoryCache.this.propertiesFile);
            for (Map.Entry<Object, Object> entry : DefaultPersistentDirectoryCache.this.properties.entrySet()) {
                String currentValue;
                String previousValue = cachedProperties.getProperty(entry.getKey().toString());
                if (previousValue.equals(currentValue = entry.getValue().toString())) continue;
                LOGGER.debug("Invalidating {} as cache property {} has changed from {} to {}.", new Object[]{DefaultPersistentDirectoryCache.this, entry.getKey(), previousValue, currentValue});
                return true;
            }
            return false;
        }

        public void initialize(FileLock fileLock) {
            for (File file : DefaultPersistentDirectoryCache.this.getBaseDir().listFiles()) {
                if (fileLock.isLockFile(file) || file.equals(DefaultPersistentDirectoryCache.this.propertiesFile)) continue;
                GFileUtils.forceDelete(file);
            }
            if (DefaultPersistentDirectoryCache.this.initAction != null) {
                DefaultPersistentDirectoryCache.this.initAction.execute((Object)DefaultPersistentDirectoryCache.this);
            }
            GUtil.saveProperties((Properties)DefaultPersistentDirectoryCache.this.properties, (File)DefaultPersistentDirectoryCache.this.propertiesFile);
            DefaultPersistentDirectoryCache.this.didRebuild = true;
        }
    }
}

