/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.buildinit.plugins.internal.TemplateOperation;

public class BuildScriptBuilder {
    private final File target;
    private final List<String> headerLines = new ArrayList<String>();
    private final ListMultimap<String, DepSpec> dependencies = ArrayListMultimap.create();
    private final Map<String, String> plugins = new LinkedHashMap<String, String>();
    private final List<ConfigSpec> config = new ArrayList<ConfigSpec>();

    public BuildScriptBuilder(File target) {
        this.target = target;
    }

    public BuildScriptBuilder fileComment(String comment) {
        this.headerLines.addAll(Splitter.on((String)"\n").splitToList((CharSequence)comment));
        return this;
    }

    public BuildScriptBuilder plugin(String comment, String pluginId) {
        this.plugins.put(pluginId, comment);
        return this;
    }

    public BuildScriptBuilder dependency(String comment, String ... dependencies) {
        this.dependencies.put((Object)"compile", (Object)new DepSpec(comment, Arrays.asList(dependencies)));
        return this;
    }

    public BuildScriptBuilder testCompileDependency(String comment, String ... dependencies) {
        this.dependencies.put((Object)"testCompile", (Object)new DepSpec(comment, Arrays.asList(dependencies)));
        return this;
    }

    public BuildScriptBuilder testRuntimeDependency(String comment, String ... dependencies) {
        this.dependencies.put((Object)"testRuntime", (Object)new DepSpec(comment, Arrays.asList(dependencies)));
        return this;
    }

    public BuildScriptBuilder configuration(String comment, String config) {
        this.config.add(new ConfigSpec(comment, Splitter.on((String)"\n").splitToList((CharSequence)config)));
        return this;
    }

    public TemplateOperation create() {
        return new TemplateOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generate() {
                try (PrintWriter writer = new PrintWriter(new FileWriter(BuildScriptBuilder.this.target));){
                    writer.println("/*");
                    writer.println(" * This build file was generated by the Gradle 'init' task.");
                    if (!BuildScriptBuilder.this.headerLines.isEmpty()) {
                        writer.println(" *");
                        for (String string : BuildScriptBuilder.this.headerLines) {
                            writer.println(" * " + string);
                        }
                    }
                    writer.println(" */");
                    for (Map.Entry entry : BuildScriptBuilder.this.plugins.entrySet()) {
                        writer.println();
                        writer.println("// " + (String)entry.getValue());
                        writer.println("apply plugin: '" + (String)entry.getKey() + "'");
                    }
                    if (!BuildScriptBuilder.this.dependencies.isEmpty()) {
                        writer.println();
                        writer.println("// In this section you declare where to find the dependencies of your project");
                        writer.println("repositories {");
                        writer.println("    // Use jcenter for resolving your dependencies.");
                        writer.println("    // You can declare any Maven/Ivy/file repository here.");
                        writer.println("    jcenter()");
                        writer.println("}");
                        writer.println();
                        writer.println("dependencies {");
                        boolean firstDep = true;
                        for (String config : Arrays.asList("compile", "testCompile", "testRuntime")) {
                            for (DepSpec depSpec : BuildScriptBuilder.this.dependencies.get((Object)config)) {
                                if (firstDep) {
                                    firstDep = false;
                                } else {
                                    writer.println();
                                }
                                writer.println("    // " + depSpec.comment);
                                for (String dep : depSpec.deps) {
                                    writer.println("    " + config + " '" + dep + "'");
                                }
                            }
                        }
                        writer.println("}");
                    }
                    for (ConfigSpec configSpec : BuildScriptBuilder.this.config) {
                        writer.println();
                        writer.println("// " + configSpec.comment);
                        for (String line : configSpec.configLines) {
                            writer.println(line);
                        }
                    }
                    writer.println();
                }
                catch (Exception e) {
                    throw new GradleException("Could not generate file " + BuildScriptBuilder.this.target + ".", (Throwable)e);
                }
            }
        };
    }

    private static class ConfigSpec {
        private final String comment;
        private final List<String> configLines;

        public ConfigSpec(String comment, List<String> configLines) {
            this.comment = comment;
            this.configLines = configLines;
        }
    }

    private static class DepSpec {
        private final String comment;
        private final List<String> deps;

        DepSpec(String comment, List<String> deps) {
            this.comment = comment;
            this.deps = deps;
        }
    }
}

