/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.LanguageLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.ProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;

public class GroovyLibraryProjectInitDescriptor
extends LanguageLibraryProjectInitDescriptor {
    private final DocumentationRegistry documentationRegistry;

    public GroovyLibraryProjectInitDescriptor(TemplateOperationFactory templateOperationFactory, FileResolver fileResolver, TemplateLibraryVersionProvider libraryVersionProvider, ProjectInitDescriptor globalSettingsDescriptor, DocumentationRegistry documentationRegistry) {
        super("groovy", templateOperationFactory, fileResolver, libraryVersionProvider, globalSettingsDescriptor);
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public void generate(BuildInitTestFramework testFramework) {
        this.globalSettingsDescriptor.generate(testFramework);
        BuildScriptBuilder buildScriptBuilder = new BuildScriptBuilder(this.fileResolver.resolve((Object)"build.gradle")).fileComment("This generated file contains a sample Groovy project to get you started.").fileComment("For more details take a look at the Groovy Quickstart chapter in the Gradle").fileComment("user guide available at " + this.documentationRegistry.getDocumentationFor("tutorial_groovy_projects")).plugin("Apply the groovy plugin to add support for Groovy", "groovy").dependency("Use the latest Groovy version for building this library", "org.codehaus.groovy:groovy-all:" + this.libraryVersionProvider.getVersion("groovy")).testCompileDependency("Use the awesome Spock testing and specification framework", "org.spockframework:spock-core:" + this.libraryVersionProvider.getVersion("spock"), "junit:junit:" + this.libraryVersionProvider.getVersion("junit"));
        buildScriptBuilder.create().generate();
        TemplateOperation groovyLibTemplateOperation = this.fromClazzTemplate("groovylibrary/Library.groovy.template", "main");
        TemplateOperation groovyTestTemplateOperation = this.fromClazzTemplate("groovylibrary/LibraryTest.groovy.template", "test");
        this.whenNoSourcesAvailable(groovyLibTemplateOperation, groovyTestTemplateOperation).generate();
    }

    @Override
    public boolean supports(BuildInitTestFramework testFramework) {
        return testFramework == BuildInitTestFramework.SPOCK;
    }
}

