/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.daemon;

import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.operations.BuildOperationWorkerRegistry;
import org.gradle.process.internal.daemon.DaemonForkOptions;
import org.gradle.process.internal.daemon.WorkSpec;
import org.gradle.process.internal.daemon.WorkerDaemon;
import org.gradle.process.internal.daemon.WorkerDaemonAction;
import org.gradle.process.internal.daemon.WorkerDaemonResult;
import org.gradle.process.internal.daemon.WorkerDaemonWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WorkerDaemonClient
implements WorkerDaemon,
Stoppable {
    private final BuildOperationWorkerRegistry buildOperationWorkerRegistry;
    private final DaemonForkOptions forkOptions;
    private final WorkerDaemonWorker workerProcess;

    public WorkerDaemonClient(BuildOperationWorkerRegistry buildOperationWorkerRegistry, DaemonForkOptions forkOptions, WorkerDaemonWorker workerProcess) {
        this.buildOperationWorkerRegistry = buildOperationWorkerRegistry;
        this.forkOptions = forkOptions;
        this.workerProcess = workerProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends WorkSpec> WorkerDaemonResult execute(WorkerDaemonAction<T> action, T spec) {
        BuildOperationWorkerRegistry.Completion workerLease = this.buildOperationWorkerRegistry.getCurrent().operationStart();
        try {
            WorkerDaemonResult workerDaemonResult = this.workerProcess.execute(action, spec);
            return workerDaemonResult;
        }
        finally {
            workerLease.operationFinish();
        }
    }

    public boolean isCompatibleWith(DaemonForkOptions required) {
        return this.forkOptions.isCompatibleWith(required);
    }

    public void stop() {
        this.workerProcess.stop();
    }
}

