/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.light;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

abstract class LightClassReferenceBase
extends LightElement
implements PsiJavaCodeReferenceElement {
    protected final String myText;
    private LightReferenceParameterList myParameterList;

    protected LightClassReferenceBase(@NotNull PsiManager manager, @NotNull String text2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReferenceBase", "<init>"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReferenceBase", "<init>"));
        }
        super(manager, JavaLanguage.INSTANCE);
        this.myText = text2;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult result2 = this.advancedResolve(incompleteCode);
        if (result2 != JavaResolveResult.EMPTY) {
            JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{result2};
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReferenceBase", "multiResolve"));
            }
            return javaResolveResultArray;
        }
        if (JavaResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReferenceBase", "multiResolve"));
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReferenceBase", "processVariants"));
        }
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        if (this.myParameterList == null) {
            this.myParameterList = new LightReferenceParameterList(this.myManager, PsiTypeElement.EMPTY_ARRAY);
        }
        return this.myParameterList;
    }

    @Override
    public String getQualifiedName() {
        PsiClass psiClass = (PsiClass)this.resolve();
        if (psiClass != null) {
            return psiClass.getQualifiedName();
        }
        return null;
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String name2 = this.getQualifiedName();
        if (name2 == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReferenceBase", "getCanonicalText"));
            }
            return "";
        }
        PsiType[] types = this.getTypeParameters();
        if (types.length == 0) {
            String string = name2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReferenceBase", "getCanonicalText"));
            }
            return string;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(name2);
        buf.append('<');
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(types[i].getCanonicalText());
        }
        buf.append('>');
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReferenceBase", "getCanonicalText"));
        }
        return string;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReferenceBase", "bindToElement"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReferenceBase", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceElement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + this.getText();
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return element instanceof PsiClass && this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        if (PsiType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReferenceBase", "getTypeParameters"));
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getQualifier() {
        return null;
    }

    @Override
    public boolean isQualified() {
        return false;
    }
}

