/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.light;

import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.navigation.NavigationItem;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.OriginInfoAwareElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.ElementPresentationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightModifierList;
import org.jetbrains.kotlin.com.intellij.ui.RowIcon;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.PlatformIcons;

public class LightVariableBuilder<T extends LightVariableBuilder>
extends LightElement
implements NavigationItem,
OriginInfoAwareElement,
PsiVariable {
    private final String myName;
    private final PsiType myType;
    private volatile LightModifierList myModifierList;
    private volatile Icon myBaseIcon;
    private String myOriginInfo;

    public LightVariableBuilder(@NotNull String name2, @NotNull String type2, @NotNull PsiElement navigationElement) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        if (navigationElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationElement", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        this(name2, JavaPsiFacade.getElementFactory(navigationElement.getProject()).createTypeFromText(type2, navigationElement), navigationElement);
    }

    public LightVariableBuilder(@NotNull String name2, @NotNull PsiType type2, @NotNull PsiElement navigationElement) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        if (navigationElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationElement", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        this(navigationElement.getManager(), name2, type2, JavaLanguage.INSTANCE);
        this.setNavigationElement(navigationElement);
    }

    public LightVariableBuilder(PsiManager manager, @NotNull String name2, @NotNull PsiType type2, @NotNull Language language) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        super(manager, language);
        this.myBaseIcon = PlatformIcons.VARIABLE_ICON;
        this.myName = name2;
        this.myType = type2;
        this.myModifierList = new LightModifierList(manager);
    }

    @Override
    public String toString() {
        return "LightVariableBuilder:" + this.getName();
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = this.myType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBuilder", "getType"));
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        LightModifierList lightModifierList = this.myModifierList;
        if (lightModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBuilder", "getModifierList"));
        }
        return lightModifierList;
    }

    public T setModifiers(String ... modifiers) {
        this.myModifierList = new LightModifierList(this.getManager(), this.getLanguage(), modifiers);
        return (T)this;
    }

    public T setModifierList(LightModifierList modifierList) {
        this.myModifierList = modifierList;
        return (T)this;
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBuilder", "hasModifierProperty"));
        }
        return this.myModifierList.hasModifierProperty(name2);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBuilder", "getName"));
        }
        return string;
    }

    @Override
    public PsiTypeElement getTypeElement() {
        return null;
    }

    @Override
    public PsiExpression getInitializer() {
        return null;
    }

    @Override
    public boolean hasInitializer() {
        return false;
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public Object computeConstantValue() {
        return null;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBuilder", "setName"));
        }
        throw new UnsupportedOperationException("setName is not implemented yet in com.intellij.psi.impl.light.LightVariableBuilder");
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(this.myBaseIcon, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    public T setBaseIcon(Icon baseIcon) {
        this.myBaseIcon = baseIcon;
        return (T)this;
    }

    @Override
    @Nullable
    public String getOriginInfo() {
        return this.myOriginInfo;
    }

    public void setOriginInfo(@Nullable String originInfo) {
        this.myOriginInfo = originInfo;
    }
}

