/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.scope.processor;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.scope.BaseScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.JavaScopeProcessorEvent;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public abstract class VariablesProcessor
extends BaseScopeProcessor
implements ElementClassHint {
    private boolean myStaticScopeFlag;
    private final boolean myStaticSensitiveFlag;
    private final List<PsiVariable> myResultList;

    public VariablesProcessor(boolean staticSensitive) {
        this(staticSensitive, new SmartList<PsiVariable>());
    }

    public VariablesProcessor(boolean staticSensitive, List<PsiVariable> list2) {
        this.myStaticSensitiveFlag = staticSensitive;
        this.myResultList = list2;
    }

    protected abstract boolean check(PsiVariable var1, ResolveState var2);

    @Override
    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        return kind == ElementClassHint.DeclarationKind.VARIABLE || kind == ElementClassHint.DeclarationKind.FIELD || kind == ElementClassHint.DeclarationKind.ENUM_CONST;
    }

    @Override
    public boolean execute(@NotNull PsiElement pe, @NotNull ResolveState state2) {
        if (pe == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pe", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/VariablesProcessor", "execute"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/VariablesProcessor", "execute"));
        }
        if (pe instanceof PsiVariable) {
            PsiVariable pvar = (PsiVariable)pe;
            if ((!this.myStaticSensitiveFlag || !this.myStaticScopeFlag || pvar.hasModifierProperty("static")) && this.check(pvar, state2)) {
                this.myResultList.add(pvar);
            }
        }
        return true;
    }

    @Override
    public final void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/VariablesProcessor", "handleEvent"));
        }
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStaticScopeFlag = true;
        }
    }

    public int size() {
        return this.myResultList.size();
    }

    public PsiVariable getResult(int i) {
        return this.myResultList.get(i);
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/VariablesProcessor", "getHint"));
        }
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }
}

