/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.inline.InlineAnalyzerExtension;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

public class AnalyzerExtensions {
    @NotNull
    private final BindingTrace trace;

    public AnalyzerExtensions(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/AnalyzerExtensions", "<init>"));
        }
        this.trace = trace;
    }

    public void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        if (bodiesResolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodiesResolveContext", "org/jetbrains/kotlin/resolve/AnalyzerExtensions", "process"));
        }
        for (Map.Entry<KtNamedFunction, SimpleFunctionDescriptor> entry : bodiesResolveContext.getFunctions().entrySet()) {
            KtNamedFunction function2 = entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = entry.getValue();
            for (InlineAnalyzerExtension extension : AnalyzerExtensions.getFunctionExtensions(functionDescriptor)) {
                extension.process(functionDescriptor, function2, this.trace);
            }
        }
        for (Map.Entry<KtTypeParameterListOwnerStub, CallableMemberDescriptor> entry : bodiesResolveContext.getProperties().entrySet()) {
            KtProperty function2 = (KtProperty)entry.getKey();
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            for (InlineAnalyzerExtension extension : AnalyzerExtensions.getPropertyExtensions(propertyDescriptor)) {
                extension.process(propertyDescriptor, function2, this.trace);
            }
        }
    }

    @NotNull
    private static List<InlineAnalyzerExtension> getFunctionExtensions(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/AnalyzerExtensions", "getFunctionExtensions"));
        }
        if (InlineUtil.isInline(functionDescriptor)) {
            List<InlineAnalyzerExtension> list2 = Collections.singletonList(InlineAnalyzerExtension.INSTANCE);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnalyzerExtensions", "getFunctionExtensions"));
            }
            return list2;
        }
        List<InlineAnalyzerExtension> list3 = Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnalyzerExtensions", "getFunctionExtensions"));
        }
        return list3;
    }

    @NotNull
    private static List<InlineAnalyzerExtension> getPropertyExtensions(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/AnalyzerExtensions", "getPropertyExtensions"));
        }
        if (InlineUtil.hasInlineAccessors(propertyDescriptor)) {
            List<InlineAnalyzerExtension> list2 = Collections.singletonList(InlineAnalyzerExtension.INSTANCE);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnalyzerExtensions", "getPropertyExtensions"));
            }
            return list2;
        }
        List<InlineAnalyzerExtension> list3 = Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/AnalyzerExtensions", "getPropertyExtensions"));
        }
        return list3;
    }

    public static interface AnalyzerExtension {
        public void process(@NotNull CallableMemberDescriptor var1, @NotNull KtCallableDeclaration var2, @NotNull BindingTrace var3);
    }
}

