/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;
import org.gjt.sp.util.StandardUtilities;

public class DirectoryProvider
implements DynamicMenuProvider {
    private final String dir;

    public DirectoryProvider(String string) {
        this.dir = string;
    }

    @Override
    public boolean updateEveryTime() {
        return true;
    }

    @Override
    public void update(JMenu jMenu) {
        final View view = GUIUtilities.getView(jMenu);
        String string = this.dir == null ? view.getBuffer().getDirectory() : this.dir;
        JMenuItem jMenuItem = new JMenuItem(string + ':');
        jMenuItem.setActionCommand(string);
        jMenuItem.setIcon(FileCellRenderer.openDirIcon);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jEdit.openFile(view, actionEvent.getActionCommand());
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VFSBrowser.browseDirectory(view, actionEvent.getActionCommand());
            }
        };
        jMenuItem.addActionListener(actionListener2);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        if (this.dir == null && !(view.getBuffer().getVFS() instanceof FileVFS)) {
            jMenuItem = new JMenuItem(jEdit.getProperty("directory.not-local"));
            jMenuItem.setEnabled(false);
            jMenu.add(jMenuItem);
            return;
        }
        File file = new File(string);
        JMenu jMenu2 = jMenu;
        String string2 = jEdit.getProperty("backup.prefix");
        String string3 = jEdit.getProperty("backup.suffix");
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            jMenuItem = new JMenuItem(jEdit.getProperty("directory.no-files"));
            jMenuItem.setEnabled(false);
            jMenu.add(jMenuItem);
        } else {
            int n = jEdit.getIntegerProperty("menu.spillover", 20);
            Arrays.sort(fileArray, new StandardUtilities.StringCompare(true));
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                String string4 = file2.getName();
                if (string4.endsWith(".marks") || string4.startsWith("#") && string4.endsWith("#") || string2.length() != 0 && string4.startsWith(string2) || string3.length() != 0 && string4.endsWith(string3)) continue;
                jMenuItem = new JMenuItem(string4);
                jMenuItem.setActionCommand(file2.getPath());
                jMenuItem.addActionListener(file2.isDirectory() ? actionListener2 : actionListener);
                jMenuItem.setIcon(file2.isDirectory() ? FileCellRenderer.dirIcon : FileCellRenderer.fileIcon);
                if (jMenu2.getItemCount() >= n && i != fileArray.length - 1) {
                    JMenu jMenu3 = new JMenu(jEdit.getProperty("common.more"));
                    jMenu2.add(jMenu3);
                    jMenu2 = jMenu3;
                }
                jMenu2.add(jMenuItem);
            }
        }
    }
}

