/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.JavaObjectMessageResolution;
import com.oracle.truffle.api.interop.java.NullCheckNodeSubNodeGen;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;

abstract class NullCheckNodeSub
extends JavaObjectMessageResolution.NullCheckNode {
    NullCheckNodeSub() {
    }

    public abstract Object executeWithTarget(VirtualFrame var1, Object var2);

    @Specialization
    protected Object accessWithTarget(JavaObject object) {
        return this.access(object);
    }

    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new IS_NULLRootNode(language);
    }

    private static final class IS_NULLRootNode
    extends RootNode {
        @Node.Child
        private NullCheckNodeSub node = NullCheckNodeSubNodeGen.create();

        protected IS_NULLRootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            TruffleObject receiver = ForeignAccess.getReceiver(frame);
            try {
                return this.node.executeWithTarget(frame, receiver);
            }
            catch (UnsupportedSpecializationException e) {
                if (e.getNode() instanceof NullCheckNodeSub) {
                    throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                }
                throw e;
            }
        }
    }
}

